/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.buffers.impl;

import java.nio.ByteBuffer;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.logging.Logger;
import org.hornetq.utils.UTF8Util;
import org.jboss.netty.buffer.ChannelBuffer;

public class ChannelBufferWrapper
implements HornetQBuffer {
    private static final Logger log = Logger.getLogger(ChannelBufferWrapper.class);
    protected ChannelBuffer buffer;

    public ChannelBufferWrapper(ChannelBuffer buffer) {
        this.buffer = buffer;
    }

    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    public SimpleString readNullableSimpleString() {
        byte b = this.buffer.readByte();
        if (b == 0) {
            return null;
        }
        return this.readSimpleStringInternal();
    }

    public String readNullableString() {
        byte b = this.buffer.readByte();
        if (b == 0) {
            return null;
        }
        return this.readStringInternal();
    }

    public SimpleString readSimpleString() {
        return this.readSimpleStringInternal();
    }

    private SimpleString readSimpleStringInternal() {
        int len = this.buffer.readInt();
        byte[] data = new byte[len];
        this.buffer.readBytes(data);
        return new SimpleString(data);
    }

    public String readString() {
        return this.readStringInternal();
    }

    private String readStringInternal() {
        int len = this.buffer.readInt();
        if (len < 9) {
            char[] chars = new char[len];
            for (int i = 0; i < len; ++i) {
                chars[i] = (char)this.buffer.readShort();
            }
            return new String(chars);
        }
        if (len < 4095) {
            return this.readUTF();
        }
        return this.readSimpleStringInternal().toString();
    }

    public String readUTF() {
        return UTF8Util.readUTF(this);
    }

    public void writeBoolean(boolean val) {
        this.buffer.writeByte((byte)(val ? -1 : 0));
    }

    public void writeNullableSimpleString(SimpleString val) {
        if (val == null) {
            this.buffer.writeByte(0);
        } else {
            this.buffer.writeByte(1);
            this.writeSimpleStringInternal(val);
        }
    }

    public void writeNullableString(String val) {
        if (val == null) {
            this.buffer.writeByte(0);
        } else {
            this.buffer.writeByte(1);
            this.writeStringInternal(val);
        }
    }

    public void writeSimpleString(SimpleString val) {
        this.writeSimpleStringInternal(val);
    }

    private void writeSimpleStringInternal(SimpleString val) {
        byte[] data = val.getData();
        this.buffer.writeInt(data.length);
        this.buffer.writeBytes(data);
    }

    public void writeString(String val) {
        this.writeStringInternal(val);
    }

    private void writeStringInternal(String val) {
        int length = val.length();
        this.buffer.writeInt(length);
        if (length < 9) {
            for (int i = 0; i < val.length(); ++i) {
                this.buffer.writeShort((short)val.charAt(i));
            }
        } else if (length < 4095) {
            this.writeUTF(val);
        } else {
            this.writeSimpleStringInternal(new SimpleString(val));
        }
    }

    public void writeUTF(String utf) {
        UTF8Util.saveUTF(this, utf);
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public ChannelBuffer channelBuffer() {
        return this.buffer;
    }

    public void clear() {
        this.buffer.clear();
    }

    public HornetQBuffer copy() {
        return new ChannelBufferWrapper(this.buffer.copy());
    }

    public HornetQBuffer copy(int index, int length) {
        return new ChannelBufferWrapper(this.buffer.copy(index, length));
    }

    public void discardReadBytes() {
        this.buffer.discardReadBytes();
    }

    public HornetQBuffer duplicate() {
        return new ChannelBufferWrapper(this.buffer.duplicate());
    }

    public byte getByte(int index) {
        return this.buffer.getByte(index);
    }

    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst, dstIndex, length);
    }

    public void getBytes(int index, byte[] dst) {
        this.buffer.getBytes(index, dst);
    }

    public void getBytes(int index, ByteBuffer dst) {
        this.buffer.getBytes(index, dst);
    }

    public void getBytes(int index, HornetQBuffer dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst.channelBuffer(), dstIndex, length);
    }

    public void getBytes(int index, HornetQBuffer dst, int length) {
        this.buffer.getBytes(index, dst.channelBuffer(), length);
    }

    public void getBytes(int index, HornetQBuffer dst) {
        this.buffer.getBytes(index, dst.channelBuffer());
    }

    public char getChar(int index) {
        return (char)this.buffer.getShort(index);
    }

    public double getDouble(int index) {
        return Double.longBitsToDouble(this.buffer.getLong(index));
    }

    public float getFloat(int index) {
        return Float.intBitsToFloat(this.buffer.getInt(index));
    }

    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    public short getUnsignedByte(int index) {
        return this.buffer.getUnsignedByte(index);
    }

    public long getUnsignedInt(int index) {
        return this.buffer.getUnsignedInt(index);
    }

    public int getUnsignedShort(int index) {
        return this.buffer.getUnsignedShort(index);
    }

    public void markReaderIndex() {
        this.buffer.markReaderIndex();
    }

    public void markWriterIndex() {
        this.buffer.markWriterIndex();
    }

    public boolean readable() {
        return this.buffer.readable();
    }

    public int readableBytes() {
        return this.buffer.readableBytes();
    }

    public byte readByte() {
        return this.buffer.readByte();
    }

    public void readBytes(byte[] dst, int dstIndex, int length) {
        this.buffer.readBytes(dst, dstIndex, length);
    }

    public void readBytes(byte[] dst) {
        this.buffer.readBytes(dst);
    }

    public void readBytes(ByteBuffer dst) {
        this.buffer.readBytes(dst);
    }

    public void readBytes(HornetQBuffer dst, int dstIndex, int length) {
        this.buffer.readBytes(dst.channelBuffer(), dstIndex, length);
    }

    public void readBytes(HornetQBuffer dst, int length) {
        this.buffer.readBytes(dst.channelBuffer(), length);
    }

    public void readBytes(HornetQBuffer dst) {
        this.buffer.readBytes(dst.channelBuffer());
    }

    public HornetQBuffer readBytes(int length) {
        return new ChannelBufferWrapper(this.buffer.readBytes(length));
    }

    public char readChar() {
        return (char)this.buffer.readShort();
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.buffer.readLong());
    }

    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    public void readerIndex(int readerIndex) {
        this.buffer.readerIndex(readerIndex);
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.buffer.readInt());
    }

    public int readInt() {
        return this.buffer.readInt();
    }

    public long readLong() {
        return this.buffer.readLong();
    }

    public short readShort() {
        return this.buffer.readShort();
    }

    public HornetQBuffer readSlice(int length) {
        return new ChannelBufferWrapper(this.buffer.readSlice(length));
    }

    public short readUnsignedByte() {
        return this.buffer.readUnsignedByte();
    }

    public long readUnsignedInt() {
        return this.buffer.readUnsignedInt();
    }

    public int readUnsignedShort() {
        return this.buffer.readUnsignedShort();
    }

    public void resetReaderIndex() {
        this.buffer.resetReaderIndex();
    }

    public void resetWriterIndex() {
        this.buffer.resetWriterIndex();
    }

    public void setByte(int index, byte value) {
        this.buffer.setByte(index, value);
    }

    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        this.buffer.setBytes(index, src, srcIndex, length);
    }

    public void setBytes(int index, byte[] src) {
        this.buffer.setBytes(index, src);
    }

    public void setBytes(int index, ByteBuffer src) {
        this.buffer.setBytes(index, src);
    }

    public void setBytes(int index, HornetQBuffer src, int srcIndex, int length) {
        this.buffer.setBytes(index, src.channelBuffer(), srcIndex, length);
    }

    public void setBytes(int index, HornetQBuffer src, int length) {
        this.buffer.setBytes(index, src.channelBuffer(), length);
    }

    public void setBytes(int index, HornetQBuffer src) {
        this.buffer.setBytes(index, src.channelBuffer());
    }

    public void setChar(int index, char value) {
        this.buffer.setShort(index, (short)value);
    }

    public void setDouble(int index, double value) {
        this.buffer.setLong(index, Double.doubleToLongBits(value));
    }

    public void setFloat(int index, float value) {
        this.buffer.setInt(index, Float.floatToIntBits(value));
    }

    public void setIndex(int readerIndex, int writerIndex) {
        this.buffer.setIndex(readerIndex, writerIndex);
    }

    public void setInt(int index, int value) {
        this.buffer.setInt(index, value);
    }

    public void setLong(int index, long value) {
        this.buffer.setLong(index, value);
    }

    public void setShort(int index, short value) {
        this.buffer.setShort(index, value);
    }

    public void skipBytes(int length) {
        this.buffer.skipBytes(length);
    }

    public HornetQBuffer slice() {
        return new ChannelBufferWrapper(this.buffer.slice());
    }

    public HornetQBuffer slice(int index, int length) {
        return new ChannelBufferWrapper(this.buffer.slice(index, length));
    }

    public ByteBuffer toByteBuffer() {
        return this.buffer.toByteBuffer();
    }

    public ByteBuffer toByteBuffer(int index, int length) {
        return this.buffer.toByteBuffer(index, length);
    }

    public boolean writable() {
        return this.buffer.writable();
    }

    public int writableBytes() {
        return this.buffer.writableBytes();
    }

    public void writeByte(byte value) {
        this.buffer.writeByte(value);
    }

    public void writeBytes(byte[] src, int srcIndex, int length) {
        this.buffer.writeBytes(src, srcIndex, length);
    }

    public void writeBytes(byte[] src) {
        this.buffer.writeBytes(src);
    }

    public void writeBytes(ByteBuffer src) {
        this.buffer.writeBytes(src);
    }

    public void writeBytes(HornetQBuffer src, int srcIndex, int length) {
        this.buffer.writeBytes(src.channelBuffer(), srcIndex, length);
    }

    public void writeBytes(HornetQBuffer src, int length) {
        this.buffer.writeBytes(src.channelBuffer(), length);
    }

    public void writeChar(char chr) {
        this.buffer.writeShort((short)chr);
    }

    public void writeDouble(double value) {
        this.buffer.writeLong(Double.doubleToLongBits(value));
    }

    public void writeFloat(float value) {
        this.buffer.writeInt(Float.floatToIntBits(value));
    }

    public void writeInt(int value) {
        this.buffer.writeInt(value);
    }

    public void writeLong(long value) {
        this.buffer.writeLong(value);
    }

    public int writerIndex() {
        return this.buffer.writerIndex();
    }

    public void writerIndex(int writerIndex) {
        this.buffer.writerIndex(writerIndex);
    }

    public void writeShort(short value) {
        this.buffer.writeShort(value);
    }
}

