/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.AttachmentKeys;
import org.jboss.ejb.client.EJBClientInvocationContext;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.remoting.ChannelAssociation;
import org.jboss.ejb.client.remoting.ProtocolMessageHandler;
import org.jboss.logging.Logger;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Unmarshaller;
import org.jboss.remoting3.MessageInputStream;

class MethodInvocationResponseHandler
extends ProtocolMessageHandler {
    private static final Logger logger = Logger.getLogger(MethodInvocationResponseHandler.class);
    private final ChannelAssociation channelAssociation;
    private final MarshallerFactory marshallerFactory;

    MethodInvocationResponseHandler(ChannelAssociation channelAssociation, MarshallerFactory marshallerFactory) {
        this.marshallerFactory = marshallerFactory;
        this.channelAssociation = channelAssociation;
    }

    @Override
    protected void processMessage(MessageInputStream messageInputStream) throws IOException {
        if (messageInputStream == null) {
            throw new IllegalArgumentException("Cannot read from null stream");
        }
        DataInputStream input = new DataInputStream(messageInputStream);
        short invocationId = input.readShort();
        EJBReceiverInvocationContext receiverInvocationContext = this.channelAssociation.getEJBReceiverInvocationContext(invocationId);
        EJBClientInvocationContext clientInvocationContext = null;
        if (receiverInvocationContext != null) {
            clientInvocationContext = receiverInvocationContext.getClientInvocationContext();
        }
        MethodInvocationResultProducer resultProducer = new MethodInvocationResultProducer(clientInvocationContext, input);
        this.channelAssociation.resultReady(invocationId, resultProducer);
    }

    private class MethodInvocationResultProducer
    implements EJBReceiverInvocationContext.ResultProducer {
        private final DataInputStream input;
        private final EJBClientInvocationContext clientInvocationContext;

        MethodInvocationResultProducer(EJBClientInvocationContext clientInvocationContext, DataInputStream input) {
            this.input = input;
            this.clientInvocationContext = clientInvocationContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getResult() throws Exception {
            try {
                Unmarshaller unmarshaller = MethodInvocationResponseHandler.this.prepareForUnMarshalling(MethodInvocationResponseHandler.this.marshallerFactory, this.input);
                Object result = unmarshaller.readObject();
                Map<String, Object> attachments = MethodInvocationResponseHandler.this.readAttachments(unmarshaller);
                unmarshaller.finish();
                if (this.clientInvocationContext != null && attachments != null && attachments.containsKey("jboss.ejb.weak.affinity")) {
                    Affinity weakAffinity = (Affinity)attachments.get("jboss.ejb.weak.affinity");
                    this.clientInvocationContext.putAttachment(AttachmentKeys.WEAK_AFFINITY, weakAffinity);
                }
                Object object = result;
                return object;
            }
            finally {
                this.input.close();
            }
        }

        @Override
        public void discardResult() {
        }
    }
}

