/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.model;

import com.sun.codemodel.internal.JAssignmentTarget;
import com.sun.codemodel.internal.JBlock;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.JExpr;
import com.sun.codemodel.internal.JExpression;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JInvocation;
import com.sun.codemodel.internal.JMethod;
import com.sun.codemodel.internal.JStatement;
import com.sun.codemodel.internal.JType;
import com.sun.codemodel.internal.JVar;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.jboss.logging.processor.Annotations;
import org.jboss.logging.processor.Tools;
import org.jboss.logging.processor.intf.model.MessageInterface;
import org.jboss.logging.processor.intf.model.MessageMethod;
import org.jboss.logging.processor.intf.model.Parameter;
import org.jboss.logging.processor.model.ClassModelHelper;
import org.jboss.logging.processor.model.ImplementationClassModel;

final class MessageLoggerImplementor
extends ImplementationClassModel {
    private static final String LOG_FIELD_NAME = "log";
    private static final String FQCN_FIELD_NAME = "FQCN";
    private final boolean useLogging31;

    public MessageLoggerImplementor(MessageInterface messageInterface, boolean useLogging31) {
        super(messageInterface);
        this.useLogging31 = useLogging31;
    }

    public boolean isUseLogging31() {
        return this.useLogging31;
    }

    @Override
    protected JCodeModel generateModel() throws IllegalStateException {
        JFieldVar logVar;
        JFieldVar logger2;
        JCodeModel codeModel = super.generateModel();
        JFieldVar projectCodeVar = null;
        if (!this.messageInterface().projectCode().isEmpty()) {
            projectCodeVar = this.getDefinedClass().field(28, String.class, "projectCode");
            projectCodeVar.init(JExpr.lit((String)this.messageInterface().projectCode()));
        }
        JFieldVar fqcn = this.getDefinedClass().field(28, String.class, FQCN_FIELD_NAME);
        if (this.messageInterface().loggingFQCN() == null) {
            fqcn.init((JExpression)this.getDefinedClass().dotclass().invoke("getName"));
        } else {
            fqcn.init((JExpression)codeModel.ref(this.messageInterface().loggingFQCN()).dotclass().invoke("getName"));
        }
        JMethod constructor = this.getDefinedClass().constructor(1);
        JVar constructorParam = constructor.param(8, Tools.loggers().loggerClass(), LOG_FIELD_NAME);
        JBlock constructorBody = constructor.body();
        if (this.messageInterface().extendsLoggerInterface()) {
            if (this.useLogging31) {
                this.getDefinedClass()._extends(Tools.loggers().delegatingLogger());
                constructorBody.add((JStatement)JExpr.invoke((String)"super").arg((JExpression)constructorParam));
                logger2 = JExpr._super().ref(LOG_FIELD_NAME);
            } else {
                logVar = this.getDefinedClass().field(10, Tools.loggers().loggerClass(), LOG_FIELD_NAME);
                constructorBody.assign((JAssignmentTarget)JExpr._this().ref((JVar)logVar), (JExpression)constructorParam);
                logger2 = logVar;
                this.generateDelegatingLoggerMethods(codeModel, logVar, fqcn);
            }
        } else {
            logVar = this.getDefinedClass().field(10, Tools.loggers().loggerClass(), LOG_FIELD_NAME);
            constructorBody.assign((JAssignmentTarget)JExpr._this().ref((JVar)logVar), (JExpression)constructorParam);
            logger2 = logVar;
        }
        HashSet<MessageMethod> messageMethods = new HashSet<MessageMethod>();
        messageMethods.addAll(this.messageInterface().methods());
        for (MessageInterface messageInterface : this.messageInterface().extendedInterfaces()) {
            if (messageInterface.isLoggerInterface()) continue;
            messageMethods.addAll(messageInterface.methods());
        }
        for (MessageMethod messageMethod : messageMethods) {
            JClass returnType = codeModel.ref(messageMethod.returnType().name());
            JMethod jMethod = this.getDefinedClass().method(9, (JType)returnType, messageMethod.name());
            JMethod msgMethod = this.addMessageMethod(messageMethod);
            if (messageMethod.isLoggerMethod()) {
                this.createLoggerMethod(messageMethod, jMethod, msgMethod, (JVar)projectCodeVar, (JExpression)logger2);
                continue;
            }
            this.createBundleMethod(messageMethod, jMethod, msgMethod, (JVar)projectCodeVar);
        }
        return codeModel;
    }

    private void generateDelegatingLoggerMethods(JCodeModel codeModel, JFieldVar logVar, JFieldVar fqcn) {
        for (String level : Arrays.asList("TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL")) {
            String firstUppered = level.charAt(0) + level.substring(1).toLowerCase(Locale.US);
            String lowered = level.toLowerCase(Locale.US);
            if (level.equals("TRACE") || level.equals("DEBUG") || level.equals("INFO")) {
                String isXxxEnabledStr = "is" + firstUppered + "Enabled";
                JMethod isXxxEnabled = this.getDefinedClass().method(9, (JType)codeModel.BOOLEAN, isXxxEnabledStr);
                isXxxEnabled.body()._return((JExpression)JExpr.invoke((JExpression)logVar, (String)isXxxEnabledStr));
            }
            JMethod xxx1 = this.getDefinedClass().method(9, (JType)codeModel.VOID, lowered);
            JVar xxx1message = xxx1.param((JType)codeModel.ref(Object.class), "message");
            JInvocation xxx1inv = xxx1.body().invoke((JExpression)logVar, lowered);
            xxx1inv.arg((JExpression)fqcn);
            xxx1inv.arg((JExpression)xxx1message);
            xxx1inv.arg(JExpr._null());
            JMethod xxx2 = this.getDefinedClass().method(9, (JType)codeModel.VOID, lowered);
            JVar xxx2message = xxx2.param((JType)codeModel.ref(Object.class), "message");
            JVar xxx2t = xxx2.param((JType)codeModel.ref(Throwable.class), "t");
            JInvocation xxx2inv = xxx2.body().invoke((JExpression)logVar, lowered);
            xxx2inv.arg((JExpression)fqcn);
            xxx2inv.arg((JExpression)xxx2message);
            xxx2inv.arg((JExpression)xxx2t);
            JMethod xxx3 = this.getDefinedClass().method(9, (JType)codeModel.VOID, lowered);
            JVar xxx3loggerFqcn = xxx3.param((JType)codeModel.ref(String.class), "loggerFqcn");
            JVar xxx3message = xxx3.param((JType)codeModel.ref(Object.class), "message");
            JVar xxx3t = xxx3.param((JType)codeModel.ref(Throwable.class), "t");
            JInvocation xxx3inv = xxx3.body().invoke((JExpression)logVar, lowered);
            xxx3inv.arg((JExpression)xxx3loggerFqcn);
            xxx3inv.arg((JExpression)xxx3message);
            xxx3inv.arg((JExpression)xxx3t);
            JMethod xxx4 = this.getDefinedClass().method(9, (JType)codeModel.VOID, lowered);
            JVar xxx4loggerFqcn = xxx4.param((JType)codeModel.ref(String.class), "loggerFqcn");
            JVar xxx4message = xxx4.param((JType)codeModel.ref(Object.class), "message");
            JVar xxx4params = xxx4.param((JType)codeModel.ref(Object[].class), "params");
            JVar xxx4t = xxx4.param((JType)codeModel.ref(Throwable.class), "t");
            JInvocation xxx4inv = xxx4.body().invoke((JExpression)logVar, lowered);
            xxx4inv.arg((JExpression)xxx4loggerFqcn);
            xxx4inv.arg((JExpression)xxx4message);
            xxx4inv.arg((JExpression)xxx4params);
            xxx4inv.arg((JExpression)xxx4t);
            for (String affix : Arrays.asList("v", "f")) {
                String name = lowered + affix;
                String target = LOG_FIELD_NAME + affix;
                for (boolean renderThr : new boolean[]{false, true}) {
                    JVar thr = null;
                    JMethod xxx1x = this.getDefinedClass().method(9, (JType)codeModel.VOID, name);
                    if (renderThr) {
                        thr = xxx1x.param((JType)codeModel.ref(Throwable.class), "t");
                    }
                    JVar xxx1xFormat = xxx1x.param((JType)codeModel.ref(String.class), "format");
                    JVar xxx1xParams = xxx1x.varParam((JType)codeModel.ref(Object.class), "params");
                    JInvocation xxx1xInv = xxx1x.body().invoke((JExpression)logVar, target);
                    xxx1xInv.arg((JExpression)fqcn);
                    xxx1xInv.arg((JExpression)codeModel.ref(Tools.loggers().logLevelClass()).staticRef(level));
                    xxx1xInv.arg((JExpression)(renderThr ? thr : JExpr._null()));
                    xxx1xInv.arg((JExpression)xxx1xFormat);
                    xxx1xInv.arg((JExpression)xxx1xParams);
                    for (int i = 1; i <= 3; ++i) {
                        JMethod xxx2x = this.getDefinedClass().method(9, (JType)codeModel.VOID, name);
                        if (renderThr) {
                            thr = xxx2x.param((JType)codeModel.ref(Throwable.class), "t");
                        }
                        JVar xxx2xFormat = xxx2x.param((JType)codeModel.ref(String.class), "format");
                        JVar[] params = new JVar[i];
                        for (int j = 0; j < i; ++j) {
                            params[j] = xxx2x.param((JType)codeModel.ref(Object.class), "param" + (j + 1));
                        }
                        JInvocation xxx2xInv = xxx2x.body().invoke((JExpression)logVar, target);
                        xxx2xInv.arg((JExpression)fqcn);
                        xxx2xInv.arg((JExpression)codeModel.ref(Tools.loggers().logLevelClass()).staticRef(level));
                        xxx2xInv.arg((JExpression)(renderThr ? thr : JExpr._null()));
                        xxx2xInv.arg((JExpression)xxx2xFormat);
                        for (int j = 0; j < i; ++j) {
                            xxx2xInv.arg((JExpression)params[j]);
                        }
                    }
                }
            }
        }
        JMethod isEnabled = this.getDefinedClass().method(9, (JType)codeModel.BOOLEAN, "isEnabled");
        JVar isEnabledLevel = isEnabled.param((JType)codeModel.ref(Tools.loggers().logLevelClass()), "level");
        JInvocation isEnabledInv = JExpr.invoke((JExpression)logVar, (String)"isEnabled");
        isEnabledInv.arg((JExpression)isEnabledLevel);
        isEnabled.body()._return((JExpression)isEnabledInv);
        JMethod log1 = this.getDefinedClass().method(9, (JType)codeModel.VOID, LOG_FIELD_NAME);
        JVar log1Level = log1.param((JType)codeModel.ref(Tools.loggers().logLevelClass()), "level");
        JVar log1Message = log1.param((JType)codeModel.ref(Object.class), "message");
        JInvocation log1inv = log1.body().invoke((JExpression)logVar, LOG_FIELD_NAME);
        log1inv.arg((JExpression)fqcn);
        log1inv.arg((JExpression)log1Level);
        log1inv.arg((JExpression)log1Message);
        log1inv.arg(JExpr._null());
        log1inv.arg(JExpr._null());
        JMethod log2 = this.getDefinedClass().method(9, (JType)codeModel.VOID, LOG_FIELD_NAME);
        JVar log2Level = log2.param((JType)codeModel.ref(Tools.loggers().logLevelClass()), "level");
        JVar log2message = log2.param((JType)codeModel.ref(Object.class), "message");
        JVar log2t = log2.param((JType)codeModel.ref(Throwable.class), "t");
        JInvocation log2inv = log2.body().invoke((JExpression)logVar, LOG_FIELD_NAME);
        log2inv.arg((JExpression)fqcn);
        log2inv.arg((JExpression)log2Level);
        log2inv.arg((JExpression)log2message);
        log2inv.arg(JExpr._null());
        log2inv.arg((JExpression)log2t);
        JMethod log3 = this.getDefinedClass().method(9, (JType)codeModel.VOID, LOG_FIELD_NAME);
        JVar log3Level = log3.param((JType)codeModel.ref(Tools.loggers().logLevelClass()), "level");
        JVar log3loggerFqcn = log3.param((JType)codeModel.ref(String.class), "loggerFqcn");
        JVar log3message = log3.param((JType)codeModel.ref(Object.class), "message");
        JVar log3t = log3.param((JType)codeModel.ref(Throwable.class), "t");
        JInvocation log3inv = log3.body().invoke((JExpression)logVar, LOG_FIELD_NAME);
        log3inv.arg((JExpression)log3Level);
        log3inv.arg((JExpression)log3loggerFqcn);
        log3inv.arg((JExpression)log3message);
        log3inv.arg((JExpression)log3t);
        JMethod log4 = this.getDefinedClass().method(9, (JType)codeModel.VOID, LOG_FIELD_NAME);
        JVar log4loggerFqcn = log4.param((JType)codeModel.ref(String.class), "loggerFqcn");
        JVar log4Level = log4.param((JType)codeModel.ref(Tools.loggers().logLevelClass()), "level");
        JVar log4message = log4.param((JType)codeModel.ref(Object.class), "message");
        JVar log4params = log4.param((JType)codeModel.ref(Object[].class), "params");
        JVar log4t = log4.param((JType)codeModel.ref(Throwable.class), "t");
        JInvocation log4inv = log4.body().invoke((JExpression)logVar, LOG_FIELD_NAME);
        log4inv.arg((JExpression)log4loggerFqcn);
        log4inv.arg((JExpression)log4Level);
        log4inv.arg((JExpression)log4message);
        log4inv.arg((JExpression)log4params);
        log4inv.arg((JExpression)log4t);
        for (String affix : Arrays.asList("v", "f")) {
            String name = LOG_FIELD_NAME + affix;
            JVar logFqcn = null;
            JVar thr = null;
            for (RenderLog render : RenderLog.values()) {
                thr = null;
                boolean renderThr = render.isThr();
                boolean renderFqcn = render.isFqcn();
                JMethod log1x = this.getDefinedClass().method(9, (JType)codeModel.VOID, name);
                if (renderFqcn) {
                    logFqcn = log1x.param((JType)codeModel.ref(String.class), "loggerFqcn");
                }
                JVar log1xLevel = log1x.param((JType)codeModel.ref(Tools.loggers().logLevelClass()), "level");
                if (renderThr) {
                    thr = log1x.param((JType)codeModel.ref(Throwable.class), "t");
                }
                JVar log1xFormat = log1x.param((JType)codeModel.ref(String.class), "format");
                JVar log1xParams = log1x.varParam((JType)codeModel.ref(Object.class), "params");
                JInvocation log1xInv = log1x.body().invoke((JExpression)logVar, name);
                log1xInv.arg((JExpression)(renderFqcn ? logFqcn : fqcn));
                log1xInv.arg((JExpression)log1xLevel);
                log1xInv.arg((JExpression)(renderThr ? thr : JExpr._null()));
                log1xInv.arg((JExpression)log1xFormat);
                log1xInv.arg((JExpression)log1xParams);
                for (int i = 1; i <= 3; ++i) {
                    JMethod log2x = this.getDefinedClass().method(9, (JType)codeModel.VOID, name);
                    if (renderFqcn) {
                        logFqcn = log2x.param((JType)codeModel.ref(String.class), "loggerFqcn");
                    }
                    JVar log2xLevel = log2x.param((JType)codeModel.ref(Tools.loggers().logLevelClass()), "level");
                    if (renderThr) {
                        thr = log2x.param((JType)codeModel.ref(Throwable.class), "t");
                    }
                    JVar log2xFormat = log2x.param((JType)codeModel.ref(String.class), "format");
                    JVar[] params = new JVar[i];
                    for (int j = 0; j < i; ++j) {
                        params[j] = log2x.param((JType)codeModel.ref(Object.class), "param" + (j + 1));
                    }
                    JInvocation log2xInv = log2x.body().invoke((JExpression)logVar, name);
                    log2xInv.arg((JExpression)(renderFqcn ? logFqcn : fqcn));
                    log2xInv.arg((JExpression)log2xLevel);
                    log2xInv.arg((JExpression)(renderThr ? thr : JExpr._null()));
                    log2xInv.arg((JExpression)log2xFormat);
                    for (int j = 0; j < i; ++j) {
                        log2xInv.arg((JExpression)params[j]);
                    }
                }
            }
        }
    }

    private void createLoggerMethod(MessageMethod messageMethod, JMethod method, JMethod msgMethod, JVar projectCodeVar, JExpression logger2) {
        this.addThrownTypes(messageMethod, method);
        JBlock body = method.body();
        Map<Parameter, JVar> params = this.createParameters(messageMethod, method);
        JInvocation logInv = body.invoke(logger2, messageMethod.loggerMethod());
        if (messageMethod.parameters(Parameter.ParameterType.FQCN).isEmpty()) {
            logInv.arg((JExpression)JExpr.ref((String)FQCN_FIELD_NAME));
        } else {
            logInv.arg((JExpression)params.get(messageMethod.parameters(Parameter.ParameterType.FQCN).iterator().next()).invoke("getName"));
        }
        logInv.arg(JExpr.direct((String)messageMethod.logLevel()));
        MessageMethod.Message message = messageMethod.message();
        if (message.format() == Annotations.FormatType.NO_FORMAT) {
            if (message.hasId() && projectCodeVar != null) {
                String formattedId = ClassModelHelper.formatMessageId(message.id());
                logInv.arg(projectCodeVar.plus(JExpr.lit((String)formattedId)).plus((JExpression)JExpr.invoke((JMethod)msgMethod)));
            } else {
                logInv.arg((JExpression)JExpr.invoke((JMethod)msgMethod));
            }
            logInv.arg(JExpr._null());
            if (messageMethod.hasCause()) {
                logInv.arg(JExpr.direct((String)messageMethod.cause().name()));
            } else {
                logInv.arg(JExpr._null());
            }
        } else {
            if (messageMethod.hasCause()) {
                logInv.arg(JExpr.direct((String)messageMethod.cause().name()));
            } else {
                logInv.arg(JExpr._null());
            }
            if (message.hasId() && projectCodeVar != null) {
                String formattedId = ClassModelHelper.formatMessageId(message.id());
                logInv.arg(projectCodeVar.plus(JExpr.lit((String)formattedId)).plus((JExpression)JExpr.invoke((JMethod)msgMethod)));
            } else {
                logInv.arg((JExpression)JExpr.invoke((JMethod)msgMethod));
            }
            for (Map.Entry<Parameter, JVar> entry : params.entrySet()) {
                Parameter param = entry.getKey();
                String formatterClass = param.formatterClass();
                switch (param.parameterType()) {
                    case FORMAT: {
                        if (formatterClass == null) {
                            logInv.arg((JExpression)entry.getValue());
                            break;
                        }
                        logInv.arg((JExpression)JExpr._new((JClass)this.getCodeModel().ref(formatterClass)).arg((JExpression)entry.getValue()));
                    }
                }
            }
        }
    }

    private Map<Parameter, JVar> createParameters(MessageMethod messageMethod, JMethod method) {
        LinkedHashMap<Parameter, JVar> result = new LinkedHashMap<Parameter, JVar>();
        for (Parameter param : messageMethod.parameters(Parameter.ParameterType.ANY)) {
            JClass paramType = this.getCodeModel().ref(param.type());
            JVar var = method.param(8, (JType)paramType, param.name());
            result.put(param, var);
        }
        return result;
    }

    static enum RenderLog {
        NONE(false, false),
        CAUSE(true, false),
        FQCN(true, true);

        private final boolean thr;
        private final boolean fqcn;

        private RenderLog(boolean thr, boolean fqcn) {
            this.thr = thr;
            this.fqcn = fqcn;
        }

        public boolean isThr() {
            return this.thr;
        }

        public boolean isFqcn() {
            return this.fqcn;
        }
    }
}

