/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.encoding.TypeMapping;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.core.binding.TypeMappingImpl;
import org.jboss.ws.core.jaxrpc.EncodedTypeMapping;
import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;

public class TypeMappingRegistryImpl
implements TypeMappingRegistry {
    private static final ResourceBundle bundle = BundleUtils.getBundle(TypeMappingRegistryImpl.class);
    private Map<String, TypeMappingImpl> typeMappings = new HashMap<String, TypeMappingImpl>();

    public TypeMappingRegistryImpl() {
        this.typeMappings.put("", new LiteralTypeMapping());
        this.typeMappings.put("http://schemas.xmlsoap.org/soap/encoding/", new EncodedTypeMapping());
    }

    public void clear() {
        this.typeMappings.clear();
    }

    public TypeMapping getDefaultTypeMapping() {
        return this.typeMappings.get("");
    }

    public void registerDefault(TypeMapping mapping) {
        throw new NotImplementedException();
    }

    public TypeMapping createTypeMapping() {
        throw new NotImplementedException();
    }

    public TypeMapping getTypeMapping(String encodingStyleURI) {
        this.assertEncodingStyle(encodingStyleURI);
        return this.typeMappings.get(encodingStyleURI);
    }

    public String[] getRegisteredEncodingStyleURIs() {
        return new String[]{"", "http://schemas.xmlsoap.org/soap/encoding/"};
    }

    public TypeMapping register(String encodingStyleURI, TypeMapping mapping) {
        throw new NotImplementedException();
    }

    public TypeMapping unregisterTypeMapping(String encodingStyleURI) {
        throw new NotImplementedException();
    }

    public boolean removeTypeMapping(TypeMapping mapping) {
        throw new NotImplementedException();
    }

    private void assertEncodingStyle(String encURI) {
        if (!"".equals(encURI) && !"http://schemas.xmlsoap.org/soap/encoding/".equals(encURI)) {
            throw new JAXRPCException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNSUPPORTED_ENCODING_STYLE", (Object[])new Object[]{encURI}));
        }
    }
}

