/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder.jaxws;

import java.util.ResourceBundle;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.common.integration.WSHelper;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.ws.metadata.builder.jaxws.JAXWSServerMetaDataBuilder;
import org.jboss.ws.metadata.builder.jaxws.SecurityActions;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Endpoint;

public class JAXWSMetaDataBuilderJSE {
    private static final ResourceBundle bundle = BundleUtils.getBundle(JAXWSMetaDataBuilderJSE.class);
    private final Logger log = Logger.getLogger(JAXWSMetaDataBuilderJSE.class);

    public UnifiedMetaData buildMetaData(ArchiveDeployment dep) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("START buildMetaData: [name=" + dep.getCanonicalName() + "]"));
        }
        try {
            UnifiedMetaData wsMetaData = new UnifiedMetaData(dep.getRootFile());
            wsMetaData.setDeploymentName(dep.getCanonicalName());
            ClassLoader runtimeClassLoader = dep.getRuntimeClassLoader();
            if (null == runtimeClassLoader) {
                throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"RUNTIME_CLASSLOADER_CANNOT_BE_NULL", (Object[])new Object[0]));
            }
            wsMetaData.setClassLoader((ClassLoader)new DelegateClassLoader(runtimeClassLoader, SecurityActions.getContextClassLoader()));
            for (Endpoint ep : dep.getService().getEndpoints()) {
                if (!WSHelper.isJaxwsJseEndpoint((Endpoint)ep)) continue;
                String shortName = ep.getShortName();
                Class beanClass = ep.getTargetBeanClass();
                JAXWSServerMetaDataBuilder.setupProviderOrWebService(dep, wsMetaData, beanClass, shortName);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("END buildMetaData: " + wsMetaData));
            }
            return wsMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_BUILD_META_DATA", (Object[])new Object[]{ex.getMessage()}), ex);
        }
    }
}

