/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.umdm;

import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.metadata.umdm.TypesMetaData;

public class TypeMappingMetaData {
    private static final ResourceBundle bundle = BundleUtils.getBundle(TypeMappingMetaData.class);
    private TypesMetaData typesMetaData;
    private QName xmlType;
    private String javaTypeName;
    private String qnameScope;
    public static final String QNAME_SCOPE_SIMPLE_TYPE = "simpleType";
    public static final String QNAME_SCOPE_COMPLEX_TYPE = "complexType";
    public static final String QNAME_SCOPE_ELEMENT = "element";
    private static List<String> allowedScopes = Arrays.asList("complexType", "simpleType", "element");

    public TypeMappingMetaData(TypesMetaData typesMetaData, QName xmlType, String javaTypeName) {
        if (xmlType == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVALID_NULL_XMLTYPE", (Object[])new Object[0]));
        }
        if (javaTypeName == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVALID_NULL_JAVATYPENAME", (Object[])new Object[0]));
        }
        this.typesMetaData = typesMetaData;
        this.javaTypeName = javaTypeName;
        this.xmlType = xmlType;
        this.qnameScope = QNAME_SCOPE_COMPLEX_TYPE;
    }

    public TypesMetaData getTypesMetaData() {
        return this.typesMetaData;
    }

    public String getJavaTypeName() {
        return this.javaTypeName;
    }

    public QName getXmlType() {
        return this.xmlType;
    }

    public String getQNameScope() {
        return this.qnameScope;
    }

    public void setQNameScope(String qnameScope) {
        if (!allowedScopes.contains(qnameScope)) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INVALID_QNAME_SCOPE", (Object[])new Object[]{qnameScope}));
        }
        this.qnameScope = qnameScope;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TypeMappingMetaData)) {
            return false;
        }
        TypeMappingMetaData other = (TypeMappingMetaData)obj;
        return this.toString().equals(other.toString());
    }

    public String toString() {
        return "[" + this.qnameScope + "=" + this.xmlType + ",javaType=" + this.javaTypeName + "]";
    }
}

