/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.ws.tools.Configuration;
import org.jboss.ws.tools.SecurityActions;
import org.jboss.ws.tools.config.ToolsSchemaConfigReader;
import org.jboss.ws.tools.helpers.ToolsHelper;

public class WSTools {
    private static final ResourceBundle bundle = BundleUtils.getBundle(WSTools.class);
    private static Logger log = Logger.getLogger(WSTools.class);

    public static void main(String[] args) throws IOException {
        WSTools tools = new WSTools();
        boolean success = false;
        try {
            success = tools.generate(args);
        }
        catch (Throwable e) {
            e.printStackTrace(new PrintWriter(System.err));
        }
        if (success) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    public boolean generate(String configLocation, String outputDir) throws IOException {
        ToolsSchemaConfigReader configReader = new ToolsSchemaConfigReader();
        Configuration config = configReader.readConfig(configLocation);
        return this.process(config, outputDir);
    }

    public boolean generate(String[] args) throws IOException {
        String configLocation = null;
        String outputDir = null;
        if (args.length == 0) {
            this.usage();
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-config".equals(arg)) {
                configLocation = args[i + 1];
                ++i;
                continue;
            }
            if ("-dest".equals(arg)) {
                outputDir = args[i + 1];
                ++i;
                continue;
            }
            if ("-classpath".equals(arg) || "-cp".equals(arg)) {
                StringTokenizer st = new StringTokenizer(args[i + 1], File.pathSeparator);
                int tokens = st.countTokens();
                URL[] urls = new URL[tokens];
                for (int j = 0; j < tokens; ++j) {
                    String token = st.nextToken();
                    urls[j] = new File(token).toURL();
                }
                ClassLoader ctxLoader = SecurityActions.getContextClassLoader();
                URLClassLoader urlLoader = new URLClassLoader(urls, ctxLoader);
                SecurityActions.setContextClassLoader(urlLoader);
                ++i;
                continue;
            }
            this.usage();
        }
        return this.generate(configLocation, outputDir);
    }

    private void usage() {
        System.out.println("Usage: wstools (-classpath|-cp) <classpath> -config <config> [-dest <destination path>]");
        System.exit(1);
    }

    private boolean process(Configuration config, String outputDir) throws IOException {
        if (config == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CONFIGURATION_IS_NULL", (Object[])new Object[0]));
        }
        if (outputDir == null) {
            outputDir = ".";
        }
        ToolsHelper helper = new ToolsHelper();
        if (config.getJavaToWSDLConfig(false) != null) {
            helper.handleJavaToWSDLGeneration(config, outputDir);
        } else if (config.getWSDLToJavaConfig(false) != null) {
            helper.handleWSDLToJavaGeneration(config, outputDir);
        } else {
            throw new IOException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CONFIGURATION_ERROR", (Object[])new Object[0]));
        }
        return true;
    }
}

