/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.util.Locale;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.ServerMessages;
import org.jboss.dmr.ModelNode;

public class RootResourceHack
implements OperationStepHandler,
DescriptionProvider {
    public static final RootResourceHack INSTANCE = new RootResourceHack();
    public static final String NAME = "root-resource-hack";
    private static final ModelNode OPERATION = new ModelNode();
    private ThreadLocal<ResourceAndRegistration> resource = new ThreadLocal();

    private RootResourceHack() {
    }

    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ResourceAndRegistration threadResource = this.resource.get();
        if (threadResource == null || threadResource != ResourceAndRegistration.NULL) {
            throw ServerMessages.MESSAGES.internalUseOnly();
        }
        this.resource.set(new ResourceAndRegistration(context.getRootResource(), context.getResourceRegistration()));
        context.completeStep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceAndRegistration getRootResource(ModelController controller) {
        this.resource.set(ResourceAndRegistration.NULL);
        ResourceAndRegistration reg = null;
        try {
            controller.execute(OPERATION, null, ModelController.OperationTransactionControl.COMMIT, null);
        }
        finally {
            reg = this.resource.get();
            this.resource.remove();
            if (ResourceAndRegistration.NULL == reg) {
                throw ServerMessages.MESSAGES.cannotGetRootResource();
            }
        }
        return reg;
    }

    static {
        OPERATION.get("operation").set(NAME);
    }

    public static class ResourceAndRegistration {
        private static final ResourceAndRegistration NULL = new ResourceAndRegistration(null, null);
        private final Resource resource;
        private final ImmutableManagementResourceRegistration registry;

        private ResourceAndRegistration(Resource resource, ImmutableManagementResourceRegistration registry) {
            this.resource = resource;
            this.registry = registry;
        }

        public Resource getResource() {
            return this.resource;
        }

        public ImmutableManagementResourceRegistration getRegistration() {
            return this.registry;
        }
    }
}

