/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr;

import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jacorb.imr.AdminPackage.DuplicateServerName;
import org.jacorb.imr.HostInfo;
import org.jacorb.imr.ImRHostInfo;
import org.jacorb.imr.ImRPOAInfo;
import org.jacorb.imr.ImRServerInfo;
import org.jacorb.imr.POAInfo;
import org.jacorb.imr.ResourceLock;
import org.jacorb.imr.ServerInfo;
import org.jacorb.imr.UnknownServerName;

public class ServerTable
implements Serializable {
    private Hashtable servers = new Hashtable();
    private transient ResourceLock servers_lock;
    private Hashtable poas = new Hashtable();
    private transient ResourceLock poas_lock;
    private Hashtable hosts = new Hashtable();
    private transient ResourceLock hosts_lock;
    public transient ResourceLock table_lock;

    public ServerTable() {
        this.initTransient();
    }

    private void initTransient() {
        this.table_lock = new ResourceLock();
        this.servers_lock = new ResourceLock();
        this.poas_lock = new ResourceLock();
        this.hosts_lock = new ResourceLock();
    }

    public boolean hasServer(String name) {
        return this.servers.containsKey(name);
    }

    public ImRServerInfo getServer(String name) throws UnknownServerName {
        ImRServerInfo _tmp = (ImRServerInfo)this.servers.get(name);
        if (_tmp == null) {
            throw new UnknownServerName(name);
        }
        return _tmp;
    }

    public void putServer(String name, ImRServerInfo server) throws DuplicateServerName {
        if (this.servers.containsKey(name)) {
            throw new DuplicateServerName(name);
        }
        this.table_lock.gainSharedLock();
        this.servers_lock.gainSharedLock();
        this.servers.put(name, server);
        this.servers_lock.releaseSharedLock();
        this.table_lock.releaseSharedLock();
    }

    public void removeServer(String name) throws UnknownServerName {
        this.table_lock.gainSharedLock();
        this.servers_lock.gainSharedLock();
        Object _obj = this.servers.remove(name);
        this.servers_lock.releaseSharedLock();
        this.table_lock.releaseSharedLock();
        if (_obj == null) {
            throw new UnknownServerName(name);
        }
    }

    public boolean poa_enp_reused(String name, String host, int port) {
        POAInfo[] poas = this.getPOAs();
        for (int i = 0; i < poas.length; ++i) {
            if (poas[i].name.equals(name) || !poas[i].host.equals(host) || poas[i].port != port || !poas[i].active) continue;
            return true;
        }
        return false;
    }

    public ImRPOAInfo getPOA(String name) {
        return (ImRPOAInfo)this.poas.get(name);
    }

    public void putPOA(String name, ImRPOAInfo poa) {
        this.table_lock.gainSharedLock();
        this.poas_lock.gainSharedLock();
        this.poas.put(name, poa);
        this.poas_lock.releaseSharedLock();
        this.table_lock.releaseSharedLock();
    }

    public void removePOA(String name) {
        this.table_lock.gainSharedLock();
        this.poas_lock.gainSharedLock();
        this.poas.remove(name);
        this.poas_lock.releaseSharedLock();
        this.table_lock.releaseSharedLock();
    }

    public ServerInfo[] getServers() {
        this.table_lock.gainSharedLock();
        this.servers_lock.gainExclusiveLock();
        ServerInfo[] _servers = new ServerInfo[this.servers.size()];
        Enumeration _server_enum = this.servers.elements();
        int _i = 0;
        while (_server_enum.hasMoreElements()) {
            _servers[_i++] = ((ImRServerInfo)_server_enum.nextElement()).toServerInfo();
        }
        this.servers_lock.releaseExclusiveLock();
        this.table_lock.releaseSharedLock();
        return _servers;
    }

    public HostInfo[] getHosts() {
        this.table_lock.gainSharedLock();
        this.hosts_lock.gainExclusiveLock();
        HostInfo[] _hosts = new HostInfo[this.hosts.size()];
        Enumeration _host_enum = this.hosts.elements();
        int _i = 0;
        while (_host_enum.hasMoreElements()) {
            _hosts[_i++] = ((ImRHostInfo)_host_enum.nextElement()).toHostInfo();
        }
        this.hosts_lock.releaseExclusiveLock();
        this.table_lock.releaseSharedLock();
        return _hosts;
    }

    public POAInfo[] getPOAs() {
        this.table_lock.gainSharedLock();
        this.poas_lock.gainExclusiveLock();
        POAInfo[] _poas = new POAInfo[this.poas.size()];
        Enumeration _poa_enum = this.poas.elements();
        int _i = 0;
        while (_poa_enum.hasMoreElements()) {
            _poas[_i++] = ((ImRPOAInfo)_poa_enum.nextElement()).toPOAInfo();
        }
        this.poas_lock.releaseExclusiveLock();
        this.table_lock.releaseSharedLock();
        return _poas;
    }

    public void putHost(String name, ImRHostInfo host) {
        this.table_lock.gainSharedLock();
        this.hosts_lock.gainSharedLock();
        this.hosts.put(name, host);
        this.hosts_lock.releaseSharedLock();
        this.table_lock.releaseSharedLock();
    }

    public Object removeHost(String name) {
        return this.hosts.remove(name);
    }

    public ImRHostInfo getHost(String name) {
        return (ImRHostInfo)this.hosts.get(name);
    }

    private void readObject(ObjectInputStream in) throws IOException, NotActiveException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransient();
    }
}

