/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.queue;

import edu.emory.mathcs.backport.java.util.PriorityQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.AbstractBoundedEventQueue;
import org.jacorb.notification.queue.EventQueueOverflowStrategy;
import org.jacorb.notification.queue.QueueUtil;

public abstract class AbstractBoundedEventHeap
extends AbstractBoundedEventQueue {
    private final PriorityQueue heap_;

    protected AbstractBoundedEventHeap(int capacity, EventQueueOverflowStrategy overflowStrategy, Object lock, Comparator comparator) {
        super(capacity, overflowStrategy, lock);
        this.heap_ = new PriorityQueue(capacity, comparator);
    }

    private final List copyAllEntries() {
        ArrayList _events = new ArrayList(this.heap_.size());
        _events.addAll(this.heap_);
        return _events;
    }

    private final List removeAllEntries() {
        List _entries = this.copyAllEntries();
        this.heap_.clear();
        return _entries;
    }

    protected final Message removeFirstElement(Comparator comp) {
        List _entries = this.copyAllEntries();
        Collections.sort(_entries, comp);
        Message _mesg = (Message)_entries.remove(0);
        this.heap_.clear();
        this.heap_.addAll((Collection)_entries);
        return _mesg;
    }

    protected final Message[] getAllElements() {
        List _entries = this.removeAllEntries();
        return _entries.toArray(new Message[_entries.size()]);
    }

    public final boolean isEmpty() {
        return this.getSize() == 0;
    }

    public final int getSize() {
        return this.heap_.size();
    }

    protected final void addElement(Message event) {
        this.heap_.add((Object)event);
    }

    protected final Message[] getElements(int max) {
        ArrayList<Object> _result = new ArrayList<Object>();
        while (this.heap_.peek() != null && _result.size() < max) {
            _result.add(this.heap_.remove());
        }
        return _result.toArray(QueueUtil.MESSAGE_ARRAY_TEMPLATE);
    }

    protected final Message getNextHeapElement() {
        return (Message)this.heap_.remove();
    }

    protected final Message getNextElement() {
        return this.getNextHeapElement();
    }

    public final String toString() {
        return this.heap_.toString();
    }
}

