/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.common.beans.property;

import java.util.Locale;
import java.util.StringTokenizer;
import org.jboss.common.beans.property.PropertyEditorSupport;
import org.jboss.common.beans.property.PropertyEditors;

public class LocaleEditor
extends PropertyEditorSupport<Locale> {
    public LocaleEditor() {
        super(Locale.class);
    }

    @Override
    public void setAsText(String text) {
        if (PropertyEditors.isNull(text)) {
            this.setValue(null);
            return;
        }
        try {
            this.setValue(LocaleEditor.parseLocaleString(text));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse locale.", e);
        }
    }

    private static Locale parseLocaleString(String localeString) {
        int endIndexOfCountryCode;
        StringTokenizer stringTokenizer = new StringTokenizer(localeString, "_ ");
        String[] parts = new String[stringTokenizer.countTokens()];
        int index = 0;
        while (stringTokenizer.countTokens() > 0) {
            parts[index++] = stringTokenizer.nextToken();
        }
        String language = parts.length > 0 ? parts[0] : "";
        String country = parts.length > 1 ? parts[1] : "";
        String variant = "";
        if (parts.length >= 2 && (variant = LocaleEditor.trimLeadingWhitespace(localeString.substring(endIndexOfCountryCode = localeString.indexOf(country) + country.length()))).startsWith("_")) {
            variant = variant.replaceFirst("_*", "");
        }
        return language.length() > 0 ? new Locale(language, country, variant) : null;
    }

    private static String trimLeadingWhitespace(String substring) {
        StringBuffer buf = new StringBuffer(substring);
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(0))) {
            buf.deleteCharAt(0);
        }
        return buf.toString();
    }
}

