/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.container.catalina;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.jboss.modcluster.container.ContainerEventHandler;
import org.jboss.modcluster.container.catalina.AutoProxyConnectorProvider;
import org.jboss.modcluster.container.catalina.CatalinaEventHandler;
import org.jboss.modcluster.container.catalina.CatalinaFactory;
import org.jboss.modcluster.container.catalina.JMXServerProvider;
import org.jboss.modcluster.container.catalina.ProxyConnectorProvider;
import org.jboss.modcluster.container.catalina.ServerProvider;
import org.jboss.modcluster.container.catalina.ServiceLoaderCatalinaFactory;
import org.jboss.modcluster.container.catalina.SimpleProxyConnectorProvider;
import org.jboss.modcluster.container.catalina.SimpleServerProvider;

public class CatalinaEventHandlerAdapter
implements CatalinaEventHandler {
    protected final ContainerEventHandler eventHandler;
    protected final ServerProvider serverProvider;
    protected final CatalinaFactory factory;
    protected final AtomicBoolean init = new AtomicBoolean(false);
    protected final AtomicBoolean start = new AtomicBoolean(false);

    public CatalinaEventHandlerAdapter(ContainerEventHandler eventHandler) {
        this(eventHandler, ManagementFactory.getPlatformMBeanServer());
    }

    public CatalinaEventHandlerAdapter(ContainerEventHandler eventHandler, MBeanServer mbeanServer) {
        this(eventHandler, (ServerProvider)new JMXServerProvider(mbeanServer, CatalinaEventHandlerAdapter.toObjectName("Catalina:type=Server")), new AutoProxyConnectorProvider());
    }

    public CatalinaEventHandlerAdapter(ContainerEventHandler eventHandler, Server server) {
        this(eventHandler, (ServerProvider)new SimpleServerProvider(server), new AutoProxyConnectorProvider());
    }

    public CatalinaEventHandlerAdapter(ContainerEventHandler eventHandler, Server server, Connector connector) {
        this(eventHandler, (ServerProvider)new SimpleServerProvider(server), new SimpleProxyConnectorProvider(connector));
    }

    public CatalinaEventHandlerAdapter(ContainerEventHandler eventHandler, ServerProvider serverProvider, ProxyConnectorProvider connectorProvider) {
        this(eventHandler, serverProvider, new ServiceLoaderCatalinaFactory(connectorProvider));
    }

    public CatalinaEventHandlerAdapter(ContainerEventHandler eventHandler, ServerProvider serverProvider, CatalinaFactory factory) {
        this.eventHandler = eventHandler;
        this.serverProvider = serverProvider;
        this.factory = factory;
    }

    public void start() {
        Server server = this.serverProvider.getServer();
        if (!(server instanceof Lifecycle)) {
            throw new IllegalStateException();
        }
        Lifecycle lifecycle = (Lifecycle)server;
        if (!this.containsListener(lifecycle)) {
            lifecycle.addLifecycleListener((LifecycleListener)this);
        }
        if (this.init.compareAndSet(false, true)) {
            this.init(server);
        }
        if (this.start.compareAndSet(false, true)) {
            this.eventHandler.start(this.factory.createServer(server));
        }
    }

    public void stop() {
        Server server = this.serverProvider.getServer();
        if (!(server instanceof Lifecycle)) {
            throw new IllegalStateException();
        }
        Lifecycle lifecycle = (Lifecycle)server;
        lifecycle.removeLifecycleListener((LifecycleListener)this);
        if (this.init.get() && this.start.compareAndSet(true, false)) {
            this.eventHandler.stop(this.factory.createServer(server));
        }
        if (this.init.compareAndSet(true, false)) {
            this.destroy(server);
        }
    }

    private boolean containsListener(Lifecycle lifecycle) {
        for (LifecycleListener listener : lifecycle.findLifecycleListeners()) {
            if (!listener.equals(this)) continue;
            return true;
        }
        return false;
    }

    public void containerEvent(ContainerEvent event) {
        Container container = event.getContainer();
        Object child = event.getData();
        String type = event.getType();
        if (type.equals("addChild")) {
            if (container instanceof Host) {
                ((Lifecycle)child).addLifecycleListener((LifecycleListener)this);
                ((Container)child).addPropertyChangeListener((PropertyChangeListener)this);
                if (this.start.get()) {
                    this.eventHandler.add(this.factory.createContext((Context)child));
                }
            } else if (container instanceof Engine) {
                container.addContainerListener((ContainerListener)this);
                if (child != null) {
                    ((Host)child).addContainerListener((ContainerListener)this);
                }
            }
        } else if (type.equals("removeChild")) {
            if (container instanceof Host) {
                ((Lifecycle)child).removeLifecycleListener((LifecycleListener)this);
                ((Container)child).removePropertyChangeListener((PropertyChangeListener)this);
                if (this.start.get()) {
                    this.eventHandler.remove(this.factory.createContext((Context)child));
                }
            } else if (container instanceof Engine) {
                if (child != null) {
                    ((Host)child).removeContainerListener((ContainerListener)this);
                }
                container.removeContainerListener((ContainerListener)this);
            }
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        Lifecycle source = event.getLifecycle();
        String type = event.getType();
        if (this.isAfterInit(event)) {
            if (source instanceof Server && this.init.compareAndSet(false, true)) {
                Server server = (Server)source;
                this.init(server);
            }
        } else if (type.equals("start")) {
            if (source instanceof Server && this.init.compareAndSet(false, true)) {
                Server server = (Server)source;
                this.init(server);
            }
        } else if (type.equals("after_start")) {
            if (source instanceof Server && this.init.get() && this.start.compareAndSet(false, true)) {
                this.eventHandler.start(this.factory.createServer((Server)source));
            }
        } else if (type.equals("before_stop")) {
            if (source instanceof Context) {
                if (this.start.get()) {
                    this.eventHandler.stop(this.factory.createContext((Context)source));
                }
            } else if (source instanceof Server && this.init.get() && this.start.compareAndSet(true, false)) {
                this.eventHandler.stop(this.factory.createServer((Server)source));
            }
        } else if (this.isBeforeDestroy(event)) {
            if (source instanceof Server && this.init.compareAndSet(true, false)) {
                this.destroy((Server)source);
            }
        } else if (type.equals("periodic") && source instanceof Engine && this.start.get()) {
            this.eventHandler.status(this.factory.createEngine((Engine)source));
        }
    }

    protected boolean isAfterInit(LifecycleEvent event) {
        return false;
    }

    protected boolean isBeforeDestroy(LifecycleEvent event) {
        return false;
    }

    protected void init(Server server) {
        this.eventHandler.init(this.factory.createServer(server));
        this.addListeners(server);
    }

    protected void destroy(Server server) {
        this.removeListeners(server);
        this.eventHandler.shutdown();
    }

    private void addListeners(Server server) {
        for (Service service : server.findServices()) {
            Container engine = service.getContainer();
            engine.addContainerListener((ContainerListener)this);
            ((Lifecycle)engine).addLifecycleListener((LifecycleListener)this);
            for (Container host : engine.findChildren()) {
                host.addContainerListener((ContainerListener)this);
                for (Container context : host.findChildren()) {
                    ((Lifecycle)context).addLifecycleListener((LifecycleListener)this);
                }
            }
        }
    }

    private void removeListeners(Server server) {
        for (Service service : server.findServices()) {
            Container engine = service.getContainer();
            engine.removeContainerListener((ContainerListener)this);
            ((Lifecycle)engine).removeLifecycleListener((LifecycleListener)this);
            for (Container host : engine.findChildren()) {
                host.removeContainerListener((ContainerListener)this);
                for (Container context : host.findChildren()) {
                    ((Lifecycle)context).removeLifecycleListener((LifecycleListener)this);
                }
            }
        }
    }

    protected static ObjectName toObjectName(String name) {
        try {
            return ObjectName.getInstance(name);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof Context && "available".equals(event.getPropertyName()) && Boolean.FALSE.equals(event.getOldValue()) && Boolean.TRUE.equals(event.getNewValue())) {
            this.eventHandler.start(this.factory.createContext((Context)event.getSource()));
        }
    }
}

