/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.osgi.metadata.VersionRange;
import org.jboss.osgi.resolver.XBundleCapability;
import org.jboss.osgi.resolver.XBundleRequirement;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.spi.AbstractRequirement;
import org.osgi.framework.Version;
import org.osgi.resource.Resource;

public class AbstractBundleRequirement
extends AbstractRequirement
implements XBundleRequirement {
    private final String symbolicName = (String)this.getAttribute("osgi.wiring.bundle");
    private final VersionRange versionrange;
    private final String visibility = this.getDirective("visibility");

    protected AbstractBundleRequirement(Resource res, Map<String, Object> atts, Map<String, String> dirs) {
        super(res, "osgi.wiring.bundle", atts, dirs);
        Object versionatt = atts.get("bundle-version");
        if (versionatt instanceof String) {
            versionatt = VersionRange.parse((String)((String)versionatt));
        }
        this.versionrange = (VersionRange)versionatt;
    }

    @Override
    protected Set<String> getMandatoryAttributes() {
        return Collections.singleton("osgi.wiring.bundle");
    }

    @Override
    public String getSymbolicName() {
        return this.symbolicName;
    }

    @Override
    public VersionRange getVersionRange() {
        return this.versionrange;
    }

    @Override
    public String getVisibility() {
        return this.visibility;
    }

    @Override
    public boolean matches(XCapability cap) {
        Version version;
        if (this.getResource() == cap.getResource()) {
            return false;
        }
        if (!super.matches(cap)) {
            return false;
        }
        return this.versionrange == null || this.versionrange.isInRange(version = ((XBundleCapability)cap).getVersion());
    }
}

