/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.internal.ResolverMessages;
import org.jboss.osgi.resolver.spi.AbstractElement;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class AbstractResource
extends AbstractElement
implements XResource {
    private final Map<String, List<Capability>> capabilities = new HashMap<String, List<Capability>>();
    private final Map<String, List<Requirement>> requirements = new HashMap<String, List<Requirement>>();
    private XIdentityCapability identityCapability;
    private Boolean fragment;

    protected void addCapability(Capability cap) {
        String namespace = cap.getNamespace();
        this.getCaplist(namespace).add(cap);
        this.getCaplist(null).add(cap);
    }

    protected void addRequirement(Requirement req) {
        String namespace = req.getNamespace();
        this.getReqlist(namespace).add(req);
        this.getReqlist(null).add(req);
    }

    @Override
    public List<Capability> getCapabilities(String namespace) {
        return Collections.unmodifiableList(this.getCaplist(namespace));
    }

    @Override
    public List<Requirement> getRequirements(String namespace) {
        return Collections.unmodifiableList(this.getReqlist(namespace));
    }

    @Override
    public XIdentityCapability getIdentityCapability() {
        if (this.identityCapability == null) {
            List<Capability> caps = this.getCapabilities("osgi.identity");
            if (caps.size() > 1) {
                throw ResolverMessages.MESSAGES.illegalStateMultipleIdentities(caps);
            }
            if (caps.size() == 1) {
                this.identityCapability = (XIdentityCapability)caps.get(0);
            }
        }
        return this.identityCapability;
    }

    @Override
    public boolean isFragment() {
        if (this.fragment == null) {
            List<Requirement> reqs = this.getRequirements("osgi.wiring.host");
            this.fragment = new Boolean(reqs.size() > 0);
        }
        return this.fragment;
    }

    private List<Capability> getCaplist(String namespace) {
        List<Capability> caplist = this.capabilities.get(namespace);
        if (caplist == null) {
            caplist = new ArrayList<Capability>();
            this.capabilities.put(namespace, caplist);
        }
        return caplist;
    }

    private List<Requirement> getReqlist(String namespace) {
        List<Requirement> reqlist = this.requirements.get(namespace);
        if (reqlist == null) {
            reqlist = new ArrayList<Requirement>();
            this.requirements.put(namespace, reqlist);
        }
        return reqlist;
    }

    public String toString() {
        XIdentityCapability id = this.getIdentityCapability();
        String idstr = id != null ? id.getSymbolicName() + ":" + id.getVersion() : "anonymous";
        return this.getClass().getSimpleName() + "[" + idstr + "]";
    }
}

