package br.com.centralit.bpm.integracao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import br.com.centralit.bpm.dto.EventoFluxoDTO;
import br.com.centralit.bpm.util.Enumerated.FlowElementType;
import br.com.centralit.bpm.util.Enumerated.FlowInstanceStatus;
import br.com.centralit.bpm.util.Enumerated.StatusWorkItem;
import br.com.citframework.excecao.PersistenceException;

public class EventoFluxoDao extends ItemTrabalhoFluxoDao {

    @Override
    public Class<EventoFluxoDTO> getBean() {
        return EventoFluxoDTO.class;
    }

    private StringBuilder getSQLRestoreAll() {
        final StringBuilder sql = new StringBuilder();
        sql.append("SELECT item.idItemTrabalho, item.idInstancia, item.idElemento, item.dataHoraCriacao, ");
		sql.append("       item.dataHoraFinalizacao, item.dataHoraExecucao, item.idStatus, elem.intervalo, ");
        sql.append("       inst.idFluxo, tipo.idTipoFluxo, tipo.nomeClasseFluxo ");
        sql.append("  FROM bpm_itemtrabalhofluxo item inner join bpm_elementofluxo elem on elem.idElemento = item.idElemento ");
        sql.append("                                  inner join bpm_instanciafluxo inst on inst.idInstancia = item.idInstancia ");
        sql.append("                                  inner join bpm_fluxo fluxo on fluxo.idFluxo = inst.idFluxo ");
        sql.append("                                  inner join bpm_tipofluxo tipo on tipo.idTipoFluxo = fluxo.idTipoFluxo ");
		sql.append(" WHERE elem.idType = " + FlowElementType.EVENT.getId() + "");
        return sql;
    }

    private List<String> getColunasRestoreAll() {
        final List<String> listRetorno = new ArrayList<>();
        listRetorno.add("idItemTrabalho");
        listRetorno.add("idInstancia");
        listRetorno.add("idElemento");
        listRetorno.add("dataHoraCriacao");
        listRetorno.add("dataHoraFinalizacao");
        listRetorno.add("dataHoraExecucao");
		listRetorno.add("idStatus");
        listRetorno.add("intervalo");
        listRetorno.add("idFluxo");
        listRetorno.add("idTipoFluxo");
        listRetorno.add("nomeClasseFluxo");
        return listRetorno;
    }

    public Collection<EventoFluxoDTO> findDisponiveis() throws PersistenceException {
        final List<Object> parametro = new ArrayList<>();

        final StringBuilder sql = this.getSQLRestoreAll();
		sql.append("    AND item.idStatus <> ? ");
		sql.append("    AND item.idStatus <> ? ");
		sql.append("    AND item.idStatus <> ? ");
		sql.append("    AND inst.idStatus = ? ");

		parametro.add(StatusWorkItem.CANCELED.getId());
		parametro.add(StatusWorkItem.EXECUTED.getId());
		parametro.add(StatusWorkItem.SUSPENDED.getId());
		parametro.add(FlowInstanceStatus.STARTED.getId());

        sql.append("ORDER BY item.dataHoraCriacao");

        final List<?> lista = this.execSQL(sql.toString(), parametro.toArray());

        return engine.listConvertion(this.getBean(), lista, this.getColunasRestoreAll());
    }

    public Collection<EventoFluxoDTO> findDisponiveis(final Integer idInstancia) throws PersistenceException {
        final List<Object> parametro = new ArrayList<>();

        final StringBuilder sql = this.getSQLRestoreAll();
        sql.append("    AND item.idInstancia = ? ");
		sql.append("    AND item.idStatus <> ? ");
		sql.append("    AND item.idStatus <> ? ");
		sql.append("    AND item.idStatus <> ? ");

        parametro.add(idInstancia);
		parametro.add(StatusWorkItem.CANCELED.getId());
		parametro.add(StatusWorkItem.EXECUTED.getId());
		parametro.add(StatusWorkItem.SUSPENDED.getId());
        sql.append("ORDER BY item.dataHoraCriacao");

        final List<?> lista = this.execSQL(sql.toString(), parametro.toArray());

        return engine.listConvertion(this.getBean(), lista, this.getColunasRestoreAll());
    }

}
