package br.com.centralit.bpm.util;

public class Enumerated {

	public static final String ACTION_DELEGATE = "D";
	public static final String ACTION_START = "I";
	public static final String ACTION_EXECUTE = "E";
	public static final String ACTION_VIEW = "V";

	public static final String INTERACTION_VIEW = "V";
	public static final String INTERACTION_URL = "U";

	public static final String RELATIONSHIP_TYPE_INSTANCE = "I";
	public static final String RELATIONSHIP_TYPE_TASK = "T";

	public static final Integer INSTANCE_OPENED = FlowInstanceStatus.STARTED.getId();
	public static final Integer INSTANCE_CLOSED = FlowInstanceStatus.CLOSED.getId();

	public enum StatusWorkItem {
		CREATED(1, "bpm.enum.statusWorkItem.created"),
		AVAILABLE(2, "bpm.enum.statusWorkItem.available"),
		IN_PROGRESS(3, "Em bpm.enum.statusWorkItem.inProgress"),
		SUSPENDED(4, "bpm.enum.statusWorkItem.suspended"),
		CANCELED(5, "bpm.enum.statusWorkItem.canceled"),
		CLOSED(6, "bpm.enum.statusWorkItem.closed"),
		EXECUTED(7, "bpm.enum.statusWorkItem.executed");

		private final Integer id;
		private final String I18NKey;

		StatusWorkItem(final Integer id, final String I18NKey) {
			this.id = id;
			this.I18NKey = I18NKey;
		}

		public Integer getId() {
			return id;
		}

		public String getI18NKey() {
			return I18NKey;
		}

		public static StatusWorkItem fromId(Integer id) {
			for (StatusWorkItem statusWorkItem : StatusWorkItem.values()) {
				if (statusWorkItem.getId().equals(id)) {
					return statusWorkItem;
				}
			}

			return null;
		}

		public static String chaveFromId(Integer id) {
			for (StatusWorkItem statusWorkItem : StatusWorkItem.values()) {
				if (statusWorkItem.getId().equals(id)) {
					return statusWorkItem.getI18NKey();
				}
			}

			return null;
		}
	}

	public enum FlowInstanceStatus {
		STARTED(1, "bpm.enum.flowInstanceStatus.started"),
		SUSPENDED(2, "bpm.enum.flowInstanceStatus.suspended"),
		CANCELED(3, "bpm.enum.flowInstanceStatus.canceled"),
		CLOSED(4, "bpm.enum.flowInstanceStatus.closed");

		private final Integer id;
		private final String I18NKey;

		FlowInstanceStatus(final Integer id, final String I18NKey) {
			this.id = id;
			this.I18NKey = I18NKey;
		}

		public static FlowInstanceStatus fromId(Integer id) {
			for (FlowInstanceStatus flowInstanceStatus : FlowInstanceStatus.values()) {
				if (flowInstanceStatus.getId().equals(id)) {
					return flowInstanceStatus;
				}
			}

			return null;
		}

		public Integer getId() {
			return id;
		}

		public String getI18NKey() {
			return I18NKey;
		}
	}

	public enum AssignmentType {
		AUTOMATIC(1, "bpm.enum.assignmentType.automatic"),
		MONITORING(2, "bpm.enum.assignmentType.monitoring"),
		DELEGATION(3, "bpm.enum.assignmentType.delegation");

		private final Integer id;
		private final String I18NKey;

		AssignmentType(final Integer id, final String I18NKey) {
			this.id = id;
			this.I18NKey = I18NKey;
		}

		public Integer getId() {
			return id;
		}

		public String getI18NKey() {
			return I18NKey;
		}
	}

	public enum FlowElementType {
		START(1, "Inicio", "bpm.enum.flowElementType.start"),
		TASK(2, "Tarefa", "bpm.enum.flowElementType.task"),
		SCRIPT(3, "Script", "bpm.enum.flowElementType.script"),
		EMAIL(4, "Email", "bpm.enum.flowElementType.email"),
		PORT(5, "Porta", "bpm.enum.flowElementType.port"),
		EVENT(6, "Evento", "bpm.enum.flowElementType.event"),
		END(7, "Finalizacao", "bpm.enum.flowElementType.end");

		private final Integer id;
		private final String className;
		private final String I18NKey;

		FlowElementType(final Integer id, final String className, final String I18NKey) {
			this.id = id;
			this.className = className;
			this.I18NKey = I18NKey;
		}

		public Integer getId() {
			return id;
		}

		public String getClassName() {
			return className;
		}

		public String getI18NKey() {
			return I18NKey;
		}

		public static FlowElementType fromId(Integer idType) {
			for (FlowElementType elementType : FlowElementType.values()) {
				if (elementType.getId().equals(idType)) {
					return elementType;
				}
			}

			return null;
		}
	}

	public enum PortType {
		DECISION(1, "bpm.enum.portType.decision"),
		PARALLEL(2, "bpm.enum.portType.parallel"),
		CONVERGENT(3, "bpm.enum.portType.convergent");

		private final Integer id;
		private final String I18NKey;

		PortType(final Integer id, final String I18NKey) {
			this.id = id;
			this.I18NKey = I18NKey;
		}

		public Integer getId() {
			return id;
		}

		public String getI18NKey() {
			return I18NKey;
		}
	}

	public enum EndType {
		CHAINED(1, "bpm.enum.endType.chained");

		private final Integer id;
		private final String I18NKey;

		EndType(final Integer id, final String I18NKey) {
			this.id = id;
			this.I18NKey = I18NKey;
		}

		public Integer getId() {
			return id;
		}

		public String getI18NKey() {
			return I18NKey;
		}
	}

	public enum ActionWorkItem {
		START(1, "bpm.enum.actionWorkItem.start"),
		EXECUTE(2, "bpm.enum.actionWorkItem.execute"),
		DELEGATE(3, "bpm.enum.actionWorkItem.delegate"),
		SUSPEND(4, "bpm.enum.actionWorkItem.suspend"),
		CANCEL(5, "bpm.enum.actionWorkItem.cancel");

		private final Integer id;
		private final String I18NKey;

		ActionWorkItem(final Integer id, final String I18NKey) {
			this.id = id;
			this.I18NKey = I18NKey;
		}

		public Integer getId() {
			return id;
		}

		public String getI18NKey() {
			return I18NKey;
		}
	}

}