package br.com.centralit.citajax.html;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.citframework.util.UtilI18N;

@SuppressWarnings("rawtypes")
public abstract class AjaxFormAction {

    private static final Logger LOGGER = Logger.getLogger(AjaxFormAction.class);

    public abstract void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception;

    /**
     * Utilizado para setar qual classe representa o bean.
     *
     * @return
     */
    public abstract Class<?> getBeanClass();

    public Object getUsuario(final HttpServletRequest request) {
        return request.getSession().getAttribute("USUARIO");
    }

    public String i18n_Message(final String key, final UsuarioDTO usuario) {
        if (usuario != null) {
            if (UtilI18N.internacionaliza(usuario.getLocale(), key) != null) {
                return UtilI18N.internacionaliza(usuario.getLocale(), key);
            }
            return key;
        }
        return key;
    }

    /**
     * Retorna a linguagem que foi passada no request que est em paramtersDefinition. ATENO: UTILIZADO SOMENTE PARA A GERAO DE RELATRIOS EM PAINEL. Este mtodo tambm est
     * implementando em
     * br.com.centralit.citgerencial.bean.GerencialGenerateService.java.
     *
     * @param paramtersDefinition
     * @return String - Language
     * @author valdoilo.damasceno
     * @since 06.02.2014
     */
    public String getLanguage(final Collection paramtersDefinition) {
        String language = UtilI18N.PORTUGUESE_SIGLA;

        for (final Iterator iterator = paramtersDefinition.iterator(); iterator.hasNext();) {
            final Object parametro = iterator.next();

            if (parametro != null && "org.apache.catalina.connector.RequestFacade".equals(parametro.getClass().getName())) {
                final HttpServletRequest request = (HttpServletRequest) parametro;

                final String aux = (String) request.getSession().getAttribute("locale");

                if (aux != null && StringUtils.isNotBlank(aux)) {
                    language = aux;
                }

                break;
            }
        }

        return language;
    }

    protected void debugValuesFromRequest(final Map<String, Object> hashValores) {
        final Set<Entry<String, Object>> set = hashValores.entrySet();
        final Iterator<Entry<String, Object>> i = set.iterator();

        LOGGER.debug("------- VALORES DO REQUEST: -------");
        while (i.hasNext()) {
            final Entry<String, Object> me = i.next();
            LOGGER.debug("-------------> [" + me.getKey() + "]: [" + me.getValue() + "]");
        }
    }

    /**
     * Mtodo retorna a cidade onde o sistema foi instalado,  um parametro que dece ser configurado. Caso no seja informado
     * o mesmo retorna a cidade de Brasilia.
	 * defeito-2287 - AjaxFormAction.java_(#getCidadeParametrizada).
	 *
	 * @since 21/12/2015
	 * @author ibimon.morais
     */
    public String getCidadeParametrizada(final HttpServletRequest request) throws Exception{
    	String cidadeRelatorio = ParametroUtil.getValor(ParametroSistema.CIDADE_LOCALIDADE);
    	if(cidadeRelatorio == null || "".equals(cidadeRelatorio)){
    		cidadeRelatorio = UtilI18N.internacionaliza(request, "citcorpore.comum.relatorioCidade");
    	}
		return cidadeRelatorio;
    }
}
