package br.com.centralit.citcorpore.ajaxForms;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citajax.html.HTMLTable;
import br.com.centralit.citcorpore.bean.AnaliseTendenciasDTO;
import br.com.centralit.citcorpore.bean.CatalogoServicoDTO;
import br.com.centralit.citcorpore.bean.CausaIncidenteDTO;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.ImpactoDTO;
import br.com.centralit.citcorpore.bean.ItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.bean.TendenciaDTO;
import br.com.centralit.citcorpore.bean.TendenciaGanttDTO;
import br.com.centralit.citcorpore.bean.UrgenciaDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.integracao.CatalogoServicoDao;
import br.com.centralit.citcorpore.integracao.ServicoDao;
import br.com.centralit.citcorpore.negocio.AnaliseTendenciasService;
import br.com.centralit.citcorpore.negocio.CausaIncidenteService;
import br.com.centralit.citcorpore.negocio.ContratoService;
import br.com.centralit.citcorpore.negocio.EvmConexaoService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.ImpactoService;
import br.com.centralit.citcorpore.negocio.ItemConfiguracaoService;
import br.com.centralit.citcorpore.negocio.ServicoService;
import br.com.centralit.citcorpore.negocio.UrgenciaService;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados.ServiceDemandType;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.LogoRel;
import br.com.centralit.citcorpore.util.UtilRelatorio;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.centralit.enums.EvmEnumerados.TipoEvento;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;

public class AnaliseTendencias extends AjaxFormAction {

	private EvmConexaoService evmConexaoService;
	private ItemConfiguracaoService itemConfiguracaoService;
	private AnaliseTendenciasService analiseTendenciasService;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		document.getJanelaPopupById("JANELA_AGUARDE_MENU").show();

		/** Solicitaes de Servios **/
		this.carregarComboContratos(document);
		this.carregarComboTipoDemandaServico(document, request);
		this.carregarComboUrgencia(document, request);
		this.carregarComboImpacto(document, request);
		this.carregarComboCausaIncidente(document, request);
		this.carregarComboGrupoExecutor(document, request);

		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
	}

	/**
	 * Carrega Combo Grupo Executor.
	 *
	 * @param document
	 * @param request
	 * @throws Exception
	 * @throws ServiceException
	 * @author valdoilo.damasceno
	 * @since 04.06.2014
	 */
	private void carregarComboGrupoExecutor(DocumentHTML document, HttpServletRequest request) throws Exception, ServiceException {
		document.getSelectById("idGrupoExecutor").removeAllOptions();

		GrupoService grupoServoce = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		Collection<GrupoDTO> listGrupoServiceDesk = grupoServoce.listGruposServiceDesk();

		HTMLSelect idGrupoExecutor = document.getSelectById("idGrupoExecutor");

		idGrupoExecutor.addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.todos") + " --");
		idGrupoExecutor.addOptions(listGrupoServiceDesk, "idGrupo", "nome", null);
	}

	/**
	 * Alterado por rcs - Analista Desenvolvedor <a
	 * href="rafael.soyer@centralit.com.br">rafael.soyer@centralit.com.br</a>
	 * rcs: Faz-se agora, atravs da linha de cdigo
	 * "causaIncidenteService.filtraColCausasIncidentesPorDataAtiva(colCausas);"
	 * uma filtragem das causas de incidentes. S iro aparecer no combo, as
	 * causas que foram registradas com data igual ou anterior a data atual.
	 * data de alterao: 27/04/2015
	 *
	 *
	 * Carrega Combo Causa.
	 *
	 * @param document
	 * @param request
	 * @throws ServiceException
	 * @throws Exception
	 * @author valdoilo.damasceno
	 * @since 04.06.2014
	 */
	@SuppressWarnings("unchecked")
	private void carregarComboCausaIncidente(DocumentHTML document, HttpServletRequest request) throws ServiceException, Exception {
		document.getSelectById("idCausaIncidente").removeAllOptions();

		CausaIncidenteService causaIncidenteService = (CausaIncidenteService) ServiceLocator.getInstance().getService(CausaIncidenteService.class, null);
		Collection<CausaIncidenteDTO> colCausas = causaIncidenteService.listHierarquia();
		causaIncidenteService.filtraColCausasIncidentesPorDataAtiva(colCausas);

		HTMLSelect idCausaIncidente = document.getSelectById("idCausaIncidente");

		idCausaIncidente.removeAllOptions();
		idCausaIncidente.addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.todas") + " --");

		if (colCausas != null && !colCausas.isEmpty()) {
			idCausaIncidente.addOptions(colCausas, "idCausaIncidente", "descricaoCausaNivel", null);
		}
	}

	/**
	 * Carrega Combo Impacto.
	 *
	 * @param document
	 * @param request
	 * @throws ServiceException
	 * @throws Exception
	 * @throws LogicException
	 * @author valdoilo.damasceno
	 * @since 04.06.2014
	 */
	private void carregarComboImpacto(DocumentHTML document, HttpServletRequest request) throws ServiceException, Exception, LogicException {
		document.getSelectById("impacto").removeAllOptions();

		ImpactoService impactoService = (ImpactoService) ServiceLocator.getInstance().getService(ImpactoService.class, null);
		Collection<ImpactoDTO> listImpacto = impactoService.list();

		HTMLSelect comboImpacto = document.getSelectById("impacto");
		comboImpacto.addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.todos") + " --");
		comboImpacto.addOptions(listImpacto, "idImpacto", "nivelImpacto", null);
	}

	/**
	 * Carrega Combo Urgncia.
	 *
	 * @param document
	 * @param request
	 * @throws ServiceException
	 * @throws Exception
	 * @author valdoilo.damasceno
	 * @since 04.06.2014
	 */
	private void carregarComboUrgencia(DocumentHTML document, HttpServletRequest request) throws ServiceException, Exception, LogicException {
		document.getSelectById("urgencia").removeAllOptions();

		UrgenciaService urgenciaService = (UrgenciaService) ServiceLocator.getInstance().getService(UrgenciaService.class, null);
		Collection<UrgenciaDTO> listUrgencia = urgenciaService.list();

		HTMLSelect comboUrgencia = document.getSelectById("urgencia");
		comboUrgencia.addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.todas") + " --");
		comboUrgencia.addOptions(listUrgencia, "idUrgencia", "nivelUrgencia", null);
	}

	/**
	 * Carrega Combo Tipo Demanda Servio.
	 *
	 * @param document
	 * @param request
	 * @throws ServiceException
	 * @throws Exception
	 * @author valdoilo.damasceno
	 * @since 04.06.2014
	 */
	private void carregarComboTipoDemandaServico(DocumentHTML document, HttpServletRequest request) throws ServiceException, Exception {
		HTMLSelect comboTipoDemandaServico = document.getSelectById("idTipoDemandaServico");
		comboTipoDemandaServico.removeAllOptions();

		comboTipoDemandaServico.addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.todos") + " --");
		
		for (ServiceDemandType serviceDemandType : ServiceDemandType.valuesWithoutOS()) {
			comboTipoDemandaServico.addOption(String.valueOf(serviceDemandType.getId()), UtilI18N.internacionaliza(request, serviceDemandType.getI18NKey()));
		}
	}

	/**
	 * Carrega Combo de Contratos.
	 *
	 * @param document
	 * @throws ServiceException
	 * @throws Exception
	 * @author valdoilo.damasceno
	 * @since 04.06.2014
	 */
	private void carregarComboContratos(DocumentHTML document) throws ServiceException, Exception {
		document.getSelectById("idContrato").removeAllOptions();

		ContratoService contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		Collection<ContratoDTO> listContratoDto = contratoService.listAtivosWithNomeRazaoSocialCliente();

		HTMLSelect comboContrato = document.getSelectById("idContrato");
		comboContrato.addOptions(listContratoDto, "idContrato", "numeroContratoComNomeRazaoSocial", null);
	}

	public void buscarTendencia (DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException, Exception {
		AnaliseTendenciasDTO analiseTendenciasDTO = (AnaliseTendenciasDTO) document.getBean();
		AnaliseTendenciasService analiseTendenciasService = (AnaliseTendenciasService) ServiceLocator.getInstance().getService(AnaliseTendenciasService.class, null);

		Collection<TendenciaDTO> colServico = analiseTendenciasService.buscarTendenciasServico(analiseTendenciasDTO);

		HTMLTable tblServicos = document.getTableById("tblServicos");
		tblServicos.deleteAllRows();
		if(colServico != null && colServico.size() >0){
			if (colServico != null && !colServico.isEmpty() && colServico.size() > 0) {
				tblServicos.addRowsByCollection(colServico, new String[] {"id", "descricao", "qtdeCritica",""}, null, "", new String[] { "exibeTendenciaServico" }, null, null);
			}
		}

		Collection<TendenciaDTO> colCausa = analiseTendenciasService.buscarTendenciasCausa(analiseTendenciasDTO);

		HTMLTable tblCausa = document.getTableById("tblCausa");
		tblCausa.deleteAllRows();
		if(colCausa != null && colCausa.size() >0){
			if (colCausa != null && !colCausa.isEmpty() && colCausa.size() > 0) {
				tblCausa.addRowsByCollection(colCausa, new String[] {"id", "descricao", "qtdeCritica",""}, null, "", new String[] { "exibeTendenciaCausa" }, null, null);
			}
		}

		Collection<TendenciaDTO> colItemConfiguracao = analiseTendenciasService.buscarTendenciasItemConfiguracao(analiseTendenciasDTO);

		HTMLTable tblItemConfiguracao = document.getTableById("tblItemConfiguracao");
		tblItemConfiguracao.deleteAllRows();
		if(colItemConfiguracao != null && colItemConfiguracao.size() >0){
			if (colItemConfiguracao != null && !colItemConfiguracao.isEmpty() && colItemConfiguracao.size() > 0) {
				tblItemConfiguracao.addRowsByCollection(colItemConfiguracao, new String[] {"id", "descricao", "qtdeCritica",""}, null, "", new String[] { "exibeTendenciaItemConfig" }, null, null);
			}
		}

		document.executeScript("JANELA_AGUARDE_MENU.hide();");
		document.executeScript("showResultSolicitacao();");
	}

	private Collection<TendenciaDTO> prepararAbaServicoTecnico(DocumentHTML document, Collection<TendenciaDTO> colItemConfiguracao) throws Exception {
		final ServicoDao servicoDao = new ServicoDao();
		List<TendenciaDTO> listTendenciaServico = new ArrayList<TendenciaDTO>();
		for (TendenciaDTO tendenciaDTO : colItemConfiguracao) {
			Collection<ServicoDTO> listServico = servicoDao.listServicosPorImagemItemConfiguracao(Integer.valueOf(tendenciaDTO.getIdString()));

			if (listServico != null && !listServico.isEmpty()) {
				for (ServicoDTO servico : listServico) {
					TendenciaDTO tendenciaServicoDTO = new TendenciaDTO();
					tendenciaServicoDTO.setId(servico.getIdServico());
					tendenciaServicoDTO.setDescricao(servico.getNomeServico());
					tendenciaServicoDTO.setQtdeCritica(tendenciaDTO.getQtdeCritica());
					tendenciaServicoDTO.setFerramenta(tendenciaDTO.getFerramenta());
					tendenciaServicoDTO.setIdString(tendenciaDTO.getIdString());

					listTendenciaServico.add(tendenciaServicoDTO);
				}
			}
		}

		Collections.sort(listTendenciaServico, new TendenciaDTO());

		Map<Integer, TendenciaDTO> mapTendenciaServico = new HashMap<Integer, TendenciaDTO>();
		for (TendenciaDTO tendenciaDTO : listTendenciaServico) {
			Integer key = tendenciaDTO.getId();
			if (!mapTendenciaServico.containsKey(key)) {
				mapTendenciaServico.put(key, tendenciaDTO);
			} else {
				TendenciaDTO tendenciaDTOaux = mapTendenciaServico.get(key);
				Integer qtdeCritica = tendenciaDTO.getQtdeCritica() + tendenciaDTOaux.getQtdeCritica();
				String idString = tendenciaDTO.getIdString().concat(",").concat(tendenciaDTOaux.getIdString());

				tendenciaDTOaux.setQtdeCritica(qtdeCritica);
				tendenciaDTOaux.setIdString(idString);
			}
		}

		HTMLTable tblEventoServicoTecnico = document.getTableById("tblEventoServicoTecnico");
		tblEventoServicoTecnico.deleteAllRows();
		if (listTendenciaServico != null && !listTendenciaServico.isEmpty() && listTendenciaServico.size() > 0) {
			tblEventoServicoTecnico.addRowsByCollection(mapTendenciaServico.values(), new String[] { "id", "descricao", "qtdeCritica", "" }, null, "",
					new String[] { "exibeTendenciaEventoServico" },
					null, null);
		}

		return mapTendenciaServico.values();
	}

	private Collection<TendenciaDTO> prepararAbaCatalogoNegocio(DocumentHTML document, Collection<TendenciaDTO> colTendenciaServico) throws Exception {
		final CatalogoServicoDao catalogoServicoDao = new CatalogoServicoDao();
		List<TendenciaDTO> listTendenciaNegocio = new ArrayList<TendenciaDTO>();
		for (TendenciaDTO tendenciaDTO : colTendenciaServico) {
			Collection<CatalogoServicoDTO> listNegocio = catalogoServicoDao.findByIdServico(tendenciaDTO.getId());

			if (listNegocio != null && !listNegocio.isEmpty()) {
				for (CatalogoServicoDTO negocio : listNegocio) {
					TendenciaDTO tendenciaServicoDTO = new TendenciaDTO();
					tendenciaServicoDTO.setId(negocio.getIdCatalogoServico());
					tendenciaServicoDTO.setDescricao(negocio.getTituloCatalogoServico());
					tendenciaServicoDTO.setQtdeCritica(tendenciaDTO.getQtdeCritica());
					tendenciaServicoDTO.setFerramenta(tendenciaDTO.getFerramenta());
					tendenciaServicoDTO.setIdString(tendenciaDTO.getId().toString());

					listTendenciaNegocio.add(tendenciaServicoDTO);
				}
			}
		}

		Collections.sort(listTendenciaNegocio, new TendenciaDTO());

		Map<Integer, TendenciaDTO> mapTendenciaNegocio = new HashMap<Integer, TendenciaDTO>();
		for (TendenciaDTO tendenciaDTO : listTendenciaNegocio) {
			Integer key = tendenciaDTO.getId();
			if (!mapTendenciaNegocio.containsKey(key)) {
				mapTendenciaNegocio.put(key, tendenciaDTO);
			} else {
				TendenciaDTO tendenciaDTOaux = mapTendenciaNegocio.get(key);
				Integer qtdeCritica = tendenciaDTO.getQtdeCritica() + tendenciaDTOaux.getQtdeCritica();
				String idString = tendenciaDTO.getIdString().concat(",").concat(tendenciaDTOaux.getIdString());

				tendenciaDTOaux.setQtdeCritica(qtdeCritica);
				tendenciaDTOaux.setIdString(idString);
			}
		}

		HTMLTable tblEventoCatalogoNegocio = document.getTableById("tblEventoCatalogoNegocio");
		tblEventoCatalogoNegocio.deleteAllRows();
		if (listTendenciaNegocio != null && !listTendenciaNegocio.isEmpty() && listTendenciaNegocio.size() > 0) {
			tblEventoCatalogoNegocio.addRowsByCollection(mapTendenciaNegocio.values(), new String[] { "id", "descricao", "qtdeCritica", "" }, null, "",
					new String[] { "exibeTendenciaEventoCatalogoNegocio" }, null, null);
		}

		return mapTendenciaNegocio.values();
	}

	public void gerarRelatorio (DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		AnaliseTendenciasDTO analiseTendenciasDTO = (AnaliseTendenciasDTO) document.getBean();
		List<TendenciaGanttDTO> listTendenciasDto = new ArrayList<TendenciaGanttDTO>();

		String relatorioTitulo = "";
		UsuarioDTO usuario = WebUtil.getUsuario(request);

		AnaliseTendenciasService analiseTendenciaService = (AnaliseTendenciasService) ServiceLocator.getInstance().getService(AnaliseTendenciasService.class, null);

		if ("servico".equalsIgnoreCase(analiseTendenciasDTO.getTipoRelatorio())) {
			listTendenciasDto = analiseTendenciaService.listarGraficoGanttServico(analiseTendenciasDTO, analiseTendenciasDTO.getIdRelatorio());

			ServicoService servicoService = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);
			ServicoDTO servicoDto = servicoService.findById(analiseTendenciasDTO.getIdRelatorio());

			if (servicoDto != null) {
				relatorioTitulo = UtilI18N.internacionaliza(request, "citcorpore.comum.servico") + ": " + servicoDto.getNomeServico();
			}
		} else if (analiseTendenciasDTO.getTipoRelatorio().equalsIgnoreCase("causa")) {
			listTendenciasDto = analiseTendenciaService.listarGraficoGanttCausa(analiseTendenciasDTO, analiseTendenciasDTO.getIdRelatorio());
			CausaIncidenteService causaIncidenteService = (CausaIncidenteService) ServiceLocator.getInstance().getService(CausaIncidenteService.class, null);
			CausaIncidenteDTO causaIncidenteDto = new CausaIncidenteDTO();
			causaIncidenteDto.setIdCausaIncidente(analiseTendenciasDTO.getIdRelatorio());
			causaIncidenteDto = (CausaIncidenteDTO) causaIncidenteService.restore(causaIncidenteDto);

			if (causaIncidenteDto != null) {
				relatorioTitulo = UtilI18N.internacionaliza(request, "problema.causa") + ": " + causaIncidenteDto.getDescricaoCausa();
			}
		} else if (analiseTendenciasDTO.getTipoRelatorio().equalsIgnoreCase("itemConfiguracao")) {
			listTendenciasDto = analiseTendenciaService.listarGraficoGanttItemConfiguracao(analiseTendenciasDTO, analiseTendenciasDTO.getIdRelatorio());
			ItemConfiguracaoService causaIncidenteService = (ItemConfiguracaoService) ServiceLocator.getInstance().getService(ItemConfiguracaoService.class, null);
			ItemConfiguracaoDTO itemConfiguracaoDto = causaIncidenteService.restoreByIdItemConfiguracao(analiseTendenciasDTO.getIdRelatorio());

			if (itemConfiguracaoDto != null) {
				relatorioTitulo = UtilI18N.internacionaliza(request, "itemConfiguracao.itemConfiguracao") + ": " + itemConfiguracaoDto.getIdentificacao();
			}
		}

		if (listTendenciasDto != null && !listTendenciasDto.isEmpty()) {
			DefaultCategoryDataset dataset = new DefaultCategoryDataset();

			for (TendenciaGanttDTO tendencia : listTendenciasDto) {
				if (tendencia != null) {
					String data = UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, tendencia.getData(), WebUtil.getLanguage(request));
					dataset.addValue(tendencia.getQtde(), relatorioTitulo, data);
				}
			}

			geraGraficoRelatorio(document, request, relatorioTitulo, usuario, dataset);
		} else {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.relatorioVazio"));
			return;
		}

		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	private void geraGraficoRelatorio(DocumentHTML document, HttpServletRequest request, String relatorioTitulo, UsuarioDTO usuario, DefaultCategoryDataset dataset) throws Exception {
		JFreeChart chart = ChartFactory.createBarChart("", // chart title
				UtilI18N.internacionaliza(request, "citcorporeRelatorio.comum.data"), // domain axis label
				UtilI18N.internacionaliza(request, "visao.quantidade"), // range
																		// axis
																		// label
				dataset, // dataset
				PlotOrientation.VERTICAL, // orientation
				false, // include legend
				true, // tooltips?
				false // URLs?
				);

		CategoryPlot plot = chart.getCategoryPlot();
		CategoryAxis xAxis = plot.getDomainAxis();
		xAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);

		ValueAxis yAxis = plot.getRangeAxis();
		yAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());

		File file = null;

		try {
			String diretorioRelativo = CITCorporeUtil.CAMINHO_REAL_APP + "tempFiles" + "/ChartAnaliseTendencias.png";
			file = new File(diretorioRelativo);
			ChartUtilities.saveChartAsPNG(file, chart, 1200, 650);
		} catch (IOException e) {
			System.err.println("Problem occurred creating chart.");
		}

		Map<String, Object> parametros = new HashMap<String, Object>();

		HttpSession session = request.getSession(true);
		parametros = UtilRelatorio.trataInternacionalizacaoLocale(session, parametros);

		parametros.put("TITULO_RELATORIO", UtilI18N.internacionaliza(request, "problema.analiseTendencias.titulo"));
		parametros.put("NOME_USUARIO", usuario.getNomeUsuario());
                    parametros.put("CIDADE", getCidadeParametrizada(request));
		parametros.put("DATA_HORA", UtilDatas.getDataHoraAtual());
		parametros.put("Logo", LogoRel.getFile());
		parametros.put("TipoRelatorio", relatorioTitulo);

		Date dt = new Date();
		String strCompl = "" + dt.getTime();

		parametros.put("ChartAnaliseTendencias", file);

		String caminhoJasper = CITCorporeUtil.CAMINHO_REAL_APP + Constantes.getValue("CAMINHO_RELATORIOS") + "RelatorioAnaliseTendencias.jasper";
		String diretorioReceita = CITCorporeUtil.CAMINHO_REAL_APP + "/tempFiles";
		String diretorioRelativoOS = Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/tempFiles";

		JasperPrint print = JasperFillManager.fillReport(caminhoJasper, parametros);
		JasperExportManager.exportReportToPdfFile(print, diretorioReceita + "/RelatorioAnaliseTendencias" + strCompl + ".pdf");

		document.executeScript("window.open('" + Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/printPDF/printPDF.jsp?url=" + diretorioRelativoOS
				+ "/RelatorioAnaliseTendencias" + strCompl + ".pdf')");
	}

	@Override
	public Class<AnaliseTendenciasDTO> getBeanClass() {
		return AnaliseTendenciasDTO.class;
	}

	/**
	 * Metodo para restaurar os dados do Item de Configurao Filhos da Lookup.
	 */
	public void restoreICGerenciado(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		AnaliseTendenciasDTO analiseTendenciasDTO = (AnaliseTendenciasDTO) document.getBean();

		if (analiseTendenciasDTO != null && analiseTendenciasDTO.getIdItemConfiguracaoGerenciado() != null) {
			ItemConfiguracaoDTO itemConfiguracaoGerenciado = new ItemConfiguracaoDTO();
			itemConfiguracaoGerenciado.setIdItemConfiguracao(analiseTendenciasDTO.getIdItemConfiguracaoGerenciado());
			itemConfiguracaoGerenciado = (ItemConfiguracaoDTO) this.getItemConfiguracaoService().restore(itemConfiguracaoGerenciado);

			HTMLElement inputIdentificadorItemConfiguracaoGerenciado = document.getElementById("identificadorItemConfiguracaoGerenciado");
			inputIdentificadorItemConfiguracaoGerenciado.setValue(itemConfiguracaoGerenciado.getIdentificacao());

		} else {
			document.alert(UtilI18N.internacionaliza(request, "gerenciamentoDeEventos.DadosIncompletos"));
		}

		document.executeScript("fecharPopupICGerenciado()");

	}

	/**
	 * Metodo para restaurar os dados do Item de Configurao Pai da Lookup.
	 */
	public void restoreICPai(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		AnaliseTendenciasDTO analiseTendenciasDTO = (AnaliseTendenciasDTO) document.getBean();

		if (analiseTendenciasDTO.getIdItemConfiguracaoPai() != null) {
			ItemConfiguracaoDTO itemConfiguracaoPai = new ItemConfiguracaoDTO();
			itemConfiguracaoPai.setIdItemConfiguracao(analiseTendenciasDTO.getIdItemConfiguracaoPai());
			itemConfiguracaoPai = (ItemConfiguracaoDTO) this.getItemConfiguracaoService().restore(itemConfiguracaoPai);

			HTMLElement inputIdentificadorItemConfiguracaoPai = document.getElementById("identificadorItemConfiguracaoPai");
			inputIdentificadorItemConfiguracaoPai.setValue(itemConfiguracaoPai.getIdentificacao());
		}

		limparCamposGerenciado(document, request, response);

		document.executeScript("fecharPopupICPai()");
	}

	public void limparCamposGerenciado(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		try {
			HTMLElement inputIdentificadorItemConfiguracaoGerenciado = document.getElementById("identificadorItemConfiguracaoGerenciado");
			inputIdentificadorItemConfiguracaoGerenciado.setValue("");

			HTMLElement inputIdItemConfiguracaoGerenciado = document.getElementById("idItemConfiguracaoGerenciado");
			inputIdItemConfiguracaoGerenciado.setValue("");
		} catch (Exception e) {
		}
	}

	private ItemConfiguracaoService getItemConfiguracaoService() throws ServiceException {
		if (itemConfiguracaoService == null) {
			itemConfiguracaoService = (ItemConfiguracaoService) ServiceLocator.getInstance().getService(ItemConfiguracaoService.class, null);
		}
		return itemConfiguracaoService;
	}

	private AnaliseTendenciasService getAnaliseTendenciaService() throws ServiceException {
		if (analiseTendenciasService == null) {
			analiseTendenciasService = (AnaliseTendenciasService) ServiceLocator.getInstance().getService(AnaliseTendenciasService.class, null);
		}
		return analiseTendenciasService;
	}
}
