package br.com.centralit.citcorpore.ajaxForms;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.AtributoDemandaDTO;
import br.com.centralit.citcorpore.bean.IndicadorCapacidadeDTO;
import br.com.centralit.citcorpore.negocio.AtributoDemandaService;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Upload;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;

public class AtributoDemanda extends AjaxFormAction {

	@Override
	public Class<AtributoDemandaDTO> getBeanClass() {
		return AtributoDemandaDTO.class;
	}

	private AtributoDemandaService atributoDemandaService;
	
	@SuppressWarnings("rawtypes")
	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		HashMap hshRetorno[] = null;
		Upload upload = new Upload();
        try {
            hshRetorno = upload.doUploadAll(request);
	        if (hshRetorno != null) {
	
	            Collection fileItems = hshRetorno[1].values();
	            String fileName = "";
	            FileItem fi;
	            String mensagemRetorno = "importaratributofinanceiro.falhaimportacao";
	            if (fileItems != null && !fileItems.isEmpty()) {
	            	File arquivo = null;
	                Iterator it = fileItems.iterator();
	                while (it.hasNext()) {
	                    fi = (FileItem) it.next();
	
	                    if (fi.getName().length() < 1) {
	                    	mensagemRetorno =  "cargaCatalagoServico.selecionarArquivo";
	                        break;
	                    }
	
	                    String extensao = br.com.centralit.citcorpore.util.Util.getFileExtension(fi.getName());
	                    if (!extensao.equalsIgnoreCase("xml") 
	                    		&& !extensao.equalsIgnoreCase("csv")
	                    		&& !extensao.equalsIgnoreCase("xls")
	                    		&& !extensao.equalsIgnoreCase("xlsx") ) {
	                    	mensagemRetorno = "importaratributofinanceiro.erroformato";
	                        break;
	                    }
	                    fileName = fi.getName();
	                    arquivo = new File(CITCorporeUtil.CAMINHO_REAL_APP + "tempFiles/" + fileName);
	                    fi.write(arquivo);
	                    mensagemRetorno = getAtributoDemandaService().importarDados(arquivo, request);

	                    document.alert(UtilI18N.internacionaliza(request, mensagemRetorno));
					}
                }
            }
        } catch (Exception e){
    		throw e;
        } finally {
        }
	}
	
	public void save(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		AtributoDemandaDTO atributoDemandaDTO = (AtributoDemandaDTO) document.getBean();
		String mensagem = "MSE02";
		if(atributoDemandaDTO.getIdAtributoDemanda() == null){
			atributoDemandaDTO = (AtributoDemandaDTO) getAtributoDemandaService().create(atributoDemandaDTO);
			if(atributoDemandaDTO.getIdAtributoDemanda() != null){
				mensagem = "MSG05";
			}
		} else {
			getAtributoDemandaService().update(atributoDemandaDTO);
			mensagem = "MSG06";
		}
		document.executeScript("notificacaoI18N('".concat(mensagem).concat("');"));
		document.executeScript("limpar()");
	}
	
	public void restore(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		AtributoDemandaDTO atributoDemandaDTO = (AtributoDemandaDTO) document.getBean();
		atributoDemandaDTO = (AtributoDemandaDTO) getAtributoDemandaService().restore(atributoDemandaDTO);
		document.getForm("form").clear();
		document.getForm("form").setValues(atributoDemandaDTO);

	}
	
	public void delete(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		AtributoDemandaDTO atributoDemandaDTO = (AtributoDemandaDTO) document.getBean();
		if(atributoDemandaDTO != null && atributoDemandaDTO.getIdAtributoDemanda() != null){
			getAtributoDemandaService().delete(atributoDemandaDTO);
			document.executeScript("notificacaoI18N('MSG07');");
			document.executeScript("limpar()");
		}else{
			document.executeScript("notificacaoErro('MSG04');");
		}
	}

	
	private AtributoDemandaService getAtributoDemandaService() throws ServiceException{
		if(atributoDemandaService == null){
			atributoDemandaService = (AtributoDemandaService) ServiceLocator.getInstance().getService(AtributoDemandaService.class, null);
		}
		return atributoDemandaService;
	}

}
