package br.com.centralit.citcorpore.ajaxForms;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.google.gson.Gson;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.AutoCompleteDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.negocio.CategoriaServicoService;
import br.com.centralit.citcorpore.util.Arvore;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilStrings;

public class AutoCompleteCategoriaServico extends AjaxFormAction {

	private CategoriaServicoService categoriaServicoService;
	private final Gson gson = new Gson();

    @Override
    public Class<ServicoDTO> getBeanClass() {
        return ServicoDTO.class;
    }

    @Override
    public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
    	
		if (request.getParameter("query") != null) {
			String queryConsulta = UtilStrings.fixEncoding(request.getParameter("query"));

			final String contrato = request.getParameter("contrato");
			Integer idContrato = null;
			if (UtilStrings.stringVazia(contrato)) {
				return;
			} else {
				idContrato = Integer.parseInt(contrato);
			}

			String idServicoStr = request.getParameter("idServicoNegocioTecnicoBusca");
			Integer idServico = null;
			if (!UtilStrings.stringVazia(idServicoStr)) {
				idServico = Integer.parseInt(idServicoStr);
			}

			/*
			final Collection<CategoriaServicoDTO> colRetorno = this.getCategoriaServicoService().findAutoCompleteCategoriaServico(idContrato, idServico, queryConsulta);
			final AutoCompleteDTO autoCompleteDTO = new AutoCompleteDTO();

			final List<String> listaNome = new ArrayList<>();
			final List<Integer> listaId = new ArrayList<>();

			if (colRetorno != null) {
				for (final Iterator<CategoriaServicoDTO> it = colRetorno.iterator(); it.hasNext();) {
					final CategoriaServicoDTO categoriaServicoDTO = (CategoriaServicoDTO) it.next();
					if (categoriaServicoDTO.getIdCategoriaServico() != null) {
						listaNome.add(categoriaServicoDTO.getNomeCategoriaServico());
						listaId.add(categoriaServicoDTO.getIdCategoriaServico());
					}
				}
			}
			
			autoCompleteDTO.setQuery(queryConsulta);
			autoCompleteDTO.setSuggestions(listaNome);
			autoCompleteDTO.setData(listaId);

			final String json = gson.toJson(autoCompleteDTO);
			request.setAttribute("json_response", json);
			*/
			Arvore arvore = new Arvore();
			//arvore = this.getCategoriaServicoService().obtemArvoreCategoriaServico(idContrato, idServico, queryConsulta);

			String json = "";

			final AutoCompleteDTO autoCompleteDTO = new AutoCompleteDTO();
			autoCompleteDTO.setQuery(queryConsulta);
			autoCompleteDTO.setSuggestions(arvore.getListaTexto());
			autoCompleteDTO.setData(arvore.getListaID());
			json = gson.toJson(autoCompleteDTO);

			request.setAttribute("json_response", json);
		}
    }

    private CategoriaServicoService getCategoriaServicoService() throws Exception {
        if (categoriaServicoService == null) {
            categoriaServicoService = (CategoriaServicoService) ServiceLocator.getInstance().getService(CategoriaServicoService.class, null);
        }
        return categoriaServicoService;
    }

}