package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.AutoCompleteDTO;
import br.com.centralit.citcorpore.bean.CausaIncidenteDTO;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.negocio.CausaIncidenteService;
import br.com.citframework.service.ServiceLocator;

import com.google.gson.Gson;
@SuppressWarnings({ "rawtypes", "unchecked" })
public class AutoCompleteCausa extends AjaxFormAction {

	
	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		//Corrige o enconding do parmetro desejado.
		String descricaoCausa = new String(request.getParameter("query").getBytes("ISO-8859-1"), "UTF-8");  
		CausaIncidenteService causaIncidenteService = (CausaIncidenteService) ServiceLocator.getInstance().getService(CausaIncidenteService.class, null);
		
		
		
		Collection colRetorno = causaIncidenteService.listaCausaByDescricaoCausa(descricaoCausa);
		AutoCompleteDTO autoCompleteDTO = new AutoCompleteDTO();
		Gson gson = new Gson();
		List lst = new ArrayList();
		List lstVal = new ArrayList();
		
		if (colRetorno != null){
			for (Iterator it = colRetorno.iterator(); it.hasNext();){
				CausaIncidenteDTO causaIncidenteDto = (CausaIncidenteDTO) it.next();
				if (causaIncidenteDto.getIdCausaIncidente()!= null) {
					lst.add(causaIncidenteDto.getDescricaoCausa()); 
					lstVal.add(causaIncidenteDto.getIdCausaIncidente());
				}
			}
		}
		autoCompleteDTO.setQuery(descricaoCausa);
		autoCompleteDTO.setSuggestions(lst);
		autoCompleteDTO.setData(lstVal);
		
		String json = gson.toJson(autoCompleteDTO);
		request.setAttribute("json_response", json);
	}
	@Override
	public Class getBeanClass() {
		// TODO Auto-generated method stub
		return EmpregadoDTO.class;
	}

}
