package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.AutoCompleteDTO;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.UsuarioService;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;

import com.google.gson.Gson;

public class AutoCompleteResponsavel extends AjaxFormAction {

	private UsuarioService usuarioService;

	private final Gson gson = new Gson();

	@Override
	public Class<EmpregadoDTO> getBeanClass() {
		return EmpregadoDTO.class;
	}

	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {

		if (request.getParameter("query") != null) {
			final String consulta = new String(request.getParameter("query").getBytes("ISO-8859-1"), "UTF-8");
			// Corrige o enconding do parmetro desejado.

			final String idContratoStr = request.getParameter("contrato");
			Integer idContrato = null;
			if (idContratoStr != null && !idContratoStr.equals("-1") && !idContratoStr.equals("")) {
				idContrato = Integer.parseInt(idContratoStr);
			}

			Collection<UsuarioDTO> listUsuarioDto = new ArrayList<>();

			String idUnidadeStr = request.getParameter("unidade");
			Integer idUnidade = null;
			if (idUnidadeStr != null && !idUnidadeStr.equals("-1") && !idUnidadeStr.equals("")) {
				idUnidade = Integer.parseInt(idUnidadeStr);
			}

			/* Criado para permitir filtrar as solicitaes que no possuem responsvel. valdoilo.damasceno */
			UsuarioDTO semResponsavel = new UsuarioDTO();

			semResponsavel.setNomeUsuario(UtilI18N.internacionaliza(request, "citsmart.comum.semresponsavel"));
			semResponsavel.setIdUsuario(-1);

			listUsuarioDto.add(semResponsavel);

			if (idContrato != null) {
				listUsuarioDto.addAll(this.getUsuarioService().findUsuarioByNomeAndIdContratoAndIdUnidade(consulta, idContrato, idUnidade));
			} else {
				listUsuarioDto.addAll(this.getUsuarioService().findUsuarioByNome(consulta));
			}

			final AutoCompleteDTO autoCompleteDTO = new AutoCompleteDTO();

			final List<String> listNome = new ArrayList<>();
			final List<Integer> listIdUsuario = new ArrayList<>();

			/* Criado para permitir filtrar as solicitaes que no possuem responsvel. valdoilo.damasceno */
			listNome.add(UtilI18N.internacionaliza(request, "citsmart.comum.semresponsavel"));
			listIdUsuario.add(-1);

			if (listUsuarioDto != null && !listUsuarioDto.isEmpty()) {

				for (final UsuarioDTO usuarioDto : listUsuarioDto) {

					if (usuarioDto.getIdUsuario() != null) {
						listNome.add(usuarioDto.getNomeUsuario());
						listIdUsuario.add(usuarioDto.getIdUsuario());
					}
				}
			}
			autoCompleteDTO.setQuery(consulta);
			autoCompleteDTO.setSuggestions(listNome);
			autoCompleteDTO.setData(listIdUsuario);

			String json = "";

			if (request.getParameter("colection") != null) {
				json = gson.toJson(listUsuarioDto);
			} else {
				json = gson.toJson(autoCompleteDTO);
			}

			request.setAttribute("json_response", json);
		}
	}

	/**
	 * Retorna instncia de UsuarioService;
	 * 
	 * @return UsuarioService
	 * @author valdoilo.damasceno
	 * @since 27.02.2015
	 */
	public UsuarioService getUsuarioService() throws ServiceException {

		if (usuarioService == null) {
			usuarioService = (UsuarioService) ServiceLocator.getInstance().getService(UsuarioService.class, null);
		}
		return usuarioService;
	}
}
