package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.AutoCompleteDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.negocio.ServicoService;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilStrings;

import com.google.gson.Gson;

public class AutoCompleteServicoNegocioTecnico extends AjaxFormAction {

	private ServicoService servicoService;
    private final Gson gson = new Gson();

    @Override
    public Class<ServicoDTO> getBeanClass() {
        return ServicoDTO.class;
    }

    @Override
    public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (request.getParameter("query") != null) {
			String queryConsulta = UtilStrings.fixEncoding(request.getParameter("query"));

			final String contrato = request.getParameter("contrato");
			Integer idContrato = null;
			if (UtilStrings.stringVazia(contrato)) {
				return;
			} else {
				idContrato = Integer.parseInt(contrato);
			}

			String tipoServicoNegocioTecnico = request.getParameter("tipoServico");
			if (UtilStrings.stringVazia(tipoServicoNegocioTecnico)) {
				return;
			}
			
			String categoriaServicoNegocio = request.getParameter("categoriaServicoNegocio");
			Integer idCategoriaServicoNegocio = null;
			if (!UtilStrings.stringVazia(categoriaServicoNegocio)) {
				idCategoriaServicoNegocio = Integer.parseInt(categoriaServicoNegocio);
			}
			
			final Collection<ServicoDTO> colRetorno = this.getServicoService().findAutocompleteServicoNegocioTecnico(idContrato, tipoServicoNegocioTecnico, queryConsulta, idCategoriaServicoNegocio);
			final AutoCompleteDTO autoCompleteDTO = new AutoCompleteDTO();

			final List<String> listaNome = new ArrayList<>();
			final List<Integer> listaId = new ArrayList<>();

			if (colRetorno != null) {
				for (final Iterator<ServicoDTO> it = colRetorno.iterator(); it.hasNext();) {
					final ServicoDTO servicoDto = (ServicoDTO) it.next();
					if (servicoDto.getIdServico() != null) {
						listaNome.add(servicoDto.getNomeServico());
						listaId.add(servicoDto.getIdServico());
					}
				}
			}
			
			autoCompleteDTO.setQuery(queryConsulta);
			autoCompleteDTO.setSuggestions(listaNome);
			autoCompleteDTO.setData(listaId);

			final String json = gson.toJson(autoCompleteDTO);
			request.setAttribute("json_response", json);
		}
    }

    private ServicoService getServicoService() throws Exception {
        if (servicoService == null) {
            servicoService = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);
        }
        return servicoService;
    }

}
