package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.AutoCompleteDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.UsuarioService;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilI18N;

import com.google.gson.Gson;

public class AutoCompleteUsuariosDosGruposDoUsuarioLogado extends AjaxFormAction {

	private static final Gson GSON = new Gson();

    @Override
    public Class<UsuarioDTO> getBeanClass() {
        return UsuarioDTO.class;
    }

    @Override
    public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
    	
    	UsuarioDTO usuario = WebUtil.getUsuario(request);

		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}
		
		final String consulta = request.getParameter("query");
    	
		final Collection<UsuarioDTO> colUsuarios = getService().getUsuariosDosGruposDoUsuarioLogado(usuario.getIdUsuario(), consulta);;

        final AutoCompleteDTO autoCompleteDTO = new AutoCompleteDTO();
        final List<String> lst = new ArrayList<>();
        final List<Integer> lstVal = new ArrayList<>();

        for (final UsuarioDTO usuarioDTO : colUsuarios) {
            lst.add(usuarioDTO.getLogin() + " - " + usuarioDTO.getNomeUsuario());
            lstVal.add(usuarioDTO.getIdUsuario());
        }

        autoCompleteDTO.setQuery(consulta);
        autoCompleteDTO.setSuggestions(lst);
        autoCompleteDTO.setData(lstVal);

        final String json = GSON.toJson(autoCompleteDTO);
        request.setAttribute("json_response", json);
    }

    private static UsuarioService service;

    private UsuarioService getService() throws Exception {
        if (service == null) {
            service = (UsuarioService) ServiceLocator.getInstance().getService(UsuarioService.class, null);
        }
        return service;
    }
}
