/**
 * CentralIT - CITSmart
 */
package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citajax.html.HTMLTable;
import br.com.centralit.citcorpore.bean.BaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.BaseConhecimentoRelacionadoDTO;
import br.com.centralit.citcorpore.bean.ComentariosDTO;
import br.com.centralit.citcorpore.bean.ConhecimentoICDTO;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.ImportanciaConhecimentoGrupoDTO;
import br.com.centralit.citcorpore.bean.ImportanciaConhecimentoUsuarioDTO;
import br.com.centralit.citcorpore.bean.ItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.NotificacaoDTO;
import br.com.centralit.citcorpore.bean.NotificacaoGrupoDTO;
import br.com.centralit.citcorpore.bean.NotificacaoUsuarioDTO;
import br.com.centralit.citcorpore.bean.PastaDTO;
import br.com.centralit.citcorpore.bean.ProblemaDTO;
import br.com.centralit.citcorpore.bean.RequisicaoLiberacaoDTO;
import br.com.centralit.citcorpore.bean.RequisicaoMudancaDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.BaseConhecimentoRelacionadoService;
import br.com.centralit.citcorpore.negocio.BaseConhecimentoService;
import br.com.centralit.citcorpore.negocio.ComentariosService;
import br.com.centralit.citcorpore.negocio.ConhecimentoICService;
import br.com.centralit.citcorpore.negocio.EmpregadoService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.ImportanciaConhecimentoGrupoService;
import br.com.centralit.citcorpore.negocio.ImportanciaConhecimentoUsuarioService;
import br.com.centralit.citcorpore.negocio.ItemConfiguracaoService;
import br.com.centralit.citcorpore.negocio.NotificacaoGrupoService;
import br.com.centralit.citcorpore.negocio.NotificacaoService;
import br.com.centralit.citcorpore.negocio.NotificacaoUsuarioService;
import br.com.centralit.citcorpore.negocio.PastaService;
import br.com.centralit.citcorpore.negocio.PerfilAcessoPastaService;
import br.com.centralit.citcorpore.negocio.ProblemaService;
import br.com.centralit.citcorpore.negocio.RequisicaoLiberacaoService;
import br.com.centralit.citcorpore.negocio.RequisicaoMudancaService;
import br.com.centralit.citcorpore.negocio.ServicoContratoService;
import br.com.centralit.citcorpore.negocio.ServicoService;
import br.com.centralit.citcorpore.negocio.SolicitacaoServicoService;
import br.com.centralit.citcorpore.negocio.UsuarioService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.OrigemBaseConhecimento;
import br.com.centralit.citcorpore.util.Enumerados.PermissaoAcessoPasta;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.Enumerados.TipoConhecimento;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.centralit.citged.negocio.ControleGEDService;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;

/**
 * Action de BaseConhecimento.
 *
 * @author valdoilo.damasceno
 */
public class BaseConhecimento extends AjaxFormAction {

	private Integer idPrimeiraPasta;
	ProblemaDTO problemaDto;
	private ConhecimentoICService conhecimentoICService;
	private ItemConfiguracaoService itemConfiguracaoService;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		BaseConhecimentoDTO baseConhecimentoDto = new BaseConhecimentoDTO();

		String tipoDocumento = request.getParameter("tipoDocumentoExt");

		baseConhecimentoDto.setErroConhecido(request.getParameter("erroConhecido"));

		if (request.getParameter("iframe") != null && !request.getParameter("iframe").equalsIgnoreCase("")) {
			baseConhecimentoDto.setIframe(request.getParameter("iframe"));
		}

		// Quando  chamada atravs do cadastro de problemas, este id servir
		// para posterior vnculo deste cadastro ao problema.
		if(request.getParameter("idProblema") !=null && request.getParameter("idProblema").length()>0){
			baseConhecimentoDto.setIdProblema(Integer.parseInt(request.getParameter("idProblema")));
		}

		if (request.getParameter("idBaseConhecimento") != null && !request.getParameter("idBaseConhecimento").equalsIgnoreCase("") && !"sim".equals(request.getAttribute("limpar"))) {
			baseConhecimentoDto.setIdBaseConhecimento(Integer.parseInt(request.getParameter("idBaseConhecimento")));
		}
		request.removeAttribute("limpar");

		PerfilAcessoPastaService perfilAcessoPastaService = (PerfilAcessoPastaService) ServiceLocator.getInstance().getService(PerfilAcessoPastaService.class, null);
		EmpregadoService empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);

		UsuarioDTO usuarioDto = WebUtil.getUsuario(request);

		this.carregaComboTipoConhecimento(document, request);
		this.carregaComboPastasBaseConhecimento(document, request);
		this.carregaComboOrigem(document, request);
		this.carregaComboPrivacidade(document, request);
		this.carregaComboSituacao(document, request);
		this.carregaCombosCheckbox(document, request);

		EmpregadoDTO empregadoDto = new EmpregadoDTO();

		empregadoDto.setIdEmpregado(usuarioDto.getIdEmpregado());

		empregadoDto = (EmpregadoDTO) empregadoService.restore(empregadoDto);

		String autor = empregadoDto.getNome();

		baseConhecimentoDto.setAutor(autor);

		baseConhecimentoDto.setDataInicio(UtilDatas.getDataAtual());

		if (perfilAcessoPastaService.verificarSeUsuarioAprovaBaseConhecimentoParaPastaSelecionada(usuarioDto, this.getIdPrimeiraPasta())) {
			document.executeScript("$('#publicacao').show()");
		} else {
			document.executeScript("$('#publicacao').hide()");
		}

		request.getSession(true).setAttribute("colUploadsGED", null);

		document.executeScript("uploadAnexos.clear()");

		if (baseConhecimentoDto.getIdProblema() != null) {
			problemaDto = this.getProblemaDto(baseConhecimentoDto.getIdProblema());
		}

		if (problemaDto != null) {
			baseConhecimentoDto.setConteudo("<strong>" + UtilI18N.internacionaliza(request, "baseConhecimento.causaRaiz") + " </strong><br type='_moz' />" + problemaDto.getCausaRaiz() + "<br/><br/><strong>&nbsp;" + UtilI18N.internacionaliza(request, "baseConhecimento.solucaoContorno") + " </strong><br />"
					+ problemaDto.getSolucaoContorno());
		}

		HTMLForm form = document.getForm("formCadastroBaseConhecimento");
		form.clear();

		form.setValues(baseConhecimentoDto);

		this.preencherComboNotificacao(document, request, response);
		HTMLElement notificacaoTitulo = document.getElementById("notificacaoTitulo");
		notificacaoTitulo.setValue("");

		document.executeScript("limpaTabelaEventoMonitoramento();");

		document.executeScript("$('#tabelaGrupoNotificacao').hide()");
		document.executeScript("$('#tabelaUsuarioNotificacao').hide()");
		document.executeScript("$('#btnGravarNotificacao').hide()");
		document.executeScript("$('#divSolicitacaoServico').hide()");
		document.executeScript("$('#divMudanca').hide()");
		document.executeScript("$('#divItemConfiguracao').hide()");
		/*
		 * Adicionando class que fora a margem do campo para 0px, afim de
		 * driblar condio do layout.
		 */
		document.executeScript("$('#divEvento').addClass('ml0')");
		document.executeScript("$('#btnGravarEventoMonitConhecimento').hide()");

		if (tipoDocumento != null && !tipoDocumento.isEmpty()) {
			document.executeScript("$('#comboTipoConhecimento').val('".concat(tipoDocumento).concat("');"));
			document.executeScript("$('#comboTipoConhecimento').attr('disabled', true)");
			baseConhecimentoDto.setTipoDocumento(tipoDocumento);
		}

		String iframe = "";
		if (baseConhecimentoDto.getIframe() != null) {
			iframe = baseConhecimentoDto.getIframe();
		}

		if (iframe != null && !iframe.equals("")) {
			if (baseConhecimentoDto.getErroConhecido() != null && baseConhecimentoDto.getErroConhecido().equalsIgnoreCase("S")) {
				document.executeScript("defineTipoDocumentoErroConhecido();");
				HTMLSelect comboOrigem = document.getSelectById("comboOrigem");
				comboOrigem.setValue(OrigemBaseConhecimento.PROBLEMA.getIdentificador().toString());
				document.executeScript("$('#tabs-2').hide()");
			}

			if(baseConhecimentoDto.getIdBaseConhecimento()!=null){
				this.restore(document, request, response);
			}
		} else {
			tipoDocumento = "D";
			if (SimNao.SIM.getValorStr().equalsIgnoreCase(baseConhecimentoDto.getFaq())) {
				tipoDocumento = "F";
			} else if (SimNao.SIM.getValorStr().equalsIgnoreCase(baseConhecimentoDto.getErroConhecido())) {
				tipoDocumento = "E";
			}

			document.executeScript("habilitarPergunta(\"" + tipoDocumento + "\")");
		}

		document.setBean(baseConhecimentoDto);

		// fechando janela aguarde
		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
	}

	private void carregaCombosCheckbox(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect comboStatus = document.getSelectById("status");
		HTMLSelect comboGerenciamentoDisponibilidade = document.getSelectById("gerenciamentoDisponibilidade");
		HTMLSelect comboDireitoAutoral = document.getSelectById("direitoAutoral");
		HTMLSelect comboLegislacao = document.getSelectById("legislacao");

		carregaOpcoesSimNao(comboStatus, request);
		carregaOpcoesSimNao(comboGerenciamentoDisponibilidade, request);
		carregaOpcoesSimNao(comboDireitoAutoral, request);
		carregaOpcoesSimNao(comboLegislacao, request);
	}

	private void carregaOpcoesSimNao(HTMLSelect combo, HttpServletRequest request) {
		combo.removeAllOptions();

		combo.addOption(SimNao.NAO.getValorStr(), UtilI18N.internacionaliza(request, SimNao.NAO.getChave()));
		combo.addOption(SimNao.SIM.getValorStr(), UtilI18N.internacionaliza(request, SimNao.SIM.getChave()));
	}

	private void carregaComboTipoConhecimento(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("comboTipoConhecimento");
		combo.removeAllOptions();

		for (TipoConhecimento tipoConhecimento : TipoConhecimento.values()) {
			combo.addOption(tipoConhecimento.getIdentificador(), UtilI18N.internacionaliza(request, tipoConhecimento.getChave()));
		}
	}

	public void abrirPopupNotificacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		document.executeScript("window.open('" + Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/pages/configEventoNotificacao/configEventoNotificacao.load')");
	}

	/**
	 * Inclui nova Base de Conhecimento.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author valdoilo.damasceno
	 */
	@SuppressWarnings("unchecked")
	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		document.executeScript("aguarde();");
		BaseConhecimentoDTO baseConhecimentoDto = new BaseConhecimentoDTO();

		baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();

		UsuarioDTO usuarioDto = WebUtil.getUsuario(request);

		BaseConhecimentoService baseConhecimentoService = (BaseConhecimentoService) ServiceLocator.getInstance().getService(BaseConhecimentoService.class, WebUtil.getUsuarioSistema(request));

		Collection<UploadDTO> arquivosUpados = (Collection<UploadDTO>) request.getSession(true).getAttribute("colUploadsGED");

		baseConhecimentoDto.setListImportanciaConhecimentoUsuario(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(
				ImportanciaConhecimentoUsuarioDTO.class, "listImportanciaConhecimentoUsuarioSerializado", request));

		baseConhecimentoDto.setListImportanciaConhecimentoGrupo(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(
				ImportanciaConhecimentoGrupoDTO.class, "listImportanciaConhecimentoGrupoSerializado", request));

		baseConhecimentoDto.setListBaseConhecimentoRelacionado(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(
				BaseConhecimentoRelacionadoDTO.class, "listConhecimentoRelacionadoSerializado", request));

		baseConhecimentoDto.setListaDeUsuarioNotificacao((ArrayList<NotificacaoUsuarioDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(NotificacaoUsuarioDTO.class,
				"listUsuariosNotificacaoSerializados", request));

		baseConhecimentoDto.setListaDeGrupoNotificacao((ArrayList<NotificacaoGrupoDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(NotificacaoGrupoDTO.class,
				"listGruposNotificacaoSerializados", request));

		if (baseConhecimentoDto.getIdBaseConhecimento() == null) {

			if (baseConhecimentoDto.getStatus() == null) {
				baseConhecimentoDto.setStatus("N");
			}

			if (baseConhecimentoService.verificaBaseConhecimentoExistente(baseConhecimentoDto)) {
				document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.registroJaCadastrado"));
				document.executeScript("fechar_aguarde();");
				return;
			}

			baseConhecimentoDto = baseConhecimentoService.create(baseConhecimentoDto, arquivosUpados, WebUtil.getIdEmpresa(request), usuarioDto);
			document.alert(UtilI18N.internacionaliza(request, "dinamicview.gravadocomsucesso"));

		} else {
			if (baseConhecimentoService.verificarSeBaseConhecimentoJaPossuiNovaVersao(baseConhecimentoDto)) {
				document.executeScript("fechar_aguarde();");
				document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.versaorecente"));
			} else {
				if (baseConhecimentoDto.getIdBaseConhecimentoPai() == null && baseConhecimentoService.verificaBaseConhecimentoExistente(baseConhecimentoDto)) {
					document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.registroJaCadastrado"));
					document.executeScript("fechar_aguarde();");
					return;
				}

				baseConhecimentoService.update(baseConhecimentoDto, arquivosUpados, WebUtil.getIdEmpresa(request), usuarioDto);

				document.alert(UtilI18N.internacionaliza(request, "MSG06"));
				document.executeScript("fechar_aguarde();");
				document.executeScript("limpar()");
			}
		}

		document.executeScript("limpar();");
		document.executeScript("limpar_LOOKUP_BASECONHECIMENTO()");
		document.executeScript("fechar_aguarde();");
		document.executeScript("fechar();");

		document.executeScript("fecharModal('".concat(baseConhecimentoDto.getIdBaseConhecimento().toString()).concat(",").concat(baseConhecimentoDto.getTitulo()).concat("')"));
	}

	/**
	 * Restaura Base de Conhecimento.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author valdoilo.damasceno
	 */
	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuarioDto = WebUtil.getUsuario(request);

		String iframe = "";

		BaseConhecimentoDTO baseConhecimentoDto = new BaseConhecimentoDTO();
		NotificacaoDTO notificacaoDto = new NotificacaoDTO();

		baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();

		if (baseConhecimentoDto.getIframe() != null) {
			iframe = baseConhecimentoDto.getIframe();
		}

		if (baseConhecimentoDto.getIdBaseConhecimento() != null) {

			request.getSession(true).setAttribute("colUploadsGED", null);

			NotificacaoService notificacaoService = (NotificacaoService) ServiceLocator.getInstance().getService(NotificacaoService.class, null);
			NotificacaoGrupoService notificacaoGrupoService = (NotificacaoGrupoService) ServiceLocator.getInstance().getService(NotificacaoGrupoService.class, null);
			NotificacaoUsuarioService notificacaoUsuarioService = (NotificacaoUsuarioService) ServiceLocator.getInstance().getService(NotificacaoUsuarioService.class, null);
			BaseConhecimentoService baseConhecimentoService = (BaseConhecimentoService) ServiceLocator.getInstance().getService(BaseConhecimentoService.class, null);
			ComentariosService comentariosService = (ComentariosService) ServiceLocator.getInstance().getService(ComentariosService.class, null);
			EmpregadoService empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);
			UsuarioService usuarioService = (UsuarioService) ServiceLocator.getInstance().getService(UsuarioService.class, null);
			GrupoService grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
			ImportanciaConhecimentoUsuarioService importanciaConhecimentoUsuarioService = (ImportanciaConhecimentoUsuarioService) ServiceLocator.getInstance().getService(
					ImportanciaConhecimentoUsuarioService.class, null);
			ImportanciaConhecimentoGrupoService importanciaConhecimentoGrupoService = (ImportanciaConhecimentoGrupoService) ServiceLocator.getInstance().getService(
					ImportanciaConhecimentoGrupoService.class, null);
			BaseConhecimentoRelacionadoService baseConhecimentoRelacionadoService = (BaseConhecimentoRelacionadoService) ServiceLocator.getInstance().getService(
					BaseConhecimentoRelacionadoService.class, null);

			baseConhecimentoDto = (BaseConhecimentoDTO) baseConhecimentoService.restore(baseConhecimentoDto);

			if (baseConhecimentoDto != null) {

				boolean isPossuiPermissao = this.aplicarPermissaoDeAcesso(document, request, baseConhecimentoDto, usuarioDto, true);

				if (isPossuiPermissao) {
					if (iframe == null || iframe.equals("")) {
						document.executeScript("document.formCadastroBaseConhecimento.restore()");
					}

				} else {
					document.executeScript("limpar()");
					return;
				}

				if (baseConhecimentoDto.getOrigem() == null) {
					baseConhecimentoDto.setOrigem("1");
				} else if (baseConhecimentoDto.getOrigem().equals("")) {
					baseConhecimentoDto.setOrigem("1");
				}

				EmpregadoDTO empregadoAutor = new EmpregadoDTO();
				EmpregadoDTO empregadoAprovador = new EmpregadoDTO();

				UsuarioDTO usuarioAutor = new UsuarioDTO();
				UsuarioDTO usuarioAprovador = new UsuarioDTO();

				if (baseConhecimentoDto.getIdUsuarioAutor() != null) {

					usuarioAutor.setIdUsuario(baseConhecimentoDto.getIdUsuarioAutor());
					usuarioAutor = (UsuarioDTO) usuarioService.restore(usuarioAutor);
					if (usuarioAutor != null) {
						empregadoAutor = empregadoService.restoreByIdEmpregado(usuarioAutor.getIdEmpregado());
						baseConhecimentoDto.setAutor(empregadoAutor.getNome());
					}

				}

				if (baseConhecimentoDto.getIdUsuarioAprovador() != null) {

					usuarioAprovador.setIdUsuario(baseConhecimentoDto.getIdUsuarioAprovador());
					usuarioAprovador = (UsuarioDTO) usuarioService.restore(usuarioAprovador);
					if (usuarioAprovador != null) {
						empregadoAprovador = empregadoService.restoreByIdEmpregado(usuarioAprovador.getIdEmpregado());
						baseConhecimentoDto.setAprovador(empregadoAprovador.getNome());
					}

				}

				request.getSession().removeAttribute("idBaseConhecimento");
				request.getSession().setAttribute("idBaseConhecimento", baseConhecimentoDto.getIdBaseConhecimento());

				Double media = baseConhecimentoService.calcularNota(baseConhecimentoDto.getIdBaseConhecimento());
				if (media != null) {

					baseConhecimentoDto.setMedia(media.toString());
				}

				Long quantidadeVotos = baseConhecimentoService.contarVotos(baseConhecimentoDto.getIdBaseConhecimento());
				if (quantidadeVotos != null) {

					baseConhecimentoDto.setVotos(quantidadeVotos.toString());
				}


				if (baseConhecimentoDto.getIdNotificacao() != null) {

					notificacaoDto.setIdNotificacao(baseConhecimentoDto.getIdNotificacao());

					notificacaoDto = (NotificacaoDTO) notificacaoService.restore(notificacaoDto);

					Collection<NotificacaoGrupoDTO> listaIdGrupo = notificacaoGrupoService.listaIdGrupo(notificacaoDto.getIdNotificacao());

					Collection<NotificacaoUsuarioDTO> listaIdUsuario = notificacaoUsuarioService.listaIdUsuario(notificacaoDto.getIdNotificacao());

					if (listaIdUsuario != null && !listaIdUsuario.isEmpty()) {
						for (NotificacaoUsuarioDTO notificacaoUsuarioDto : listaIdUsuario) {
							if (notificacaoUsuarioDto.getIdUsuario() != null) {
								UsuarioDTO usuarioDtoNotificacao = new UsuarioDTO();
								usuarioDtoNotificacao.setIdUsuario(notificacaoUsuarioDto.getIdUsuario());
								usuarioDtoNotificacao = (UsuarioDTO) usuarioService.restore(usuarioDtoNotificacao);
								document.executeScript("addLinhaTabelaUsuarioNotificacao(" + usuarioDtoNotificacao.getIdUsuario() + ", '" + usuarioDtoNotificacao.getNomeUsuario() + "', " + false
										+ ");");
								document.executeScript("$('#tabelaUsuarioNotificacao').show()");
								document.executeScript("$('#gridUsuarioNotificacao').show()");
							}

						}
					}

					if (listaIdGrupo != null && !listaIdGrupo.isEmpty()) {
						for (NotificacaoGrupoDTO notificacaoGrupoDto : listaIdGrupo) {
							if (notificacaoGrupoDto.getIdGrupo() != null) {
								GrupoDTO grupoDtoNotificacao = new GrupoDTO();
								grupoDtoNotificacao.setIdGrupo(notificacaoGrupoDto.getIdGrupo());
								grupoDtoNotificacao = (GrupoDTO) grupoService.restore(grupoDtoNotificacao);
								document.executeScript("addLinhaTabelaGrupoNotificacao(" + grupoDtoNotificacao.getIdGrupo() + ", '" + grupoDtoNotificacao.getNome() + "', " + false + ");");
								document.executeScript("$('#tabelaGrupoNotificacao').show()");
								document.executeScript("$('#gridGrupoNotificacao').show()");
							}
						}
					}
					baseConhecimentoDto.setTituloNotificacao(notificacaoDto.getTitulo());
					baseConhecimentoDto.setTipoNotificacao(notificacaoDto.getTipoNotificacao());
				}

				HTMLForm form = document.getForm("formCadastroBaseConhecimento");
				form.clear();

				if (baseConhecimentoDto.getFaq() != null && StringUtils.equalsIgnoreCase(baseConhecimentoDto.getFaq().trim(), "S")) {
					document.executeScript("defineTipoDocumentoFAQ()");
				} else {
					if (baseConhecimentoDto.getErroConhecido() != null && baseConhecimentoDto.getErroConhecido().equalsIgnoreCase("S")) {
						document.executeScript("defineTipoDocumentoErroConhecido();");
					} else {
						document.executeScript("defineTipoDocumentoDocumento();");
					}
				}

				document.executeScript("uploadAnexos.clear()");
				document.executeScript("deleteAllRows()");

				this.restaurarAnexos(request, baseConhecimentoDto);

				if (request.getParameter("idProblema") != null && !request.getParameter("idProblema").equalsIgnoreCase("")) {
					baseConhecimentoDto.setIdProblema(Integer.parseInt(request.getParameter("idProblema")));
				}

				document.setBean(baseConhecimentoDto);

				atualizaItemConfiguracaoVinculados(document, request, response);

				form.setValues(baseConhecimentoDto);

				document.executeScript("setarValoresPopupNotificacao()");
				document.executeScript("deleteAllRowsUsuario()");
				document.executeScript("deleteAllRowsGrupo()");
				document.executeScript("deleteAllRowsConhecimento()");
				document.executeScript("$('#btnGravarNotificacao').show()");

				Collection<ImportanciaConhecimentoUsuarioDTO> listImportanciaConhecimentoUsuarioDto = importanciaConhecimentoUsuarioService.listByIdBaseConhecimento(baseConhecimentoDto
						.getIdBaseConhecimento());

				if (listImportanciaConhecimentoUsuarioDto != null && !listImportanciaConhecimentoUsuarioDto.isEmpty()) {

					for (ImportanciaConhecimentoUsuarioDTO importanciaConhecimentoUsuarioDTO : listImportanciaConhecimentoUsuarioDto) {

						if (importanciaConhecimentoUsuarioDTO.getIdUsuario() != null) {

							UsuarioDTO usuarioImportanciaConhecimento = new UsuarioDTO();
							usuarioImportanciaConhecimento.setIdUsuario(importanciaConhecimentoUsuarioDTO.getIdUsuario());
							usuarioImportanciaConhecimento = (UsuarioDTO) usuarioService.restore(usuarioImportanciaConhecimento);

							document.executeScript("addLinhaTabelaUsuario(" + usuarioImportanciaConhecimento.getIdUsuario() + ", '" + usuarioImportanciaConhecimento.getNomeUsuario() + "', " + false
									+ ");");
							document.executeScript("atribuirCheckedUsuario('" + importanciaConhecimentoUsuarioDTO.getGrauImportanciaUsuario() + "')");
							document.executeScript("exibirTabelaUsuario()");
						}
					}
				}

				Collection<ImportanciaConhecimentoGrupoDTO> listImportanciaConhecimentoGrupoDto = importanciaConhecimentoGrupoService.listByIdBaseConhecimento(baseConhecimentoDto
						.getIdBaseConhecimento());

				if (listImportanciaConhecimentoGrupoDto != null && !listImportanciaConhecimentoGrupoDto.isEmpty()) {

					for (ImportanciaConhecimentoGrupoDTO importanciaConhecimentoGrupoDTO : listImportanciaConhecimentoGrupoDto) {

						if (importanciaConhecimentoGrupoDTO.getIdGrupo() != null) {

							GrupoDTO grupoImportanciaConhecimento = new GrupoDTO();
							grupoImportanciaConhecimento.setIdGrupo(importanciaConhecimentoGrupoDTO.getIdGrupo());
							grupoImportanciaConhecimento = (GrupoDTO) grupoService.restore(grupoImportanciaConhecimento);

							document.executeScript("addLinhaTabelaGrupo(" + grupoImportanciaConhecimento.getIdGrupo() + ", '" + grupoImportanciaConhecimento.getNome() + "', " + false + ");");
							document.executeScript("atribuirCheckedGrupo('" + importanciaConhecimentoGrupoDTO.getGrauImportanciaGrupo() + "')");
						}

					}
				}

				Collection<BaseConhecimentoRelacionadoDTO> listBaseConhecimentoRelacionadoDto = baseConhecimentoRelacionadoService
						.listByIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento());
				if (listBaseConhecimentoRelacionadoDto == null) {
					listBaseConhecimentoRelacionadoDto = new ArrayList<BaseConhecimentoRelacionadoDTO>();
				}
				if (listBaseConhecimentoRelacionadoDto != null && !listBaseConhecimentoRelacionadoDto.isEmpty()) {

					for (BaseConhecimentoRelacionadoDTO baseConhecimentoRelacionadoDto : listBaseConhecimentoRelacionadoDto) {

						if (baseConhecimentoRelacionadoDto.getIdBaseConhecimentoRelacionado() != null) {

							BaseConhecimentoDTO conhecimentoRelacionadoDto = new BaseConhecimentoDTO();
							conhecimentoRelacionadoDto.setIdBaseConhecimento(baseConhecimentoRelacionadoDto.getIdBaseConhecimentoRelacionado());
							conhecimentoRelacionadoDto = (BaseConhecimentoDTO) baseConhecimentoService.restore(conhecimentoRelacionadoDto);

							document.executeScript("addLinhaTabelaConhecimentoRelacionado(" + conhecimentoRelacionadoDto.getIdBaseConhecimento() + ",'" + conhecimentoRelacionadoDto.getTitulo() + "',"
									+ true + ");");
						}
					}
				}
				Collection<BaseConhecimentoRelacionadoDTO> listBaseConhecimentoRelacionadoAux = baseConhecimentoRelacionadoService.listByIdBaseConhecimentoRelacionado(baseConhecimentoDto
						.getIdBaseConhecimento());
				if (listBaseConhecimentoRelacionadoAux != null && !listBaseConhecimentoRelacionadoAux.isEmpty()) {

					for (BaseConhecimentoRelacionadoDTO baseConhecimentoRelacionadoDto : listBaseConhecimentoRelacionadoAux) {

						if (baseConhecimentoRelacionadoDto.getIdBaseConhecimentoRelacionado() != null) {

							BaseConhecimentoDTO conhecimentoRelacionadoDto = new BaseConhecimentoDTO();
							conhecimentoRelacionadoDto.setIdBaseConhecimento(baseConhecimentoRelacionadoDto.getIdBaseConhecimento());
							conhecimentoRelacionadoDto = (BaseConhecimentoDTO) baseConhecimentoService.restore(conhecimentoRelacionadoDto);
							if (conhecimentoRelacionadoDto != null) {
								document.executeScript("addLinhaTabelaConhecimentoRelacionado(" + conhecimentoRelacionadoDto.getIdBaseConhecimento() + ",'" + conhecimentoRelacionadoDto.getTitulo()
										+ "'," + true + ");");
							}

						}
					}
				}

				document.executeScript("exibirBtnGravarImportancia()");
				document.executeScript("exibirBtnGravarConhecimentoRelacionado()");
				document.executeScript("uploadAnexos.refresh()");

				Collection<ComentariosDTO> comentarios = comentariosService.consultarComentarios(baseConhecimentoDto);

				if (comentarios != null && !comentarios.isEmpty()) {
					comentariosService.restaurarGridComentarios(document, comentarios);
				}

				if (baseConhecimentoDto.getStatus() != null && StringUtils.contains(baseConhecimentoDto.getStatus(), "S")) {
					document.executeScript("bloquearTitulo()");
				} else {
					if (baseConhecimentoDto.getStatus() != null && StringUtils.contains(baseConhecimentoDto.getStatus(), "N")
							&& baseConhecimentoService.verificarSeBaseConhecimentoPossuiVersaoAnterior(baseConhecimentoDto)) {
						document.executeScript("bloquearTitulo()");
					} else {
						document.executeScript("liberarTitulo()");
					}
				}

				if (baseConhecimentoDto.getArquivado() != null && StringUtils.equalsIgnoreCase(baseConhecimentoDto.getArquivado().trim(), "S")) {
					document.executeScript("exibirArquivado()");
					document.executeScript("exibirBotaoRestaurar()");
				}
				if (iframe == null || iframe.equals("")) {
					document.executeScript("setDataEditor()");
				}

				document.executeScript("$('#divSolicitacaoServico').show()");
				document.executeScript("$('#divMudanca').show()");
				document.executeScript("$('#divItemConfiguracao').show()");
				/*
				 * Removendo class que fora a margem do campo para 0px, afim de
				 * driblar condio do layout.
				 */
				document.executeScript("$('#divEvento').removeClass('ml0')");
				document.executeScript("$('#btnGravarEventoMonitConhecimento').show()");

				document.executeScript("$('#comboTipoConhecimento').val('".concat(baseConhecimentoDto.getTipoDocumento()).concat("');"));

			}
		}
	}

	/**
	 * Exclui Base conhecimento e todos os seus contedos.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author valdoilo.damasceno
	 */
	public void excluir(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		BaseConhecimentoDTO baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();

		UsuarioDTO usuarioDto = WebUtil.getUsuario(request);

		BaseConhecimentoService baseConhecimentoService = (BaseConhecimentoService) ServiceLocator.getInstance().getService(BaseConhecimentoService.class, null);

		boolean isAprovaBaseConhecimento = this.usuarioAprovaBaseConhecimento(usuarioDto, baseConhecimentoDto.getIdPasta());

		if (baseConhecimentoService.verificarSeBaseConhecimentoJaPossuiNovaVersao(baseConhecimentoDto)) {
			document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.versaorecente"));
			document.executeScript("fechar_aguarde();");
		} else {
			if (isAprovaBaseConhecimento) {
				baseConhecimentoService.excluir(baseConhecimentoDto, isAprovaBaseConhecimento);
				document.alert(UtilI18N.internacionaliza(request, "MSG07"));
				document.executeScript("fechar_aguarde();");
			} else {
				document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.usuarioSemPermissao"));
				document.executeScript("fechar_aguarde();");
			}
		}
		document.executeScript("fechar();");
		document.executeScript("limpar()");
		document.executeScript("fechar_aguarde();");

	}

	/**
	 * Grava Importncia Conhecimento.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
	@SuppressWarnings("unchecked")
	public void gravarImportanciaConhecimento(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		BaseConhecimentoDTO baseConhecimentoDto = new BaseConhecimentoDTO();

		baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();

		UsuarioDTO usuarioDto = WebUtil.getUsuario(request);

		PermissaoAcessoPasta permissao = this.obterPermissaoDeAcessoPasta(baseConhecimentoDto, usuarioDto);

		if (permissao != null) {

			if (PermissaoAcessoPasta.LEITURAGRAVACAO.equals(permissao)) {

				baseConhecimentoDto.setListImportanciaConhecimentoUsuario(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(
						ImportanciaConhecimentoUsuarioDTO.class, "listImportanciaConhecimentoUsuarioSerializado", request));

				baseConhecimentoDto.setListImportanciaConhecimentoGrupo(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(
						ImportanciaConhecimentoGrupoDTO.class, "listImportanciaConhecimentoGrupoSerializado", request));

				BaseConhecimentoService baseConhecimentoService = (BaseConhecimentoService) ServiceLocator.getInstance().getService(BaseConhecimentoService.class, null);

				baseConhecimentoService.criarImportanciaConhecimentoUsuario(baseConhecimentoDto, null);

				baseConhecimentoService.criarImportanciaConhecimentoGrupo(baseConhecimentoDto, null);

				document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.importanciaDefinida"));

			} else {
				document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.usuarioSemPermissao"));
			}

		} else {
			document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.usuarioSemPermissao"));
		}
		document.executeScript("fecharPopupGrauDeImportancia()");
	}

	/**
	 * Grava Conhecimento Relacionado.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
	@SuppressWarnings("unchecked")
	public void gravarConhecimentoRelacionado(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		BaseConhecimentoDTO baseConhecimentoDto = new BaseConhecimentoDTO();

		baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();

		UsuarioDTO usuarioDto = WebUtil.getUsuario(request);

		PermissaoAcessoPasta permissao = this.obterPermissaoDeAcessoPasta(baseConhecimentoDto, usuarioDto);

		if (permissao != null) {

			if (PermissaoAcessoPasta.LEITURAGRAVACAO.equals(permissao)) {
				baseConhecimentoDto.setListBaseConhecimentoRelacionado(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(
						BaseConhecimentoRelacionadoDTO.class, "listConhecimentoRelacionadoSerializado", request));

				BaseConhecimentoService baseConhecimentoService = (BaseConhecimentoService) ServiceLocator.getInstance().getService(BaseConhecimentoService.class, null);

				baseConhecimentoService.criarRelacionamentoEntreConhecimentos(baseConhecimentoDto, null);

				document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.conhecimentoRelacionadoSucesso"));

			} else {
				document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.usuarioSemPermissao"));
			}

		} else {
			document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.usuarioSemPermissao"));
		}
		document.executeScript("fecharPopupConhecimentoRelacionado()");
	}

	/**
	 * Restaura arquivos Anexos da Base de Conhecimento.
	 *
	 * @param request
	 * @throws ServiceException
	 * @throws Exception
	 * @author valdoilo.damasceno
	 */
	@SuppressWarnings("rawtypes")
	protected void restaurarAnexos(HttpServletRequest request, BaseConhecimentoDTO baseConhecimentoDto) throws ServiceException, Exception {

		ControleGEDService controleGedService = (ControleGEDService) ServiceLocator.getInstance().getService(ControleGEDService.class, null);


		Collection colAnexos = controleGedService.listByIdTabelaAndID(ControleGEDDTO.TABELA_BASECONHECIMENTO, baseConhecimentoDto.getIdBaseConhecimento());

		Collection<UploadDTO> colAnexosUploadDTO = controleGedService.convertListControleGEDToUploadDTO(colAnexos);

		if (colAnexosUploadDTO != null) {

			for (UploadDTO uploadDTO : colAnexosUploadDTO) {

				if (uploadDTO.getDescricao() == null) {
					uploadDTO.setDescricao("");
				}

			}
		}

		request.getSession(true).setAttribute("colUploadsGED", colAnexosUploadDTO);
	}

	/**
	 * Limpa Fomulrio e arquivos anexos.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author valdoilo.damasceno
	 */
	public void limpar(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		request.getSession(true).setAttribute("colUploadsGED", null);
		document.executeScript("uploadAnexos.clear()");
		request.setAttribute("limpar", "sim");
		this.load(document, request, response);
	}

	/**
	 * Verifica se Usurio Pode Aprovar Base de Conhecimento da pasta
	 * Selecionada.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @throws ServiceException
	 * @author valdoilo.damasceno
	 */
	public void verificarPermissoesDeAcesso(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException, Exception {
		BaseConhecimentoDTO baseConhecimentoDto = new BaseConhecimentoDTO();

		baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();

		UsuarioDTO usuarioDto = WebUtil.getUsuario(request);

		PerfilAcessoPastaService perfilAcessoPastaService = (PerfilAcessoPastaService) ServiceLocator.getInstance().getService(PerfilAcessoPastaService.class, null);

		boolean usuarioAprovaBaseConhecimento = perfilAcessoPastaService.verificarSeUsuarioAprovaBaseConhecimentoParaPastaSelecionada(usuarioDto, baseConhecimentoDto.getIdPasta());

		if (usuarioAprovaBaseConhecimento) {
			document.executeScript("$('#publicacao').show()");
		} else {
			document.getElementById("status").setValue("N");
			document.executeScript("$('#publicacao').hide()");
			document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.semPermissaoParaPublicar"));

		}

		this.aplicarPermissaoDeAcesso(document, request, baseConhecimentoDto, usuarioDto, false);
	}

	/**
	 * Oculta ou Exibe Botes Gravar, Limpar ou Excluir de Acordo com a
	 * permisso de Acesso do Usurio Logado.
	 *
	 * @param document
	 * @param baseConhecimentoDto
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
	private boolean aplicarPermissaoDeAcesso(DocumentHTML document, HttpServletRequest request, BaseConhecimentoDTO baseConhecimentoDto, UsuarioDTO usuarioDto, boolean isRestore) throws Exception {
		PerfilAcessoPastaService perfilAcessoPastaService = (PerfilAcessoPastaService) ServiceLocator.getInstance().getService(PerfilAcessoPastaService.class, null);

		PermissaoAcessoPasta permissao = obterPermissaoDeAcessoPasta(baseConhecimentoDto, usuarioDto);

		boolean usuarioAprovaBaseConhecimento = perfilAcessoPastaService.verificarSeUsuarioAprovaBaseConhecimentoParaPastaSelecionada(usuarioDto, baseConhecimentoDto.getIdPasta());

		if (permissao != null) {

			if (PermissaoAcessoPasta.SEMPERMISSAO.equals(permissao)) {
				document.executeScript("ocultarBotoes()");
				document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.usuarioSemPermissao"));
				document.executeScript("ocultarBtnGravarImportancia()");
				document.executeScript("ocultarBtnGravarConhecimentoRelacionado()");
				if (request.getParameter("iframe").equalsIgnoreCase("true")) {
					document.executeScript("desabilitaCamposFrame()");
				}
				return false;
			} else {

				if (PermissaoAcessoPasta.LEITURA.equals(permissao)) {
					document.executeScript("ocultarBotoes()");
					document.executeScript("ocultarDivPublicacao()");

					if (isRestore) {
						document.executeScript("desabilitarComboPasta()");
					}

					document.executeScript("ocultarBtnGravarImportancia()");
					document.executeScript("ocultarBtnGravarConhecimentoRelacionado()");

					document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.somenteLeitura"));
					if (request.getParameter("iframe") != null && request.getParameter("iframe").equalsIgnoreCase("true")) {
						document.executeScript("desabilitaCamposFrame()");
					}
				} else {

					if (PermissaoAcessoPasta.LEITURAGRAVACAO.equals(permissao)) {
						document.executeScript("exibirBotoes()");
						document.executeScript("habilitarComboPasta()");

						if (usuarioAprovaBaseConhecimento) {
							document.executeScript("$('#publicacao').show()");
						} else {
							document.executeScript("$('#publicacao').hide()");
						}

						if (baseConhecimentoDto.getArquivado() != null && StringUtils.equalsIgnoreCase(baseConhecimentoDto.getArquivado().trim(), "S")) {
							document.executeScript("ocultarBotaoArquivar()");
							document.executeScript("exibirBotaoRestaurar()");
						} else {
							document.executeScript("ocultarArquivado()");
							document.executeScript("exibirBotaoArquivar()");
							document.executeScript("ocultarBotaoRestaurar()");
						}
					}
				}
				return true;
			}

		} else {
			document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.usuarioSemPermissao"));
			return false;
		}
	}

	/**
	 * Retorna PermissaoAcessoPasta do Usurio  Pasta que est o conhecimento
	 * informado.
	 *
	 * @param baseConhecimentoDto
	 * @param usuarioDto
	 * @return PermissaoAcessoPasta
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
	public PermissaoAcessoPasta obterPermissaoDeAcessoPasta(BaseConhecimentoDTO baseConhecimentoDto, UsuarioDTO usuarioDto) throws Exception {
		PastaService pastaService = (PastaService) ServiceLocator.getInstance().getService(PastaService.class, null);
		PerfilAcessoPastaService perfilAcessoPastaService = (PerfilAcessoPastaService) ServiceLocator.getInstance().getService(PerfilAcessoPastaService.class, null);

		PastaDTO pastaDto = new PastaDTO();

		if (baseConhecimentoDto.getIdPasta() != null) {
			pastaDto.setId(baseConhecimentoDto.getIdPasta());
			pastaDto = (PastaDTO) pastaService.restore(pastaDto);

			return perfilAcessoPastaService.verificarPermissaoDeAcessoPasta(usuarioDto, pastaDto);
		}
		return null;
	}

	/**
	 * Carrega combo de Pastas de Acordo com Perfil de Acesso do Usurio Logado.
	 *
	 * @param document
	 * @param request
	 * @throws Exception
	 * @author Valdoilo Damasceno
	 */
	private void carregaComboPastasBaseConhecimento(DocumentHTML document, HttpServletRequest request) throws Exception {
		PastaService pastaService = (PastaService) ServiceLocator.getInstance().getService(PastaService.class, null);

		UsuarioDTO usuarioDto = WebUtil.getUsuario(request);
		HTMLSelect combo = document.getSelectById("comboPasta");
		inicializaCombo(combo, request);

		ArrayList<PastaDTO> listaPastaAux = (ArrayList<PastaDTO>) pastaService.listPastasESubpastas(usuarioDto);

		for (PastaDTO pasta : listaPastaAux) {
			if (pasta.getDataFim() == null) {
				combo.addOption(pasta.getId().toString(), pasta.getNomeNivel());
			}
		}
	}

	/**
	 * Carrega combo de Origem do conhecimento
	 *
	 * @param document
	 * @param request
	 * @throws Exception
	 * @author rodrigo.oliveira
	 */
	private void carregaComboOrigem(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("comboOrigem");
		inicializaCombo(combo, request);

		combo.addOption(BaseConhecimentoDTO.CONHECIMENTO.toString(), UtilI18N.internacionaliza(request, "baseConhecimento.conhecimento"));
		combo.addOption(BaseConhecimentoDTO.EVENTO.toString(), UtilI18N.internacionaliza(request, "justificacaoFalhas.evento"));
		combo.addOption(BaseConhecimentoDTO.MUDANCA.toString(), UtilI18N.internacionaliza(request, "requisicaMudanca.mudanca"));
		combo.addOption(BaseConhecimentoDTO.INCIDENTE.toString(), UtilI18N.internacionaliza(request, "solicitacaoServico.incidente"));
		combo.addOption(BaseConhecimentoDTO.SERVICO.toString(), UtilI18N.internacionaliza(request, "servico.servico"));
		combo.addOption(BaseConhecimentoDTO.PROBLEMA.toString(), UtilI18N.internacionaliza(request, "problema.problema"));
	}

	/**
	 * Preenche Combo Privacidade.
	 *
	 * @param document
	 * @param request
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
	private void carregaComboPrivacidade(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect comboPrivacidade = document.getSelectById("comboPrivacidade");
		comboPrivacidade.removeAllOptions();

		comboPrivacidade.addOption(BaseConhecimentoDTO.CONFIDENCIAL.toString(), UtilI18N.internacionaliza(request, "baseconhecimento.privacidade.confidencial"));
		comboPrivacidade.addOption(BaseConhecimentoDTO.PUBLICO.toString(), UtilI18N.internacionaliza(request, "baseconhecimento.privacidade.publico"));
		comboPrivacidade.addOption(BaseConhecimentoDTO.INTERNO.toString(), UtilI18N.internacionaliza(request, "baseconhecimento.privacidade.interno"));
	}

	/**
	 * Preenche combo situao.
	 *
	 * @param document
	 * @param request
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
	private void carregaComboSituacao(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect comboPrivacidade = document.getSelectById("comboSituacao");
		comboPrivacidade.removeAllOptions();

		comboPrivacidade.addOption(BaseConhecimentoDTO.EMDESENHO.toString(), UtilI18N.internacionaliza(request, "baseconhecimento.emdesenho"));
		comboPrivacidade.addOption(BaseConhecimentoDTO.EMREVISAO.toString(), UtilI18N.internacionaliza(request, "baseconhecimento.emrevisao"));
		comboPrivacidade.addOption(BaseConhecimentoDTO.REVISADO.toString(), UtilI18N.internacionaliza(request, "baseconhecimento.revisado"));
		comboPrivacidade.addOption(BaseConhecimentoDTO.EMAVALIACAO.toString(), UtilI18N.internacionaliza(request, "baseconhecimento.emavaliacao"));
		comboPrivacidade.addOption(BaseConhecimentoDTO.AVALIADO.toString(), UtilI18N.internacionaliza(request, "baseconhecimento.avaliado"));
	}

	/**
	 * Verifica se usurio aprova Base Conhecimento na pasta selecionada.
	 *
	 * @param usuarioDto
	 * @param idPasta
	 * @return true = aprova; false = no aprova.
	 * @throws ServiceException
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
	private boolean usuarioAprovaBaseConhecimento(UsuarioDTO usuarioDto, Integer idPasta) throws ServiceException, Exception {
		boolean aprovaBaseConhecimento = false;

		PerfilAcessoPastaService perfilAcessoPastaService = (PerfilAcessoPastaService) ServiceLocator.getInstance().getService(PerfilAcessoPastaService.class, null);

		aprovaBaseConhecimento = perfilAcessoPastaService.verificarSeUsuarioAprovaBaseConhecimentoParaPastaSelecionada(usuarioDto, idPasta);

		return aprovaBaseConhecimento;
	}

	public void verificarNotificacoes(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException, Exception {
		BaseConhecimentoDTO baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();

		BaseConhecimentoService baseConhecimentoService = (BaseConhecimentoService) ServiceLocator.getInstance().getService(BaseConhecimentoService.class, null);

		if (baseConhecimentoDto.getIdBaseConhecimento() != null) {

			baseConhecimentoDto = (BaseConhecimentoDTO) baseConhecimentoService.restore(baseConhecimentoDto);

			if (baseConhecimentoDto.getIdNotificacao() != null) {

				Notificacao notificacao = new Notificacao();

				NotificacaoDTO notificacaoDto = new NotificacaoDTO();

				notificacaoDto.setIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento());
				notificacaoDto.setIdNotificacao(baseConhecimentoDto.getIdNotificacao());

				DocumentHTML documentNotificacao = document;

				documentNotificacao.setBean(notificacaoDto);

				notificacao.restore(documentNotificacao, request, response);
			}
		}
	}

	/**
	 * Verifica se usurio possui acesso ao Conhecimento que est tentanto
	 * relacionar.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws ServiceException
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
	public void validarRelacionamentoConhecimento(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException, Exception {

		BaseConhecimentoDTO baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();

		UsuarioDTO usuarioDto = WebUtil.getUsuario(request);

		BaseConhecimentoService baseConhecimentoService = (BaseConhecimentoService) ServiceLocator.getInstance().getService(BaseConhecimentoService.class, null);

		if (baseConhecimentoDto.getIdConhecimentoRelacionado() != null) {

			baseConhecimentoDto.setIdBaseConhecimento(baseConhecimentoDto.getIdConhecimentoRelacionado());
			baseConhecimentoDto = (BaseConhecimentoDTO) baseConhecimentoService.restore(baseConhecimentoDto);

			PermissaoAcessoPasta permissao = this.obterPermissaoDeAcessoPasta(baseConhecimentoDto, usuarioDto);

			if (permissao != null && (permissao.equals(PermissaoAcessoPasta.LEITURA) || permissao.equals(PermissaoAcessoPasta.LEITURAGRAVACAO))) {
				document.executeScript("addLinhaTabelaConhecimentoRelacionado(" + baseConhecimentoDto.getIdBaseConhecimento() + ",'" + baseConhecimentoDto.getTitulo() + "'," + true + ");");
			} else {
				document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.usuarioSemPermissao"));
			}
		}
	}

	@Override
	public Class<BaseConhecimentoDTO> getBeanClass() {
		return BaseConhecimentoDTO.class;
	}

	/**
	 * @return valor do atributo idPrimeiraPasta.
	 */
	public Integer getIdPrimeiraPasta() {
		return idPrimeiraPasta;
	}

	/**
	 * Define valor do atributo idPrimeiraPasta.
	 *
	 * @param idPrimeiraPasta
	 */
	public void setIdPrimeiraPasta(Integer idPrimeiraPasta) {
		this.idPrimeiraPasta = idPrimeiraPasta;
	}

	/**
	 * Preenche combo de Notificaes.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author Thays
	 */
	public void preencherComboNotificacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect comboTipoNotificacao = document.getSelectById("tipo");
		inicializaCombo(comboTipoNotificacao, request);

		for (Enumerados.TipoNotificacao tipoNotificacao : Enumerados.TipoNotificacao.values()) {
			comboTipoNotificacao.addOption(tipoNotificacao.getTipoNotificacao(), UtilI18N.internacionaliza(request, tipoNotificacao.getDescricao()));
		}

		/*
		 * comboTipoNotificacao.addOption("T", "Tudo for alterado");
		 * comboTipoNotificacao.addOption("C",
		 * "Novas nofiticaes for adicionadas");
		 * comboTipoNotificacao.addOption("A", "Notificaes forem alteradas");
		 * comboTipoNotificacao.addOption("E", "Notificaes forem excluidas");
		 */

	}

	/**
	 * Inicializa combo.
	 *
	 * @param componenteCombo
	 * @param request
	 * @author Vadoilo Damasceno
	 */
	private void inicializaCombo(HTMLSelect componenteCombo, HttpServletRequest request) {
		componenteCombo.removeAllOptions();
		componenteCombo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
	}

	/**
	 * Restorna String com a Label Confidencial caso o usurio no possua
	 * Permisso de Acesso a Pasta ou a Base de Conhecimento.
	 *
	 * @param idPasta
	 * @param pastaBaseConhecimento
	 * @param usuarioDto
	 * @return String
	 * @throws ServiceException
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
	public String obterStatusPermissao(HttpServletRequest request, PastaDTO pastaDto, String pastaBaseConhecimento, UsuarioDTO usuarioDto) throws ServiceException, Exception {

		PerfilAcessoPastaService perfilAcessoPastaService = (PerfilAcessoPastaService) ServiceLocator.getInstance().getService(PerfilAcessoPastaService.class, null);

		PermissaoAcessoPasta permissao = null;

		permissao = perfilAcessoPastaService.verificarPermissaoDeAcessoPasta(usuarioDto, pastaDto);

		if (permissao != null) {
			if (PermissaoAcessoPasta.SEMPERMISSAO.equals(permissao)) {
				return "" + pastaBaseConhecimento + " - " + UtilI18N.internacionaliza(request, "baseconhecimento.permissao.sempermissao");
			} else {
				return "" + pastaBaseConhecimento + " ";
			}
		} else {
			return "" + pastaBaseConhecimento + " - " + UtilI18N.internacionaliza(request, "baseconhecimento.permissao.sempermissao");
		}
	}

	/**
	 * Cria Notificao.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author Thays
	 */
	@SuppressWarnings("unchecked")
	public void gravarNotificacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		BaseConhecimentoDTO baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();

		UsuarioDTO usuarioDto = WebUtil.getUsuario(request);

		NotificacaoDTO notificacaoDto = new NotificacaoDTO();

		baseConhecimentoDto.setListaDeUsuarioNotificacao((ArrayList<NotificacaoUsuarioDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(NotificacaoUsuarioDTO.class,
				"listUsuariosNotificacaoSerializados", request));

		baseConhecimentoDto.setListaDeGrupoNotificacao((ArrayList<NotificacaoGrupoDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(NotificacaoGrupoDTO.class,
				"listGruposNotificacaoSerializados", request));

		BaseConhecimentoService baseConhecimentoService = (BaseConhecimentoService) ServiceLocator.getInstance().getService(BaseConhecimentoService.class, null);

		PermissaoAcessoPasta permissao = this.obterPermissaoDeAcessoPasta(baseConhecimentoDto, usuarioDto);

		if (baseConhecimentoDto.getIdBaseConhecimento() != null) {

			if (permissao != null) {

				if (PermissaoAcessoPasta.LEITURAGRAVACAO.equals(permissao)) {

					if (baseConhecimentoDto.getIdNotificacao() != null) {

						if (baseConhecimentoDto.getTituloNotificacao() != null && !baseConhecimentoDto.getTituloNotificacao().equalsIgnoreCase("")) {
							notificacaoDto.setTitulo(baseConhecimentoDto.getTitulo());
						} else {
							document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.tituloObrigatorio"));
							return;
						}

						if (baseConhecimentoDto.getTipoNotificacao() != null && !baseConhecimentoDto.getTipoNotificacao().equalsIgnoreCase("")) {
							notificacaoDto.setTipoNotificacao(baseConhecimentoDto.getTipoNotificacao());
						} else {
							document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.tipoNotificacaoObrigatorio"));
							return;
						}

						baseConhecimentoService.criarNotificacao(baseConhecimentoDto, null);

						document.alert(UtilI18N.internacionaliza(request, "MSG06"));

						document.executeScript("limpar_LOOKUP_BASECONHECIMENTO()");
					} else {

						if (baseConhecimentoDto.getTituloNotificacao() != null && !baseConhecimentoDto.getTituloNotificacao().equalsIgnoreCase("")) {
							notificacaoDto.setTitulo(baseConhecimentoDto.getTitulo());
						} else {
							document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.tituloObrigatorio"));
							return;
						}

						if (baseConhecimentoDto.getTipoNotificacao() != null && !baseConhecimentoDto.getTipoNotificacao().equalsIgnoreCase("")) {
							notificacaoDto.setTipoNotificacao(baseConhecimentoDto.getTipoNotificacao());
						} else {
							document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.tipoNotificacaoObrigatorio"));
							return;
						}

						notificacaoDto = baseConhecimentoService.criarNotificacao(baseConhecimentoDto, null);

						baseConhecimentoDto.setIdNotificacao(notificacaoDto.getIdNotificacao());

						baseConhecimentoService.update(baseConhecimentoDto);

						document.alert(UtilI18N.internacionaliza(request, "MSG05"));

						document.executeScript("limpar_LOOKUP_BASECONHECIMENTO()");
					}

				} else {
					document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.usuarioSemPermissao"));
				}

			} else {
				document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.usuarioSemPermissao"));
			}
		}
	}

	/**
	 * Arquiva Documento da Base de Conhecimento.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
	public void arquivarConhecimento(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		BaseConhecimentoDTO baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();

		BaseConhecimentoService baseConhecimentoService = (BaseConhecimentoService) ServiceLocator.getInstance().getService(BaseConhecimentoService.class, null);

		if (baseConhecimentoDto.getIdBaseConhecimento() != null) {
			baseConhecimentoService.arquivarConhecimento(baseConhecimentoDto);

			document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.documentoArquivado"));

			document.executeScript("limpar()");
			document.executeScript("ocultarBotaoArquivar()");
		}
	}

	/**
	 * Restaura Conhecimento Arquivado da Base de Conhecimento.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
	public void restaurarConhecimento(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		BaseConhecimentoDTO baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();

		BaseConhecimentoService baseConhecimentoService = (BaseConhecimentoService) ServiceLocator.getInstance().getService(BaseConhecimentoService.class, null);

		if (baseConhecimentoDto.getIdBaseConhecimento() != null) {

			baseConhecimentoService.restaurarConhecimento(baseConhecimentoDto);

			document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.documentoRestaurado"));

			document.executeScript("limpar()");
			document.executeScript("ocultarBotaoRestaurar()");
			document.executeScript("exibirBotaoArquivar()");
		}
	}

	/**
	 * Retorna privacidade de Acordo com a sua abreviao.
	 *
	 * @param abreviacaoPrivacidade
	 * @return Privacidade
	 * @author Vadoilo Damasceno
	 */
	public String getPrivacidade(HttpServletRequest request, String abreviacaoPrivacidade) {

		if (abreviacaoPrivacidade != null && !StringUtils.isEmpty(abreviacaoPrivacidade)) {
			if (StringUtils.equalsIgnoreCase(BaseConhecimentoDTO.CONFIDENCIAL, abreviacaoPrivacidade)) {
				return UtilI18N.internacionaliza(request, "baseconhecimento.privacidade.confidencial");
			} else {
				if (StringUtils.equalsIgnoreCase(BaseConhecimentoDTO.PUBLICO, abreviacaoPrivacidade)) {
					return UtilI18N.internacionaliza(request, "baseconhecimento.privacidade.publico");
				} else {
					if (StringUtils.equalsIgnoreCase(BaseConhecimentoDTO.INTERNO, abreviacaoPrivacidade)) {
						return UtilI18N.internacionaliza(request, "baseconhecimento.privacidade.interno");
					}
				}
			}
		}
		return "";
	}

	/**
	 * Retorna Grau de Importncia.
	 *
	 * @param request
	 * @param importancia
	 * @return String
	 * @author Vadoilo Damasceno
	 */
	public String getGrauImportancia(HttpServletRequest request, Integer importancia) {

		if (importancia != null) {
			if (importancia == 1) {
				return " - " + UtilI18N.internacionaliza(request, "baseconhecimento.importancia") + ": " + UtilI18N.internacionaliza(request, "baseconhecimento.grauimportancia.baixo");
			} else {
				if (importancia == 2) {
					return " - " + UtilI18N.internacionaliza(request, "baseconhecimento.importancia") + ": " + UtilI18N.internacionaliza(request, "baseconhecimento.grauimportancia.medio");
				} else {
					if (importancia == 3) {
						return " - " + UtilI18N.internacionaliza(request, "baseconhecimento.importancia") + ": " + UtilI18N.internacionaliza(request, "baseconhecimento.grauimportancia.alto");
					}
				}
			}
		}
		return "";
	}

	/**
	 * Restaura item configurao na Grid.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
	public void restoreItemConfiguracao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		BaseConhecimentoDTO baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();
		ItemConfiguracaoDTO itemConfiguracaoDTO = new ItemConfiguracaoDTO();

		ItemConfiguracaoService itemConfiguracaoService = (ItemConfiguracaoService) ServiceLocator.getInstance().getService(ItemConfiguracaoService.class, null);

		itemConfiguracaoDTO.setIdItemConfiguracao(baseConhecimentoDto.getIdItemConfiguracao());
		itemConfiguracaoDTO = (ItemConfiguracaoDTO) itemConfiguracaoService.restore(itemConfiguracaoDTO);

		HTMLTable tabelaItemConfiguracao = document.getTableById("tblIC");

		if (itemConfiguracaoDTO.getSequenciaIC() == null) {

			tabelaItemConfiguracao.addRow(itemConfiguracaoDTO, new String[] { "", "idItemConfiguracao", "identificacao", "" }, new String[] { "idItemConfiguracao" },
					UtilI18N.internacionaliza(request, "baseConhecimento.itemExiste"), new String[] { "exibeIconesIC" }, null, null);
		} else {

			tabelaItemConfiguracao.updateRow(itemConfiguracaoDTO, new String[] { "", "idItemConfiguracao", "identificacao", "" }, new String[] { "idItemConfiguracao" },
					UtilI18N.internacionaliza(request, "baseConhecimento.itemExiste"), new String[] { "exibeIconesIC" }, null, null, itemConfiguracaoDTO.getSequenciaIC());
		}

		document.executeScript("HTMLUtils.applyStyleClassInAllCells('tblIC', 'tblIC');");
		document.executeScript("fecharPopupPesquisaItemCfg()");
	}

	/**
	 * Restura solicitao servio na Grid.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
	public void atualizaGridSolicitacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		BaseConhecimentoDTO baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();

		SolicitacaoServicoService solicitacaoServicoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, null);
		ServicoContratoService servicoContratoService = (ServicoContratoService) ServiceLocator.getInstance().getService(ServicoContratoService.class, null);
		ServicoService servicoService = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);

		SolicitacaoServicoDTO solicitacaoServicoDto = new SolicitacaoServicoDTO();
		ServicoContratoDTO servicoContratoDto = new ServicoContratoDTO();
		ServicoDTO servicoDto = new ServicoDTO();

		solicitacaoServicoDto.setIdSolicitacaoServico(baseConhecimentoDto.getIdSolicitacaoServico());

		solicitacaoServicoDto = (SolicitacaoServicoDTO) solicitacaoServicoService.restore(solicitacaoServicoDto);

		servicoContratoDto.setIdServicoContrato(solicitacaoServicoDto.getIdServicoContrato());

		servicoContratoDto = (ServicoContratoDTO) servicoContratoService.restore(servicoContratoDto);

		servicoDto.setIdServico(servicoContratoDto.getIdServico());

		servicoDto = (ServicoDTO) servicoService.restore(servicoDto);

		solicitacaoServicoDto.setNomeServico(servicoDto.getNomeServico());

		HTMLTable tblSolicitacao = document.getTableById("tblSolicitacao");

		if (solicitacaoServicoDto.getSequenciaSolicitacao() == null) {
			tblSolicitacao.addRow(solicitacaoServicoDto, new String[] { "", "", "idSolicitacaoServico", "nomeServico" }, new String[] { "idSolicitacaoServico" },
					UtilI18N.internacionaliza(request, "baseConhecimento.solicitacaoExiste"), new String[] { "exibeIconesSolicitacao" }, null, null);
		} else {
			tblSolicitacao.updateRow(solicitacaoServicoDto, new String[] { "", "", "idSolicitacaoServico", "nomeServico" }, new String[] { "idSolicitacaoServico" },
					UtilI18N.internacionaliza(request, "baseConhecimento.solicitacaoExiste"), new String[] { "exibeIconesSolicitacao" }, null, null, solicitacaoServicoDto.getSequenciaSolicitacao());
		}
		document.executeScript("HTMLUtils.applyStyleClassInAllCells('tblSolicitacao', 'tblSolicitacao');");
		document.executeScript("fecharSolicitacaoServico();");
	}

	/**
	 * Restaura Problemas na Grid.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
	public void atualizaGridProblema(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		BaseConhecimentoDTO baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();
		ProblemaService problemaService = (ProblemaService) ServiceLocator.getInstance().getService(ProblemaService.class, null);
		ProblemaDTO problemaDTO = new ProblemaDTO();

		problemaDTO.setIdProblema(baseConhecimentoDto.getIdProblema());

		problemaDTO = (ProblemaDTO) problemaService.restore(problemaDTO);
		HTMLTable tblProblema = document.getTableById("tblProblema");

		if (problemaDTO != null) {
			if (problemaDTO.getSequenciaProblema() == null) {
				tblProblema.addRow(problemaDTO, new String[] { "", "", "titulo", "status" }, new String[] { "idProblema" }, UtilI18N.internacionaliza(request, "baseConhecimento.problemaExiste"),
						new String[] { "exibeIconesProblema" }, null, null);
			} else {
				tblProblema.updateRow(problemaDTO, new String[] { "", "", "titulo", "status" }, new String[] { "idProblema" }, UtilI18N.internacionaliza(request, "baseConhecimento.problemaExiste"),
						new String[] { "exibeIconesProblema" }, null, null, problemaDTO.getSequenciaProblema());
			}
		}

		document.executeScript("HTMLUtils.applyStyleClassInAllCells('tblProblema', 'tblProblema');");
		document.executeScript("fecharProblema();");
	}

	/**
	 * Restaura Mudanas na Grid.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
	public void atualizaGridMudanca(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		BaseConhecimentoDTO baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();

		RequisicaoMudancaService requisicaoMudancaService = (RequisicaoMudancaService) ServiceLocator.getInstance().getService(RequisicaoMudancaService.class, null);
		RequisicaoMudancaDTO requisicaoMudancaDTO = new RequisicaoMudancaDTO();

		requisicaoMudancaDTO.setIdRequisicaoMudanca(baseConhecimentoDto.getIdRequisicaoMudanca());

		requisicaoMudancaDTO = (RequisicaoMudancaDTO) requisicaoMudancaService.restore(requisicaoMudancaDTO);

		HTMLTable tblMudanca = document.getTableById("tblMudanca");

		if (requisicaoMudancaDTO.getSequenciaMudanca() == null) {
			tblMudanca.addRow(requisicaoMudancaDTO, new String[] { "", "", "titulo", "status" }, new String[] { "idRequisicaoMudanca" },
					UtilI18N.internacionaliza(request, "baseConhecimento.mudancaExiste"), new String[] { "exibeIconesMudanca" }, null, null);
		} else {
			tblMudanca.updateRow(requisicaoMudancaDTO, new String[] { "", "", "titulo", "status" }, new String[] { "idRequisicaoMudanca" },
					UtilI18N.internacionaliza(request, "baseConhecimento.mudancaExiste"), new String[] { "exibeIconesMudanca" }, null, null, requisicaoMudancaDTO.getSequenciaMudanca());
		}
		document.executeScript("HTMLUtils.applyStyleClassInAllCells('tblMudanca', 'tblMudanca');");
		document.executeScript("fecharMudancaAtualizaGrid();");
	}

	/**
	 * Restaura Liberaes na Grid.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author murilo.pacheco
	 */
	public void atualizaGridLiberacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		BaseConhecimentoDTO baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();

		RequisicaoLiberacaoService requisicaoLiberacaoService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, null);

		RequisicaoLiberacaoDTO requisicaoLiberacaoDTO = new RequisicaoLiberacaoDTO();

		requisicaoLiberacaoDTO.setIdRequisicaoLiberacao(baseConhecimentoDto.getIdRequisicaoLiberacao());

		requisicaoLiberacaoDTO = (RequisicaoLiberacaoDTO) requisicaoLiberacaoService.restore(requisicaoLiberacaoDTO);

		HTMLTable tblMudanca = document.getTableById("tblLiberacao");

		if (requisicaoLiberacaoDTO.getSeqReabertura() == null) {
			tblMudanca.addRow(requisicaoLiberacaoDTO, new String[] { "", "", "titulo", "status" }, new String[] { "idRequisicaoLiberacao" },
					UtilI18N.internacionaliza(request, "baseConhecimento.liberacaoExiste"), new String[] { "exibeIconesLiberacao" }, null, null);
		} else {
			tblMudanca.updateRow(requisicaoLiberacaoDTO, new String[] { "", "", "titulo", "status" }, new String[] { "idRequisicaoLiberacao" },
					UtilI18N.internacionaliza(request, "baseConhecimento.liberacaoExiste"), new String[] { "exibeIconesLiberacao" }, null, null, requisicaoLiberacaoDTO.getIdRequisicaoLiberacao());
		}
		document.executeScript("HTMLUtils.applyStyleClassInAllCells('tblLiberacao', 'tblLiberacao');");
		document.executeScript("fecharLiberacao();");
	}

	/**
	 * Associa solicitaes ao documento.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
	@SuppressWarnings("unchecked")
	public void gravarSolicitacoesConhecimento(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		BaseConhecimentoService baseConhecimentoService = (BaseConhecimentoService) ServiceLocator.getInstance().getService(BaseConhecimentoService.class, WebUtil.getUsuarioSistema(request));
		BaseConhecimentoDTO baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();
		List<SolicitacaoServicoDTO> colItensINC_Serialize = (List<SolicitacaoServicoDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(SolicitacaoServicoDTO.class,
				"colItensINC_Serialize", request);
		baseConhecimentoDto.setColItensIncidentes(colItensINC_Serialize);
		baseConhecimentoService.gravarSolicitacoesConhecimento(baseConhecimentoDto);
		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
		document.alert(UtilI18N.internacionaliza(request, "MSG05"));
	}

	/**
	 * Associa problemas ao documento.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
	@SuppressWarnings("unchecked")
	public void gravarProblemasConhecimento(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		BaseConhecimentoService baseConhecimentoService = (BaseConhecimentoService) ServiceLocator.getInstance().getService(BaseConhecimentoService.class, WebUtil.getUsuarioSistema(request));
		BaseConhecimentoDTO baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();
		List<ProblemaDTO> colItensProblema_Serialize = (List<ProblemaDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(ProblemaDTO.class, "colItensProblema_Serialize", request);
		baseConhecimentoDto.setColItensProblema(colItensProblema_Serialize);
		baseConhecimentoService.gravarProblemasConhecimento(baseConhecimentoDto);
		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
		document.alert(UtilI18N.internacionaliza(request, "MSG05"));
	}

	/**
	 * Associa mudanas ao documento.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
	@SuppressWarnings("unchecked")
	public void gravarMudancaConhecimento(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		BaseConhecimentoService baseConhecimentoService = (BaseConhecimentoService) ServiceLocator.getInstance().getService(BaseConhecimentoService.class, WebUtil.getUsuarioSistema(request));
		BaseConhecimentoDTO baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();
		List<RequisicaoMudancaDTO> colItensMudanca_Serialize = (List<RequisicaoMudancaDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(RequisicaoMudancaDTO.class,
				"colItensMudanca_Serialize", request);
		baseConhecimentoDto.setColItensMudanca(colItensMudanca_Serialize);
		baseConhecimentoService.gravarMudancaConhecimento(baseConhecimentoDto);
		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
		document.alert(UtilI18N.internacionaliza(request, "MSG05"));
	}

	/**
	 * Associa Liberaoes ao documento.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author murilo.pacheco
	 */
	@SuppressWarnings("unchecked")
	public void gravarLiberacaoConhecimento(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		BaseConhecimentoService baseConhecimentoService = (BaseConhecimentoService) ServiceLocator.getInstance().getService(BaseConhecimentoService.class, WebUtil.getUsuarioSistema(request));
		BaseConhecimentoDTO baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();
		List<RequisicaoLiberacaoDTO> colItensLiberacao_Serialize = (List<RequisicaoLiberacaoDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(RequisicaoLiberacaoDTO.class,
				"colItensLiberacao_Serialize", request);
		baseConhecimentoDto.setColItensLiberacao(colItensLiberacao_Serialize);
		baseConhecimentoService.gravarLiberacaoConhecimento(baseConhecimentoDto);
		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
		document.alert(UtilI18N.internacionaliza(request, "MSG05"));
	}

	/**
	 * Associa itens configurao ao documento.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author Vadoilo Damasceno
	 */
	@SuppressWarnings("unchecked")
	public void gravarICConhecimento(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		BaseConhecimentoService baseConhecimentoService = (BaseConhecimentoService) ServiceLocator.getInstance().getService(BaseConhecimentoService.class, WebUtil.getUsuarioSistema(request));
		BaseConhecimentoDTO baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();
		List<ItemConfiguracaoDTO> colItensIC = (List<ItemConfiguracaoDTO>) br.com.citframework.util.WebUtil
				.deserializeCollectionFromRequest(ItemConfiguracaoDTO.class, "colItensIC_Serialize", request);
		baseConhecimentoDto.setColItensICSerialize(colItensIC);
		baseConhecimentoService.gravarICConhecimento(baseConhecimentoDto);
		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
		document.alert(UtilI18N.internacionaliza(request, "MSG05"));
	}

	private ProblemaDTO getProblemaDto(Integer idProblema) throws Exception {
		ProblemaService problemaService = (ProblemaService) ServiceLocator.getInstance().getService(ProblemaService.class, null);

		ProblemaDTO problemaDto = new ProblemaDTO();

		if (idProblema != null) {
			problemaDto.setIdProblema(idProblema);
			problemaDto = (ProblemaDTO) problemaService.restore(problemaDto);
		}

		return problemaDto;
	}

	public void atualizaItemConfiguracaoVinculados(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		BaseConhecimentoDTO baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();

		Collection<ConhecimentoICDTO> colConhecimentoICDTO = getConhecimentoICService().findByIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento());

		StringBuilder html = new StringBuilder();
		html.append("<table class='dynamicTable table  table-bordered table-condensed dataTable' id='tbRetorno' width='98%'  >");
		html.append("<tr>");
		html.append("<th style=\"width: 5%;\">&nbsp;</th>");
		html.append("<th>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.identificacao")).append("</th>");
		html.append("<th>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.nome")).append("</th>");
		html.append("</tr>");

		if(colConhecimentoICDTO != null){
			for (final ConhecimentoICDTO conhecimentoICDTO : colConhecimentoICDTO) {

				ItemConfiguracaoDTO itemConfiguracaoDTO = new ItemConfiguracaoDTO();
				itemConfiguracaoDTO.setIdItemConfiguracao(conhecimentoICDTO.getIdItemConfiguracao());
				itemConfiguracaoDTO = (ItemConfiguracaoDTO) getItemConfiguracaoService().restore(itemConfiguracaoDTO);

				html.append("<tr>");
				html.append("<td>");
				html.append("<img style=\"cursor: pointer;\" ");
				html.append("     title=\"").append(UtilI18N.internacionaliza(request, "citcorpore.comum.cliquaParaExcluir")).append("\" ");
				html.append("     src=\"" + br.com.citframework.util.Constantes.getValue("CONTEXTO_APLICACAO") + "/imagens/delete.png\" ");
				html.append("     onclick=\"excluiVinculacaoItemConfiguracao('").append(itemConfiguracaoDTO.getIdItemConfiguracao()).append("');\">");
				html.append("</td>");

				html.append("<td>").append(itemConfiguracaoDTO.getIdentificacao()).append("</td>");
				html.append("<td>").append(itemConfiguracaoDTO.getNome()).append("</td>");

				html.append("</tr>");
			}
		}
		html.append("</table>");
		HTMLTable tabelaItemConfiguracao = document.getTableById("tabelaItemConfiguracao");
		tabelaItemConfiguracao.setInnerHTML(html.toString());

		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
	}

	public void gravarRelacionamentoItemConfiguracao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if(!WebUtil.validarSeUsuarioEstaNaSessao(request, document)){
			return;
		}
		document.getJanelaPopupById("JANELA_AGUARDE_MENU").show();

		BaseConhecimentoDTO baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();

		Collection<ConhecimentoICDTO> colConhecimentoICDTO = getConhecimentoICService().findByidItemConfiguracaoAndIdBaseConhecimento(
				baseConhecimentoDto.getIdItemConfiguracao(), baseConhecimentoDto.getIdBaseConhecimento());

		if(colConhecimentoICDTO == null || colConhecimentoICDTO.isEmpty()){
			ConhecimentoICDTO conhecimentoICDTO = new ConhecimentoICDTO();
			conhecimentoICDTO.setIdBaseConhecimento(baseConhecimentoDto.getIdBaseConhecimento());
			conhecimentoICDTO.setIdItemConfiguracao(baseConhecimentoDto.getIdItemConfiguracao());
			getConhecimentoICService().create(conhecimentoICDTO);
			document.executeScript("notificacaoI18N('MSG18');");
			document.executeScript("$('#POPUP_ITEM_CONFIGURACAO').dialog('close');");
			atualizaItemConfiguracaoVinculados(document, request, response);
		} else {
			document.executeScript("notificacaoErro('baseConhecimento.itemConfiguracaoJaVinculado');");
		}

		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();

	}

	public void deletarRelacionamentoItemConfiguracao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if(!WebUtil.validarSeUsuarioEstaNaSessao(request, document)){
			return;
		}
		document.getJanelaPopupById("JANELA_AGUARDE_MENU").show();

		BaseConhecimentoDTO baseConhecimentoDto = (BaseConhecimentoDTO) document.getBean();

		getConhecimentoICService().deleteByIdBaseConhecimentoAndIdItemConfiguracao(baseConhecimentoDto.getIdBaseConhecimento(), baseConhecimentoDto.getIdItemConfiguracao());

		document.executeScript("notificacaoI18N('MSG18');");
		atualizaItemConfiguracaoVinculados(document, request, response);

		document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();

	}

	private ConhecimentoICService getConhecimentoICService() throws ServiceException {
		if(conhecimentoICService == null) {
			conhecimentoICService = (ConhecimentoICService) ServiceLocator.getInstance().getService(ConhecimentoICService.class, null);
		}
		return conhecimentoICService;
	}

	private ItemConfiguracaoService getItemConfiguracaoService() throws ServiceException {
		if(itemConfiguracaoService == null) {
			itemConfiguracaoService = (ItemConfiguracaoService) ServiceLocator.getInstance().getService(ItemConfiguracaoService.class, null);
		}
		return itemConfiguracaoService;
	}

}
