package br.com.centralit.citcorpore.ajaxForms;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.BaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.BaseConhecimentoRelacionadoDTO;
import br.com.centralit.citcorpore.bean.ComentariosDTO;
import br.com.centralit.citcorpore.bean.ConhecimentoICDTO;
import br.com.centralit.citcorpore.bean.ContadorAcessoDTO;
import br.com.centralit.citcorpore.bean.HistoricoBaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.ItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.PastaDTO;
import br.com.centralit.citcorpore.bean.ProblemaDTO;
import br.com.centralit.citcorpore.bean.RequisicaoLiberacaoDTO;
import br.com.centralit.citcorpore.bean.RequisicaoMudancaDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.BaseConhecimentoRelacionadoService;
import br.com.centralit.citcorpore.negocio.BaseConhecimentoService;
import br.com.centralit.citcorpore.negocio.ComentariosService;
import br.com.centralit.citcorpore.negocio.ConhecimentoICService;
import br.com.centralit.citcorpore.negocio.ContadorAcessoService;
import br.com.centralit.citcorpore.negocio.HistoricoBaseConhecimentoService;
import br.com.centralit.citcorpore.negocio.ItemConfiguracaoService;
import br.com.centralit.citcorpore.negocio.PastaService;
import br.com.centralit.citcorpore.negocio.PerfilAcessoPastaService;
import br.com.centralit.citcorpore.negocio.ProblemaService;
import br.com.centralit.citcorpore.negocio.RequisicaoLiberacaoService;
import br.com.centralit.citcorpore.negocio.RequisicaoMudancaService;
import br.com.centralit.citcorpore.negocio.SolicitacaoServicoService;
import br.com.centralit.citcorpore.negocio.UsuarioService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.PermissaoAcessoPasta;
import br.com.centralit.citcorpore.util.Enumerados.ServiceRequestStatus;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.centralit.citged.negocio.ControleGEDService;
import br.com.centralit.lucene.Lucene;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;
import br.com.citframework.util.UtilStrings;

@SuppressWarnings({"unchecked", "rawtypes"})
public class BaseConhecimentoView extends BaseConhecimento {

	private PastaService pastaService;
	private PerfilAcessoPastaService perfilAcessoPastaService;
	private BaseConhecimentoService baseConhecimentoService;
	private BaseConhecimentoRelacionadoService baseConhecimentoRelacionadoService;
	private ControleGEDService controleGEDService;
	private SolicitacaoServicoService solicitacaoServicoService;
	private ProblemaService problemaService;
	private RequisicaoMudancaService requisicaoMudancaService;
	private RequisicaoLiberacaoService requisicaoLiberacaoService;
	private ItemConfiguracaoService itemConfiguracaoService;
	private HistoricoBaseConhecimentoService historicoBaseConhecimentoService;
	private UsuarioService usuarioService;
	private ComentariosService comentariosService;
	private ConhecimentoICService conhecimentoICService;

	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);

		UsuarioDTO usuarioDTO = WebUtil.getUsuario(request);

		StringBuilder tableOfContents = new StringBuilder();
		Collection<PastaDTO> listPastas = getPastaService().listPastaSuperiorSemPai();

		if (!listPastas.isEmpty()) {
			for (final PastaDTO pasta : listPastas) {
				final Long quantidadeSubPastas = getPastaService().quantidadeSubPastas(pasta);
				final Long quantidadeBaseConhecimento = getBaseConhecimentoService().quantidadeBaseConhecimentoByPasta(pasta);

				String nome = super.obterStatusPermissao(request, pasta, pasta.getNome(), usuarioDTO);

				if (quantidadeBaseConhecimento != null && quantidadeBaseConhecimento > 0 || quantidadeSubPastas != null && quantidadeSubPastas > 0) {
					tableOfContents.append("<li class=\"hasSubmenu\">");
					tableOfContents.append("	<a class=\"glyphicons folder_open\" href=\"#tableOfContentsSub" + pasta.getId() + "\" title=\"" + nome + "\" onclick=\"BaseConhecimento.TableOfContents.Folder.toggleEvent(" + pasta.getId() + "); return false;\">");
					tableOfContents.append("		<i></i>");
					tableOfContents.append("		<span class=\"ellipsis\">" + nome + "</span>");
					tableOfContents.append("		<div class=\"count\"><span class=\"label label-primary\" title=\"" + UtilI18N.internacionaliza(request, "baseConhecimentoView.quantidadeConhecimentos") + "\">" + (quantidadeBaseConhecimento != null ? quantidadeBaseConhecimento : "0") + "</span>&nbsp;<span class=\"label label-warning\" title=\"" + UtilI18N.internacionaliza(request, "baseConhecimentoView.quantidadePastas") + "\">" + (quantidadeSubPastas != null ? quantidadeSubPastas : "0") + "</span></div>");
					tableOfContents.append("	</a>");
					tableOfContents.append("	<ul class=\"collapse\" id=\"tableOfContentsSub" + pasta.getId() + "\" data-loaded=\"false\"></ul>");
					tableOfContents.append("</li>");
				} else {
					tableOfContents.append("<li>");
					tableOfContents.append("	<a class=\"glyphicons folder_open\" href=\"#\" title=\"" + nome + "\" onclick=\"return false;\">");
					tableOfContents.append("		<i></i>");
					tableOfContents.append("		<span class=\"ellipsis\">" + nome + "</span>");
					tableOfContents.append("		<div class=\"count\"><span class=\"label label-primary\" title=\"" + UtilI18N.internacionaliza(request, "baseConhecimentoView.quantidadeConhecimentos") + "\">0</span>&nbsp;<span class=\"label label-warning\" title=\"" + UtilI18N.internacionaliza(request, "baseConhecimentoView.quantidadePastas") + "\">0</span></div>");
					tableOfContents.append("	</a>");
					tableOfContents.append("</li>");
				}
			}
		}

		if (tableOfContents.length() > 0) {
			HTMLElement wrapper = document.getElementById("base-conhecimento-list");
			wrapper.setInnerHTML(tableOfContents.toString());

			document.executeScript("BaseConhecimento.TableOfContents.Loading.close();");
		}

		if (request.getParameter("idBaseConhecimento") != null) {
			Integer idBaseConhecimento = Integer.parseInt(request.getParameter("idBaseConhecimento"));

			BaseConhecimentoDTO baseConhecimentoDTO = new BaseConhecimentoDTO();
			baseConhecimentoDTO.setIdBaseConhecimento(idBaseConhecimento);

			baseConhecimentoDTO = (BaseConhecimentoDTO) getBaseConhecimentoService().restore(baseConhecimentoDTO);

			document.executeScript("BaseConhecimento.Iframe.open(" + baseConhecimentoDTO.getIdBaseConhecimento() + ", " + baseConhecimentoDTO.getIdPasta() + ");");

			restore(document, request, response);
		}

		preencheComboTipoDocumento(document, request);
	}

	private void preencheComboTipoDocumento(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect tipoDocumentoSelect = document.getSelectById("tipoDocumento");
		tipoDocumentoSelect.addOption("-1", UtilI18N.internacionaliza(request, "citcorpore.comum.todos"));
		for(Enumerados.TipoConhecimento tipoConhecimento : Enumerados.TipoConhecimento.values()){
			tipoDocumentoSelect.addOption(tipoConhecimento.getIdentificador(), UtilI18N.internacionaliza(request, tipoConhecimento.getChave()));
		}
	}

	@Override
	public void restore(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);

		BaseConhecimentoDTO baseConhecimentoDTO = (BaseConhecimentoDTO) document.getBean();
		UsuarioDTO usuarioDTO = WebUtil.getUsuario(request);
		PastaDTO pastaDTO = new PastaDTO();

		ContadorAcessoDTO contadorAcessoDTO = new ContadorAcessoDTO();
		ContadorAcessoService contadorAcessoService;
		contadorAcessoService = (ContadorAcessoService) ServiceLocator.getInstance().getService(ContadorAcessoService.class, null);

		if (contadorAcessoDTO.getIdContadorAcesso() == null) {
			contadorAcessoDTO.setIdUsuario(usuarioDTO.getIdUsuario());
			contadorAcessoDTO.setDataHoraAcesso(UtilDatas.getDataHoraAtual());
			contadorAcessoDTO.setIdBaseConhecimento(baseConhecimentoDTO.getIdBaseConhecimento());
			contadorAcessoDTO.setContadorAcesso(1);
			if (contadorAcessoService.verificarDataHoraDoContadorDeAcesso(contadorAcessoDTO)) {
				contadorAcessoService.create(contadorAcessoDTO);
			}
		}

		baseConhecimentoDTO = (BaseConhecimentoDTO) getBaseConhecimentoService().restore(baseConhecimentoDTO);

		final Integer quantidadeDeCliques = contadorAcessoService.quantidadesDeAcessoPorBaseConhecimnto(baseConhecimentoDTO);
		if (quantidadeDeCliques != null) {
			baseConhecimentoDTO.setContadorCliques(quantidadeDeCliques);
		} else {
			baseConhecimentoDTO.setContadorCliques(0);
		}

		if (baseConhecimentoDTO != null && baseConhecimentoDTO.getIdBaseConhecimento() != null) {
			if (baseConhecimentoDTO.getIdPasta() != null) {
				pastaDTO = getPastaService().restorePastaById(baseConhecimentoDTO.getIdPasta());
				baseConhecimentoDTO.setNomePasta(pastaDTO.getNome());
			}

			document.getElementById("titulo").setInnerHTML(baseConhecimentoDTO.getTitulo());
			document.getElementById("pasta").setInnerHTML(baseConhecimentoDTO.getNomePasta());

			Double media = getBaseConhecimentoService().calcularNota(baseConhecimentoDTO.getIdBaseConhecimento());
			Long quantidadeVotos = getBaseConhecimentoService().contarVotos(baseConhecimentoDTO.getIdBaseConhecimento());

			StringBuilder votes = new StringBuilder();
			votes.append("<p class=\"mr5\">" + (quantidadeVotos != null ? quantidadeVotos : "0") + " Voto(s)</p>");
			votes.append("<i class=\"material-icons md-14\">" + (media != null && media >= 1.0 ? "star" : "star_border") + "</i>");
			votes.append("<i class=\"material-icons md-14\">" + (media != null && media >= 2.0 ? "star" : "star_border") + "</i>");
			votes.append("<i class=\"material-icons md-14\">" + (media != null && media >= 3.0 ? "star" : "star_border") + "</i>");
			votes.append("<i class=\"material-icons md-14\">" + (media != null && media >= 4.0 ? "star" : "star_border") + "</i>");
			votes.append("<i class=\"material-icons md-14\">" + (media != null && media >= 5.0 ? "star" : "star_border") + "</i>");
			votes.append("<div class=\"clearfix\"></div>");

			document.getElementById("media").setInnerHTML(votes.toString());
			document.getElementById("conteudo").setInnerHTML(baseConhecimentoDTO.getConteudo());

			//Adicionando conhecimentos relacionados.
			StringBuilder tableBaseConhecimentoRelacionados = new StringBuilder();

			Collection<BaseConhecimentoRelacionadoDTO> listBaseConhecimentoRelacionadoDto = getBaseConhecimentoRelacionadoService().listByIdBaseConhecimento(baseConhecimentoDTO.getIdBaseConhecimento());

			if (listBaseConhecimentoRelacionadoDto != null && !listBaseConhecimentoRelacionadoDto.isEmpty()) {
				tableBaseConhecimentoRelacionados.append("<table class=\"table table-condensed table-vertical-center table-thead-simple\">");
				tableBaseConhecimentoRelacionados.append("	<thead>");
				tableBaseConhecimentoRelacionados.append("		<tr>");
				tableBaseConhecimentoRelacionados.append("			<th>"+ UtilI18N.internacionaliza(request, "citcorpore.comum.titulo") + "</th>");
				tableBaseConhecimentoRelacionados.append("		</tr>");
				tableBaseConhecimentoRelacionados.append("	</thead>");
				tableBaseConhecimentoRelacionados.append("	<tbody>");

				for (final BaseConhecimentoRelacionadoDTO baseConhecimentoRelacionadoDTO : listBaseConhecimentoRelacionadoDto) {
					if (baseConhecimentoRelacionadoDTO.getIdBaseConhecimentoRelacionado() != null) {
						BaseConhecimentoDTO conhecimentoRelacionadoDto = new BaseConhecimentoDTO();

						conhecimentoRelacionadoDto.setIdBaseConhecimento(baseConhecimentoRelacionadoDTO.getIdBaseConhecimentoRelacionado());
						conhecimentoRelacionadoDto = (BaseConhecimentoDTO) getBaseConhecimentoService().restore(conhecimentoRelacionadoDto);

						pastaDTO = this.getPastaService().restorePastaById(conhecimentoRelacionadoDto.getIdPasta());

						PermissaoAcessoPasta permissao = getPerfilAcessoPastaService().verificarPermissaoDeAcessoPasta(usuarioDTO, pastaDTO);

						StringBuilder titulo = new StringBuilder();
						if (permissao != null) {
							if (PermissaoAcessoPasta.SEMPERMISSAO.equals(permissao)) {
								titulo.append(" - " + UtilI18N.internacionaliza(request, "baseConhecimentoView.confidencial"));
							}
						} else {
							titulo.append(" - " + UtilI18N.internacionaliza(request, "baseConhecimentoView.confidencial"));
						}

						tableBaseConhecimentoRelacionados.append("<tr>");
						tableBaseConhecimentoRelacionados.append("	<td>" + conhecimentoRelacionadoDto.getTitulo() + titulo.toString() + "</td>");
						tableBaseConhecimentoRelacionados.append("</tr>");
					}
				}

				tableBaseConhecimentoRelacionados.append("	</tbody>");
				tableBaseConhecimentoRelacionados.append("</table>");
			} else {
				tableBaseConhecimentoRelacionados.append("<div class=\"align-center\">"+ UtilI18N.internacionaliza(request, "baseConhecimentoView.nenhumConhecimentoEncontrado") + "</div>");
			}

			document.getElementById("base-conhecimento-conhecimentos-relacionados-body").setInnerHTML(tableBaseConhecimentoRelacionados.toString());

			//Adicionando anexos.
			StringBuilder tableAnexos = new StringBuilder();

			Collection colAnexos = getControleGEDService().listByIdTabelaAndID(ControleGEDDTO.TABELA_BASECONHECIMENTO, baseConhecimentoDTO.getIdBaseConhecimento());
			Collection<UploadDTO> colAnexosUploadDTO = getControleGEDService().convertListControleGEDToUploadDTO(colAnexos);

			if (colAnexosUploadDTO != null) {
				tableAnexos.append("<table class=\"table table-condensed table-vertical-center table-thead-simple\">");
				tableAnexos.append("	<thead>");
				tableAnexos.append("		<tr>");
				tableAnexos.append("			<th>"+ UtilI18N.internacionaliza(request, "citcorpore.comum.titulo") + "</th>");
				tableAnexos.append("		</tr>");
				tableAnexos.append("	</thead>");
				tableAnexos.append("	<tbody>");

				for (UploadDTO uploadDTO : colAnexosUploadDTO) {
					if (uploadDTO.getDescricao() == null) {
						uploadDTO.setDescricao("");
					}

					tableAnexos.append("<tr>");
					tableAnexos.append("	<td><a href=\"#\" class=\"ellipsis\" onclick=\"BaseConhecimento.Content.obtemAnexo('" + uploadDTO.getPath() + "'); return false;\">"
							+ (uploadDTO.getNameFile() != null ? uploadDTO.getNameFile() : "") + "</td>");
					tableAnexos.append("</tr>");
				}

				tableAnexos.append("	</tbody>");
				tableAnexos.append("</table>");
			} else {
				tableAnexos.append("<div class=\"align-center\">"+ UtilI18N.internacionaliza(request, "baseConhecimentoView.nenhumAnexoEncontrado") + "</div>");
			}

			document.getElementById("base-conhecimento-anexos-body").setInnerHTML(tableAnexos.toString());

			// Adicionando solicitaes de servio relacionados.
			StringBuilder tableSolicitacoes = new StringBuilder();

			Collection colSolicitacao = getSolicitacaoServicoService().findByConhecimento(baseConhecimentoDTO);

			if (colSolicitacao != null) {
				tableSolicitacoes.append("<table class=\"table table-condensed table-vertical-center table-thead-simple\">");
				tableSolicitacoes.append("	<thead>");
				tableSolicitacoes.append("		<tr>");
				tableSolicitacoes.append("			<th>"+ UtilI18N.internacionaliza(request, "baseConhecimentoView.id") + "</th>");
				tableSolicitacoes.append("			<th>"+ UtilI18N.internacionaliza(request, "baseConhecimentoView.servico") + "</th>");
				tableSolicitacoes.append("		</tr>");
				tableSolicitacoes.append("	</thead>");
				tableSolicitacoes.append("	<tbody>");

				for (Object object : colSolicitacao) {
					SolicitacaoServicoDTO solicitacaoServicoDTO = (SolicitacaoServicoDTO) object;

					tableSolicitacoes.append("<tr>");
					tableSolicitacoes.append("	<td>" + (solicitacaoServicoDTO.getIdSolicitacaoServico() != null ? solicitacaoServicoDTO.getIdSolicitacaoServico() : "") + "</td>");
					tableSolicitacoes.append("	<td>" + (solicitacaoServicoDTO.getNomeServico() != null ? solicitacaoServicoDTO.getNomeServico() : "") + "</td>");
					tableSolicitacoes.append("</tr>");
				}

				tableSolicitacoes.append("	</tbody>");
				tableSolicitacoes.append("</table>");
			} else {
				tableSolicitacoes.append("<div class=\"align-center\">"+ UtilI18N.internacionaliza(request, "baseConhecimentoView.nenhumIncidenteRequisicaoEncontrado") + "</div>");
			}

			document.getElementById("base-conhecimento-incidentes-requisicoes-body").setInnerHTML(tableSolicitacoes.toString());

			//Adicionando problemas relacionados.
			StringBuilder tableProblemas = new StringBuilder();

			final Collection<ProblemaDTO> colProblema = getProblemaService().findByConhecimento(baseConhecimentoDTO);
			if (colProblema != null) {
				tableProblemas.append("<table class=\"table table-condensed table-vertical-center table-thead-simple\">");
				tableProblemas.append("	<thead>");
				tableProblemas.append("		<tr>");
				tableProblemas.append("			<th>"+ UtilI18N.internacionaliza(request, "citcorpore.comum.titulo") + "</th>");
				tableProblemas.append("			<th>"+ UtilI18N.internacionaliza(request, "citcorpore.comum.status") + "</th>");
				tableProblemas.append("		</tr>");
				tableProblemas.append("	</thead>");
				tableProblemas.append("	<tbody>");

				for (final ProblemaDTO problema : colProblema) {
					String status = UtilI18N.internacionaliza(request, problema.getDescrStatus());

					tableProblemas.append("<tr>");
					tableProblemas.append("	<td>" + (problema.getTitulo() != null ? problema.getTitulo() : "") + "</td>");
					tableProblemas.append("	<td>" + status + "</td>");
					tableProblemas.append("</tr>");
				}

				tableProblemas.append("	</tbody>");
				tableProblemas.append("</table>");
			} else {
				tableProblemas.append("<div class=\"align-center\">"+ UtilI18N.internacionaliza(request, "baseConhecimentoView.nenhumProblemaEncontrado") + "</div>");
			}

			document.getElementById("base-conhecimento-problemas-body").setInnerHTML(tableProblemas.toString());

			// Adicionando mudanas relacionadas.
			StringBuilder tableMudancas = new StringBuilder();

			final Collection<RequisicaoMudancaDTO> colMudanca = getRequisicaoMudancaService().findByConhecimento(baseConhecimentoDTO);
			if (colMudanca != null) {
				tableMudancas.append("<table class=\"table table-condensed table-vertical-center table-thead-simple\">");
				tableMudancas.append("	<thead>");
				tableMudancas.append("		<tr>");
				tableMudancas.append("			<th>"+ UtilI18N.internacionaliza(request, "citcorpore.comum.titulo") + "</th>");
				tableMudancas.append("			<th>"+ UtilI18N.internacionaliza(request, "citcorpore.comum.status") + "</th>");
				tableMudancas.append("		</tr>");
				tableMudancas.append("	</thead>");
				tableMudancas.append("	<tbody>");

				for (final RequisicaoMudancaDTO mudanca : colMudanca) {
					tableMudancas.append("<tr>");
					tableMudancas.append("	<td>" + (mudanca.getTitulo() != null ? mudanca.getTitulo() : "") + "</td>");
					tableMudancas.append("	<td>" + UtilI18N.internacionaliza(request, mudanca.getDescrStatus()) + "</td>");
					tableMudancas.append("</tr>");
				}

				tableMudancas.append("	</tbody>");
				tableMudancas.append("</table>");
			} else {
				tableMudancas.append("<div class=\"align-center\">"+ UtilI18N.internacionaliza(request, "baseConhecimentoView.nenhumaMudancaEncontrada") + "</div>");
			}

			document.getElementById("base-conhecimento-mudancas-body").setInnerHTML(tableMudancas.toString());

			// Adicionando liberaes relacionadas.
			StringBuilder tableLiberacoes = new StringBuilder();

			final Collection<RequisicaoLiberacaoDTO> colLiberacao = getRequisicaoLiberacaoService().findByConhecimento(baseConhecimentoDTO);
			if (colLiberacao != null) {
				tableLiberacoes.append("<table class=\"table table-condensed table-vertical-center table-thead-simple\">");
				tableLiberacoes.append("	<thead>");
				tableLiberacoes.append("		<tr>");
				tableLiberacoes.append("			<th>"+ UtilI18N.internacionaliza(request, "citcorpore.comum.titulo") + "</th>");
				tableLiberacoes.append("			<th>"+ UtilI18N.internacionaliza(request, "citcorpore.comum.status") + "</th>");
				tableLiberacoes.append("		</tr>");
				tableLiberacoes.append("	</thead>");
				tableLiberacoes.append("	<tbody>");

				for (final RequisicaoLiberacaoDTO liberacao : colLiberacao) {
					tableLiberacoes.append("<tr>");
					tableLiberacoes.append("	<td>" + (liberacao.getTitulo() != null ? liberacao.getTitulo() : "") + "</td>");
					tableLiberacoes.append("	<td>" + (liberacao.getIdStatus() != null ? UtilI18N.internacionaliza(request, liberacao.getDescrStatus()) : "") + "</td>");
					tableLiberacoes.append("</tr>");
				}

				tableLiberacoes.append("	</tbody>");
				tableLiberacoes.append("</table>");
			} else {
				tableLiberacoes.append("<div class=\"align-center\">"+ UtilI18N.internacionaliza(request, "baseConhecimentoView.nenhumaLiberacaoEncontrada") + "</div>");
			}

			document.getElementById("base-conhecimento-liberacoes-body").setInnerHTML(tableLiberacoes.toString());

			// Adicionando itens de configurao relacionados.
			refreshListItemConfiguracao(document, request, baseConhecimentoDTO);

			document.executeScript("BaseConhecimento.Content.Loading.close();");
		}
	}

	/**
	 * Carrega o submenu da rvore de um item clicado.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.acorse
	 */
	public void loadItemTableOfContents(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);

		BaseConhecimentoDTO baseConhecimentoDTO = (BaseConhecimentoDTO) document.getBean();
		UsuarioDTO usuarioDTO = WebUtil.getUsuario(request);

		if (baseConhecimentoDTO.getIdPasta() != null) {
			StringBuilder tableOfContents = new StringBuilder();

			PastaDTO pastaDTO = getPastaService().restorePastaById(baseConhecimentoDTO.getIdPasta());

			final Collection<PastaDTO> listaDeSubPastas = this.getPastaService().listSubPastas(pastaDTO);

			if (listaDeSubPastas != null && !listaDeSubPastas.isEmpty()) {
				for (final PastaDTO pasta : listaDeSubPastas) {
					final Long quantidadeSubPastas = getPastaService().quantidadeSubPastas(pasta);
					final Long quantidadeBaseConhecimento = getBaseConhecimentoService().quantidadeBaseConhecimentoByPasta(pasta);

					String nome = super.obterStatusPermissao(request, pasta, pasta.getNome(), usuarioDTO);

					if (quantidadeBaseConhecimento != null && quantidadeBaseConhecimento > 0 || quantidadeSubPastas != null && quantidadeSubPastas > 0) {
						tableOfContents.append("<li class=\"hasSubmenu\">");
						tableOfContents.append("	<a class=\"glyphicons folder_open\" href=\"#tableOfContentsSub" + pasta.getId() + "\" title=\"" + nome + "\" onclick=\"BaseConhecimento.TableOfContents.Folder.toggleEvent(" + pasta.getId() + "); return false;\">");
						tableOfContents.append("		<i></i>");
						tableOfContents.append("		<span class=\"ellipsis\">" + nome + "</span>");
						tableOfContents.append("		<div class=\"count\"><span class=\"label label-primary\" title=\"" + UtilI18N.internacionaliza(request, "baseConhecimentoView.quantidadeConhecimentos") + "\">" + (quantidadeBaseConhecimento != null ? quantidadeBaseConhecimento : "0") + "</span>&nbsp;<span class=\"label label-warning\" title=\"" + UtilI18N.internacionaliza(request, "baseConhecimentoView.quantidadePastas") + "\">" + (quantidadeSubPastas != null ? quantidadeSubPastas : "0") + "</span></div>");
						tableOfContents.append("	</a>");
						tableOfContents.append("	<ul class=\"collapse\" id=\"tableOfContentsSub" + pasta.getId() + "\" data-loaded=\"false\"></ul>");
						tableOfContents.append("</li>");
					} else {
						tableOfContents.append("<li>");
						tableOfContents.append("	<a class=\"glyphicons folder_open\" href=\"#\" title=\"" + nome + "\" onclick=\"return false;\">");
						tableOfContents.append("		<i></i>");
						tableOfContents.append("		<span class=\"ellipsis\">" + nome + "</span>");
						tableOfContents.append("		<div class=\"count\"><span class=\"label label-primary\" title=\"" + UtilI18N.internacionaliza(request, "baseConhecimentoView.quantidadeConhecimentos") + "\">0</span>&nbsp;<span class=\"label label-warning\" title=\"" + UtilI18N.internacionaliza(request, "baseConhecimentoView.quantidadePastas") + "\">0</span></div>");
						tableOfContents.append("	</a>");
						tableOfContents.append("</li>");
					}
				}
			}

			final Collection<BaseConhecimentoDTO> listBaseconhecimento = getBaseConhecimentoService().listarBaseConhecimentoByPasta(pastaDTO);

			if (listBaseconhecimento != null && !listBaseconhecimento.isEmpty()) {
				for (final BaseConhecimentoDTO conhecimentoDTO : listBaseconhecimento) {
					if (getBaseConhecimentoService().verificaPermissaoDeAcessoDoUsuarioParaBaseConhecimento(pastaDTO, conhecimentoDTO, usuarioDTO)) {
						tableOfContents.append("<li>");
						tableOfContents.append("	<a class=\"glyphicons file\" href=\"#\" title=\"" + conhecimentoDTO.getTitulo() + "\" onclick=\"BaseConhecimento.TableOfContents.Item.open(" + conhecimentoDTO.getIdBaseConhecimento() + ", " + pastaDTO.getId() + "); return false;\">");
						tableOfContents.append("		<i></i>");
						tableOfContents.append("		<span class=\"ellipsis\">" + conhecimentoDTO.getTitulo() + "</span>");
						tableOfContents.append("	</a>");
						tableOfContents.append("</li>");
					}
				}
			}

			if (tableOfContents.length() > 0) {
				HTMLElement wrapper = document.getElementById("tableOfContentsSub" + baseConhecimentoDTO.getIdPasta());
				wrapper.setInnerHTML(tableOfContents.toString());

				document.executeScript("BaseConhecimento.TableOfContents.Folder.toggle(" + baseConhecimentoDTO.getIdPasta() + ");");
			}
		}
	}

	/**
	 * Realiza a pesquisa na base de conhecimento.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.acorse
	 */
	public void pesquisaBaseConhecimento(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);

		BaseConhecimentoDTO baseConhecimentoDTO = (BaseConhecimentoDTO) document.getBean();
		UsuarioDTO usuarioDTO = WebUtil.getUsuario(request);

		List<BaseConhecimentoDTO> listaPesquisaBaseConhecimento = new ArrayList<BaseConhecimentoDTO>();
		StringBuilder search = new StringBuilder();

		listaPesquisaBaseConhecimento = new Lucene().pesquisaBaseConhecimento(baseConhecimentoDTO);

		if (!listaPesquisaBaseConhecimento.isEmpty()) {
			ArrayList<BaseConhecimentoDTO> listaBasesConhecimentoAux = new ArrayList<BaseConhecimentoDTO>();
			listaBasesConhecimentoAux.addAll(listaPesquisaBaseConhecimento);

			for (final BaseConhecimentoDTO bc : listaBasesConhecimentoAux) {
				if (bc != null && bc.getIdPasta() != null) {
					PastaDTO pastaDTO = this.getPastaService().restorePastaById(bc.getIdPasta());
					if (getBaseConhecimentoService().verificaPermissaoDeAcessoDoUsuarioParaBaseConhecimento(pastaDTO, bc, usuarioDTO)) {
						if (getBaseConhecimentoService().obterGrauDeImportanciaParaUsuario(bc, usuarioDTO) != null) {
							final Integer grauImportancia = getBaseConhecimentoService().obterGrauDeImportanciaParaUsuario(bc, usuarioDTO);
							bc.setGrauImportancia(grauImportancia);
						}
					} else {
						listaPesquisaBaseConhecimento.remove(bc);
					}
				}
			}

			if (!listaPesquisaBaseConhecimento.isEmpty()) {
				final CompararBaseConhecimentoGrauImportancia comparaGrauDeImportancia = new CompararBaseConhecimentoGrauImportancia();
				Collections.sort(listaPesquisaBaseConhecimento, comparaGrauDeImportancia);

				for (final BaseConhecimentoDTO bc : listaPesquisaBaseConhecimento) {
					PastaDTO pastaDTO = this.getPastaService().restorePastaById(bc.getIdPasta());

					final Integer importancia = bc.getGrauImportancia();

					String titulo = UtilStrings.nullToVazio(bc.getTitulo());

					titulo = titulo.replaceAll("\"", "");
					titulo = titulo.replaceAll("/", "");

					Double media = getBaseConhecimentoService().calcularNota(bc.getIdBaseConhecimento());
					Long votos = getBaseConhecimentoService().contarVotos(bc.getIdBaseConhecimento());

					search.append("<div class=\"row-fluid\">");
					search.append("		<div class=\"span12\">");
					search.append("			<h4><a href=\"#\" onclick=\"BaseConhecimento.Search.openItem(" + bc.getIdBaseConhecimento() + ", " + bc.getIdPasta() + "); return false;\">" + titulo + super.getGrauImportancia(request, importancia) + "</a></h4>");
					search.append("			<div class=\"menubar links primary\">");
					search.append("				<ul>");
					search.append("					<li>Pasta:</li>");
					search.append("					<li><p>" + pastaDTO.getNome() + "</p></li>");
					search.append("					<li>" + UtilI18N.internacionaliza(request, "baseConhecimentoView.mediaAvaliacao") + "</li>");
					search.append("					<li>");
					search.append("						<div class=\"rating pt5\">");
					search.append("							<p class=\"mr5\">" + (votos != null ? votos.toString() : "0") + " Voto(s)</p>");
					search.append("							<i class=\"material-icons md-14\">" + (media != null && media >= 1.0 ? "star" : "star_border") + "</i>");
					search.append("							<i class=\"material-icons md-14\">" + (media != null && media >= 2.0 ? "star" : "star_border") + "</i>");
					search.append("							<i class=\"material-icons md-14\">" + (media != null && media >= 3.0 ? "star" : "star_border") + "</i>");
					search.append("							<i class=\"material-icons md-14\">" + (media != null && media >= 4.0 ? "star" : "star_border") + "</i>");
					search.append("							<i class=\"material-icons md-14\">" + (media != null && media >= 5.0 ? "star" : "star_border") + "</i>");
					search.append("							<div class=\"clearfix\"></div>");
					search.append("						</div>");
					search.append("					</li>");
					search.append("				</ul>");
					search.append("			</div>");
					search.append("			<div class=\"details\">");

					if (bc.getDataInicio() != null) {
						search.append("				<span class=\"label\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.dataCriacao") + " <span class=\"value\">" + new SimpleDateFormat("dd/MM/yyyy").format(bc.getDataInicio()) + "</span></span>");
					}

					if (bc.getDataExpiracao() != null) {
						search.append("				<span class=\"label\">" + UtilI18N.internacionaliza(request, "baseConhecimentoView.dataExpiracao") + " <span class=\"value\">" + new SimpleDateFormat("dd/MM/yyyy").format(bc.getDataExpiracao()) + "</span></span>");
					}

					if (bc.getDataPublicacao() != null) {
						search.append("				<span class=\"label\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.dataPublicacao") + " <span class=\"value\">" + new SimpleDateFormat("dd/MM/yyyy").format(bc.getDataPublicacao()) + "</span></span>");
					}

					if (bc.getVersao() != null && !bc.getVersao().isEmpty()) {
						search.append("				<span class=\"label\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.versao") + " <span class=\"value\">" + bc.getVersao() + "</span></span>");
					}

					if (bc.getPrivacidade() != null && !bc.getPrivacidade().isEmpty()) {
						search.append("				<span class=\"label\">" + UtilI18N.internacionaliza(request, "baseConhecimentoView.privacidade") + " <span class=\"value\">" + super.getPrivacidade(request, bc.getPrivacidade()) + "</span></span>");
					}

					search.append("			</div>");
					search.append("		</div>");
					search.append("</div>");

					search.append("<div class=\"separator\"></div>");
					search.append("<div class=\"separator\"></div>");

				}
			} else {
				search.append("<div class=\"align-center\">" + UtilI18N.internacionaliza(request, "baseConhecimentoView.nenhumConhecimentoEncontrado") + "</div>");
			}
		} else {
			search.append("<div class=\"align-center\">" + UtilI18N.internacionaliza(request, "baseConhecimentoView.nenhumConhecimentoEncontrado") + "</div>");
		}

		HTMLElement baseConhecimentoSearchBody = document.getElementById("base-conhecimento-search-body");
		baseConhecimentoSearchBody.setInnerHTML(search.toString());

		document.executeScript("BaseConhecimento.Search.Loading.close();");
	}

	/**
	 * Permite visualizar o histrico de verses do conhecimento.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.acorse
	 */
	public void visualizarHistoricoVersao(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		BaseConhecimentoDTO baseConhecimentoDTO = (BaseConhecimentoDTO) document.getBean();
		baseConhecimentoDTO = this.getBaseConhecimentoService().restore(baseConhecimentoDTO);
		StringBuilder tableHistoricoVersoes = new StringBuilder();

		if (baseConhecimentoDTO.getIdBaseConhecimento() != null) {
			Collection<HistoricoBaseConhecimentoDTO> listVersoesBaseConhecimento = this.getHistoricoBaseConhecimentoService().getHistoricoDeVersoes(baseConhecimentoDTO);

			if (listVersoesBaseConhecimento != null && !listVersoesBaseConhecimento.isEmpty()) {
				tableHistoricoVersoes.append("<table class=\"table table-condensed table-vertical-center table-thead-simple\">");
				tableHistoricoVersoes.append("	<thead>");
				tableHistoricoVersoes.append("		<tr>");
				tableHistoricoVersoes.append("			<th>"+ UtilI18N.internacionaliza(request, "baseConhecimentoView.id") + "</th>");
				tableHistoricoVersoes.append("			<th>"+ UtilI18N.internacionaliza(request, "citcorpore.comum.titulo") + "</th>");
				tableHistoricoVersoes.append("			<th>"+ UtilI18N.internacionaliza(request, "citcorpore.comum.versao") + "</th>");
				tableHistoricoVersoes.append("		</tr>");
				tableHistoricoVersoes.append("	</thead>");
				tableHistoricoVersoes.append("	<tbody>");

				for (final BaseConhecimentoDTO baseConhecimentoVersao : listVersoesBaseConhecimento) {
					tableHistoricoVersoes.append("<tr>");
					tableHistoricoVersoes.append("	<td>" + (baseConhecimentoVersao.getIdBaseConhecimento() != null ? baseConhecimentoVersao.getIdBaseConhecimento() : "") + "</td>");
					tableHistoricoVersoes.append("	<td>" + (baseConhecimentoVersao.getTitulo() != null ? baseConhecimentoVersao.getTitulo() : "") + "</td>");
					tableHistoricoVersoes.append("	<td>" + (baseConhecimentoVersao.getVersao() != null ? baseConhecimentoVersao.getVersao() : "") + "</td>");
					tableHistoricoVersoes.append("</tr>");
				}

				tableHistoricoVersoes.append("	</tbody>");
				tableHistoricoVersoes.append("</table>");
			} else {
				tableHistoricoVersoes.append("<div class=\"align-center\">"+ UtilI18N.internacionaliza(request, "baseConhecimentoView.nenhumHistoricoEncontrado") + "</div>");
			}

			document.getElementById("modal-historico-versoes-body").setInnerHTML(tableHistoricoVersoes.toString());

			document.executeScript("Modal.open('modal-historico-versoes');");
		}
	}

	/**
	 * Permite visualizar o histrico de alteraes do conhecimento.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.acorse
	 */
	public void visualizarHistoricoAlteracoes(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);

		BaseConhecimentoDTO baseConhecimentoDTO = (BaseConhecimentoDTO) document.getBean();
		HistoricoBaseConhecimentoDTO historicoBaseConhecimentoDTO = new HistoricoBaseConhecimentoDTO();
		StringBuilder tableHistoricoAlteracoes = new StringBuilder();

		if (baseConhecimentoDTO.getIdBaseConhecimento() != null) {
			baseConhecimentoDTO = (BaseConhecimentoDTO) getBaseConhecimentoService().restore(baseConhecimentoDTO);

			if (baseConhecimentoDTO.getIdHistoricoBaseConhecimento() != null) {
				historicoBaseConhecimentoDTO.setIdHistoricoBaseConhecimento(baseConhecimentoDTO.getIdHistoricoBaseConhecimento());
			}

			Collection<HistoricoBaseConhecimentoDTO> listHistoricoAlteracaoBaseConhecimento = getHistoricoBaseConhecimentoService().obterHistoricoDeAlteracao(baseConhecimentoDTO.getTitulo());

			if (listHistoricoAlteracaoBaseConhecimento != null && !listHistoricoAlteracaoBaseConhecimento.isEmpty()) {
				String language = WebUtil.getLanguage(request);

				tableHistoricoAlteracoes.append("<table class=\"table table-condensed table-vertical-center table-thead-simple\">");
				tableHistoricoAlteracoes.append("	<thead>");
				tableHistoricoAlteracoes.append("		<tr>");
				tableHistoricoAlteracoes.append("			<th>"+ UtilI18N.internacionaliza(request, "citcorpore.comum.titulo") + "</th>");
				tableHistoricoAlteracoes.append("			<th>"+ UtilI18N.internacionaliza(request, "baseConhecimentoView.pasta") + "</th>");
				tableHistoricoAlteracoes.append("			<th>"+ UtilI18N.internacionaliza(request, "citcorpore.comum.versao") + "</th>");
				tableHistoricoAlteracoes.append("			<th>"+ UtilI18N.internacionaliza(request, "citcorpore.comum.origem") + "</th>");
				tableHistoricoAlteracoes.append("			<th>"+ UtilI18N.internacionaliza(request, "citcorpore.comum.usuario") + "</th>");
				tableHistoricoAlteracoes.append("			<th>"+ UtilI18N.internacionaliza(request, "baseConhecimentoView.dataAlteracao") + "</th>");
				tableHistoricoAlteracoes.append("		</tr>");
				tableHistoricoAlteracoes.append("	</thead>");
				tableHistoricoAlteracoes.append("	<tbody>");

				for (final HistoricoBaseConhecimentoDTO historicoBaseConhecimento : listHistoricoAlteracaoBaseConhecimento) {
					PastaDTO pastaDTO = new PastaDTO();
					UsuarioDTO usuarioDTO = new UsuarioDTO();

					if (historicoBaseConhecimento.getIdPasta() != null) {
						pastaDTO = this.getPastaService().restorePastaById(historicoBaseConhecimento.getIdPasta());
					}

					if (historicoBaseConhecimento.getIdUsuarioAlteracao() != null) {
						usuarioDTO.setIdUsuario(historicoBaseConhecimento.getIdUsuarioAlteracao());
						usuarioDTO = (UsuarioDTO) getUsuarioService().restore(usuarioDTO);
					}

					if (historicoBaseConhecimento.getStatus().equalsIgnoreCase("S")) {
						historicoBaseConhecimento.setStatus(UtilI18N.internacionaliza(request, "pesquisaBaseConhecimento.publicado"));
					} else {
						historicoBaseConhecimento.setStatus(UtilI18N.internacionaliza(request, "pesquisaBaseConhecimento.naoPublicado"));
					}

					tableHistoricoAlteracoes.append("<tr>");
					tableHistoricoAlteracoes.append("	<td>" + (historicoBaseConhecimento.getTitulo() != null ? historicoBaseConhecimento.getTitulo() : "") + "</td>");
					tableHistoricoAlteracoes.append("	<td>" + (pastaDTO.getNome() != null ? pastaDTO.getNome() : "") + "</td>");
					tableHistoricoAlteracoes.append("	<td>" + (historicoBaseConhecimento.getVersao() != null ? historicoBaseConhecimento.getVersao() : "") + "</td>");
					tableHistoricoAlteracoes.append("	<td>" + (historicoBaseConhecimento.getOrigem() != null ? historicoBaseConhecimento.getOrigem() : "") + "</td>");
					tableHistoricoAlteracoes.append("	<td>" + (usuarioDTO.getNomeUsuario() != null ? usuarioDTO.getNomeUsuario() : "") + "</td>");
					tableHistoricoAlteracoes.append("	<td>" + (historicoBaseConhecimento.getDataHoraAlteracao() != null ? UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, historicoBaseConhecimento.getDataHoraAlteracao(), language) : "") + "</td>");
					tableHistoricoAlteracoes.append("</tr>");
				}

				tableHistoricoAlteracoes.append("	</tbody>");
				tableHistoricoAlteracoes.append("</table>");
			} else {
				tableHistoricoAlteracoes.append("<div class=\"align-center\">"+ UtilI18N.internacionaliza(request, "baseConhecimentoView.nenhumHistoricoAlteracaoEncontrado") + "</div>");
			}

			document.getElementById("modal-historico-alteracoes-body").setInnerHTML(tableHistoricoAlteracoes.toString());

			document.executeScript("Modal.open('modal-historico-alteracoes');");
		}
	}

	/**
	 * Permite visualizar as referncias em incidentes/requisies
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author douglas.japiassu
	 */
	public void visualizarReferenciasIncidentesRequisicoes(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final String language = WebUtil.getLanguage(request);
		BaseConhecimentoDTO baseConhecimentoDTO = (BaseConhecimentoDTO) document.getBean();

		final SolicitacaoServicoDTO solicitacaoServicoDto = new SolicitacaoServicoDTO();
        solicitacaoServicoDto.setIdBaseConhecimento(baseConhecimentoDTO.getIdBaseConhecimento());

		Collection<SolicitacaoServicoDTO> listIncidentesRequisicoesBaseConhecimento = getSolicitacaoServicoService().findByConhecimento(baseConhecimentoDTO);
		StringBuilder tableIncidentesRequisicoes = new StringBuilder();

		if (listIncidentesRequisicoesBaseConhecimento != null && !listIncidentesRequisicoesBaseConhecimento.isEmpty()) {
			tableIncidentesRequisicoes.append("<table class=\"table table-condensed table-vertical-center table-thead-simple\">");
			tableIncidentesRequisicoes.append("	<thead>");
			tableIncidentesRequisicoes.append("		<tr>");
			tableIncidentesRequisicoes.append("			<th>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.numero")).append("</th>");
			tableIncidentesRequisicoes.append("			<th>").append(UtilI18N.internacionaliza(request, "solicitacaoServico.solicitante")).append("</th>");
			tableIncidentesRequisicoes.append("			<th>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.tipo")).append("</th>");
			tableIncidentesRequisicoes.append("			<th>").append(UtilI18N.internacionaliza(request, "solicitacaoServico.datahoraabertura")).append("</th>");
			tableIncidentesRequisicoes.append("			<th>").append(UtilI18N.internacionaliza(request, "gerenciaservico.sla")).append("</th>");
			tableIncidentesRequisicoes.append("			<th>").append(UtilI18N.internacionaliza(request, "solicitacaoServico.descricao")).append("</th>");
			tableIncidentesRequisicoes.append("			<th>").append(UtilI18N.internacionaliza(request, "solicitacaoServico.solucaoResposta")).append("</th>");
			tableIncidentesRequisicoes.append("			<th>").append(UtilI18N.internacionaliza(request, "solicitacaoServico.situacao")).append("</th>");
			tableIncidentesRequisicoes.append("			<th>").append(UtilI18N.internacionaliza(request, "solicitacaoServico.datahoralimite")).append("</th>");
			tableIncidentesRequisicoes.append("			<th>").append(UtilI18N.internacionaliza(request, "unidade.grupo")).append("</th>");
			tableIncidentesRequisicoes.append("		</tr>");
			tableIncidentesRequisicoes.append("	</thead>");
			tableIncidentesRequisicoes.append("	<tbody>");

			for (SolicitacaoServicoDTO solicitacaoServico : listIncidentesRequisicoesBaseConhecimento) {
				solicitacaoServico = getSolicitacaoServicoService().restoreAll(solicitacaoServico.getIdSolicitacaoServico());
				tableIncidentesRequisicoes.append("<tr>");
				tableIncidentesRequisicoes.append("	<td>" + UtilNumbersAndDecimals.nullToVazio(solicitacaoServico.getIdSolicitacaoServico()) + "</td>");
				tableIncidentesRequisicoes.append("	<td>" + UtilStrings.nullToVazio(solicitacaoServico.getNomeSolicitante()) + "</td>");
				tableIncidentesRequisicoes.append("	<td>" + UtilStrings.nullToVazio(solicitacaoServico.getNomeTipoDemandaServico()) + "</td>");

				if (solicitacaoServico.getSeqReabertura() == null || solicitacaoServico.getSeqReabertura().intValue() == 0) {
					tableIncidentesRequisicoes.append("<td id='dataHoraSolicitacao'>" + UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, solicitacaoServico.getDataHoraSolicitacao(), language)
                            + "</td>");
                } else {
                	tableIncidentesRequisicoes.append("<td id='dataHoraSolicitacao'>" + UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, solicitacaoServico.getDataHoraSolicitacao(), language)
                            + "<br><br>Seq.reabertura: <span style='color:red'><b>");
                	tableIncidentesRequisicoes.append(+solicitacaoServico.getSeqReabertura() + "</b></span></td>");
                }

				if(solicitacaoServico.getPrazoHH() != null && solicitacaoServico.getPrazoMM() != null){
					tableIncidentesRequisicoes.append("	<td>" + solicitacaoServico.getPrazoHH() + ":" + solicitacaoServico.getPrazoMM() + "</td>");
				} else {
					tableIncidentesRequisicoes.append("	<td>N/A</td>");
				}
				tableIncidentesRequisicoes.append("	<td>" + UtilStrings.nullToVazio(solicitacaoServico.getDescricao()) + "</td>");
				tableIncidentesRequisicoes.append("	<td>" + UtilStrings.nullToVazio(solicitacaoServico.getResposta()) + "</td>");
				tableIncidentesRequisicoes.append("	<td>" + UtilI18N.internacionaliza(request, ServiceRequestStatus.getChaveFromId(solicitacaoServico.getIdStatus())) + "</td>");
				tableIncidentesRequisicoes.append("	<td>" + UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, solicitacaoServico.getDataHoraLimite(), language) + "</td>");
				tableIncidentesRequisicoes.append("	<td>" + UtilStrings.nullToVazio(solicitacaoServico.getSiglaGrupo()) + "</td>");
				tableIncidentesRequisicoes.append("</tr>");
			}

			tableIncidentesRequisicoes.append("	</tbody>");
			tableIncidentesRequisicoes.append("</table>");
		} else {
			tableIncidentesRequisicoes.append("<div class=\"align-center\">").append(UtilI18N.internacionaliza(request, "MSG04")).append("</div>");
		}

		document.getElementById("modal-requisicoes-incidentes-body").setInnerHTML(tableIncidentesRequisicoes.toString());

		document.executeScript("Modal.open('modal-requisicoes-incidentes');");
    }

	/**
	 * Permite visualizar as referncias em problemas.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.acorse
	 */
	public void visualizarReferenciasProblemas(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		BaseConhecimentoDTO baseConhecimentoDTO = (BaseConhecimentoDTO) document.getBean();
		StringBuilder tableProblemas = new StringBuilder();

		if (baseConhecimentoDTO.getIdBaseConhecimento() != null) {
			String language = WebUtil.getLanguage(request);

			ProblemaDTO problemaDTO = new ProblemaDTO();
			problemaDTO.setIdBaseConhecimento(baseConhecimentoDTO.getIdBaseConhecimento());

			final Collection<ProblemaDTO> listaProblemaPorBaseConhecimento = getProblemaService().findByConhecimento(baseConhecimentoDTO);

			if (listaProblemaPorBaseConhecimento != null) {
				tableProblemas.append("<table class=\"table table-condensed table-vertical-center table-thead-simple\">");
				tableProblemas.append("	<thead>");
				tableProblemas.append("		<tr>");
				tableProblemas.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.numero") + "</th>");
				tableProblemas.append("			<th>" + UtilI18N.internacionaliza(request, "problema.proprietario") + "</th>");
				tableProblemas.append("			<th>" + UtilI18N.internacionaliza(request, "problema.titulo") + "</th>");
				tableProblemas.append("			<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.datahoraabertura") + "</th>");
				tableProblemas.append("			<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.descricao") + "</th>");
				tableProblemas.append("			<th>" + UtilI18N.internacionaliza(request, "problema.causa_raiz") + "</th>");
				tableProblemas.append("			<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.solucao") + "</th>");
				tableProblemas.append("			<th>" + UtilI18N.internacionaliza(request, "requisicaMudanca.status") + "</th>");
				tableProblemas.append("		</tr>");
				tableProblemas.append("	</thead>");
				tableProblemas.append("	<tbody>");

				for (ProblemaDTO problema : listaProblemaPorBaseConhecimento) {
					problema = getProblemaService().restauraTodos(problema);
					tableProblemas.append("<tr>");
					tableProblemas.append("	<td>" + (problema.getIdProblema() != null ? problema.getIdProblema() : "") + "</td>");
					tableProblemas.append("	<td>" + (problema.getNomeProprietario() != null ? problema.getNomeProprietario() : "") + "</td>");
					tableProblemas.append("	<td>" + (problema.getTitulo() != null ? problema.getTitulo() : "") + "</td>");
					tableProblemas.append("	<td>" + (problema.getDataHoraInicio() != null ? UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, problema.getDataHoraInicio(), language) : "") + "</td>");
					tableProblemas.append("	<td>" + (problema.getDescricao() != null ? problema.getDescricao() : "") + "</td>");
					tableProblemas.append("	<td>" + (problema.getCausaRaiz() != null ? problema.getCausaRaiz() : "") + "</td>");
					tableProblemas.append("	<td>" + (problema.getSolucaoContorno() != null ? problema.getSolucaoContorno() : "") + "</td>");

					String status = UtilI18N.internacionaliza(request, problema.getDescrStatus());

					tableProblemas.append("	<td>" + UtilStrings.nullToVazio(status) + "</td>");
					tableProblemas.append("</tr>");
				}

				tableProblemas.append("	</tbody>");
				tableProblemas.append("</table>");
			} else {
				tableProblemas.append("<div class=\"align-center\">"+ UtilI18N.internacionaliza(request, "baseConhecimentoView.nenhumProblemaEncontrado") + "</div>");
			}

			document.getElementById("modal-problemas-body").setInnerHTML(tableProblemas.toString());

			document.executeScript("Modal.open('modal-problemas');");
		}
	}

	/**
	 * Permite visualizar as referncias em mudanas.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.acorse
	 */
	public void visualizarReferenciasMudancas(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		BaseConhecimentoDTO baseConhecimentoDTO = (BaseConhecimentoDTO) document.getBean();
		StringBuilder tableMudancas = new StringBuilder();

		if (baseConhecimentoDTO.getIdBaseConhecimento() != null) {
			String language = WebUtil.getLanguage(request);

			RequisicaoMudancaDTO requisicaoMudancaDTO = new RequisicaoMudancaDTO();
			requisicaoMudancaDTO.setIdBaseConhecimento(baseConhecimentoDTO.getIdBaseConhecimento());

			final Collection<RequisicaoMudancaDTO> listaMudancaoPorBaseConhecimento = getRequisicaoMudancaService().findByConhecimento(baseConhecimentoDTO);

			if (listaMudancaoPorBaseConhecimento != null) {
				tableMudancas.append("<table class=\"table table-condensed table-vertical-center table-thead-simple\">");
				tableMudancas.append("	<thead>");
				tableMudancas.append("		<tr>");
				tableMudancas.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.identificacao") + "</th>");
				tableMudancas.append("			<th>" + UtilI18N.internacionaliza(request, "problema.proprietario") + "</th>");
				tableMudancas.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.motivo") + "</th>");
				tableMudancas.append("			<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.datahoraabertura") + "</th>");
				tableMudancas.append("			<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.descricao") + "</th>");
				tableMudancas.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.tipo") + "</th>");
				tableMudancas.append("			<th>" + UtilI18N.internacionaliza(request, "pesquisaBaseConhecimento.dataHoraConclusao") + "</th>");
				tableMudancas.append("			<th>" + UtilI18N.internacionaliza(request, "requisicaMudanca.status") + "</th>");
				tableMudancas.append("		</tr>");
				tableMudancas.append("	</thead>");
				tableMudancas.append("	<tbody>");

				for (RequisicaoMudancaDTO mudanca : listaMudancaoPorBaseConhecimento) {
					mudanca = getRequisicaoMudancaService().restoreAll(mudanca.getIdRequisicaoMudanca());
					tableMudancas.append("<tr>");
					tableMudancas.append("	<td>" + (mudanca.getIdRequisicaoMudanca() != null ? mudanca.getIdRequisicaoMudanca() : "") + "</td>");
					tableMudancas.append("	<td>" + (mudanca.getNomeProprietario() != null ? mudanca.getNomeProprietario() : "") + "</td>");
					tableMudancas.append("	<td>" + (mudanca.getMotivo() != null ? mudanca.getMotivo() : "") + "</td>");
					tableMudancas.append("	<td>" + (mudanca.getDataHoraInicio() != null ? UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, mudanca.getDataHoraInicio(), language) : "") + "</td>");
					tableMudancas.append("	<td>" + (mudanca.getDescricao() != null ? mudanca.getDescricao() : "") + "</td>");
					tableMudancas.append("	<td>" + (mudanca.getTipo() != null ? mudanca.getTipo() : "") + "</td>");
					tableMudancas.append("	<td>" + (mudanca.getDataHoraConclusao() != null ? mudanca.getDataHoraConclusao() : "") + "</td>");

					tableMudancas.append("	<td>" + UtilI18N.internacionaliza(request, mudanca.getDescrStatus()) + "</td>");

					tableMudancas.append("</tr>");
				}

				tableMudancas.append("	</tbody>");
				tableMudancas.append("</table>");
			} else {
				tableMudancas.append("<div class=\"align-center\">"+ UtilI18N.internacionaliza(request, "baseConhecimentoView.nenhumaMudancaEncontrada") + "</div>");
			}

			document.getElementById("modal-mudancas-body").setInnerHTML(tableMudancas.toString());

			document.executeScript("Modal.open('modal-mudancas');");
		}
	}

	/**
	 * Permite visualizar as referncias em itens de configurao
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author douglas.japiassu
	 */
	public void visualizarReferenciasItensConfiguracao(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final String language = WebUtil.getLanguage(request);
		BaseConhecimentoDTO baseConhecimentoDTO = (BaseConhecimentoDTO) document.getBean();

		final ItemConfiguracaoDTO itemConfiguracaoDto = new ItemConfiguracaoDTO();
		itemConfiguracaoDto.setIdBaseConhecimento(baseConhecimentoDTO.getIdBaseConhecimento());

		final Collection<ItemConfiguracaoDTO> listItemConfiguracaoBaseConhecimento = getItemConfiguracaoService().findByConhecimento(baseConhecimentoDTO);
		StringBuilder tableItemConfiguracao = new StringBuilder();

		if (listItemConfiguracaoBaseConhecimento != null && !listItemConfiguracaoBaseConhecimento.isEmpty()) {
			tableItemConfiguracao.append("<table class=\"table table-condensed table-vertical-center table-thead-simple\">");
			tableItemConfiguracao.append("	<thead>");
			tableItemConfiguracao.append("		<tr>");
			tableItemConfiguracao.append("			<th>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.identificacao")).append("</th>");
			tableItemConfiguracao.append("			<th>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.dataCriacao")).append("</th>");
			tableItemConfiguracao.append("			<th>").append(UtilI18N.internacionaliza(request, "relatorioBaseConhecimento.ordenarPorVersao")).append("</th>");
			tableItemConfiguracao.append("			<th>").append(UtilI18N.internacionaliza(request, "pesquisaBaseConhecimento.Familia")).append("</th>");
			tableItemConfiguracao.append("			<th>").append(UtilI18N.internacionaliza(request, "pesquisaBaseConhecimento.dataExpiracao")).append("</th>");
			tableItemConfiguracao.append("		</tr>");
			tableItemConfiguracao.append("	</thead>");
			tableItemConfiguracao.append("	<tbody>");

			for (ItemConfiguracaoDTO itemConfiguracao : listItemConfiguracaoBaseConhecimento) {
				itemConfiguracao = (ItemConfiguracaoDTO) getItemConfiguracaoService().restore(itemConfiguracao);
				tableItemConfiguracao.append("<tr>");
				tableItemConfiguracao.append("	<td>" + UtilStrings.nullToVazio(itemConfiguracao.getIdentificacao()) + "</td>");
				tableItemConfiguracao.append("	<td>" + UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, itemConfiguracao.getDataInicio(), language) + "</td>");
				tableItemConfiguracao.append("	<td>" + UtilStrings.nullToVazio(itemConfiguracao.getVersao()) + "</td>");
				tableItemConfiguracao.append("	<td>" + UtilStrings.nullToVazio(itemConfiguracao.getFamilia()) + "</td>");
				tableItemConfiguracao.append("	<td>" + UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, itemConfiguracao.getDataExpiracao(), language) + "</td>");
				tableItemConfiguracao.append("</tr>");
			}

			tableItemConfiguracao.append("	</tbody>");
			tableItemConfiguracao.append("</table>");
		} else {
			tableItemConfiguracao.append("<div class=\"align-center\">").append(UtilI18N.internacionaliza(request, "MSG04")).append("</div>");
		}

		document.getElementById("modal-item-configuracao-body").setInnerHTML(tableItemConfiguracao.toString());

		document.executeScript("Modal.open('modal-item-configuracao');");
	}

	/**
	 * Permite visualizar os comentrios do conhecimento
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author douglas.japiassu
	 */
	public void visualizarComentarios(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		BaseConhecimentoDTO baseConhecimentoDTO = (BaseConhecimentoDTO) document.getBean();

		final Collection<ComentariosDTO> listComentariosBaseConhecimento = getComentariosService().consultarComentarios(baseConhecimentoDTO);
		StringBuilder tableComentarios = new StringBuilder();

		if (listComentariosBaseConhecimento != null && !listComentariosBaseConhecimento.isEmpty()) {
			tableComentarios.append("<table class=\"table table-condensed table-vertical-center table-thead-simple\">");
			tableComentarios.append("	<thead>");
			tableComentarios.append("		<tr>");
			tableComentarios.append("			<th>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.nome")).append("</th>");
			tableComentarios.append("			<th>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.email")).append("</th>");
			tableComentarios.append("			<th>").append(UtilI18N.internacionaliza(request, "baseConhecimento.comentario")).append("</th>");
			tableComentarios.append("			<th>").append(UtilI18N.internacionaliza(request, "baseConhecimento.nota")).append("</th>");
			tableComentarios.append("		</tr>");
			tableComentarios.append("	</thead>");
			tableComentarios.append("	<tbody>");

			for (final ComentariosDTO comentario : listComentariosBaseConhecimento) {
				tableComentarios.append("<tr>");
				tableComentarios.append("	<td>" + UtilStrings.nullToVazio(comentario.getNome()) + "</td>");
				tableComentarios.append("	<td>" + UtilStrings.nullToVazio(comentario.getEmail()) + "</td>");
				tableComentarios.append("	<td>" + UtilStrings.nullToVazio(comentario.getComentario()) + "</td>");
				tableComentarios.append("	<td>");
				tableComentarios.append(getDivVotos(UtilStrings.nullToVazio(comentario.getNota())));
				tableComentarios.append("	</td>");
				tableComentarios.append("</tr>");
			}

			tableComentarios.append("	</tbody>");
			tableComentarios.append("</table>");
		} else {
			tableComentarios.append("<div class=\"align-center\">").append(UtilI18N.internacionaliza(request, "MSG04")).append("</div>");
		}

		document.getElementById("modal-comentarios-body").setInnerHTML(tableComentarios.toString());

		document.executeScript("Modal.open('modal-comentarios');");
	}

	/**
	 * Recupera a div de notas
	 *
	 * @param nota
	 * @return divVotos - Div contendo as estrelas preenchidas at
	 * @author douglas.japiassu
	 */
	private String getDivVotos(String nota) {
		StringBuilder divVotos = new StringBuilder();
		final Integer maximoEstrelas = 5;

		divVotos.append("		<div class=\"rating pt5\">");
		for (int qtdeEstrelas = 1; qtdeEstrelas <= maximoEstrelas; qtdeEstrelas++) {
			divVotos.append("			<i class=\"material-icons md-14\">" + (Integer.parseInt(nota) >= qtdeEstrelas ? "star" : "star_border")  + "</i>");
		}
		divVotos.append("		<div class=\"clearfix\"></div>");
		divVotos.append("		</div>");

		return divVotos.toString();
	}

	public void vincularItemConfiguracao(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		BaseConhecimentoDTO baseConhecimentoDTO = (BaseConhecimentoDTO) document.getBean();
		try{
			if(baseConhecimentoDTO != null
					&& baseConhecimentoDTO.getIdItemConfiguracao() != null
					&& baseConhecimentoDTO.getIdBaseConhecimento() != null){
				Collection<ConhecimentoICDTO> colConhecimentoICDTO = getConhecimentoICService().findByidItemConfiguracaoAndIdBaseConhecimento(
						baseConhecimentoDTO.getIdItemConfiguracao()
						, baseConhecimentoDTO.getIdBaseConhecimento());
				ConhecimentoICDTO conhecimentoICDTO = new ConhecimentoICDTO();
				if(colConhecimentoICDTO == null || colConhecimentoICDTO.size() == 0){
					conhecimentoICDTO.setIdItemConfiguracao(baseConhecimentoDTO.getIdItemConfiguracao());
					conhecimentoICDTO.setIdBaseConhecimento(baseConhecimentoDTO.getIdBaseConhecimento());
					getConhecimentoICService().create(conhecimentoICDTO);
					document.executeScript("notificacaoI18N('MSG18')");
				} else {
					document.executeScript("notificacaoI18N('baseConhecimentoView.itemConfiguracaoJaVinculadoEsteConhecimento')");
				}
			}
		} catch (Exception e){
			e.printStackTrace();
			document.executeScript("notificacaoErro(".concat("'MSE02'").concat(")"));
		}
		refreshListItemConfiguracao(document, request, baseConhecimentoDTO);
	}

	private void refreshListItemConfiguracao(DocumentHTML document, HttpServletRequest request, BaseConhecimentoDTO baseConhecimentoDTO) throws Exception {
		StringBuilder tableItensConfiguracao = new StringBuilder();

		final Collection<ItemConfiguracaoDTO> colItensConfiguracao = getItemConfiguracaoService().findByConhecimento(baseConhecimentoDTO);
		if (colItensConfiguracao != null) {
			tableItensConfiguracao.append("<table class=\"table table-condensed table-vertical-center table-thead-simple\">");
			tableItensConfiguracao.append("	<thead>");
			tableItensConfiguracao.append("		<tr>");
			tableItensConfiguracao.append("			<th>"+ UtilI18N.internacionaliza(request, "baseConhecimentoView.id") + "</th>");
			tableItensConfiguracao.append("			<th>"+ UtilI18N.internacionaliza(request, "citcorpore.comum.identificacao") + "</th>");
			tableItensConfiguracao.append("		</tr>");
			tableItensConfiguracao.append("	</thead>");
			tableItensConfiguracao.append("	<tbody>");

			for (ItemConfiguracaoDTO itemConfiguracaoDTO  : colItensConfiguracao) {
				tableItensConfiguracao.append("<tr>");
				tableItensConfiguracao.append("	<td>" + (itemConfiguracaoDTO.getIdItemConfiguracao() != null ? itemConfiguracaoDTO.getIdItemConfiguracao() : "") + "</td>");
				tableItensConfiguracao.append("	<td>" + (itemConfiguracaoDTO.getIdentificacao() != null ? itemConfiguracaoDTO.getIdentificacao() : "") + "</td>");
				tableItensConfiguracao.append("</tr>");
			}

			tableItensConfiguracao.append("	</tbody>");
			tableItensConfiguracao.append("</table>");
		} else {
			tableItensConfiguracao.append("<div class=\"align-center\">"+ UtilI18N.internacionaliza(request, "baseConhecimentoView.nenhumItemConfiguracaoEncontrado") + "</div>");
		}

		document.getElementById("base-conhecimento-itens-configuracao-body").setInnerHTML(tableItensConfiguracao.toString());

	}

	public void deletarConhecimentoIc(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		BaseConhecimentoDTO baseConhecimentoDTO = (BaseConhecimentoDTO) document.getBean();
		try{
			if(baseConhecimentoDTO != null
					&& baseConhecimentoDTO.getIdItemConfiguracao() != null
					&& baseConhecimentoDTO.getIdBaseConhecimento() != null){
				getConhecimentoICService().deleteByIdBaseConhecimentoAndIdItemConfiguracao(
						baseConhecimentoDTO.getIdBaseConhecimento(),
						baseConhecimentoDTO.getIdItemConfiguracao());
				document.executeScript("notificacaoI18N(".concat("'MSG18'").concat(")"));
			}
		} catch (Exception e){
			e.printStackTrace();
			document.executeScript("notificacaoErro(".concat("'MSE02'").concat(")"));
		}
		refreshListItemConfiguracao(document, request, baseConhecimentoDTO);
	}

	private PastaService getPastaService() throws ServiceException {
		if (pastaService == null) {
			pastaService = (PastaService) ServiceLocator.getInstance().getService(PastaService.class, null);
		}

		return pastaService;
	}

	private PerfilAcessoPastaService getPerfilAcessoPastaService() throws ServiceException {
		if (perfilAcessoPastaService == null) {
			perfilAcessoPastaService = (PerfilAcessoPastaService) ServiceLocator.getInstance().getService(PerfilAcessoPastaService.class, null);
		}

		return perfilAcessoPastaService;
	}

	private BaseConhecimentoService getBaseConhecimentoService() throws ServiceException {
		if (baseConhecimentoService == null) {
			baseConhecimentoService = (BaseConhecimentoService) ServiceLocator.getInstance().getService(BaseConhecimentoService.class, null);
		}

		return baseConhecimentoService;
	}

	private BaseConhecimentoRelacionadoService getBaseConhecimentoRelacionadoService() throws ServiceException {
		if (baseConhecimentoRelacionadoService == null) {
			baseConhecimentoRelacionadoService = (BaseConhecimentoRelacionadoService) ServiceLocator.getInstance().getService(BaseConhecimentoRelacionadoService.class, null);
		}

		return baseConhecimentoRelacionadoService;
	}

	private ControleGEDService getControleGEDService() throws ServiceException {
		if (controleGEDService == null) {
			controleGEDService = (ControleGEDService) ServiceLocator.getInstance().getService(ControleGEDService.class, null);
		}

		return controleGEDService;
	}

	private ProblemaService getProblemaService() throws ServiceException {
		if (problemaService == null) {
			problemaService = (ProblemaService) ServiceLocator.getInstance().getService(ProblemaService.class, null);
		}

		return problemaService;
	}

	private RequisicaoMudancaService getRequisicaoMudancaService() throws ServiceException {
		if (requisicaoMudancaService == null) {
			requisicaoMudancaService = (RequisicaoMudancaService) ServiceLocator.getInstance().getService(RequisicaoMudancaService.class, null);
		}

		return requisicaoMudancaService;
	}

	private ItemConfiguracaoService getItemConfiguracaoService() throws ServiceException {
		if (itemConfiguracaoService == null) {
			itemConfiguracaoService = (ItemConfiguracaoService) ServiceLocator.getInstance().getService(ItemConfiguracaoService.class, null);
		}

		return itemConfiguracaoService;
	}

	private SolicitacaoServicoService getSolicitacaoServicoService() throws ServiceException {
		if (solicitacaoServicoService == null) {
			solicitacaoServicoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, null);
		}

		return solicitacaoServicoService;
	}

	private RequisicaoLiberacaoService getRequisicaoLiberacaoService() throws ServiceException {
		if (requisicaoLiberacaoService == null) {
			requisicaoLiberacaoService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, null);
		}

		return requisicaoLiberacaoService;
	}

	private HistoricoBaseConhecimentoService getHistoricoBaseConhecimentoService() throws ServiceException {
		if (historicoBaseConhecimentoService == null) {
			historicoBaseConhecimentoService = (HistoricoBaseConhecimentoService) ServiceLocator.getInstance().getService(HistoricoBaseConhecimentoService.class, null);
		}

		return historicoBaseConhecimentoService;
	}

	private UsuarioService getUsuarioService() throws ServiceException {
		if (usuarioService == null) {
			usuarioService = (UsuarioService) ServiceLocator.getInstance().getService(UsuarioService.class, null);
		}

		return usuarioService;
	}

	private ComentariosService getComentariosService() throws ServiceException {
		if (comentariosService == null) {
			comentariosService = (ComentariosService) ServiceLocator.getInstance().getService(ComentariosService.class, null);
		}

		return comentariosService;
	}

	private ConhecimentoICService getConhecimentoICService() throws ServiceException {
		if(conhecimentoICService == null) {
			conhecimentoICService = (ConhecimentoICService) ServiceLocator.getInstance().getService(ConhecimentoICService.class, null);
		}
		return conhecimentoICService;
	}

}