package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLTable;
import br.com.centralit.citcorpore.bean.AplicacaoClienteDTO;
import br.com.centralit.citcorpore.bean.AplicacaoDTO;
import br.com.centralit.citcorpore.bean.AplicacaoRequisitoDTO;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.negocio.AplicacaoRequisitoService;
import br.com.centralit.citcorpore.negocio.AplicacaoService;
import br.com.centralit.citcorpore.negocio.EmpregadoService;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;

/**
 * @author murilo.rodrigues
 * @since 01/10/2015
 */
public class CadastroAplicacao extends AjaxFormAction {
	private AplicacaoService aplicacaoService;
	private AplicacaoRequisitoService aplicacaoRequisitoService;
	private EmpregadoService empregadoService;

	private void carregaNomeEmpregadoResponsavel(AplicacaoDTO aplicacaoDTO) throws Exception, ServiceException {
		if (aplicacaoDTO != null && aplicacaoDTO.getIdResponsavel() != null && aplicacaoDTO.getIdResponsavel().intValue() > 0) {
			EmpregadoDTO empregadoDTO = null;
			empregadoDTO = getEmpregadoService().restoreByIdEmpregado(aplicacaoDTO.getIdResponsavel());
			if (empregadoDTO != null && empregadoDTO.getNome() != null && !empregadoDTO.getNome().isEmpty()) {
				aplicacaoDTO.setNomeResponsavel(empregadoDTO.getNome());
			}
		}
	}

	public void excluir(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		final AplicacaoDTO aplicacaoDTO = (AplicacaoDTO) document.getBean();
		boolean existeVinculoServico = this.getAplicacaoService().aplicacaoVinculadoServico(aplicacaoDTO.getIdAplicacao());
		if (aplicacaoDTO != null && aplicacaoDTO.getIdAplicacao() != null && aplicacaoDTO.getIdAplicacao().intValue() > 0 && !existeVinculoServico) {
			this.getAplicacaoService().delete(aplicacaoDTO);
			final HTMLForm form = document.getForm("formCadastroAplicacao");
			limparCamposDoFormulario(document, form);
		}else{
			document.alert(UtilI18N.internacionaliza(request, "portfolio.aplicacao.aplicacaoVinculadaServico"));
		}
		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	public AplicacaoService getAplicacaoService() throws ServiceException {
		if (this.aplicacaoService == null) {
			this.aplicacaoService = (AplicacaoService) ServiceLocator.getInstance().getService(AplicacaoService.class, null);
		}
		return this.aplicacaoService;
	}

	public AplicacaoRequisitoService getAplicacaoRequisitoService() throws ServiceException {
		if (this.aplicacaoRequisitoService == null) {
			this.aplicacaoRequisitoService = (AplicacaoRequisitoService) ServiceLocator.getInstance().getService(AplicacaoRequisitoService.class, null);
		}
		return this.aplicacaoRequisitoService;
	}

	/**
	 * @author murilo.rodrigues
	 * @since 01/10/2015
	 */
	@Override
	public Class<AplicacaoDTO> getBeanClass() {
		return AplicacaoDTO.class;
	}

	public EmpregadoService getEmpregadoService() throws ServiceException {
		if (this.empregadoService == null) {
			this.empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);
		}
		return this.empregadoService;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroAplicacao.java_( limparCamposDoFormulario)
	 *
	 * @author murilo.rodrigues
	 * @since 01/10/2015
	 */
	private void limparCamposDoFormulario(final DocumentHTML document, final HTMLForm form) throws Exception {
		this.limparFormulario(form);
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroAplicacao.java_( limparFormulario)
	 * 
	 * @author murilo.rodrigues
	 * @since 01/10/2015
	 */
	private void limparFormulario(final HTMLForm form) {
		form.clear();
	}

	/**
	 * @author murilo.rodrigues
	 * @since 01/10/2015
	 */
	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		limparFormulariosCadastro(document);
	}

	/**
	 * @author murilo.rodrigues
	 * @since 01/10/2015
	 */
	public void restore(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			final AplicacaoDTO dto = (AplicacaoDTO) document.getBean();

			if (dto != null && dto.getIdAplicacao() != null) {
				limparFormulariosCadastro(document);

				AplicacaoDTO aplicacaoDTO = new AplicacaoDTO();
				aplicacaoDTO.setIdAplicacao(dto.getIdAplicacao());
				aplicacaoDTO = this.getAplicacaoService().restore(aplicacaoDTO);

				carregaNomeEmpregadoResponsavel(aplicacaoDTO);

				final HTMLForm form = document.getForm("formCadastroAplicacao");
				// Setando o formulario para impressao na tela
				form.setValues(aplicacaoDTO);

				definirRequisitosDaAplicacao(aplicacaoDTO, document, request);
				definirClientesDaAplicacao(aplicacaoDTO, document, request);
			}

		} catch (final Exception e) {
			throw new Exception(e);
		}finally{
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroAplicacao.java_(save)
	 *
	 * @author murilo.rodrigues
	 * @since 01/10/2015
	 */
	public void save(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		AplicacaoDTO aplicacaoDTO = (AplicacaoDTO) document.getBean();

		if (aplicacaoDTO.getIdAplicacao() != null && aplicacaoDTO.getIdAplicacao().intValue() > 0) {
			this.getAplicacaoService().update(aplicacaoDTO);
			document.alert(UtilI18N.internacionaliza(request, "MSG06"));
		} else {
			aplicacaoDTO = (AplicacaoDTO) this.getAplicacaoService().create(aplicacaoDTO);
			if (aplicacaoDTO != null) {
				document.alert(UtilI18N.internacionaliza(request, "MSG05"));
			}
		}

		manterRequisitosDaAplicacao(document, request, aplicacaoDTO.getIdAplicacao());
		manterClientesDaAplicacao(document, request, aplicacaoDTO.getIdAplicacao());

		document.getForm("formCadastroAplicacao").setValue("idAplicacao", aplicacaoDTO.getIdAplicacao());
	}

	private void limparFormulariosCadastro(final DocumentHTML document) throws Exception {
		final HTMLForm formCadastroAplicacao = document.getForm("formCadastroAplicacao");
		this.limparCamposDoFormulario(document, formCadastroAplicacao);

		final HTMLForm formAplicacaoRequisito = document.getForm("formAplicacaoRequisito");
		this.limparCamposDoFormulario(document, formAplicacaoRequisito);
		final HTMLTable tabelaDeRequisitosDaAplicacao = document.getTableById("tblRequisitoAplicacao");
		tabelaDeRequisitosDaAplicacao.deleteAllRows();

		final HTMLForm formPesquisaClienteAplicacao = document.getForm("formPesquisaClienteAplicacao");
		this.limparCamposDoFormulario(document, formPesquisaClienteAplicacao);
		final HTMLTable tabelaDeClientesDaAplicacao = document.getTableById("tblClienteAplicacao");
		tabelaDeClientesDaAplicacao.deleteAllRows();

	}

	// ---------------------- ABA REQUISITOS DA APLICACAO -----------------------//

	private void manterRequisitosDaAplicacao(final DocumentHTML document, final HttpServletRequest request, Integer idAplicacao) throws Exception, ServiceException {
		List<AplicacaoRequisitoDTO> listaDeRequisitosDaAplicacao = obterRequisitosDaAplicacao(request);
		this.getAplicacaoRequisitoService().salvarRequisitos(listaDeRequisitosDaAplicacao, idAplicacao);

		List<String> listaDeRequisitosAExluir = obterListaParaExclusaoDeRequisitosDaAplicacao(document);
		this.getAplicacaoRequisitoService().excluirRequisitos(listaDeRequisitosAExluir);
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroAplicacao.java_(definirRequisitosDaAplicacao)
	 *
	 * @since 07/10/2015
	 * @author murilo.rodrigues
	 */
	@SuppressWarnings("unchecked")
	private void definirRequisitosDaAplicacao(final AplicacaoDTO dto, final DocumentHTML document, final HttpServletRequest request) throws Exception {
		if (dto != null && dto.getIdAplicacao() != null) {
			List<AplicacaoRequisitoDTO> listaDeRequisitosPeloIdDaAplicacao = new ArrayList<AplicacaoRequisitoDTO>(0);
			listaDeRequisitosPeloIdDaAplicacao = (List<AplicacaoRequisitoDTO>) this.getAplicacaoRequisitoService().findByIdAplicacao(dto.getIdAplicacao());

			this.definirSerializacaoRequisitosDaAplicacao(document, request, listaDeRequisitosPeloIdDaAplicacao);
			this.carregarTabelaDeRequisitosDaAplicacao(document, request, listaDeRequisitosPeloIdDaAplicacao);
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroAplicacao.java_(definirSerializacaoRequisitosDaAplicacao)
	 *
	 * @since 07/10/2015
	 * @author murilo.rodrigues
	 */
	private void definirSerializacaoRequisitosDaAplicacao(final DocumentHTML document, final HttpServletRequest request, final List<AplicacaoRequisitoDTO> listaDeRequisitosDaAplicacao)
			throws Exception {
		final String listaSerializada = br.com.citframework.util.WebUtil.serializeObjects(listaDeRequisitosDaAplicacao, WebUtil.getLanguage(request));
		document.executeScript("document.formCadastroAplicacao.colItens_Requisitos_Serialize.value = '".concat(listaSerializada).concat("';"));
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroAplicacao.java_(carregarTabelaDeRequisitosDaAplicacao)
	 *
	 * @since 07/10/2015
	 * @author murilo.rodrigues
	 */
	private void carregarTabelaDeRequisitosDaAplicacao(final DocumentHTML document, final HttpServletRequest request, final List<AplicacaoRequisitoDTO> listaDeRequisitosDaAplicacao) throws Exception {
		if (listaDeRequisitosDaAplicacao != null && !listaDeRequisitosDaAplicacao.isEmpty()) {
			final HTMLTable tabelaDeRequisitosDaAplicacao = document.getTableById("tblRequisitoAplicacao");
			tabelaDeRequisitosDaAplicacao.deleteAllRows();
			tabelaDeRequisitosDaAplicacao.addRowsByCollection(listaDeRequisitosDaAplicacao, new String[] { "nomeRequisito", "statusRequisito", "" }, null,
					UtilI18N.internacionaliza(request, "citcorpore.comum.registroJaCadastrado"), new String[] { "exibeIconesTabelaRequisitos", "internacionalizaStatusDoRequisito" }, null, null);
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroAplicacao.java_(obterRequisitosDaAplicacao)
	 *
	 * @since 07/10/2015
	 * @author murilo.rodrigues
	 */
	@SuppressWarnings("unchecked")
	private List<AplicacaoRequisitoDTO> obterRequisitosDaAplicacao(final HttpServletRequest request) throws Exception {
		final List<AplicacaoRequisitoDTO> lista = ((ArrayList<AplicacaoRequisitoDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(AplicacaoRequisitoDTO.class,
				"colItens_Requisitos_Serialize", request));
		return lista;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroAplicacao.java_(obterListaParaExclusaoDeRequisitosDaAplicacao)
	 *
	 * @since 07/10/2015
	 * @author murilo.rodrigues
	 */
	@SuppressWarnings("unchecked")
	private List<String> obterListaParaExclusaoDeRequisitosDaAplicacao(final DocumentHTML document) throws Exception {
		final HTMLElement element = document.getElementById("colItens_Delecao_Requisito");
		final Map<String, String> mapValores = element.getDocument().getValuesForm();
		// Elemento no formulario
		final String valorElemento = StringUtils.removeEnd(mapValores.get("COLITENS_DELECAO_REQUISITO"), ",");
		List<String> listaretorno = new ArrayList<String>();
		if (StringUtils.isNotEmpty(valorElemento)) {
			listaretorno = Arrays.asList(valorElemento.split(","));
		}
		return listaretorno;
	}

	// ---------------------- ABA CLIENTES DA APLICACAO -----------------------//

	private void manterClientesDaAplicacao(final DocumentHTML document, final HttpServletRequest request, Integer idAplicacao) throws Exception, ServiceException {
		List<AplicacaoClienteDTO> listaDeClientesDaAplicacao = obterClientesDaAplicacao(request);
		this.getAplicacaoService().salvarClientes(listaDeClientesDaAplicacao, idAplicacao);

		List<String> listaDeClientesAExluir = obterListaParaExclusaoDeClientesDaAplicacao(document);
		this.getAplicacaoService().excluirClientes(listaDeClientesAExluir);
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroAplicacao.java_(definirClientesDaAplicacao)
	 *
	 * @since 08/10/2015
	 * @author murilo.rodrigues
	 */
	private void definirClientesDaAplicacao(final AplicacaoDTO dto, final DocumentHTML document, final HttpServletRequest request) throws Exception {
		if (dto != null && dto.getIdAplicacao() != null) {
			List<AplicacaoClienteDTO> listaDeClientesDaAplicacao = new ArrayList<AplicacaoClienteDTO>(0);
			listaDeClientesDaAplicacao = (List<AplicacaoClienteDTO>) this.getAplicacaoService().findClientesByIdAplicacao(dto.getIdAplicacao());

			this.definirSerializacaoClientesDaAplicacao(document, request, listaDeClientesDaAplicacao);
			this.carregarTabelaDeClientesDaAplicacao(document, request, listaDeClientesDaAplicacao);
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroAplicacao.java_(definirSerializacaoClientesDaAplicacao)
	 *
	 * @since 07/10/2015
	 * @author murilo.rodrigues
	 */
	private void definirSerializacaoClientesDaAplicacao(final DocumentHTML document, final HttpServletRequest request, final List<AplicacaoClienteDTO> listaDeClientesDaAplicacao) throws Exception {
		final String listaSerializada = br.com.citframework.util.WebUtil.serializeObjects(listaDeClientesDaAplicacao, WebUtil.getLanguage(request));
		document.executeScript("document.formCadastroAplicacao.colItens_Clientes_Serialize.value = '".concat(listaSerializada).concat("';"));
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroAplicacao.java_(carregarTabelaDeClientesDaAplicacao)
	 *
	 * @since 07/10/2015
	 * @author murilo.rodrigues
	 */
	private void carregarTabelaDeClientesDaAplicacao(final DocumentHTML document, final HttpServletRequest request, final List<AplicacaoClienteDTO> listaDeClientesDaAplicacao) throws Exception {
		if (listaDeClientesDaAplicacao != null && !listaDeClientesDaAplicacao.isEmpty()) {
			final HTMLTable tabelaDeClientesDaAplicacao = document.getTableById("tblClienteAplicacao");
			tabelaDeClientesDaAplicacao.deleteAllRows();
			tabelaDeClientesDaAplicacao.addRowsByCollection(listaDeClientesDaAplicacao, new String[] { "nomeCliente", "" }, null,
					UtilI18N.internacionaliza(request, "citcorpore.comum.registroJaCadastrado"), new String[] { "exibeIconesTabelaClientes" }, null, null);
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroAplicacao.java_(obterClientesDaAplicacao)
	 *
	 * @since 07/10/2015
	 * @author murilo.rodrigues
	 */
	@SuppressWarnings("unchecked")
	private List<AplicacaoClienteDTO> obterClientesDaAplicacao(final HttpServletRequest request) throws Exception {
		final List<AplicacaoClienteDTO> lista = ((ArrayList<AplicacaoClienteDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(AplicacaoClienteDTO.class,
				"colItens_Clientes_Serialize", request));
		return lista;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroAplicacao.java_(obterListaParaExclusaoDeClientesDaAplicacao)
	 *
	 * @since 07/10/2015
	 * @author murilo.rodrigues
	 */
	@SuppressWarnings("unchecked")
	private List<String> obterListaParaExclusaoDeClientesDaAplicacao(final DocumentHTML document) throws Exception {
		final HTMLElement element = document.getElementById("colItens_Delecao_Cliente");
		final Map<String, String> mapValores = element.getDocument().getValuesForm();
		// Elemento no formulario
		final String valorElemento = StringUtils.removeEnd(mapValores.get("COLITENS_DELECAO_REQUISITO"), ",");
		List<String> listaretorno = new ArrayList<String>();
		if (StringUtils.isNotEmpty(valorElemento)) {
			listaretorno = Arrays.asList(valorElemento.split(","));
		}
		return listaretorno;
	}


}
