package br.com.centralit.citcorpore.ajaxForms;

import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citajax.html.HTMLTable;
import br.com.centralit.citcorpore.bean.AcordoNivelServicoContratoDTO;
import br.com.centralit.citcorpore.bean.CadastroContratoDTO;
import br.com.centralit.citcorpore.bean.ClienteDTO;
import br.com.centralit.citcorpore.bean.ComplexidadeDTO;
import br.com.centralit.citcorpore.bean.CondicaoOperacaoDTO;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.ContratoFormulaOsDTO;
import br.com.centralit.citcorpore.bean.ContratoHistoricoDTO;
import br.com.centralit.citcorpore.bean.ContratoPerfilDTO;
import br.com.centralit.citcorpore.bean.ContratosGruposDTO;
import br.com.centralit.citcorpore.bean.ContratosUnidadesDTO;
import br.com.centralit.citcorpore.bean.FormulaOsDTO;
import br.com.centralit.citcorpore.bean.FornecedorDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioCadastroServicoNegocioDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.MatrizContratoDTO;
import br.com.centralit.citcorpore.bean.MoedaDTO;
import br.com.centralit.citcorpore.bean.ProdutoContratoDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.AcordoNivelServicoContratoService;
import br.com.centralit.citcorpore.negocio.ClienteService;
import br.com.centralit.citcorpore.negocio.ComplexidadeService;
import br.com.centralit.citcorpore.negocio.CondicaoOperacaoService;
import br.com.centralit.citcorpore.negocio.ContratoFormulaOsService;
import br.com.centralit.citcorpore.negocio.ContratoHistoricoService;
import br.com.centralit.citcorpore.negocio.ContratoPerfilService;
import br.com.centralit.citcorpore.negocio.ContratoService;
import br.com.centralit.citcorpore.negocio.ContratosGruposService;
import br.com.centralit.citcorpore.negocio.ContratosUnidadesService;
import br.com.centralit.citcorpore.negocio.FormulaOsService;
import br.com.centralit.citcorpore.negocio.FornecedorService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.MatrizContratoService;
import br.com.centralit.citcorpore.negocio.MoedaService;
import br.com.centralit.citcorpore.negocio.ProdutoContratoService;
import br.com.centralit.citcorpore.negocio.SolicitacaoServicoService;
import br.com.centralit.citcorpore.util.Enumerados.CampoUpload;
import br.com.centralit.citcorpore.util.Enumerados.CommunicationMatrixContactType;
import br.com.centralit.citcorpore.util.Enumerados.CommunicationMatrixFrequencyType;
import br.com.centralit.citcorpore.util.Enumerados.CommunicationMatrixRecordType;
import br.com.centralit.citcorpore.util.Enumerados.Complexidade;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.Enumerados.SituacaoContrato;
import br.com.centralit.citcorpore.util.Enumerados.TipoAcordoContrato;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citged.bean.ControleGEDDTO;
import br.com.centralit.citged.negocio.ControleGEDService;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citcorpore.util.UtilCalculo;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilFormatacao;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilStrings;

/**
 * @author ibimon.morais
 * @since 17/09/2015
 */
public class CadastroContrato extends AjaxFormAction {

	private GrupoService grupoService;
	private MoedaService moedaService;
	private ContratoService contratoService;
	private ClienteService clienteService;
	private FornecedorService fornecedorService;
	private AcordoNivelServicoContratoService acordoNivelServicoContratoService;
	private ComplexidadeService complexidadeService;
	private ContratoHistoricoService contratoHistoricoService;
	private ContratoPerfilService contratoPerfilService;
	private ProdutoContratoService produtoContratoService;
	private MatrizContratoService matrizContratoService;
	private ContratoFormulaOsService contratoFormulaOsService;
	private ContratosUnidadesService contratosUnidadesService;
	private ContratosGruposService contratosGrupoService;
	private CondicaoOperacaoService condicaoOperacaoService;
	private FormulaOsService formulaOsService;
	private static Permissoes permissao;
	private SolicitacaoServicoService solicitacaoServicoService;
	private ControleGEDService controleGEDService;

	/**
	 * @author ibimon.morais
	 * @since 15/09/2015
	 */
	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		permissao = new Permissoes(document, request);

		this.carregarDadosComboGrupoSolicitante(document, request, response);
		this.carregarDadosComboMoedas(document, request, response);
		this.carregarDadosComboSituacao(document, request, response);
		this.carregarDadosComboTipoAcordoContrato(document, request, response);
		this.carregarDadosComboTipoRegistro(document, request, response);
		this.carregarDadosComboFormaContato(document, request, response);
		this.carregarDadosComboFrequencia(document, request, response);
		this.carregaComboCondicaoOperacao(document, request, response);
		this.carregaComboPermiteCadastroSolicitante(document, request, response);

		this.htmlTableComplexidade(document, request, response);
		this.definirHistoricoAuditoriaContrato(document, request, response, null);
		this.iniciarChecksSituacao(document);
		request.getSession(true).setAttribute(CampoUpload.UPLOADCONTRATO.getColUploadGED(), null);
		document.executeScript("DEFINEALLPAGES_generateConfiguracaoCamposForm(document.formCadastroContrato);");
	}

	private void setPermissaoCadastroContrato(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) {
		CadastroContratoDTO beanDto = (CadastroContratoDTO) document.getBean();
		String caminhoPermissaoAcesso = "";

		if (!UtilStrings.isNullOrEmpty(beanDto.getTipoServicoPortfolio())) {
			caminhoPermissaoAcesso = PagesPortfolio.CONTRATOS_DETALHES.getCaminho();
		}

		permissao = new Permissoes(document, request, caminhoPermissaoAcesso);
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato#save
	 *
	 * @since 18/09/2015
	 * @author ibimon.morais
	 */
	public void save(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		setPermissaoCadastroContrato(document, request, response);
		if (permissao.isGravar()) {
			final CadastroContratoDTO beanDto = (CadastroContratoDTO) document.getBean();
			final Map<String, Object> parametros = new HashMap<String, Object>();
			final ContratoDTO contratoDto = new ContratoDTO();
			Reflexao.copyPropertyValues(beanDto, contratoDto);
			Collection<UploadDTO> arquivosGED = (Collection<UploadDTO>) request.getSession(true).getAttribute(CampoUpload.UPLOADCONTRATO.getColUploadGED());
			contratoDto.setColsUploadGED(arquivosGED);
			Boolean isUpdate = false;
			if (contratoDto.getIdContrato() != null && contratoDto.getIdContrato().intValue() > 0) {
				isUpdate = true;
			}
			// SAVE Tratando o contrato criado
			this.aplicarAcaoSalvar(document, request, parametros, contratoDto, isUpdate);
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
		}
	}

	/**
	 *
	 * projeto-missao_novo_paradigma - CadastroContrato.java_(#aplicarAcaoSalvar).
	 *
	 * @since 10/11/2015
	 * @author ibimon.morais
	 */
	private void aplicarAcaoSalvar(final DocumentHTML document, final HttpServletRequest request, final Map<String, Object> parametros, ContratoDTO contratoDto, final Boolean isUpdate)
			throws Exception, ServiceException {
		if (contratoDto != null) {
			this.montarParametroParaSalvarNoBanco(document, request, contratoDto, parametros);
			contratoDto = this.getContratoService().salvar(parametros);
			if (contratoDto == null) {
				document.alert(UtilI18N.internacionaliza(request, "Erro ao salvar o Contrato"));
			} else if (isUpdate) {
				document.alert(UtilI18N.internacionaliza(request, "MSG06"));
				document.executeScript("fechaModalContrato()");
			} else {
				document.executeScript("fechaModalContrato()");
				document.alert(UtilI18N.internacionaliza(request, "MSG05"));
				final HTMLForm form = document.getForm("formCadastroContrato");
				form.setValue("idContrato", contratoDto.getIdContrato().toString());
			}
			this.iniciarChecksSituacao(document);
		}
	}
	/**
	 * @since 02/03/2016
	 * @author pedro.sousa
	 */
	public void visualizarFormula(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);

		CadastroContratoDTO dto = (CadastroContratoDTO) document.getBean();
		if (!Util.isNullOrEmpty(dto.getIdFormulaSelecionada())) {
			FormulaOsDTO formulaOsDTO = getFormulaOsService().buscarPorId(dto.getIdFormulaSelecionada());

			if (!Util.isNullOrEmpty(formulaOsDTO) && !Util.isNullOrEmpty(formulaOsDTO.getFormula())) {
				document.executeScript("document.formCadastroContrato.formula.value = '" + formulaOsDTO.getFormula() + "'");
				document.executeScript("MostrarFormula()");
			}
		}
	}

	public void simularCalculo(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		CadastroContratoDTO dto = (CadastroContratoDTO) document.getBean();
		String formulaSimulada = dto.getFormulaSimulada();
		formulaSimulada = formulaSimulada.replace("vNumeroUsuarios", "100");
		formulaSimulada = formulaSimulada.replace("vNumberOfUsers", "100");
		formulaSimulada = formulaSimulada.replace("vDiasUteis", "24");
		formulaSimulada = formulaSimulada.replace("vWeekdays", "24");
		formulaSimulada = formulaSimulada.replace("vDiasHabiles", "24");
		formulaSimulada = formulaSimulada.replace("vDiasCorridos", "30");
		formulaSimulada = formulaSimulada.replace("vCalendarDays", "30");

		double custo = UtilCalculo.calculaExpressao(formulaSimulada);
		String resultado = "<b>" + custo + "</b>";
		document.executeScript("setarResultado('<b>" + formulaSimulada + "</b> = " + resultado + "')");
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( excluirContrato)
	 *
	 * @since 01/10/2015
	 * @author ibimon.morais
	 */
	public void excluirContrato(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		setPermissaoCadastroContrato(document, request, response);
		if (permissao.isDeletar()) {
			final CadastroContratoDTO beanDto = (CadastroContratoDTO) document.getBean();
			final ContratoDTO contratoDto = new ContratoDTO();
			Reflexao.copyPropertyValues(beanDto, contratoDto);
			
			if (contratoDto != null && contratoDto.getIdContrato() != null) {
				
				if(this.verificaContSolAndamento(contratoDto.getIdContrato())){
					document.alert(UtilI18N.internacionaliza(request, "contrato.excluirContratoComSolicitacoesEmAndamento"));
					return;
				}else{
					contratoDto.setDeleted("Y");
					this.getContratoService().update(contratoDto);
					document.alert(UtilI18N.internacionaliza(request, "MSG07"));
					this.limparCamposDoFormularioAposSalvar(document, request, response);
					return;
				}
			}

			document.alert(UtilI18N.internacionaliza(request, "MSG04"));
		} else {
			document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
		}
	}

	/**
	 * Verififica se o contrato possui solicitaes em andamento vinculados
	 * @author gilmar.junior
	 * @since 08.08.2016
	 * */
	public boolean verificaContSolAndamento (Integer idContrato)throws Exception{
		boolean retorno = false;
		
		if(idContrato != null && idContrato > 0){
			retorno = this.getSolicitacaoServicoService().verificaContSolAndamento(idContrato);
		}
		
		return retorno;
	}

	/**
	 * Verifica se h solicitaes em andamento vinculado ao contrato
	 * Funo realiza verificao no onchange quando a situao for cancelada/paralisada
	 * 
	 * */
	public void existeSolicitacaoEmAndamento(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response)throws Exception{
		final CadastroContratoDTO beanDto = (CadastroContratoDTO) document.getBean();
		boolean retorno = false;

		if(beanDto != null && beanDto.getIdContrato() != null){
			retorno = this.verificaContSolAndamento(beanDto.getIdContrato());
		}
		
		if(retorno){
			document.executeScript("$('#existeSolEmAndamento').val('1')");
		}else{
			document.executeScript("$('#existeSolEmAndamento').val('0')");
		}
	}

	/**
	 * @author ibimon.morais
	 * @since 15/09/2015
	 */
	public void restore(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		try {
			WebUtil.validarSeUsuarioEstaNaSessao(request, document);
			final CadastroContratoDTO dto = (CadastroContratoDTO) document.getBean();
			this.carregarDadosComboGrupoSolicitante(document, request, response);
			this.carregarDadosComboMoedas(document, request, response);
			this.carregarDadosComboSituacao(document, request, response);
			this.carregarDadosComboTipoAcordoContrato(document, request, response);
			this.carregarDadosComboTipoRegistro(document, request, response);
			this.carregarDadosComboFormaContato(document, request, response);
			this.carregarDadosComboFrequencia(document, request, response);
			this.carregaComboCondicaoOperacao(document, request, response);
			this.carregaComboPermiteCadastroSolicitante(document, request, response);
			this.definirControlesDeValoresDoFormulario(document, dto, request, response);
			this.restaurarAnexos(document, request, dto);
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
		} catch (final Exception e) {
			System.out.println(e.getMessage());
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( montarParametroParaSalvarNoBanco)
	 *
	 * @since 24/09/2015
	 * @author ibimon.morais
	 */
	private void montarParametroParaSalvarNoBanco(final DocumentHTML document, final HttpServletRequest request, final ContratoDTO contratoDto, final Map<String, Object> parametros) throws Exception {
		final List<AcordoNivelServicoContratoDTO> listaAcordoNivelServico = this.obterListaDeAcordosNiveisDeServico(document, request, contratoDto);
		final ContratoHistoricoDTO historicoServico = this.obterHistoricoAuditoriaContrato(contratoDto, request);
		final List<ComplexidadeDTO> listaComplexidades = this.obterComplexidades(contratoDto.getIdContrato(), document);
		final List<ContratoPerfilDTO> listaDePerfis = this.obterPerfisDoContrato(contratoDto, request);
		final List<ProdutoContratoDTO> listaDeProdutos = this.obterProdutosDoContrato(contratoDto, request);
		final List<ContratosGruposDTO> listaDeContratosGrupos = this.obterContratosGrupo(contratoDto, request);
		final List<MatrizContratoDTO> listaDeMatrizes = this.obterMatrizDoContrato(contratoDto, request);
		final List<ContratoFormulaOsDTO> listaDeFormulas = this.obterFormulaOsDoContrato(contratoDto, request);
		final List<ContratosUnidadesDTO> listaDeUnidades = this.obterUnidadesDoContrato(contratoDto, request);
		
		this.definirListasDeParametrosParaAcaoSalvar(contratoDto, parametros, listaAcordoNivelServico, historicoServico, listaComplexidades, listaDePerfis, listaDeProdutos, listaDeMatrizes, listaDeFormulas, listaDeContratosGrupos, listaDeUnidades);
		this.definirListasExclusaoRegistros(document, parametros);
	}

	/**
	 * projeto-missao_novo_paradigma - CadastroContrato.java_(#iniciarChecksSituacao).
	 *
	 * @since 18/11/2015
	 * @author ibimon.morais
	 */
	private void iniciarChecksSituacao(final DocumentHTML document) {
		document.executeScript("$('input[name=cadastroManualUsuario][value=S]').attr('checked', true)");
		document.executeScript("$('input[name=cadastroManualUsuario][value=N]').attr('checked', false)");
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( definirListasDeParametrosParaAcaoSalvar)
	 *
	 * @since 30/09/2015
	 * @author ibimon.morais
	 */
	private void definirListasDeParametrosParaAcaoSalvar(final ContratoDTO contratoDto, final Map<String, Object> parametros, final List<AcordoNivelServicoContratoDTO> listaAcordoNivelServico,
			final ContratoHistoricoDTO historicoServico, final List<ComplexidadeDTO> listaComplexidades, final List<ContratoPerfilDTO> listaDePerfis, final List<ProdutoContratoDTO> listaDeProdutos,
			final List<MatrizContratoDTO> listaDeMatrizes, final List<ContratoFormulaOsDTO> listaDeFormulas, final List<ContratosGruposDTO> listaDeContratosGrupos,
			final List<ContratosUnidadesDTO> listaDeUnidades) {
		parametros.put("contratoDto", contratoDto);
		parametros.put("listaAcordoNivelServico", listaAcordoNivelServico);
		parametros.put("historicoServico", historicoServico);
		parametros.put("listaComplexidades", listaComplexidades);
		parametros.put("listaDePerfis", listaDePerfis);
		parametros.put("listaDeProdutos", listaDeProdutos);
		parametros.put("listaDeMatrizes", listaDeMatrizes);
		parametros.put("listaDeFormulasOs", listaDeFormulas);
		parametros.put("listaDeContratosGrupos", listaDeContratosGrupos);
		parametros.put("listaDeUnidades", listaDeUnidades);
		if(contratoDto != null && contratoDto.getColsUploadGED() !=null && contratoDto.getColsUploadGED().size() > 0)
			parametros.put("listaAnexos", (List<UploadDTO>)contratoDto.getColsUploadGED());
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( definirListasExclusaoRegistros)
	 *
	 * @since 30/09/2015
	 * @author ibimon.morais
	 */
	private void definirListasExclusaoRegistros(final DocumentHTML document, final Map<String, Object> parametros) throws Exception {
		parametros.put("listaExclusaoAcordNSC", this.obterListaParaExclusaoDeNiveisDeServicoContrato(document));
		parametros.put("listaExclusaoPerfilContrato", this.obterListaParaExclusaoDePerfilContrato(document));
		parametros.put("listaExclusaoDeProdutos", this.obterListaParaExclusaoDoProdutoContrato(document));
		parametros.put("listaExclusaoDeMatriz", this.obterListaParaExclusaoDeMatrizDoContrato(document));
		parametros.put("listaFormulasDeFormulasOs", this.obterListaParaExclusaoDeFormulasOsDoContrato(document));
		parametros.put("listaExclusaoDeContratosGrupos", this.obterListaParaExclusaoContratosGrupos(document));
		parametros.put("listaExclusaoDeUnidades", this.obterListaParaExclusaoContratosUnidades(document));
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( definirValoresDoFormulario)
	 *
	 * @since 18/09/2015
	 * @author ibimon.morais
	 */
	private void definirControlesDeValoresDoFormulario(final DocumentHTML document, final CadastroContratoDTO dto, final HttpServletRequest request, final HttpServletResponse response)
			throws Exception {
		if (dto != null && dto.getIdContrato() != null) {
			ContratoDTO contratoDTO = new ContratoDTO();
			contratoDTO.setIdContrato(dto.getIdContrato());
			contratoDTO = this.getContratoService().restore(contratoDTO);

			final HTMLForm form = document.getForm("formCadastroContrato");
			this.limparCamposDoFormularioAposSalvar(document, request, response);
			this.definirValorCliente(contratoDTO, document);
			this.definirValorFornecedor(contratoDTO, document);
			this.definirControlesDasAbas(document, request, response, contratoDTO);

			// Setando o formulario para impressao na tela
			form.setValues(contratoDTO);
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( definirControlesDasAbas)
	 *
	 * @since 30/09/2015
	 * @author ibimon.morais
	 */
	private void definirControlesDasAbas(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response, final ContratoDTO contratoDTO) throws Exception {
		this.definirAcordoNivelServicoNoContrato(contratoDTO, document, request);
		this.definirComplexidadeContrato(contratoDTO, document, request);
		this.definirHistoricoAuditoriaContrato(document, request, response, contratoDTO);
		this.definirPerfisDoContrato(contratoDTO, document, request);
		this.definirProdutosDoContrato(contratoDTO, document, request);
		this.definirMatrizComunicacaoDoContrato(contratoDTO, document, request);
		this.definirFormulaDoContrato(contratoDTO, document, request);
		this.definirContratosGrupo(contratoDTO, document, request);
		this.definirContratosUnidades(contratoDTO, document, request);
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( definirValorCliente)
	 *
	 * @since 17/09/2015
	 * @author ibimon.morais
	 */
	private void definirValorCliente(final ContratoDTO dto, final DocumentHTML document) throws LogicException, ServiceException {
		if (dto != null && dto.getIdCliente() != null) {
			final ClienteDTO cliente = this.restoreCliente(dto);
			if (StringUtils.isNotBlank(cliente.getNomeRazaoSocial())) {
				document.executeScript("document.getElementById('nomeRazaoSocialSelecionado').value = '".concat(cliente.getNomeRazaoSocial()).concat("';"));
			}
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( restoreCliente)
	 *
	 * @since 22/09/2015
	 * @author ibimon.morais
	 */
	private ClienteDTO restoreCliente(final ContratoDTO contrato) throws LogicException, ServiceException {
		ClienteDTO cliente = new ClienteDTO();
		if (contrato != null && contrato.getIdCliente() != null) {
			cliente.setIdCliente(contrato.getIdCliente());
			cliente = this.getClienteService().restore(cliente);
		}
		return cliente;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( definirValorFornecedor)
	 *
	 * @since 17/09/2015
	 * @author ibimon.morais
	 */
	private void definirValorFornecedor(final ContratoDTO dto, final DocumentHTML document) throws LogicException, ServiceException {
		if (dto != null && dto.getIdCliente() != null) {
			final FornecedorDTO fornecedor = this.restoreFornecedor(dto);
			if (StringUtils.isNotBlank(fornecedor.getNomeFantasia())) {
				document.executeScript("document.getElementById('nomeFornecedorSelecionado').value = '".concat(fornecedor.getNomeFantasia()).concat("';"));
			}
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( restoreFornecedor)
	 *
	 * @since 22/09/2015
	 * @author ibimon.morais
	 */
	private FornecedorDTO restoreFornecedor(final ContratoDTO contrato) throws LogicException, ServiceException {
		FornecedorDTO fornecedor = new FornecedorDTO();
		if (contrato != null && contrato.getIdCliente() != null) {
			fornecedor.setIdFornecedor(contrato.getIdFornecedor());
			fornecedor = this.getFornecedorService().restore(fornecedor);
		}
		return fornecedor;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_(restoreMoeda )
	 *
	 * @since 22/09/2015
	 * @author ibimon.morais
	 */
	private String getNomeMoeda(final Integer idMoeda) {
		String nomeMoeda = "";
		try {
			if (idMoeda != null) {
				MoedaDTO moedaDto = new MoedaDTO();
				moedaDto.setIdMoeda(idMoeda);
				moedaDto = (MoedaDTO) this.getMoedaService().restore(moedaDto);
				if (moedaDto != null) {
					nomeMoeda = moedaDto.getNomeMoeda();
				}
			}
		} catch (final LogicException | ServiceException e) {
			e.printStackTrace();
		}
		return nomeMoeda;
	}

	/**
	 * @author joao.morais
	 * @since 15/01/2016
	 */
	private void carregaComboCondicaoOperacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("horaSuporte");
		iniciarCombos(document, request, combo);

		Collection<CondicaoOperacaoDTO> listCondicaoOperacaoDto = this.getCondicaoOperacaoService().list();

		if (listCondicaoOperacaoDto != null) {
			for (CondicaoOperacaoDTO condicaoOperacaoDto : listCondicaoOperacaoDto) {
				if (condicaoOperacaoDto.getDataFim() == null) {
					combo.addOption(String.valueOf(condicaoOperacaoDto.getIdCondicaoOperacao()), condicaoOperacaoDto.getNomeCondicaoOperacao());
				}
			}
		}
	}

	/**
	 * @author joao.morais
	 * @since 04/04/2016
	 */
	private void carregaComboPermiteCadastroSolicitante(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("cadastroManualUsuario");
		iniciarCombos(document, request, combo);

		combo.addOption("S", UtilI18N.internacionaliza(request, "citcorpore.comum.sim"));
		combo.addOption("N", UtilI18N.internacionaliza(request, "citcorpore.comum.nao"));

	}

	/**
	 * @author ibimon.morais
	 * @since 15/09/2015
	 */
	@SuppressWarnings("unchecked")
	private void carregarDadosComboGrupoSolicitante(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final HTMLSelect combo = document.getSelectById("idGrupoSolicitante");
		this.iniciarCombos(document, request, combo);
		final Collection<GrupoDTO> listaDeGruposSolicitantesAtivos = this.getGrupoService().listarGruposAtivos();

		if (listaDeGruposSolicitantesAtivos != null) {
			for (final GrupoDTO grupo : listaDeGruposSolicitantesAtivos) {
				combo.addOption(String.valueOf(grupo.getIdGrupo()), grupo.getNome());
			}
		}
	}

	/**
	 * @author ibimon.morais
	 * @since 15/09/2015
	 */
	private void carregarDadosComboMoedas(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {

		final HTMLSelect combo = document.getSelectById("idMoeda");
		this.iniciarCombos(document, request, combo);
		final Collection<MoedaDTO> listaDeMoedasConsultada = this.getMoedaService().list();

		if (listaDeMoedasConsultada != null) {
			for (final MoedaDTO itemConsultado : listaDeMoedasConsultada) {
				combo.addOption(String.valueOf(itemConsultado.getIdMoeda()), itemConsultado.getNomeMoeda());
			}
		}
	}

	/**
	 * @author ibimon.morais
	 * @since 15/09/2015
	 */
	private void carregarDadosComboSituacao(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final HTMLSelect combo = document.getSelectById("situacao");
		this.iniciarCombos(document, request, combo);

		for (final SituacaoContrato sit : SituacaoContrato.values()) {
			combo.addOption(sit.getIdentificador(), UtilI18N.internacionaliza(request, sit.getChave()));
		}
	}

	/**
	 * @author ibimon.morais
	 * @since 15/09/2015
	 */
	private void carregarDadosComboTipoAcordoContrato(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		CadastroContratoDTO cadastroContrato = new CadastroContratoDTO();
		if (document.getBean() instanceof CadastroContratoDTO) {
			cadastroContrato = (CadastroContratoDTO) document.getBean();
		}
		this.definirItensAcordoNivelServicoContrato(document, request, cadastroContrato);
	}

	/**
	 *
	 * projeto-missao_novo_paradigma - CadastroContrato.java_(#definirItensAcordoNivelServicoContrato).
	 *
	 * @since 17/11/2015
	 * @author ibimon.morais
	 */
	private void definirItensAcordoNivelServicoContrato(final DocumentHTML document, final HttpServletRequest request, final CadastroContratoDTO cadastroContrato) throws Exception {
		final HTMLSelect combo = document.getSelectById("tipo");
		this.iniciarCombos(document, request, combo);

		if ("APOIO".equalsIgnoreCase(cadastroContrato.getTipoTela())) {
			combo.addOption(TipoAcordoContrato.ACORDO_NIVEL_OPERACIONAL.getIdentificador(), UtilI18N.internacionaliza(request, TipoAcordoContrato.ACORDO_NIVEL_OPERACIONAL.getChave()));
			combo.addOption(TipoAcordoContrato.CONTRATO_APOIO.getIdentificador(), UtilI18N.internacionaliza(request, TipoAcordoContrato.CONTRATO_APOIO.getChave()));
		} else if ("NEGOCIO".equalsIgnoreCase(cadastroContrato.getTipoTela())) {
			combo.removeAllOptions();
			combo.addOption(TipoAcordoContrato.CONTRATO.getIdentificador(), UtilI18N.internacionaliza(request, TipoAcordoContrato.CONTRATO.getChave()));
		} else {
			for (final TipoAcordoContrato tipoAcordoContrato : TipoAcordoContrato.values()) {
				combo.addOption(tipoAcordoContrato.getIdentificador(), UtilI18N.internacionaliza(request, tipoAcordoContrato.getChave()));
			}
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( carregarDadosComboFormaContato)
	 *
	 * @since 28/09/2015
	 * @author ibimon.morais
	 */
	private void carregarDadosComboFormaContato(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final HTMLSelect combo = document.getSelectById("idFormaContato");
		this.iniciarCombos(document, request, combo);

		for (final CommunicationMatrixContactType contactType : CommunicationMatrixContactType.values()) {
			combo.addOption(String.valueOf(contactType.getId()), UtilI18N.internacionaliza(request, contactType.getI18NKey()));
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( carregarDadosComboFrequencia)
	 *
	 * @since 28/09/2015
	 * @author ibimon.morais
	 */
	private void carregarDadosComboFrequencia(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final HTMLSelect combo = document.getSelectById("idFrequencia");
		this.iniciarCombos(document, request, combo);

		for (final CommunicationMatrixFrequencyType frequencyType : CommunicationMatrixFrequencyType.values()) {
			combo.addOption(String.valueOf(frequencyType.getId()), UtilI18N.internacionaliza(request, frequencyType.getI18NKey()));
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( carregarDadosComboTipoRegistro)
	 *
	 * @since 28/09/2015
	 * @author ibimon.morais
	 */
	private void carregarDadosComboTipoRegistro(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final HTMLSelect combo = document.getSelectById("idTipoRegistro");
		this.iniciarCombos(document, request, combo);

		for (final CommunicationMatrixRecordType recordType : CommunicationMatrixRecordType.values()) {
			combo.addOption(String.valueOf(recordType.getId()), UtilI18N.internacionaliza(request, recordType.getI18NKey()));
		}
	}

	/**
	 * @author ibimon.morais
	 * @since 15/09/2015
	 */
	private void iniciarCombos(final DocumentHTML document, final HttpServletRequest request, final HTMLSelect combo) throws Exception {
		combo.removeAllOptions();
		combo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( limparCamposDoFormularioAposSalvar)
	 *
	 * @since 24/09/2015
	 * @author ibimon.morais
	 */
	public void limparCamposDoFormularioAposSalvar(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final HTMLTable tabelaDeAcordosNiveisDeServicosDoContrato = document.getTableById("tblANSC");
		final HTMLTable tabelaDePerfilDoContrato = document.getTableById("tblPerfilContrato");
		final HTMLTable tabelaDeProdutoDoContrato = document.getTableById("tblProdutoContrato");
		final HTMLTable tabelaMatrizComunicacao = document.getTableById("tblMatrizContrato");
		final HTMLTable tabelaPerfilContrato = document.getTableById("tblPerfilContrato");
		final HTMLTable tabelaFormulaContrato = document.getTableById("tblFormula");
		final HTMLTable tblContratosGrupos = document.getTableById("tblContratosGrupos");
		final HTMLTable tblContratosUnidades = document.getTableById("tblContratosUnidades");
		final HTMLElement divAuditoriaContrato = document.getElementById("idTabelaHistoricoAuditoriaContrato");

		this.deletarLinhasDasTabelas(tabelaDeAcordosNiveisDeServicosDoContrato, tabelaDePerfilDoContrato, tabelaDeProdutoDoContrato, tabelaMatrizComunicacao, tabelaPerfilContrato, tabelaFormulaContrato, divAuditoriaContrato, tblContratosGrupos, tblContratosUnidades);
		
		final HTMLForm form = document.getForm("formCadastroContrato");
		this.limparFormulario(form);
		limparAnexos(document,request,response);
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( limparFormulario)
	 *
	 * @since 30/09/2015
	 * @author ibimon.morais
	 */
	private void limparFormulario(final HTMLForm form) {
		form.clear();
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( deletarLinhasDasTabelas)
	 *
	 * @since 30/09/2015
	 * @author ibimon.morais
	 */
	private void deletarLinhasDasTabelas(final HTMLTable tabelaDeAcordosNiveisDeServicosDoContrato, final HTMLTable tabelaDePerfilDoContrato, final HTMLTable tabelaDeProdutoDoContrato,
			final HTMLTable tabelaMatrizComunicacao, final HTMLTable tabelaPerfilContrato, final HTMLTable tabelaFormulaContrato, final HTMLElement divAuditoriaContrato,
			final HTMLTable tblContratosGrupos, final HTMLTable tblContratosUnidades) {
		tabelaDeAcordosNiveisDeServicosDoContrato.deleteAllRows();
		tabelaDePerfilDoContrato.deleteAllRows();
		tabelaDeProdutoDoContrato.deleteAllRows();
		tabelaMatrizComunicacao.deleteAllRows();
		tabelaPerfilContrato.deleteAllRows();
		tabelaFormulaContrato.deleteAllRows();
		tblContratosGrupos.deleteAllRows();
		tblContratosUnidades.deleteAllRows();
		divAuditoriaContrato.setValue("");
	}

	// ------------ABA NIVEL DE SERVICO CONTRATO-----------------//

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( definirAcordoNivelServicoNoContrato)
	 *
	 * @since 18/09/2015
	 * @author ibimon.morais
	 */
	@SuppressWarnings("unchecked")
	private void definirAcordoNivelServicoNoContrato(final ContratoDTO dto, final DocumentHTML document, final HttpServletRequest request) throws Exception {
		if (dto != null && dto.getIdContrato() != null) {
			List<AcordoNivelServicoContratoDTO> listaDeAcordosPeloIdDoContrato = new ArrayList<AcordoNivelServicoContratoDTO>(0);
			listaDeAcordosPeloIdDoContrato = (List<AcordoNivelServicoContratoDTO>) this.getAcordoNivelServicoContratoService().findAtivosByIdContrato(dto.getIdContrato());

			this.definirSerializacaoNivelDeServicoContrato(document, request, listaDeAcordosPeloIdDoContrato);
			this.carregarTabelaDeAcordoNivelDeServicoNoContrato(document, listaDeAcordosPeloIdDoContrato, request);
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_(
	 * carregarTabelaDeAcordoNivelDeServicoNoContrato)
	 *
	 * @since 18/09/2015
	 * @author ibimon.morais
	 */
	private void carregarTabelaDeAcordoNivelDeServicoNoContrato(final DocumentHTML document, final List<AcordoNivelServicoContratoDTO> listaDeAcordosPeloIdDoContrato, final HttpServletRequest request)
			throws Exception {

		if (listaDeAcordosPeloIdDoContrato != null && !listaDeAcordosPeloIdDoContrato.isEmpty()) {
			final HTMLTable tabelaDeAcordosNiveisDeServicosDoContrato = document.getTableById("tblANSC");
			tabelaDeAcordosNiveisDeServicosDoContrato.deleteAllRows();
			tabelaDeAcordosNiveisDeServicosDoContrato.addRowsByCollection(listaDeAcordosPeloIdDoContrato, new String[] { "descricaoAcordo", "detalhamentoAcordo", "valorLimite", "unidadeValorLimite", "dataInicio", "dataFim", "descricaoGlosa", "" }, null, UtilI18N.internacionaliza(request, "citcorpore.comum.registroJaCadastrado"), new String[] { "exibeIconesTabela" }, null, null);
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_(
	 * definirSerializacaoNivelDeServicoContrato)
	 *
	 * @since 18/09/2015
	 * @author ibimon.morais
	 */
	private void definirSerializacaoNivelDeServicoContrato(final DocumentHTML document, final HttpServletRequest request, final List<AcordoNivelServicoContratoDTO> listaDeAcordosPeloIdDoContrato)
			throws Exception {
		final String listaSerializada = br.com.citframework.util.WebUtil.serializeObjects(listaDeAcordosPeloIdDoContrato, WebUtil.getLanguage(request));
		document.executeScript("document.formCadastroContrato.colItens_Serialize.value = '".concat(listaSerializada).concat("';"));
	}

	@SuppressWarnings("unchecked")
	private List<AcordoNivelServicoContratoDTO> obterListaDeAcordosNiveisDeServico(final DocumentHTML document, final HttpServletRequest request, final ContratoDTO dtoContrato) throws Exception {
		final List<AcordoNivelServicoContratoDTO> lista = (ArrayList<AcordoNivelServicoContratoDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(AcordoNivelServicoContratoDTO.class, "colItens_Serialize", request);
		return lista;
	}

	@SuppressWarnings("unchecked")
	private List<String> obterListaParaExclusaoDeNiveisDeServicoContrato(final DocumentHTML document) throws Exception {
		final HTMLElement element = document.getElementById("colItens_Delecao_Acordo");
		final Map<String, String> mapValores = element.getDocument().getValuesForm();
		// Elemento no formulario
		final String valorElemento = StringUtils.removeEnd(mapValores.get("COLITENS_DELECAO_ACORDO"), ",");

		if (valorElemento != null) {
			final String[] itensDeId = valorElemento.split(",");
			return Arrays.asList(itensDeId);
		}

		return new ArrayList<>();
	}

	// -------------------------- TABLE COMPLEXIDADE ------------------------//
	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( htmlTableComplexidade)
	 *
	 * @since 24/09/2015
	 * @author ibimon.morais
	 */
	public void htmlTableComplexidade(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final StringBuilder htmlTabela = new StringBuilder();

		htmlTabela.append(this.montarCabecalhoTabelaComplexidade(request));

		for (final Complexidade complexidade : Complexidade.values()) {
			htmlTabela.append("<tr> ");
			htmlTabela.append(this.montarLinhaTabelaComplexidade(complexidade, request));
			htmlTabela.append(this.montarAcoesNaLinhaTabelaComplexidade(document, request, complexidade));
			htmlTabela.append("</tr> ");
		}

		htmlTabela.append(this.montarRodapeTabelaComplexidade());

		final HTMLElement divComplexidadeContrato = document.getElementById("idTabelaComplexidade");
		divComplexidadeContrato.setInnerHTML(htmlTabela.toString());
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( montarAcoesNaLinhaTabelaComplexidade)
	 *
	 * @since 22/09/2015
	 * @author ibimon.morais
	 */
	private String montarAcoesNaLinhaTabelaComplexidade(final DocumentHTML document, final HttpServletRequest request, final Complexidade complexidade) {
		final StringBuilder htmlAcaoLinha = new StringBuilder();
		final String comentarioTitulo = UtilI18N.internacionaliza(request, "gerenciaportfolio.rejeitaralteracoes");

		htmlAcaoLinha.append("<td class=\"center\" style=\"width: 30px;\">");
		if (permissao.isDeletar() && permissao.isGravar()) {
			htmlAcaoLinha.append("<a title='");
			htmlAcaoLinha.append(comentarioTitulo).append("'");
			htmlAcaoLinha.append(" onclick='limparValorComplexidadeInformado(\"");
			htmlAcaoLinha.append(complexidade.getIdentificador().toUpperCase().trim());
			htmlAcaoLinha.append("\");'");
			htmlAcaoLinha.append(" class='btn-action glyphicons no-js unshare btn-success'><i></i></a>");
		}
		htmlAcaoLinha.append("</td> ");

		return htmlAcaoLinha.toString();
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( montarCabecalhoTabelaComplexidade)
	 *
	 * @since 22/09/2015
	 * @author ibimon.morais
	 */
	private String montarCabecalhoTabelaComplexidade(final HttpServletRequest request) {
		final StringBuilder htmlCabecalhoTabela = new StringBuilder();
		htmlCabecalhoTabela.append("<table id='tblComplexidade' class='dynamicTable table table-striped table-bordered table-condensed'> ");
		htmlCabecalhoTabela.append("<tbody> ").append("<tr>");
		htmlCabecalhoTabela.append("<th width=\"5%\">").append(UtilI18N.internacionaliza(request, "gerenciaportfolio.sigla")).append("</th>");
		htmlCabecalhoTabela.append("<th width=\"35%\">").append(UtilI18N.internacionaliza(request, "gerenciaportfolio.complexidade")).append("</th>");
		htmlCabecalhoTabela.append("<th width=\"55%\">").append(UtilI18N.internacionaliza(request, "gerenciaportfolio.valorComplexidade")).append("</th>");
		htmlCabecalhoTabela.append("<th width=\"5%\">").append(UtilI18N.internacionaliza(request, "citcorpore.comum.acoes")).append("</th>");
		htmlCabecalhoTabela.append("</tr>");

		return htmlCabecalhoTabela.toString();
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( montarRodapeTabelaComplexidade)
	 *
	 * @since 22/09/2015
	 * @author ibimon.morais
	 */
	private String montarRodapeTabelaComplexidade() {
		final StringBuilder htmlRodapeTabela = new StringBuilder().append("</tbody> ").append("</table> ");

		return htmlRodapeTabela.toString();
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( montarLinhaTabelaComplexidade)
	 *
	 * @since 22/09/2015
	 * @author ibimon.morais
	 */
	private String montarLinhaTabelaComplexidade(final Complexidade complexidade, final HttpServletRequest request) {
		final String idComplexidadeEdicao = "complexidadeEdicao".concat(complexidade.getIdentificador());

		final StringBuilder htmlLinhaTabela = new StringBuilder();
		htmlLinhaTabela.append("<td>").append(UtilI18N.internacionaliza(request, complexidade.getIdentificador())).append("</td>");
		htmlLinhaTabela.append("<td>").append(UtilI18N.internacionaliza(request, complexidade.getChave())).append("</td> ");
		htmlLinhaTabela.append("<td>").append(this.montarHtmlCampoEdicaoComplexidade(idComplexidadeEdicao)).append("</td> ");

		return htmlLinhaTabela.toString();
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( montarHtmlCampoEdicaoComplexidade)
	 *
	 * @since 22/09/2015
	 * @author ibimon.morais
	 */
	private String montarHtmlCampoEdicaoComplexidade(final String idDoCampo) {
		final StringBuilder htmlCampo = new StringBuilder();
		htmlCampo.append("<input type='text' name='").append(idDoCampo).append("' id='").append(idDoCampo).append("' maxlength=\"14\" class=\"span10 Format[Moeda]\"/>");
		return htmlCampo.toString();
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( definirComplexidadeContrato)
	 *
	 * @since 21/09/2015
	 * @author ibimon.morais
	 */
	private void definirComplexidadeContrato(final ContratoDTO dto, final DocumentHTML document, final HttpServletRequest request) throws Exception {
		if (dto != null && dto.getIdContrato() != null) {
			List<ComplexidadeDTO> listaDeAcordosPeloIdDoContrato = new ArrayList<ComplexidadeDTO>(0);
			listaDeAcordosPeloIdDoContrato = this.getComplexidadeService().consultarPorIdContrato(dto.getIdContrato());

			if (listaDeAcordosPeloIdDoContrato != null && !listaDeAcordosPeloIdDoContrato.isEmpty()) {
				for (final ComplexidadeDTO complexidadeDTO : listaDeAcordosPeloIdDoContrato) {
					final String strIdElement = "complexidadeEdicao".concat(complexidadeDTO.getComplexidade());
					document.getElementById(strIdElement).setValue(complexidadeDTO.getValorComplexidade() != null ? complexidadeDTO.getValorComplexidade().toString().replace(".", ",") : "");
				}
			}
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( inserirComplexidade)
	 *
	 * @since 21/09/2015
	 * @author ibimon.morais
	 */
	@SuppressWarnings("unchecked")
	private List<ComplexidadeDTO> obterComplexidades(final Integer idContrato, final DocumentHTML document) throws Exception {
		final List<ComplexidadeDTO> listaComplexidade = new ArrayList<ComplexidadeDTO>();

		for (final Complexidade complexidade : Complexidade.values()) {
			// Pegar o valor do identificador Complexidade: A, B, E, I OU M
			final String idElementoLido = "COMPLEXIDADEEDICAO".concat(complexidade.getIdentificador());
			final HTMLElement element = document.getElementById(idElementoLido);
			final Map<String, String> mapValores = element.getDocument().getValuesForm();
			// Elemento no formulario
			final String valorElemento = mapValores.get(idElementoLido);
			final ComplexidadeDTO complexidadeDTO = new ComplexidadeDTO();
			complexidadeDTO.setIdContrato(idContrato);
			complexidadeDTO.setComplexidade(complexidade.getIdentificador());
			complexidadeDTO.setValorComplexidade(valorElemento != null ? new BigDecimal(StringUtils.isNotBlank(valorElemento) ? valorElemento.replace(",", ".") : "0.00") : null);

			listaComplexidade.add(complexidadeDTO);
		}
		return listaComplexidade;
	}

	// --------- ABA HISTORICO AUDITORIA CONTRATO ---------------//
	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( definirHistoricoAuditoriaContrato)
	 *
	 * @since 30/09/2015
	 * @author ibimon.morais
	 */
	public void definirHistoricoAuditoriaContrato(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response, final ContratoDTO contratoDto) throws Exception {
		final StringBuilder htmlTabelaHistoricoAuditoria = new StringBuilder();

		final HTMLElement divAuditoriaContrato = document.getElementById("idTabelaHistoricoAuditoriaContrato");
		// Montando o cabecalho da tabela
		htmlTabelaHistoricoAuditoria.append(this.montarCabecalhoTabelaHistoricoAuditoria(request));
		Collection<ContratoHistoricoDTO> listaHistoricoAuditoriaContrato = null;

		if (contratoDto != null && contratoDto.getIdContrato() != null) {
			listaHistoricoAuditoriaContrato = this.getContratoHistoricoService().findByIdContratoOrderHist(contratoDto.getIdContrato());
			if (listaHistoricoAuditoriaContrato != null) {
				// Cliente
				final ClienteDTO cliente = this.restoreCliente(contratoDto);
				// Fornecedor
				final FornecedorDTO fornecedor = this.restoreFornecedor(contratoDto);
				for (final ContratoHistoricoDTO historicoServicoDTO : listaHistoricoAuditoriaContrato) {
					htmlTabelaHistoricoAuditoria.append(this.montarCorpoTabelaHistoricoAuditoria(request, historicoServicoDTO, cliente, fornecedor));
				}
			}
			htmlTabelaHistoricoAuditoria.append("</tbody> ");
			htmlTabelaHistoricoAuditoria.append("</table>");
			htmlTabelaHistoricoAuditoria.append("</div>");
		}
		divAuditoriaContrato.setInnerHTML(htmlTabelaHistoricoAuditoria.toString());
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( montarCabecalhoTabelaHistoricoAuditoria)
	 *
	 * @since 22/09/2015
	 * @author ibimon.morais
	 */
	private String montarCabecalhoTabelaHistoricoAuditoria(final HttpServletRequest request) {
		final StringBuilder htmlCabecalho = new StringBuilder();
		htmlCabecalho.append("<div class=\"table-responsive divTabelasCadastroContrato\" id=\"divTabelaAuditoriaContrato\" style=\"max-height: 400px !important;\"> ");
		htmlCabecalho.append("<table id=\"tblHistoricoAuditoria\" class=\"dynamicTable table table-striped table-bordered table-condensed\">");
		htmlCabecalho.append("<thead> ");
		htmlCabecalho.append("<tr>");
		htmlCabecalho.append("<td>").append("&nbsp;").append("</td>");
		htmlCabecalho.append("<td>").append("<b>").append(UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "contrato.cliente"))).append("</b></td>");
		htmlCabecalho.append("<td>").append("<b>").append(UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "contrato.fornecedor"))).append("</b></td>");
		htmlCabecalho.append("<td>").append("<b>").append(UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "contrato.tipo"))).append("</b></td>");
		htmlCabecalho.append("<td>").append("<b>").append(UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "contrato.numero"))).append("</b></td>");
		htmlCabecalho.append("<td>").append("<b>").append(UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "contrato.datacontrato"))).append("</b></td>");
		htmlCabecalho.append("<td>").append("<b>").append(UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "contrato.situacao"))).append("</b></td>");
		htmlCabecalho.append("<td>").append("<b>").append(UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "contrato.datafimcontrato"))).append("</b></td>");
		htmlCabecalho.append("<td>").append("<b>").append(UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "contrato.modificadopor"))).append("</b></td>");
		htmlCabecalho.append("<td>").append("<b>").append(UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "contrato.modificadoem"))).append("</b></td>");
		htmlCabecalho.append("</tr>");
		htmlCabecalho.append("</thead> ");
		htmlCabecalho.append("<tbody> ");
		return htmlCabecalho.toString();
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( montarCorpoTabelaHistoricoAuditoria)
	 *
	 * @since 22/09/2015
	 * @author ibimon.morais
	 */
	private String montarCorpoTabelaHistoricoAuditoria(final HttpServletRequest request, final ContratoHistoricoDTO historicoDTO, final ClienteDTO cliente, final FornecedorDTO fornecedor) {
		final StringBuilder htmlCorpo = new StringBuilder();
		htmlCorpo.append("<tr>");
		htmlCorpo.append("	<td class=\"gradeX\" style=\"font-size: 9pt;\">");
		htmlCorpo.append("		<a class=\"btn-action glyphicons circle_plus btn-primary\" onclick=\"controlarDetalhesHistoricoContrato(this, 'idContratoHist_" + historicoDTO.getIdContrato_Hist() + "')\" ><i></i></a>");
		htmlCorpo.append("	</td>");
		htmlCorpo.append("	<td class=\"gradeC\"  style=\" font-size: 9pt;\">");
		htmlCorpo.append("		").append(UtilHTML.encodeHTML(cliente.getNomeRazaoSocial())).append("");
		htmlCorpo.append("	</td>");
		htmlCorpo.append("	<td class=\"gradeA\"  style=\" font-size: 9pt;\">");
		htmlCorpo.append("		").append(UtilHTML.encodeHTML(fornecedor.getRazaoSocial())).append("");
		htmlCorpo.append("	</td>");
		htmlCorpo.append("	<td class=\"gradeA\"  style=\" font-size: 9pt;\">");
		htmlCorpo.append("		").append(UtilHTML.encodeHTML(this.getDescricaoTipoContrato(historicoDTO, request))).append("");
		htmlCorpo.append("	</td>");
		htmlCorpo.append("	<td class=\"gradeA\"  style=\" font-size: 9pt;\">");
		htmlCorpo.append("		").append(UtilHTML.encodeHTML(historicoDTO.getNumero())).append("");
		htmlCorpo.append("	</td>");
		htmlCorpo.append("	<td class=\"gradeA\"  style=\" font-size: 9pt;\">");
		htmlCorpo.append("		").append(UtilHTML.encodeHTML(this.configurarDatasContrato(historicoDTO.getDataContrato(), request))).append("");
		htmlCorpo.append("	</td>");
		htmlCorpo.append("	<td class=\"gradeA\"  style=\" font-size: 9pt;\">");
		htmlCorpo.append("		").append(UtilHTML.encodeHTML(this.getDescricaoSituacaoContrato(historicoDTO.getSituacao(), request))).append("");
		htmlCorpo.append("	</td>");
		htmlCorpo.append("	<td class=\"gradeA\"  style=\" font-size: 9pt;\">");
		htmlCorpo.append("		").append(UtilHTML.encodeHTML(this.configurarDatasContrato(historicoDTO.getDataFimContrato(), request))).append("");
		htmlCorpo.append("	</td>");
		htmlCorpo.append("	<td class=\"gradeA\"  style=\" font-size: 9pt;\">");
		htmlCorpo.append("		").append(UtilHTML.encodeHTML(historicoDTO.getModificadoPor())).append("");
		htmlCorpo.append("	</td>");
		htmlCorpo.append("	<td class=\"gradeA\"  style=\" font-size: 9pt;\">");
		htmlCorpo.append("		").append(UtilHTML.encodeHTML(this.configurarDatasContrato(historicoDTO.getModificadoEm(), request))).append("");
		htmlCorpo.append("	</td>");
		htmlCorpo.append("</tr>");

		htmlCorpo.append(this.montarVisaoDetalhesPorIdContratoNaTabelaHistoricoAuditoria(request, historicoDTO, cliente, fornecedor));

		return htmlCorpo.toString();
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_(
	 * montarVisaoDetalhesPorIdContratoNaTabelaHistoricoAuditoria)
	 *
	 * @since 30/09/2015
	 * @author ibimon.morais
	 */
	private String montarVisaoDetalhesPorIdContratoNaTabelaHistoricoAuditoria(final HttpServletRequest request, final ContratoHistoricoDTO historicoDTO, final ClienteDTO cliente,
			final FornecedorDTO fornecedor) {
		final StringBuilder htmlCorpo = new StringBuilder();
		htmlCorpo.append("<tr id=\"idContratoHist_" + historicoDTO.getIdContrato_Hist() + "\" style='display:none'>");
		htmlCorpo.append("<td colspan='11' > ");
		htmlCorpo.append("<div class=\"table-responsive\" > ");
		htmlCorpo.append("<table class=\"table table-bordered table-condensed table-striped table-vertical-center\">");
		htmlCorpo.append("<tr>");
		htmlCorpo.append("	       <td colspan='2' class=\"gradeC\"  style=\" font-size: 10pt; font-weight: bold\">");
		htmlCorpo.append("		   ").append(UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "contrato.objeto"))).append("");
		htmlCorpo.append("	      </td>");
		htmlCorpo.append("      </tr>");

		htmlCorpo.append("      <tr>");
		htmlCorpo.append("	       <td colspan='2' class=\"gradeA\"  style=\" font-size: 9pt;\"> ");
		htmlCorpo.append("		   ").append(UtilHTML.encodeHTML(historicoDTO.getObjeto())).append("");
		htmlCorpo.append("	      </td>");
		htmlCorpo.append("      </tr>");

		htmlCorpo.append("      <tr>");
		htmlCorpo.append("	       <td colspan='2' class=\"gradeC\"  style=\" font-size: 10pt; font-weight: bold\">");
		htmlCorpo.append("		     ").append(UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "contrato.moeda"))).append("");
		htmlCorpo.append("	       </td>");
		htmlCorpo.append("      </tr>");

		htmlCorpo.append("      <tr>");
		htmlCorpo.append("	       <td colspan='2' class=\"gradeA\"  style=\" font-size: 9pt;\">");
		htmlCorpo.append("		     ").append(UtilHTML.encodeHTML(this.getNomeMoeda(historicoDTO.getIdMoeda()))).append("");
		htmlCorpo.append("	       </td>");
		htmlCorpo.append("      </tr>");

		htmlCorpo.append("      <tr>");
		htmlCorpo.append("	       <td class=\"gradeC\"  style=\" font-size: 10pt; font-weight: bold \">");
		htmlCorpo.append("		    ").append(UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "contrato.cotacaomoeda"))).append("");
		htmlCorpo.append("	       </td>");
		htmlCorpo.append("      </tr>");

		htmlCorpo.append("      <tr>");
		htmlCorpo.append("	       <td class=\"gradeA\"  style=\" font-size: 9pt;\">");
		htmlCorpo.append("		    ").append(UtilHTML.encodeHTML(this.getDescricaoCotacao(historicoDTO, request))).append("");
		htmlCorpo.append("	       </td>");
		htmlCorpo.append("      </tr>");

		htmlCorpo.append("      <tr>");
		htmlCorpo.append("	      <td class=\"gradeC\"  style=\" font-size: 10pt; font-weight: bold\">");
		htmlCorpo.append("		   ").append(UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "contrato.valorestimado"))).append("");
		htmlCorpo.append("	      </td>");
		htmlCorpo.append("      </tr>");

		htmlCorpo.append("      <tr>");
		htmlCorpo.append("	      <td class=\"gradeA\"  style=\" font-size: 9pt;\">");
		htmlCorpo.append("		   ").append(UtilHTML.encodeHTML(this.getDescricaoValorEstimado(historicoDTO, request))).append("");
		htmlCorpo.append("	      </td>");
		htmlCorpo.append("      </tr>");

		htmlCorpo.append("      <tr>");
		htmlCorpo.append("        <td colspan='11'>");
		htmlCorpo.append("         <b>").append(UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "contrato.dadoslog"))).append("</b>");
		htmlCorpo.append("        </td>");
		htmlCorpo.append("      </tr>");

		htmlCorpo.append("      <tr>");
		htmlCorpo.append("        <td colspan='11' style=\" font-size: 8pt;\">");
		htmlCorpo.append("		     ").append(UtilHTML.encodeHTML(this.getDescriacaoConteudo(historicoDTO, request))).append("");
		htmlCorpo.append("        </td>");
		htmlCorpo.append("      </tr>");
		htmlCorpo.append("  </table>");
		htmlCorpo.append("</div>");
		htmlCorpo.append("</td>");
		htmlCorpo.append("</tr>");
		htmlCorpo.append("<tr style='display:none'>");
		htmlCorpo.append("</tr>");

		return htmlCorpo.toString();
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( getDescriacaoConteudo)
	 *
	 * @since 22/09/2015
	 * @author ibimon.morais
	 */
	private String getDescriacaoConteudo(final ContratoHistoricoDTO contratoHistoricoDTO, final HttpServletRequest request) {
		String strTable = "&nbsp;";
		if (contratoHistoricoDTO.getConteudodados() != null) {
			strTable = UtilHTML.encodeHTML(contratoHistoricoDTO.getConteudodados().replaceAll("\n", "<br>"));
		}
		return strTable;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( getDescricaoValorEstimado)
	 *
	 * @since 22/09/2015
	 * @author ibimon.morais
	 */
	private String getDescricaoValorEstimado(final ContratoHistoricoDTO contratoHistoricoDTO, final HttpServletRequest request) {
		String strTable = "&nbsp;";
		if (contratoHistoricoDTO.getValorEstimado() != null) {
			strTable = UtilFormatacao.formatDouble(contratoHistoricoDTO.getValorEstimado(), 2);
		}
		return strTable;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( getDescricaoCotacao)
	 *
	 * @since 22/09/2015
	 * @author ibimon.morais
	 */
	private String getDescricaoCotacao(final ContratoHistoricoDTO contratoHistoricoDTO, final HttpServletRequest request) {
		String strTable = "&nbsp;";
		if (contratoHistoricoDTO.getCotacaoMoeda() != null) {
			strTable = UtilFormatacao.formatDouble(contratoHistoricoDTO.getCotacaoMoeda(), 2);
		}
		return strTable;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( getDescricaoSituacaoContrato)
	 *
	 * @since 22/09/2015
	 * @author ibimon.morais
	 */
	private String getDescricaoSituacaoContrato(final String situacao, final HttpServletRequest request) {
		return UtilI18N.internacionaliza(request, SituacaoContrato.fromTipo(situacao).getChave());
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( getDescricaoTipoContrato)
	 *
	 * @since 22/09/2015
	 * @author ibimon.morais
	 */
	private String getDescricaoTipoContrato(final ContratoHistoricoDTO contratoHistoricoDTO, final HttpServletRequest request) {
		String tipo = contratoHistoricoDTO.getTipo();

		switch (contratoHistoricoDTO.getTipo()) {
		case "A":
			tipo = UtilI18N.internacionaliza(request, "contrato.tipo.ano");
			break;

		case "C":
			tipo = UtilI18N.internacionaliza(request, "contrato.tipo.cliente");
			break;

		default:
			tipo = UtilI18N.internacionaliza(request, "contrato.tipo.terceiro");
			break;
		}
		return tipo;
	}

	/**
	 * Metodo responsavel por:
	 *
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( configurarDatasContrato)
	 *
	 * @since 22/09/2015
	 * @author ibimon.morais
	 */
	private String configurarDatasContrato(final java.sql.Date dataIndicada, final HttpServletRequest request) {
		String strData = "&nbsp;";
		if (dataIndicada != null) {
			strData = "".concat(UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, dataIndicada, WebUtil.getLanguage(request))).concat("");
		}
		return strData;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( saveHistoricoAuditoriaContrato)
	 *
	 * @since 23/09/2015
	 * @author ibimon.morais
	 */
	private ContratoHistoricoDTO obterHistoricoAuditoriaContrato(final ContratoDTO contratoDto, final HttpServletRequest request) throws Exception {
		final ContratoHistoricoDTO historicoServicoDto = new ContratoHistoricoDTO();
		Reflexao.copyPropertyValues(contratoDto, historicoServicoDto);

		if (historicoServicoDto != null && historicoServicoDto.getIdContrato() != null) {
			historicoServicoDto.setCriadoEm(UtilDatas.getDataAtual());
			historicoServicoDto.setModificadoEm(UtilDatas.getDataAtual());

			this.montarConteudoDadosHistorico(historicoServicoDto);
		}
			final UsuarioDTO usuario = WebUtil.getUsuario(request);
			if (usuario != null && usuario.getNomeUsuario() != null) {
				historicoServicoDto.setCriadoPor(usuario.getNomeUsuario());
				historicoServicoDto.setModificadoPor(usuario.getNomeUsuario());
			}
		return historicoServicoDto;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( montarConteudoDadosHistorico)
	 *
	 * @since 23/09/2015
	 * @author ibimon.morais
	 */
	private void montarConteudoDadosHistorico(final ContratoHistoricoDTO historicoServicoDto) throws Exception {
		final List<String> lista = Reflexao.getAllProperties(historicoServicoDto);
		final StringBuilder dados = new StringBuilder();
		for (int i = 0; i < lista.size(); i++) {
			final String campo = lista.get(i).toString();
			final Object valor = Reflexao.getPropertyValue(historicoServicoDto, campo);
			if (valor != null) {
				try {
					if (dados.length() > 0) {
						dados.append("\n\r");
					}
					dados.append(campo);
					dados.append(" = ");
					dados.append(valor);
				} catch (final Exception e) {
				}
			}
		}
		historicoServicoDto.setConteudodados(dados.toString());
	}

	// ---------------------- ABA PERFIS DO CONTRATO -----------------------//

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( definirPerfisDoContrato)
	 *
	 * @since 23/09/2015
	 * @author ibimon.morais
	 */
	private void definirPerfisDoContrato(final ContratoDTO dto, final DocumentHTML document, final HttpServletRequest request) throws Exception {
		if (dto != null && dto.getIdContrato() != null) {
			List<ContratoPerfilDTO> listaDeAcordosPeloIdDoContrato = new ArrayList<ContratoPerfilDTO>(0);
			listaDeAcordosPeloIdDoContrato = (List<ContratoPerfilDTO>) this.getContratoPerfilService().findByIdContrato(dto.getIdContrato());

			this.definirSerializacaoPerfilDoContrato(document, request, listaDeAcordosPeloIdDoContrato);
			this.carregarTabelaDePerfilDoContrato(document, listaDeAcordosPeloIdDoContrato, request);
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( definirSerializacaoPerfilDOContrato)
	 *
	 * @since 23/09/2015
	 * @author ibimon.morais
	 */
	private void definirSerializacaoPerfilDoContrato(final DocumentHTML document, final HttpServletRequest request, final List<ContratoPerfilDTO> listaPerfis) throws Exception {
		final String listaSerializada = br.com.citframework.util.WebUtil.serializeObjects(listaPerfis, WebUtil.getLanguage(request));
		document.executeScript("document.formCadastroContrato.colItens_Perfis_Serialize.value = '".concat(listaSerializada).concat("';"));
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( carregarTabelaDePerfidDoContrato)
	 *
	 * @since 23/09/2015
	 * @author ibimon.morais
	 */
	private void carregarTabelaDePerfilDoContrato(final DocumentHTML document, final List<ContratoPerfilDTO> listaDePerfilDoContrato, final HttpServletRequest request) throws Exception {

		if (listaDePerfilDoContrato != null && !listaDePerfilDoContrato.isEmpty()) {
			final HTMLTable tabelaDePerfisDoContrato = document.getTableById("tblPerfilContrato");
			tabelaDePerfisDoContrato.deleteAllRows();
			tabelaDePerfisDoContrato.addRowsByCollection(listaDePerfilDoContrato, new String[] { "nomePerfilContrato", "custoHora", "" }, null, UtilI18N.internacionaliza(request, "citcorpore.comum.registroJaCadastrado"), new String[] { "exibeIconesTabelaPerfil" }, null, null);
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( savePerfisDoContrato)
	 *
	 * @since 23/09/2015
	 * @author ibimon.morais
	 */
	@SuppressWarnings("unchecked")
	private List<ContratoPerfilDTO> obterPerfisDoContrato(final ContratoDTO contratoDto, final HttpServletRequest request) throws Exception {
		final List<ContratoPerfilDTO> lista = (ArrayList<ContratoPerfilDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(ContratoPerfilDTO.class, "colItens_Perfis_Serialize", request);
		return lista;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( obterListaParaExclusaoDePerfilContrato)
	 *
	 * @since 24/09/2015
	 * @author ibimon.morais
	 */
	@SuppressWarnings("unchecked")
	private List<String> obterListaParaExclusaoDePerfilContrato(final DocumentHTML document) throws Exception {
		final HTMLElement element = document.getElementById("colItens_Delecao_Perfil");
		final Map<String, String> mapValores = element.getDocument().getValuesForm();
		// Elemento no formulario
		final String valorElemento = StringUtils.removeEnd(mapValores.get("COLITENS_DELECAO_PERFIL"), ",");
		List<String> listaretorno = new ArrayList<String>();
		if (StringUtils.isNotEmpty(valorElemento)) {
			listaretorno = Arrays.asList(valorElemento.split(","));
		}
		return listaretorno;
	}

	// ---------------------- ABA PRODUTO CONTRATO -----------------------//

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( definirProdutosDoContrato)
	 *
	 * @since 24/09/2015
	 * @author ibimon.morais
	 */
	@SuppressWarnings("unchecked")
	private void definirProdutosDoContrato(final ContratoDTO dto, final DocumentHTML document, final HttpServletRequest request) throws Exception {
		if (dto != null && dto.getIdContrato() != null) {
			List<ProdutoContratoDTO> listaDeProdutosPeloIdDoContrato = new ArrayList<ProdutoContratoDTO>(0);
			listaDeProdutosPeloIdDoContrato = (List<ProdutoContratoDTO>) this.getProdutoContratoService().findByIdContrato(dto.getIdContrato());

			this.definirSerializacaoProdutoDoContrato(document, request, listaDeProdutosPeloIdDoContrato);
			this.carregarTabelaDoProdutoDoContrato(document, listaDeProdutosPeloIdDoContrato, request);
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( definirSerializacaoProdutoDoContrato)
	 *
	 * @since 24/09/2015
	 * @author ibimon.morais
	 */
	private void definirSerializacaoProdutoDoContrato(final DocumentHTML document, final HttpServletRequest request, final List<ProdutoContratoDTO> listaPerfis) throws Exception {
		final String listaSerializada = br.com.citframework.util.WebUtil.serializeObjects(listaPerfis, WebUtil.getLanguage(request));
		document.executeScript("document.formCadastroContrato.colItens_Produto_Serialize.value = '".concat(listaSerializada).concat("';"));
	}

	/***
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( carregarTabelaDoProdutoDoContrato)
	 *
	 * @since 24/09/2015
	 * @author ibimon.morais
	 */
	private void carregarTabelaDoProdutoDoContrato(final DocumentHTML document, final List<ProdutoContratoDTO> listaDeProdutoContrato, final HttpServletRequest request) throws Exception {

		final HTMLTable tabelaDeProdutosDoContrato = document.getTableById("tblProdutoContrato");
		tabelaDeProdutosDoContrato.deleteAllRows();
		if (listaDeProdutoContrato != null && !listaDeProdutoContrato.isEmpty()) {
			tabelaDeProdutosDoContrato.addRowsByCollection(listaDeProdutoContrato, new String[] { "nomeProduto", "" }, null, UtilI18N.internacionaliza(request, "citcorpore.comum.registroJaCadastrado"), new String[] { "exibeIconesTabelaProduto" }, null, null);
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( obterProdutosDoContrato)
	 *
	 * @since 24/09/2015
	 * @author ibimon.morais
	 */
	@SuppressWarnings("unchecked")
	private List<ProdutoContratoDTO> obterProdutosDoContrato(final ContratoDTO contratoDto, final HttpServletRequest request) throws Exception {
		final List<ProdutoContratoDTO> lista = (ArrayList<ProdutoContratoDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(ProdutoContratoDTO.class, "colItens_Produto_Serialize", request);
		return lista;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( obterListaParaExclusaoDoProdutoContrato)
	 *
	 * @since 24/09/2015
	 * @author ibimon.morais
	 */
	@SuppressWarnings("unchecked")
	private List<String> obterListaParaExclusaoDoProdutoContrato(final DocumentHTML document) throws Exception {
		final HTMLElement element = document.getElementById("colItens_Delecao_Produto");
		final Map<String, String> mapValores = element.getDocument().getValuesForm();
		// Elemento no formulario
		final String valorElemento = StringUtils.removeEnd(mapValores.get("COLITENS_DELECAO_PRODUTO"), ",");
		List<String> listaretorno = new ArrayList<String>();
		if (StringUtils.isNotEmpty(valorElemento)) {
			listaretorno = Arrays.asList(valorElemento.split(","));
		}
		return listaretorno;
	}

	// ----- ABA MATRIZ COMUNICACAO CONTRATO -----//

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( definirMatrizComunicacaoDoContrato)
	 *
	 * @since 28/09/2015
	 * @author ibimon.morais
	 */
	private void definirMatrizComunicacaoDoContrato(final ContratoDTO dto, final DocumentHTML document, final HttpServletRequest request) throws Exception {
		if (dto != null && dto.getIdContrato() != null) {
			List<MatrizContratoDTO> lista = new ArrayList<MatrizContratoDTO>(0);
			lista = (List<MatrizContratoDTO>) this.getMatrizContratoService().findByIdContrato(dto.getIdContrato());

			this.definirSerializacaoMatrizComunicacaoContrato(document, request, lista);
			this.carregarTabelaMatrizComunicacaoDoContrato(document, lista, request);
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_(
	 * definirSerializacaoMatrizComunicacaoContrato)
	 *
	 * @since 28/09/2015
	 * @author ibimon.morais
	 */
	private void definirSerializacaoMatrizComunicacaoContrato(final DocumentHTML document, final HttpServletRequest request, final List<MatrizContratoDTO> listaMatriz) throws Exception {
		final String listaSerializada = br.com.citframework.util.WebUtil.serializeObjects(listaMatriz, WebUtil.getLanguage(request));
		document.executeScript("document.formCadastroContrato.colItens_Matriz_Serialize.value = '".concat(listaSerializada).concat("';"));
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_(
	 * carregarTabelaMatrizComunicacaoDoContrato)
	 *
	 * @since 28/09/2015
	 * @author ibimon.morais
	 */
	private void carregarTabelaMatrizComunicacaoDoContrato(final DocumentHTML document, final List<MatrizContratoDTO> listaMatriz, final HttpServletRequest request) throws Exception {

		final HTMLTable tabelaMatrizSerializada = document.getTableById("tblMatrizContrato");
		tabelaMatrizSerializada.deleteAllRows();

		if (listaMatriz != null && !listaMatriz.isEmpty()) {

			for (MatrizContratoDTO matrizContratoDTO : listaMatriz) {
				matrizContratoDTO.setDescTipoRegistro(UtilI18N.internacionaliza(request, CommunicationMatrixRecordType.getChaveFromId(matrizContratoDTO.getIdTipoRegistro())));
				matrizContratoDTO.setFormaContato(UtilI18N.internacionaliza(request, CommunicationMatrixContactType.getChaveFromId(matrizContratoDTO.getIdFormaContato())));
				matrizContratoDTO.setDescFrequencia(UtilI18N.internacionaliza(request, CommunicationMatrixFrequencyType.getChaveFromId(matrizContratoDTO.getIdFrequencia())));

				tabelaMatrizSerializada.addRow(matrizContratoDTO, new String[] { "nomeGrupoEnvolvido", "responsabilidades", "descTipoRegistro", "descFrequencia", "formaContato", "" }, null,
						UtilI18N.internacionaliza(request, "citcorpore.comum.registroJaCadastrado"), new String[] { "exibeIconesTabelaMatriz" }, null, null);
			}
		}

	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( obterMatrizDoContrato)
	 *
	 * @since 28/09/2015
	 * @author ibimon.morais
	 */
	@SuppressWarnings("unchecked")
	private List<MatrizContratoDTO> obterMatrizDoContrato(final ContratoDTO contratoDto, final HttpServletRequest request) throws Exception {
		final List<MatrizContratoDTO> lista = (ArrayList<MatrizContratoDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(MatrizContratoDTO.class, "colItens_Matriz_Serialize", request);
		return lista;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( obterListaParaExclusaoDeMatrizDoContrato)
	 *
	 * @since 28/09/2015
	 * @author ibimon.morais
	 */
	private List<String> obterListaParaExclusaoDeMatrizDoContrato(final DocumentHTML document) throws Exception {
		final HTMLElement element = document.getElementById("colItens_Delecao_Matriz_Comunicacao");
		@SuppressWarnings("unchecked")
		final Map<String, String> mapValores = element.getDocument().getValuesForm();
		// Elemento no formulario
		final String valorElemento = StringUtils.removeEnd(mapValores.get("COLITENS_DELECAO_MATRIZ_COMUNICACAO"), ",");
		List<String> listaretorno = new ArrayList<String>();
		if (StringUtils.isNotEmpty(valorElemento)) {
			listaretorno = Arrays.asList(valorElemento.split(","));
		}
		return listaretorno;
	}

	// ---------------------- ABA FORMULA DO CONTRATO -----------------------//

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( definirFormulaDoContrato)
	 *
	 * @since 30/09/2015
	 * @author ibimon.morais
	 */
	private void definirFormulaDoContrato(final ContratoDTO dto, final DocumentHTML document, final HttpServletRequest request) throws Exception {
		if (dto != null && dto.getIdContrato() != null) {
			List<ContratoFormulaOsDTO> lista = new ArrayList<ContratoFormulaOsDTO>(0);
			lista = (List<ContratoFormulaOsDTO>) this.getContratoFormulaOsService().findByIdContrato(dto.getIdContrato());

			this.definirSerializacaoFormulaContrato(document, request, lista);
			this.carregarTabelaFormulasDoContrato(document, lista, request);
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( definirSerializacaoFormulaContrato)
	 *
	 * @since 30/09/2015
	 * @author ibimon.morais
	 */
	private void definirSerializacaoFormulaContrato(final DocumentHTML document, final HttpServletRequest request, final List<ContratoFormulaOsDTO> listaDeFormulas) throws Exception {
		final String listaSerializada = br.com.citframework.util.WebUtil.serializeObjects(listaDeFormulas, WebUtil.getLanguage(request));
		document.executeScript("document.formCadastroContrato.colItens_Formula_Serialize.value = '".concat(listaSerializada).concat("';"));
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( carregarTabelaFormulasDoContrato)
	 *
	 * @since 30/09/2015
	 * @author ibimon.morais
	 */
	private void carregarTabelaFormulasDoContrato(final DocumentHTML document, final List<ContratoFormulaOsDTO> listaDeFormulas, final HttpServletRequest request) throws Exception {

		final HTMLTable tabelaFormulaContratoSerializada = document.getTableById("tblFormula");
		tabelaFormulaContratoSerializada.deleteAllRows();
		if (listaDeFormulas != null && !listaDeFormulas.isEmpty()) {
			tabelaFormulaContratoSerializada.addRowsByCollection(listaDeFormulas, new String[] { "descricao", "" }, null, UtilI18N.internacionaliza(request, "citcorpore.comum.registroJaCadastrado"), new String[] { "exibeIconesTabelaFormula" }, null, null);
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( obterFormulaOsDoContrato)
	 *
	 * @since 30/09/2015
	 * @author ibimon.morais
	 */
	@SuppressWarnings("unchecked")
	private List<ContratoFormulaOsDTO> obterFormulaOsDoContrato(final ContratoDTO contratoDto, final HttpServletRequest request) throws Exception {
		final List<ContratoFormulaOsDTO> lista = (ArrayList<ContratoFormulaOsDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(ContratoFormulaOsDTO.class, "colItens_Formula_Serialize", request);
		return lista;
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_(
	 * obterListaParaExclusaoDeFormulasOsDoContrato)
	 *
	 * @since 30/09/2015
	 * @author ibimon.morais
	 */
	private List<String> obterListaParaExclusaoDeFormulasOsDoContrato(final DocumentHTML document) throws Exception {
		final HTMLElement element = document.getElementById("colItens_Delecao_Formula_Comunicacao");
		@SuppressWarnings("unchecked")
		final Map<String, String> mapValores = element.getDocument().getValuesForm();
		// Elemento no formulario
		final String valorElemento = StringUtils.removeEnd(mapValores.get("COLITENS_DELECAO_FORMULA_COMUNICACAO"), ",");
		List<String> listaretorno = new ArrayList<String>();
		if (StringUtils.isNotEmpty(valorElemento)) {
			listaretorno = Arrays.asList(valorElemento.split(","));
		}
		return listaretorno;
	}

	// ----------- ABA CONTRATOS GRUPO --------//

	/**
	 * projeto-missao_novo_paradigma - br.com.centralit.citcorpore.ajaxForms -(#definirContratosGrupo)
	 *
	 * @since 09/11/2015.
	 * @author ibimon.morais.
	 * @throws Exception
	 * @throws ServiceException
	 */
	private void definirContratosGrupo(final ContratoDTO contratoDTO, final DocumentHTML document, final HttpServletRequest request) throws ServiceException, Exception {
		final ContratosGruposDTO contratosGruposDTO = new ContratosGruposDTO();
		contratosGruposDTO.setIdContrato(contratoDTO.getIdContrato());
		final List<ContratosGruposDTO> contratosGruposDTOS = (List<ContratosGruposDTO>) this.getContratosGrupoService().findByIdContratoCompleto(contratoDTO.getIdContrato());

		this.definirSerializacaoContratosGrupo(document, request, contratosGruposDTOS);
		this.carregarTabelaContratosGrupo(document, contratosGruposDTOS, request);
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.CadastroContrato.java_( definirSerializacaoPerfilDOContrato)
	 *
	 * @since 09/11/2015
	 * @author ibimon.morais
	 */
	private void definirSerializacaoContratosGrupo(final DocumentHTML document, final HttpServletRequest request, final List<ContratosGruposDTO> lista) throws Exception {
		final String listaSerializada = br.com.citframework.util.WebUtil.serializeObjects(lista, WebUtil.getLanguage(request));
		document.executeScript("document.formCadastroContrato.colItens_Contratos_Grupos_Serialize.value = '".concat(listaSerializada).concat("';"));
	}

	/***
	 * projeto-missao_novo_paradigma - br.com.centralit.citcorpore.ajaxForms -(#carregarTabelaContratosGrupo)
	 *
	 * @since 09/11/2015.
	 * @author ibimon.morais.
	 */
	private void carregarTabelaContratosGrupo(final DocumentHTML document, final List<ContratosGruposDTO> lista, final HttpServletRequest request) throws Exception {

		if (lista != null && !lista.isEmpty()) {
			final HTMLTable tabelaContratosGrupo = document.getTableById("tblContratosGrupos");
			tabelaContratosGrupo.deleteAllRows();
			tabelaContratosGrupo.addRowsByCollection(lista, new String[] { "idGrupo", "nomeGrupoContratosGrupo", "" }, null, UtilI18N.internacionaliza(request, "citcorpore.comum.registroJaCadastrado"), new String[] { "exibeIconesTabelaContratosGrupo" }, null, null);
		}
	}

	/**
	 *
	 * projeto-missao_novo_paradigma - br.com.centralit.citcorpore.ajaxForms -(#obterContratosGrupo)
	 *
	 * @since 09/11/2015.
	 * @author ibimon.morais.
	 */
	@SuppressWarnings("unchecked")
	private List<ContratosGruposDTO> obterContratosGrupo(final ContratoDTO contratoDto, final HttpServletRequest request) throws Exception {
		final List<ContratosGruposDTO> lista = (ArrayList<ContratosGruposDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(ContratosGruposDTO.class, "colItens_Contratos_Grupos_Serialize", request);
		return lista;
	}

	/**
	 * projeto-missao_novo_paradigma - br.com.centralit.citcorpore.ajaxForms
	 * -(#obterListaParaExclusaoContratosGrupos)
	 *
	 * @since 09/11/2015.
	 * @author ibimon.morais.
	 */
	private List<String> obterListaParaExclusaoContratosGrupos(final DocumentHTML document) throws Exception {
		final HTMLElement element = document.getElementById("colItens_Delecao_Contratos_Grupos");
		@SuppressWarnings("unchecked")
		final Map<String, String> mapValores = element.getDocument().getValuesForm();
		// Elemento no formulario
		final String valorElemento = StringUtils.removeEnd(mapValores.get("COLITENS_DELECAO_CONTRATOS_GRUPOS"), ",");
		List<String> listaretorno = new ArrayList<String>();

		if (StringUtils.isNotEmpty(valorElemento)) {
			listaretorno = Arrays.asList(valorElemento.split(","));
		}
		return listaretorno;
	}

	// ----------- ABA UNIDADE --------//

	/**
	 *
	 * projeto-missao_novo_paradigma - CadastroContrato.java_(#definirContratosUnidades).
	 *
	 * @since 12/11/2015
	 * @author ibimon.morais
	 */
	private void definirContratosUnidades(final ContratoDTO dto, final DocumentHTML document, final HttpServletRequest request) throws Exception {
		if (dto != null && dto.getIdContrato() != null) {
			List<ContratosUnidadesDTO> lista = new ArrayList<ContratosUnidadesDTO>(0);
			lista = (List<ContratosUnidadesDTO>) this.getContratosUnidadesService().findByIdContratoCompleto(dto.getIdContrato());

			this.definirSerializacaoUnidadeContrato(document, request, lista);
			this.carregarTabelaUnidadesDoContrato(document, lista, request);
		}
	}

	/**
	 *
	 * projeto-missao_novo_paradigma - CadastroContrato.java_(#definirSerializacaoUnidadeContrato).
	 *
	 * @since 12/11/2015
	 * @author ibimon.morais
	 */
	private void definirSerializacaoUnidadeContrato(final DocumentHTML document, final HttpServletRequest request, final List<ContratosUnidadesDTO> lista) throws Exception {
		final String listaSerializada = br.com.citframework.util.WebUtil.serializeObjects(lista, WebUtil.getLanguage(request));
		document.executeScript("document.formCadastroContrato.colItens_Unidade_Serialize.value = '".concat(listaSerializada).concat("';"));
	}

	/**
	 *
	 * projeto-missao_novo_paradigma - CadastroContrato.java_(#carregarTabelaUnidadesDoContrato).
	 *
	 * @since 12/11/2015
	 * @author ibimon.morais
	 */
	private void carregarTabelaUnidadesDoContrato(final DocumentHTML document, final List<ContratosUnidadesDTO> lista, final HttpServletRequest request) throws Exception {
		final HTMLTable tabelaSerializada = document.getTableById("tblContratosUnidades");
		tabelaSerializada.deleteAllRows();
		if (lista != null && !lista.isEmpty()) {
			tabelaSerializada.addRowsByCollection(lista, new String[] { "idUnidade", "nome", "" }, null, UtilI18N.internacionaliza(request, "citcorpore.comum.registroJaCadastrado"), new String[] { "exibeIconesTabelaUnidades" }, null, null);
		}
	}

	/**
	 *
	 * projeto-missao_novo_paradigma - CadastroContrato.java_(#obterFormulaOsDoContrato).
	 *
	 * @since 12/11/2015
	 * @author ibimon.morais
	 */
	@SuppressWarnings("unchecked")
	private List<ContratosUnidadesDTO> obterUnidadesDoContrato(final ContratoDTO contratoDto, final HttpServletRequest request) throws Exception {
		final List<ContratosUnidadesDTO> lista = (ArrayList<ContratosUnidadesDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(ContratosUnidadesDTO.class, "colItens_Unidade_Serialize", request);
		return lista;
	}

	/**
	 *
	 * projeto-missao_novo_paradigma - CadastroContrato.java_(#obterListaParaExclusaoContratosUnidades).
	 *
	 * @since 12/11/2015
	 * @author ibimon.morais
	 */
	private List<String> obterListaParaExclusaoContratosUnidades(final DocumentHTML document) throws Exception {
		final HTMLElement element = document.getElementById("colItens_Delecao_Unidade");
		@SuppressWarnings("unchecked")
		final Map<String, String> mapValores = element.getDocument().getValuesForm();
		// Elemento no formulario
		final String valorElemento = StringUtils.removeEnd(mapValores.get("COLITENS_DELECAO_UNIDADE"), ",");
		List<String> listaretorno = new ArrayList<String>();
		if (StringUtils.isNotEmpty(valorElemento)) {
			listaretorno = Arrays.asList(valorElemento.split(","));
		}
		return listaretorno;
	}
	public void reloadAnexos(final DocumentHTML document, final HttpServletRequest request,
			final HttpServletResponse response) throws Exception {
		CadastroContratoDTO beanDto = (CadastroContratoDTO) document.getBean();
		
		restaurarAnexos(document, request, beanDto);
		document.executeScript("afterReloadAnexosContrato()");
	}
	
	private void restaurarAnexos(final DocumentHTML document, final HttpServletRequest request, final CadastroContratoDTO contratoDTO) throws ServiceException, Exception {
		Collection<UploadDTO> colAnexosUploadDTO = new ArrayList<UploadDTO>();
		if(contratoDTO==null || contratoDTO.getIdContrato()==null) return;
		final Collection<ControleGEDDTO> colAnexos = getControleGEDService().listByIdTabelaAndID(ControleGEDDTO.TABELA_CONTRATO,
				contratoDTO.getIdContrato());

		if (colAnexos != null && !colAnexos.isEmpty()) {
			colAnexosUploadDTO = getControleGEDService().convertListControleGEDToUploadDTO(colAnexos);
			request.getSession(true).setAttribute(CampoUpload.UPLOADCONTRATO.getColUploadGED(), colAnexosUploadDTO);
		} else {
			request.getSession(true).setAttribute(CampoUpload.UPLOADCONTRATO.getColUploadGED(), null);
		}
		document.executeScript("uploadContrato.refresh();");
	}
	
	public void limparAnexos(final DocumentHTML document, final HttpServletRequest request,final HttpServletResponse response){
		request.getSession(true).setAttribute(CampoUpload.UPLOADCONTRATO.getColUploadGED(), null);
		document.executeScript("uploadContrato.refresh();");
	}
	// ----------- FIM ABA UNIDADE --------//

	/**
	 * @author ibimon.morais
	 * @since 15/09/2015
	 */
	@Override
	public Class<CadastroContratoDTO> getBeanClass() {
		return CadastroContratoDTO.class;
	}
	
	private ControleGEDService getControleGEDService() throws ServiceException {
		if (this.controleGEDService == null) {
			this.controleGEDService = (ControleGEDService) ServiceLocator.getInstance().getService(ControleGEDService.class, null);
		}
		return this.controleGEDService;
	}
	
	private GrupoService getGrupoService() throws ServiceException {
		if (this.grupoService == null) {
			this.grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		}
		return this.grupoService;
	}

	private MoedaService getMoedaService() throws ServiceException {
		if (this.moedaService == null) {
			this.moedaService = (MoedaService) ServiceLocator.getInstance().getService(MoedaService.class, null);
		}
		return this.moedaService;
	}

	private ContratoService getContratoService() throws ServiceException {
		if (this.contratoService == null) {
			this.contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		}
		return this.contratoService;
	}

	private ClienteService getClienteService() throws ServiceException {
		if (this.clienteService == null) {
			this.clienteService = (ClienteService) ServiceLocator.getInstance().getService(ClienteService.class, null);
		}
		return this.clienteService;
	}

	private FornecedorService getFornecedorService() throws ServiceException {
		if (this.fornecedorService == null) {
			this.fornecedorService = (FornecedorService) ServiceLocator.getInstance().getService(FornecedorService.class, null);
		}
		return this.fornecedorService;
	}

	private AcordoNivelServicoContratoService getAcordoNivelServicoContratoService() throws ServiceException {
		if (this.acordoNivelServicoContratoService == null) {
			this.acordoNivelServicoContratoService = (AcordoNivelServicoContratoService) ServiceLocator.getInstance().getService(AcordoNivelServicoContratoService.class, null);
		}
		return this.acordoNivelServicoContratoService;
	}

	private ComplexidadeService getComplexidadeService() throws ServiceException {
		if (this.complexidadeService == null) {
			this.complexidadeService = (ComplexidadeService) ServiceLocator.getInstance().getService(ComplexidadeService.class, null);
		}
		return this.complexidadeService;
	}

	private ContratoHistoricoService getContratoHistoricoService() throws ServiceException {
		if (this.contratoHistoricoService == null) {
			this.contratoHistoricoService = (ContratoHistoricoService) ServiceLocator.getInstance().getService(ContratoHistoricoService.class, null);
		}
		return this.contratoHistoricoService;
	}

	private ContratoPerfilService getContratoPerfilService() throws ServiceException {
		if (this.contratoPerfilService == null) {
			this.contratoPerfilService = (ContratoPerfilService) ServiceLocator.getInstance().getService(ContratoPerfilService.class, null);
		}
		return this.contratoPerfilService;
	}

	private ProdutoContratoService getProdutoContratoService() throws ServiceException {
		if (this.produtoContratoService == null) {
			this.produtoContratoService = (ProdutoContratoService) ServiceLocator.getInstance().getService(ProdutoContratoService.class, null);
		}
		return this.produtoContratoService;
	}

	private MatrizContratoService getMatrizContratoService() throws ServiceException {
		if (this.matrizContratoService == null) {
			this.matrizContratoService = (MatrizContratoService) ServiceLocator.getInstance().getService(MatrizContratoService.class, null);
		}
		return this.matrizContratoService;
	}

	private ContratoFormulaOsService getContratoFormulaOsService() throws ServiceException {
		if (this.contratoFormulaOsService == null) {
			this.contratoFormulaOsService = (ContratoFormulaOsService) ServiceLocator.getInstance().getService(ContratoFormulaOsService.class, null);
		}
		return this.contratoFormulaOsService;
	}

	public ContratosGruposService getContratosGrupoService() throws ServiceException {
		if (this.contratosGrupoService == null) {
			this.contratosGrupoService = (ContratosGruposService) ServiceLocator.getInstance().getService(ContratosGruposService.class, null);
		}
		return this.contratosGrupoService;
	}

	public ContratosUnidadesService getContratosUnidadesService() throws ServiceException {
		if (this.contratosUnidadesService == null) {
			this.contratosUnidadesService = (ContratosUnidadesService) ServiceLocator.getInstance().getService(ContratosUnidadesService.class, null);
		}
		return this.contratosUnidadesService;
	}

	/**
	 * @author joao.morais
	 * @since 15/01/2016
	 */
	private CondicaoOperacaoService getCondicaoOperacaoService() throws ServiceException {
		if (condicaoOperacaoService == null) {
			condicaoOperacaoService = (CondicaoOperacaoService) ServiceLocator.getInstance().getService(CondicaoOperacaoService.class, null);
		}
		return condicaoOperacaoService;
	}
	
	/**
	 * @author gilmar.junior
	 * @since 08.08.2016
	 * */
	private SolicitacaoServicoService getSolicitacaoServicoService() throws ServiceException {
		if (solicitacaoServicoService == null) {
			solicitacaoServicoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, null);
		}
		return solicitacaoServicoService;
	}
	
	public FormulaOsService getFormulaOsService() throws ServiceException {
		return Util.isNullOrEmpty(formulaOsService) ? formulaOsService = (FormulaOsService) ServiceLocator.getInstance().getService(FormulaOsService.class, null) : formulaOsService;
	}

}