package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citcorpore.bean.CadastroHabilidadeDTO;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.bean.VinculoHabilidadeColaboradorDTO;
import br.com.centralit.citcorpore.negocio.CadastroHabilidadeService;
import br.com.centralit.citcorpore.negocio.EmpregadoService;
import br.com.centralit.citcorpore.negocio.VinculoHabilidadeColaboradorService;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;

/**
 * @since 28.01.2016
 * @author joao.morais
 */
public class CadastroHabilidade extends AjaxFormAction {

	private CadastroHabilidadeService cadastroHabilidadeService;
	private VinculoHabilidadeColaboradorService vinculoService;
	private EmpregadoService empregadoService;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
	}

	@Override
	public Class<CadastroHabilidadeDTO> getBeanClass() {
		return CadastroHabilidadeDTO.class;
	}

	private boolean verificaHabilidade(CadastroHabilidadeDTO cadastroHabilidadeDTO) throws ServiceException, PersistenceException{
		if(this.getCadastroHabilidadeService().verificaHabilidade(cadastroHabilidadeDTO)) {
			return true;
		}

		return false;
	}

	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);

		CadastroHabilidadeDTO habilidadeDTO = (CadastroHabilidadeDTO) document.getBean();
		VinculoHabilidadeColaboradorDTO vinculoDTO = new VinculoHabilidadeColaboradorDTO();

		ArrayList<VinculoHabilidadeColaboradorDTO> listaIdColaborador = (ArrayList<VinculoHabilidadeColaboradorDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(VinculoHabilidadeColaboradorDTO.class, "listaColaboradores_Serialize", request);

		if (habilidadeDTO != null && habilidadeDTO.getIdHabilidade() == null) {
			if(!verificaHabilidade(habilidadeDTO)){
				habilidadeDTO.setDataHoraInicio(UtilDatas.getDataHoraAtual());
				habilidadeDTO = (CadastroHabilidadeDTO) this.getCadastroHabilidadeService().create(habilidadeDTO);

				if (listaIdColaborador != null && listaIdColaborador.size() > 0) {
					for(VinculoHabilidadeColaboradorDTO idColaborador : listaIdColaborador){
						vinculoDTO.setIdEmpregado(idColaborador.getIdEmpregado());
						vinculoDTO.setIdHabilidade(habilidadeDTO.getIdHabilidade());
						vinculoDTO = (VinculoHabilidadeColaboradorDTO) this.getVinculoHabilidadeColaboradorService().create(vinculoDTO);
					}
				}
				limparFormulario(document, request, response);
				document.executeScript("JANELA_AGUARDE_MENU.hide();");
				document.alert(UtilI18N.internacionaliza(request, "MSG05"));
			}else{
				document.executeScript("JANELA_AGUARDE_MENU.hide();");
				document.alert(UtilI18N.internacionaliza(request, "MSE01"));
				return;
			}

		} else if(habilidadeDTO != null && habilidadeDTO.getIdHabilidade() != null){
			this.getCadastroHabilidadeService().update(habilidadeDTO);
			this.getVinculoHabilidadeColaboradorService().deleteAllVinculosHabilidade(habilidadeDTO.getIdHabilidade());

			if (listaIdColaborador != null && listaIdColaborador.size() > 0) {
				for(VinculoHabilidadeColaboradorDTO idColaborador : listaIdColaborador){
					vinculoDTO.setIdEmpregado(idColaborador.getIdEmpregado());
					vinculoDTO.setIdHabilidade(habilidadeDTO.getIdHabilidade());

					this.getVinculoHabilidadeColaboradorService().create(vinculoDTO);
				}
			}

			limparFormulario(document, request, response);
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			document.alert(UtilI18N.internacionaliza(request, "MSG06"));

		}
	}

	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws ServiceException, LogicException, PersistenceException{
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		CadastroHabilidadeDTO habilidadeDTO = (CadastroHabilidadeDTO) document.getBean();

		VinculoHabilidadeColaboradorDTO vinculoDTO = new VinculoHabilidadeColaboradorDTO();

		try {
			habilidadeDTO = (CadastroHabilidadeDTO) getCadastroHabilidadeService().restore(habilidadeDTO);

			vinculoDTO.setIdHabilidade(habilidadeDTO.getIdHabilidade());
			Collection<VinculoHabilidadeColaboradorDTO> listaVinculo = this.getVinculoHabilidadeColaboradorService().findByIdHabilidade(vinculoDTO.getIdHabilidade());
			List<EmpregadoDTO> listaUsuarios = new ArrayList<EmpregadoDTO>();
			String listaColaboradoresLookup = "";

			if (listaVinculo != null && listaVinculo.size() > 0) {
				for (VinculoHabilidadeColaboradorDTO colaborador : listaVinculo) {
					listaUsuarios.add(getEmpregadoService().restoreEmpregadosAtivosById(colaborador.getIdEmpregado()));
					listaColaboradoresLookup += colaborador.getIdEmpregado() + ";";
				}
				try {
					geraHtmlTabelaColaborador(listaUsuarios, document, request);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}

			final HTMLForm form = document.getForm("formCadastroHabilidade");
			form.setValues(habilidadeDTO);
			form.setValue("listaColaboradores", listaColaboradoresLookup);
			form.setValue("dataHoraInicio", habilidadeDTO.getDataHoraInicio());
			document.executeScript("Colaborador.serializarListaIdsColaboradoresVinculados();");
		} catch (LogicException e) {
			e.printStackTrace();
		}
	}

	public void excluir(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception{
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		CadastroHabilidadeDTO habilidadeDTO = (CadastroHabilidadeDTO) document.getBean();

		if(habilidadeDTO != null && habilidadeDTO.getIdHabilidade() != null  && habilidadeDTO.getIdHabilidade().intValue() > 0){
			this.getCadastroHabilidadeService().delete(habilidadeDTO);
			this.getVinculoHabilidadeColaboradorService().deleteAllVinculosHabilidade(habilidadeDTO.getIdHabilidade());

			limparFormulario(document, request, response);
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			document.alert(UtilI18N.internacionaliza(request, "MSG07"));
		}
	}

	public void adicionaTabelaLOOKUP_VINCULAR_COLABORADOR(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		CadastroHabilidadeDTO habilidadeDTO = (CadastroHabilidadeDTO) document.getBean();
		if (habilidadeDTO != null) {
			// Executa a funo no js para atualizar a lista de unidades vinculadas
			document.executeScript("Colaborador.montarTabelaColaboradores();");
			document.executeScript("Colaborador.fecharModal();");
		}
	}

	public void montarTabelaColaboradores(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) {
		try {
			List<VinculoHabilidadeColaboradorDTO> listaVinculoColaborador = new ArrayList<VinculoHabilidadeColaboradorDTO>();
			listaVinculoColaborador = (ArrayList) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(VinculoHabilidadeColaboradorDTO.class, "listaColaboradores_Serialize", request);
			List<EmpregadoDTO> listaUsuarios = new ArrayList<EmpregadoDTO>();

			if (listaVinculoColaborador != null && listaVinculoColaborador.size() > 0) {
				for (VinculoHabilidadeColaboradorDTO colaborador : listaVinculoColaborador) {
					listaUsuarios.add(getEmpregadoService().restoreEmpregadosAtivosById(colaborador.getIdEmpregado()));
				}
				document.alert(UtilI18N.internacionaliza(request, "cadastroHabilidade.colaboradorVinculadoSucesso"));
			}

			geraHtmlTabelaColaborador(listaUsuarios, document, request);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void geraHtmlTabelaColaborador(List<EmpregadoDTO> listaUsuarios, DocumentHTML document, HttpServletRequest request) throws Exception {
		StringBuilder sb = new StringBuilder();

		if (listaUsuarios != null && listaUsuarios.size() > 0) {
			sb.append(geraHtmlCabecalhoTabela(request));

			sb.append(geraHtmlDadosTabela(listaUsuarios, document, request));

			sb.append(geraHTMLFinalTabela());
		} else {
			sb.append("<h4>" + UtilI18N.internacionaliza(request, "cadastroHabilidade.nenhumColaborador") + "</h4>");
		}
		HTMLElement tabelaColaborador = document.getElementById("divTabelaColaboradorHabilidade");
		tabelaColaborador.setInnerHTML(sb.toString());
	}

	public void zeraTabela(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		StringBuilder sb = new StringBuilder();
		sb.append("<h4>" + UtilI18N.internacionaliza(request, "cadastroHabilidade.nenhumColaborador") + "</h4>");
		HTMLElement tabelaColaborador = document.getElementById("divTabelaColaboradorHabilidade");
		tabelaColaborador.setInnerHTML(sb.toString());
	}


	private String geraHtmlCabecalhoTabela(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "cadastroHabilidade.IdHabilidade") + "</th> ");
		sb.append("				<th>" + UtilI18N.internacionaliza(request, "cadastroHabilidade.colaborador") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.acoes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody id=\"bodyTabelaColaboradorHabilidade\"> ");

		return sb.toString();
	}

	private String geraHtmlDadosTabela(List<EmpregadoDTO> listaUsuarios, DocumentHTML document, HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		for (EmpregadoDTO empregado : listaUsuarios) {
			sb.append(geraHtmlLinhaTabela(request, empregado.getIdEmpregado(), empregado.getNome()));
		}

		return sb.toString();
	}

	private String geraHtmlLinhaTabela(HttpServletRequest request, Integer id, String descricao) {
		StringBuilder sb = new StringBuilder();
		String onMouseOver = "onmouseover=\"abreTooltip(this, '"+UtilI18N.internacionaliza(request, "cadastroHabilidade.desvincularColaborador")+"')\" onmouseout=\"fechaTooltip();\"";

		sb.append("		<tr id=\""+id+"\">");
		sb.append("			<td class=\"center\">" + id + "</td> ");
		sb.append("			<td>" + descricao + "</td> ");
		sb.append("			<td class=\"center\" style=\"width: 50px;\">");
		sb.append("				<a onclick=\"Colaborador.removerColaboradorFromTable(this);\" "+onMouseOver+" class=\"btn-action glyphicons remove_2 btn-default btnUpDate\"><i></i></a>");
		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}

	private String geraHTMLFinalTabela() {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");

		return sb.toString();
	}

	public void limparFormulario(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		document.getForm("formCadastroHabilidade").clear();
		geraHtmlTabelaColaborador(null, document, request);
	}

	public void desvinculaColaborador(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception{
		CadastroHabilidadeDTO habilidadeDTO = (CadastroHabilidadeDTO) document.getBean();
		VinculoHabilidadeColaboradorDTO vinculoDTO = new VinculoHabilidadeColaboradorDTO();
		if(habilidadeDTO != null){
			ArrayList<VinculoHabilidadeColaboradorDTO> listaIdColaborador = (ArrayList<VinculoHabilidadeColaboradorDTO>) br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(VinculoHabilidadeColaboradorDTO.class, "listaColaboradores_Serialize", request);
			this.getVinculoHabilidadeColaboradorService().deleteAllVinculosHabilidade(habilidadeDTO.getIdHabilidade());

			for(VinculoHabilidadeColaboradorDTO idColaborador : listaIdColaborador){
				vinculoDTO.setIdEmpregado(idColaborador.getIdEmpregado());
				vinculoDTO.setIdHabilidade(habilidadeDTO.getIdHabilidade());

				this.getVinculoHabilidadeColaboradorService().create(vinculoDTO);
			}
		}
	}

	public CadastroHabilidadeService getCadastroHabilidadeService() throws ServiceException {
		if (cadastroHabilidadeService == null) {
			cadastroHabilidadeService = (CadastroHabilidadeService) ServiceLocator.getInstance().getService(CadastroHabilidadeService.class, null);
		}
		return cadastroHabilidadeService;
	}

	public VinculoHabilidadeColaboradorService getVinculoHabilidadeColaboradorService() throws ServiceException {
		if (vinculoService == null) {
			vinculoService = (VinculoHabilidadeColaboradorService) ServiceLocator.getInstance().getService(VinculoHabilidadeColaboradorService.class, null);
		}
		return vinculoService;
	}

	private EmpregadoService getEmpregadoService() throws ServiceException {
		if (empregadoService == null) {
			empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);
		}

		return empregadoService;
	}

}
