package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mysql.jdbc.StringUtils;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citajax.html.HTMLTable;
import br.com.centralit.citcorpore.bean.AcordoNivelServicoDTO;
import br.com.centralit.citcorpore.bean.AcordoServicoContratoDTO;
import br.com.centralit.citcorpore.bean.CadastroTemplateIncidenteRequisicaoDTO;
import br.com.centralit.citcorpore.bean.CadastroTemplateIncidenteRequisicaoICDTO;
import br.com.centralit.citcorpore.bean.CategoriaServicoDTO;
import br.com.centralit.citcorpore.bean.ClienteDTO;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.bean.FornecedorDTO;
import br.com.centralit.citcorpore.bean.ImpactoDTO;
import br.com.centralit.citcorpore.bean.ItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.OrigemAtendimentoDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.UnidadeDTO;
import br.com.centralit.citcorpore.bean.UrgenciaDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.integracao.AcordoNivelServicoDao;
import br.com.centralit.citcorpore.negocio.AcordoNivelServicoService;
import br.com.centralit.citcorpore.negocio.AcordoServicoContratoService;
import br.com.centralit.citcorpore.negocio.CadastroTemplateIncidenteRequisicaoICService;
import br.com.centralit.citcorpore.negocio.CadastroTemplateIncidenteRequisicaoService;
import br.com.centralit.citcorpore.negocio.CategoriaServicoService;
import br.com.centralit.citcorpore.negocio.ClienteService;
import br.com.centralit.citcorpore.negocio.ContratoService;
import br.com.centralit.citcorpore.negocio.EmpregadoService;
import br.com.centralit.citcorpore.negocio.FornecedorService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.ItemConfiguracaoService;
import br.com.centralit.citcorpore.negocio.OrigemAtendimentoService;
import br.com.centralit.citcorpore.negocio.PrioridadeSolicitacoesService;
import br.com.centralit.citcorpore.negocio.ServicoContratoService;
import br.com.centralit.citcorpore.negocio.ServicoService;
import br.com.centralit.citcorpore.negocio.SolicitacaoServicoService;
import br.com.centralit.citcorpore.negocio.UnidadeService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.MatrizPrioridade;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.Enumerados.ServiceDemandType;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.Enumerados.TipoAcordoContrato;
import br.com.centralit.citcorpore.util.Enumerados.TipoCatalogoServico;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;
import br.com.citframework.util.UtilStrings;

public class CadastroTemplateIncidenteRequisicao extends AjaxFormAction {

	private ServicoContratoService servicoContratoService;
	private UnidadeService unidadeService;
	private ServicoService servicoService;
	private ContratoService contratoService;
	private AcordoNivelServicoService acordoNivelServicoService;
	private AcordoServicoContratoService acordoServicoContratoService;
	private GrupoService grupoService;
	private SolicitacaoServicoService solicitacaoServicoService;
	private CategoriaServicoService categoriaService;
	private CadastroTemplateIncidenteRequisicaoService cadastroTemplateIncidenteRequisicaoService;
	private EmpregadoService empregadoService;
	private CadastroTemplateIncidenteRequisicaoICService cadastroTemplateIncidenteRequisicaoICService;
	private ItemConfiguracaoService itemConfiguracaoService;
	private ClienteService clienteService;
	private FornecedorService fornecedorService;

	ContratoDTO contratoDtoAux = new ContratoDTO();

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuario = br.com.centralit.citcorpore.util.WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		CadastroTemplateIncidenteRequisicaoDTO cadastroTemplateIncidenteRequisicaoDTO = (CadastroTemplateIncidenteRequisicaoDTO) document.getBean();

		Integer idContratoSelecionado = getContratoService().carregarContratos("S", usuario, document, request);

		if (idContratoSelecionado != null) {
			cadastroTemplateIncidenteRequisicaoDTO.setIdContrato(idContratoSelecionado);
		}

		carregarComboOrigem(document, request, response);
		carregarComboTipoDemanda(document, request);
		carregarCombosImpactoUrgente(document, request);

		this.carregaUnidades(cadastroTemplateIncidenteRequisicaoDTO, document, request, response);

		this.carregarComboTipoCatalogoServicoSolicitacao(document, request, response);
	}

	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse respose) throws Exception {
		CadastroTemplateIncidenteRequisicaoDTO cadastroTemplateIncidenteRequisicaoDTO = (CadastroTemplateIncidenteRequisicaoDTO) document.getBean();

		List<Integer> idsItemConfiguracao = new ArrayList<>();
		if (cadastroTemplateIncidenteRequisicaoDTO.getIdsItemConfiguracao() != null && !cadastroTemplateIncidenteRequisicaoDTO.getIdsItemConfiguracao().isEmpty()) {
			idsItemConfiguracao = new Gson().fromJson(cadastroTemplateIncidenteRequisicaoDTO.getIdsItemConfiguracao(), new TypeToken<List<Integer>>() {
			}.getType());
		}

		if (cadastroTemplateIncidenteRequisicaoDTO.getIdTemplateIncidenteRequisicao() == null) {
			cadastroTemplateIncidenteRequisicaoDTO.setDataInicio(UtilDatas.getDataAtual());

			cadastroTemplateIncidenteRequisicaoDTO = getCadastroTemplateIncidenteRequisicaoService().create(cadastroTemplateIncidenteRequisicaoDTO);
			document.alert(UtilI18N.internacionaliza(request, "MSG05"));
		} else {
			getCadastroTemplateIncidenteRequisicaoService().update(cadastroTemplateIncidenteRequisicaoDTO);
			document.alert(UtilI18N.internacionaliza(request, "MSG06"));
		}

		if (cadastroTemplateIncidenteRequisicaoDTO.getIdTemplateIncidenteRequisicao() != null) {
			getCadastroTemplateIncidenteRequisicaoICService().deleteByIdTemplateIncidenteRequisicao(cadastroTemplateIncidenteRequisicaoDTO.getIdTemplateIncidenteRequisicao());

			if (idsItemConfiguracao != null && !idsItemConfiguracao.isEmpty()) {
				for (Integer idItemConfiguracao : idsItemConfiguracao) {
					CadastroTemplateIncidenteRequisicaoICDTO cadastroTemplateIncidenteRequisicaoICDTO = new CadastroTemplateIncidenteRequisicaoICDTO();
					cadastroTemplateIncidenteRequisicaoICDTO.setIdItemConfiguracao(idItemConfiguracao);
					cadastroTemplateIncidenteRequisicaoICDTO.setIdTemplateIncidenteRequisicao(cadastroTemplateIncidenteRequisicaoDTO.getIdTemplateIncidenteRequisicao());

					getCadastroTemplateIncidenteRequisicaoICService().create(cadastroTemplateIncidenteRequisicaoICDTO);
				}
			}
		}

		document.executeScript("limpar()");
	}

	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		CadastroTemplateIncidenteRequisicaoDTO cadastroTemplateIncidenteRequisicaoDTO = (CadastroTemplateIncidenteRequisicaoDTO) document.getBean();

		cadastroTemplateIncidenteRequisicaoDTO = getCadastroTemplateIncidenteRequisicaoService().restore(cadastroTemplateIncidenteRequisicaoDTO);

		if (cadastroTemplateIncidenteRequisicaoDTO != null && cadastroTemplateIncidenteRequisicaoDTO.getIdSolicitante() != null) {
			EmpregadoDTO empregadoDto = new EmpregadoDTO();
			empregadoDto.setIdEmpregado(cadastroTemplateIncidenteRequisicaoDTO.getIdSolicitante());

			empregadoDto = (EmpregadoDTO) getEmpregadoService().restore(empregadoDto);

			if (empregadoDto != null && empregadoDto.getIdEmpregado() != null) {
				cadastroTemplateIncidenteRequisicaoDTO.setIdSolicitante(empregadoDto.getIdEmpregado());

				if (empregadoDto.getNome() != null) {
					cadastroTemplateIncidenteRequisicaoDTO.setSolicitante(empregadoDto.getNome());
				}
			}
		}

		if (cadastroTemplateIncidenteRequisicaoDTO != null && cadastroTemplateIncidenteRequisicaoDTO.getIdServico() != null) {
			ServicoDTO servicoDto = new ServicoDTO();
			servicoDto.setIdServico(cadastroTemplateIncidenteRequisicaoDTO.getIdServico());

			servicoDto = (ServicoDTO) getServicoService().restore(servicoDto);

			if (servicoDto != null && servicoDto.getIdServico() != null && servicoDto.getNomeServico() != null) {
				cadastroTemplateIncidenteRequisicaoDTO.setServico(servicoDto.getNomeServico());
			}
		}

		this.carregaUnidades(cadastroTemplateIncidenteRequisicaoDTO, document, request, response);

		document.executeScript("limpar()");

		if (null != cadastroTemplateIncidenteRequisicaoDTO.getUtilizaCategoriaServico() && cadastroTemplateIncidenteRequisicaoDTO.getUtilizaCategoriaServico().equals("S")) {
			document.executeScript("habilitaCheckCategoriaServico()");
			this.carregarComboCategoriaServico(document, request, response);
		} else {
			document.executeScript("desabilitaCheckCategoriaServico()");
		}

		HTMLForm form = document.getForm("form");
		form.setValues(cadastroTemplateIncidenteRequisicaoDTO);
		final HTMLSelect idTipoCatalogoServicoSolicitacao = document.getSelectById("idTipoCatalogoServicoSol");
		idTipoCatalogoServicoSolicitacao.setValue(cadastroTemplateIncidenteRequisicaoDTO.getIdTipoCatalogoServicoSoli());
		idTipoCatalogoServicoSolicitacao.setDisabled(true);

		HTMLElement elemento = document.getElementById("servicoNegocioTecnicoBusca");
		ServicoDTO servicoDto = this.getServicoService().findByIdServico(cadastroTemplateIncidenteRequisicaoDTO.getIdServicoNegocioTecBusc());
		if (servicoDto != null) {
			elemento.setValue(servicoDto.getNomeServico());
		}

		document.getSelectById("impacto").setDisabled(false);
		document.getSelectById("urgencia").setDisabled(false);

		if (cadastroTemplateIncidenteRequisicaoDTO.getIdServico() != null && cadastroTemplateIncidenteRequisicaoDTO.getIdContrato() != null) {
			ServicoContratoDTO servicoContratoDto = this.getServicoContratoService().findByIdContratoAndIdServico(cadastroTemplateIncidenteRequisicaoDTO.getIdContrato(), cadastroTemplateIncidenteRequisicaoDTO.getIdServico());

			if (servicoContratoDto != null) {
				AcordoNivelServicoDTO acordoNivelServicoDto = this.getAcordoNivelServicoService().findAtivoByIdServicoContrato(servicoContratoDto.getIdServicoContrato(), "T");
				if (acordoNivelServicoDto == null) {
					// Se nao houver acordo especifico, ou seja, associado direto ao servicocontrato, entao busca um acordo geral que esteja vinculado ao servicocontrato.
					final AcordoServicoContratoDTO acordoServicoContratoDTO = this.getAcordoServicoContratoService().findAtivoByIdServicoContrato(servicoContratoDto.getIdServicoContrato(), "T");
					if (acordoServicoContratoDTO == null) {
						document.alert(UtilI18N.internacionaliza(request, "solicitacaoservico.validacao.tempoacordo"));
						return;
					}
					// Apos achar a vinculacao do acordo com o servicocontrato, entao faz um restore do acordo de nivel de servico.
					acordoNivelServicoDto = new AcordoNivelServicoDTO();
					acordoNivelServicoDto.setIdAcordoNivelServico(acordoServicoContratoDTO.getIdAcordoNivelServico());
					acordoNivelServicoDto = (AcordoNivelServicoDTO) new AcordoNivelServicoDao().restore(acordoNivelServicoDto);
					if (acordoNivelServicoDto == null) {
						// Se nao houver acordo especifico, ou seja, associado direto ao servicocontrato
						document.alert(UtilI18N.internacionaliza(request, "solicitacaoservico.validacao.tempoacordo"));
						return;
					}
				}
				if (acordoNivelServicoDto.getImpacto() != null) {
					document.getSelectById("impacto").setValue("" + acordoNivelServicoDto.getImpacto());
					if (acordoNivelServicoDto.getPermiteMudarImpUrg() != null && acordoNivelServicoDto.getPermiteMudarImpUrg().equalsIgnoreCase("N")) {
						document.getSelectById("impacto").setDisabled(true);
					} else {
						if (cadastroTemplateIncidenteRequisicaoDTO.getImpacto() != null) {
							document.getSelectById("impacto").setValue(cadastroTemplateIncidenteRequisicaoDTO.getImpacto());
						}
					}
				} else {
					document.getSelectById("impacto").setValue("B");
				}
				if (acordoNivelServicoDto.getUrgencia() != null) {
					document.getSelectById("urgencia").setValue("" + acordoNivelServicoDto.getUrgencia());
					if (acordoNivelServicoDto.getPermiteMudarImpUrg() != null && acordoNivelServicoDto.getPermiteMudarImpUrg().equalsIgnoreCase("N")) {
						document.getSelectById("urgencia").setDisabled(true);
					} else {
						if (cadastroTemplateIncidenteRequisicaoDTO.getUrgencia() != null) {
							document.getSelectById("urgencia").setValue(cadastroTemplateIncidenteRequisicaoDTO.getUrgencia());
						}
					}
				} else {
					document.getSelectById("urgencia").setValue("B");
				}
			} else if (cadastroTemplateIncidenteRequisicaoDTO != null && !StringUtils.isEmptyOrWhitespaceOnly(cadastroTemplateIncidenteRequisicaoDTO.getImpacto()) && !StringUtils.isEmptyOrWhitespaceOnly(cadastroTemplateIncidenteRequisicaoDTO.getUrgencia())) {
				document.getSelectById("impacto").setValue(cadastroTemplateIncidenteRequisicaoDTO.getImpacto());
				document.getSelectById("urgencia").setValue(cadastroTemplateIncidenteRequisicaoDTO.getUrgencia());
			} else {
				document.getSelectById("impacto").setValue("B");
				document.getSelectById("urgencia").setValue("B");
			}
		}

		if (cadastroTemplateIncidenteRequisicaoDTO.getIdTemplateIncidenteRequisicao() != null) {
			Collection<CadastroTemplateIncidenteRequisicaoICDTO> colCadastroTemplateIncidenteRequisicaoICDTO = getCadastroTemplateIncidenteRequisicaoICService().listByIdTemplateIncidenteRequisicao(cadastroTemplateIncidenteRequisicaoDTO.getIdTemplateIncidenteRequisicao());
			if (colCadastroTemplateIncidenteRequisicaoICDTO != null && !colCadastroTemplateIncidenteRequisicaoICDTO.isEmpty()) {
				for (CadastroTemplateIncidenteRequisicaoICDTO cadastroTemplateIncidenteRequisicaoICDTO : colCadastroTemplateIncidenteRequisicaoICDTO) {
					ItemConfiguracaoDTO itemConfiguracaoDTO = getItemConfiguracaoService().restoreByIdItemConfiguracao(cadastroTemplateIncidenteRequisicaoICDTO.getIdItemConfiguracao());

					document.executeScript("selectedItemConfiguracao(" + itemConfiguracaoDTO.getIdItemConfiguracao() + ", '" + itemConfiguracaoDTO.getIdentificacao() + "');");
				}
			}
		}

		document.executeScript("calcularSLA();");
	}

	public void excluir(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		CadastroTemplateIncidenteRequisicaoDTO cadastroTemplateIncidenteRequisicaoDTO = (CadastroTemplateIncidenteRequisicaoDTO) document.getBean();

		if (cadastroTemplateIncidenteRequisicaoDTO.getIdTemplateIncidenteRequisicao() != null) {
			if (getCadastroTemplateIncidenteRequisicaoService().delete(cadastroTemplateIncidenteRequisicaoDTO)) {
				document.alert(UtilI18N.internacionaliza(request, "MSG07"));
			}
		}

		HTMLForm form = document.getForm("form");
		form.clear();
	}

	@Override
	public Class<CadastroTemplateIncidenteRequisicaoDTO> getBeanClass() {
		return CadastroTemplateIncidenteRequisicaoDTO.class;
	}

	public void restaurarSolicitante(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		CadastroTemplateIncidenteRequisicaoDTO cadastroTemplateIncidenteRequisicaoDTO = (CadastroTemplateIncidenteRequisicaoDTO) document.getBean();

		if (cadastroTemplateIncidenteRequisicaoDTO != null && cadastroTemplateIncidenteRequisicaoDTO.getIdSolicitante() != null) {
			EmpregadoService empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);

			EmpregadoDTO empregadoDto = new EmpregadoDTO();
			empregadoDto.setIdEmpregado(cadastroTemplateIncidenteRequisicaoDTO.getIdSolicitante());

			empregadoDto = (EmpregadoDTO) empregadoService.restore(empregadoDto);

			if (empregadoDto != null) {
				cadastroTemplateIncidenteRequisicaoDTO.setEmailSolicitante(empregadoDto.getEmail());

				HTMLForm form = document.getForm("form");
				form.setValues(cadastroTemplateIncidenteRequisicaoDTO);
			}
		}
	}

	public void carregaContratos(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		CadastroTemplateIncidenteRequisicaoDTO cadastroTemplateIncidenteRequisicaoDTO = (CadastroTemplateIncidenteRequisicaoDTO) document.getBean();

		HTMLSelect idContrato = document.getSelectById("idContrato");
		idContrato.removeAllOptions();

		if (cadastroTemplateIncidenteRequisicaoDTO != null && cadastroTemplateIncidenteRequisicaoDTO.getIdSolicitante() != null) {
			Collection<ContratoDTO> listContratoAtivo = this.getContratoService().findAtivosByIdEmpregado(cadastroTemplateIncidenteRequisicaoDTO.getIdSolicitante());

			if (listContratoAtivo != null && !listContratoAtivo.isEmpty()) {
				for (final ContratoDTO contratoDto : listContratoAtivo) {
					contratoDto.setNome(this.tratarNomeContrato(contratoDto, document.getLanguage()));
				}

				if (listContratoAtivo.size() > 0) {
					idContrato.addOptions(listContratoAtivo, "idContrato", "nome", null);
				}
			}
		}

		document.executeScript("onChangeContrato();");
	}

	private String tratarNomeContrato(final ContratoDTO contratoDto, final String language) throws Exception {
		String nomeCliente = "";
		String nomeFornecedor = "";

		ClienteDTO clienteDto = new ClienteDTO();

		clienteDto.setIdCliente(contratoDto.getIdCliente());

		clienteDto = (ClienteDTO) this.getClienteService().restore(clienteDto);

		if (clienteDto != null) {
			nomeCliente = clienteDto.getNomeRazaoSocial();
		}

		FornecedorDTO fornecedorDto = new FornecedorDTO();

		fornecedorDto.setIdFornecedor(contratoDto.getIdFornecedor());

		fornecedorDto = (FornecedorDTO) this.getFornecedorService().restore(fornecedorDto);

		if (fornecedorDto != null) {
			nomeFornecedor = fornecedorDto.getRazaoSocial();
		}

		final String nomeContrato = "" + contratoDto.getNumero() + " de " + UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, contratoDto.getDataContrato(), language) + " (" + nomeCliente + " - " + nomeFornecedor + ")";

		return nomeContrato;
	}

	private void inicializarCombo(HTMLSelect componenteCombo, HttpServletRequest request) {
		if (componenteCombo != null) {
			componenteCombo.removeAllOptions();
			componenteCombo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
		}
	}

	public void carregarComboOrigem(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final HTMLSelect selectOrigem = document.getSelectById("idOrigem");
		selectOrigem.removeAllOptions();
		OrigemAtendimentoService service = (OrigemAtendimentoService) ServiceLocator.getInstance().getService(OrigemAtendimentoService.class, null);
		final ArrayList<OrigemAtendimentoDTO> todasOrigens = (ArrayList<OrigemAtendimentoDTO>) service.recuperaAtivos();
		final String origemPadrao = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.ORIGEM_PADRAO, "");

		selectOrigem.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
		selectOrigem.addOptions(todasOrigens, "idOrigem", "descricao", origemPadrao);
	}

	public void carregarComboUnidade(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) {
		try {
			CadastroTemplateIncidenteRequisicaoDTO cadastroTemplateIncidenteRequisicaoDTO = (CadastroTemplateIncidenteRequisicaoDTO) document.getBean();
			this.carregaUnidades(cadastroTemplateIncidenteRequisicaoDTO, document, request, response);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void carregaUnidades(CadastroTemplateIncidenteRequisicaoDTO cadastroTemplateIncidenteRequisicaoDTO, DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		String UNIDADE_AUTOCOMPLETE = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.UNIDADE_AUTOCOMPLETE, "N");
		if (UNIDADE_AUTOCOMPLETE != null && !UNIDADE_AUTOCOMPLETE.equalsIgnoreCase("S")) {
			UnidadeService unidadeService = (UnidadeService) ServiceLocator.getInstance().getService(UnidadeService.class, null);
			HTMLSelect comboUnidade = document.getSelectById("idUnidade");
			if (comboUnidade != null) {
				inicializarCombo(comboUnidade, request);
				String validarComboUnidade = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.UNIDADE_VINC_CONTRATOS, "N");
				if (validarComboUnidade.trim().equalsIgnoreCase("S")) {
					ArrayList<UnidadeDTO> unidades;
					if (cadastroTemplateIncidenteRequisicaoDTO != null && cadastroTemplateIncidenteRequisicaoDTO.getIdContrato() != null && cadastroTemplateIncidenteRequisicaoDTO.getIdContrato().intValue() >= 0) {
						unidades = (ArrayList) unidadeService.listHierarquiaMultiContratos(cadastroTemplateIncidenteRequisicaoDTO.getIdContrato());
					} else {
						unidades = null;
					}
					if (unidades != null) {
						if (unidades.size() == 1) {
							comboUnidade.addOptions(unidades, "idUnidade", "nomeNivel", unidades.get(0).getIdUnidade().toString());
						} else {
							comboUnidade.addOptions(unidades, "idUnidade", "nomeNivel", "");
						}
					}
				} else {
					ArrayList<UnidadeDTO> unidades = (ArrayList) unidadeService.listHierarquia();
					if (unidades != null) {
						if (unidades.size() == 1) {
							comboUnidade.addOptions(unidades, "idUnidade", "nomeNivel", unidades.get(0).getIdUnidade().toString());
						} else {
							comboUnidade.addOptions(unidades, "idUnidade", "nomeNivel", "");
						}
					}
				}
			}
		} else {
			StringBuilder objeto;
			objeto = new StringBuilder();
			objeto.append("<label  class='strong  campoObrigatorio'>");
			objeto.append(UtilI18N.internacionaliza(request, "unidade.unidade"));
			objeto.append("</label>");
			if (cadastroTemplateIncidenteRequisicaoDTO != null && cadastroTemplateIncidenteRequisicaoDTO.getIdContrato() == null) {
				objeto.append("<input type='text' disabled name='unidadeDes' id='unidadeDes' class='span12 Valid[Required] Description[unidade.unidade]' onkeydown='onkeypressUnidadeDes();' onfocus='montaParametrosAutocompleteUnidade();'>");
			} else {
				objeto.append("<input type='text' name='unidadeDes' id='unidadeDes' class='span12 Valid[Required] Description[unidade.unidade]' onkeydown='onkeypressUnidadeDes();' onfocus='montaParametrosAutocompleteUnidade();'>");
			}
			objeto.append("<input type='hidden' name='idUnidade' id='idUnidade' value='0'/>");
			document.getElementById("divUnidade").setInnerHTML(objeto.toString());
			document.executeScript("habilitaAutoComplete()");
		}
	}

	private void carregarComboTipoDemanda(final DocumentHTML document, final HttpServletRequest request) throws ServiceException, Exception {

		final HTMLSelect idTipoDemandaServico = document.getSelectById("idTipoDemandaServico");
		idTipoDemandaServico.removeAllOptions();

		idTipoDemandaServico.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		for (ServiceDemandType serviceDemandType : ServiceDemandType.valuesWithoutOS()) {
			idTipoDemandaServico.addOption(String.valueOf(serviceDemandType.getId()), UtilI18N.internacionaliza(request, serviceDemandType.getI18NKey()));
		}
	}

	public String getCalcularDinamicamente() throws Exception {
		String calcularDinamicamente = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.CALCULAR_PRIORIDADE_SOLICITACAO_DINAMICAMENTE, "N");
		return calcularDinamicamente.trim();
	}

	private void carregarCombosImpactoUrgente(final DocumentHTML document, final HttpServletRequest request) throws Exception, ServiceException {

		final HTMLSelect urgencia = document.getSelectById("urgencia");

		urgencia.removeAllOptions();

		final HTMLSelect impacto = document.getSelectById("impacto");

		impacto.removeAllOptions();

		if (!getCalcularDinamicamente().trim().equalsIgnoreCase("S")) {

			urgencia.addOption("B", UtilI18N.internacionaliza(request, "citcorpore.comum.baixa"));
			urgencia.addOption("M", UtilI18N.internacionaliza(request, "citcorpore.comum.media"));
			urgencia.addOption("A", UtilI18N.internacionaliza(request, "citcorpore.comum.alta"));

			impacto.addOption("B", UtilI18N.internacionaliza(request, "citcorpore.comum.baixa"));
			impacto.addOption("M", UtilI18N.internacionaliza(request, "citcorpore.comum.media"));
			impacto.addOption("A", UtilI18N.internacionaliza(request, "citcorpore.comum.alta"));

		} else {

			PrioridadeSolicitacoesService service = (PrioridadeSolicitacoesService) ServiceLocator.getInstance().getService(PrioridadeSolicitacoesService.class, null);
			final Collection<UrgenciaDTO> listUrgenciaDTO = service.consultaUrgencia();

			if (listUrgenciaDTO != null && !listUrgenciaDTO.isEmpty()) {
				for (final UrgenciaDTO urgenciaTemp : listUrgenciaDTO) {
					urgencia.addOption(urgenciaTemp.getSiglaUrgencia().toString().trim(), urgenciaTemp.getNivelUrgencia());
				}
			}

			final Collection<ImpactoDTO> listImpactoDTO = service.consultaImpacto();

			if (listImpactoDTO != null && !listImpactoDTO.isEmpty()) {
				for (final ImpactoDTO impactoTemp : listImpactoDTO) {
					impacto.addOption(impactoTemp.getSiglaImpacto().toString().trim(), impactoTemp.getNivelImpacto());
				}
			}
		}
	}

	/**
	 * @author joao.morais
	 * @since 25.05.2016
	 */
	private void carregarComboTipoCatalogoServicoSolicitacao(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		final HTMLSelect idTipoCatalogoServicoSolicitacao = document.getSelectById("idTipoCatalogoServicoSol");
		idTipoCatalogoServicoSolicitacao.setDisabled(false);
		idTipoCatalogoServicoSolicitacao.removeAllOptions();
		idTipoCatalogoServicoSolicitacao.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		for (TipoCatalogoServico tipoCatalogoServico : TipoCatalogoServico.values()) {
			idTipoCatalogoServicoSolicitacao.addOption(tipoCatalogoServico.getIdentificador(), UtilI18N.internacionaliza(request, tipoCatalogoServico.getChave()));
		}

		this.verificaTipoDeAcordoDoContrato(document, request, response);
	}

	/**
	 * De acordo com o Contrato selecionado, a combo idTipoCatalogoServico
	 * ser setado.
	 *
	 * @param sol
	 * @param idTipoCatalogoServicoSolicitacao
	 * @author joao.morais
	 * @throws Exception
	 */
	public void verificaTipoDeAcordoDoContrato(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		CadastroTemplateIncidenteRequisicaoDTO cadastroTemplateIncidenteRequisicaoDTO = (CadastroTemplateIncidenteRequisicaoDTO) document.getBean();

		if (cadastroTemplateIncidenteRequisicaoDTO.getIdContrato() != null) {
			ContratoDTO contrato = new ContratoDTO();
			contrato.setIdContrato(cadastroTemplateIncidenteRequisicaoDTO.getIdContrato());

			contrato = getContratoService().restore(contrato);

			if (contrato != null) {
				final HTMLSelect idTipoCatalogoServicoSolicitacao = document.getSelectById("idTipoCatalogoServicoSol");

				if (TipoAcordoContrato.CONTRATO.getIdentificador().equalsIgnoreCase(contrato.getTipo())) {
					idTipoCatalogoServicoSolicitacao.setValue(TipoCatalogoServico.SERVICO_NEGOCIO.getIdentificador());
				} else {
					idTipoCatalogoServicoSolicitacao.setValue(TipoCatalogoServico.SERVICO_TECNICO.getIdentificador());
				}
				document.executeScript("setaIdTipoCatalogoServicoSoli()");
				idTipoCatalogoServicoSolicitacao.setDisabled(true);
			}
		}
	}

	public void listarServicosNegocioTecnico(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final CadastroTemplateIncidenteRequisicaoDTO cadastroTemplateIncidenteRequisicaoDTO = (CadastroTemplateIncidenteRequisicaoDTO) document.getBean();

		final HTMLTable tblListaServicosNegocioTecnico = document.getTableById("tblListaServicosNegocioTecnico");
		tblListaServicosNegocioTecnico.deleteAllRows();

		final Collection<ServicoDTO> colServicos = this.getServicoService().findAutocompleteServicoNegocioTecnico(cadastroTemplateIncidenteRequisicaoDTO.getIdContrato(), cadastroTemplateIncidenteRequisicaoDTO.getTipoServico(), "");
		if (colServicos != null && !colServicos.isEmpty()) {
			tblListaServicosNegocioTecnico.addRowsByCollection(colServicos, new String[] { "idServico", "nomeServico" }, null, null, null, "selecionarServicoNegocioTecnico", null);
			document.executeScript("$('#modal_infoServicosNegocioTecnico').modal('show')");
		} else {
			document.alert(UtilI18N.internacionaliza(request, "MSG04"));
		}

		document.executeScript("depoisListarServicos();");
	}

	public void verificaImpactoUrgencia(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		CadastroTemplateIncidenteRequisicaoDTO cadastroTemplateIncidenteRequisicaoDTO = (CadastroTemplateIncidenteRequisicaoDTO) document.getBean();

		HTMLSelect impacto = document.getSelectById("impacto");
		HTMLSelect urgencia = document.getSelectById("urgencia");

		impacto.setDisabled(false);
		urgencia.setDisabled(false);

		if (cadastroTemplateIncidenteRequisicaoDTO.getIdServico() == null || cadastroTemplateIncidenteRequisicaoDTO.getIdContrato() == null) {
			return;
		}

		ServicoContratoDTO servicoContratoDto = this.getServicoContratoService().findByIdContratoAndIdServico(cadastroTemplateIncidenteRequisicaoDTO.getIdContrato(), cadastroTemplateIncidenteRequisicaoDTO.getIdServico());

		if (servicoContratoDto != null) {
			AcordoNivelServicoDTO acordoNivelServicoDto = this.getAcordoNivelServicoService().findAtivoByIdServicoContrato(servicoContratoDto.getIdServicoContrato(), "T");
			if (acordoNivelServicoDto == null) {
				// Se nao houver acordo especifico, ou seja, associado direto ao servicocontrato, entao busca um acordo geral que esteja vinculado ao servicocontrato.
				final AcordoServicoContratoDTO acordoServicoContratoDTO = this.getAcordoServicoContratoService().findAtivoByIdServicoContrato(servicoContratoDto.getIdServicoContrato(), "T");
				if (acordoServicoContratoDTO == null) {
					document.alert(UtilI18N.internacionaliza(request, "solicitacaoservico.validacao.tempoacordo"));
					return;
				}
				// Apos achar a vinculacao do acordo com o servicocontrato, entao faz um restore do acordo de nivel de servico.
				acordoNivelServicoDto = new AcordoNivelServicoDTO();
				acordoNivelServicoDto.setIdAcordoNivelServico(acordoServicoContratoDTO.getIdAcordoNivelServico());
				acordoNivelServicoDto = (AcordoNivelServicoDTO) new AcordoNivelServicoDao().restore(acordoNivelServicoDto);
				if (acordoNivelServicoDto == null) {
					// Se nao houver acordo especifico, ou seja, associado direto ao servicocontrato
					document.alert(UtilI18N.internacionaliza(request, "solicitacaoservico.validacao.tempoacordo"));
					return;
				}
			}
			if (acordoNivelServicoDto.getImpacto() != null) {
				impacto.setValue("" + acordoNivelServicoDto.getImpacto());
				if (acordoNivelServicoDto.getPermiteMudarImpUrg() != null && acordoNivelServicoDto.getPermiteMudarImpUrg().equalsIgnoreCase("N")) {
					impacto.setDisabled(true);
				}
			} else {
				impacto.setValue("B");
			}
			if (acordoNivelServicoDto.getUrgencia() != null) {
				urgencia.setValue("" + acordoNivelServicoDto.getUrgencia());
				if (acordoNivelServicoDto.getPermiteMudarImpUrg() != null && acordoNivelServicoDto.getPermiteMudarImpUrg().equalsIgnoreCase("N")) {
					urgencia.setDisabled(true);
				}
			} else {
				urgencia.setValue("B");
			}
		} else {
			impacto.setValue("B");
			urgencia.setValue("B");
		}
	}

	public void definirFiltrosServico(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws PersistenceException, ServiceException, Exception {
		SolicitacaoServicoDTO solicitacaoServicoDto = new SolicitacaoServicoDTO();
		CadastroTemplateIncidenteRequisicaoDTO cadastroTemplateIncidenteRequisicaoDTO = (CadastroTemplateIncidenteRequisicaoDTO) document.getBean();
		Reflexao.copyPropertyValues(cadastroTemplateIncidenteRequisicaoDTO, solicitacaoServicoDto);
		definirFiltrosServico(document, request, solicitacaoServicoDto);
	}

	private void definirFiltrosServico(final DocumentHTML document, final HttpServletRequest request, SolicitacaoServicoDTO solicitacaoServicoDTO) throws PersistenceException, ServiceException, Exception {
		if (SimNao.SIM.getValorStr().equalsIgnoreCase(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.SOLICITACAO_SERVICO_FILTRAR_CATEGORIA_SERVICO, SimNao.NAO.getValorStr()))) {
			this.carregarComboCategoriaServico(document, request, "");
			document.executeScript("ocultarCheckboxUtilizarCategoriaServico()");
		}

		if (solicitacaoServicoDTO.getIdContrato() != null && solicitacaoServicoDTO.getIdServico() != null) {
			ServicoDTO servicoRelacionado = this.getServicoService().recuperaServicoRelacionado(solicitacaoServicoDTO.getIdContrato(), solicitacaoServicoDTO.getIdServico());

			HTMLElement servicoNegocioTecnicoBusca = document.getElementById("servicoNegocioTecnicoBusca");
			servicoNegocioTecnicoBusca.setValue(UtilStrings.nullToVazio(servicoRelacionado.getNomeServico()));

			HTMLElement idServicoNegocioTecnicoBusca = document.getElementById("idServicoNegocioTecBusc");
			idServicoNegocioTecnicoBusca.setValue(UtilNumbersAndDecimals.nullToVazio(servicoRelacionado.getIdServico()));

			if (UtilStrings.isNotVazio(servicoRelacionado.getTipoServico())) {
				HTMLSelect idTipoCatalogoServicoSolicitacao = document.getSelectById("idTipoCatalogoServicoSol");
				idTipoCatalogoServicoSolicitacao.setValue(UtilStrings.nullToVazio(servicoRelacionado.getTipoServico()));
			}

			ServicoDTO servico = this.getServicoService().findById(solicitacaoServicoDTO.getIdServico());

			HTMLSelect idTipoDemandaServico = document.getSelectById("idTipoDemandaServico");
			idTipoDemandaServico.setValue(UtilNumbersAndDecimals.nullToVazio(servico.getIdTipoDemandaServico()));

			HTMLSelect idCategoriaServico = document.getSelectById("idCategoriaServico");
			idCategoriaServico.setValue(UtilNumbersAndDecimals.nullToVazio(servico.getIdCategoriaServico()));
		}
	}

	public void carregarComboCategoriaServico(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		carregarComboCategoriaServico(document, request, "");
	}

	private void carregarComboCategoriaServico(final DocumentHTML document, final HttpServletRequest request, String valorDefault) throws Exception {
		SolicitacaoServicoDTO solicitacaoServicoDTO = new SolicitacaoServicoDTO();
		CadastroTemplateIncidenteRequisicaoDTO cadastroTemplateIncidenteRequisicaoDTO = (CadastroTemplateIncidenteRequisicaoDTO) document.getBean();
		Reflexao.copyPropertyValues(cadastroTemplateIncidenteRequisicaoDTO, solicitacaoServicoDTO);

		if (solicitacaoServicoDTO != null) {
			List<CategoriaServicoDTO> listaDeCategorias = new ArrayList<CategoriaServicoDTO>();

			if (SimNao.SIM.getValorStr().equalsIgnoreCase(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.SOLICITACAO_SERVICO_FILTRAR_CATEGORIA_SERVICO, SimNao.NAO.getValorStr()))) {
				listaDeCategorias = this.getCategoriaService().findCategoriaRelacionadaAoServicoContrato(solicitacaoServicoDTO.getIdContrato(), solicitacaoServicoDTO.getIdServicoNegocioTecnico());
			} else {
				listaDeCategorias = (List<CategoriaServicoDTO>) this.getCategoriaService().listHierarquia();
			}

			final HTMLSelect idCategoriaServico = document.getSelectById("idCategoriaServico");
			this.inicializarCombo(idCategoriaServico, request);

			if ((listaDeCategorias == null || listaDeCategorias.isEmpty()) && SimNao.SIM.getValorStr().equalsIgnoreCase(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.SOLICITACAO_SERVICO_FILTRAR_CATEGORIA_SERVICO, SimNao.NAO.getValorStr()))) {
				document.executeScript("naoEncontrouRegistrosCategoriaServico();");
			} else if (listaDeCategorias != null && !listaDeCategorias.isEmpty()) {
				idCategoriaServico.addOptions(listaDeCategorias, "idCategoriaServico", "nomeCategoriaServico", valorDefault);
			}

			document.executeScript("depoisCarregarComboCategoria();");
		}
	}

	public void calculaSLA(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		String sla = "";
		try {
			SolicitacaoServicoDTO solicitacaoServicoDto = new SolicitacaoServicoDTO();
			CadastroTemplateIncidenteRequisicaoDTO cadastroTemplateIncidenteRequisicaoDTO = (CadastroTemplateIncidenteRequisicaoDTO) document.getBean();
			Reflexao.copyPropertyValues(cadastroTemplateIncidenteRequisicaoDTO, solicitacaoServicoDto);
			if (solicitacaoServicoDto.getIdContrato() == null || solicitacaoServicoDto.getIdContrato().intValue() == 0) {
				throw new LogicException("Contrato no encontrado");
			}
			if (solicitacaoServicoDto.getIdServico() == null || solicitacaoServicoDto.getIdServico().intValue() == 0) {
				throw new LogicException("Servio no encontrado");
			}

			sla = this.getSolicitacaoServicoService().calculaSLAMultinivel(solicitacaoServicoDto, document, request);

			if (sla.equals("")) {
				sla = "N/A";
			}

			MatrizPrioridade matrizPrioridade = MatrizPrioridade.getMatrizPrioridade(solicitacaoServicoDto.getUrgencia(), solicitacaoServicoDto.getImpacto());
			document.executeScript("exibeCalculoSLA('".concat(sla).concat("','").concat(matrizPrioridade.getCor()).concat("');"));

		} catch (final Exception e) {
			e.printStackTrace();
			if (sla.equals("")) {
				sla = "N/A";
			}

			document.executeScript("exibeCalculoSLA('".concat(sla).concat("','');"));
		}
	}

	private CadastroTemplateIncidenteRequisicaoService getCadastroTemplateIncidenteRequisicaoService() throws ServiceException {
		if (cadastroTemplateIncidenteRequisicaoService == null) {
			cadastroTemplateIncidenteRequisicaoService = (CadastroTemplateIncidenteRequisicaoService) ServiceLocator.getInstance().getService(CadastroTemplateIncidenteRequisicaoService.class, null);
		}
		return cadastroTemplateIncidenteRequisicaoService;
	}

	private ServicoContratoService getServicoContratoService() throws ServiceException {
		if (servicoContratoService == null) {
			servicoContratoService = (ServicoContratoService) ServiceLocator.getInstance().getService(ServicoContratoService.class, null);
		}
		return servicoContratoService;
	}

	private UnidadeService getUnidadeService() throws ServiceException {
		if (unidadeService == null) {
			unidadeService = (UnidadeService) ServiceLocator.getInstance().getService(UnidadeService.class, null);
		}
		return unidadeService;
	}

	private ServicoService getServicoService() throws ServiceException {
		if (servicoService == null) {
			servicoService = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);
		}
		return servicoService;
	}

	private ContratoService getContratoService() throws ServiceException {
		if (contratoService == null) {
			contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		}
		return contratoService;
	}

	private AcordoNivelServicoService getAcordoNivelServicoService() throws ServiceException {
		if (acordoNivelServicoService == null) {
			acordoNivelServicoService = (AcordoNivelServicoService) ServiceLocator.getInstance().getService(AcordoNivelServicoService.class, null);
		}
		return acordoNivelServicoService;
	}

	private AcordoServicoContratoService getAcordoServicoContratoService() throws ServiceException {
		if (acordoServicoContratoService == null) {
			acordoServicoContratoService = (AcordoServicoContratoService) ServiceLocator.getInstance().getService(AcordoServicoContratoService.class, null);
		}
		return acordoServicoContratoService;
	}

	private GrupoService getGrupoService() throws ServiceException {
		if (grupoService == null) {
			grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		}
		return grupoService;
	}

	private SolicitacaoServicoService getSolicitacaoServicoService() throws ServiceException {
		if (solicitacaoServicoService == null) {
			solicitacaoServicoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, null);
		}

		return solicitacaoServicoService;
	}

	private CategoriaServicoService getCategoriaService() throws ServiceException {
		if (categoriaService == null) {
			categoriaService = (CategoriaServicoService) ServiceLocator.getInstance().getService(CategoriaServicoService.class, null);
		}
		return categoriaService;
	}

	private EmpregadoService getEmpregadoService() throws ServiceException {
		if (empregadoService == null) {
			empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);
		}
		return empregadoService;
	}

	private CadastroTemplateIncidenteRequisicaoICService getCadastroTemplateIncidenteRequisicaoICService() throws ServiceException {
		if (cadastroTemplateIncidenteRequisicaoICService == null) {
			cadastroTemplateIncidenteRequisicaoICService = (CadastroTemplateIncidenteRequisicaoICService) ServiceLocator.getInstance().getService(CadastroTemplateIncidenteRequisicaoICService.class, null);
		}
		return cadastroTemplateIncidenteRequisicaoICService;
	}

	private ItemConfiguracaoService getItemConfiguracaoService() throws ServiceException {
		if (itemConfiguracaoService == null) {
			itemConfiguracaoService = (ItemConfiguracaoService) ServiceLocator.getInstance().getService(ItemConfiguracaoService.class, null);
		}
		return itemConfiguracaoService;
	}

	public ClienteService getClienteService() throws ServiceException {
		if (clienteService == null) {
			clienteService = (ClienteService) ServiceLocator.getInstance().getService(ClienteService.class, null);
		}
		return clienteService;
	}

	public FornecedorService getFornecedorService() throws ServiceException {
		if (fornecedorService == null) {
			fornecedorService = (FornecedorService) ServiceLocator.getInstance().getService(FornecedorService.class, null);
		}
		return fornecedorService;
	}
}