package br.com.centralit.citcorpore.ajaxForms;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.CadastroTipoFinanceiroDTO;
import br.com.centralit.citcorpore.negocio.CadastroTipoFinanceiroService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Permissoes;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.centralit.citcorpore.util.Enumerados.PagesPortfolio;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;

/**
 * @author joao.morais
 * @since 07/01/2016
 */
public class CadastroTipoFinanceiro extends AjaxFormAction {
	
	private CadastroTipoFinanceiroService cadastroTipoFinanceiroService;
	private static Permissoes permissao;
	/**
	 * @author murilo.rodrigues
	 * @since 01/10/2015
	 */
	private final String PERFIL_RECEITA = "R";
	
	@Override
	public Class<CadastroTipoFinanceiroDTO> getBeanClass() {
		return CadastroTipoFinanceiroDTO.class;
	}

	private void limparCamposDoFormulario(final DocumentHTML document, final HTMLForm form) throws Exception {
		this.limparFormulario(form);
	}

	private void limparFormulario(final HTMLForm form) {
		form.clear();
	}

	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		permissao = new Permissoes(document, request, PagesPortfolio.SERVICO_NEGOCIO_ATRIBUTOS_FINANCEIROS.getCaminho());
		montaCombo(document, request);
	}
	
	private CadastroTipoFinanceiroService getCadastroTipoFinanceiroService() throws ServiceException {
		if (cadastroTipoFinanceiroService == null) {
			cadastroTipoFinanceiroService = (CadastroTipoFinanceiroService) ServiceLocator.getInstance().getService(CadastroTipoFinanceiroService.class, null);
		}
		return cadastroTipoFinanceiroService;
	}
	
	public void restore(final String idTipo, final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception{
		HTMLSelect comboPerfil = document.getSelectById("perfilFinanceiroCadTipo");
		inicializaCombo(comboPerfil, request);
		int indice = 0;
		for (Enumerados.PerfilFinanceiro perfil : Enumerados.PerfilFinanceiro.values()) {
			
			if(buscaPerfil(Integer.parseInt(idTipo)).equals(perfil.getValorPerfil())){
				comboPerfil.setSelectedIndex(indice);
				comboPerfil.addOption(perfil.getValorPerfil(), UtilI18N.internacionaliza(request, perfil.getNomePerfil()));
				indice++;
			}else{
				comboPerfil.addOption(perfil.getValorPerfil(), UtilI18N.internacionaliza(request, perfil.getNomePerfil()));
				indice++;
			}
		}
	}

	public void save(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		CadastroTipoFinanceiroDTO cadastroTipoFinanceiroDTO = (CadastroTipoFinanceiroDTO) document.getBean();
		
		if(!permissao.isGravar()){
			document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
			return;
		}
		if(cadastroTipoFinanceiroDTO.getPerfil().equalsIgnoreCase(PERFIL_RECEITA)
				|| cadastroTipoFinanceiroDTO.getClassificacaoTipo() == -1)
			cadastroTipoFinanceiroDTO.setClassificacaoTipo(null);
		
		if (cadastroTipoFinanceiroDTO.getIdTipoSelecionado() != null && cadastroTipoFinanceiroDTO.getIdTipoSelecionado().intValue() > 0) {
			cadastroTipoFinanceiroDTO.setIdTipo(cadastroTipoFinanceiroDTO.getIdTipoSelecionado());
			this.getCadastroTipoFinanceiroService().update(cadastroTipoFinanceiroDTO);
			document.alert(UtilI18N.internacionaliza(request, "MSG06"));
		} else {
			if(!verificaTipoFinanceiro(cadastroTipoFinanceiroDTO)){
				cadastroTipoFinanceiroDTO = this.getCadastroTipoFinanceiroService().create(cadastroTipoFinanceiroDTO);
				if (cadastroTipoFinanceiroDTO != null) {
					document.alert(UtilI18N.internacionaliza(request, "MSG05"));
				}
			}else{
				document.alert(UtilI18N.internacionaliza(request, "MSG12"));
			}
		}
		
		//atualiza combo com tipo adicionado
		GerenciamentoPortfolioAtributosFinanceiros gerenciamentoPortfolioAtributosFinanceiros  = new GerenciamentoPortfolioAtributosFinanceiros();
		gerenciamentoPortfolioAtributosFinanceiros.iniciaComboTipo(cadastroTipoFinanceiroDTO.getPerfil(), document, request);
		
		document.executeScript("limparAplicacao();");
	}
	
	public void excluir(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		final CadastroTipoFinanceiroDTO cadastroTipoFinanceiroDTO = (CadastroTipoFinanceiroDTO) document.getBean();
		if (cadastroTipoFinanceiroDTO != null && cadastroTipoFinanceiroDTO.getIdTipoSelecionado() != null && cadastroTipoFinanceiroDTO.getIdTipoSelecionado().intValue() > 0) {
			if(!permissao.isDeletar()){
				document.executeScript("JANELA_AGUARDE_MENU.hide();");
				document.executeScript("notificacaoErro('citcorpore.comum.permissaoFuncionalidade');");
				return;
			}
			this.getCadastroTipoFinanceiroService().deleteLogico(cadastroTipoFinanceiroDTO);
			final HTMLForm form = document.getForm("formCadastroTipoFinanceiro");
			limparCamposDoFormulario(document, form);
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			document.alert(UtilI18N.internacionaliza(request, "MSG07"));
		}else{
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			document.alert(UtilI18N.internacionaliza(request, "gerenciaportfolio.atributosFinanceiros.falhaExcluir"));
		}
		
	}

	private void limparFormulariosCadastro(final DocumentHTML document) throws Exception {
		final HTMLForm formCadastroTipoFinanceiro = document.getForm("formCadastroTipoFinanceiro");
		this.limparCamposDoFormulario(document, formCadastroTipoFinanceiro);
	}
	
	private void montaCombo(DocumentHTML document, HttpServletRequest request) throws Exception{
		HTMLSelect comboPerfil = document.getSelectById("perfilFinanceiroCadTipo");
		inicializaCombo(comboPerfil, request);
		for (Enumerados.PerfilFinanceiro perfil : Enumerados.PerfilFinanceiro.values()) {
			comboPerfil.addOption(perfil.getValorPerfil(), UtilI18N.internacionaliza(request, perfil.getNomePerfil()));
		}
		carregarComboClassificacao(document, request);
	}
	
	private void inicializaCombo(HTMLSelect componenteCombo, HttpServletRequest request) {
		componenteCombo.removeAllOptions();
	}
	
	/*
	 * Retorna false se no existir a combinao tipo e perfil na tabela
	 */
	private boolean verificaTipoFinanceiro(CadastroTipoFinanceiroDTO cadastroTipoFinanceiroDTO) throws ServiceException, PersistenceException{
		if(this.getCadastroTipoFinanceiroService().findTipoFinanceiro(cadastroTipoFinanceiroDTO))
			return true;
		else 
			return false;
	}
	
	private String buscaPerfil(Integer idTipo) throws PersistenceException, ServiceException{
		String perfil = this.getCadastroTipoFinanceiroService().getPerfil(idTipo);
		return perfil;
	}
	
	public void carregarComboClassificacao(final DocumentHTML document, final HttpServletRequest request) throws Exception{
		HTMLSelect classificacaoSelect = document.getSelectById("classificacaoTipo");
		classificacaoSelect.removeAllOptions();
		classificacaoSelect.addOption("-1", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
		for(Enumerados.ClassificacaoTipoFinanceiro classificacaoTipoFinanceiro : Enumerados.ClassificacaoTipoFinanceiro.values()){
			classificacaoSelect.addOption(
					classificacaoTipoFinanceiro.getIdClassificacaoTipoFinanceiro().toString(), 
					UtilI18N.internacionaliza(request, classificacaoTipoFinanceiro.getNomeClassificacaoTipoFinanceiro()));
		}
		document.executeScript("atualizaClassificacaoCadastro();");
	}

}
