package br.com.centralit.citcorpore.ajaxForms;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.AtributosFinanceirosDTO;
import br.com.centralit.citcorpore.negocio.ImportarDadosArquivoService;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Upload;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;

public class CapacidadeIntegracao extends AjaxFormAction {

	@Override
	public Class<AtributosFinanceirosDTO> getBeanClass() {
		return AtributosFinanceirosDTO.class;
	}

	private ImportarDadosArquivoService importarDadosArquivoService;
	
	@SuppressWarnings("rawtypes")
	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		HashMap hshRetorno[] = null;
		Upload upload = new Upload();
        try {
            hshRetorno = upload.doUploadAll(request);
	        if (hshRetorno != null) {
	
	            Collection fileItems = hshRetorno[1].values();
	            String fileName = "";
	            FileItem fi;
	            String mensagemRetorno = "importaratributofinanceiro.falhaimportacao";
	            if (fileItems != null && !fileItems.isEmpty()) {
	            	File arquivo = null;
	                Iterator it = fileItems.iterator();
	                while (it.hasNext()) {
	                    fi = (FileItem) it.next();
	
	                    if (fi.getName().length() < 1) {
	                    	mensagemRetorno =  "cargaCatalagoServico.selecionarArquivo";
	                        break;
	                    }
	
	                    String extensao = br.com.centralit.citcorpore.util.Util.getFileExtension(fi.getName());
	                    if (!extensao.equalsIgnoreCase("xml") 
	                    		&& !extensao.equalsIgnoreCase("csv")
	                    		&& !extensao.equalsIgnoreCase("xls")
	                    		&& !extensao.equalsIgnoreCase("xlsx") ) {
	                    	mensagemRetorno = "importaratributofinanceiro.erroformato";
	                        break;
	                    }
	                    fileName = fi.getName();
	                    arquivo = new File(CITCorporeUtil.CAMINHO_REAL_APP + "tempFiles/" + fileName);
	                    fi.write(arquivo);
	                    getImportarDadosArquivoService().getMapaDados(arquivo);
					}
                }

                document.alert(UtilI18N.internacionaliza(request, mensagemRetorno));
            }
        } catch (Exception e){
    		throw e;
        } finally {
        }
	}
	
	private ImportarDadosArquivoService getImportarDadosArquivoService() throws ServiceException{
		if(importarDadosArquivoService == null){
			importarDadosArquivoService = (ImportarDadosArquivoService) ServiceLocator.getInstance().getService(ImportarDadosArquivoService.class, null);
		}
		return importarDadosArquivoService;
	}

}
