package br.com.centralit.citcorpore.ajaxForms;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;

import com.github.sommeri.less4j.core.parser.LessParser.document_return;

import br.com.centralit.bpm.util.UtilScript;
import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.CargaPaisesDTO;
import br.com.centralit.citcorpore.bean.ScriptsDTO;
import br.com.centralit.citcorpore.bean.UnidadeDTO;
import br.com.centralit.citcorpore.negocio.PaisServico;
import br.com.centralit.citcorpore.negocio.ScriptsService;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.dto.Usuario;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilI18N;

@SuppressWarnings({ "rawtypes" })
public class CargaPaises extends AjaxFormAction {
	
	private String dPaises = CITCorporeUtil.CAMINHO_REAL_APP + "sqls" + System.getProperty("file.separator") + "paises";
	
	@Override
    public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
    	this.carregaCombo(document, request, response);
    }
	
	public void executarCarga(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) {
		try{
			CargaPaisesDTO carga = (CargaPaisesDTO)document.getBean();
			final Usuario usuario = WebUtil.getUsuarioSistema(request);
			
			PaisServico paisService = (PaisServico) ServiceLocator.getInstance().getService(PaisServico.class, usuario);
			
			if(carga.getPais().isEmpty()){
				document.alert(UtilI18N.internacionaliza(request, "cargaPaises.msg.Selecionar"));
				document.executeScript("JANELA_AGUARDE_MENU.hide();");
				return;
			}
			
			if(paisService.existeNomePais(carga.getPais())){
				document.alert(UtilI18N.internacionaliza(request, "cargaPaises.msg.CargaEfetuada"));
				document.executeScript("JANELA_AGUARDE_MENU.hide();");
				return;
			}
			
			String script = doScript(carga.getPais()+".sql");
			ScriptsDTO s= new ScriptsDTO();
			s.setNome("Carga de Pais");
			s.setDescricao("Script carregado na tela de carga de pais");
			s.setSqlQuery(script);
			ScriptsService scriptsService = (ScriptsService) ServiceLocator.getInstance().getService(ScriptsService.class, usuario);
			scriptsService.executarScriptUpdate(s);
			
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			document.alert(UtilI18N.internacionaliza(request, "cargaPaises.msg.Sucesso"));
		}catch(Exception e){
			document.executeScript("JANELA_AGUARDE_MENU.hide();");
			document.alert(e.getMessage());
		}
	}
    
    private void carregaCombo(DocumentHTML document, HttpServletRequest request, HttpServletResponse response){
    	try{
	    	final HTMLSelect combo = document.getSelectById("pais");
	    	List<String> paises = this.buscaPaisesDiretorio();
	    	combo.addOption("", UtilI18N.internacionaliza(request, "cargaPaises.msg.Selecionar"));
	    	for(String pais : paises){
	    		combo.addOption(pais, pais);
	    	}
    	}catch(Exception e){
    		document.alert(e.getMessage());
    	}
    }
    
    private List<String> buscaPaisesDiretorio(){
    	List<String> paises = new ArrayList<String>();
    	File diretorio= new File(dPaises);
    	File files[];
    	String aux;
    	
    	if(diretorio.isDirectory()){
	    	files = diretorio.listFiles();
	    	
	    	for(File file : files){
	    		aux = file.getName();
	    		if(aux.substring(aux.length()-4).equals(".sql")){
	    			paises.add(aux.substring(0, aux.length()-4));
	    		}
	    	}
    	}
    	
    	return paises;
    }
    
    private String doScript(String pais) throws Exception{
    	File f = new File(dPaises+System.getProperty("file.separator")+pais);
    	String aux = "";
    	
    	aux = new String(Files.readAllBytes(f.toPath()));
    	
		return aux;
    }

    @Override
    public Class<CargaPaisesDTO> getBeanClass() {
        return CargaPaisesDTO.class;
    }

}
