package br.com.centralit.citcorpore.ajaxForms;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONArray;
import org.json.JSONObject;

import br.com.centralit.bpm.dto.FluxoDTO;
import br.com.centralit.bpm.servico.FluxoService;
import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.CalendarioDTO;
import br.com.centralit.citcorpore.bean.CargaPortfolioServicoDTO;
import br.com.centralit.citcorpore.bean.CondicaoOperacaoDTO;
import br.com.centralit.citcorpore.bean.FaseServicoDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.ModeloEmailDTO;
import br.com.centralit.citcorpore.negocio.CalendarioService;
import br.com.centralit.citcorpore.negocio.CondicaoOperacaoService;
import br.com.centralit.citcorpore.negocio.FaseServicoService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.ImportarCargaPortfolioServicoService;
import br.com.centralit.citcorpore.negocio.ModeloEmailService;
import br.com.centralit.citcorpore.negocio.ServicoService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.CriticidadeServico;
import br.com.centralit.citcorpore.util.Enumerados.DemandaServicoNegocio;
import br.com.centralit.citcorpore.util.Enumerados.FaseServico;
import br.com.centralit.citcorpore.util.Enumerados.RetornoFinanceiroServico;
import br.com.centralit.citcorpore.util.Enumerados.ServiceDemandType;
import br.com.centralit.citcorpore.util.Enumerados.ServiceSituation;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.Enumerados.StatusServico;
import br.com.centralit.citcorpore.util.Enumerados.TipoDeInvestimento;
import br.com.centralit.citcorpore.util.Enumerados.TipoValorImportacaoCarga;
import br.com.centralit.citcorpore.util.Enumerados.ValoresDefaultImportacaoCargaServicoPortfolio;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilStrings;

public class CargaPortfolioServico extends AjaxFormAction {
	private ServicoService servicoService;
	private ModeloEmailService modeloEmailService;
	private GrupoService grupoService;
	private CalendarioService calendarioService;
	private CondicaoOperacaoService condicaoOperacaoService;
	private FluxoService fluxoService;
	private FaseServicoService faseServicoService;
	private ImportarCargaPortfolioServicoService importarCargaPortfolioServicoService;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		setDefaultValues(document, request);
		carregaCombos(document, request);
	}

	private void setDefaultValues(DocumentHTML document, HttpServletRequest request) throws Exception {
		StringBuilder sbScript = new StringBuilder();

		// Data Implantao Servio
		sbScript.append("$('#campoCargaServicoDataImplantacao .campoValorDefault').text('");
		sbScript.append(UtilI18N.internacionaliza(request, ValoresDefaultImportacaoCargaServicoPortfolio.SERVICO_DATA_IMPLANTACAO.getChave()));
		sbScript.append("');");
		sbScript.append("$('#campoCargaServicoDataImplantacao .campoValorDefault').attr('data-valor', '");
		sbScript.append(UtilI18N.internacionaliza(request, ValoresDefaultImportacaoCargaServicoPortfolio.SERVICO_DATA_IMPLANTACAO.getValor()));
		sbScript.append("');");

		// Fase Servio
		sbScript.append("$('#campoCargaServicoFase .campoValorDefault').text('");
		sbScript.append(UtilI18N.internacionaliza(request, ValoresDefaultImportacaoCargaServicoPortfolio.SERVICO_FASE.getChave()));
		sbScript.append("');");
		sbScript.append("$('#campoCargaServicoFase .campoValorDefault').attr('data-valor', '");
		sbScript.append(ValoresDefaultImportacaoCargaServicoPortfolio.SERVICO_FASE.getValor());
		sbScript.append("');");

		// Status Servio
		sbScript.append("$('#campoCargaServicoStatus .campoValorDefault').text('");
		sbScript.append(UtilI18N.internacionaliza(request, ValoresDefaultImportacaoCargaServicoPortfolio.SERVICO_STATUS.getChave()));
		sbScript.append("');");
		sbScript.append("$('#campoCargaServicoStatus .campoValorDefault').attr('data-valor', '");
		sbScript.append(ValoresDefaultImportacaoCargaServicoPortfolio.SERVICO_STATUS.getValor());
		sbScript.append("');");
		
		// Criticidade Servio (Classificao)
		sbScript.append("$('#campoCargaServicoCriticidade .campoValorDefault').text('");
		sbScript.append(UtilI18N.internacionaliza(request, ValoresDefaultImportacaoCargaServicoPortfolio.SERVICO_CRITICIDADE.getChave()));
		sbScript.append("');");
		sbScript.append("$('#campoCargaServicoCriticidade .campoValorDefault').attr('data-valor', '");
		sbScript.append(ValoresDefaultImportacaoCargaServicoPortfolio.SERVICO_CRITICIDADE.getValor());
		sbScript.append("');");

		// Situao Incidente/Requisio
		sbScript.append("$('#campoCargaIncidenteRequisicaoSituacao .campoValorDefault').text('");
		sbScript.append(UtilI18N.internacionaliza(request, ValoresDefaultImportacaoCargaServicoPortfolio.INCIDENTE_REQUISICAO_SITUACAO.getChave()));
		sbScript.append("');");
		sbScript.append("$('#campoCargaIncidenteRequisicaoSituacao .campoValorDefault').attr('data-valor', '");
		sbScript.append(ValoresDefaultImportacaoCargaServicoPortfolio.INCIDENTE_REQUISICAO_SITUACAO.getValor());
		sbScript.append("');");

		// Data Implantao Incidente/Requisio
		sbScript.append("$('#campoCargaIncidenteRequisicaoDataImplantacao .campoValorDefault').text('");
		sbScript.append(UtilI18N.internacionaliza(request, ValoresDefaultImportacaoCargaServicoPortfolio.INCIDENTE_REQUISICAO_DATA_IMPLANTACAO.getChave()));
		sbScript.append("');");
		sbScript.append("$('#campoCargaIncidenteRequisicaoDataImplantacao .campoValorDefault').attr('data-valor', '");
		sbScript.append(UtilI18N.internacionaliza(request, ValoresDefaultImportacaoCargaServicoPortfolio.INCIDENTE_REQUISICAO_DATA_IMPLANTACAO.getValor()));
		sbScript.append("');");

		// Disponvel no Portal Incidente/Requisio
		sbScript.append("$('#campoCargaIncidenteRequisicaoDisponivelPortal .campoValorDefault').text('");
		sbScript.append(UtilI18N.internacionaliza(request, ValoresDefaultImportacaoCargaServicoPortfolio.INCIDENTE_REQUISICAO_DIPONIVEL_PORTAL.getChave()));
		sbScript.append("');");
		sbScript.append("$('#campoCargaIncidenteRequisicaoDisponivelPortal .campoValorDefault').attr('data-valor', '");
		sbScript.append(ValoresDefaultImportacaoCargaServicoPortfolio.INCIDENTE_REQUISICAO_DIPONIVEL_PORTAL.getValor());
		sbScript.append("');");

		//		sbScript.append("$('#campoCargaContratoIncReqCondicaoOperacao .campoValorDefault').text('");
		//		sbScript.append(UtilI18N.internacionaliza(request, ValoresDefaultImportacaoCargaServicoPortfolio.CONTRATO_INCIDENTE_REQUISICAO_CONDICAO_OPERACAO.getChave()));
		//		sbScript.append("');");

		document.executeScript(sbScript.toString());
	}

	private void carregaCombos(DocumentHTML document, HttpServletRequest request) throws Exception {
		carregaComboFaseServico(document, request);
		carregaComboCriticidadeServico(document, request);
		carregaComboTipoDeInvestimentoServico(document, request);
		carregaComboDemandaNegocioServico(document, request);
		carregaComboTipoRetornoServico(document, request);
		carregaComboSituacaoServicoIncReq(document, request);
		carregaComboTipoDemandaServicoIncReq(document, request);
		carregaComboDisponivelPortalServicoIncReq(document, request);
//		carregaComboCondicaoOperacaoContratoIncReq(document, request);
//		carregaComboModeloEmailAberturaContratoIncReq(document, request);
//		carregaComboGrupoNivel1ContratoIncReq(document, request);
//		carregaComboGrupoExecutorContratoIncReq(document, request);
//		carregaComboCalendarioContratoIncReq(document, request);
//		carregaComboTipoFluxoContratoIncReq(document, request);
//		carregaComboFaseContratoIncReq(document, request);
	}

	private void carregaComboFaseServico(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("faseServicoCarga");
		combo.removeAllOptions();

		for (FaseServico faseServico : FaseServico.values()) {
			combo.addOption(faseServico.getIdentificador(), UtilI18N.internacionaliza(request, faseServico.getChave()));
		}

		combo = document.getSelectById("statusServicoCarga");
		combo.removeAllOptions();

		for (StatusServico statusServico : StatusServico.fromFase(FaseServico.DEFINIR)) {
			combo.addOption(statusServico.getIdentificador(), UtilI18N.internacionaliza(request, statusServico.getChave()));
		}
	}

	/**
	 * De acordo com os requisitos do Gerenciamento de Portflio, o servio ser classificado em <i>status</i>, de acordo com a fase selecionada.
	 *
	 * @see br.com.centralit.citcorpore.util.Enumerados.StatusServico
	 * @since 25/09/2015
	 * @author douglas.japiassu
	 */
	public void carregaComboStatusServico(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("statusServicoCarga");
		combo.removeAllOptions();

		CargaPortfolioServicoDTO cargaPortfolioServicoDTO = (CargaPortfolioServicoDTO) document.getBean();

		if (UtilStrings.isNotVazio(cargaPortfolioServicoDTO.getFaseServico())) {
			FaseServico fase = FaseServico.fromTipo(cargaPortfolioServicoDTO.getFaseServico());

			for (StatusServico statusServico : StatusServico.fromFase(fase)) {
				combo.addOption(statusServico.getIdentificador(), UtilI18N.internacionaliza(request, statusServico.getChave()));
			}
		}
	}
	
	private void carregaComboCriticidadeServico(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("criticidadeServicoCarga");
		combo.removeAllOptions();

		for (CriticidadeServico criticidadeServico : CriticidadeServico.values()) {
			combo.addOption(criticidadeServico.getIdentificador().toString(), UtilI18N.internacionaliza(request, criticidadeServico.getChave()));
		}
	}
	
	private void carregaComboTipoDeInvestimentoServico(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("tipoInvestimentoServicoCarga");
		combo.removeAllOptions();

		for (TipoDeInvestimento tipoDeInvestimento : TipoDeInvestimento.values()) {
			combo.addOption(tipoDeInvestimento.getIdentificador(), UtilI18N.internacionaliza(request, tipoDeInvestimento.getChave()));
		}
	}

	private void carregaComboDemandaNegocioServico(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("tipoDemandaServicoCarga");
		combo.removeAllOptions();

		for (DemandaServicoNegocio demandaServicoNegocio : DemandaServicoNegocio.values()) {
			combo.addOption(demandaServicoNegocio.getIdentificador().toString(), UtilI18N.internacionaliza(request, demandaServicoNegocio.getChave()));
		}
	}

	private void carregaComboTipoRetornoServico(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("retornoFinanceiroServicoCarga");
		combo.removeAllOptions();

		for (RetornoFinanceiroServico retornoFinanceiroServico : RetornoFinanceiroServico.values()) {
			combo.addOption(retornoFinanceiroServico.getIdentificador().toString(), UtilI18N.internacionaliza(request, retornoFinanceiroServico.getChave()));
		}
	}

	private void carregaComboSituacaoServicoIncReq(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("situacaoServicoIncReqCarga");
		combo.removeAllOptions();

		for (ServiceSituation serviceSituation : ServiceSituation.values()) {
			combo.addOption(String.valueOf(serviceSituation.getId()), UtilI18N.internacionaliza(request, serviceSituation.getI18NKey()));
		}
	}

	private void carregaComboTipoDemandaServicoIncReq(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("tipoDemandaServicoIncReqCarga");
		combo.removeAllOptions();
		
		for (ServiceDemandType serviceDemandType : ServiceDemandType.valuesWithoutOSAndProcedure()) {
			combo.addOption(String.valueOf(serviceDemandType.getId()), UtilI18N.internacionaliza(request, serviceDemandType.getI18NKey()));
		}
	}

	private void carregaComboDisponivelPortalServicoIncReq(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("disponivelPortalServicoIncReqCarga");
		combo.removeAllOptions();

		combo.addOption(SimNao.NAO.getValorStr(), UtilI18N.internacionaliza(request, SimNao.NAO.getChave()));
		combo.addOption(SimNao.SIM.getValorStr(), UtilI18N.internacionaliza(request, SimNao.SIM.getChave()));
	}

	private void carregaComboCondicaoOperacaoContratoIncReq(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("condicaoOperacaoContratoIncReqCarga");
		combo.removeAllOptions();

		Collection<CondicaoOperacaoDTO> listCondicaoOperacaoDto = this.getCondicaoOperacaoService().list();

		if (listCondicaoOperacaoDto != null) {
			for (CondicaoOperacaoDTO condicaoOperacaoDto : listCondicaoOperacaoDto) {
				if (condicaoOperacaoDto.getDataFim() == null) {
					combo.addOption(String.valueOf(condicaoOperacaoDto.getIdCondicaoOperacao()), condicaoOperacaoDto.getNomeCondicaoOperacao());
				}
			}
		}
	}

	private void carregaComboModeloEmailAberturaContratoIncReq(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("emailAberturaContratoIncReqCarga");
		combo.removeAllOptions();

		Collection<ModeloEmailDTO> listModeloEmailDto = this.getModeloEmailService().getAtivos();

		if (listModeloEmailDto != null) {
			for (ModeloEmailDTO modeloEmailDTO : listModeloEmailDto) {
				combo.addOption(String.valueOf(modeloEmailDTO.getIdModeloEmail()), modeloEmailDTO.getTitulo());
			}
		}
	}

	private void carregaComboGrupoNivel1ContratoIncReq(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("grupoPrimeiroNivelContratoIncReqCarga");
		combo.removeAllOptions();

		Collection<GrupoDTO> listGrupoDto = this.getGrupoService().listaGruposAtivos();

		if (listGrupoDto != null) {
			for (GrupoDTO grupoDTO : listGrupoDto) {
				combo.addOption(String.valueOf(grupoDTO.getIdGrupo()), grupoDTO.getNome());
			}
		}
	}

	private void carregaComboGrupoExecutorContratoIncReq(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("grupoExecutorContratoIncReqCarga");
		combo.removeAllOptions();

		Collection<GrupoDTO> listGrupoDto = this.getGrupoService().listaGruposAtivos();

		if (listGrupoDto != null) {
			for (GrupoDTO grupoDTO : listGrupoDto) {
				combo.addOption(String.valueOf(grupoDTO.getIdGrupo()), grupoDTO.getNome());
			}
		}
	}

	private void carregaComboCalendarioContratoIncReq(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("calendarioContratoIncReqCarga");
		combo.removeAllOptions();

		Collection<CalendarioDTO> listCalendarioDto = this.getCalendarioService().list();

		if (listCalendarioDto != null) {
			for (CalendarioDTO calendarioDTO : listCalendarioDto) {
				combo.addOption(String.valueOf(calendarioDTO.getIdCalendario()), calendarioDTO.getDescricao());
			}
		}
	}

	private void carregaComboTipoFluxoContratoIncReq(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("comboTipoFluxoCarga");
		combo.removeAllOptions();

		Collection<FluxoDTO> listFluxoDto = this.getFluxoService().list();

		if (listFluxoDto != null) {
			for (FluxoDTO fluxoDto : listFluxoDto) {
				combo.addOption(String.valueOf(fluxoDto.getIdTipoFluxo()), fluxoDto.getDescricao());
			}
		}
	}

	private void carregaComboFaseContratoIncReq(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect combo = document.getSelectById("comboFaseCarga");
		combo.removeAllOptions();

		Collection<FaseServicoDTO> listFaseServicoDto = this.getFaseServicoService().list();

		if (listFaseServicoDto != null) {
			String nomeFase;
			Enumerados.FaseServicoFluxo faseServico;
			for (FaseServicoDTO faseServicoDto : listFaseServicoDto) {
				faseServico = Enumerados.FaseServicoFluxo.fromIdentificador(faseServicoDto.getNomeFase());
				nomeFase = faseServico != null ? UtilI18N.internacionaliza(request, faseServico.getChave()) : faseServicoDto.getNomeFase();
				combo.addOption(String.valueOf(faseServicoDto.getIdFase()), nomeFase);
			}
		}
	}
	
	public void gerarModeloXls(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		CargaPortfolioServicoDTO cargaPortfolioServicoDTO = (CargaPortfolioServicoDTO) document.getBean();
		List<String> listCamposValoresPermitidos = new ArrayList<>();
		inicializaListaValoresPermitidos(request, listCamposValoresPermitidos);
		
		JSONArray jaCamposCarga = new JSONArray(cargaPortfolioServicoDTO.getJson());
		
		if (jaCamposCarga != null && jaCamposCarga.length() > 0) {
			Integer quantidadeRegistros = cargaPortfolioServicoDTO.getQuantidadeRegistros();
			List<Row> listRowsValorCarga = new ArrayList<>();
			
			String nomePlanilhaCarga = UtilI18N.internacionaliza(request, "cargaPortfolioServico.nomePlanilha.carga");
			String nomePlanilhaValoresDefault = UtilI18N.internacionaliza(request, "cargaPortfolioServico.nomePlanilha.valoresDefault");
			String nomePlanilhaValoresPossiveis = UtilI18N.internacionaliza(request, "cargaPortfolioServico.nomePlanilha.valoresPossiveis");
			
			HSSFWorkbook workbook = new HSSFWorkbook();
			HSSFSheet sheetCarga = workbook.createSheet(nomePlanilhaCarga);
			HSSFSheet sheetDefault = workbook.createSheet(nomePlanilhaValoresDefault);
			sheetDefault.protectSheet("sheetProtected" + Double.toHexString(Math.floor((1 + Math.random()) * 0x10000)));
			HSSFSheet sheetValores = workbook.createSheet(nomePlanilhaValoresPossiveis);
			sheetValores.protectSheet("sheetProtected" + Double.toHexString(Math.floor((1 + Math.random()) * 0x10000)));
			
			CreationHelper createHelper = workbook.getCreationHelper();
			
			Row rowHeadCarga = sheetCarga.createRow(0);
			
			CellStyle boldStyle = workbook.createCellStyle();
			Font boldFont = workbook.createFont();
			boldFont.setBoldweight(Font.BOLDWEIGHT_BOLD);
			boldStyle.setFont(boldFont);
			
			CellStyle hlinkStyle = workbook.createCellStyle();
			Font hlinkFont = workbook.createFont();
			hlinkFont.setUnderline(Font.U_SINGLE);
			hlinkFont.setColor(IndexedColors.BLUE.getIndex());
			hlinkStyle.setFont(hlinkFont);
			
			int numColunaCarga = 0;
			int numRowDefault = 0;
			int numRowValores = 0;
			
			if (quantidadeRegistros != null) {
				for (int indexRow = 1; indexRow <= quantidadeRegistros; indexRow++) {
					listRowsValorCarga.add(sheetCarga.createRow(indexRow));
				}
			}
			
			Row rowDefaultIdioma = sheetDefault.createRow(numRowDefault);
			Cell cellCampoDefaultIdioma = rowDefaultIdioma.createCell(0);
			cellCampoDefaultIdioma.setCellValue(UtilI18N.internacionaliza(request, "lingua.lingua"));
			cellCampoDefaultIdioma.setCellStyle(boldStyle);
			
			Cell cellValorDefaultIdioma = rowDefaultIdioma.createCell(1);
			cellValorDefaultIdioma.setCellValue(WebUtil.getLanguage(request));
			
			numRowDefault++;
			
			for (int index = 0, qtdCampos = jaCamposCarga.length(); index < qtdCampos; index++) {
				JSONObject joCampoCarga = jaCamposCarga.getJSONObject(index);
				
				if (joCampoCarga.getInt("tipoValor") != TipoValorImportacaoCarga.DEFAULT.getIdentificador().intValue()) {
					Cell cellNome = rowHeadCarga.createCell(numColunaCarga);
					cellNome.setCellValue(joCampoCarga.getString("nome"));
					cellNome.setCellStyle(boldStyle);
					
					if (joCampoCarga.getInt("tipoValor") == TipoValorImportacaoCarga.INFORMADO.getIdentificador().intValue()) {
						if (listRowsValorCarga != null) {
							for (Row rowValorCarga : listRowsValorCarga) {
								Cell cellValor = rowValorCarga.createCell(numColunaCarga);
								cellValor.setCellValue(joCampoCarga.getString("valor"));
							}
						}
					}
					
					if (listCamposValoresPermitidos != null && listCamposValoresPermitidos.contains(joCampoCarga.getString("nome"))) {
						Hyperlink linkValoresPermitidos = createHelper.createHyperlink(Hyperlink.LINK_DOCUMENT);
						linkValoresPermitidos.setAddress("'"+nomePlanilhaValoresPossiveis+"'!A" + (numRowValores + 1));
						cellNome.setHyperlink(linkValoresPermitidos);
						cellNome.setCellStyle(hlinkStyle);
						
						Row rowHeadValorPermitido = sheetValores.createRow(numRowValores);
						Cell cellHeadValorPermitido = rowHeadValorPermitido.createCell(0);
						cellHeadValorPermitido.setCellValue(joCampoCarga.getString("nome"));
						cellHeadValorPermitido.setCellStyle(boldStyle);
						CellRangeAddress cellRangeAddress = new CellRangeAddress(numRowValores, numRowValores, 0, 1);
						sheetValores.addMergedRegion(cellRangeAddress);
						numRowValores++;
						Row rowHead2ValorPermitido = sheetValores.createRow(numRowValores);
						Cell cellHead2ValorPermitido = rowHead2ValorPermitido.createCell(0);
						cellHead2ValorPermitido.setCellValue(UtilI18N.internacionaliza(request, "citcorpore.comum.valor"));
						cellHead2ValorPermitido.setCellStyle(boldStyle);
						Cell cellHead2DescValorPermitido = rowHead2ValorPermitido.createCell(1);
						cellHead2DescValorPermitido.setCellValue(UtilI18N.internacionaliza(request, "citcorpore.comum.descricao"));
						cellHead2DescValorPermitido.setCellStyle(boldStyle);
						numRowValores++;
						
						numRowValores = this.createRowValorPermitido(request, joCampoCarga.getString("nome"), sheetValores, numRowValores);
					}
					
					numColunaCarga++;
				} else {
					Row rowDefault = sheetDefault.createRow(numRowDefault);
					Cell cellCampoDefault = rowDefault.createCell(0);
					cellCampoDefault.setCellValue(joCampoCarga.getString("nome"));
					cellCampoDefault.setCellStyle(boldStyle);
					
					Cell cellValorDefault = rowDefault.createCell(1);
					cellValorDefault.setCellValue(joCampoCarga.getString("valor"));
					
					Cell cellDescValorDefault = rowDefault.createCell(2);
					cellDescValorDefault.setCellValue(UtilStrings.nullToVazio(joCampoCarga.getString("descValorDefault")));
					
					numRowDefault++;
				}
			}
			
			sheetDefault.autoSizeColumn(0);
			sheetDefault.autoSizeColumn(1);
			sheetDefault.autoSizeColumn(2);
			sheetValores.autoSizeColumn(0);
			sheetValores.autoSizeColumn(1);
			
			for (int numColuna = 0; numColuna < numColunaCarga; numColuna++) {
				sheetCarga.autoSizeColumn(numColuna);
			}
			
			try {
				FileOutputStream out = new FileOutputStream(new File(request.getSession().getServletContext().getRealPath("/pages/importarCargaPortfolioServico/modelo/modeloCargaPortfolioServico.xls")));
				workbook.write(out);
				out.close();
				
				document.executeScript("CargaPortfolioServico.downloadModeloCargaXls();");
				
			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				document.executeScript("JANELA_AGUARDE_MENU.hide();");
			}
		}
	}

	public void gerarModeloXlsx(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		CargaPortfolioServicoDTO cargaPortfolioServicoDTO = (CargaPortfolioServicoDTO) document.getBean();
		List<String> listCamposValoresPermitidos = new ArrayList<>();
		inicializaListaValoresPermitidos(request, listCamposValoresPermitidos);

		JSONArray jaCamposCarga = new JSONArray(cargaPortfolioServicoDTO.getJson());

		if (jaCamposCarga != null && jaCamposCarga.length() > 0) {
			Integer quantidadeRegistros = cargaPortfolioServicoDTO.getQuantidadeRegistros();
			List<Row> listRowsValorCarga = new ArrayList<>();

			String nomePlanilhaCarga = UtilI18N.internacionaliza(request, "cargaPortfolioServico.nomePlanilha.carga");
			String nomePlanilhaValoresDefault = UtilI18N.internacionaliza(request, "cargaPortfolioServico.nomePlanilha.valoresDefault");
			String nomePlanilhaValoresPossiveis = UtilI18N.internacionaliza(request, "cargaPortfolioServico.nomePlanilha.valoresPossiveis");
			
			XSSFWorkbook workbook = new XSSFWorkbook();
			XSSFSheet sheetCarga = workbook.createSheet(nomePlanilhaCarga);
			XSSFSheet sheetDefault = workbook.createSheet(nomePlanilhaValoresDefault);
			sheetDefault.protectSheet("sheetProtected" + Double.toHexString(Math.floor((1 + Math.random()) * 0x10000)));
			XSSFSheet sheetValores = workbook.createSheet(nomePlanilhaValoresPossiveis);
			sheetValores.protectSheet("sheetProtected" + Double.toHexString(Math.floor((1 + Math.random()) * 0x10000)));

			CreationHelper createHelper = workbook.getCreationHelper();

			Row rowHeadCarga = sheetCarga.createRow(0);

			CellStyle boldStyle = workbook.createCellStyle();
			Font boldFont = workbook.createFont();
			boldFont.setBoldweight(Font.BOLDWEIGHT_BOLD);
			boldStyle.setFont(boldFont);

			CellStyle hlinkStyle = workbook.createCellStyle();
			Font hlinkFont = workbook.createFont();
			hlinkFont.setUnderline(Font.U_SINGLE);
			hlinkFont.setColor(IndexedColors.BLUE.getIndex());
			hlinkStyle.setFont(hlinkFont);

			int numColunaCarga = 0;
			int numRowDefault = 0;
			int numRowValores = 0;

			if (quantidadeRegistros != null) {
				for (int indexRow = 1; indexRow <= quantidadeRegistros; indexRow++) {
					listRowsValorCarga.add(sheetCarga.createRow(indexRow));
				}
			}
			
			Row rowDefaultIdioma = sheetDefault.createRow(numRowDefault);
			Cell cellCampoDefaultIdioma = rowDefaultIdioma.createCell(0);
			cellCampoDefaultIdioma.setCellValue(UtilI18N.internacionaliza(request, "lingua.lingua"));
			cellCampoDefaultIdioma.setCellStyle(boldStyle);

			Cell cellValorDefaultIdioma = rowDefaultIdioma.createCell(1);
			cellValorDefaultIdioma.setCellValue(WebUtil.getLanguage(request));

			numRowDefault++;

			for (int index = 0, qtdCampos = jaCamposCarga.length(); index < qtdCampos; index++) {
				JSONObject joCampoCarga = jaCamposCarga.getJSONObject(index);

				if (joCampoCarga.getInt("tipoValor") != TipoValorImportacaoCarga.DEFAULT.getIdentificador().intValue()) {
					Cell cellNome = rowHeadCarga.createCell(numColunaCarga);
					cellNome.setCellValue(joCampoCarga.getString("nome"));
					cellNome.setCellStyle(boldStyle);
					
					if (joCampoCarga.getInt("tipoValor") == TipoValorImportacaoCarga.INFORMADO.getIdentificador().intValue()) {
						if (listRowsValorCarga != null) {
							for (Row rowValorCarga : listRowsValorCarga) {
								Cell cellValor = rowValorCarga.createCell(numColunaCarga);
								cellValor.setCellValue(joCampoCarga.getString("valor"));
							}
						}
					}

					if (listCamposValoresPermitidos != null && listCamposValoresPermitidos.contains(joCampoCarga.getString("nome"))) {
						Hyperlink linkValoresPermitidos = createHelper.createHyperlink(Hyperlink.LINK_DOCUMENT);
						linkValoresPermitidos.setAddress("'"+nomePlanilhaValoresPossiveis+"'!A" + (numRowValores + 1));
						cellNome.setHyperlink(linkValoresPermitidos);
						cellNome.setCellStyle(hlinkStyle);

						Row rowHeadValorPermitido = sheetValores.createRow(numRowValores);
						Cell cellHeadValorPermitido = rowHeadValorPermitido.createCell(0);
						cellHeadValorPermitido.setCellValue(joCampoCarga.getString("nome"));
						cellHeadValorPermitido.setCellStyle(boldStyle);
						CellRangeAddress cellRangeAddress = new CellRangeAddress(numRowValores, numRowValores, 0, 1);
						sheetValores.addMergedRegion(cellRangeAddress);
						numRowValores++;
						Row rowHead2ValorPermitido = sheetValores.createRow(numRowValores);
						Cell cellHead2ValorPermitido = rowHead2ValorPermitido.createCell(0);
						cellHead2ValorPermitido.setCellValue(UtilI18N.internacionaliza(request, "citcorpore.comum.valor"));
						cellHead2ValorPermitido.setCellStyle(boldStyle);
						Cell cellHead2DescValorPermitido = rowHead2ValorPermitido.createCell(1);
						cellHead2DescValorPermitido.setCellValue(UtilI18N.internacionaliza(request, "citcorpore.comum.descricao"));
						cellHead2DescValorPermitido.setCellStyle(boldStyle);
						numRowValores++;

						numRowValores = this.createRowValorPermitido(request, joCampoCarga.getString("nome"), sheetValores, numRowValores);
					}

					numColunaCarga++;
				} else {
					Row rowDefault = sheetDefault.createRow(numRowDefault);
					Cell cellCampoDefault = rowDefault.createCell(0);
					cellCampoDefault.setCellValue(joCampoCarga.getString("nome"));
					cellCampoDefault.setCellStyle(boldStyle);

					Cell cellValorDefault = rowDefault.createCell(1);
					cellValorDefault.setCellValue(joCampoCarga.getString("valor"));

					Cell cellDescValorDefault = rowDefault.createCell(2);
					cellDescValorDefault.setCellValue(UtilStrings.nullToVazio(joCampoCarga.getString("descValorDefault")));

					numRowDefault++;
				}
			}

			sheetDefault.autoSizeColumn(0);
			sheetDefault.autoSizeColumn(1);
			sheetDefault.autoSizeColumn(2);
			sheetValores.autoSizeColumn(0);
			sheetValores.autoSizeColumn(1);

			for (int numColuna = 0; numColuna < numColunaCarga; numColuna++) {
				sheetCarga.autoSizeColumn(numColuna);
			}

			try {
				FileOutputStream out = new FileOutputStream(new File(request.getSession().getServletContext().getRealPath("/pages/importarCargaPortfolioServico/modelo/modeloCargaPortfolioServico.xlsx")));
				workbook.write(out);
				out.close();

				document.executeScript("CargaPortfolioServico.downloadModeloCargaXlsx();");

			} catch (FileNotFoundException e) {
				e.printStackTrace();
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				document.executeScript("JANELA_AGUARDE_MENU.hide();");
			}
		}
	}

	private void inicializaListaValoresPermitidos(HttpServletRequest request, List<String> listCamposValoresPermitidos) {
		listCamposValoresPermitidos.add(UtilI18N.internacionaliza(request, "gerenciaportfolio.faseServico"));
		listCamposValoresPermitidos.add(UtilI18N.internacionaliza(request, "gerenciaportfolio.statusServico"));
		listCamposValoresPermitidos.add(UtilI18N.internacionaliza(request, "gerenciaportfolio.servicoNegocio.criticidadeServico"));
		listCamposValoresPermitidos.add(UtilI18N.internacionaliza(request, "gerenciaportfolio.tipoDeInvestimento"));
		listCamposValoresPermitidos.add(UtilI18N.internacionaliza(request, "gerenciaportfolio.classificacao.demandaServico"));
		listCamposValoresPermitidos.add(UtilI18N.internacionaliza(request, "gerenciaportfolio.classificacao.retornoFinanceiroServico"));
		listCamposValoresPermitidos.add(UtilI18N.internacionaliza(request, "cargaPortfolioServico.situacaoServicoIncidenteRequisicao"));
		listCamposValoresPermitidos.add(UtilI18N.internacionaliza(request, "gerenciaportfolio.tipoDemandaServico"));
		listCamposValoresPermitidos.add(UtilI18N.internacionaliza(request, "gerenciaportfolio.dispPortal"));
	}
	
	private Integer createRowValorPermitido(HttpServletRequest request, String campo, HSSFSheet sheetValores, Integer numRow) {
		if (!UtilStrings.isNullOrEmpty(campo)) {
			
			if (campo.equals(UtilI18N.internacionaliza(request, "gerenciaportfolio.faseServico"))) {
				for (FaseServico faseServico : FaseServico.values()) {
					Row rowValorPermitido = sheetValores.createRow(numRow);
					rowValorPermitido.createCell(0).setCellValue(faseServico.getIdentificador());
					rowValorPermitido.createCell(1).setCellValue(UtilI18N.internacionaliza(request, faseServico.getChave()));
					numRow++;
				}
				numRow++;
			}
			
			if (campo.equals(UtilI18N.internacionaliza(request, "gerenciaportfolio.statusServico"))) {
				for (StatusServico statusServico : StatusServico.values()) {
					Row rowValorPermitido = sheetValores.createRow(numRow);
					rowValorPermitido.createCell(0).setCellValue(statusServico.getIdentificador());
					rowValorPermitido.createCell(1).setCellValue(UtilI18N.internacionaliza(request, statusServico.getChave()));
					numRow++;
				}
				numRow++;
			}
			
			if (campo.equals(UtilI18N.internacionaliza(request, "gerenciaportfolio.servicoNegocio.criticidadeServico"))) {
				for (CriticidadeServico criticidadeServico : CriticidadeServico.values()) {
					Row rowValorPermitido = sheetValores.createRow(numRow);
					rowValorPermitido.createCell(0).setCellValue(criticidadeServico.getIdentificador());
					rowValorPermitido.createCell(1).setCellValue(UtilI18N.internacionaliza(request, criticidadeServico.getChave()));
					numRow++;
				}
				numRow++;
			}
			
			if (campo.equals(UtilI18N.internacionaliza(request, "gerenciaportfolio.tipoDeInvestimento"))) {
				for (TipoDeInvestimento tipoDeInvestimento : TipoDeInvestimento.values()) {
					Row rowValorPermitido = sheetValores.createRow(numRow);
					rowValorPermitido.createCell(0).setCellValue(tipoDeInvestimento.getIdentificador());
					rowValorPermitido.createCell(1).setCellValue(UtilI18N.internacionaliza(request, tipoDeInvestimento.getChave()));
					numRow++;
				}
				numRow++;
			}
			
			if (campo.equals(UtilI18N.internacionaliza(request, "gerenciaportfolio.classificacao.demandaServico"))) {
				for (DemandaServicoNegocio demandaServicoNegocio : DemandaServicoNegocio.values()) {
					Row rowValorPermitido = sheetValores.createRow(numRow);
					rowValorPermitido.createCell(0).setCellValue(demandaServicoNegocio.getIdentificador());
					rowValorPermitido.createCell(1).setCellValue(UtilI18N.internacionaliza(request, demandaServicoNegocio.getChave()));
					numRow++;
				}
				numRow++;
			}
			
			if (campo.equals(UtilI18N.internacionaliza(request, "gerenciaportfolio.classificacao.retornoFinanceiroServico"))) {
				for (RetornoFinanceiroServico retornoFinanceiroServico : RetornoFinanceiroServico.values()) {
					Row rowValorPermitido = sheetValores.createRow(numRow);
					rowValorPermitido.createCell(0).setCellValue(retornoFinanceiroServico.getIdentificador());
					rowValorPermitido.createCell(1).setCellValue(UtilI18N.internacionaliza(request, retornoFinanceiroServico.getChave()));
					numRow++;
				}
				numRow++;
			}
			
			if (campo.equals(UtilI18N.internacionaliza(request, "cargaPortfolioServico.situacaoServicoIncidenteRequisicao"))) {
				for (ServiceSituation serviceSituation : ServiceSituation.values()) {
					Row rowValorPermitido = sheetValores.createRow(numRow);
					rowValorPermitido.createCell(0).setCellValue(serviceSituation.getId());
					rowValorPermitido.createCell(1).setCellValue(UtilI18N.internacionaliza(request, serviceSituation.getI18NKey()));
					numRow++;
				}
				
				numRow++;
			}
			
			if (campo.equals(UtilI18N.internacionaliza(request, "gerenciaportfolio.tipoDemandaServico"))) {
				for (ServiceDemandType serviceDemandType : ServiceDemandType.valuesWithoutOSAndProcedure()) {
					Row rowValorPermitido = sheetValores.createRow(numRow);
					rowValorPermitido.createCell(0).setCellValue(serviceDemandType.getId());
					rowValorPermitido.createCell(1).setCellValue(UtilI18N.internacionaliza(request, serviceDemandType.getI18NKey()));
					numRow++;
				}
				
				numRow++;
			}
			
			if (campo.equals(UtilI18N.internacionaliza(request, "gerenciaportfolio.dispPortal"))) {
				Row rowValorPermitido1 = sheetValores.createRow(numRow);
				rowValorPermitido1.createCell(0).setCellValue(SimNao.NAO.getValorStr());
				rowValorPermitido1.createCell(1).setCellValue(UtilI18N.internacionaliza(request, SimNao.NAO.getChave()));
				numRow++;
				
				Row rowValorPermitido2 = sheetValores.createRow(numRow);
				rowValorPermitido2.createCell(0).setCellValue(SimNao.SIM.getValorStr());
				rowValorPermitido2.createCell(1).setCellValue(UtilI18N.internacionaliza(request, SimNao.SIM.getChave()));
				numRow++;
				
				numRow++;
			}
		}
		
		return numRow;
	}

	private Integer createRowValorPermitido(HttpServletRequest request, String campo, XSSFSheet sheetValores, Integer numRow) {
		if (!UtilStrings.isNullOrEmpty(campo)) {

			if (campo.equals(UtilI18N.internacionaliza(request, "gerenciaportfolio.faseServico"))) {
				for (FaseServico faseServico : FaseServico.values()) {
					Row rowValorPermitido = sheetValores.createRow(numRow);
					rowValorPermitido.createCell(0).setCellValue(faseServico.getIdentificador());
					rowValorPermitido.createCell(1).setCellValue(UtilI18N.internacionaliza(request, faseServico.getChave()));
					numRow++;
				}
				numRow++;
			}

			if (campo.equals(UtilI18N.internacionaliza(request, "gerenciaportfolio.statusServico"))) {
				for (StatusServico statusServico : StatusServico.values()) {
					Row rowValorPermitido = sheetValores.createRow(numRow);
					rowValorPermitido.createCell(0).setCellValue(statusServico.getIdentificador());
					rowValorPermitido.createCell(1).setCellValue(UtilI18N.internacionaliza(request, statusServico.getChave()));
					numRow++;
				}
				numRow++;
			}

			if (campo.equals(UtilI18N.internacionaliza(request, "gerenciaportfolio.tipoDeInvestimento"))) {
				for (TipoDeInvestimento tipoDeInvestimento : TipoDeInvestimento.values()) {
					Row rowValorPermitido = sheetValores.createRow(numRow);
					rowValorPermitido.createCell(0).setCellValue(tipoDeInvestimento.getIdentificador());
					rowValorPermitido.createCell(1).setCellValue(UtilI18N.internacionaliza(request, tipoDeInvestimento.getChave()));
					numRow++;
				}
				numRow++;
			}

			if (campo.equals(UtilI18N.internacionaliza(request, "gerenciaportfolio.classificacao.demandaServico"))) {
				for (DemandaServicoNegocio demandaServicoNegocio : DemandaServicoNegocio.values()) {
					Row rowValorPermitido = sheetValores.createRow(numRow);
					rowValorPermitido.createCell(0).setCellValue(demandaServicoNegocio.getIdentificador());
					rowValorPermitido.createCell(1).setCellValue(UtilI18N.internacionaliza(request, demandaServicoNegocio.getChave()));
					numRow++;
				}
				numRow++;
			}

			if (campo.equals(UtilI18N.internacionaliza(request, "gerenciaportfolio.classificacao.retornoFinanceiroServico"))) {
				for (RetornoFinanceiroServico retornoFinanceiroServico : RetornoFinanceiroServico.values()) {
					Row rowValorPermitido = sheetValores.createRow(numRow);
					rowValorPermitido.createCell(0).setCellValue(retornoFinanceiroServico.getIdentificador());
					rowValorPermitido.createCell(1).setCellValue(UtilI18N.internacionaliza(request, retornoFinanceiroServico.getChave()));
					numRow++;
				}
				numRow++;
			}
			
			if (campo.equals(UtilI18N.internacionaliza(request, "cargaPortfolioServico.situacaoServicoIncidenteRequisicao"))) {
				for (ServiceSituation serviceSituation : ServiceSituation.values()) {
					Row rowValorPermitido = sheetValores.createRow(numRow);
					rowValorPermitido.createCell(0).setCellValue(serviceSituation.getId());
					rowValorPermitido.createCell(1).setCellValue(UtilI18N.internacionaliza(request, serviceSituation.getI18NKey()));
					numRow++;
				}
				
				numRow++;
			}

			if (campo.equals(UtilI18N.internacionaliza(request, "gerenciaportfolio.tipoDemandaServico"))) {
				Row rowValorPermitido1 = sheetValores.createRow(numRow);
				rowValorPermitido1.createCell(0).setCellValue(ServiceDemandType.REQUEST.getId().toString());
				rowValorPermitido1.createCell(1).setCellValue(UtilI18N.internacionaliza(request, ServiceDemandType.REQUEST.getI18NKey()));
				numRow++;

				Row rowValorPermitido2 = sheetValores.createRow(numRow);
				rowValorPermitido2.createCell(0).setCellValue(ServiceDemandType.INCIDENT.getId().toString());
				rowValorPermitido2.createCell(1).setCellValue(UtilI18N.internacionaliza(request, ServiceDemandType.INCIDENT.getI18NKey()));
				numRow++;

				numRow++;
			}

			if (campo.equals(UtilI18N.internacionaliza(request, "gerenciaportfolio.dispPortal"))) {
				Row rowValorPermitido1 = sheetValores.createRow(numRow);
				rowValorPermitido1.createCell(0).setCellValue(SimNao.NAO.getValorStr());
				rowValorPermitido1.createCell(1).setCellValue(UtilI18N.internacionaliza(request, SimNao.NAO.getChave()));
				numRow++;

				Row rowValorPermitido2 = sheetValores.createRow(numRow);
				rowValorPermitido2.createCell(0).setCellValue(SimNao.SIM.getValorStr());
				rowValorPermitido2.createCell(1).setCellValue(UtilI18N.internacionaliza(request, SimNao.SIM.getChave()));
				numRow++;

				numRow++;
			}
		}

		return numRow;
	}

	private ImportarCargaPortfolioServicoService getImportarCargaPortfolioServicoService() throws ServiceException {
		if (importarCargaPortfolioServicoService == null) {
			importarCargaPortfolioServicoService = (ImportarCargaPortfolioServicoService) ServiceLocator.getInstance().getService(ImportarCargaPortfolioServicoService.class, null);
		}
		return importarCargaPortfolioServicoService;
	}

	private ServicoService getServicoService() throws ServiceException {
		if (servicoService == null) {
			servicoService = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);
		}
		return servicoService;
	}

	private ModeloEmailService getModeloEmailService() throws ServiceException {
		if (modeloEmailService == null) {
			modeloEmailService = (ModeloEmailService) ServiceLocator.getInstance().getService(ModeloEmailService.class, null);
		}
		return modeloEmailService;
	}

	private CalendarioService getCalendarioService() throws ServiceException {
		if (calendarioService == null) {
			calendarioService = (CalendarioService) ServiceLocator.getInstance().getService(CalendarioService.class, null);
		}
		return calendarioService;
	}

	private GrupoService getGrupoService() throws ServiceException {
		if (grupoService == null) {
			grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		}
		return grupoService;
	}

	private CondicaoOperacaoService getCondicaoOperacaoService() throws ServiceException {
		if (condicaoOperacaoService == null) {
			condicaoOperacaoService = (CondicaoOperacaoService) ServiceLocator.getInstance().getService(CondicaoOperacaoService.class, null);
		}
		return condicaoOperacaoService;
	}

	private FluxoService getFluxoService() throws ServiceException {
		if (fluxoService == null) {
			fluxoService = (FluxoService) ServiceLocator.getInstance().getService(FluxoService.class, null);
		}
		return fluxoService;
	}

	private FaseServicoService getFaseServicoService() throws ServiceException {
		if (faseServicoService == null) {
			faseServicoService = (FaseServicoService) ServiceLocator.getInstance().getService(FaseServicoService.class, null);
		}
		return faseServicoService;
	}

	@Override
	public Class<CargaPortfolioServicoDTO> getBeanClass() {
		return CargaPortfolioServicoDTO.class;
	}
}
