/**
 * CentralIT - CITSmart
 */
package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.CategoriaServicoDTO;
import br.com.centralit.citcorpore.negocio.CategoriaServicoService;
import br.com.centralit.citcorpore.util.Enumerados.TipoCategoria;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;

public class CategoriaServico extends AjaxFormAction {

	private CategoriaServicoService categoriaServicoService;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		carregaComboTipoCategoria(document, request, response);
	}

	/**
	 * De acordo com os requisitos do Gerenciamento de Portflio, a categoria ser
	 * classificada em tipos, definidos no enum citado abaixo.
	 *
	 * @see br.com.centralit.citcorpore.util.Enumerados.TipoCategoria
	 * @since 16/09/2015
	 * @author douglas.japiassu
	 */
	public void carregaComboTipoCategoria(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("tipoCategoria");
		combo.removeAllOptions();
		combo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		for (TipoCategoria tipoCategoria : TipoCategoria.values()) {
			combo.addOption(tipoCategoria.getIdentificador(), UtilI18N.internacionaliza(request, tipoCategoria.getChave()));
		}
	}

	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		CategoriaServicoDTO categoriaServicoDTO = (CategoriaServicoDTO) document.getBean();
		categoriaServicoDTO.setIdEmpresa(WebUtil.getIdEmpresa(request));

		if (categoriaServicoDTO.getIdCategoriaServico() == null) {
			categoriaServicoDTO.setDataInicio(UtilDatas.getDataAtual());
			categoriaServicoDTO.setIdEmpresa(WebUtil.getIdEmpresa(request));

			if (!getCategoriaServicoService().verificarSeCategoriaExiste(categoriaServicoDTO)) {

				if (categoriaServicoDTO.getIdCategoriaServicoPai() != null) {
					Integer idCategoriaServico = 0;
					idCategoriaServico = categoriaServicoDTO.getIdCategoriaServicoPai();
					if (categoriaServicoDTO.getIdCategoriaServico() != null) {
						if (categoriaServicoDTO.getIdCategoriaServico() == idCategoriaServico.intValue()) {
							document.alert(UtilI18N.internacionaliza(request, "categoriaServico.registroPaiIgual"));
							return;
						}
					}
				}

				String nomeConcatenado = categoriaServicoDTO.getNomeCategoriaServicoConcatenado() + categoriaServicoDTO.getNomeCategoriaServico();
				categoriaServicoDTO.setNomeCategoriaServicoConcatenado(nomeConcatenado);
				getCategoriaServicoService().create(categoriaServicoDTO);
				document.alert(UtilI18N.internacionaliza(request, "MSG05"));
			} else {
				document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.registroJaCadastrado"));
			}
		} else {
			if (categoriaServicoDTO.getIdCategoriaServicoPai() != null) {
				Integer idCategoriaServico = 0;
				idCategoriaServico = categoriaServicoDTO.getIdCategoriaServicoPai();
				if (categoriaServicoDTO.getIdCategoriaServico() == idCategoriaServico.intValue()) {
					document.alert(UtilI18N.internacionaliza(request, "categoriaServico.registroPaiIgual"));
					return;
				}

				List<CategoriaServicoDTO> listCategoriaHierarquia = new ArrayList<CategoriaServicoDTO>();
				CategoriaServicoDTO beanCategoriaServico = new CategoriaServicoDTO();
				beanCategoriaServico.setIdCategoriaServico(categoriaServicoDTO.getIdCategoriaServicoPai());
				beanCategoriaServico = (CategoriaServicoDTO) getCategoriaServicoService().restore(beanCategoriaServico);
				getCategoriaServicoService().listCategoriaHierarquia(beanCategoriaServico, listCategoriaHierarquia);
				categoriaServicoDTO.setNomeCategoriaServicoConcatenado(this.nomeConcatenado(listCategoriaHierarquia) + categoriaServicoDTO.getNomeCategoriaServico());
			} else {
				categoriaServicoDTO.setNomeCategoriaServicoConcatenado(categoriaServicoDTO.getNomeCategoriaServico());
			}

			categoriaServicoDTO.setIdEmpresa(WebUtil.getIdEmpresa(request));
			getCategoriaServicoService().update(categoriaServicoDTO);
			document.alert(UtilI18N.internacionaliza(request, "MSG06"));
		}

		HTMLForm form = document.getForm("formCategoriaServico");
		form.clear();
		document.executeScript("limpar_LOOKUP_CATEGORIASERVICO()");
		document.setBean(new CategoriaServicoDTO());
	}

	public void excluir(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		CategoriaServicoDTO categoriaServico = (CategoriaServicoDTO) document.getBean();

		if (categoriaServico != null && categoriaServico.getIdCategoriaServico() != null) {
			if (getCategoriaServicoService().verificarSeCategoriaPossuiServicoOuSubCategoria(categoriaServico)) {
				document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.registroNaoPodeSerExcluido"));
			} else {
				categoriaServico.setIdEmpresa(WebUtil.getIdEmpresa(request));
				categoriaServico.setDataFim(UtilDatas.getDataAtual());
				getCategoriaServicoService().update(categoriaServico);
				document.alert(UtilI18N.internacionaliza(request, "MSG07"));
			}

		}
		HTMLForm form = document.getForm("formCategoriaServico");
		form.clear();
		document.executeScript("limpar_LOOKUP_CATEGORIASERVICO()");
	}



	/**
	 * Verificar se existe Hierarquia.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void verificaHierarquia(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		CategoriaServicoDTO categoriaServicoDTO = (CategoriaServicoDTO) document.getBean();
		List<CategoriaServicoDTO> listCategoriaHierarquia = new ArrayList<CategoriaServicoDTO>();

		CategoriaServicoDTO beanCategoriaServico = new CategoriaServicoDTO();
		beanCategoriaServico.setIdCategoriaServico(categoriaServicoDTO.getIdCategoriaServicoPai());
		beanCategoriaServico = (CategoriaServicoDTO) getCategoriaServicoService().restore(beanCategoriaServico);
		getCategoriaServicoService().listCategoriaHierarquia(beanCategoriaServico, listCategoriaHierarquia);

		document.getElementById("nomeCategoriaServicoConcatenado").setValue(this.nomeConcatenado(listCategoriaHierarquia));
	}

	private String nomeConcatenado(List<CategoriaServicoDTO> listCategoriaHierarquia) {
		String nomeConcatenado = "";

		for (int i = listCategoriaHierarquia.size() - 1; i >= 0; i--) {
			CategoriaServicoDTO categoriaServicoDTO = listCategoriaHierarquia.get(i);
			nomeConcatenado += categoriaServicoDTO.getNomeCategoriaServico() + " - ";
		}

		return nomeConcatenado;
	}

	/**
	 * Restaura os dados ao clicar em um registro.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		CategoriaServicoDTO categoriaServicoDTO = (CategoriaServicoDTO) document.getBean();
		categoriaServicoDTO = (CategoriaServicoDTO) getCategoriaServicoService().restore(categoriaServicoDTO);

		CategoriaServicoDTO categoriaServicoSuperior = new CategoriaServicoDTO();

		if(categoriaServicoDTO.getIdCategoriaServicoPai() != null){
			categoriaServicoSuperior.setIdCategoriaServico(categoriaServicoDTO.getIdCategoriaServicoPai());
			categoriaServicoSuperior = (CategoriaServicoDTO) getCategoriaServicoService().restore(categoriaServicoSuperior);
			if(categoriaServicoSuperior != null){
				categoriaServicoDTO.setNomeCategoriaServicoPai(categoriaServicoSuperior.getNomeCategoriaServico());
			}
		}
		
		HTMLForm form = document.getForm("formCategoriaServico");
		form.clear();
		form.setValues(categoriaServicoDTO);
	}

	public void setaCategoriaNegocio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("tipoCategoria");
		combo.removeAllOptions();
		combo.addOption(TipoCategoria.CATEGORIA_NEGOCIO.getIdentificador(), UtilI18N.internacionaliza(request, TipoCategoria.CATEGORIA_NEGOCIO.getChave()));
	}

	public void setaCategoriaApoio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("tipoCategoria");
		combo.removeAllOptions();
		combo.addOption(TipoCategoria.CATEGORIA_APOIO.getIdentificador(), UtilI18N.internacionaliza(request, TipoCategoria.CATEGORIA_APOIO.getChave()));
	}

	public void setaCategoriaIncidenteRequisicao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("tipoCategoria");
		combo.removeAllOptions();
		combo.addOption(TipoCategoria.CATEGORIA_INCIDENTE_REQUISICAO.getIdentificador(), UtilI18N.internacionaliza(request, TipoCategoria.CATEGORIA_INCIDENTE_REQUISICAO.getChave()));
	}
	
	public void setaCategoriaProcedimento(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("tipoCategoria");
		combo.removeAllOptions();
		combo.addOption(TipoCategoria.CATEGORIA_PROCEDIMENTO.getIdentificador(), UtilI18N.internacionaliza(request, TipoCategoria.CATEGORIA_PROCEDIMENTO.getChave()));
	}
	
	@Override
	public Class<CategoriaServicoDTO> getBeanClass() {
		return CategoriaServicoDTO.class;
	}

	private CategoriaServicoService getCategoriaServicoService() throws ServiceException {
		if (categoriaServicoService == null) {
			categoriaServicoService = (CategoriaServicoService) ServiceLocator.getInstance().getService(CategoriaServicoService.class, null);
		}

		return categoriaServicoService;
	}

}
