package br.com.centralit.citcorpore.ajaxForms;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citcorpore.bean.ClienteDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.ClienteService;
import br.com.centralit.citcorpore.negocio.ContratoService;
import br.com.centralit.citcorpore.util.Enumerados.SituacaoAtivoInativo;
import br.com.centralit.citcorpore.util.Enumerados.TipoCliente;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilI18N;

/**
 * @author ibimon.morais
 */
public class Cliente extends AjaxFormAction {

	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}
		document.executeScript("$('#cpfCnpj').unmask()");
		document.focusInFirstActivateField(null);
	}

	/**
	 * 
	 * br.com.centralit.citcorpore.ajaxForms.Cliente.java_(#Cliente_onsave)
	 *
	 * @since 30/10/2015
	 * @author ibimon.morais
	 */
	public void save(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final ClienteDTO cliente = (ClienteDTO) document.getBean();
		final ClienteService clienteService = (ClienteService) ServiceLocator.getInstance().getService(ClienteService.class, null);
		// Tratando a mascara de CNPJ e CPF
		cliente.setCpfCnpj((StringUtils.isNotBlank(cliente.getCpfCnpj()) ? Util.retiraMascara(cliente.getCpfCnpj()) : null));
		// Tratar tipo e situacao cliente nao informado
		tratarCheckSituacaoClienteNaoSalvo(cliente);
		tratarCheckTipoClienteAindaNaoSalvo(cliente);

		// Executando a acao salvar
		if (this.executarRecursoSave(cliente, clienteService, document, request)) {
			final HTMLForm form = document.getForm("formCadastroCliente");
			form.clear();
			document.alert(UtilI18N.internacionaliza(request, "MSG05"));
			document.executeScript("limparCliente();");
		}
	}

	/**
	 * projeto-missao_novo_paradigma - Cliente.java_(#tratarCheckTipoClienteAindaNaoSalvo).
	 *
	 * @since 10/11/2015
	 * @author ibimon.morais
	 */
	private void tratarCheckTipoClienteAindaNaoSalvo(final ClienteDTO cliente) {
		if (cliente.getIdCliente() == null && StringUtils.isBlank(cliente.getSituacao())) {
			cliente.setSituacao(SituacaoAtivoInativo.ATIVO.getIdentificador());
		}
	}

	/**
	 * projeto-missao_novo_paradigma - Cliente.java_(#tratarCheckSituacaoClienteNaoSalvo).
	 *
	 * @since 10/11/2015
	 * @author ibimon.morais
	 */
	private void tratarCheckSituacaoClienteNaoSalvo(final ClienteDTO cliente) {
		if (cliente.getIdCliente() == null && StringUtils.isBlank(cliente.getTipoCliente())) {
			cliente.setTipoCliente(TipoCliente.INTERNO.getIdentificador());
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.Cliente.java_(# tratarCpfCnpjParaSalvar)
	 *
	 * @since 04/11/2015
	 * @author ibimon.morais
	 * @throws PersistenceException
	 */
	private boolean executarRecursoSave(final ClienteDTO cliente, final ClienteService clienteService, final DocumentHTML document, final HttpServletRequest request)
			throws LogicException, ServiceException, PersistenceException {
		if (cliente.getIdCliente() == null && clienteService.verificarSeRazaoSocialJaCadastrada(cliente)) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.registroJaCadastrado"));
			return Boolean.FALSE;
		}
		if (cliente.getIdCliente() == null || cliente.getIdCliente().intValue() == 0) {
			clienteService.create(cliente);
		} else {
			clienteService.update(cliente);
		}
		return Boolean.TRUE;
	}

	/**
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void restore(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		ClienteDTO cliente = (ClienteDTO) document.getBean();
		final ClienteService clienteService = (ClienteService) ServiceLocator.getInstance().getService(ClienteService.class, null);

		cliente = (ClienteDTO) clienteService.restore(cliente);

		final HTMLForm form = document.getForm("formCadastroCliente");
		this.definirCheckSituacao(document, cliente);
		this.definirCheckTipoCliente(document, cliente);
		this.definirEntradaCPFCNPJ(document, cliente);
		form.setValues(cliente);
		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.Cliente.java_(# definirCheckTipoCliente)
	 *
	 * @since 04/11/2015
	 * @author ibimon.morais
	 */
	private void definirCheckTipoCliente(final DocumentHTML document, final ClienteDTO cliente) {
		if (TipoCliente.INTERNO.getIdentificador().equalsIgnoreCase(cliente.getTipoCliente())) {
			document.executeScript("$('input[name=tipoCliente][value=I').attr('checked', 'checked')");
			document.executeScript("$('input[name=tipoCliente][value=I]').closest('span').addClass('checked', 'checked')");
			document.executeScript("$('input[name=tipoCliente][value=E]').attr('checked', '')");
			document.executeScript("$('input[name=tipoCliente][value=E]').closest('span').removeClass('checked')");
			
		} else if (TipoCliente.EXTERNO.getIdentificador().equalsIgnoreCase(cliente.getTipoCliente())) {
			document.executeScript("$('input[name=tipoCliente][value=E').attr('checked', 'checked')");
			document.executeScript("$('input[name=tipoCliente][value=E]').closest('span').addClass('checked', 'checked')");
			document.executeScript("$('input[name=tipoCliente][value=I]').attr('checked', '')");
			document.executeScript("$('input[name=tipoCliente][value=I]').closest('span').removeClass('checked')");
			
		} else {
			document.executeScript("$('input[name=tipoCliente][value=E').attr('checked', '')");
			document.executeScript("$('input[name=tipoCliente][value=E]').closest('span').removeClass('checked')");
			document.executeScript("$('input[name=tipoCliente][value=I]').attr('checked', '')");
			document.executeScript("$('input[name=tipoCliente][value=I]').closest('span').removeClass('checked')");
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.Cliente.java_(#definirCheckSituacao )
	 *
	 * @since 04/11/2015
	 * @author ibimon.morais
	 */
	private void definirCheckSituacao(final DocumentHTML document, final ClienteDTO cliente) {
		if (cliente.getSituacao().equals(SituacaoAtivoInativo.ATIVO.getIdentificador())) {
			document.executeScript("$('input[name=situacao][value=A]').attr('checked', 'checked')");
			document.executeScript("$('input[name=situacao][value=I]').attr('checked', false)");
		} else {
			document.executeScript("$('input[name=situacao][value=I]').attr('checked', 'checked')");
			document.executeScript("$('input[name=situacao][value=A]').attr('checked', false)");
		}
	}

	/**
	 * br.com.centralit.citcorpore.ajaxForms.Cliente.java_(# definirEntradaCPFCNPJ)
	 *
	 * @since 03/11/2015
	 * @author ibimon.morais
	 */
	private void definirEntradaCPFCNPJ(final DocumentHTML document, final ClienteDTO cliente) {
		String mascara = "";
		// Retirando a mscara antiga.
		if (cliente == null || StringUtils.isBlank(cliente.getCpfCnpj())) {
			return;
		}

		if (cliente.getCpfCnpj().length() < 11) {
			document.executeScript("$('#cpfCnpj').unmask()");
			return;
		} else if (cliente.getCpfCnpj().length() == 11) {
			mascara = "999.999.999-99";
		} else if (cliente.getCpfCnpj().length() > 11) {
			mascara = "99.999.999/9999-99";
		}
		// Aplicando a nova mscara ao campo.
		document.executeScript("$('#cpfCnpj').mask(\"" + mascara + "\")");
	}

	/**
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void excluir(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		ClienteDTO cliente = (ClienteDTO) document.getBean();
		
		final ContratoService contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		final ClienteService clienteService = (ClienteService) ServiceLocator.getInstance().getService(ClienteService.class, null);
		if(contratoService.findByIdCliente(cliente.getIdCliente()) == null){
			cliente = (ClienteDTO) clienteService.restore(cliente);
			cliente.setDeleted("S");
			clienteService.update(cliente);
			document.alert(UtilI18N.internacionaliza(request, "MSG07"));
			final HTMLForm form = document.getForm("formCadastroCliente");
			form.clear();
		}else{
			document.alert(UtilI18N.internacionaliza(request, "cliente.clienteVinculadoContrato"));
		}
		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	@Override
	public Class<ClienteDTO> getBeanClass() {
		return ClienteDTO.class;
	}
}
