package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Arrays;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.GerenciaConfiguracaoParametrosDTO;
import br.com.centralit.citcorpore.bean.ParametroCorporeDTO;
import br.com.centralit.citcorpore.negocio.ParametroCorporeService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;

/**
 * Altera os parmetros relacionados a base de conhecimento.
 *
 * @author joao.morais
 * @since 30.03.2016
 */

public class ConfiguracaoGerenciamentoBaseConhecimento extends AjaxFormAction {

	private ParametroCorporeService parametroCorporeService;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		ArrayList<Enumerados.ParametroSistema> listParametros = new ArrayList<Enumerados.ParametroSistema>(
				Arrays.asList(
						Enumerados.ParametroSistema.AVISAR_DATAEXPIRACAO_BASECONHECIMENTO,
						Enumerados.ParametroSistema.ID_CALENDARIO_PADRAO,
						Enumerados.ParametroSistema.ID_MODELO_EMAIL_AVISAR_CRIACAO_PASTA,
						Enumerados.ParametroSistema.ID_MODELO_EMAIL_AVISAR_CRIACAO_CONHECIMENTO,
						Enumerados.ParametroSistema.ID_MODELO_EMAIL_AVISAR_ATUALIZACAO_CONHECIMENTO,
						Enumerados.ParametroSistema.ID_MODELO_EMAIL_AVISAR_EXCLUSAO_CONHECIMENTO,
						Enumerados.ParametroSistema.ID_MODELO_EMAIL_AVISAR_EXCLUSAO_PASTA,
						Enumerados.ParametroSistema.ID_MODELO_EMAIL_AVISAR_ATUALIZACAO_PASTA,
						Enumerados.ParametroSistema.LUCENE_DIR_BASECONHECIMENTO,
						Enumerados.ParametroSistema.LUCENE_DIR_ANEXOBASECONHECIMENTO,
						Enumerados.ParametroSistema.LUCENE_REFAZER_INDICES,
						Enumerados.ParametroSistema.LUCENE_DIR_PALAVRAGEMEA,
						Enumerados.ParametroSistema.PASTA_SALVA_DESCRICAO_RESPOSTA_DE_SOLICITACAOSERVICO_EM_BASECONHECIMENTO,
						Enumerados.ParametroSistema.PASTA_PADRAO_CONHECIMENTOS_OCORRENCIAS_EVENTOS,
						Enumerados.ParametroSistema.MOSTRAR_GRAVAR_BASE_CONHECIMENTO,
						Enumerados.ParametroSistema.VALIDAR_BOTOES

				)
		);

		for(Enumerados.ParametroSistema parametro : listParametros){
			StringBuilder sb = new StringBuilder();

			sb.append("addLinhaTabelaAtributosConfiguracaoGerenciamentoBaseConhecimento(");
			sb.append(parametro.id());
			sb.append(",'");

			if(parametro.getCampoParametroInternacionalizado(request).contains("\\")){
				sb.append(parametro.getCampoParametroInternacionalizado(request).replace("\\", "\\\\"));
			}else{
				sb.append(StringUtils.replace(parametro.getCampoParametroInternacionalizado(request), "'", "\\'"));
			}
			sb.append("','");
			sb.append(StringEscapeUtils.escapeJavaScript(StringUtils.replace(ParametroUtil.getValorParametroCitSmartHashMap(parametro, ""), "'", "\\'")));
			sb.append("', '");
			sb.append(parametro.tipoCampo());
			sb.append("')");

			document.executeScript(sb.toString());
		}

		document.executeScript("renderiza()");

	}

	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciaConfiguracaoParametrosDTO gerenciaConfiguracaoParametrosDTO = (GerenciaConfiguracaoParametrosDTO) document.getBean();

		gerenciaConfiguracaoParametrosDTO
				.setListConfiguracaoParametrosDTO(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(GerenciaConfiguracaoParametrosDTO.class, "listConfiguracaoParametroSerializado", request));
		ParametroCorporeService parametroCorporeService = (ParametroCorporeService) ServiceLocator.getInstance().getService(ParametroCorporeService.class, null);

		if (gerenciaConfiguracaoParametrosDTO.getListConfiguracaoParametroDTO() != null && !gerenciaConfiguracaoParametrosDTO.getListConfiguracaoParametroDTO().isEmpty()) {
			String[] totalParametros = null;
			for (GerenciaConfiguracaoParametrosDTO configuracaoParametrosDTO : gerenciaConfiguracaoParametrosDTO.getListConfiguracaoParametroDTO()) {
				ParametroCorporeDTO parametroCorporeDto = new ParametroCorporeDTO();

				parametroCorporeDto.setId(Integer.parseInt(configuracaoParametrosDTO.getId().trim()));

				parametroCorporeDto = (ParametroCorporeDTO) parametroCorporeService.restore(parametroCorporeDto);
				/*
				 * Se o parmetro for do tipo boolean, faz a converso para o
				 * valor correto
				 */
				if (parametroCorporeDto.getTipoDado() != null && parametroCorporeDto.getTipoDado().equalsIgnoreCase("Boolean")) {
					parametroCorporeDto.setValor(Internacionalizar.internacionalizaOptionSN(request, "save", configuracaoParametrosDTO.getValorAtributoConfiguracaoParametro()));
				} else {
					parametroCorporeDto.setValor(configuracaoParametrosDTO.getValorAtributoConfiguracaoParametro().trim());
				}

				parametroCorporeService.atualizarParametros(parametroCorporeDto);

			}

			document.executeScript("notificacaoI18N('MSG06');");
		}
	}

	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciaConfiguracaoParametrosDTO gerenciaConfiguracaoParametrosDTO = (GerenciaConfiguracaoParametrosDTO) document.getBean();

	}

	public void excluir(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciaConfiguracaoParametrosDTO gerenciaConfiguracaoParametrosDTO = (GerenciaConfiguracaoParametrosDTO) document.getBean();

	}

	public ParametroCorporeService getParametroCorporeService() throws ServiceException {
		if (parametroCorporeService == null) {
			parametroCorporeService = (ParametroCorporeService) ServiceLocator.getInstance().getService(ParametroCorporeService.class, null);
		}
		return parametroCorporeService;
	}

	@Override
	public Class<GerenciaConfiguracaoParametrosDTO> getBeanClass() {
		return GerenciaConfiguracaoParametrosDTO.class;
	}

}
