package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Arrays;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.GerenciaConfiguracaoParametrosDTO;
import br.com.centralit.citcorpore.bean.ParametroCorporeDTO;
import br.com.centralit.citcorpore.negocio.ParametroCorporeService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.citframework.service.ServiceLocator;

public class ConfiguracaoGerenciamentoIncidenteRequisicoes extends AjaxFormAction {
	private GerenciaConfiguracaoParametrosDTO gerenciaConfiguracaoParametrosDTO;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		ArrayList<Enumerados.ParametroSistema> listParametros = new ArrayList<Enumerados.ParametroSistema>(
			Arrays.asList(
					Enumerados.ParametroSistema.ID_GRUPO_PADRAO_NIVEL1,
					Enumerados.ParametroSistema.SMTP_ENVIO_RemetenteNotificacoesSolicitacao,
					Enumerados.ParametroSistema.SMTP_LEITURA_Servidor,
					Enumerados.ParametroSistema.SMTP_LEITURA_Usuario,
					Enumerados.ParametroSistema.SMTP_LEITURA_Senha,
					Enumerados.ParametroSistema.SMTP_LEITURA_Provider,
					Enumerados.ParametroSistema.SMTP_LEITURA_Porta,
					Enumerados.ParametroSistema.SMTP_LEITURA_Pasta,
					Enumerados.ParametroSistema.NomeFluxoPadraoServicos,
					Enumerados.ParametroSistema.IDFaseExecucaoServicos,
					Enumerados.ParametroSistema.EnviaEmailFluxo,
					Enumerados.ParametroSistema.PAGE_CADADTRO_SOLICITACAOSERVICO,
					Enumerados.ParametroSistema.VALIDAR_BOTOES,
					Enumerados.ParametroSistema.ID_MODELO_EMAIL_GRUPO_DESTINO,
					Enumerados.ParametroSistema.NOTIFICAR_GRUPO_RECEPCAO_SOLICITACAO,
					Enumerados.ParametroSistema.SERVICO_PADRAO_SOLICITACAO,
					Enumerados.ParametroSistema.ORIGEM_PADRAO_SOLICITACAO,
					Enumerados.ParametroSistema.LDAP_MOSTRA_BOTAO,
					Enumerados.ParametroSistema.CAMPOS_OBRIGATORIO_SOLICITACAOSERVICO,
					Enumerados.ParametroSistema.AVISAR_DATAEXPIRACAO_LICENCA,
					Enumerados.ParametroSistema.MOSTRAR_CATEGORIA_SERVICO_EM_INCIDENTE,
					Enumerados.ParametroSistema.CALCULAR_PRIORIDADE_SOLICITACAO_DINAMICAMENTE,
					Enumerados.ParametroSistema.ORIGEM_PADRAO,
					Enumerados.ParametroSistema.TIRAR_VINCULO_LOCALIDADE_UNIDADE,
					Enumerados.ParametroSistema.CONTRATO_PADRAO,
					Enumerados.ParametroSistema.TIPO_CAPTURA_SOLICITACOES,
					Enumerados.ParametroSistema.ID_MODELO_EMAIL_AVISAR_PESQUISA_SATISFACAO_RUIM_OU_REGULAR,
					Enumerados.ParametroSistema.ID_GRUPO_PADRAO_AVISAR_PESQUISA_SATISFACAO_RUIM_OU_REGULAR,
					Enumerados.ParametroSistema.QTDE_DIAS_RESP_PESQ_SASTISFACAO,
 Enumerados.ParametroSistema.AVALIAO_AUTOMATICA, Enumerados.ParametroSistema.NOTA_AVALIAO_AUTOMATICA,
					Enumerados.ParametroSistema.FILTRO_FLUXO_NOME,
					Enumerados.ParametroSistema.FILTRO_FLUXO_ENCERRAMENTO,
					Enumerados.ParametroSistema.DIAS_LIMITE_REABERTURA_INCIDENTE_REQUISICAO,
					Enumerados.ParametroSistema.PASTA_SALVA_DESCRICAO_RESPOSTA_DE_SOLICITACAOSERVICO_EM_BASECONHECIMENTO,
					Enumerados.ParametroSistema.HABILITA_REGRA_ESCALONAMENTO,
					Enumerados.ParametroSistema.HABILITA_ROTINA_DE_LEITURA_EMAIL,
					Enumerados.ParametroSistema.RECEBER_NOTIFICACAO_ENCERRAR_ESCALONAR_SOLICITACOES_VINCULADAS,
					Enumerados.ParametroSistema.ID_MODELO_EMAIL_CRIACAO_GRUPO_EXECUTOR_SOLICITACAO_RELACIONADA,
					Enumerados.ParametroSistema.ID_MODELO_EMAIL_ACOES_GRUPO_EXECUTOR_SOLICITACAO_RELACIONADA,
					Enumerados.ParametroSistema.ID_MODELO_EMAIL_ENCERRAMENTO_GRUPO_EXECUTOR_SOLICITACAO_RELACIONADA,
					Enumerados.ParametroSistema.BPM_ELEMENTO_EXECUCAO,
					Enumerados.ParametroSistema.ATIVAR_ENVIO_EMAIL_UPDATE_INCIDENTE,
					Enumerados.ParametroSistema.QUANTIDADE_REGISTROS_PESQUISA_AVANCADA,
					Enumerados.ParametroSistema.ID_CATEGORIA_REGISTRA_OCORRENCIA_PORTAL,
					Enumerados.ParametroSistema.ID_ORIGEM_REGISTRA_OCORRENCIA_PORTAL,
					Enumerados.ParametroSistema.ID_CALENDARIO_PADRAO,
					Enumerados.ParametroSistema.SMTP_ENVIO_Porta,
					Enumerados.ParametroSistema.SOLICITACAO_SERVICO_FILTRAR_CATEGORIA_SERVICO
			)
		);

		for(Enumerados.ParametroSistema parametro : listParametros){
			document.executeScript("addLinhaTabelaAtributos(" + parametro.id() + ",'"
					+ StringUtils.replace(parametro.getCampoParametroInternacionalizado(request), "'", "\\'") + "','"
					+ StringEscapeUtils.escapeJavaScript(StringUtils.replace(ParametroUtil.getValorParametroCitSmartHashMap(parametro, ""), "'", "\'")) + "', '"
					+ parametro.tipoCampo() + "')"
			);
		}

			document.executeScript("renderiza()");

	}

	@SuppressWarnings("unchecked")
	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		this.setGerenciaConfiguracaoParametrosDTO((GerenciaConfiguracaoParametrosDTO) document.getBean());

		this.getGerenciaConfiguracaoParametrosDTO().setListConfiguracaoParametrosDTO(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(GerenciaConfiguracaoParametrosDTO.class, "listConfiguracaoParametroSerializado", request));
		ParametroCorporeService parametroCorporeService = (ParametroCorporeService) ServiceLocator.getInstance().getService(ParametroCorporeService.class, null);

		if (this.getGerenciaConfiguracaoParametrosDTO() != null
				&& this.getGerenciaConfiguracaoParametrosDTO().getListConfiguracaoParametroDTO() != null && !this.getGerenciaConfiguracaoParametrosDTO().getListConfiguracaoParametroDTO().isEmpty()) {

			for (GerenciaConfiguracaoParametrosDTO parametroGerenciaConfiguracaoParametrosDTO : this.getGerenciaConfiguracaoParametrosDTO().getListConfiguracaoParametroDTO()) {
				ParametroCorporeDTO parametroCorporeDTO = new ParametroCorporeDTO();

				parametroCorporeDTO.setId(Integer.parseInt(parametroGerenciaConfiguracaoParametrosDTO.getId().trim()));
				parametroCorporeDTO = (ParametroCorporeDTO) parametroCorporeService.restore(parametroCorporeDTO);

				if (parametroCorporeDTO.getTipoDado() != null && parametroCorporeDTO.getTipoDado().equalsIgnoreCase("Boolean")) {
					parametroCorporeDTO.setValor(Internacionalizar.internacionalizaOptionSN(request, "save", parametroGerenciaConfiguracaoParametrosDTO.getValorAtributoConfiguracaoParametro()));
				} else {
					parametroCorporeDTO.setValor(parametroGerenciaConfiguracaoParametrosDTO.getValorAtributoConfiguracaoParametro().trim());
				}

				parametroCorporeService.atualizarParametros(parametroCorporeDTO);
			}
			document.executeScript("notificacaoI18N('MSG06');");
		}
	}

	@Override
	public Class<GerenciaConfiguracaoParametrosDTO> getBeanClass() {
		return GerenciaConfiguracaoParametrosDTO.class;
	}

	public GerenciaConfiguracaoParametrosDTO getGerenciaConfiguracaoParametrosDTO() {
		return gerenciaConfiguracaoParametrosDTO;
	}

	public void setGerenciaConfiguracaoParametrosDTO(GerenciaConfiguracaoParametrosDTO gerenciaConfiguracaoParametrosDTO) {
		this.gerenciaConfiguracaoParametrosDTO = gerenciaConfiguracaoParametrosDTO;
	}
}
