package br.com.centralit.citcorpore.ajaxForms;


import java.util.ArrayList;
import java.util.Arrays;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citcorpore.bean.GerenciaConfiguracaoParametrosDTO;
import br.com.centralit.citcorpore.bean.ParametroCorporeDTO;
import br.com.centralit.citcorpore.negocio.ParametroCorporeService;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;

public class ConfiguracaoGerenciamentoMudanca extends AjaxFormAction {

	private ParametroCorporeService parametroCorporeService;

	ArrayList<Enumerados.ParametroSistema> listParametros = new ArrayList<Enumerados.ParametroSistema>(Arrays.asList(
			Enumerados.ParametroSistema.FLUXO_NORMAL_MUDANCAS, Enumerados.ParametroSistema.FLUXO_EMERGENCIAL_MUDANCAS,
			Enumerados.ParametroSistema.FLUXO_PADRAO_MUDANCAS,
			Enumerados.ParametroSistema.ID_MODELO_EMAIL_GRUPO_COMITE_REQUISICAOMUDANCA,
			Enumerados.ParametroSistema.ID_MODELO_EMAIL_GRUPO_DESTINO_REQUISICAOMUDANCA,
			Enumerados.ParametroSistema.HABILITA_ESCALONAMENTO_MUDANA,
			Enumerados.ParametroSistema.ERROCONHECIDO_ARQUIVAR_AO_CONCLUIR_MUDANCA,
			Enumerados.ParametroSistema.SMTP_LEITURA_Servidor,
			Enumerados.ParametroSistema.SMTP_LEITURA_Usuario,
			Enumerados.ParametroSistema.SMTP_LEITURA_Senha,
			Enumerados.ParametroSistema.SMTP_LEITURA_Provider,
			Enumerados.ParametroSistema.SMTP_LEITURA_Porta,
			Enumerados.ParametroSistema.SMTP_LEITURA_Pasta,
			Enumerados.ParametroSistema.VALIDAR_BOTOES,
			Enumerados.ParametroSistema.ID_MODELO_EMAIL_AVISAR_REUNIAO_MARCADA,
			Enumerados.ParametroSistema.TEMPLATE_QUESTIONARIO,
			Enumerados.ParametroSistema.UNIDADE_AUTOCOMPLETE,
			Enumerados.ParametroSistema.ID_CALENDARIO_PADRAO,
			Enumerados.ParametroSistema.ID_MODELO_EMAIL_ENCERRAMENTO_GRUPO_EXECUTOR_MUDANCA));

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		for (Enumerados.ParametroSistema parametro : listParametros) {
			document.executeScript("addLinhaTabelaAtributosGerenciaMudanca(" + parametro.id() + ",'" + StringUtils.replace(parametro.getCampoParametroInternacionalizado(request), "'", "\\'") + "','"
					+ StringEscapeUtils.escapeJavaScript(StringUtils.replace(ParametroUtil.getValorParametroCitSmartHashMap(parametro, ""), "'", "\'")) + "', '" + parametro.tipoCampo() + "')");
		}

		document.executeScript("renderiza()");

	}

	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciaConfiguracaoParametrosDTO gerenciaParametros = (GerenciaConfiguracaoParametrosDTO) document.getBean();

		gerenciaParametros.setListConfiguracaoParametrosDTO(br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(GerenciaConfiguracaoParametrosDTO.class, "listConfiguracaoParametroSerializado", request));
		ParametroCorporeService parametroCorporeService = (ParametroCorporeService) ServiceLocator.getInstance().getService(ParametroCorporeService.class, null);

		if (gerenciaParametros.getListConfiguracaoParametroDTO() != null && !gerenciaParametros.getListConfiguracaoParametroDTO().isEmpty()) {
			String[] totalParametros = null;
			for (GerenciaConfiguracaoParametrosDTO parametroGerenciaCmdbDTO : gerenciaParametros.getListConfiguracaoParametroDTO()) {
				ParametroCorporeDTO parametroCorporeDto = new ParametroCorporeDTO();

				parametroCorporeDto.setId(Integer.parseInt(parametroGerenciaCmdbDTO.getId().trim()));

				parametroCorporeDto = (ParametroCorporeDTO) parametroCorporeService.restore(parametroCorporeDto);
				/*
				 * Se o parmetro for do tipo boolean, faz a converso para o valor correto
				 */
				if (parametroCorporeDto.getTipoDado() != null && parametroCorporeDto.getTipoDado().equalsIgnoreCase("Boolean")) {
					parametroCorporeDto.setValor(Internacionalizar.internacionalizaOptionSN(request, "save", parametroGerenciaCmdbDTO.getValorAtributoConfiguracaoParametro()));
				} else {
					parametroCorporeDto.setValor(parametroGerenciaCmdbDTO.getValorAtributoConfiguracaoParametro().trim());
				}

				parametroCorporeService.atualizarParametros(parametroCorporeDto);

			}

			document.executeScript("notificacaoI18N('MSG06');");
		}
	}

	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
	}

	public void excluir(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
	}

	/**
	 * Recupera instncia de ParametroCorporeService.
	 *
	 * @return EvmGrupoCategoriaOcorrenciaService
	 * @throws ServiceException
	 * @author murilo.rodrigues
	 * @since 25.03.2015
	 */
	public ParametroCorporeService getParametroCorporeService() throws ServiceException {
		if (parametroCorporeService == null) {
			parametroCorporeService = (ParametroCorporeService) ServiceLocator.getInstance().getService(ParametroCorporeService.class, null);
		}
		return parametroCorporeService;
	}

	@Override
	public Class<GerenciaConfiguracaoParametrosDTO> getBeanClass() {
		return GerenciaConfiguracaoParametrosDTO.class;
	}

}
