package br.com.centralit.citcorpore.ajaxForms;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringEscapeUtils;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.StaxDriver;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.BICategoriasDTO;
import br.com.centralit.citcorpore.bean.BIConsultaColunasDTO;
import br.com.centralit.citcorpore.bean.BIConsultaDTO;
import br.com.centralit.citcorpore.negocio.BICategoriasService;
import br.com.centralit.citcorpore.negocio.BIConsultaColunasService;
import br.com.centralit.citcorpore.negocio.BIConsultaService;
import br.com.centralit.citcorpore.util.Enumerados.ModuloExibicaoRelatorio;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.centralit.citquestionario.util.Upload;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilStrings;

public class ConstrutorConsultas extends AjaxFormAction {

	@Override
	public void load(DocumentHTML document, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		BIConsultaDTO biConsultaDTO = (BIConsultaDTO) document.getBean();
		BICategoriasService biCategoriasService = (BICategoriasService) ServiceLocator.getInstance().getService(BICategoriasService.class, null);
		Collection col = biCategoriasService.findSemPai();

		HTMLSelect idCategoria = document.getSelectById("idCategoria");
		preencheComboCateg(idCategoria, col, biCategoriasService, 0, request);

		carregaComboModuloExibicao(document, request, response);

		if (biConsultaDTO.getAcao()!=null){
			if (biConsultaDTO.getAcao().equalsIgnoreCase("restore")){
				restore(document, request, response);
			}
		}else{
			Upload upload = new Upload();
			HashMap hshRetorno[] = null;

			try{
				hshRetorno = upload.doUploadAll(request);
			}catch (Exception e) {
			}

			if (hshRetorno != null){
				Collection fileItems = hshRetorno[1].values();
				HashMap formItems = hshRetorno[0];

				String acao = (String) formItems.get("ACAO");
				if (acao != null && acao.equalsIgnoreCase("importar")){
					importar(fileItems, document, request);
				}
			}
		}
	}

	/**
	 * @see br.com.centralit.citcorpore.util.Enumerados.ModuloExibicaoRelatorio
	 * @since 25/11/2015
	 * @author douglas.japiassu
	 */
	private void carregaComboModuloExibicao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect combo = document.getSelectById("slModuloExibicao");
		combo.removeAllOptions();

		for (ModuloExibicaoRelatorio moduloExibicao : ModuloExibicaoRelatorio.values()) {
			combo.addOption(moduloExibicao.getIdentificador(), UtilI18N.internacionaliza(request, moduloExibicao.getChave()));
		}
	}

	private void preencheComboCateg(HTMLSelect idCategoria, Collection<BICategoriasDTO> col, BICategoriasService biCategoriasService, int nivel, HttpServletRequest request) throws Exception {
		if (col != null){
			for (Iterator<BICategoriasDTO> it = col.iterator(); it.hasNext();) {
				BICategoriasDTO biCategoriasDTO = it.next();
				idCategoria.addOption(geraNivel(nivel) + biCategoriasDTO.getIdCategoria(), UtilI18N.internacionaliza(request, biCategoriasDTO.getNomeCategoria()));
				Collection colAux = biCategoriasService.findByIdCategoriaPai(biCategoriasDTO.getIdCategoria());
				if (colAux != null){
					preencheComboCateg(idCategoria, colAux, biCategoriasService, nivel + 1, request);
				}
			}
		}
	}
	private String geraNivel(int niv){
		String ret  = "";
		for (int i = 0; i < niv; i++){
			ret = ret + "...";
		}
		return ret;
	}

	@Override
	public Class<BIConsultaDTO> getBeanClass() {
		return BIConsultaDTO.class;
	}

	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		BIConsultaDTO biConsultaDTO = (BIConsultaDTO) document.getBean();
		BIConsultaService biConsultaService = (BIConsultaService) ServiceLocator.getInstance().getService(BIConsultaService.class, null);

		Collection<BIConsultaColunasDTO> colColunas = br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(BIConsultaColunasDTO.class, "colCriterios_Serialize", request);
		biConsultaDTO.setColColunas(colColunas);
		if (biConsultaDTO.getIdConsulta() == null || biConsultaDTO.getIdConsulta().intValue() == 0) {
			biConsultaService.create(biConsultaDTO);
			document.alert(UtilI18N.internacionaliza(request, "MSG05"));
		} else {
			biConsultaService.update(biConsultaDTO);
			document.alert(UtilI18N.internacionaliza(request, "MSG06"));
		}

		HTMLForm form = document.getForm("form");
		form.clear();
		document.executeScript("GRID_COLUNAS.deleteAllRows();");
		document.executeScript("limpar();");

		document.executeScript("parametros = CM.init(document.getElementById(\"parametros\"), {lineNumbers: true, matchTags: {bothTags: true}, extraKeys: {\"Ctrl-J\": \"toMatchingTag\"}, mode: \"application/xml\"});");
		document.executeScript("scriptExec = CM.init(document.getElementById(\"scriptExec\"), {lineNumbers: true, matchBrackets: true, mode: \"text/x-java\"});");
		document.executeScript("template = CM.init(document.getElementById(\"template\"), {lineNumbers: true, matchTags: {bothTags: true}, extraKeys: {\"Ctrl-J\": \"toMatchingTag\"}, mode: \"text/html\"});");

	}

	public void exportar(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		BIConsultaDTO biConsultaDTO = (BIConsultaDTO) document.getBean();

		Collection<BIConsultaColunasDTO> colColunas = br.com.citframework.util.WebUtil.deserializeCollectionFromRequest(BIConsultaColunasDTO.class, "colCriterios_Serialize", request);
		biConsultaDTO.setColColunas(colColunas);
		if (biConsultaDTO.getIdConsulta() == null || biConsultaDTO.getIdConsulta().intValue() == 0) {
			document.alert(UtilI18N.internacionaliza(request, "construtorconsultas.gravarAntes"));
			return;
		}

		String diretorioExport = request.getSession().getServletContext().getRealPath("/");
		String diretorioRelativoExport = Constantes.getValue("SERVER_ADDRESS") + Constantes.getValue("CONTEXTO_APLICACAO") + "/";

		diretorioExport = diretorioExport + "exportXML";
		diretorioRelativoExport = diretorioRelativoExport + "exportXML";
		File f = new File(diretorioExport);
		if (!f.exists()){
			f.mkdirs();
		}

		String name = UtilStrings.generateNomeBusca(biConsultaDTO.getIdentificacao());
		name = name + ".citreport";
		FileOutputStream fOut = new FileOutputStream(diretorioExport + "/" + name);

		XStream x = new XStream(new StaxDriver());
		biConsultaDTO.setIdConsulta(null);
		x.toXML(biConsultaDTO, fOut);

		fOut.close();

		document.executeScript("window.open('" + diretorioRelativoExport + "/" + name + "')");

	}

	public void importar(Collection fileItems, DocumentHTML document, HttpServletRequest request) throws Exception{
		BIConsultaService biConsultaService = (BIConsultaService) ServiceLocator.getInstance().getService(BIConsultaService.class, null);
		BIConsultaDTO biConsultaDTO = null;
		FileItem fi;
		if (!fileItems.isEmpty()){
			Iterator it = fileItems.iterator();
			while(it.hasNext()){
				fi = (FileItem)it.next();

				XStream x = new XStream(new StaxDriver());

				String str = new String(fi.get(), "UTF-8");
				biConsultaDTO = (BIConsultaDTO) x.fromXML(str);
			}
		}

		document.executeScript("GRID_COLUNAS.deleteAllRows();");
		HTMLForm form = document.getForm("form");
		try{
			BIConsultaDTO biConsultaAux = biConsultaService.getByIdentificacao(biConsultaDTO.getIdentificacao());
			if (biConsultaAux != null){
				biConsultaDTO.setIdConsulta(biConsultaAux.getIdConsulta());
			}
		}catch(Exception e){}
		form.clear();
		form.setValues(biConsultaDTO);


		Collection<BIConsultaColunasDTO> colColunas = biConsultaDTO.getColColunas();

		if (colColunas != null) {
			int i = 0;
			for (BIConsultaColunasDTO colunaDto : colColunas) {
				i++;
				document.executeScript("GRID_COLUNAS.addRow()");
				document.executeScript("seqColuna = NumberUtil.zerosAEsquerda(" + i + ",5)");
				document.executeScript("exibeColuna('" + br.com.citframework.util.WebUtil.serializeObject(colunaDto, WebUtil.getLanguage(request)) + "')");
			}
		}
		document.alert(UtilI18N.internacionaliza(request, "construtorconsultas.importado"));
	}

	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		BIConsultaDTO biConsultaDTO = (BIConsultaDTO) document.getBean();
		BIConsultaService biConsultaService = (BIConsultaService) ServiceLocator.getInstance().getService(BIConsultaService.class, null);
		BIConsultaColunasService biConsultaColunasService = (BIConsultaColunasService) ServiceLocator.getInstance().getService(BIConsultaColunasService.class, null);

		biConsultaDTO = (BIConsultaDTO) biConsultaService.restore(biConsultaDTO);
		document.executeScript("GRID_COLUNAS.deleteAllRows();");
		HTMLForm form = document.getForm("form");
		form.clear();
		form.setValues(biConsultaDTO);

		document.executeScript("CM.update(parametros, \"" + StringEscapeUtils.escapeJavaScript(biConsultaDTO.getParametros()) + "\");");
		document.executeScript("CM.update(scriptExec, \"" + StringEscapeUtils.escapeJavaScript(biConsultaDTO.getScriptExec()) + "\");");
		document.executeScript("CM.update(template, \"" + StringEscapeUtils.escapeJavaScript(biConsultaDTO.getTemplate()) + "\");");

		defineValueElementos(document, biConsultaDTO);

		Collection<BIConsultaColunasDTO> colColunas = biConsultaColunasService.findByIdConsulta(biConsultaDTO.getIdConsulta());

		if (colColunas != null) {
			int i = 0;
			for (BIConsultaColunasDTO colunaDto : colColunas) {
				i++;
				document.executeScript("GRID_COLUNAS.addRow()");
				document.executeScript("seqColuna = NumberUtil.zerosAEsquerda(" + i + ",5)");
				document.executeScript("exibeColuna('" + br.com.citframework.util.WebUtil.serializeObject(colunaDto, WebUtil.getLanguage(request)) + "')");
			}
		}
	}

	private void defineValueElementos(DocumentHTML document, BIConsultaDTO consultaDTO) throws Exception {
		//document.executeScript("defineComportamentoCheckboxNaoAtualizBase(" + SimNao.SIM.getValorStr().equalsIgnoreCase(consultaDTO.getNaoAtualizBase()) + ")");
		document.executeScript("defineComportamentoRadioTipoExibicao('".concat(consultaDTO.getTipoExibicao()).concat("')"));
		document.executeScript("defineComportamentoSelectModuloExibicao('".concat(UtilStrings.nullToVazio(consultaDTO.getModuloExibicao())).concat("')"));
	}

}