package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.bpm.dto.ElementoFluxoDTO;
import br.com.centralit.bpm.dto.ItemTrabalhoFluxoDTO;
import br.com.centralit.bpm.integracao.ItemTrabalhoFluxoDao;
import br.com.centralit.bpm.negocio.ItemTrabalho;
import br.com.centralit.bpm.util.Enumerated;
import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citcorpore.bean.CtrlTelefoniaDTO;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.bean.ExecucaoSolicitacaoDTO;
import br.com.centralit.citcorpore.bean.ServicoContratoDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.UnidadeDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.integracao.ExecucaoSolicitacaoDao;
import br.com.centralit.citcorpore.negocio.EmpregadoService;
import br.com.centralit.citcorpore.negocio.ExecucaoSolicitacaoService;
import br.com.centralit.citcorpore.negocio.ServicoContratoService;
import br.com.centralit.citcorpore.negocio.ServicoService;
import br.com.centralit.citcorpore.negocio.SolicitacaoServicoService;
import br.com.centralit.citcorpore.negocio.UnidadeService;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.ServiceRequestStatus;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.Telefone;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.PersistenceException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilI18N;

/**
 * @author euler.ramos
 */
public class CtrlTelefonia extends AjaxFormAction {

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
	}

	public void abrePopUpAsterisk(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		CtrlTelefoniaDTO ctrlTelefoniaDTO = (CtrlTelefoniaDTO) document.getBean();
		// Este nmero vem da sesso:
		if (request.getSession().getAttribute("ramalTelefone")!=null){
			ctrlTelefoniaDTO.setRamalTelefone(request.getSession().getAttribute("ramalTelefone").toString());
		}
		if (ctrlTelefoniaDTO.getListaChamadas()!=null&&ctrlTelefoniaDTO.getListaChamadas().length()>0){
			if (ctrlTelefoniaDTO.getRamalTelefone()!=null&&ctrlTelefoniaDTO.getRamalTelefone().length()>0){
				// Quebrando por Ligaes
				String[] arrayListaTelefones = ctrlTelefoniaDTO.getListaChamadas().split("#");
				StringBuilder html = new StringBuilder();
				StringBuilder campoNome = new StringBuilder();
				StringBuilder campoTelefone = new StringBuilder();
				EmpregadoDTO empregadoDto = new EmpregadoDTO();
				StringBuilder condicaoProcura;
				EmpregadoService empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, WebUtil.getUsuarioSistema(request));
				for(String ligacao : arrayListaTelefones){
					//Separando os campos
					String[] chamada = ligacao.split(",");
					//Se Destino for o ramal deste cliente
					if (chamada[1].equals(ctrlTelefoniaDTO.getRamalTelefone())){
						condicaoProcura = new StringBuilder();
						condicaoProcura.append(Telefone.mascaraProcuraSql(chamada[0]));
						empregadoDto = empregadoService.findByTelefoneOrRamal(condicaoProcura.toString());
						if (empregadoDto != null && empregadoDto.getNome() != null && org.apache.commons.lang.StringUtils.isNotBlank(empregadoDto.getNome())) {
							campoNome.append("<p>").append(empregadoDto.getNome()).append("</p>");
							this.alimentarDadosSolicitante(empregadoDto, document);
						} else {
							campoNome.append("<p>").append(UtilI18N.internacionaliza(WebUtil.getUsuarioSistema(request).getLocale(), "citcorpore.comum.telefone.CliNaoIdentificado")).append("</p>");
						}
						campoTelefone.append("<p>").append(Telefone.numeroMascarado(chamada[0], false)).append("</p>");
						html.append("<div class='box-generic'>");
						html.append("	<div class='row-fluid'>");
						html.append("		<div class='span6'>");
						html.append("			<label class='strong'>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.nome")).append("</label>");
						html.append(campoNome.toString());
						html.append("		</div>");
						html.append("		<div class='span6'>");
						html.append("			<label class='strong'>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.telefone")).append("</label>");
						html.append(campoTelefone.toString());
						html.append("		</div>");
						html.append("	</div>");
						html.append("	<div class='row-fluid'>");
						html.append("		<div class='span12 innerTB'>");
						html.append("			<button class='btn btn-block btn-primary' onclick='novaSolicitacaoTelefonia();' type='button'>").append(UtilI18N.internacionaliza(request, "solicitacaoServico.cadastrosolicitacao")).append("</button>");
						html.append("		</div>");
						html.append("	</div>");
						html.append("</div>");

						document.getElementById("conteudoframeTelefonia").setInnerHTML(html.toString());
						document.executeScript("$('#modal_Telefonia').modal('show');");
						break; // No haver mais do que uma chamada ativa para este ramal, outras tentativas recebero sinal de ocupado.
					}
				}
			}
		}
	}

	public void abrePopUpNovaSolicitacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		CtrlTelefoniaDTO ctrlTelefoniaDTO = (CtrlTelefoniaDTO) document.getBean();
		// Este nmero vem da sesso e identifica o ramal do atendente:
		if (request.getSession().getAttribute("ramalTelefone")!=null){
			ctrlTelefoniaDTO.setRamalTelefone(request.getSession().getAttribute("ramalTelefone").toString());
		}
		// Este nmero representa o ramal que est tocando na telefonia
		if (ctrlTelefoniaDTO.getCalledID()!=null&&ctrlTelefoniaDTO.getCalledID().length()>0){
			if (ctrlTelefoniaDTO.getRamalTelefone()!=null&&ctrlTelefoniaDTO.getRamalTelefone().length()>0){
				//Se Destino for o ramal deste cliente
				if (ctrlTelefoniaDTO.getCalledID().equals(ctrlTelefoniaDTO.getRamalTelefone())){
					StringBuilder html = new StringBuilder();
					html.append(this.geraDadosSolicitante(ctrlTelefoniaDTO.getTelCPF(), request, document));
					html.append("<div class='box-generic'>");
					html.append("	<div class='row-fluid'>");
					html.append("		<div class='span12 innerTB'>");
					html.append("			<button class='btn btn-block btn-primary' onclick='novaSolicitacaoTelefonia();' type='button'>").append(UtilI18N.internacionaliza(request, "solicitacaoServico.cadastrosolicitacao")).append("</button>");
					html.append("		</div>");
					html.append("	</div>");
					html.append("</div>");

					document.getElementById("conteudoframeTelefonia").setInnerHTML(html.toString());
					document.executeScript("$('#modal_Telefonia').modal('show');");
				}
			}
		}
	}

	public void abrePopUpVisualizarSolicitacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null||usuario.getIdUsuario() == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		CtrlTelefoniaDTO ctrlTelefoniaDTO = (CtrlTelefoniaDTO) document.getBean();

		// Este nmero vem da sesso e identifica o ramal do atendente:
		if (request.getSession().getAttribute("ramalTelefone")!=null){
			ctrlTelefoniaDTO.setRamalTelefone(request.getSession().getAttribute("ramalTelefone").toString());
		}

		// Este nmero representa o ramal que est tocando na telefonia
		if (ctrlTelefoniaDTO.getCalledID()!=null&&ctrlTelefoniaDTO.getCalledID().length()>0){

			if (ctrlTelefoniaDTO.getRamalTelefone()!=null&&ctrlTelefoniaDTO.getRamalTelefone().length()>0){

				//Se Destino for o ramal deste cliente
				if (ctrlTelefoniaDTO.getCalledID().equals(ctrlTelefoniaDTO.getRamalTelefone())){

					if (ctrlTelefoniaDTO.getTelIdSolicitacao()!=null&&ctrlTelefoniaDTO.getTelIdSolicitacao().intValue()>0){

						SolicitacaoServicoService solicitacaoServicoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, WebUtil.getUsuarioSistema(request));
						SolicitacaoServicoDTO solicitacaoServicoDTO = solicitacaoServicoService.restoreAll(ctrlTelefoniaDTO.getTelIdSolicitacao());

						StringBuilder html = new StringBuilder();
						if (solicitacaoServicoDTO != null && solicitacaoServicoDTO.getIdSolicitacaoServico() != null && solicitacaoServicoDTO.getIdSolicitacaoServico() > 0) {

							if (ServiceRequestStatus.CANCELED.getId().equals(solicitacaoServicoDTO.getIdStatus()) || ServiceRequestStatus.CLOSED.getId().equals(solicitacaoServicoDTO.getIdStatus())
									|| ServiceRequestStatus.SUSPENDED.getId().equals(solicitacaoServicoDTO.getIdStatus())) {
								// As solicitaes de servio nas situaes Cancelada e Suspensa, no encerram todos os itens de trabalho, portanto, deve-se estabelecer via cdigo a proibio de
								// execuo.
								html.append(this.gerarBotaoVisualizar(solicitacaoServicoDTO, request, usuario, solicitacaoServicoService, document));
							} else {
								Integer idItemTrabalho = this.encontrarItemTrabalhoDeExecucao(solicitacaoServicoDTO, usuario, solicitacaoServicoService, document, request);
								if (idItemTrabalho != null && idItemTrabalho.intValue() > 0) {
									html.append(this.gerarBotaoExecutar(solicitacaoServicoDTO, idItemTrabalho, request, document));
								} else {
									html.append(this.gerarBotaoVisualizar(solicitacaoServicoDTO, request, usuario, solicitacaoServicoService, document));
								}
							}
						} else {
							html.append(this.geraQuadroSolicitacaoNaoEncontrada(request));
						}
						document.getElementById("conteudoframeTelefonia").setInnerHTML(html.toString());
						document.executeScript("$('#modal_Telefonia').modal('show');");
					}
				}
			}
		}
	}

	private String gerarBotaoExecutar(SolicitacaoServicoDTO solicitacaoServicoDTO, Integer idItemTrabalho,	HttpServletRequest request, DocumentHTML document) throws ServiceException, Exception {
		StringBuilder html = new StringBuilder();
		html.append(this.geraQuadroDadosSolicitacao(solicitacaoServicoDTO, idItemTrabalho, request));
		html.append("<button class='btn btn-block btn-primary' onclick='executarSolicitacaoTelefonia();' type='button'>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.executar")).append("</button>");
		html.append(this.geraFimQuadroDadoSolicitacao());

		this.alimentarDadosSolicitacao(solicitacaoServicoDTO, idItemTrabalho, document);

		return html.toString();
	}

	private String gerarBotaoVisualizar(SolicitacaoServicoDTO solicitacaoServicoDTO, HttpServletRequest request, UsuarioDTO usuario, SolicitacaoServicoService solicitacaoServicoService, DocumentHTML document) throws ServiceException, Exception {
		StringBuilder html = new StringBuilder();
		Integer idItemTrabalho = this.encontrarItemTrabalhoDeVisualizacao(solicitacaoServicoDTO, usuario, solicitacaoServicoService, document, request);
		html.append(this.geraQuadroDadosSolicitacao(solicitacaoServicoDTO, idItemTrabalho, request));
		if (idItemTrabalho!=null&&idItemTrabalho.longValue()>0){
			html.append("<button class='btn btn-block btn-primary' onclick='visualizarSolicitacaoTelefonia();' type='button'>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.visualizar")).append("</button>");
		} else {
			html.append("	<div class='row-fluid'>");
			html.append("		<div class='span12'>");
			html.append("			<label class='content-row'>");
			html.append("		      <span class='content-row prioridade Alta center'>").append(UtilI18N.internacionaliza(request, "baseConhecimento.usuarioSemPermissao")).append("</span>");
			html.append("		    </label>");
			html.append("		</div>");
			html.append("	</div>");
		}
		html.append(this.geraFimQuadroDadoSolicitacao());

		this.alimentarDadosSolicitacao(solicitacaoServicoDTO, idItemTrabalho, document);

		return html.toString();
	}

	private void alimentarDadosSolicitacao(SolicitacaoServicoDTO solicitacaoServicoDTO, Integer idItemTrabalho, DocumentHTML document) throws Exception {
		HTMLElement telIdSolicitacao = document.getElementById("telIdSolicitacao");
		if (telIdSolicitacao!=null) {
			if (solicitacaoServicoDTO.getIdSolicitacaoServico()!=null){
				telIdSolicitacao.setValue(solicitacaoServicoDTO.getIdSolicitacaoServico().toString());
			} else {
				telIdSolicitacao.setValue("");
			}
		};
		HTMLElement telIdItemTrabalho = document.getElementById("telIdItemTrabalho");
		if (telIdItemTrabalho!=null) {
			if (idItemTrabalho!=null){
				telIdItemTrabalho.setValue(idItemTrabalho.toString());
			} else {
				telIdItemTrabalho.setValue("");
			}
		};
	}

	private void alimentarDadosSolicitante(EmpregadoDTO empregadoDto, DocumentHTML document) throws Exception {
		HTMLElement telIdEmpregado = document.getElementById("telIdEmpregado");
		if (empregadoDto!=null) {
			if (empregadoDto.getIdEmpregado()!=null){
				telIdEmpregado.setValue(empregadoDto.getIdEmpregado().toString());
			} else {
				telIdEmpregado.setValue("");
			}
		};
	}

	private String geraDadosSolicitante(String cpf, HttpServletRequest request, DocumentHTML document) throws Exception{
		EmpregadoDTO empregadoDTO = new EmpregadoDTO();
		EmpregadoService empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, WebUtil.getUsuarioSistema(request));
		empregadoDTO = empregadoService.restoreByCPF(cpf);
		this.alimentarDadosSolicitante(empregadoDTO, document);
		return this.geraDadosSolicitante(empregadoDTO, request);
	}

	private String geraDadosSolicitante(EmpregadoDTO empregadoDTO, HttpServletRequest request) throws Exception {
		StringBuilder html = new StringBuilder();

		html.append("<div class='top separator'></div>");
			html.append("<div class='box-generic'>");
				html.append("<div class='row-fluid'>");
					html.append("<div class='span12'>");
						html.append("<h5 class='pull-left'>").append(UtilI18N.internacionaliza(request, "solicitacaoServico.informacoesSolicitante")).append("</h5>");
					html.append("</div>");
				html.append("</div>");
				html.append("<hr class='mt0'>");
				if (empregadoDTO != null&&empregadoDTO.getIdEmpregado()!=null&&empregadoDTO.getIdEmpregado().intValue()>0) {

					html.append("<div class='row-fluid'>");

						html.append("<div class='span4'>");
							html.append("<label class='content-row'>");
								html.append("<div>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.nome")).append("</div>");
								html.append("<span class='fontSize15'>").append(empregadoDTO.getNome()!=null?empregadoDTO.getNome():"").append("</span>");
							html.append("</label>");
						html.append("</div>");

						html.append("<div class='span4'>");
							html.append("<label class='content-row'>");
								html.append("<div>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.cpfcnpj")).append("</div>");
								html.append("<span class='fontSize15'>").append(empregadoDTO.getCpf()!=null?empregadoDTO.getCpf():"").append("</span>");
							html.append("</label>");
						html.append("</div>");

						html.append("<div class='span4'>");
							html.append("<label class='content-row'>");
								html.append("<div>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.email")).append("</div>");
								html.append("<span class='fontSize15'>").append(empregadoDTO.getEmail()!=null?empregadoDTO.getEmail():"").append("</span>");
							html.append("</label>");
						html.append("</div>");

					html.append("</div>");

					html.append("<div class='row-fluid'>");

						html.append("<div class='span4'>");
							html.append("<label class='content-row'>");
								html.append("<div>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.telefone")).append("</div>");
								html.append("<span class='fontSize15'>").append(empregadoDTO.getTelefone()!=null?empregadoDTO.getTelefone():"").append("</span>");
							html.append("</label>");
						html.append("</div>");

						html.append("<div class='span4'>");
							html.append("<label class='content-row'>");
								html.append("<div>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.ramal")).append("</div>");
								html.append("<span class='fontSize15'>").append(empregadoDTO.getRamal()!=null?empregadoDTO.getRamal():"").append("</span>");
							html.append("</label>");
						html.append("</div>");

					html.append("</div>");

					html.append("<div class='row-fluid'>");
						html.append("<div class='span12'>");
							html.append("<label class='content-row'>");
								html.append("<div>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.unidade")).append("</div>");
								html.append("<span class='fontSize15'>").append(this.obterNomeUnidade(empregadoDTO.getIdUnidade())).append("</span>");
							html.append("</label>");
						html.append("</div>");
					html.append("</div>");

				} else {
					html.append("<div class='row-fluid'>");
						html.append("<div class='span12'>");
						html.append("<span class='fontSize15'>").append(UtilI18N.internacionaliza(WebUtil.getUsuarioSistema(request).getLocale(), "citcorpore.comum.telefone.CliNaoIdentificado")).append("</span>");
						html.append("</div>");
					html.append("</div>");
				}
			html.append("</div>");
		html.append("</div>");

		return html.toString();
	}

	private String obterNomeUnidade(Integer idUnidade) throws ServiceException, LogicException {
		if (idUnidade!=null){
			UnidadeService unidadeService = (UnidadeService) ServiceLocator.getInstance().getService(UnidadeService.class,null);
			UnidadeDTO unidadeDTO = new UnidadeDTO();
			unidadeDTO.setIdUnidade(idUnidade);
			unidadeDTO = unidadeService.restore(unidadeDTO);
			return unidadeDTO!=null&&unidadeDTO.getNome()!=null?unidadeDTO.getNome():"";
		}
		return "";
	}

	private String geraQuadroSolicitacaoNaoEncontrada(HttpServletRequest request) {
		StringBuilder html = new StringBuilder();
		html.append("	<div class='row-fluid'>");
		html.append("		<div class='span12'>");
		html.append("			<label class='content-row'>");
		html.append("		      <span class='content-row prioridade Alta center'>").append(UtilI18N.internacionaliza(request, "rest.service.mobile.service.solicitation.notfound")).append("</span>");
		html.append("		    </label>");
		html.append("		</div>");
		html.append("	</div>");
		return html.toString();
	}

	private Integer encontrarItemTrabalhoDeExecucao(SolicitacaoServicoDTO solicitacaoServicoDTO, UsuarioDTO usuario, SolicitacaoServicoService solicitacaoServicoService, DocumentHTML document, HttpServletRequest request) throws PersistenceException {
		Integer idItemTrabalho = null;
		ArrayList<CtrlTelefoniaDTO> listaCtrlTelefoniaDTO = solicitacaoServicoService.obterItensTrabalhoParaExecucaoSolicitacaoServico(solicitacaoServicoDTO.getIdSolicitacaoServico(), usuario.getIdUsuario());
		if (listaCtrlTelefoniaDTO!=null&&listaCtrlTelefoniaDTO.size()>0){
			for (CtrlTelefoniaDTO ctrlTelefoniaDTO : listaCtrlTelefoniaDTO) {
				if(ctrlTelefoniaDTO.getIdUsuario()!=null&&ctrlTelefoniaDTO.getIdUsuario().equals(usuario.getIdUsuario())){
					// Dando preferncia para o item de trabalho atribuido diretamente ao usurio logado
					idItemTrabalho = ctrlTelefoniaDTO.getTelIdItemTrabalho();
					break;
				}
			}
			// Do contrrio pegar o primeiro na lista
			if (idItemTrabalho==null){
				idItemTrabalho = listaCtrlTelefoniaDTO.get(0).getTelIdItemTrabalho();
			}
		}
		return idItemTrabalho;
	}

	private Integer encontrarItemTrabalhoDeVisualizacao(SolicitacaoServicoDTO solicitacaoServicoDTO, UsuarioDTO usuario, SolicitacaoServicoService solicitacaoServicoService, DocumentHTML document, HttpServletRequest request) throws PersistenceException {
		Integer idItemTrabalho = null;
		ArrayList<CtrlTelefoniaDTO> listaCtrlTelefoniaDTO = solicitacaoServicoService.obterItensTrabalhoParaVisualizacaoSolicitacaoServico(solicitacaoServicoDTO.getIdSolicitacaoServico(), usuario.getIdUsuario());
		if (listaCtrlTelefoniaDTO!=null&&listaCtrlTelefoniaDTO.size()>0){
			for (CtrlTelefoniaDTO ctrlTelefoniaDTO : listaCtrlTelefoniaDTO) {
				if(ctrlTelefoniaDTO.getIdUsuario()!=null&&ctrlTelefoniaDTO.getIdUsuario().equals(usuario.getIdUsuario())){
					// Dando preferncia para o item de trabalho atribuido diretamente ao usurio logado
					idItemTrabalho = ctrlTelefoniaDTO.getTelIdItemTrabalho();
					break;
				}
			}
			// Do contrrio pegar o primeiro na lista
			if (idItemTrabalho==null){
				idItemTrabalho = listaCtrlTelefoniaDTO.get(0).getTelIdItemTrabalho();
			}
		}
		return idItemTrabalho;
	}

	private String geraQuadroDadosSolicitacao(SolicitacaoServicoDTO solicitacaoServicoDTO, Integer idItemTrabalho, HttpServletRequest request) throws ServiceException, Exception {
		StringBuilder html = new StringBuilder();
		EmpregadoService empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, WebUtil.getUsuarioSistema(request));
		EmpregadoDTO solicitante = empregadoService.restoreByIdEmpregado(solicitacaoServicoDTO.getIdSolicitante());

			html.append("<div class='box-generic'>");
				html.append("<div class='row-fluid'>");
					html.append("<div class='span12'>");
						html.append("<h5 class='pull-left'>").append(UtilI18N.internacionaliza(request, "solicitacaoServico.informacoesSolicitacao")).append("</h5>");
					html.append("</div>");
				html.append("</div>");
				html.append("<hr class='mt0'>");
				html.append("	<div class='row-fluid'>");
				html.append("		<div class='span4'>");
				html.append("			<label class='content-row'>");
				html.append("		      <div>").append(UtilI18N.internacionaliza(request, "gerenciaservico.numerosolicitacao")).append("</div>");
				html.append("		      <span class='fontSize15'>[").append(solicitacaoServicoDTO.getIdSolicitacaoServico()).append("]</span>");
				html.append("		    </label>");
				html.append("		</div>");
				html.append("		<div class='span4'>");
				html.append("			<label class='content-row'>");
				html.append("		      <div>").append(UtilI18N.internacionaliza(request, "solicitacaoServico.dataHoraCriacao")).append("</div>");
				html.append("		      <span class='fontSize15'>").append(solicitacaoServicoDTO.obterDataHoraSolicitacaoStrWithLanguage((String) request.getSession().getAttribute("locale"))).append("</span>");
				html.append("		    </label>");
				html.append("		</div>");
				html.append("		<div class='span4'>");
				html.append("			<label class='content-row'>");
				html.append("		      <div>").append(UtilI18N.internacionaliza(request, "solicitacaoServico.datahoralimite")).append("</div>");
				html.append("		      <span class='fontSize15'>").append(solicitacaoServicoDTO.getPrazoHH() != null && solicitacaoServicoDTO.getPrazoHH().equals(0) && solicitacaoServicoDTO.getPrazoMM().equals(0) && solicitacaoServicoDTO.getPrazoMM() != null ? "" : solicitacaoServicoDTO.obterDataHoraLimiteStrWithLanguage((String) request.getSession().getAttribute("locale"))).append("</span>");
				html.append("		    </label>");
				html.append("		</div>");
				html.append("	</div>");
				html.append("	<div class='row-fluid'>");
				html.append("		<div class='span4'>");
				html.append("			<label class='content-row'>");
				html.append("		      <div>").append(UtilI18N.internacionaliza(request, "solicitacaoServico.situacao")).append("</div>");
		html.append("		      <span class='content-row prioridade Alta'>").append(UtilI18N.internacionaliza((String) request.getSession().getAttribute("locale"), ServiceRequestStatus.getChaveFromId(solicitacaoServicoDTO.getIdStatus())))
				.append("</span>");
				html.append("		    </label>");
				html.append("		</div>");
				html.append("		<div class='span4'>");
				html.append("		    <label class='content-row'>");
				html.append("		      <div>").append(UtilI18N.internacionaliza(request, "solicitacaoServico.tarefaatual.desc")).append("</div>");
				html.append("			  <span class='content-row prioridade'>").append(this.obterTarefaAtual(idItemTrabalho)).append("</span>");
				html.append("		    </label>");
				html.append("		</div>");
				html.append("		<div class='span4'>");
				html.append("		    <label class='content-row'>");
				html.append("		      <div>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.grupoExecutor")).append("</div>");
				html.append("			  <span class='content-row prioridade'>").append(solicitacaoServicoDTO.getGrupoAtual()!=null?solicitacaoServicoDTO.getGrupoAtual():"").append("</span>");
				html.append("		    </label>");
				html.append("	    </div>");
				html.append("	</div>");
				html.append("	<div class='row-fluid'>");
				html.append("		<div class='span12'>");
				html.append("			<label class='content-row'>");
				html.append("		      <div>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.contrato")).append("</div>");
				html.append("		      <span class='content-row prioridade Alta'>").append(solicitacaoServicoDTO.getContrato()!=null?solicitacaoServicoDTO.getContrato():"").append("</span>");
				html.append("		    </label>");
				html.append("	    </div>");
				html.append("	</div>");
				html.append("	<div class='row-fluid'>");
				html.append("		<div class='span12'>");
				html.append("			<label class='content-row'>");
				html.append("		      <div>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.servico")).append("</div>");
				html.append("		      <span class='content-row prioridade Alta'>").append(solicitacaoServicoDTO.getNomeServico()!=null?solicitacaoServicoDTO.getNomeServico():"").append("</span>");
				html.append("		    </label>");
				html.append("		</div>");
				html.append("	</div>");
			html.append("</div>");
		html.append("</div>");

		html.append(this.geraDadosSolicitante(solicitante, request));

		html.append("	<div class='row-fluid'>");
		html.append("		<div class='span12 innerTB'>");
		return html.toString();
	}

	private String obterTarefaAtual(Integer idItemTrabalho) throws ServiceException, PersistenceException {
		if (idItemTrabalho!=null){
			ExecucaoSolicitacaoService execucaoSolicitacaoService = (ExecucaoSolicitacaoService) ServiceLocator.getInstance().getService(ExecucaoSolicitacaoService.class, null);
			ElementoFluxoDTO elementoFluxoDTO = execucaoSolicitacaoService.consultaElementoFluxoPeloIdItemTrabalho(idItemTrabalho);
			if (elementoFluxoDTO!=null&&elementoFluxoDTO.getDocumentacao()!=null){
				return elementoFluxoDTO.getDocumentacao()!=null?elementoFluxoDTO.getDocumentacao():"";
			}
		}
		return "";
	}

	private String geraFimQuadroDadoSolicitacao() {
		StringBuilder html = new StringBuilder();
		html.append("</div>");
		html.append("</div>");
		return html.toString();
	}

	public void abreRamalTelefone(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		CtrlTelefoniaDTO ctrlTelefoniaDTO = (CtrlTelefoniaDTO) document.getBean();
		if (request.getSession().getAttribute("ramalTelefone") != null) {
			ctrlTelefoniaDTO.setRamalTelefone(request.getSession().getAttribute("ramalTelefone").toString());
		}
		HTMLForm form = document.getForm("formCtrlTelefonia");
		form.clear();
		form.setValues(ctrlTelefoniaDTO);

		document.executeScript("$('#modal_ramalTelefone').modal('show');");
	}

	public void gravarRamalTelefone(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		CtrlTelefoniaDTO ctrlTelefoniaDTO = (CtrlTelefoniaDTO) document.getBean();
		if (ctrlTelefoniaDTO != null) {
			request.getSession().setAttribute("ramalTelefone", ctrlTelefoniaDTO.getRamalTelefone());
			if (ctrlTelefoniaDTO.getRamalTelefone() != null || ctrlTelefoniaDTO.getRamalTelefone().length() > 0) {
				document.alert(UtilI18N.internacionaliza(WebUtil.getUsuarioSistema(request).getLocale(), "citcorpore.comum.ramal.ramalGravadoSucesso"));
				document.executeScript("$('#modal_ramalTelefone').modal('hide');");
			}
		} else {
			// Quando o usurio esvaziou o campo o sistema retira este cliente da Thread MonitoraAsterisk, para no sobrecarreg-la!
			request.getSession().setAttribute("ramalTelefone", null);
		}
	}

	public void abrirNovaSolicitacaoTelefonia(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception{
		CtrlTelefoniaDTO ctrlTelefoniaDTO = (CtrlTelefoniaDTO) document.getBean();
		if (ctrlTelefoniaDTO!=null){
			StringBuilder html = new StringBuilder();
			html.append("<iframe height='700' id='frameSolicitacaoServico' class='iframeSemBorda' width='100%' src ='")
			.append(CITCorporeUtil.CAMINHO_SERVIDOR + request.getContextPath())
			.append("/pages/solicitacaoServicoMultiContratos/solicitacaoServicoMultiContratos.load?iframe=true&modalTelefonia=true&idEmpregado=")
			.append(ctrlTelefoniaDTO.getTelIdEmpregado()).append("'></iframe>");
			document.getElementById("conteudoframeSolicitacaoServico").setInnerHTML(html.toString());
			document.executeScript("$('#modal_INCIDENTE').modal('show');");
		}
	}

	public void abrirExecutarSolicitacaoTelefonia(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception{
		CtrlTelefoniaDTO ctrlTelefoniaDTO = (CtrlTelefoniaDTO) document.getBean();
		if (ctrlTelefoniaDTO!=null){
			this.lancarSolicitacaoRelacionadaDeVisualizacao(ctrlTelefoniaDTO.getTelIdSolicitacao(), request);
			StringBuilder html = new StringBuilder();
			html.append("<iframe height='700' id='frameSolicitacaoServico' class='iframeSemBorda' width='100%' src ='")
			.append(CITCorporeUtil.CAMINHO_SERVIDOR + request.getContextPath())
			.append("/pages/solicitacaoServicoMultiContratos/solicitacaoServicoMultiContratos.load?iframe=true&modalTelefonia=true")
			.append("&escalar=S&alterarSituacao=S&idSolicitacaoServico=")
			.append(ctrlTelefoniaDTO.getTelIdSolicitacao()).append("&idTarefa=").append(ctrlTelefoniaDTO.getTelIdItemTrabalho()).append("&acaoFluxo=E")
			.append("'></iframe>");
			document.getElementById("conteudoframeSolicitacaoServico").setInnerHTML(html.toString());
			document.executeScript("$('#modal_INCIDENTE').modal('show');");
		}
	}

	public void abrirVisualizarSolicitacaoTelefonia(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception{
		CtrlTelefoniaDTO ctrlTelefoniaDTO = (CtrlTelefoniaDTO) document.getBean();
		if (ctrlTelefoniaDTO!=null){
			this.lancarSolicitacaoRelacionadaDeVisualizacao(ctrlTelefoniaDTO.getTelIdSolicitacao(), request);
			StringBuilder html = new StringBuilder();
			html.append("<iframe height='700' id='frameSolicitacaoServico' class='iframeSemBorda' width='100%' src ='")
			.append(CITCorporeUtil.CAMINHO_SERVIDOR + request.getContextPath())
			.append("/pages/solicitacaoServicoMultiContratos/solicitacaoServicoMultiContratos.load?iframe=true&modalTelefonia=true")
			.append("&escalar=N&alterarSituacao=N&idSolicitacaoServico=")
			.append(ctrlTelefoniaDTO.getTelIdSolicitacao()).append("&idTarefa=").append(ctrlTelefoniaDTO.getTelIdItemTrabalho()).append("&editar=N&acaoFluxo=V")
			.append("'></iframe>");
			document.getElementById("conteudoframeSolicitacaoServico").setInnerHTML(html.toString());
			document.executeScript("$('#modal_INCIDENTE').modal('show');");
		}
	}

	@SuppressWarnings("unchecked")
	private void lancarSolicitacaoRelacionadaDeVisualizacao(Integer telIdSolicitacao, HttpServletRequest request) throws Exception {
		if(telIdSolicitacao!=null&&ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.TELEFONIA_LANCAR_SOLICITACAO_REQUISICAO_INFORMACAO, "N").equalsIgnoreCase("S")){
			UsuarioDTO usuario = WebUtil.getUsuario(request);
			if (usuario != null&&usuario.getIdUsuario() != null&&usuario.getIdEmpregado() != null) {
				SolicitacaoServicoService solicitacaoServicoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, WebUtil.getUsuarioSistema(request));

				//Restaura a solicitacao
	    		SolicitacaoServicoDTO solicitacaoServicoModelo = solicitacaoServicoService.restoreAll(telIdSolicitacao);

	    		//Cria uma nova solicitacao com base nas informacoes da solicitacao de servico restaurada
				SolicitacaoServicoDTO solicitacaoServicoNova = new SolicitacaoServicoDTO();

				solicitacaoServicoNova.setIdOrigem(solicitacaoServicoModelo.getIdOrigem());
				solicitacaoServicoNova.setIdGrupoAtual(solicitacaoServicoModelo.getIdGrupo());
				solicitacaoServicoNova.setIdStatus(ServiceRequestStatus.IN_PROGRESS.getId());
				solicitacaoServicoNova.setRegistroexecucao("");

				solicitacaoServicoNova.setEmailcontato(solicitacaoServicoModelo.getEmailcontato());
				solicitacaoServicoNova.setEmailResponsavel(solicitacaoServicoModelo.getEmailResponsavel());
				solicitacaoServicoNova.setIdUnidade(solicitacaoServicoModelo.getIdUnidade());
				solicitacaoServicoNova.setIdLocalidade(solicitacaoServicoModelo.getIdLocalidade());

				EmpregadoService empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, WebUtil.getUsuarioSistema(request));
				EmpregadoDTO empregadoDto = empregadoService.restoreByIdEmpregado(solicitacaoServicoModelo.getIdSolicitante());

				solicitacaoServicoNova.setIdSolicitante(empregadoDto.getIdEmpregado());
				solicitacaoServicoNova.setIdUsuarioResponsavelAtual(usuario.getIdUsuario());
				solicitacaoServicoNova.setNomeUsuarioResponsavelAtual(usuario.getNomeUsuario());
				solicitacaoServicoNova.setUsuarioDto(usuario);
				solicitacaoServicoNova.setRegistradoPor(usuario.getNomeUsuario());
				solicitacaoServicoNova.setNomecontato(empregadoDto.getNome());
				solicitacaoServicoNova.setEmailcontato(empregadoDto.getEmail());
				solicitacaoServicoNova.setTelefonecontato(empregadoDto.getTelefone());

				String strIdServico = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.TELEFONIA_ID_SERVICO_SOLICITACAO_REQUISICAO_INFORMACAO, "0");
				Integer idServico = strIdServico.length()>0?Integer.parseInt(strIdServico):0;
				ServicoService servicoService = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);
				ServicoDTO servicoDTO = new ServicoDTO();
				servicoDTO.setIdServico(idServico);
				servicoDTO = servicoService.restore(servicoDTO);

				ServicoContratoService servicoContratoService = (ServicoContratoService) ServiceLocator.getInstance().getService(ServicoContratoService.class, null);
				ArrayList<ServicoContratoDTO> listaServicoContrato = (ArrayList<ServicoContratoDTO>) servicoContratoService.findByIdServico(idServico);
				ServicoContratoDTO servicoContratoDTO = null;
				if (listaServicoContrato!=null&&listaServicoContrato.size()>0){
					servicoContratoDTO = listaServicoContrato.get(0);
				}

				if (servicoDTO!=null&&servicoDTO.getIdServico().intValue()>0&&servicoContratoDTO!=null&&servicoContratoDTO.getIdServico().intValue()>0){

					solicitacaoServicoNova.setIdContrato(servicoContratoDTO.getIdContrato());
					solicitacaoServicoNova.setIdServico(servicoContratoDTO.getIdServico());
					solicitacaoServicoNova.setIdTipoDemandaServico(servicoDTO.getIdTipoDemandaServico());
					solicitacaoServicoNova.setImpacto(solicitacaoServicoModelo.getImpacto());
					solicitacaoServicoNova.setUrgencia(solicitacaoServicoModelo.getUrgencia());
					solicitacaoServicoNova.setEnviaEmailAcoes("N");
					solicitacaoServicoNova.setEnviaEmailCriacao("N");
					solicitacaoServicoNova.setEnviaEmailFinalizacao("N");
					solicitacaoServicoNova.setIdSolicitacaoRelacionada(solicitacaoServicoModelo.getIdSolicitacaoServico());

					solicitacaoServicoNova.setDescricao(solicitacaoServicoModelo.getDescricao());

					// Cria a solicitacao
					solicitacaoServicoNova = (SolicitacaoServicoDTO) solicitacaoServicoService.create(solicitacaoServicoNova);

					// Valida se a solicitacao foi criada
					if (solicitacaoServicoNova != null) {

						// Fecha a solicitacao
						solicitacaoServicoNova.setAcaoFluxo(Enumerated.ACTION_EXECUTE);
						solicitacaoServicoNova.setIdStatus(ServiceRequestStatus.CLOSED.getId());

						String locale = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.IDIOMAPADRAO, UtilI18N.PORTUGUESE_SIGLA);

						// Mensagem resposta do fechamento da solicitacao
						solicitacaoServicoNova.setResposta(UtilI18N.internacionaliza(locale.toLowerCase(), "solicitacaoServico.requisicaoInformacaoSolicitacaoExistente"));

						//Lista as tarefas e encerra a mesma
						Collection<ExecucaoSolicitacaoDTO> colExecucao = new ExecucaoSolicitacaoDao().listByIdSolicitacao(solicitacaoServicoNova.getIdSolicitacaoServico());
						if (colExecucao != null) {
							for (ExecucaoSolicitacaoDTO execucaoSolicitacaoDto : colExecucao) {
								execucaoSolicitacaoDto.getIdInstanciaFluxo();
								ItemTrabalhoFluxoDao itemTrabalhoFluxoDao = new ItemTrabalhoFluxoDao();
								Collection<ItemTrabalhoFluxoDTO> colItens = itemTrabalhoFluxoDao.findDisponiveisByIdInstancia(execucaoSolicitacaoDto.getIdInstanciaFluxo());
								if (colItens != null) {
									for (ItemTrabalhoFluxoDTO itemTrabalhoFluxoDto : colItens) {
										ItemTrabalho itemTrabalho = ItemTrabalho.getItemTrabalho(itemTrabalhoFluxoDto.getIdItemTrabalho());
										solicitacaoServicoNova.setIdTarefa(itemTrabalho.getIdItemTrabalho());
									}
								}
							}
						}
						solicitacaoServicoNova.setUsuarioDto(usuario);
						//Fechando a solicitacao
						solicitacaoServicoService.updateInfo(solicitacaoServicoNova);
					}
				}
			}
		}
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	@Override
	public Class getBeanClass() {
		return CtrlTelefoniaDTO.class;
	}
}