package br.com.centralit.citcorpore.ajaxForms;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.quartz.CronExpression;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.EvmCronDTO;
import br.com.centralit.citcorpore.negocio.EvmCronService;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;

/**
 * Classe Action da tela de Manter Expresses Cron.
 * 
 * @author valdoilo.damasceno
 * @version 1.0
 * @created 21-out-2014 16:48:58
 */
public class EvmCron extends AjaxFormAction {

	private EvmCronService evmCronService;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		EvmCronDTO evmCronDto = (EvmCronDTO) document.getBean();

		populaSelects(document, request, response);

		HTMLForm form = CITCorporeUtil.limparFormulario(document);

		form.setValues(evmCronDto);

	}

	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		EvmCronDTO evmCronDto = (EvmCronDTO) document.getBean();

		this.montaExpressaoCron(evmCronDto);

		if (!this.getEvmCronService().cronExiste(evmCronDto)) {

			if (this.validaExpressaoCron(document, request, evmCronDto)) {

				if (evmCronDto != null && evmCronDto.getIdCron() != null) {

					evmCronDto.setIdUsuarioModificador(WebUtil.getUsuario(request).getIdUsuario());
					evmCronDto.setDataHoraUltimaAlteracao(UtilDatas.getDataAtual());

					this.getEvmCronService().update(evmCronDto);

					document.alert(UtilI18N.internacionaliza(request, "MSG06"));
				} else if(evmCronDto!=null){

					evmCronDto.setIdUsuarioCriador(WebUtil.getUsuario(request).getIdUsuario());
					evmCronDto.setDataHoraInicio(UtilDatas.getDataAtual());

					this.getEvmCronService().create(evmCronDto);

					document.alert(UtilI18N.internacionaliza(request, "MSG05"));
				}

				CITCorporeUtil.limparFormulario(document);
			}
		} else {
			document.alert(UtilI18N.internacionaliza(request, "evm.nome.expressao.duplicado"));

			restore(document, request, response);
		}

	}

	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		EvmCronDTO evmCronDto = (EvmCronDTO) document.getBean();

		if (evmCronDto != null && evmCronDto.getIdCron() != null) {
			evmCronDto = this.getEvmCronService().restoreWithInfoAudit(evmCronDto);
		}

		if(evmCronDto!=null){
		setaPropriedadesExpressaoCron(evmCronDto);

		document.getElementById("divCriador").setVisible(true);

		document.getElementById("criadopor").setInnerHTML(evmCronDto.getNomeUsuarioCriador());
		document.getElementById("datahoracriacao").setInnerHTML(UtilDatas.convertDateToString(TipoDate.TIMESTAMP_DEFAULT, evmCronDto.getDataHoraInicio(), WebUtil.getLanguage(request)));

		if (evmCronDto.getNomeUsuarioModificador() != null && StringUtils.isNotBlank(evmCronDto.getNomeUsuarioModificador())) {
			document.getElementById("divModificador").setVisible(true);

			document.getElementById("alteradopor").setInnerHTML(evmCronDto.getNomeUsuarioModificador());
			document.getElementById("datahoraalteracao").setInnerHTML(UtilDatas.convertDateToString(TipoDate.TIMESTAMP_DEFAULT, evmCronDto.getDataHoraUltimaAlteracao(), WebUtil.getLanguage(request)));
		}

		HTMLForm form = CITCorporeUtil.limparFormulario(document);

		form.setValues(evmCronDto);
	}
	}

	/**
	 * Realiza a excluso lgica do registro, caso ele no possua referncia.
	 * 
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author valdoilo.damasceno S
	 * @since 21.10.2014
	 */
	public void delete(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		EvmCronDTO evmCronDto = (EvmCronDTO) document.getBean();

		if (!this.getEvmCronService().possuiRelacionamento(evmCronDto)) {
			evmCronDto.setDataHoraFim(UtilDatas.getDataAtual());
			evmCronDto.setIdUsuarioModificador(WebUtil.getUsuario(request).getIdUsuario());
			evmCronDto.setDataHoraUltimaAlteracao(UtilDatas.getDataAtual());

			this.getEvmCronService().updateNotNull(evmCronDto);
			document.alert(UtilI18N.internacionaliza(request, "MSG07"));

			CITCorporeUtil.limparFormulario(document);
		} else {
			document.alert(UtilI18N.internacionaliza(request, "MSG08"));
		}
	}

	/**
	 * Popula Combos necessrias para o cadastro de expresses cron.
	 * 
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * 
	 * @author flavio.santana
	 */
	public void populaSelects(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLSelect comboAno = document.getSelectById("ano");
		comboAno.addOption("*", UtilI18N.internacionaliza(request, "citcorpore.comum.todos"));
		for (Integer ano = Calendar.getInstance().get(Calendar.YEAR) - 1; ano <= Calendar.getInstance().get(Calendar.YEAR) + 50; ano++) {
			comboAno.addOption(ano.toString(), ano.toString());
		}

		HTMLSelect comboDiaDaSemana = document.getSelectById("diaDaSemana");
		comboDiaDaSemana.addOption("?", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
		comboDiaDaSemana.addOption("*", UtilI18N.internacionaliza(request, "citcorpore.comum.todos"));
		comboDiaDaSemana.addOption("2", UtilI18N.internacionaliza(request, "citcorpore.texto.diaSemana.segundaFeira"));
		comboDiaDaSemana.addOption("3", UtilI18N.internacionaliza(request, "citcorpore.texto.diaSemana.tercaFeira"));
		comboDiaDaSemana.addOption("4", UtilI18N.internacionaliza(request, "citcorpore.texto.diaSemana.quartaFeira"));
		comboDiaDaSemana.addOption("5", UtilI18N.internacionaliza(request, "citcorpore.texto.diaSemana.quintaFeira"));
		comboDiaDaSemana.addOption("6", UtilI18N.internacionaliza(request, "citcorpore.texto.diaSemana.sextaFeira"));
		comboDiaDaSemana.addOption("7", UtilI18N.internacionaliza(request, "citcorpore.texto.diaSemana.sabado"));
		comboDiaDaSemana.addOption("1", UtilI18N.internacionaliza(request, "citcorpore.texto.diaSemana.domingo"));

		HTMLSelect comboDiaDoMes = document.getSelectById("diaDoMes");
		comboDiaDoMes.addOption("?", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
		comboDiaDoMes.addOption("*", UtilI18N.internacionaliza(request, "citcorpore.comum.todos"));
		for (Integer dia = 1; dia <= 31; dia++) {
			comboDiaDoMes.addOption(dia.toString(), dia.toString());
		}

		HTMLSelect comboHoras = document.getSelectById("hora");
		comboHoras.addOption("*", UtilI18N.internacionaliza(request, "citcorpore.comum.todas"));
		comboHoras.addOption("0", "0");
		for (Integer hora = 1; hora <= 23; hora++) {
			comboHoras.addOption("*/" + hora.toString(), hora.toString());
		}

		HTMLSelect comboMes = document.getSelectById("mes");
		comboMes.addOption("*", UtilI18N.internacionaliza(request, "citcorpore.comum.todos"));
		comboMes.addOption("1", UtilI18N.internacionaliza(request, "citcorpore.texto.mes.janeiro"));
		comboMes.addOption("2", UtilI18N.internacionaliza(request, "citcorpore.texto.mes.fevereiro"));
		comboMes.addOption("3", UtilI18N.internacionaliza(request, "citcorpore.texto.mes.marco"));
		comboMes.addOption("4", UtilI18N.internacionaliza(request, "citcorpore.texto.mes.abril"));
		comboMes.addOption("5", UtilI18N.internacionaliza(request, "citcorpore.texto.mes.maio"));
		comboMes.addOption("6", UtilI18N.internacionaliza(request, "citcorpore.texto.mes.junho"));
		comboMes.addOption("7", UtilI18N.internacionaliza(request, "citcorpore.texto.mes.julho"));
		comboMes.addOption("8", UtilI18N.internacionaliza(request, "citcorpore.texto.mes.agosto"));
		comboMes.addOption("9", UtilI18N.internacionaliza(request, "citcorpore.texto.mes.setembro"));
		comboMes.addOption("10", UtilI18N.internacionaliza(request, "citcorpore.texto.mes.outubro"));
		comboMes.addOption("11", UtilI18N.internacionaliza(request, "citcorpore.texto.mes.novembro"));
		comboMes.addOption("12", UtilI18N.internacionaliza(request, "citcorpore.texto.mes.dezembro"));

		HTMLSelect comboMinutos = document.getSelectById("minuto");
		comboMinutos.addOption("*", UtilI18N.internacionaliza(request, "citcorpore.comum.todos"));
		comboMinutos.addOption("0", "0");
		for (Integer minuto = 1; minuto <= 59; minuto++) {
			comboMinutos.addOption("*/" + minuto.toString(), minuto.toString());
		}

		HTMLSelect comboSegundos = document.getSelectById("segundo");
		comboSegundos.addOption("*", UtilI18N.internacionaliza(request, "citcorpore.comum.todos"));
		for (Integer segundo = 0; segundo <= 59; segundo++) {
			comboSegundos.addOption(segundo.toString(), segundo.toString());
		}

		HTMLSelect comboSituacao = document.getSelectById("situacao");
		comboSituacao.addOption("A", UtilI18N.internacionaliza(request, "citcorpore.comum.ativo"));
		comboSituacao.addOption("I", UtilI18N.internacionaliza(request, "citcorpore.comum.inativo"));
		comboSituacao.setSelectedIndex(1);
	}

	/**
	 * Cria a expresso Cron  partir dos valores selecionados em tela.
	 * 
	 * @param evmCronDto
	 * @author euler.ramos
	 */
	public void montaExpressaoCron(EvmCronDTO evmCronDto) {
		String expressaoCron = new String();

		if (evmCronDto.getSegundo() != null) {
			expressaoCron += evmCronDto.getSegundo() + " ";
		}
		if (evmCronDto.getMinuto() != null) {
			expressaoCron += evmCronDto.getMinuto() + " ";
		}
		if (evmCronDto.getHora() != null) {
			expressaoCron += evmCronDto.getHora() + " ";
		}
		if (evmCronDto.getDiaDoMes() != null) {
			expressaoCron += evmCronDto.getDiaDoMes() + " ";
		}
		if (evmCronDto.getMes() != null) {
			expressaoCron += evmCronDto.getMes() + " ";
		}
		if (evmCronDto.getDiaDaSemana() != null) {
			expressaoCron += evmCronDto.getDiaDaSemana() + " ";
		}
		if (evmCronDto.getAno() != null) {
			expressaoCron += evmCronDto.getAno();
		}

		evmCronDto.setExpressao(expressaoCron);
	}

	/**
	 * Valida os valores selecionados pelo usurio em tela, verificando se atende a sintaxe Cron.
	 * 
	 * @param document
	 * @param request
	 * @param evmCronDTO
	 * @return boolean
	 * 
	 * @author euler.ramos
	 */
	public boolean validaExpressaoCron(DocumentHTML document, HttpServletRequest request, EvmCronDTO evmCronDTO) {
		if ((evmCronDTO.getDiaDoMes() != null) && (evmCronDTO.getDiaDaSemana() != null)) {
			// '?' can only be specfied for Day-of-Month -OR- Day-of-Week.
			if ((evmCronDTO.getDiaDoMes().equalsIgnoreCase("?")) && (evmCronDTO.getDiaDaSemana().equalsIgnoreCase("?"))) {
				document.alert(UtilI18N.internacionaliza(request, "processamentoBatch.aoMenosDiaMesOuDiaSemana"));
				return false;
			}
			// Somente o Dia do ms ou dia da semana deve ser informado.
			// Support for specifying both a day-of-week AND a day-of-month parameter is not implemented.
			if ((!evmCronDTO.getDiaDoMes().equalsIgnoreCase("?")) && (!evmCronDTO.getDiaDaSemana().equalsIgnoreCase("?"))) {
				document.alert(UtilI18N.internacionaliza(request, "processamentoBatch.diaMesdiaSemanaMesmoTempo"));
				return false;
			}
		}
		// Verificando a expresso cron para saber se define um agendamento passvel de ser executado.
		if ((evmCronDTO.getExpressao() != null) && (evmCronDTO.getExpressao().length() > 0)) {
			Date dtProximaEx = this.proximaExecucao(evmCronDTO.getExpressao());
			if (dtProximaEx == null) {
				document.alert(UtilI18N.internacionaliza(request, "processamentoBatch.naoSeraExecutado"));
				return false;
			}
		} else {
			document.alert(UtilI18N.internacionaliza(request, "processamentoBatch.expressaoCronInvalida"));
			return false;
		}
		return true;
	}

	/**
	 * Retorna a prxima data de execuo definida na expresso Cron.
	 * 
	 * @author euler.ramos
	 */
	public Date proximaExecucao(String expressaoCron) {
		try {
			Date data = new Date();
			CronExpression cronExpression = new CronExpression(expressaoCron);
			return cronExpression.getNextValidTimeAfter(data);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		return null;
	}

	/**
	 * Realiza o parse da expresso cron (String) para os campos em tela.
	 * 
	 * @param evmCronDto
	 * @author euler.ramos
	 */
	public void setaPropriedadesExpressaoCron(EvmCronDTO evmCronDto) {
		if (evmCronDto.getExpressao() != null && !evmCronDto.getExpressao().isEmpty()) {
			String expressaoCron = evmCronDto.getExpressao().trim();
			expressaoCron = expressaoCron.replaceAll("  ", " ");
			String partes[] = expressaoCron.split(" ");
			if (partes.length > 5) {
				evmCronDto.setSegundo(partes[0]);
				evmCronDto.setMinuto(partes[1]);
				evmCronDto.setHora(partes[2]);
				evmCronDto.setDiaDoMes(partes[3]);
				evmCronDto.setMes(partes[4]);
				evmCronDto.setDiaDaSemana(partes[5]);
			}
			if (partes.length > 6) {
				evmCronDto.setAno(partes[6]);
			}
		}
	}

	@Override
	public Class<EvmCronDTO> getBeanClass() {
		return EvmCronDTO.class;
	}

	/**
	 * Fbrica de EvmCronService.
	 * 
	 * @return evmCronService
	 * @throws ServiceException
	 * @throws Exception
	 * @author valdoilo.damasceno
	 * @since 01.10.2014
	 */
	public EvmCronService getEvmCronService() throws ServiceException, Exception {

		if (evmCronService == null) {
			evmCronService = (EvmCronService) ServiceLocator.getInstance().getService(EvmCronService.class, null);
		}

		return evmCronService;
	}
}
