package br.com.centralit.citcorpore.ajaxForms;

import java.sql.Timestamp;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.EvmConexaoDTO;
import br.com.centralit.citcorpore.bean.EvmCronDTO;
import br.com.centralit.citcorpore.bean.EvmInventoryConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.EvmInventoryConfiguracaoTelaDTO;
import br.com.centralit.citcorpore.bean.FormulaDTO;
import br.com.centralit.citcorpore.negocio.EvmConexaoService;
import br.com.centralit.citcorpore.negocio.EvmCronService;
import br.com.centralit.citcorpore.negocio.EvmInventoryConfiguracaoService;
import br.com.centralit.citcorpore.negocio.FormulaService;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.IPInventario;
import br.com.centralit.citcorpore.util.ValidarScript;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.centralit.enums.EvmEnumerados;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;

/**
 * 
 * @author thyen.chang
 *
 */
public class EvmInventoryConfiguracao extends AjaxFormAction {

	private EvmInventoryConfiguracaoService evmInventoryConfiguracaoService;
	
	private Timestamp dataHoraInicioConexao;	
	public Timestamp getDataHoraInicioConexao() { return dataHoraInicioConexao; }
	public void setDataHoraInicioConexao(Timestamp dataHoraInicioConexao) { this.dataHoraInicioConexao = dataHoraInicioConexao; }

	public void atualizarConfiguracaoInventory(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		EvmInventoryConfiguracaoTelaDTO telaDTO = (EvmInventoryConfiguracaoTelaDTO) document.getBean();

		EvmInventoryConfiguracaoService evmInventoryConfiguracaoService = this.getEvmInventoryConfiguracaoService();
		String retorno = evmInventoryConfiguracaoService.testarConexaoInventory(IPInventario.montaUrlWs(telaDTO, "atualizarConfiguracaoInventory"));
		/*if (retorno.equals("OK")) {
			document.alert(UtilI18N.internacionaliza(request, "evm.inventory.configuracao.atualizarConfiguracaoInventory.sucesso"));
		} else {
			document.alert(UtilI18N.internacionaliza(request, "evm.inventory.configuracao.atualizarConfiguracaoInventory.falha"));
		}*/
	}

	public void carregaComboEvmCron(DocumentHTML document) throws Exception {
		EvmCronService evmCronService = (EvmCronService) ServiceLocator.getInstance().getService(EvmCronService.class, null);
		Collection<EvmCronDTO> listEvmCron = evmCronService.listarExpressoesCronAtivas();
		HTMLSelect comboTipoFaixaIp = document.getSelectById("idCron");
		comboTipoFaixaIp.removeAllOptions();
		if (listEvmCron != null) {
			for (EvmCronDTO evmCronDTO : listEvmCron) {
				comboTipoFaixaIp.addOption(evmCronDTO.getIdCron().toString(), evmCronDTO.getNome());
			}
		}
	}

	public void carregaComboStatus(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect comboStatus = document.getSelectById("status");
		comboStatus.removeAllOptions();
		for (EvmEnumerados.StatusInventory status : EvmEnumerados.StatusInventory.values()) {
			comboStatus.addOption(status.name(), UtilI18N.internacionaliza(request, status.getChave()));
		}
	}

	public void carregaComboTipoFaixaIp(DocumentHTML document) throws Exception {
		HTMLSelect comboTipoFaixaIp = document.getSelectById("tipofaixaip");
		comboTipoFaixaIp.removeAllOptions();
		for (EvmEnumerados.TiposFaixaIp tipo : EvmEnumerados.TiposFaixaIp.values()) {
			comboTipoFaixaIp.addOption(tipo.getValor().toString(), tipo.geTipoFaixaIp());
		}
	}

	public void delete(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		EvmInventoryConfiguracaoTelaDTO telaDTO = (EvmInventoryConfiguracaoTelaDTO) document.getBean();
		EvmConexaoDTO conexaoDTO = new EvmConexaoDTO();
		EvmInventoryConfiguracaoDTO configuracaoDTO = new EvmInventoryConfiguracaoDTO();

		telaDTO.setIdUsuarioModificador(WebUtil.getUsuario(request).getIdUsuario());
		telaDTO.setDataHoraUltimaAlteracao(new Timestamp(UtilDatas.parseDateTimeStringToDate(UtilDatas.getCurrentDateTimeString(request), request).getMillis()));
		
		if(conexaoDTO.getIdConexao() != null)
			this.setDataHoraInicioConexao(telaDTO.getDataHoraInicio());
		
		try {
			Reflexao.copyPropertyValues(telaDTO, conexaoDTO);
			Reflexao.copyPropertyValues(telaDTO, configuracaoDTO);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		if (conexaoDTO.getIdConexao() != null)
			conexaoDTO.setDataHoraInicio(this.getDataHoraInicioConexao());

		EvmConexaoService conexaoService = (EvmConexaoService) ServiceLocator.getInstance().getService(EvmConexaoService.class, null);
		EvmInventoryConfiguracaoService configuracaoService = this.getEvmInventoryConfiguracaoService();

		conexaoDTO = conexaoService.restore(conexaoDTO);
		conexaoDTO.setDataHoraFim(new Timestamp(UtilDatas.parseDateTimeStringToDate(UtilDatas.getCurrentDateTimeString(request), request).getMillis()));
		conexaoService.update(conexaoDTO);

		configuracaoDTO = configuracaoService.restore(configuracaoDTO);
		configuracaoDTO.setDataHoraFim(new Timestamp(UtilDatas.parseDateTimeStringToDate(UtilDatas.getCurrentDateTimeString(request), request).getMillis()));
		configuracaoService.update(configuracaoDTO);

		document.executeScript("limpar();");
		document.executeScript("JANELA_AGUARDE_MENU.hide();");
		document.alert(UtilI18N.internacionaliza(request, "MSG07"));

		CITCorporeUtil.limparFormulario(document);

	}

	@Override
	public Class<EvmInventoryConfiguracaoTelaDTO> getBeanClass() {
		return EvmInventoryConfiguracaoTelaDTO.class;
	}

	public String getDestinoInventarioSugerido(HttpServletRequest request) {
		String scheme = request.getScheme();
		String serverName = request.getServerName();
		int portNumber = request.getServerPort();
		String contextPath = request.getContextPath();

		StringBuilder destinoInventarioSugerido = new StringBuilder();
		if (scheme != null && serverName != null && contextPath != null) {
			destinoInventarioSugerido.append(scheme);
			destinoInventarioSugerido.append("://");
			destinoInventarioSugerido.append(serverName);
			destinoInventarioSugerido.append(":");
			destinoInventarioSugerido.append(portNumber);
			destinoInventarioSugerido.append(contextPath);
			destinoInventarioSugerido.append("/citsmartInventory/recebeInventario");
		}

		return destinoInventarioSugerido.toString();
	}

	private EvmInventoryConfiguracaoService getEvmInventoryConfiguracaoService() throws ServiceException {
		if (evmInventoryConfiguracaoService == null) {
			evmInventoryConfiguracaoService = (EvmInventoryConfiguracaoService) ServiceLocator.getInstance().getService(EvmInventoryConfiguracaoService.class, null);
		}
		return evmInventoryConfiguracaoService;
	}

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		/**
		 * Carrega combo Status
		 */
		carregaComboStatus(document, request);
		/**
		 * Carrega combo Tipo Faixa Ip
		 */
		carregaComboTipoFaixaIp(document);
		/**
		 * Carrega combo Intervalo a partir do EvmCronDTO
		 */
		carregaComboEvmCron(document);
		/**
		 * Preenche campo contexto com o padro
		 */
		document.getElementById("contexto").setValue("citsmartinventory");
		document.getElementById("destinoInventario").setValue(getDestinoInventarioSugerido(request));
	}

	public void restore(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		EvmInventoryConfiguracaoTelaDTO telaDTO = (EvmInventoryConfiguracaoTelaDTO) document.getBean();
		telaDTO.setDataHoraInicio(new Timestamp(UtilDatas.parseDateTimeStringToDate(UtilDatas.getCurrentDateTimeString(request), request).getMillis()));
		EvmInventoryConfiguracaoDTO configuracaoDTO = new EvmInventoryConfiguracaoDTO();
		try {
			Reflexao.copyPropertyValues(telaDTO, configuracaoDTO);
		} catch (Exception e) {
			e.printStackTrace();
		}
		EvmInventoryConfiguracaoService configuracaoService = (EvmInventoryConfiguracaoService) ServiceLocator.getInstance().getService(EvmInventoryConfiguracaoService.class, null);
		configuracaoDTO = configuracaoService.findConfiguracaoById(configuracaoDTO.getIdConfiguracao());

		EvmConexaoService conexaoService = (EvmConexaoService) ServiceLocator.getInstance().getService(EvmConexaoService.class, null);
		EvmConexaoDTO evmConexaoDto = new EvmConexaoDTO();
		evmConexaoDto.setIdConexao(configuracaoDTO.getIdConexao());

		if (evmConexaoDto != null && evmConexaoDto.getIdConexao() != null) {
			evmConexaoDto = conexaoService.restoreWithInfoAudit(evmConexaoDto);
		}
		document.getElementById("h4InfoAudit").setVisible(true);

		document.getElementById("divCriador").setVisible(true);

		document.getElementById("criadopor").setInnerHTML(evmConexaoDto.getNomeUsuarioCriador());
		//document.getElementById("datahoracriacao").setInnerHTML(UtilDatas.convertDateToString(TipoDate.TIMESTAMP_DEFAULT, evmConexaoDto.getDataHoraInicio(), WebUtil.getLanguage(request)));
		document.getElementById("datahoracriacao").setInnerHTML(UtilDatas.parseDateTimeToString(evmConexaoDto.getDataHoraInicio(), request));

		if (evmConexaoDto.getNomeUsuarioModificador() != null && StringUtils.isNotBlank(evmConexaoDto.getNomeUsuarioModificador())) {
			document.getElementById("divModificador").setVisible(true);

			document.getElementById("alteradopor").setInnerHTML(evmConexaoDto.getNomeUsuarioModificador());
			//document.getElementById("datahoraalteracao").setInnerHTML(UtilDatas.convertDateToString(TipoDate.TIMESTAMP_DEFAULT, evmConexaoDto.getDataHoraUltimaAlteracao(), WebUtil.getLanguage(request)));
			document.getElementById("datahoraalteracao").setInnerHTML(UtilDatas.parseDateTimeToString(evmConexaoDto.getDataHoraUltimaAlteracao(), request));
		}

		HTMLForm form = CITCorporeUtil.limparFormulario(document);

		telaDTO = new EvmInventoryConfiguracaoTelaDTO();

		try {
			Reflexao.copyPropertyValues(configuracaoDTO, telaDTO);
			Reflexao.copyPropertyValues(evmConexaoDto, telaDTO);
		} catch (Exception e) {
			e.printStackTrace();
		}

		FormulaService formulaService = (FormulaService) ServiceLocator.getInstance().getService(FormulaService.class, null);
		FormulaDTO formulaDTO = formulaService.findById(configuracaoDTO.getIdFormula());
		if (formulaDTO != null && formulaDTO.getNome() != null)
			document.getElementById("nomeFormula").setValue(formulaDTO.getNome());

		if (telaDTO.getIdEvmConexaoEventMonitor() != null) {
			document.executeScript("$('#adicionaConexaoEVM').prop('checked', true);");
			document.executeScript("$('.evm-conexao-event-monitor').removeClass('hide');");
		} else {
			document.executeScript("$('#adicionaConexaoEVM').prop('checked', false);");
			document.executeScript("$('.evm-conexao-event-monitor').addClass('hide');");
		}

		if (telaDTO.getIgnorarIcsInventariados() != null && telaDTO.getIgnorarIcsInventariados().equalsIgnoreCase("S")) {
			document.executeScript("$('#ignorarIcsInventariados').prop('checked', true);");
			document.executeScript("$('.evm-configuracao-ignorar-maquinas-inventariadas').removeClass('hide');");
		} else {
			document.executeScript("$('#ignorarIcsInventariados').prop('checked', false);");
			document.executeScript("$('.evm-configuracao-ignorar-maquinas-inventariadas').addClass('hide');");
		}

		form.setValues(telaDTO);

		/**
		 * Por algum motivo o nmero da porta no  setado no setValues. Setando
		 * na mo
		 */
		if (document.getElementById("porta").getValue() == null) {
			document.getElementById("porta").setValue(telaDTO.getPorta() != null ? telaDTO.getPorta().toString() : "");
		}
		document.executeScript("JANELA_AGUARDE_MENU.hide();");
	}

	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		EvmInventoryConfiguracaoTelaDTO telaDTO = (EvmInventoryConfiguracaoTelaDTO) document.getBean();
		EvmConexaoDTO evmConexao = new EvmConexaoDTO();

		evmConexao.setFerramenta(EvmEnumerados.Ferramentas.CITSMART_INVENTORY.name());
		evmConexao.setProtocolo(EvmEnumerados.Protocolo.HTTP.name());

		if (telaDTO.getIdConexao() != null)
			this.setDataHoraInicioConexao(telaDTO.getDataHoraInicio());

		telaDTO.setDataHoraInicio(new Timestamp(UtilDatas.parseDateTimeStringToDate(UtilDatas.getCurrentDateTimeString(request), request).getMillis()));

		EvmInventoryConfiguracaoDTO configuracaoDTO = new EvmInventoryConfiguracaoDTO();
		try {
			Reflexao.copyPropertyValues(telaDTO, evmConexao);
			Reflexao.copyPropertyValues(telaDTO, configuracaoDTO);
		} catch (Exception e) {
			e.printStackTrace();
		}

		if (evmConexao.getIdConexao() != null) {
			evmConexao.setDataHoraInicio(this.getDataHoraInicioConexao());
		}

		FormulaService formulaService = (FormulaService) ServiceLocator.getInstance().getService(FormulaService.class, null);
		if (configuracaoDTO.getIdFormula() != null) {
			FormulaDTO formulaDTO = formulaService.findById(configuracaoDTO.getIdFormula());
			ValidarScript validarScript = new ValidarScript(document, request, response);
			if (!validarScript.validar(formulaDTO.getConteudo())) {
				document.alert(validarScript.getMensagemResumida());
				return;
			}
			configuracaoDTO.setConteudoFormula(formulaDTO.getConteudo());
		}

		/**
		 * Recupera o EvmCron e seta a expresso na configurao para gravar no
		 * banco
		 */
		EvmCronService evmCronService = (EvmCronService) ServiceLocator.getInstance().getService(EvmCronService.class, null);
		EvmCronDTO evmCronDTO = new EvmCronDTO();
		evmCronDTO.setIdCron(configuracaoDTO.getIdCron());
		evmCronDTO = evmCronService.restore(evmCronDTO);
		configuracaoDTO.setExpressaoCron(evmCronDTO.getExpressao());

		EvmInventoryConfiguracaoService configuracaoService = this.getEvmInventoryConfiguracaoService();

		if (configuracaoDTO.getIgnorarIcsInventariados() == null || configuracaoDTO.getIgnorarIcsInventariados().isEmpty()) {
			configuracaoDTO.setIgnorarIcsInventariados("N");
		}

		String retorno = configuracaoService.salvarConfiguracao(configuracaoDTO, evmConexao, WebUtil.getUsuario(request));
		if (retorno.equals("MSG05") || retorno.equals("MSG06")) {
			atualizarConfiguracaoInventory(document, request, response);
			CITCorporeUtil.limparFormulario(document);
			document.executeScript("limpar();");
		}

		document.executeScript("limpar();");
		document.executeScript("JANELA_AGUARDE_MENU.hide();");
		document.alert(UtilI18N.internacionaliza(request, retorno));
	}

	public void testarConexao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		EvmInventoryConfiguracaoTelaDTO telaDTO = (EvmInventoryConfiguracaoTelaDTO) document.getBean();

		EvmInventoryConfiguracaoService evmInventoryConfiguracaoService = this.getEvmInventoryConfiguracaoService();
		String retorno = evmInventoryConfiguracaoService.testarConexaoInventory(IPInventario.montaUrlWs(telaDTO, "verificarDisponibilidade"));
		if (retorno.equals("OK")) {
			document.alert(UtilI18N.internacionaliza(request, "evm.inventory.configuracao.conexaosucedida"));
		} else {
			document.alert(UtilI18N.internacionaliza(request, "evm.inventory.configuracao.conexaofalha"));
		}
	}
}
