package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.EvmConexaoDTO;
import br.com.centralit.citcorpore.bean.EvmInventoryConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.EvmStatusInventoryDTO;
import br.com.centralit.citcorpore.bean.ItemConfiguracaoIpDTO;
import br.com.centralit.citcorpore.negocio.EvmConexaoService;
import br.com.centralit.citcorpore.negocio.EvmInventoryConfiguracaoService;
import br.com.centralit.citcorpore.negocio.EvmStatusInventoryService;
import br.com.centralit.citcorpore.negocio.ValorService;
import br.com.centralit.citcorpore.util.CronExpression;
import br.com.centralit.citcorpore.util.IPInventario;
import br.com.centralit.enums.EvmEnumerados;
import br.com.centralit.enums.EvmEnumerados.Ferramentas;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilI18N;

/**
 * Classe para exibir o status dos itens da faixa de IP do Citsmart Inventory
 *
 * @author thyen.chang
 * @since 18/02/2015
 */
public class EvmStatusInventory extends AjaxFormAction {

	private EvmStatusInventoryService evmStatusInventoryService;

	private EvmInventoryConfiguracaoService evmInventoryConfiguracaoService;

	private EvmConexaoService evmConexaoService;

	private ValorService valorService;

	private static List<IPInventario> listaIps = new ArrayList<IPInventario>();

	private static final Integer paginacao = 100;

	private static Integer pagina = 1;

	private static Integer quantidadePaginas = 1;

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		carregaComboInventory(document, request);
	}

	public void carregaComboInventory(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect inventory = document.getSelectById("inventory");
		inventory.removeAllOptions();
		inventory.addOption("0", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		Collection<EvmConexaoDTO> evmConexaoDTOs = this.getEvmConexaoService().findByFerramentaMonitoracao(Ferramentas.CITSMART_INVENTORY);

		if (evmConexaoDTOs != null) {
			for (EvmConexaoDTO evmConexaoDTO : evmConexaoDTOs) {
				if (evmConexaoDTO.getIdConexao() != null) {
					inventory.addOption(evmConexaoDTO.getIdConexao().toString(), evmConexaoDTO.getNome());
				}
			}
		}
	}

	public void carregaListaIp(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		EvmStatusInventoryDTO evmStatusInventoryDTO = (EvmStatusInventoryDTO) document.getBean();

		Integer idConexao = evmStatusInventoryDTO.getIdConexao();

		EvmConexaoDTO conexaoDTO = this.getEvmConexaoService().getConexaoById(idConexao);

		EvmInventoryConfiguracaoDTO configuracaoDTO = this.getEvmInventoryConfiguracaoService().findConfiguracaoByIdConexao(idConexao);

		try {
			listaIps = this.getEvmStatusInventoryService().listIpsByConexao(IPInventario.montaUrlWs(conexaoDTO, configuracaoDTO, "listaIpInventario"));
		} catch (Exception e) {
			document.executeScript("escondeJanelaAguarde();");
			document.alert(UtilI18N.internacionaliza(request, "evm.statusinventory.conexaorecusada"));
		}

		if (listaIps.size() > 0) {
			EvmStatusInventory.pagina = 1;

			renderiza(document, request);
		} else {
			limpaListaIp(document, request, response);
		}

		document.executeScript("escondeJanelaAguarde();");
	}

	private void renderiza(DocumentHTML document, HttpServletRequest request) throws Exception {
		EvmStatusInventoryDTO evmStatusInventoryDTO = (EvmStatusInventoryDTO) document.getBean();
		List<IPInventario> listaIpsFiltrados = new ArrayList<IPInventario>();

		document.executeScript("$('#tabelaIP tbody').html('');");

		Integer max = EvmStatusInventory.pagina * EvmStatusInventory.paginacao;

		if (evmStatusInventoryDTO.getFiltroIp() != null && !evmStatusInventoryDTO.getFiltroIp().isEmpty()) {
			if (listaIps != null && !listaIps.isEmpty()) {
				for (IPInventario ipInventario : listaIps) {
					if (ipInventario.getIp().contains(evmStatusInventoryDTO.getFiltroIp())) {
						listaIpsFiltrados.add(ipInventario);
					}
				}
			}

			if (listaIpsFiltrados != null && !listaIpsFiltrados.isEmpty()) {
				EvmStatusInventory.quantidadePaginas = (int) Math.ceil((double) listaIpsFiltrados.size() / EvmStatusInventory.paginacao);
			}
		} else {
			listaIpsFiltrados = listaIps;
			EvmStatusInventory.quantidadePaginas = (int) Math.ceil((double) listaIps.size() / EvmStatusInventory.paginacao);
		}

		if (EvmStatusInventory.quantidadePaginas == 0) {
			EvmStatusInventory.quantidadePaginas = 1;
		}

		for (int i = max - EvmStatusInventory.paginacao; i < max; i++) {
			if (listaIpsFiltrados.size() > i) {
				IPInventario ip = listaIpsFiltrados.get(i);
				if (ip != null) {
					if (evmStatusInventoryDTO.getFiltroIp() != null && !evmStatusInventoryDTO.getFiltroIp().isEmpty()) {
						if (!ip.getIp().contains(evmStatusInventoryDTO.getFiltroIp())) {
							continue;
						}
					}

					StringBuilder conteudoHTML = new StringBuilder();

					CronExpression cronExpression = new CronExpression(ip.getCronInventario());
					ip.setDataProximaCaptura(cronExpression.nextTimeAfter(UtilDatas.getDataDateTime(ip.getDataProximaCaptura())).toDate());

					ItemConfiguracaoIpDTO itemConfiguracaoIpDTO = this.getValorService().getItemConfiguracaoByValorIp(ip);

					if (itemConfiguracaoIpDTO != null && itemConfiguracaoIpDTO.getIdItemConfiguracao() != null) {
						if (itemConfiguracaoIpDTO.getDtUltimaCaptura() != null) {
							ip.setDataUltimaCaptura(itemConfiguracaoIpDTO.getDtUltimaCaptura());
						} else {
							ip.setDataUltimaCaptura(null);
						}
						if (itemConfiguracaoIpDTO.getIdentificacao() != null) {
							ip.setIdentificacaoIC(itemConfiguracaoIpDTO.getIdentificacao());
						} else {
							ip.setIdentificacaoIC(UtilI18N.internacionaliza(request, "evmStatusInventory.novo"));
						}
					} else {
						ip.setDataUltimaCaptura(null);
						ip.setIdentificacaoIC(UtilI18N.internacionaliza(request, "evmStatusInventory.novo"));
					}

					conteudoHTML.append("<tr>");
					conteudoHTML.append("<td>" + (ip.getIdentificacaoIC() != null ? ip.getIdentificacaoIC() : "-") + "</td>");
					conteudoHTML.append("<td>" + (ip.getIp() != null ? ip.getIp() : "-") + "</td>");
					conteudoHTML.append("<td>" 
							+ (ip.ativo ? UtilI18N.internacionaliza(request, EvmEnumerados.StatusInventory.ATIVO.getChave()) : UtilI18N.internacionaliza(request, EvmEnumerados.StatusInventory.INATIVO.getChave())) 
							+ "</td>");
					conteudoHTML.append("<td>");

					if (ip.ativo) {
						conteudoHTML.append("<button type='button' name='btnGravar' class='lFloat btn btn-icon btn-primary btn-block' onclick='inventariaIp(\"" + ip.getIp() + "\");'>");
						conteudoHTML.append(UtilI18N.internacionaliza(request, "evm.statusinventory.inventariarAgora"));
						conteudoHTML.append("</button>");
					} else {
						conteudoHTML.append("--");
					}

					conteudoHTML.append("</td>");
					conteudoHTML.append("<td>" + (ip.getDataUltimaCaptura() != null ? ip.getDataUltimaCaptura() : "-") + "</td>");
					conteudoHTML.append("<td>" + (ip.ativo && ip.getDataProximaCaptura() != null ? UtilDatas.convertDateStringEnToPt(ip.getDataProximaCaptura().toString()) : "-") + "</td>");
					conteudoHTML.append("</tr>");

					document.executeScript("$(\"#tabelaIP tbody\").append(\"" + StringEscapeUtils.escapeJavaScript(conteudoHTML.toString()) + "\");");
				}
			}
		}

		StringBuilder sbPaginacao = new StringBuilder();

		sbPaginacao.append("<ul>");
		sbPaginacao.append("<li id=\"first\" class=\"" + (EvmStatusInventory.pagina.compareTo(1) == 0 ? " disabled " : "") + "\"><a href=\"#\">&laquo;</a></li>");
		sbPaginacao.append("<li id=\"previous\" class=\"" + (EvmStatusInventory.pagina.compareTo(1) == 0 ? " disabled " : "") + "\"><a href=\"#\">&lsaquo;</a></li>");
		sbPaginacao.append("<li class=\"disabled\"><a href=\"#\">" + EvmStatusInventory.pagina + " " + UtilI18N.internacionaliza(request, "citcorpore.comum.deMin") + " "
				+ EvmStatusInventory.quantidadePaginas
				+ "</a></li>");
		sbPaginacao.append("<li id=\"next\" class=\"" + (EvmStatusInventory.pagina.compareTo(EvmStatusInventory.quantidadePaginas) == 0 ? " disabled " : "") + "\"><a href=\"#\">&rsaquo;</a></li>");
		sbPaginacao.append("<li id=\"last\" class=\"" + (EvmStatusInventory.pagina.compareTo(EvmStatusInventory.quantidadePaginas) == 0 ? " disabled " : "") + "\"><a href=\"#\">&raquo;</a></li>");
		sbPaginacao.append("</ul>");

		document.executeScript("$('#pagination').html('" + sbPaginacao.toString() + "');");

		document.executeScript("$('#tabelaIP').removeClass('hide');");
		document.executeScript("$('#pagination').removeClass('hide');");
	}

	public void limpaListaIp(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		document.executeScript("$('#tabelaIP tbody').html('');");
		document.executeScript("$('#tabelaIP').addClass('hide');");

		document.executeScript("$('#pagination').addClass('hide');");
	}

	public void inventariaIp(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		EvmStatusInventoryDTO evmStatusInventoryDTO = (EvmStatusInventoryDTO) document.getBean();

		Integer idConexao = evmStatusInventoryDTO.getIdConexao();
		String ip = evmStatusInventoryDTO.getIp();

		EvmConexaoDTO conexaoDTO = this.getEvmConexaoService().getConexaoById(idConexao);

		EvmInventoryConfiguracaoDTO configuracaoDTO = this.getEvmInventoryConfiguracaoService().findConfiguracaoByIdConexao(idConexao);

		configuracaoDTO.setFaixaIp(ip);

		this.getEvmStatusInventoryService().realizaInventarioIp(configuracaoDTO, conexaoDTO);
	}

	public void renderizaFirst(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		EvmStatusInventory.pagina = 1;

		renderiza(document, request);

		document.executeScript("$(\".widget-body\").scrollTop(0);");
		document.executeScript("escondeJanelaAguarde();");
	}

	public void renderizaPrevious(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (EvmStatusInventory.pagina > 1) {
			EvmStatusInventory.pagina--;
		}

		renderiza(document, request);

		document.executeScript("$(\".widget-body\").scrollTop(0);");
		document.executeScript("escondeJanelaAguarde();");
	}

	public void renderizaNext(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (EvmStatusInventory.pagina < EvmStatusInventory.quantidadePaginas) {
			EvmStatusInventory.pagina++;
		}

		renderiza(document, request);

		document.executeScript("$(\".widget-body\").scrollTop(0);");
		document.executeScript("escondeJanelaAguarde();");
	}

	public void renderizaLast(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		EvmStatusInventory.pagina = EvmStatusInventory.quantidadePaginas;

		renderiza(document, request);

		document.executeScript("$(\".widget-body\").scrollTop(0);");
		document.executeScript("escondeJanelaAguarde();");
	}

	@Override
	public Class<EvmStatusInventoryDTO> getBeanClass() {
		return EvmStatusInventoryDTO.class;
	}

	private EvmStatusInventoryService getEvmStatusInventoryService() throws ServiceException {
		if (evmStatusInventoryService == null) {
			evmStatusInventoryService = (EvmStatusInventoryService) ServiceLocator.getInstance().getService(EvmStatusInventoryService.class, null);
		}
		return evmStatusInventoryService;
	}

	private EvmInventoryConfiguracaoService getEvmInventoryConfiguracaoService() throws ServiceException {
		if (evmInventoryConfiguracaoService == null) {
			evmInventoryConfiguracaoService = (EvmInventoryConfiguracaoService) ServiceLocator.getInstance().getService(EvmInventoryConfiguracaoService.class, null);
		}
		return evmInventoryConfiguracaoService;
	}

	private EvmConexaoService getEvmConexaoService() throws ServiceException {
		if (evmConexaoService == null) {
			evmConexaoService = (EvmConexaoService) ServiceLocator.getInstance().getService(EvmConexaoService.class, null);
		}
		return evmConexaoService;
	}

	private ValorService getValorService() throws ServiceException {
		if (valorService == null) {
			valorService = (ValorService) ServiceLocator.getInstance().getService(ValorService.class, null);
		}
		return valorService;
	}
}
