package br.com.centralit.citcorpore.ajaxForms;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.directwebremoting.util.JavascriptUtil;
import org.json.JSONObject;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

import com.google.gson.Gson;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.AcordoNivelServicoDTO;
import br.com.centralit.citcorpore.bean.AtributoDemandaDTO;
import br.com.centralit.citcorpore.bean.AtributoDemandaItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.AuditoriaItemConfigDTO;
import br.com.centralit.citcorpore.bean.BIConsultaDTO;
import br.com.centralit.citcorpore.bean.CalendarioDTO;
import br.com.centralit.citcorpore.bean.CaracteristicaDTO;
import br.com.centralit.citcorpore.bean.ClienteDTO;
import br.com.centralit.citcorpore.bean.ConhecimentoICDTO;
import br.com.centralit.citcorpore.bean.ContratoDTO;
import br.com.centralit.citcorpore.bean.EmpregadoDTO;
import br.com.centralit.citcorpore.bean.EvmConexaoDTO;
import br.com.centralit.citcorpore.bean.EvmInventoryConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.FornecedorDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.GrupoDTO;
import br.com.centralit.citcorpore.bean.GrupoEmpregadoDTO;
import br.com.centralit.citcorpore.bean.GrupoICValorIndisponibilidadeDTO;
import br.com.centralit.citcorpore.bean.GrupoItemConfiguracaoAcordoNivelServicoDTO;
import br.com.centralit.citcorpore.bean.GrupoItemConfiguracaoCalendarioDTO;
import br.com.centralit.citcorpore.bean.GrupoItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.HistoricoBaseConhecimentoDTO;
import br.com.centralit.citcorpore.bean.HistoricoItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.HistoricoValorDTO;
import br.com.centralit.citcorpore.bean.IndicadorCapacidadeDTO;
import br.com.centralit.citcorpore.bean.IndicadorCapacidadeItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.InventarioElementoDTO;
import br.com.centralit.citcorpore.bean.ItemConfiguracaoAcordoNivelServicoDTO;
import br.com.centralit.citcorpore.bean.ItemConfiguracaoCalendarioDTO;
import br.com.centralit.citcorpore.bean.ItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.ItemConfiguracaoValorDTO;
import br.com.centralit.citcorpore.bean.LocalidadeDTO;
import br.com.centralit.citcorpore.bean.MidiaSoftwareDTO;
import br.com.centralit.citcorpore.bean.PerfilAcessoGrupoDTO;
import br.com.centralit.citcorpore.bean.PerfilAcessoMenuDTO;
import br.com.centralit.citcorpore.bean.ProblemaDTO;
import br.com.centralit.citcorpore.bean.RequisicaoLiberacaoDTO;
import br.com.centralit.citcorpore.bean.RequisicaoMudancaDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.bean.SmartReportDTO;
import br.com.centralit.citcorpore.bean.SolicitacaoServicoDTO;
import br.com.centralit.citcorpore.bean.StatusInventarioDTO;
import br.com.centralit.citcorpore.bean.StatusInventarioElementoDTO;
import br.com.centralit.citcorpore.bean.TipoItemConfiguracaoDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.bean.ValorDTO;
import br.com.centralit.citcorpore.metainfo.bean.CamposObjetoNegocioDTO;
import br.com.centralit.citcorpore.metainfo.bean.ObjetoNegocioDTO;
import br.com.centralit.citcorpore.metainfo.negocio.CamposObjetoNegocioService;
import br.com.centralit.citcorpore.metainfo.negocio.ObjetoNegocioService;
import br.com.centralit.citcorpore.metainfo.script.ScriptRhinoJSExecute;
import br.com.centralit.citcorpore.negocio.AcordoNivelServicoService;
import br.com.centralit.citcorpore.negocio.AtributoDemandaItemConfiguracaoService;
import br.com.centralit.citcorpore.negocio.AtributoDemandaService;
import br.com.centralit.citcorpore.negocio.BIConsultaService;
import br.com.centralit.citcorpore.negocio.CalendarioService;
import br.com.centralit.citcorpore.negocio.CaracteristicaService;
import br.com.centralit.citcorpore.negocio.ClienteService;
import br.com.centralit.citcorpore.negocio.ConhecimentoICService;
import br.com.centralit.citcorpore.negocio.ContratoService;
import br.com.centralit.citcorpore.negocio.EmpregadoService;
import br.com.centralit.citcorpore.negocio.EvmConexaoService;
import br.com.centralit.citcorpore.negocio.EvmInventoryConfiguracaoService;
import br.com.centralit.citcorpore.negocio.FornecedorService;
import br.com.centralit.citcorpore.negocio.GrupoEmpregadoService;
import br.com.centralit.citcorpore.negocio.GrupoICValorIndisponibilidadeService;
import br.com.centralit.citcorpore.negocio.GrupoItemConfiguracaoAcordoNivelServicoService;
import br.com.centralit.citcorpore.negocio.GrupoItemConfiguracaoCalendarioService;
import br.com.centralit.citcorpore.negocio.GrupoItemConfiguracaoService;
import br.com.centralit.citcorpore.negocio.GrupoService;
import br.com.centralit.citcorpore.negocio.HistoricoBaseConhecimentoService;
import br.com.centralit.citcorpore.negocio.HistoricoItemConfiguracaoService;
import br.com.centralit.citcorpore.negocio.HistoricoValorService;
import br.com.centralit.citcorpore.negocio.IndicadorCapacidadeItemConfiguracaoService;
import br.com.centralit.citcorpore.negocio.IndicadorCapacidadeService;
import br.com.centralit.citcorpore.negocio.ItemConfiguracaoAcordoNivelServicoService;
import br.com.centralit.citcorpore.negocio.ItemConfiguracaoCalendarioService;
import br.com.centralit.citcorpore.negocio.ItemConfiguracaoService;
import br.com.centralit.citcorpore.negocio.ItemConfiguracaoValorService;
import br.com.centralit.citcorpore.negocio.LocalidadeService;
import br.com.centralit.citcorpore.negocio.MenuService;
import br.com.centralit.citcorpore.negocio.MidiaSoftwareService;
import br.com.centralit.citcorpore.negocio.PerfilAcessoGrupoService;
import br.com.centralit.citcorpore.negocio.PerfilAcessoMenuService;
import br.com.centralit.citcorpore.negocio.ProblemaService;
import br.com.centralit.citcorpore.negocio.RequisicaoLiberacaoService;
import br.com.centralit.citcorpore.negocio.RequisicaoMudancaService;
import br.com.centralit.citcorpore.negocio.ServicoService;
import br.com.centralit.citcorpore.negocio.SmartReportService;
import br.com.centralit.citcorpore.negocio.SolicitacaoServicoService;
import br.com.centralit.citcorpore.negocio.StatusInventarioService;
import br.com.centralit.citcorpore.negocio.TipoItemConfiguracaoService;
import br.com.centralit.citcorpore.negocio.UsuarioService;
import br.com.centralit.citcorpore.util.ArvoreServico;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.Enumerados;
import br.com.centralit.citcorpore.util.Enumerados.ModuloExibicaoRelatorio;
import br.com.centralit.citcorpore.util.Enumerados.ParametroSistema;
import br.com.centralit.citcorpore.util.Enumerados.ServiceRequestStatus;
import br.com.centralit.citcorpore.util.Enumerados.StatusInventario;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.Enumerados.TipoElementoInventario;
import br.com.centralit.citcorpore.util.Enumerados.TipoExibicaoRelatorio;
import br.com.centralit.citcorpore.util.Enumerados.TipoServico;
import br.com.centralit.citcorpore.util.ParametroUtil;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.centralit.enums.EvmEnumerados.Ferramentas;
import br.com.citframework.dto.LogDados;
import br.com.citframework.excecao.LogicException;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.LogDadosService;
import br.com.citframework.service.LogDadosServiceBean;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.Reflexao;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;
import br.com.citframework.util.UtilStrings;
import br.com.citframework.util.UtilTratamentoArquivos;

@SuppressWarnings({ "unchecked", "rawtypes" })
public class GerenciamentoItemConfiguracao extends AjaxFormAction {

	private Integer ID_CICLO_DESENVOLVIMENTO = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_GRUPO_PADRAO_IC_DESENVOLVIMENTO, "997"));
	private Integer ID_CICLO_HOMOLOGACA0 = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_GRUPO_PADRAO_IC_HOMOLOGACA0, "999"));
	private Integer ID_CICLO_PRODUCAO = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_GRUPO_PADRAO_IC_PRODUCAO, "998"));

	private Integer ID_INVENTARIO = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_GRUPO_PADRAO_IC_INVENTARIO, "1000"));
	private Integer ID_CICLO_DESENVOLVIMENTO_PADRAO = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_GRUPO_PADRAO_IC_DESENVOLVIMENTO_PADRAO, "1001"));
	private Integer ID_CICLO_HOMOLOGACA0_PADRAO = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_GRUPO_PADRAO_IC_HOMOLOGACAO_PADRAO, "1002"));
	private Integer ID_CICLO_PRODUCAO_PADRAO = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_GRUPO_PADRAO_IC_PRODUCAO_PADRAO, "1003"));
	private String ITEM_CONFIGURACAO_MUDANCA = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ITEM_CONFIGURACAO_MUDANCA, "N");

	private static List<Integer> gruposParametro = new ArrayList<Integer>();

	private static HashMap<String, List<String>> caracteristicasDestaque = new HashMap<String, List<String>>();

	private static boolean exibeNome = ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.EXIBIR_NOME_ITEM_CONFIGURACAO_TREE, "S").equals("N") ? false : true;

	private Integer pageSize = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.QUANT_RETORNO_PESQUISA, "10"));

	private static boolean acessoGravar = false;
	private static boolean acessoDeletar = false;

	private GrupoItemConfiguracaoService grupoItemConfiguracaoService;
	private EvmConexaoService evmConexaoService;
	private ItemConfiguracaoService itemConfiguracaoService;
	private ContratoService contratoService;
	private TipoItemConfiguracaoService tipoItemConfiguracaoService;
	private EmpregadoService empregadoService;
	private GrupoService grupoService;
	private CaracteristicaService caracteristicaService;
	private SolicitacaoServicoService solicitacaoServicoService;
	private ProblemaService problemaService;
	private RequisicaoMudancaService requisicaoMudancaService;
	private RequisicaoLiberacaoService requisicaoLiberacaoService;
	private ConhecimentoICService conhecimentoICService;
	private HistoricoItemConfiguracaoService historicoItemConfiguracaoService;
	private HistoricoValorService historicoValorService;
	private MidiaSoftwareService midiaSoftwareService;
	private BIConsultaService biConsultaService;
	private MenuService menuService;
	private PerfilAcessoMenuService perfilAcessoMenuService;
	private UsuarioService usuarioService;
	private GrupoEmpregadoService grupoEmpregadoService;
	private PerfilAcessoGrupoService perfilAcessoGrupoService;
	private ItemConfiguracaoValorService itemConfiguracaoValorService;
	private IndicadorCapacidadeService indicadorCapacidadeService;
	private IndicadorCapacidadeItemConfiguracaoService indicadorCapacidadeItemConfiguracaoService;
	private AtributoDemandaService atributoDemandaService;
	private AtributoDemandaItemConfiguracaoService atributoDemandaItemConfiguracaoService;
	private LocalidadeService localidadeService;
	private HistoricoBaseConhecimentoService historicoBaseConhecimentoService;
	private GrupoItemConfiguracaoAcordoNivelServicoService grupoItemConfiguracaoAcordoNivelServicoService;
	private GrupoItemConfiguracaoCalendarioService grupoItemConfiguracaoCalendarioService;
	private ItemConfiguracaoAcordoNivelServicoService itemConfiguracaoAcordoNivelServicoService;
	private ItemConfiguracaoCalendarioService itemConfiguracaoCalendarioService;
	private CalendarioService calendarioService;
	private AcordoNivelServicoService acordoNivelServicoService;
	private GrupoICValorIndisponibilidadeService grupoICValorIndisponibilidadeService;
	private ServicoService servicoService;
	private StatusInventarioService statusInventarioService;
	private EvmInventoryConfiguracaoService evmInventoryConfiguracaoService;

	private boolean validaIframe = false;
	private SmartReportService smartReportService;


	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		caracteristicasDestaque.put("HARDWARE", new ArrayList<>(Arrays.asList("OSNAME", "PROCESSORT", "IPADDR", "WORKGROUP", "MEMORY", "OSVERSION")));

		if (request.getParameter("iFramInformacaoItemConfiguracao") != null && request.getParameter("iFramInformacaoItemConfiguracao").toString().equals("true") && StringUtils.isNotBlank(request.getParameter("idInfoItem"))) {
			validaIframe = true;
			document.executeScript("setIframe()");
			this.itemConfiguracaoAbrir(document, request, response);
			if(request.getParameter("idInfoItem") != null && request.getParameter("idInfoItem").toString() != null){
				HTMLElement idItem = document.getElementById("idItemConfiguracao");
				idItem.setValue(request.getParameter("idInfoItem").toString());
				this.restauraCalendarioIC(document, request, response);
				this.restauraAcordoNivelServicoIC(document, request, response);
			}
		} else {
			request.setAttribute("iFramInformacaoItemConfiguracao", false);
			validaIframe = false;
		}

		gruposParametro.add(ID_CICLO_DESENVOLVIMENTO);
		gruposParametro.add(ID_CICLO_HOMOLOGACA0);
		gruposParametro.add(ID_CICLO_PRODUCAO);
		gruposParametro.add(ID_INVENTARIO);
		gruposParametro.add(ID_CICLO_DESENVOLVIMENTO_PADRAO);
		gruposParametro.add(ID_CICLO_HOMOLOGACA0_PADRAO);
		gruposParametro.add(ID_CICLO_PRODUCAO_PADRAO);

		/*
		 * Verifica se existe as pastas padroes, e as cria se nao existir
		 */

		getGrupoItemConfiguracaoService().autenticaGrupoPadrao(ID_CICLO_DESENVOLVIMENTO_PADRAO, ID_CICLO_DESENVOLVIMENTO, ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.NOME_GRUPO_PADRAO_DESENVOLVIMENTO, UtilI18N.internacionaliza(request, "itemConfiguracao.ciclo.desenvolvimentoPadrao")));
		getGrupoItemConfiguracaoService().autenticaGrupoPadrao(ID_CICLO_HOMOLOGACA0_PADRAO, ID_CICLO_HOMOLOGACA0, ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.NOME_GRUPO_PADRAO_HOMOLOGACAO, UtilI18N.internacionaliza(request, "itemConfiguracao.ciclo.homologacaoPadrao")));
		getGrupoItemConfiguracaoService().autenticaGrupoPadrao(ID_CICLO_PRODUCAO_PADRAO, ID_CICLO_PRODUCAO, ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.NOME_GRUPO_PADRAO_PRODUCAO, UtilI18N.internacionaliza(request, "itemConfiguracao.ciclo.producaoPadrao")));

		UsuarioDTO usuarioDTO = br.com.centralit.citcorpore.util.WebUtil.getUsuario(request);

		// Carrega combo de contrato
		String COLABORADORES_VINC_CONTRATOS = ParametroUtil.getValorParametroCitSmartHashMap(br.com.centralit.citcorpore.util.Enumerados.ParametroSistema.COLABORADORES_VINC_CONTRATOS, "N");

		if (COLABORADORES_VINC_CONTRATOS == null) {
			COLABORADORES_VINC_CONTRATOS = "N";
		}

		HTMLSelect comboContrato = document.getSelectById("idContrato");

		comboContrato.removeAllOptions();

		Collection<ContratoDTO> listContratoAtivo = null;

		if (COLABORADORES_VINC_CONTRATOS != null && COLABORADORES_VINC_CONTRATOS.equalsIgnoreCase("S") && usuarioDTO != null) {
			listContratoAtivo = getContratoService().findAtivosByIdEmpregado(usuarioDTO.getIdEmpregado());
		} else {
			listContratoAtivo = getContratoService().listAtivos();
		}

		if (listContratoAtivo != null && !listContratoAtivo.isEmpty()) {
			for (ContratoDTO contratoDto : listContratoAtivo) {
				contratoDto.setNome(this.tratarNomeContrato(contratoDto));
			}

			comboContrato.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
			comboContrato.addOptions(listContratoAtivo, "idContrato", "nome", null);
		}

		// Carrega combo de status
		HTMLSelect comboStatus = document.getSelectById("status");
		HTMLSelect filtroStatus = document.getSelectById("filtroStatus");

		comboStatus.removeAllOptions();
		filtroStatus.removeAllOptions();

		comboStatus.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
		filtroStatus.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		for (Enumerados.StatusIC st : Enumerados.StatusIC.values()) {
			comboStatus.addOption(st.getItem().toString(), UtilI18N.internacionaliza(request, st.getChaveInternacionalizacao()));
			filtroStatus.addOption(st.getItem().toString(), UtilI18N.internacionaliza(request, st.getChaveInternacionalizacao()));
		}

		// Carrega combo de tipo responsavel.
		HTMLSelect comboTipoResponsavel = document.getSelectById("tipoResponsavel");

		comboTipoResponsavel.removeAllOptions();

		comboTipoResponsavel.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		comboTipoResponsavel.addOption("U", UtilI18N.internacionaliza(request, "citcorpore.comum.usuario"));
		comboTipoResponsavel.addOption("G", UtilI18N.internacionaliza(request, "controle.grupo"));

		// Carrega combo de criticidade.
		HTMLSelect comboCriticiidade = document.getSelectById("criticidade");
		HTMLSelect filtroCriticidade = document.getSelectById("filtroCriticidade");

		comboCriticiidade.removeAllOptions();
		filtroCriticidade.removeAllOptions();

		comboCriticiidade.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
		filtroCriticidade.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		for (Enumerados.CriticidadeIC ct : Enumerados.CriticidadeIC.values()) {
			comboCriticiidade.addOption(ct.getItem().toString(), UtilI18N.internacionaliza(request, ct.getDescricao()));
			filtroCriticidade.addOption(ct.getItem().toString(), UtilI18N.internacionaliza(request, ct.getDescricao()));
		}

		// Carrega combo de urgencia
		HTMLSelect comboUrgencia = document.getSelectById("urgencia");

		comboUrgencia.removeAllOptions();

		comboUrgencia.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		comboUrgencia.addOption("B", UtilI18N.internacionaliza(request, "citcorpore.comum.baixa"));
		comboUrgencia.addOption("M", UtilI18N.internacionaliza(request, "citcorpore.comum.media"));
		comboUrgencia.addOption("A", UtilI18N.internacionaliza(request, "citcorpore.comum.alta"));

		// Carrega combo de impacto.
		HTMLSelect comboImpacto = document.getSelectById("impacto");

		comboImpacto.removeAllOptions();

		comboImpacto.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		comboImpacto.addOption("B", UtilI18N.internacionaliza(request, "citcorpore.comum.baixa"));
		comboImpacto.addOption("M", UtilI18N.internacionaliza(request, "citcorpore.comum.media"));
		comboImpacto.addOption("A", UtilI18N.internacionaliza(request, "citcorpore.comum.alta"));

		/*
		 * Carrega filtros de status inventario
		 */

		List<EvmConexaoDTO> listConexoes = (List<EvmConexaoDTO>) this.getEvmConexaoService().findByFerramentaMonitoracao(Ferramentas.CITSMART_INVENTORY);

		HTMLSelect filtroStatusInventarioConfiguracaoInventory = document.getSelectById("filtroStatusInventarioConfiguracaoInventory");

		filtroStatusInventarioConfiguracaoInventory.removeAllOptions();
		filtroStatusInventarioConfiguracaoInventory.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		if (listConexoes != null && !listConexoes.isEmpty()) {
			for (EvmConexaoDTO conexaoDTO : listConexoes) {
				filtroStatusInventarioConfiguracaoInventory.addOption(conexaoDTO.getIdConexao().toString(), conexaoDTO.getNome().toUpperCase());
			}
		}

		HTMLSelect filtroStatusInventarioStatus = document.getSelectById("filtroStatusInventarioStatus");

		filtroStatusInventarioStatus.removeAllOptions();
		filtroStatusInventarioStatus.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));

		for (StatusInventario statusInventario : StatusInventario.values()) {
			filtroStatusInventarioStatus.addOption(statusInventario.getId().toString(), UtilI18N.internacionaliza(request, statusInventario.getChave()));
		}

		// Carrega valores dashboard
		carregaValoresDashboard(document);

		loadModalGrupo(document, request, response);
		loadRelatorios(document, request, response);

		Integer idMenu = getMenuService().buscarIdMenu("/gerenciamentoItemConfiguracao/gerenciamentoItemConfiguracao.load");

		if (idMenu != null) {
			PerfilAcessoMenuDTO perfilAcessoMenuDTO = new PerfilAcessoMenuDTO();
			PerfilAcessoGrupoDTO perfilAcessoGrupoDTO = new PerfilAcessoGrupoDTO();

			if (usuarioDTO.getIdPerfilAcessoUsuario() != null) {
				perfilAcessoMenuDTO.setIdPerfilAcesso(usuarioDTO.getIdPerfilAcessoUsuario());
				perfilAcessoMenuDTO.setIdMenu(idMenu);

				Collection<PerfilAcessoMenuDTO> listaPerfilAcessoMenu = getPerfilAcessoMenuService().restoreMenusAcesso(perfilAcessoMenuDTO);

				if (listaPerfilAcessoMenu != null) {
					for (PerfilAcessoMenuDTO perfilAcessoMenu : listaPerfilAcessoMenu) {
						if (perfilAcessoMenu.getGrava() != null && perfilAcessoMenu.getGrava().equalsIgnoreCase("S")) {
							acessoGravar = true;
						}
						if (perfilAcessoMenu.getDeleta() != null && perfilAcessoMenu.getDeleta().equalsIgnoreCase("S")) {
							acessoDeletar = true;
						}
					}
				}

				UsuarioDTO usuario = (UsuarioDTO) getUsuarioService().restore(usuarioDTO);
				Integer idEmpregado = usuario.getIdEmpregado();

				Collection<GrupoEmpregadoDTO> listaDeGrupoEmpregado = getGrupoEmpregadoService().findByIdEmpregado(idEmpregado);

				if (listaDeGrupoEmpregado != null) {
					for (GrupoEmpregadoDTO grupoEmpregado : listaDeGrupoEmpregado) {
						perfilAcessoMenuDTO = new PerfilAcessoMenuDTO();
						perfilAcessoGrupoDTO = new PerfilAcessoGrupoDTO();

						perfilAcessoGrupoDTO.setIdGrupo(grupoEmpregado.getIdGrupo());
						perfilAcessoGrupoDTO = getPerfilAcessoGrupoServicee().listByIdGrupo(perfilAcessoGrupoDTO);

						perfilAcessoMenuDTO.setIdPerfilAcesso(perfilAcessoGrupoDTO.getIdPerfilAcessoGrupo());
						perfilAcessoMenuDTO.setIdMenu(idMenu);

						Collection<PerfilAcessoMenuDTO> listaAcessoMenusGrupo = getPerfilAcessoMenuService().restoreMenusAcesso(perfilAcessoMenuDTO);

						if (listaAcessoMenusGrupo != null) {
							for (PerfilAcessoMenuDTO perfilAcessoMenu : listaAcessoMenusGrupo) {
								if (perfilAcessoMenu.getGrava() != null && perfilAcessoMenu.getGrava().equalsIgnoreCase("S")) {
									acessoGravar = true;
								}
								if (perfilAcessoMenu.getDeleta() != null && perfilAcessoMenu.getDeleta().equalsIgnoreCase("S")) {
									acessoDeletar = true;
								}
							}
						}
					}
				}
			}
		}

		if (ITEM_CONFIGURACAO_MUDANCA.equals("S")) {
			document.executeScript("alteraClasseMudancaObrigatorio()");
		}

		if (!acessoGravar) {
			document.executeScript("$(\"#btnCriarItemConfiguracao\").prop(\"disabled\", \"disabled\");");
			document.executeScript("$(\"#btnCriarItemConfiguracao\").text($(\"#btnCriarItemConfiguracao\").text() + \" - " + UtilI18N.internacionaliza(request, "baseConhecimento.usuarioSemPermissao") + "\");");

			document.executeScript("$(\"#btnCriarGrupo\").prop(\"disabled\", \"disabled\");");
			document.executeScript("$(\"#btnCriarGrupo\").text($(\"#btnCriarGrupo\").text() + \" - " + UtilI18N.internacionaliza(request, "baseConhecimento.usuarioSemPermissao") + "\");");

			document.executeScript("$(\"#btnAlterarGrupo\").prop(\"disabled\", \"disabled\");");
			document.executeScript("$(\"#btnAlterarGrupo\").text($(\"#btnAlterarGrupo\").text() + \" - " + UtilI18N.internacionaliza(request, "baseConhecimento.usuarioSemPermissao") + "\");");
		} else {
			document.executeScript("_inventoryAcessoGravar = true;");
		}

		if (!acessoDeletar) {
			document.executeScript("$(\"#btnExcluirGrupo\").prop(\"disabled\", \"disabled\");");
			document.executeScript("$(\"#btnExcluirGrupo\").text($(\"#btnExcluirGrupo\").text() + \" - " + UtilI18N.internacionaliza(request, "baseConhecimento.usuarioSemPermissao") + "\");");
		} else {
			document.executeScript("_inventoryAcessoDeletar = true;");
		}

		request.setAttribute("grupoDesenv", ID_CICLO_DESENVOLVIMENTO);
		request.setAttribute("grupoHomolog", ID_CICLO_HOMOLOGACA0);
		request.setAttribute("grupoProd", ID_CICLO_PRODUCAO);

		inventoryStart(document, request, response);

		if(validaIframe){
			document.executeScript("desabilitaBotoesPortal();");
		}

	}

	//TODO

	public List<StatusInventarioElementoDTO> renderStatusInventory(Collection<StatusInventarioDTO> colStatusInventarioDTO, DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		List<StatusInventarioElementoDTO> statusInventarioElementos = new ArrayList<StatusInventarioElementoDTO>();

		if (colStatusInventarioDTO != null && !colStatusInventarioDTO.isEmpty()) {
			for (StatusInventarioDTO statusInventarioDTO : colStatusInventarioDTO) {
				StatusInventarioElementoDTO statusInventarioElementoDTO = new StatusInventarioElementoDTO();

				StringBuilder name = new StringBuilder();
				StringBuilder extra = new StringBuilder();

				if (statusInventarioDTO != null) {
					if (statusInventarioDTO.getIdentificacao() != null && !statusInventarioDTO.getIdentificacao().isEmpty() && statusInventarioDTO.getIp() != null && !statusInventarioDTO.getIp().isEmpty()) {
						ItemConfiguracaoDTO itemConfiguracaoDTO = getItemConfiguracaoService().findByIdentificacao(statusInventarioDTO.getIdentificacao());

						name.append("<b>" + (itemConfiguracaoDTO.getIdItemConfiguracao() != null ? "<a href='javascript: return false;' title='" + statusInventarioDTO.getIdentificacao() + "' onclick='StatusInventory.view(" + itemConfiguracaoDTO.getIdItemConfiguracao() + ")'>" + statusInventarioDTO.getIdentificacao() + "</a>" : statusInventarioDTO.getIdentificacao()) + "</b> | "
								+ statusInventarioDTO.getIp());
					} else if (statusInventarioDTO.getIdentificacao() != null && !statusInventarioDTO.getIdentificacao().isEmpty()) {
						ItemConfiguracaoDTO itemConfiguracaoDTO = getItemConfiguracaoService().findByIdentificacao(statusInventarioDTO.getIdentificacao());

						name.append("<b>" + (itemConfiguracaoDTO.getIdItemConfiguracao() != null ? "<a href='javascript: return false;' title='" + statusInventarioDTO.getIdentificacao() + "' onclick='StatusInventory.view(" + itemConfiguracaoDTO.getIdItemConfiguracao() + ")'>" + statusInventarioDTO.getIdentificacao() + "</a>" : statusInventarioDTO.getIdentificacao()) + "</b>");
					} else if (statusInventarioDTO.getIp() != null && !statusInventarioDTO.getIp().isEmpty()) {
						name.append(statusInventarioDTO.getIp());
					}
				statusInventarioElementoDTO.setId(statusInventarioDTO.getIdStatusInventario());
				statusInventarioElementoDTO.setNome(name.toString());
					if (statusInventarioDTO.getDataHora() != null) {
				statusInventarioElementoDTO.setData(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(statusInventarioDTO.getDataHora()));
					}
				}


				extra.append("<div class='txt btn-force-inventory'>");
				if (!StatusInventario.EMEXECUCAO.getId().equals(statusInventarioDTO.getIdStatus())) {
					extra.append("	<span class='label pointer' onclick='StatusInventory.force.run(this); return false;'>" + UtilI18N.internacionaliza(request, "evm.statusinventory.inventariarAgora") + "</span>");
				} else {
					extra.append("<div class='carregando-infinito'></div>");
				}
				extra.append("</div>");
				extra.append("<div class='clearfix'></div>");
				extra.append("<span class='status status-one label "
						+ (StatusInventario.INVENTARIADA.getId().equals(statusInventarioDTO.getIdStatus()) ? "label-primary" : StatusInventario.EMEXECUCAO.getId().equals(statusInventarioDTO.getIdStatus()) ? "label-primary" : "") + "'>"
						+ UtilI18N.internacionaliza(request, StatusInventario.fromId(statusInventarioDTO.getIdStatus()).getChave()) + "</span>");

				statusInventarioElementoDTO.setExtra(extra.toString());

				statusInventarioElementos.add(statusInventarioElementoDTO);
			}
		}

		return statusInventarioElementos;
	}

	public void loadStatusInventory(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();

		HTMLElement wrapper = document.getElementById("status-inventory-wrapper");
		wrapper.setInnerHTML("<div class='row-fluid'></div>");

		Collection<StatusInventarioDTO> colStatusInventarioDTO = getStatusInventarioService().list(gerenciamentoItemConfiguracaoDTO.getFiltroStatusInventarioConfiguracaoInventory(), gerenciamentoItemConfiguracaoDTO.getFiltroStatusInventarioIdentificacao(), gerenciamentoItemConfiguracaoDTO.getFiltroStatusInventarioIP(), gerenciamentoItemConfiguracaoDTO.getFiltroStatusInventarioStatus(),
				gerenciamentoItemConfiguracaoDTO.getControllerQuantidadeItemConfiguracaoStatusInventario(), 60);

		List<StatusInventarioElementoDTO> statusInventarioElementos = renderStatusInventory(colStatusInventarioDTO, document, request, response);

		document.executeScript("StatusInventory.Widget.add({ widgets : " + new Gson().toJson(statusInventarioElementos) + "}, true);");
		document.executeScript("StatusInventory.Monitoring.begin();");
	}

	public void monitoringStatusInventory(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();

		HTMLElement wrapper = document.getElementById("status-inventory-wrapper");
		wrapper.setInnerHTML("<div class='row-fluid'></div>");

		Collection<StatusInventarioDTO> colStatusInventarioDTO = getStatusInventarioService().list(gerenciamentoItemConfiguracaoDTO.getFiltroStatusInventarioConfiguracaoInventory(), gerenciamentoItemConfiguracaoDTO.getFiltroStatusInventarioIdentificacao(), gerenciamentoItemConfiguracaoDTO.getFiltroStatusInventarioIP(), gerenciamentoItemConfiguracaoDTO.getFiltroStatusInventarioStatus(),
				gerenciamentoItemConfiguracaoDTO.getControllerQuantidadeItemConfiguracaoStatusInventario(), gerenciamentoItemConfiguracaoDTO.getControllerQuantidadeItemConfiguracaoStatusInventario() == null || gerenciamentoItemConfiguracaoDTO.getControllerQuantidadeItemConfiguracaoStatusInventario() < 60 ? 60-gerenciamentoItemConfiguracaoDTO.getControllerQuantidadeItemConfiguracaoStatusInventario() : 0);

		List<StatusInventarioElementoDTO> statusInventarioElementos = renderStatusInventory(colStatusInventarioDTO, document, request, response);

		document.executeScript("StatusInventory.Widget.add({ widgets : " + new Gson().toJson(statusInventarioElementos) + "}, true);");
		document.executeScript("StatusInventory.Monitoring.begin();");
	}

	public void filterStatusInventory(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();

		HTMLElement wrapper = document.getElementById("status-inventory-wrapper");
		wrapper.setInnerHTML("<div class='row-fluid'></div>");

		Collection<StatusInventarioDTO> colStatusInventarioDTO = getStatusInventarioService().list(gerenciamentoItemConfiguracaoDTO.getFiltroStatusInventarioConfiguracaoInventory(), gerenciamentoItemConfiguracaoDTO.getFiltroStatusInventarioIdentificacao(), gerenciamentoItemConfiguracaoDTO.getFiltroStatusInventarioIP(), gerenciamentoItemConfiguracaoDTO.getFiltroStatusInventarioStatus(),
				gerenciamentoItemConfiguracaoDTO.getControllerQuantidadeItemConfiguracaoStatusInventario(), 60);

		List<StatusInventarioElementoDTO> statusInventarioElementos = renderStatusInventory(colStatusInventarioDTO, document, request, response);

		document.executeScript("StatusInventory.Widget.add({ widgets : " + new Gson().toJson(statusInventarioElementos) + "}, true);");
	}

	public void loadMoreStatusInventory(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();

		Collection<StatusInventarioDTO> colStatusInventarioDTO = getStatusInventarioService().list(gerenciamentoItemConfiguracaoDTO.getFiltroStatusInventarioConfiguracaoInventory(), gerenciamentoItemConfiguracaoDTO.getFiltroStatusInventarioIdentificacao(), gerenciamentoItemConfiguracaoDTO.getFiltroStatusInventarioIP(), gerenciamentoItemConfiguracaoDTO.getFiltroStatusInventarioStatus(),
				gerenciamentoItemConfiguracaoDTO.getControllerQuantidadeItemConfiguracaoStatusInventario(), 60);

		List<StatusInventarioElementoDTO> statusInventarioElementos = renderStatusInventory(colStatusInventarioDTO, document, request, response);

		document.executeScript("_statusInventoryItensLoading = false;");
		document.executeScript("StatusInventory.Widget.add({ widgets : " + new Gson().toJson(statusInventarioElementos) + "}, true);");
	}

	public void forcaInventario(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();

		if (gerenciamentoItemConfiguracaoDTO.getIdStatusInventario() != null) {
			StatusInventarioDTO statusInventarioDTO = new StatusInventarioDTO();
			statusInventarioDTO.setIdStatusInventario(gerenciamentoItemConfiguracaoDTO.getIdStatusInventario());

			statusInventarioDTO = getStatusInventarioService().restore(statusInventarioDTO);

			if (statusInventarioDTO.getIdConexao() != null) {
				Integer idStatus = statusInventarioDTO.getIdStatus();

				statusInventarioDTO.setIdStatus(StatusInventario.EMEXECUCAO.getId());
				getStatusInventarioService().update(statusInventarioDTO);

				EvmConexaoDTO evmConexaoDTO = this.getEvmConexaoService().getConexaoById(statusInventarioDTO.getIdConexao());
				EvmInventoryConfiguracaoDTO evmInventoryConfiguracaoDTO = this.getEvmInventoryConfiguracaoService().findConfiguracaoByIdConexao(statusInventarioDTO.getIdConexao());
				evmInventoryConfiguracaoDTO.setFaixaIp(statusInventarioDTO.getIp() != null && !statusInventarioDTO.getIp().isEmpty() ? statusInventarioDTO.getIp() : statusInventarioDTO.getIdentificacao());

				boolean r = getStatusInventarioService().realizaInventarioIp(evmInventoryConfiguracaoDTO, evmConexaoDTO);

				if (!r) {
					statusInventarioDTO.setIdStatus(idStatus);
					getStatusInventarioService().update(statusInventarioDTO);

					document.executeScript("notificacaoErro('evm.inventory.configuracao.conexaofalha');");
					document.executeScript("StatusInventory.force.callback(" + gerenciamentoItemConfiguracaoDTO.getIdStatusInventario() + ", " + statusInventarioDTO.getIdStatus() + ");");
				}
			}
		}

		document.executeScript("$('#idStatusInventario').attr('value', '');");
		document.executeScript("StatusInventory.Monitoring.begin();");
	}

	/**
	 * Realiza a navegao inicial entre os itens do inventrio, exibindo a hierarquia dos ICs.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.acorse
	 */
	public void inventoryStart(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		HTMLElement wrapper = document.getElementById("inventory-wrapper");
		wrapper.setInnerHTML("<div class='row-fluid'></div>");

		List<InventarioElementoDTO> inventarioElementos = new ArrayList<InventarioElementoDTO>();

		InventarioElementoDTO inventarioElementoDTO = new InventarioElementoDTO();

		inventarioElementoDTO.setId(ID_CICLO_DESENVOLVIMENTO);
		inventarioElementoDTO.setNome(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.CICLO_DE_VIDA_IC_DESENVOLVIMENTO, UtilI18N.internacionaliza(request, "itemConfiguracao.ciclo.desenvolvimento")).trim());
		inventarioElementoDTO.setIcone("apps");
		inventarioElementoDTO.setTipo(TipoElementoInventario.GRUPO.getCodigo());

		inventarioElementos.add(inventarioElementoDTO);

		inventarioElementoDTO = new InventarioElementoDTO();
		inventarioElementoDTO.setId(ID_CICLO_HOMOLOGACA0);
		inventarioElementoDTO.setNome(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.CICLO_DE_VIDA_IC_HOMOLOGACAO, UtilI18N.internacionaliza(request, "itemConfiguracao.ciclo.homologacao")).trim());
		inventarioElementoDTO.setIcone("apps");
		inventarioElementoDTO.setTipo(TipoElementoInventario.GRUPO.getCodigo());

		inventarioElementos.add(inventarioElementoDTO);

		inventarioElementoDTO = new InventarioElementoDTO();
		inventarioElementoDTO.setId(ID_CICLO_PRODUCAO);
		inventarioElementoDTO.setNome(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.CICLO_DE_VIDA_IC_PRODUCAO, UtilI18N.internacionaliza(request, "itemConfiguracao.ciclo.producao")).trim());
		inventarioElementoDTO.setIcone("apps");
		inventarioElementoDTO.setTipo(TipoElementoInventario.GRUPO.getCodigo());

		inventarioElementos.add(inventarioElementoDTO);

		// Itens soltos serao exibidos somente na raiz
		GrupoItemConfiguracaoDTO grupoItemConfiguracaoDTO = new GrupoItemConfiguracaoDTO();
		grupoItemConfiguracaoDTO.setIdGrupoItemConfiguracao(0);

		Collection<ItemConfiguracaoDTO> listaItensRelacionados = getItemConfiguracaoService().listByGrupo(grupoItemConfiguracaoDTO, new ItemConfiguracaoDTO());

		if (listaItensRelacionados != null && listaItensRelacionados.size() > 0) {
			for (ItemConfiguracaoDTO itensRelacionados : listaItensRelacionados) {
				inventarioElementoDTO = new InventarioElementoDTO();

				inventarioElementoDTO.setId(itensRelacionados.getIdItemConfiguracao());

				if (exibeNome && itensRelacionados.getNome() != null && !itensRelacionados.getNome().isEmpty()) {
					inventarioElementoDTO.setNome(itensRelacionados.getNome());
				} else {
					inventarioElementoDTO.setNome(itensRelacionados.getIdentificacao());
				}

				if (itensRelacionados.getImagem() != null && !itensRelacionados.getImagem().isEmpty()) {
					inventarioElementoDTO.setIcone(itensRelacionados.getImagem());
				} else if (itensRelacionados.getIdTipoItemConfiguracao() != null) {
					TipoItemConfiguracaoDTO tipoItemConfiguracaoDTO = new TipoItemConfiguracaoDTO();
					tipoItemConfiguracaoDTO.setId(itensRelacionados.getIdTipoItemConfiguracao());
					tipoItemConfiguracaoDTO = getTipoItemConfiguracaoService().restore(tipoItemConfiguracaoDTO);

					if (tipoItemConfiguracaoDTO.getImagem() != null && !tipoItemConfiguracaoDTO.getImagem().isEmpty()) {
						inventarioElementoDTO.setIcone(tipoItemConfiguracaoDTO.getImagem());
					} else {
						inventarioElementoDTO.setIcone("devices");
					}
				} else {
					inventarioElementoDTO.setIcone("devices");
				}

				inventarioElementoDTO.setTipo(TipoElementoInventario.ITEMCONFIGURACAO.getCodigo());

				Enumerados.StatusIC statusIc = Enumerados.StatusIC.getStatus(itensRelacionados.getStatus() != null ? itensRelacionados.getStatus() : 1);
				inventarioElementoDTO.setExtra("<span class=\"status status-one label " + statusIc.getLabel() + "\" title=\"" + UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.itemconfiguracaostatus") + "\">" + UtilI18N.internacionaliza(request, statusIc.getChaveInternacionalizacao()) + "</span>");

				inventarioElementos.add(inventarioElementoDTO);
			}
		}

		document.executeScript("$(\"#btnAlterarGrupo\").prop(\"disabled\", \"disabled\");");
		document.executeScript("$(\"#btnExcluirGrupo\").prop(\"disabled\", \"disabled\");");

		document.executeScript("Inventory.Widget.add({ widgets : " + new Gson().toJson(inventarioElementos) + "}, true);");

		habilitaBotaoExportar(document, (GerenciamentoItemConfiguracaoDTO) document.getBean());

		habilitaBotaoCalendarioEANS(document,(GerenciamentoItemConfiguracaoDTO) document.getBean());
	}

	/**
	 * Realiza a navegao entre os itens do inventrio, exibindo a hierarquia dos ICs.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.acorse
	 */
	public void inventoryNavigate(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		HTMLElement wrapper = document.getElementById("inventory-wrapper");
		wrapper.setInnerHTML("<div class='row-fluid'></div>");

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();

		if (acessoGravar) {
			if (!gruposParametro.contains(gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo())) {
				document.executeScript("$(\"#btnAlterarGrupo\").removeProp(\"disabled\", \"\");");
			} else {
				document.executeScript("$(\"#btnAlterarGrupo\").prop(\"disabled\", \"disabled\");");
			}
		} else {
			document.executeScript("$(\"#btnAlterarGrupo\").prop(\"disabled\", \"disabled\");");
		}

		if (acessoDeletar) {
			if (!gruposParametro.contains(gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo())) {
				document.executeScript("$(\"#btnExcluirGrupo\").removeProp(\"disabled\", \"\");");
			} else {
				document.executeScript("$(\"#btnExcluirGrupo\").prop(\"disabled\", \"disabled\");");
			}
		} else {
			document.executeScript("$(\"#btnExcluirGrupo\").prop(\"disabled\", \"disabled\");");
		}

		List<InventarioElementoDTO> inventarioElementos = new ArrayList<InventarioElementoDTO>();

		Collection<GrupoItemConfiguracaoDTO> listaGrupos;

		if (gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo().equals(this.ID_CICLO_DESENVOLVIMENTO)) {
			listaGrupos = getGrupoItemConfiguracaoService().listByIdGrupoItemConfiguracaoDesenvolvimento(gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo());
		} else {
			listaGrupos = getGrupoItemConfiguracaoService().listByIdGrupoItemConfiguracaoPai(gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo());
		}

		InventarioElementoDTO inventarioElementoDTO = new InventarioElementoDTO();

		if (listaGrupos != null && listaGrupos.size() > 0) {
			for (GrupoItemConfiguracaoDTO grupoItemConfiguracaoDTO : listaGrupos) {
				inventarioElementoDTO = new InventarioElementoDTO();
				inventarioElementoDTO.setId(grupoItemConfiguracaoDTO.getIdGrupoItemConfiguracao());
				inventarioElementoDTO.setNome(grupoItemConfiguracaoDTO.getNomeGrupoItemConfiguracao());
				inventarioElementoDTO.setTipo(TipoElementoInventario.GRUPO.getCodigo());

				if (grupoItemConfiguracaoDTO.getImagem() != null && !grupoItemConfiguracaoDTO.getImagem().isEmpty()) {
					inventarioElementoDTO.setIcone(grupoItemConfiguracaoDTO.getImagem());
				} else {
					inventarioElementoDTO.setIcone("apps");
				}

				if (grupoItemConfiguracaoDTO.getCorFundo() != null && !grupoItemConfiguracaoDTO.getCorFundo().isEmpty()) {
					inventarioElementoDTO.setCorFundo(grupoItemConfiguracaoDTO.getCorFundo());
				}

				if (grupoItemConfiguracaoDTO.getCorTexto() != null && !grupoItemConfiguracaoDTO.getCorTexto().isEmpty()) {
					inventarioElementoDTO.setCorTexto(grupoItemConfiguracaoDTO.getCorTexto());
				}

				inventarioElementos.add(inventarioElementoDTO);
			}
		}

		if (gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo().equals(this.ID_CICLO_DESENVOLVIMENTO)) {
			inventarioElementoDTO = new InventarioElementoDTO();

			inventarioElementoDTO.setId(this.ID_INVENTARIO);
			inventarioElementoDTO.setNome(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.NOME_INVENTARIO, UtilI18N.internacionaliza(request, "itemConfiguracao.ciclo.inventario")).trim());
			inventarioElementoDTO.setIcone("apps");
			inventarioElementoDTO.setTipo(TipoElementoInventario.GRUPO.getCodigo());

			inventarioElementos.add(inventarioElementoDTO);
		} else if (gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo().equals(this.ID_INVENTARIO)) {
			List<ItemConfiguracaoDTO> listaItensSemGrupo = getItemConfiguracaoService().listItensByGerenciamentoItemConfiguracaoDTO(gerenciamentoItemConfiguracaoDTO);

			if (listaItensSemGrupo != null && listaItensSemGrupo.size() > 0) {
				for (ItemConfiguracaoDTO itemConfiguracaoDTO : listaItensSemGrupo) {
					inventarioElementoDTO = new InventarioElementoDTO();

					inventarioElementoDTO.setId(itemConfiguracaoDTO.getIdItemConfiguracao());

					if (exibeNome && itemConfiguracaoDTO.getNome() != null && !itemConfiguracaoDTO.getNome().isEmpty()) {
						inventarioElementoDTO.setNome(itemConfiguracaoDTO.getNome());
					} else {
						inventarioElementoDTO.setNome(itemConfiguracaoDTO.getIdentificacao());
					}

					if (itemConfiguracaoDTO.getImagem() != null && !itemConfiguracaoDTO.getImagem().isEmpty()) {
						inventarioElementoDTO.setIcone(itemConfiguracaoDTO.getImagem());
					} else if (itemConfiguracaoDTO.getIdTipoItemConfiguracao() != null) {
						TipoItemConfiguracaoDTO tipoItemConfiguracaoDTO = new TipoItemConfiguracaoDTO();
						tipoItemConfiguracaoDTO.setId(itemConfiguracaoDTO.getIdTipoItemConfiguracao());
						tipoItemConfiguracaoDTO = getTipoItemConfiguracaoService().restore(tipoItemConfiguracaoDTO);

						if (tipoItemConfiguracaoDTO.getImagem() != null && !tipoItemConfiguracaoDTO.getImagem().isEmpty()) {
							inventarioElementoDTO.setIcone(tipoItemConfiguracaoDTO.getImagem());
						} else {
							inventarioElementoDTO.setIcone("devices");
						}
					} else {
						inventarioElementoDTO.setIcone("devices");
					}

					inventarioElementoDTO.setTipo(TipoElementoInventario.ITEMCONFIGURACAO.getCodigo());

					Enumerados.StatusIC statusIc = Enumerados.StatusIC.getStatus(itemConfiguracaoDTO.getStatus() != null ? itemConfiguracaoDTO.getStatus() : 1);
					inventarioElementoDTO.setExtra("<span class=\"status status-one label " + statusIc.getLabel() + "\" title=\"" + UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.itemconfiguracaostatus") + "\">" + UtilI18N.internacionaliza(request, statusIc.getChaveInternacionalizacao()) + "</span>");

					inventarioElementos.add(inventarioElementoDTO);
				}
			}
		} else {
			List<ItemConfiguracaoDTO> listaItemConfiguracao = getItemConfiguracaoService().listItensByGerenciamentoItemConfiguracaoDTO(gerenciamentoItemConfiguracaoDTO);

			if (listaItemConfiguracao != null && listaItemConfiguracao.size() > 0) {
				for (ItemConfiguracaoDTO itemConfiguracaoDTO : listaItemConfiguracao) {
					inventarioElementoDTO = new InventarioElementoDTO();

					inventarioElementoDTO.setId(itemConfiguracaoDTO.getIdItemConfiguracao());

					if (exibeNome && itemConfiguracaoDTO.getNome() != null && !itemConfiguracaoDTO.getNome().isEmpty()) {
						inventarioElementoDTO.setNome(itemConfiguracaoDTO.getNome());
					} else {
						inventarioElementoDTO.setNome(itemConfiguracaoDTO.getIdentificacao());
					}

					if (itemConfiguracaoDTO.getImagem() != null && !itemConfiguracaoDTO.getImagem().isEmpty()) {
						inventarioElementoDTO.setIcone(itemConfiguracaoDTO.getImagem());
					} else if (itemConfiguracaoDTO.getIdTipoItemConfiguracao() != null) {
						TipoItemConfiguracaoDTO tipoItemConfiguracaoDTO = new TipoItemConfiguracaoDTO();
						tipoItemConfiguracaoDTO.setId(itemConfiguracaoDTO.getIdTipoItemConfiguracao());
						tipoItemConfiguracaoDTO = getTipoItemConfiguracaoService().restore(tipoItemConfiguracaoDTO);

						if (tipoItemConfiguracaoDTO.getImagem() != null && !tipoItemConfiguracaoDTO.getImagem().isEmpty()) {
							inventarioElementoDTO.setIcone(tipoItemConfiguracaoDTO.getImagem());
						} else {
							inventarioElementoDTO.setIcone("devices");
						}
					} else {
						inventarioElementoDTO.setIcone("devices");
					}

					inventarioElementoDTO.setTipo(TipoElementoInventario.ITEMCONFIGURACAO.getCodigo());

					Enumerados.StatusIC statusIc = Enumerados.StatusIC.getStatus(itemConfiguracaoDTO.getStatus() != null ? itemConfiguracaoDTO.getStatus() : 1);
					inventarioElementoDTO.setExtra("<span class=\"status status-one label " + statusIc.getLabel() + "\" title=\"" + UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.itemconfiguracaostatus") + "\">" + UtilI18N.internacionaliza(request, statusIc.getChaveInternacionalizacao()) + "</span>");

					inventarioElementos.add(inventarioElementoDTO);
				}
			}
		}

		document.executeScript("Inventory.Widget.add({ widgets : " + new Gson().toJson(inventarioElementos) + "}, true);");

		habilitaBotaoExportar(document, gerenciamentoItemConfiguracaoDTO);

		habilitaBotaoCalendarioEANS(document, gerenciamentoItemConfiguracaoDTO);
	}

	/**
	 * Abre o item de configurao com os dados principais.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.acorse
	 */
	public void itemConfiguracaoAbrir(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}


		ItemConfiguracaoDTO itemConfiguracaoDTO = new ItemConfiguracaoDTO();
		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = new GerenciamentoItemConfiguracaoDTO();

		if (request.getParameter("iFramInformacaoItemConfiguracao") != null && request.getParameter("iFramInformacaoItemConfiguracao").equals("true") && StringUtils.isNotBlank(request.getParameter("idInfoItem"))) {
			gerenciamentoItemConfiguracaoDTO.setIdItemConfiguracao(Integer.parseInt(request.getParameter("idInfoItem")));
			itemConfiguracaoDTO.setIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());

			HTMLForm form = document.getForm("formGerenciamentoItemConfiguracao");
			form.setValue("idInfoItem", request.getParameter("idInfoItem"));
			request.setAttribute("iFramInformacaoItemConfiguracao", true);

		} else {
			gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		}

		itemConfiguracaoDTO = getItemConfiguracaoService().restoreByIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());

		if(itemConfiguracaoDTO != null){
			if (itemConfiguracaoDTO.getIdItemConfiguracaoPai() != null) {
				document.getElementById("idItemConfiguracaoPai").setValue(itemConfiguracaoDTO.getIdItemConfiguracaoPai().toString());
				document.executeScript("$(\".ic-acoes ul .back-father\").removeClass(\"hide\");");
			} else {
				document.getElementById("idItemConfiguracaoPai").setValue("");
				document.executeScript("$(\".ic-acoes ul .back-father\").addClass(\"hide\");");
			}

			if (itemConfiguracaoDTO.getIdTipoItemConfiguracao() != null) {
				TipoItemConfiguracaoDTO tipoItemConfiguracaoDTO = new TipoItemConfiguracaoDTO();
				tipoItemConfiguracaoDTO.setId(itemConfiguracaoDTO.getIdTipoItemConfiguracao());
				tipoItemConfiguracaoDTO = getTipoItemConfiguracaoService().restore(tipoItemConfiguracaoDTO);

				if (tipoItemConfiguracaoDTO.getImagem() != null && !tipoItemConfiguracaoDTO.getImagem().isEmpty()) {
					document.getElementById("ic-view-image").setInnerHTML(tipoItemConfiguracaoDTO.getImagem());
				} else {
					document.getElementById("ic-view-image").setInnerHTML("devices");
				}
			} else {
				document.getElementById("ic-view-image").setInnerHTML("devices");
			}

			if (itemConfiguracaoDTO.getIdentificacao() != null) {
				document.getElementById("ic-identificacao").setInnerHTML(itemConfiguracaoDTO.getIdentificacao());
				document.getElementById("identificacaoICSelecionado").setValue(itemConfiguracaoDTO.getIdentificacao());
			}

			Collection<ItemConfiguracaoDTO> itemConfiguracaoCollectionDTO = getItemConfiguracaoService().listByIdItemPaiAndTagTipoItemCfg(itemConfiguracaoDTO.getIdItemConfiguracao(), "HARDWARE");

			if (itemConfiguracaoCollectionDTO != null && !itemConfiguracaoCollectionDTO.isEmpty()) {
				Integer itensRelacionadosPrincipais = 0;
				for (ItemConfiguracaoDTO itemConfiguracaoRelacionadoDTO : itemConfiguracaoCollectionDTO) {
					if (itensRelacionadosPrincipais == 6) {
						break;
					}

					Collection<CaracteristicaDTO> caracteristicaCollectionDTO = getCaracteristicaService().consultarCaracteristicasComValoresItemConfiguracao(itemConfiguracaoRelacionadoDTO.getIdItemConfiguracao());

					if (caracteristicaCollectionDTO != null && !caracteristicaCollectionDTO.isEmpty()) {
						for (CaracteristicaDTO caracteristicaDTO : caracteristicaCollectionDTO) {
							if (itensRelacionadosPrincipais == 6) {
								break;
							}

							if (caracteristicasDestaque.get("HARDWARE").contains(caracteristicaDTO.getTag()) && caracteristicaDTO.getValorString()!= null && !caracteristicaDTO.getValorString().isEmpty()) {
								itensRelacionadosPrincipais++;

								if (caracteristicaDTO.getTag().equalsIgnoreCase("MEMORY")) {
									try {
										Long memory = Long.parseLong(caracteristicaDTO.getValorString());
										document.getElementById("ic-destaque-caracteristicas-" + itensRelacionadosPrincipais).setInnerHTML(UtilStrings.convertePrimeiraLetra(caracteristicaDTO.getNome().toLowerCase(), "U") + "<span>" + FileUtils.byteCountToDisplaySize(memory) + "</span>");
									} catch (NumberFormatException e) {
										document.getElementById("ic-destaque-caracteristicas-" + itensRelacionadosPrincipais).setInnerHTML(UtilStrings.convertePrimeiraLetra(caracteristicaDTO.getNome().toLowerCase(), "U") + "<span>" + caracteristicaDTO.getValorString() + "</span>");
									}
								} else {
									document.getElementById("ic-destaque-caracteristicas-" + itensRelacionadosPrincipais).setInnerHTML(UtilStrings.convertePrimeiraLetra(caracteristicaDTO.getNome().toLowerCase(), "U") + "<span>" + caracteristicaDTO.getValorString() + "</span>");
								}
							}
						}
					}
				}
			}

			HTMLElement tabSolicitacoesQuantidades = document.getElementById("tab-solicitacoes-quantidades");
			HTMLElement tabIncidentesQuantidades = document.getElementById("tab-incidentes-quantidades");
			HTMLElement tabProblemasQuantidades = document.getElementById("tab-problemas-quantidades");
			HTMLElement tabMudancasQuantidades = document.getElementById("tab-mudancas-quantidades");
			HTMLElement tabLiberacoesQuantidades = document.getElementById("tab-liberacoes-quantidades");

			Integer quantidadeSolicitacoes = getSolicitacaoServicoService().listQuantidadeSolicitacoesByItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());
			if (quantidadeSolicitacoes != null) {
				tabSolicitacoesQuantidades.setInnerHTML(quantidadeSolicitacoes.toString());
			} else {
				tabSolicitacoesQuantidades.setInnerHTML("0");
			}

			Integer quantidadeIncidentes = getSolicitacaoServicoService().listQuantidadeIncidentesByItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());
			if (quantidadeIncidentes != null) {
				tabIncidentesQuantidades.setInnerHTML(quantidadeIncidentes.toString());
			} else {
				tabIncidentesQuantidades.setInnerHTML("0");
			}

			Integer quantidadeProblema = getProblemaService().listQuantidadeProblemaByIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());
			if (quantidadeProblema != null) {
				tabProblemasQuantidades.setInnerHTML(quantidadeProblema.toString());
			} else {
				tabProblemasQuantidades.setInnerHTML("0");
			}

			Integer quantidadeRequisicaoMudanca = getRequisicaoMudancaService().listQuantidadeMudancaByIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());
			if (quantidadeRequisicaoMudanca != null) {
				tabMudancasQuantidades.setInnerHTML(quantidadeRequisicaoMudanca.toString());
			} else {
				tabMudancasQuantidades.setInnerHTML("0");
			}

			Integer quantidadeRequisicaoLiberacao = getRequisicaoLiberacaoService().listQuantidadeLiberacaoByItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());
			if (quantidadeRequisicaoLiberacao != null) {
				tabLiberacoesQuantidades.setInnerHTML(quantidadeRequisicaoLiberacao.toString());
			} else {
				tabLiberacoesQuantidades.setInnerHTML("0");
			}

			preencherQuantidadeBaseConhecimento(document, gerenciamentoItemConfiguracaoDTO);

			HTMLElement itemConfiguracaoLabel = document.getElementById("ic-label");

			Enumerados.StatusIC statusIc = Enumerados.StatusIC.getStatus(itemConfiguracaoDTO.getStatus() != null ? itemConfiguracaoDTO.getStatus() : 1);
			itemConfiguracaoLabel.setInnerHTML("<span class=\"label " + statusIc.getLabel() + "\" title=\"" + UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.itemconfiguracaostatus") + "\">" + UtilI18N.internacionaliza(request, statusIc.getChaveInternacionalizacao()) + "</span>");

			HTMLElement popRelatoriosEspecificos = document.getElementById("ic-relatorios-especificos");
			popRelatoriosEspecificos.setAttributes("data-idespecifico", UtilNumbersAndDecimals.nullToVazio(itemConfiguracaoDTO.getIdItemConfiguracao()));

			loadRelatoriosEspecificos(document, request, response);
			document.executeScript("ItemConfiguracao.View.Loading.close();");

			if (request.getParameter("iFramInformacaoItemConfiguracao") != null && request.getParameter("iFramInformacaoItemConfiguracao").equals("true") && StringUtils.isNotBlank(request.getParameter("idInfoItem"))) {

				loadTab(document, request, response);

			}
		}
	}

	/**
	 * Abre o item de configurao para criao/edio.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.acorse
	 */
	public void itemConfiguracaoController(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();

		HTMLForm form = document.getForm("formGerenciamentoItemConfiguracao");

		document.getElementById("tab-controller-caracteristicas").setInnerHTML("");

		carregaComboLocalidade(document);

		if (gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao() != null) {
			ItemConfiguracaoDTO itemConfiguracaoDTO = new ItemConfiguracaoDTO();
			itemConfiguracaoDTO = getItemConfiguracaoService().restoreByIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());

			if (itemConfiguracaoDTO.getIdTipoItemConfiguracao() != null) {
				TipoItemConfiguracaoDTO tipoItemConfiguracaoDTO = new TipoItemConfiguracaoDTO();
				tipoItemConfiguracaoDTO.setId(itemConfiguracaoDTO.getIdTipoItemConfiguracao());
				tipoItemConfiguracaoDTO = getTipoItemConfiguracaoService().restore(tipoItemConfiguracaoDTO);

				if (tipoItemConfiguracaoDTO.getImagem() != null && !tipoItemConfiguracaoDTO.getImagem().isEmpty()) {
					document.getElementById("ic-controller-image").setInnerHTML(tipoItemConfiguracaoDTO.getImagem());
				} else {
					document.getElementById("ic-controller-image").setInnerHTML("devices");
				}
			} else {
				document.getElementById("ic-controller-image").setInnerHTML("devices");
			}

			form.setValue("identificacao", itemConfiguracaoDTO.getIdentificacao());
			form.setValue("nome", itemConfiguracaoDTO.getNome());
			form.setValue("idContrato", itemConfiguracaoDTO.getIdContrato());
			form.setValue("familia", itemConfiguracaoDTO.getFamilia());
			form.setValue("classe", itemConfiguracaoDTO.getClasse());
			form.setValue("versao", itemConfiguracaoDTO.getVersao());
			form.setValue("numeroSerie", itemConfiguracaoDTO.getNumeroSerie());
			form.setValue("localidade", itemConfiguracaoDTO.getLocalidade());
			form.setValue("dataExpiracao", itemConfiguracaoDTO.getDataExpiracao());

			if (itemConfiguracaoDTO.getIdItemConfiguracaoPai() != null) {
				form.setValue("idItemConfiguracaoPai", itemConfiguracaoDTO.getIdItemConfiguracaoPai());

				ItemConfiguracaoDTO itemConfiguracaoPaiDTO = getItemConfiguracaoService().restoreByIdItemConfiguracao(itemConfiguracaoDTO.getIdItemConfiguracaoPai());

				if (itemConfiguracaoPaiDTO.getIdentificacao() != null && !itemConfiguracaoPaiDTO.getIdentificacao().isEmpty()) {
					form.setValue("nomeItemConfiguracaoPai", itemConfiguracaoPaiDTO.getIdentificacao());
				}
			}

			if (itemConfiguracaoDTO.getIdMidiaSoftware() != null) {
				MidiaSoftwareDTO midiaSoftwareDTO = new MidiaSoftwareDTO();
				midiaSoftwareDTO.setIdMidiaSoftware(itemConfiguracaoDTO.getIdMidiaSoftware());
				midiaSoftwareDTO = (MidiaSoftwareDTO) getMidiaSoftwareService().restore(midiaSoftwareDTO);

				if (midiaSoftwareDTO != null) {
					form.setValue("idMidiaSoftware", midiaSoftwareDTO.getIdMidiaSoftware());
					form.setValue("nomeMidia", midiaSoftwareDTO.getNome());
				}
			}

			if (itemConfiguracaoDTO.getIdTipoItemConfiguracao() != null && itemConfiguracaoDTO.getIdTipoItemConfiguracao().intValue() > 0) {
				TipoItemConfiguracaoDTO tipoItemConfiguracaoDTO = new TipoItemConfiguracaoDTO();
				tipoItemConfiguracaoDTO.setId(itemConfiguracaoDTO.getIdTipoItemConfiguracao());
				tipoItemConfiguracaoDTO = (TipoItemConfiguracaoDTO) getTipoItemConfiguracaoService().restore(tipoItemConfiguracaoDTO);

				form.setValue("idTipoItemConfiguracao", tipoItemConfiguracaoDTO.getId());
				form.setValue("tipoItemConfiguracao", tipoItemConfiguracaoDTO.getNome());
			}

			form.setValue("status", itemConfiguracaoDTO.getStatus());
			form.setValue("ativoFixo", itemConfiguracaoDTO.getAtivoFixo());
			form.setValue("criticidade", itemConfiguracaoDTO.getCriticidade());
			form.setValue("impacto", itemConfiguracaoDTO.getImpacto());
			form.setValue("urgencia", itemConfiguracaoDTO.getUrgencia());

			if (itemConfiguracaoDTO.getIdProprietario() != null) {
				EmpregadoDTO empregadoDTO = new EmpregadoDTO();
				empregadoDTO.setIdEmpregado(itemConfiguracaoDTO.getIdProprietario());
				empregadoDTO = (EmpregadoDTO) getEmpregadoService().restore(empregadoDTO);

				if (empregadoDTO != null) {
					form.setValue("idProprietario", empregadoDTO.getIdEmpregado());
					form.setValue("nomeColaborador", empregadoDTO.getNome());
				}
			}

			if (itemConfiguracaoDTO.getIdGrupoItemConfiguracao() != null && itemConfiguracaoDTO.getIdGrupoItemConfiguracao() > 0) {
				GrupoItemConfiguracaoDTO grupoItemConfiguracaoDTO = new GrupoItemConfiguracaoDTO();
				grupoItemConfiguracaoDTO.setIdGrupoItemConfiguracao(itemConfiguracaoDTO.getIdGrupoItemConfiguracao());
				grupoItemConfiguracaoDTO = (GrupoItemConfiguracaoDTO) getGrupoItemConfiguracaoService().restore(grupoItemConfiguracaoDTO);

				if (grupoItemConfiguracaoDTO != null) {
					form.setValue("idGrupoItemConfiguracao", grupoItemConfiguracaoDTO.getIdGrupoItemConfiguracao());
					form.setValue("nomeGrupoItemConfiguracao", grupoItemConfiguracaoDTO.getNomeGrupoItemConfiguracao());
				}
			}

			if (itemConfiguracaoDTO.getIdMudanca() != null) {
				RequisicaoMudancaDTO requisicaoMudancaDTO = new RequisicaoMudancaDTO();
				requisicaoMudancaDTO.setIdRequisicaoMudanca(itemConfiguracaoDTO.getIdMudanca());
				requisicaoMudancaDTO = (RequisicaoMudancaDTO) getRequisicaoMudancaService().restore(requisicaoMudancaDTO);
				if (requisicaoMudancaDTO != null) {
					form.setValue("idMudanca", requisicaoMudancaDTO.getIdRequisicaoMudanca());
					form.setValue("numeroMudanca", requisicaoMudancaDTO.getIdRequisicaoMudanca() + " - " + requisicaoMudancaDTO.getTitulo() + " - " + UtilI18N.internacionaliza(request, requisicaoMudancaDTO.getDescrStatus()));
				}
			}

			if (itemConfiguracaoDTO.getIdResponsavel() != null) {
				itemConfiguracaoDTO.setTipoResponsavel("U");

				EmpregadoDTO empregadoDTO = new EmpregadoDTO();
				empregadoDTO.setIdEmpregado(itemConfiguracaoDTO.getIdResponsavel());
				empregadoDTO = (EmpregadoDTO) getEmpregadoService().restore(empregadoDTO);

				if (empregadoDTO != null) {
					form.setValue("idResponsavel", empregadoDTO.getIdEmpregado());
					form.setValue("nomeResponsavel", empregadoDTO.getNome());
				}
			}

			if (itemConfiguracaoDTO.getIdGrupoResponsavel() != null) {
				itemConfiguracaoDTO.setTipoResponsavel("G");

				GrupoDTO grupoDTO = new GrupoDTO();
				grupoDTO.setIdGrupo(itemConfiguracaoDTO.getIdGrupoResponsavel());
				grupoDTO = (GrupoDTO) getGrupoService().restore(grupoDTO);

				if (grupoDTO != null) {
					form.setValue("idGrupoResponsavel", grupoDTO.getIdGrupo());
					form.setValue("nomeResponsavel", grupoDTO.getNome());
				}
			}

			form.setValue("tipoResponsavel", itemConfiguracaoDTO.getTipoResponsavel());
			form.setValue("informacoesAdicionais", itemConfiguracaoDTO.getInformacoesAdicionais());
			form.setValue("custoHoraIndisponibilidade", itemConfiguracaoDTO.getCustoHoraIndisponibilidade());

			Collection<CaracteristicaDTO> caracteristicasCollectionDTO = getCaracteristicaService().consultarCaracteristicasComValoresItemConfiguracao(itemConfiguracaoDTO.getIdTipoItemConfiguracao(), itemConfiguracaoDTO.getIdItemConfiguracao());

			if (caracteristicasCollectionDTO != null && !caracteristicasCollectionDTO.isEmpty()) {
				StringBuilder caracteristicas = new StringBuilder();

				caracteristicas.append("<table id=\"tab-controller-caracteristicas-tabela\" class=\"table table-bordered table-striped\">");
				caracteristicas.append("	<thead>");
				caracteristicas.append("		<tr>");
				caracteristicas.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.caracteristica") + "</th>");
				caracteristicas.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.descricao") + "</th>");
				caracteristicas.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.valor") + "</th>");
				caracteristicas.append("		</tr>");
				caracteristicas.append("	</thead>");
				caracteristicas.append("	<tbody>");

				for (CaracteristicaDTO caracteristicaDTO : caracteristicasCollectionDTO) {
					caracteristicas.append("	<tr>");
					caracteristicas.append("		<td>" + (caracteristicaDTO.getNome() != null && !caracteristicaDTO.getNome().isEmpty() ? caracteristicaDTO.getNome() : "") + "</td>");
					caracteristicas.append("		<td>" + (caracteristicaDTO.getDescricao() != null && !caracteristicaDTO.getDescricao().isEmpty() ? caracteristicaDTO.getDescricao() : "") + "</td>");
					caracteristicas.append("		<td>");
					caracteristicas.append("			<input type=\"hidden\" id=\"idCaracteristicas" + caracteristicaDTO.getIdCaracteristica() + "\" name=\"idCaracteristicas\" value=\"" + caracteristicaDTO.getIdCaracteristica() + "\" />");
					caracteristicas.append("			<input type=\"text\" id=\"valorCaracteristicas" + caracteristicaDTO.getIdCaracteristica() + "\" name=\"valorCaracteristicas\" value=\"" + (caracteristicaDTO.getValorString() != null && !caracteristicaDTO.getValorString().isEmpty() ? caracteristicaDTO.getValorString() : "") + "\" />");
					caracteristicas.append("		</td>");
					caracteristicas.append("	</tr>");
				}

				caracteristicas.append("	</tbody>");
				caracteristicas.append("</table>");

				document.getElementById("tab-controller-caracteristicas").setInnerHTML(caracteristicas.toString());
			}
		} else {
			document.getElementById("ic-controller-image").setInnerHTML("devices");

			if (gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo() != null && gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo() > 0) {
				GrupoItemConfiguracaoDTO grupoItemConfiguracaoDTO = new GrupoItemConfiguracaoDTO();
				grupoItemConfiguracaoDTO.setIdGrupoItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo());
				grupoItemConfiguracaoDTO = (GrupoItemConfiguracaoDTO) getGrupoItemConfiguracaoService().restore(grupoItemConfiguracaoDTO);

				if (grupoItemConfiguracaoDTO != null) {
					form.setValue("idGrupoItemConfiguracao", grupoItemConfiguracaoDTO.getIdGrupoItemConfiguracao());
					form.setValue("nomeGrupoItemConfiguracao", grupoItemConfiguracaoDTO.getNomeGrupoItemConfiguracao());
				}
			}
		}

		document.executeScript("ItemConfiguracao.Controller.Loading.close($(\".ic-controller\"));");
	}

	/**
	 * Carrega as caracteristicas de acordo com o tipo do item de configurao.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.acorse
	 */
	public void itemConfiguracaoControllerChange(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();

		if (gerenciamentoItemConfiguracaoDTO.getIdTipoItemConfiguracao() != null) {
			TipoItemConfiguracaoDTO tipoItemConfiguracaoDTO = new TipoItemConfiguracaoDTO();
			tipoItemConfiguracaoDTO.setId(gerenciamentoItemConfiguracaoDTO.getIdTipoItemConfiguracao());
			tipoItemConfiguracaoDTO = getTipoItemConfiguracaoService().restore(tipoItemConfiguracaoDTO);

			if (tipoItemConfiguracaoDTO.getImagem() != null && !tipoItemConfiguracaoDTO.getImagem().isEmpty()) {
				document.getElementById("ic-controller-image").setInnerHTML(tipoItemConfiguracaoDTO.getImagem());
			} else {
				document.getElementById("ic-controller-image").setInnerHTML("devices");
			}

			Collection<CaracteristicaDTO> caracteristicasCollectionDTO = getCaracteristicaService().consultarCaracteristicasAtivas(gerenciamentoItemConfiguracaoDTO.getIdTipoItemConfiguracao());

			if (caracteristicasCollectionDTO != null && !caracteristicasCollectionDTO.isEmpty()) {
				StringBuilder caracteristicas = new StringBuilder();

				caracteristicas.append("<table id=\"tab-controller-caracteristicas-tabela\" class=\"table table-bordered table-striped\">");
				caracteristicas.append("	<thead>");
				caracteristicas.append("		<tr>");
				caracteristicas.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.caracteristica") + "</th>");
				caracteristicas.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.descricao") + "</th>");
				caracteristicas.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.valor") + "</th>");
				caracteristicas.append("		</tr>");
				caracteristicas.append("	</thead>");
				caracteristicas.append("	<tbody>");

				for (CaracteristicaDTO caracteristicaDTO : caracteristicasCollectionDTO) {
					caracteristicas.append("	<tr>");
					caracteristicas.append("		<td>" + (caracteristicaDTO.getNome() != null && !caracteristicaDTO.getNome().isEmpty() ? caracteristicaDTO.getNome() : "") + "</td>");
					caracteristicas.append("		<td>" + (caracteristicaDTO.getDescricao() != null && !caracteristicaDTO.getDescricao().isEmpty() ? caracteristicaDTO.getDescricao() : "") + "</td>");
					caracteristicas.append("		<td>");
					caracteristicas.append("			<input type=\"hidden\" id=\"idCaracteristicas" + caracteristicaDTO.getIdCaracteristica() + "\" name=\"idCaracteristicas\" value=\"" + caracteristicaDTO.getIdCaracteristica() + "\" />");
					caracteristicas.append("			<input type=\"text\" id=\"valorCaracteristicas" + caracteristicaDTO.getIdCaracteristica() + "\" name=\"valorCaracteristicas\" value=\"\" />");
					caracteristicas.append("		</td>");
					caracteristicas.append("	</tr>");
				}

				caracteristicas.append("	</tbody>");
				caracteristicas.append("</table>");

				HTMLElement tabElement = document.getElementById("tab-controller-caracteristicas");
				tabElement.setInnerHTML(caracteristicas.toString());
			}
		} else {
			document.getElementById("ic-controller-image").setInnerHTML("devices");
		}
	}

	public void inventoryLoad(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();

		ItemConfiguracaoService itemConfiguracaoService = getItemConfiguracaoService();
		List<ItemConfiguracaoDTO> listaItensFiltro = itemConfiguracaoService.listItensByGerenciamentoItemConfiguracaoDTO(gerenciamentoItemConfiguracaoDTO);

		List<InventarioElementoDTO> inventarioElementos = new ArrayList<InventarioElementoDTO>();

		if (listaItensFiltro != null && !listaItensFiltro.isEmpty()) {
			for (ItemConfiguracaoDTO itemConfiguracaoDTO : listaItensFiltro) {
				InventarioElementoDTO inventarioElementoDTO = new InventarioElementoDTO();
				inventarioElementoDTO.setId(itemConfiguracaoDTO.getIdItemConfiguracao());

				if (exibeNome && itemConfiguracaoDTO.getNome() != null && !itemConfiguracaoDTO.getNome().isEmpty()) {
					inventarioElementoDTO.setNome(itemConfiguracaoDTO.getNome());
				} else {
					inventarioElementoDTO.setNome(itemConfiguracaoDTO.getIdentificacao());
				}

				if (itemConfiguracaoDTO.getImagem() != null && !itemConfiguracaoDTO.getImagem().isEmpty()) {
					inventarioElementoDTO.setIcone(itemConfiguracaoDTO.getImagem());
				} else if (itemConfiguracaoDTO.getIdTipoItemConfiguracao() != null) {
					TipoItemConfiguracaoDTO tipoItemConfiguracaoDTO = new TipoItemConfiguracaoDTO();
					tipoItemConfiguracaoDTO.setId(itemConfiguracaoDTO.getIdTipoItemConfiguracao());
					tipoItemConfiguracaoDTO = getTipoItemConfiguracaoService().restore(tipoItemConfiguracaoDTO);

					if (tipoItemConfiguracaoDTO.getImagem() != null && !tipoItemConfiguracaoDTO.getImagem().isEmpty()) {
						inventarioElementoDTO.setIcone(tipoItemConfiguracaoDTO.getImagem());
					} else {
						inventarioElementoDTO.setIcone("devices");
					}
				} else {
					inventarioElementoDTO.setIcone("devices");
				}

				inventarioElementoDTO.setTipo(TipoElementoInventario.ITEMCONFIGURACAO.getCodigo());

				Enumerados.StatusIC statusIc = Enumerados.StatusIC.getStatus(itemConfiguracaoDTO.getStatus() != null ? itemConfiguracaoDTO.getStatus() : 1);
				inventarioElementoDTO.setExtra("<span class=\"status status-one label " + statusIc.getLabel() + "\" title=\"" + UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.itemconfiguracaostatus") + "\">" + UtilI18N.internacionaliza(request, statusIc.getChaveInternacionalizacao()) + "</span>");

				inventarioElementos.add(inventarioElementoDTO);
			}
		} else {
			document.executeScript("_inventoryItensDone = true;");
		}

		document.executeScript("_inventoryItensLoading = false;");
		document.executeScript("Inventory.Widget.add({ widgets : " + new Gson().toJson(inventarioElementos) + "}, false);");
	}

	/**
	 * Realiza o save do item de configurao.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.acorse
	 */
	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		ItemConfiguracaoDTO itemConfiguracaoDTO = new ItemConfiguracaoDTO();

		if (gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao() != null) {
			itemConfiguracaoDTO = getItemConfiguracaoService().restoreByIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());
		}

		Reflexao.copyPropertyValues(gerenciamentoItemConfiguracaoDTO, itemConfiguracaoDTO);

		if (gerenciamentoItemConfiguracaoDTO.getIdMudanca() == null) {
			itemConfiguracaoDTO.setIdMudanca(null);
		}

		if (gerenciamentoItemConfiguracaoDTO.getCustoHoraIndisponibilidade() == null) {
			itemConfiguracaoDTO.setCustoHoraIndisponibilidade(null);
		}

		if (itemConfiguracaoDTO.getTipoResponsavel().equals("G")) {
			itemConfiguracaoDTO.setIdResponsavel(null);
		} else if (itemConfiguracaoDTO.getTipoResponsavel().equals("U")) {
			itemConfiguracaoDTO.setIdGrupoResponsavel(null);
		}

		List<CaracteristicaDTO> caracteristicasListDTO = new ArrayList<CaracteristicaDTO>();
		if (gerenciamentoItemConfiguracaoDTO.getIdCaracteristicas() != null && gerenciamentoItemConfiguracaoDTO.getIdCaracteristicas().length > 0 && gerenciamentoItemConfiguracaoDTO.getValorCaracteristicas() != null && gerenciamentoItemConfiguracaoDTO.getValorCaracteristicas().length > 0 && gerenciamentoItemConfiguracaoDTO.getIdCaracteristicas().length == gerenciamentoItemConfiguracaoDTO.getValorCaracteristicas().length) {
			for (int i = 0; i < gerenciamentoItemConfiguracaoDTO.getIdCaracteristicas().length; i++) {
				CaracteristicaDTO caracteristicaDTO = new CaracteristicaDTO();

				caracteristicaDTO.setIdCaracteristica(gerenciamentoItemConfiguracaoDTO.getIdCaracteristicas()[i]);
				caracteristicaDTO = getCaracteristicaService().restore(caracteristicaDTO);
				caracteristicaDTO.setValorString(gerenciamentoItemConfiguracaoDTO.getValorCaracteristicas()[i]);

				caracteristicasListDTO.add(caracteristicaDTO);
			}
		}

		itemConfiguracaoDTO.setListCaracteristicas(caracteristicasListDTO);

		if (!getItemConfiguracaoService().VerificaSeCadastrado(itemConfiguracaoDTO)) {
			String validaVinculoMudanca = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.ITEM_CONFIGURACAO_MUDANCA, "S");
			if (validaVinculoMudanca.trim().equals("S")) {
				if (itemConfiguracaoDTO.getIdMudanca() == null) {
					document.alert(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.validaRequiredMudanca"));
					document.executeScript("ItemConfiguracao.Controller.Loading.close($(\".ic-controller\"));");
					return;
				}
			}

			if (itemConfiguracaoDTO.getIdMidiaSoftware() != null) {
				MidiaSoftwareDTO midiaSoftwareDTO = new MidiaSoftwareDTO();
				midiaSoftwareDTO.setIdMidiaSoftware(itemConfiguracaoDTO.getIdMidiaSoftware());
				midiaSoftwareDTO = (MidiaSoftwareDTO) getMidiaSoftwareService().restore(midiaSoftwareDTO);

				if (midiaSoftwareDTO.getLicencas() <= this.getItemConfiguracaoService().quantidadeMidiaSoftware(itemConfiguracaoDTO)) {
					document.alert(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.licencaEsgotada"));
					document.executeScript("ItemConfiguracao.Controller.Loading.close($(\".ic-controller\"));");
					return;
				}
			}

			if (gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao() == null) {
				try {
					itemConfiguracaoDTO = getItemConfiguracaoService().create(request, itemConfiguracaoDTO);

					if (itemConfiguracaoDTO != null && itemConfiguracaoDTO.getIdItemConfiguracao() != null) {
						document.alert(UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.itemconfiguracaoregistrado"));

						document.executeScript("ItemConfiguracao.Controller.setItemConfiguracao(" + itemConfiguracaoDTO.getIdItemConfiguracao() + ");");
						document.executeScript("ItemConfiguracao.Controller.close();");
					} else {
						document.alert(UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.itemconfiguracaoregistrarfalha"));
					}
				} catch (LogicException e) {
					document.alert(e.getMessage());
				}
			} else {
				try {
					getItemConfiguracaoService().update(request, itemConfiguracaoDTO);

					document.alert(UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.itemconfiguracaoalterado"));
					document.executeScript("ItemConfiguracao.Controller.close();");
				} catch (LogicException e) {
					document.alert(e.getMessage());
				}
			}
		} else {
			document.alert(UtilI18N.internacionaliza(request, "baseConhecimento.itemExiste"));
		}

		document.executeScript("ItemConfiguracao.Controller.Loading.close($(\".ic-controller\"));");
	}

	public void loadTab(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();

		loadTab(gerenciamentoItemConfiguracaoDTO, document, request);
	}

	/**
	 * Carrega as caracteristicas do item de configurao.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.acorse
	 */
	private void loadTab(GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO, DocumentHTML document, HttpServletRequest request) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		if (StringUtils.isNotBlank(request.getParameter("idInfoItem"))) {
			gerenciamentoItemConfiguracaoDTO.setIdItemConfiguracao(Integer.parseInt(request.getParameter("idInfoItem")));
			if (gerenciamentoItemConfiguracaoDTO.getControllerTab() == null) {
				gerenciamentoItemConfiguracaoDTO.setControllerTab("tab-informacoes-gerais");
			}
		}

		if (gerenciamentoItemConfiguracaoDTO.getControllerTab() != null) {
			StringBuilder tab = new StringBuilder();

			ItemConfiguracaoDTO itemConfiguracaoDTO = new ItemConfiguracaoDTO();
			itemConfiguracaoDTO = getItemConfiguracaoService().restoreByIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());

			if (gerenciamentoItemConfiguracaoDTO.getControllerTab().equalsIgnoreCase("tab-informacoes-gerais")) {
				tab.setLength(0);

				EmpregadoDTO empregadoDTO = new EmpregadoDTO();
				GrupoDTO grupoDTO = new GrupoDTO();

				tab.append("<div class=\"row-fluid\">");
				tab.append("<div class=\"span4\">");
				tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "citcorpore.comum.identificacao")).concat("</h5>"));
				tab.append("<p>" + (itemConfiguracaoDTO.getIdentificacao() != null && !itemConfiguracaoDTO.getIdentificacao().isEmpty() ? itemConfiguracaoDTO.getIdentificacao() : "-") + "</p>");
				tab.append("</div>");
				tab.append("<div class=\"span4\">");
				tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "lingua.nome")).concat("</h5>"));
				tab.append("<p>" + (itemConfiguracaoDTO.getNome() != null && !itemConfiguracaoDTO.getNome().isEmpty() ? itemConfiguracaoDTO.getNome() : "-") + "</p>");
				tab.append("</div>");
				tab.append("<div class=\"span4\">");
				tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "lookup.contrato")).concat("</h5>"));

				if (itemConfiguracaoDTO.getIdContrato() != null) {
					ContratoDTO contratoDTO = new ContratoDTO();
					contratoDTO.setIdContrato(itemConfiguracaoDTO.getIdContrato());
					contratoDTO = (ContratoDTO) getContratoService().restore(contratoDTO);

					tab.append("<p>" + contratoDTO.getNumero() + "</p>");
				} else {
					tab.append("<p>-</p>");
				}

				tab.append("</div>");
				tab.append("</div>");
				tab.append("<div class=\"row-fluid\">");
				tab.append("<div class=\"span4\">");
				tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.familia")).concat("</h5>"));
				tab.append("<p>" + (itemConfiguracaoDTO.getFamilia() != null && !itemConfiguracaoDTO.getFamilia().isEmpty() ? itemConfiguracaoDTO.getFamilia() : "-") + "</p>");
				tab.append("</div>");
				tab.append("<div class=\"span4\">");
				tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.classe")).concat("</h5>"));
				tab.append("<p>" + (itemConfiguracaoDTO.getClasse() != null && !itemConfiguracaoDTO.getClasse().isEmpty() ? itemConfiguracaoDTO.getClasse() : "-") + "</p>");
				tab.append("</div>");
				tab.append("<div class=\"span4\">");
				tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.versao")).concat("</h5>"));
				tab.append("<p>" + (itemConfiguracaoDTO.getVersao() != null && !itemConfiguracaoDTO.getVersao().isEmpty() ? itemConfiguracaoDTO.getVersao() : "-") + "</p>");
				tab.append("</div>");
				tab.append("</div>");
				tab.append("<div class=\"row-fluid\">");
				tab.append("<div class=\"span4\">");
				tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.nSerie")).concat("</h5>"));
				tab.append("<p>" + (itemConfiguracaoDTO.getNumeroSerie() != null && !itemConfiguracaoDTO.getNumeroSerie().isEmpty() ? itemConfiguracaoDTO.getNumeroSerie() : "-") + "</p>");
				tab.append("</div>");
				tab.append("<div class=\"span4\">");
				tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.localidade")).concat("</h5>"));
				tab.append("<p>" + (itemConfiguracaoDTO.getLocalidade() != null && !itemConfiguracaoDTO.getLocalidade().isEmpty() ? itemConfiguracaoDTO.getLocalidade() : "-") + "</p>");
				tab.append("</div>");
				tab.append("<div class=\"span4\">");
				tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.dataExpiracao")).concat("</h5>"));
				tab.append("<p>" + (itemConfiguracaoDTO.getDataExpiracao() != null
						? UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, itemConfiguracaoDTO.getDataExpiracao(), WebUtil.getLanguage(request)) : "-") + "</p>");
				tab.append("</div>");
				tab.append("</div>");
				tab.append("<div class=\"row-fluid\">");

				tab.append("<div class=\"span4\">");
				tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.midia")).concat("</h5>"));

				if (itemConfiguracaoDTO.getIdMidiaSoftware() != null) {
					MidiaSoftwareDTO midiaSoftwareDTO = new MidiaSoftwareDTO();
					midiaSoftwareDTO.setIdMidiaSoftware(itemConfiguracaoDTO.getIdMidiaSoftware());
					midiaSoftwareDTO = (MidiaSoftwareDTO) getMidiaSoftwareService().restore(midiaSoftwareDTO);

					if (midiaSoftwareDTO != null) {
						tab.append("<p>" + midiaSoftwareDTO.getNome() + "</p>");
					} else {
						tab.append("<p>-</p>");
					}
				} else {
					tab.append("<p>-</p>");
				}

				tab.append("</div>");

				tab.append("<div class=\"span4\">");
				tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.tipoItemConfiguracao")).concat("</h5>"));

				if (itemConfiguracaoDTO.getIdTipoItemConfiguracao() != null) {
					TipoItemConfiguracaoDTO tipoItemConfiguracaoDTO = new TipoItemConfiguracaoDTO();
					tipoItemConfiguracaoDTO.setId(itemConfiguracaoDTO.getIdTipoItemConfiguracao());
					tipoItemConfiguracaoDTO = (TipoItemConfiguracaoDTO) getTipoItemConfiguracaoService().restore(tipoItemConfiguracaoDTO);
					if (tipoItemConfiguracaoDTO != null) {
						tab.append("<p>" + tipoItemConfiguracaoDTO.getNome() + "</p>");
					} else {
						tab.append("<p>-</p>");
					}
				} else {
					tab.append("<p>-</p>");
				}

				tab.append("</div>");
				tab.append("<div class=\"span4\">");
				tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.status")).concat("</h5>"));

				if (itemConfiguracaoDTO.getStatus() != null) {
					Enumerados.StatusIC statusIc = Enumerados.StatusIC.getStatus(itemConfiguracaoDTO.getStatus());
					tab.append("<p>" + UtilI18N.internacionaliza(request, statusIc.getChaveInternacionalizacao()) + "</p>");
				} else {
					tab.append("<p>-</p>");
				}

				tab.append("</div>");
				tab.append("</div>");
				tab.append("<div class=\"row-fluid\">");
				tab.append("<div class=\"span4\">");
				tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.ativofixo")).concat("</h5>"));
				tab.append("<p>" + (itemConfiguracaoDTO.getAtivoFixo() != null && !itemConfiguracaoDTO.getAtivoFixo().isEmpty() ? itemConfiguracaoDTO.getAtivoFixo() : "-") + "</p>");
				tab.append("</div>");
				tab.append("<div class=\"span4\">");
				tab.append("<h5>" + UtilI18N.internacionaliza(request, "itemConfiguracaoTree.criticidadeDoServico") + "</h5>");

				if (itemConfiguracaoDTO.getCriticidade() != null) {
					for (Enumerados.CriticidadeIC criticidade : Enumerados.CriticidadeIC.values()) {
						if (itemConfiguracaoDTO.getCriticidade().equals(criticidade.getItem())) {
							tab.append("<p>" + UtilI18N.internacionaliza(request, criticidade.getDescricao()) + "</p>");
						}
					}
				} else {
					tab.append("<p>-</p>");
				}

				tab.append("</div>");
				tab.append("<div class=\"span4\">");
				tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "problema.impacto")).concat("</h5>"));

				if (itemConfiguracaoDTO.getImpacto() != null) {
					switch (itemConfiguracaoDTO.getImpacto()) {
					case "B":
						tab.append("<p>" + UtilI18N.internacionaliza(request, "citcorpore.comum.baixa") + "</p>");
						break;
					case "M":
						tab.append("<p>" + UtilI18N.internacionaliza(request, "citcorpore.comum.media") + "</p>");
						break;
					case "A":
						tab.append("<p>" + UtilI18N.internacionaliza(request, "citcorpore.comum.alta") + "</p>");
						break;
					default:
						tab.append("<p>-</p>");
						break;
					}
				} else {
					tab.append("<p>-</p>");
				}

				tab.append("</div>");
				tab.append("</div>");
				tab.append("<div class=\"row-fluid\">");
				tab.append("<div class=\"span4\">");
				tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.urgencia")).concat("</h5>"));

				if (itemConfiguracaoDTO.getUrgencia() != null) {
					switch (itemConfiguracaoDTO.getUrgencia()) {
					case "B":
						tab.append("<p>" + UtilI18N.internacionaliza(request, "citcorpore.comum.baixa") + "</p>");
						break;
					case "M":
						tab.append("<p>" + UtilI18N.internacionaliza(request, "citcorpore.comum.media") + "</p>");
						break;
					case "A":
						tab.append("<p>" + UtilI18N.internacionaliza(request, "citcorpore.comum.alta") + "</p>");
						break;
					default:
						tab.append("<p>-</p>");
						break;
					}
				} else {
					tab.append("<p>-</p>");
				}

				tab.append("</div>");
				tab.append("<div class=\"span4\">");
				tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "colaborador.colaborador")).concat("</h5>"));

				if (itemConfiguracaoDTO.getIdProprietario() != null) {
					empregadoDTO.setIdEmpregado(itemConfiguracaoDTO.getIdProprietario());
					empregadoDTO = (EmpregadoDTO) getEmpregadoService().restore(empregadoDTO);
					if (empregadoDTO != null) {
						tab.append("<p>" + empregadoDTO.getNome() + "</p>");
					} else {
						tab.append("<p>-</p>");
					}
				} else {
					tab.append("<p>-</p>");
				}

				tab.append("</div>");
				tab.append("<div class=\"span4\">");
				tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.grupo")).concat("</h5>"));

				if (itemConfiguracaoDTO.getIdGrupoItemConfiguracao() != null && itemConfiguracaoDTO.getIdGrupoItemConfiguracao() > 0) {
					GrupoItemConfiguracaoDTO grupoItemConfiguracaoDTO = new GrupoItemConfiguracaoDTO();

					grupoItemConfiguracaoDTO.setIdGrupoItemConfiguracao(itemConfiguracaoDTO.getIdGrupoItemConfiguracao());
					grupoItemConfiguracaoDTO = (GrupoItemConfiguracaoDTO) getGrupoItemConfiguracaoService().restore(grupoItemConfiguracaoDTO);
					if (grupoItemConfiguracaoDTO != null) {
						tab.append("<p>" + grupoItemConfiguracaoDTO.getNomeGrupoItemConfiguracao() + "</p>");
					} else {
						tab.append("<p>-</p>");
					}
				} else {
					tab.append("<p>-</p>");
				}

				tab.append("</div>");
				tab.append("</div>");
				tab.append("<div class=\"row-fluid\">");

				tab.append("<div class=\"span4\">");
				tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.mudanca")).concat("</h5>"));

				if (itemConfiguracaoDTO.getIdMudanca() != null) {
					RequisicaoMudancaDTO requisicaoMudancaDTO = new RequisicaoMudancaDTO();
					requisicaoMudancaDTO.setIdRequisicaoMudanca(itemConfiguracaoDTO.getIdMudanca());
					requisicaoMudancaDTO = (RequisicaoMudancaDTO) getRequisicaoMudancaService().restore(requisicaoMudancaDTO);
					if (requisicaoMudancaDTO != null) {
						tab.append("<p>" + requisicaoMudancaDTO.getIdRequisicaoMudanca() + " - " + requisicaoMudancaDTO.getTitulo() + " - " + UtilI18N.internacionaliza(request, requisicaoMudancaDTO.getDescrStatus()) + "</p>");
					} else {
						tab.append("<p>-</p>");
					}
				} else {
					tab.append("<p>-</p>");
				}

				tab.append("</div>");

				tab.append("<div class=\"span4\">");
				tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.tipoResponsavel")).concat("</h5>"));

				if (itemConfiguracaoDTO.getIdResponsavel() != null) {
					itemConfiguracaoDTO.setTipoResponsavel("U");
				} else if (itemConfiguracaoDTO.getIdGrupoResponsavel() != null) {
					itemConfiguracaoDTO.setTipoResponsavel("G");
				}

				if (itemConfiguracaoDTO.getTipoResponsavel() != null) {
					switch (itemConfiguracaoDTO.getTipoResponsavel()) {
					case "U":
						tab.append("<p>" + UtilI18N.internacionaliza(request, "citcorpore.comum.usuario") + "</p>");
						break;
					case "G":
						tab.append("<p>" + UtilI18N.internacionaliza(request, "controle.grupo") + "</p>");
						break;
					default:
						tab.append("<p>-</p>");
						break;
					}
				} else {
					tab.append("<p>-</p>");
				}

				tab.append("</div>");
				tab.append("<div class=\"span4\">");
				tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "gerenciamentoservico.responsavel")).concat("</h5>"));

				if (itemConfiguracaoDTO.getIdResponsavel() != null) {
					empregadoDTO.setIdEmpregado(itemConfiguracaoDTO.getIdResponsavel());
					empregadoDTO = (EmpregadoDTO) getEmpregadoService().restore(empregadoDTO);
					if (empregadoDTO != null) {
						tab.append("<p>" + empregadoDTO.getNome() + "</p>");
					} else {
						tab.append("<p>-</p>");
					}
				} else if (itemConfiguracaoDTO.getIdGrupoResponsavel() != null) {
					grupoDTO.setIdGrupo(itemConfiguracaoDTO.getIdGrupoResponsavel());
					grupoDTO = (GrupoDTO) getGrupoService().restore(grupoDTO);
					if (grupoDTO != null) {
						tab.append("<p>" + grupoDTO.getNome() + "</p>");
					} else {
						tab.append("<p>-</p>");
					}
				} else {
					tab.append("<p>-</p>");
				}

				tab.append("</div>");
				tab.append("</div>");//WebUtil.getLanguage(request)
				tab.append("<div class=\"row-fluid\">");
				tab.append("	<div class=\"span4\">");
				tab.append("		<h5>".concat(UtilI18N.internacionaliza(request, "gerenciamentoItemConfiguracao.itemConfiguracao.custoHoraIndisponibilidade")).concat("</h5>"));

				Locale locale = new Locale("pt", "BR");
				if (WebUtil.getLanguage(request).equalsIgnoreCase("en")) {
					locale = new Locale("en", "US");
				} else if (WebUtil.getLanguage(request).equalsIgnoreCase("es")) {
					locale = new Locale("es", "ES");
				}

				tab.append("		<p>" + (itemConfiguracaoDTO.getCustoHoraIndisponibilidade() != null ? NumberFormat.getCurrencyInstance(locale).format(itemConfiguracaoDTO.getCustoHoraIndisponibilidade()) : "-") + "</p>");
				tab.append("	</div>");
				tab.append("	<div class=\"span4\">");
				tab.append("		<h5>".concat(UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.dataUltimaCaptura")).concat("</h5>"));
				tab.append("		<p>" + (itemConfiguracaoDTO.getDtUltimaCaptura() != null ? UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, itemConfiguracaoDTO.getDtUltimaCaptura(), WebUtil.getLanguage(request)) : "-") + "</p>");
				tab.append("	</div>");
				tab.append("</div>");

				tab.append("<div class=\"row-fluid\">");
				tab.append("	<div class=\"span12\">");
				tab.append("		<h5>".concat(UtilI18N.internacionaliza(request, "entrevistaCandidato.informacoesAdicionais")).concat("</h5>"));
				tab.append("		<p>" + (itemConfiguracaoDTO.getInformacoesAdicionais() != null && !itemConfiguracaoDTO.getInformacoesAdicionais().isEmpty() ? itemConfiguracaoDTO.getInformacoesAdicionais() : "-") + "</p>");
				tab.append("	</div>");
				tab.append("</div>");
			} else if (gerenciamentoItemConfiguracaoDTO.getControllerTab().equalsIgnoreCase("tab-caracteristicas")) {
				tab.setLength(0);

				Collection<CaracteristicaDTO> caracteristicasCollectionDTO = getCaracteristicaService().consultarCaracteristicasComValoresItemConfiguracao(itemConfiguracaoDTO.getIdTipoItemConfiguracao(), itemConfiguracaoDTO.getIdItemConfiguracao());

				if (caracteristicasCollectionDTO != null && !caracteristicasCollectionDTO.isEmpty()) {
					tab.append("<table id=\"" + gerenciamentoItemConfiguracaoDTO.getControllerTab() + "-tabela\" class=\"table table-bordered table-striped\">");
					tab.append("	<thead>");
					tab.append("		<tr>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.caracteristica") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.descricao") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.valor") + "</th>");
					tab.append("		</tr>");
					tab.append("	</thead>");
					tab.append("	<tbody>");

					for (CaracteristicaDTO caracteristicaDTO : caracteristicasCollectionDTO) {
						tab.append("	<tr>");
						tab.append("		<td>" + (caracteristicaDTO.getNome() != null && !caracteristicaDTO.getNome().isEmpty() ? caracteristicaDTO.getNome() : "") + "</td>");
						tab.append("		<td>" + (caracteristicaDTO.getDescricao() != null && !caracteristicaDTO.getDescricao().isEmpty() ? caracteristicaDTO.getDescricao() : "") + "</td>");
						tab.append("		<td>" + (caracteristicaDTO.getValorString() != null && !caracteristicaDTO.getValorString().isEmpty() ? caracteristicaDTO.getValorString() : "") + "</td>");
						tab.append("	</tr>");
					}

					tab.append("	</tbody>");
					tab.append("</table>");
				}
			} else if (gerenciamentoItemConfiguracaoDTO.getControllerTab().equalsIgnoreCase("tab-requisicoes")) {
				tab.setLength(0);

				List<SolicitacaoServicoDTO> solicitacaoServicoListDTO = getSolicitacaoServicoService().listSolicitacoesByItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());

				if (solicitacaoServicoListDTO != null && !solicitacaoServicoListDTO.isEmpty()) {
					tab.append("<table id=\"" + gerenciamentoItemConfiguracaoDTO.getControllerTab() + "-tabela\" class=\"table table-bordered table-striped\">");
					tab.append("	<thead>");
					tab.append("		<tr>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "gerenciaservico.numerosolicitacao") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.servico") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.nome") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.dataHoraInicio") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.situacao") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.datahoraabertura") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.datahoralimite") + "</th>");
					tab.append("		</tr>");
					tab.append("	</thead>");
					tab.append("	<tbody>");

					for (SolicitacaoServicoDTO solicitacaoServicoDTO : solicitacaoServicoListDTO) {
						tab.append("	<tr>");
						tab.append("		<td>" + solicitacaoServicoDTO.getIdSolicitacaoServico() + "</td>");
						tab.append("		<td>" + (solicitacaoServicoDTO.getNomeServico() != null && !solicitacaoServicoDTO.getNomeServico().isEmpty() ? solicitacaoServicoDTO.getNomeServico() : "") + "</td>");
						tab.append("		<td>" + (solicitacaoServicoDTO.getNomeSolicitante() != null && !solicitacaoServicoDTO.getNomeSolicitante().isEmpty() ? solicitacaoServicoDTO.getNomeSolicitante() : "") + "</td>");
						tab.append("		<td>" + (solicitacaoServicoDTO.getDataHoraInicio() == null ? "" : UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, solicitacaoServicoDTO.getDataHoraInicio(), WebUtil.getLanguage(request))) + "</td>");
						tab.append("		<td>" + UtilI18N.internacionaliza(request, ServiceRequestStatus.getChaveFromId(solicitacaoServicoDTO.getIdStatus())) + "</td>");
						tab.append("		<td>" + (solicitacaoServicoDTO.getDataHoraSolicitacaoStr() != null && !solicitacaoServicoDTO.getDataHoraSolicitacaoStr().isEmpty() ? solicitacaoServicoDTO.getDataHoraSolicitacaoStr() : "") + "</td>");
						tab.append("		<td>" + (solicitacaoServicoDTO.getDataHoraLimiteStr() != null && !solicitacaoServicoDTO.getDataHoraLimiteStr().isEmpty() ? solicitacaoServicoDTO.obterDataHoraLimiteStrWithLanguage(WebUtil.getLanguage(request)) : "") + "</td>");
						tab.append("	</tr>");
						// TODO Adicionar itens de configurao relacionados -
						// ItemConfiguracaoTree.java (570)
					}

					tab.append("	</tbody>");
					tab.append("</table>");
				}
			} else if (gerenciamentoItemConfiguracaoDTO.getControllerTab().equalsIgnoreCase("tab-incidentes")) {
				tab.setLength(0);

				List<SolicitacaoServicoDTO> solicitacaoServicoListDTO = getSolicitacaoServicoService().listIncidentesByItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());

				if (solicitacaoServicoListDTO != null && !solicitacaoServicoListDTO.isEmpty()) {
					tab.append("<table id=\"" + gerenciamentoItemConfiguracaoDTO.getControllerTab() + "-tabela\" class=\"table table-bordered table-striped\">");
					tab.append("	<thead>");
					tab.append("		<tr>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "gerenciaservico.numerosolicitacao") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.servico") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.nome") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.dataHoraInicio") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.situacao") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.datahoraabertura") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.datahoralimite") + "</th>");
					tab.append("		</tr>");
					tab.append("	</thead>");
					tab.append("	<tbody>");

					for (SolicitacaoServicoDTO solicitacaoServicoDTO : solicitacaoServicoListDTO) {
						tab.append("	<tr>");
						tab.append("		<td>" + solicitacaoServicoDTO.getIdSolicitacaoServico() + "</td>");
						tab.append("		<td>" + (solicitacaoServicoDTO.getNomeServico() != null && !solicitacaoServicoDTO.getNomeServico().isEmpty() ? solicitacaoServicoDTO.getNomeServico() : "") + "</td>");
						tab.append("		<td>" + (solicitacaoServicoDTO.getNomeSolicitante() != null && !solicitacaoServicoDTO.getNomeSolicitante().isEmpty() ? solicitacaoServicoDTO.getNomeSolicitante() : "") + "</td>");
						tab.append("		<td>" + (solicitacaoServicoDTO.getDataHoraInicio() == null ? "" : UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, solicitacaoServicoDTO.getDataHoraInicio(), WebUtil.getLanguage(request))) + "</td>");
						tab.append("		<td>" + UtilI18N.internacionaliza(request, ServiceRequestStatus.getChaveFromId(solicitacaoServicoDTO.getIdStatus())) + "</td>");
						tab.append("		<td>" + (solicitacaoServicoDTO.getDataHoraSolicitacao() != null ? UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, solicitacaoServicoDTO.getDataHoraSolicitacao(), WebUtil.getLanguage(request)) : "") + "</td>");
						tab.append("		<td>" + (solicitacaoServicoDTO.getDataHoraLimite() != null ? solicitacaoServicoDTO.obterDataHoraLimiteStrWithLanguage(WebUtil.getLanguage(request)) : "") + "</td>");
						tab.append("	</tr>");
						// TODO Adicionar itens de configurao relacionados -
						// ItemConfiguracaoTree.java (570)
					}

					tab.append("	</tbody>");
					tab.append("</table>");
				}
			} else if (gerenciamentoItemConfiguracaoDTO.getControllerTab().equalsIgnoreCase("tab-problemas")) {
				tab.setLength(0);

				List<ProblemaDTO> problemaListDTO = getProblemaService().listProblemaByIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());

				if (problemaListDTO != null && !problemaListDTO.isEmpty()) {
					tab.append("<table id=\"" + gerenciamentoItemConfiguracaoDTO.getControllerTab() + "-tabela\" class=\"table table-bordered table-striped\">");
					tab.append("	<thead>");
					tab.append("		<tr>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "problema.numero_solicitacao") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "problema.titulo") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "problema.proprietario") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "colaborador.solicitante") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "problema.impacto") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "problema.urgencia") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "problema.severidade") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "problema.status") + "</th>");
					tab.append("		</tr>");
					tab.append("	</thead>");
					tab.append("	<tbody>");

					for (ProblemaDTO problemaDTO : problemaListDTO) {
						tab.append("	<tr>");
						tab.append("		<td>" + problemaDTO.getIdProblema() + "</td>");
						tab.append("		<td>" + (problemaDTO.getTitulo() != null && !problemaDTO.getTitulo().isEmpty() ? problemaDTO.getTitulo() : "") + "</td>");
						tab.append("		<td>" + (problemaDTO.getNomeProprietario() != null && !problemaDTO.getNomeProprietario().isEmpty() ? problemaDTO.getNomeProprietario() : "") + "</td>");
						tab.append("		<td>" + (problemaDTO.getSolicitante() != null && !problemaDTO.getSolicitante().isEmpty() ? problemaDTO.getSolicitante() : "") + "</td>");
						tab.append("		<td>" + (problemaDTO.getImpacto() == null ? ""
								: problemaDTO.getImpacto().equalsIgnoreCase("B") || problemaDTO.getImpacto().equalsIgnoreCase("Baixa") ? UtilI18N.internacionaliza(request, "citcorpore.comum.baixa")
										: problemaDTO.getImpacto().equalsIgnoreCase("A") || problemaDTO.getImpacto().equalsIgnoreCase("Alta")
												? UtilI18N.internacionaliza(request, "citcorpore.comum.alta")
												: problemaDTO.getImpacto().equalsIgnoreCase("M") || problemaDTO.getImpacto().equalsIgnoreCase("Mdia")
														? UtilI18N.internacionaliza(request, "citcorpore.comum.baixa") : problemaDTO.getImpacto())
								+ "</td>");
						tab.append("		<td>" + (problemaDTO.getUrgencia() == null ? ""
								: problemaDTO.getUrgencia().equalsIgnoreCase("B") || problemaDTO.getUrgencia().equalsIgnoreCase("Baixa") ? UtilI18N.internacionaliza(request, "citcorpore.comum.baixa")
										: problemaDTO.getUrgencia().equalsIgnoreCase("A") || problemaDTO.getUrgencia().equalsIgnoreCase("Alta")
												? UtilI18N.internacionaliza(request, "citcorpore.comum.alta")
												: problemaDTO.getUrgencia().equalsIgnoreCase("M") || problemaDTO.getUrgencia().equalsIgnoreCase("Mdia")
														? UtilI18N.internacionaliza(request, "citcorpore.comum.baixa") : problemaDTO.getUrgencia())
								+ "</td>");
						tab.append(
								"		<td>"
										+ (problemaDTO
												.getSeveridade() == null
														? ""
														: problemaDTO.getSeveridade().equalsIgnoreCase("B")
																|| problemaDTO.getSeveridade().equalsIgnoreCase("Baixa")
																		? UtilI18N.internacionaliza(request, "citcorpore.comum.baixa")
																		: problemaDTO.getSeveridade().equalsIgnoreCase("A")
																				|| problemaDTO.getSeveridade().equalsIgnoreCase("Alta")
																						? UtilI18N.internacionaliza(request, "citcorpore.comum.alta")
 : problemaDTO.getSeveridade()
																								.equalsIgnoreCase("M") || problemaDTO.getSeveridade().equalsIgnoreCase("Mdia")
																								? UtilI18N.internacionaliza(request, "citcorpore.comum.baixa") : problemaDTO.getSeveridade())
										+ "</td>");
						tab.append("		<td>" + UtilI18N.internacionaliza(request, problemaDTO.getDescrStatus()) + "</td>");
						tab.append("	</tr>");
						// TODO Adicionar itens de configurao relacionados -
						// ItemConfiguracaoTree.java (651)
					}

					tab.append("	</tbody>");
					tab.append("</table>");
				}
			} else if (gerenciamentoItemConfiguracaoDTO.getControllerTab().equalsIgnoreCase("tab-mudancas")) {
				tab.setLength(0);

				List<RequisicaoMudancaDTO> requisicaoMudancaListDTO = getRequisicaoMudancaService().listMudancaByIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());

				if (requisicaoMudancaListDTO != null && !requisicaoMudancaListDTO.isEmpty()) {
					tab.append("<table id=\"" + gerenciamentoItemConfiguracaoDTO.getControllerTab() + "-tabela\" class=\"table table-bordered table-striped\">");
					tab.append("	<thead>");
					tab.append("		<tr>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.ui.tabela.coluna.Numero") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "requisicaMudanca.titulo") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "requisicaoMudanca.proprietario") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "requisicaoMudanca.solicitante") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "requisicaoMudanca.impacto") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.prioridade") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "requisicaoMudanca.status") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "requisicaoMudanca.tipo") + "</th>");
					tab.append("		</tr>");
					tab.append("	</thead>");
					tab.append("	<tbody>");

					for (RequisicaoMudancaDTO requisicaoMudancaDTO : requisicaoMudancaListDTO) {
						tab.append("	<tr>");
						tab.append("		<td>" + requisicaoMudancaDTO.getIdRequisicaoMudanca() + "</td>");
						tab.append("		<td>" + (requisicaoMudancaDTO.getTitulo() != null && !requisicaoMudancaDTO.getTitulo().isEmpty() ? requisicaoMudancaDTO.getTitulo() : "") + "</td>");
						tab.append("		<td>" + (requisicaoMudancaDTO.getNomeProprietario() != null && !requisicaoMudancaDTO.getNomeProprietario().isEmpty() ? requisicaoMudancaDTO.getNomeProprietario() : "") + "</td>");
						tab.append("		<td>" + (requisicaoMudancaDTO.getNomeSolicitante() != null && !requisicaoMudancaDTO.getNomeSolicitante().isEmpty() ? requisicaoMudancaDTO.getNomeSolicitante() : "") + "</td>");
						tab.append("		<td>" + (requisicaoMudancaDTO.getNivelImpacto() == null ? ""
								: requisicaoMudancaDTO.getNivelImpacto().equalsIgnoreCase("B") || requisicaoMudancaDTO.getNivelImpacto().equalsIgnoreCase("Baixa")
										? UtilI18N.internacionaliza(request, "citcorpore.comum.baixa")
										: requisicaoMudancaDTO.getNivelImpacto().equalsIgnoreCase("A") || requisicaoMudancaDTO.getNivelImpacto().equalsIgnoreCase("Alta")
												? UtilI18N.internacionaliza(request, "citcorpore.comum.alta")
												: requisicaoMudancaDTO.getNivelImpacto().equalsIgnoreCase("M") || requisicaoMudancaDTO.getNivelImpacto().equalsIgnoreCase("Mdia")
														? UtilI18N.internacionaliza(request, "citcorpore.comum.baixa") : requisicaoMudancaDTO.getNivelImpacto())
								+ "</td>");
						tab.append("		<td>" + (requisicaoMudancaDTO.getPrioridade() != null && !requisicaoMudancaDTO.getPrioridade().toString().isEmpty() ? requisicaoMudancaDTO.getPrioridade() : "") + "</td>");
						tab.append("		<td>" + UtilI18N.internacionaliza(request, requisicaoMudancaDTO.getDescrStatus()) + "</td>");
						tab.append("		<td>" + (requisicaoMudancaDTO.getNomeTipoMudanca() != null && !requisicaoMudancaDTO.getNomeTipoMudanca().isEmpty() ? requisicaoMudancaDTO.getNomeTipoMudanca() : "") + "</td>");
						tab.append("	</tr>");
						// TODO Adicionar itens de configurao relacionados -
						// ItemConfiguracaoTree.java (762)
						/**
						 * @description1 Retirado nvel de importncia pois no est sendo utilizado, no lugar ser apresentado a prioridade da mudana
						 * @date 2016-03-18
						 * @author gilmar.junior
						 */
					}

					tab.append("	</tbody>");
					tab.append("</table>");
				}
			} else if (gerenciamentoItemConfiguracaoDTO.getControllerTab().equalsIgnoreCase("tab-liberacoes")) {
				tab.setLength(0);

				List<RequisicaoLiberacaoDTO> requisicaoLiberacaoListDTO = getRequisicaoLiberacaoService().listLiberacaoByItemConfiugracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());

				if (requisicaoLiberacaoListDTO != null && !requisicaoLiberacaoListDTO.isEmpty()) {
					tab.append("<table id=\"" + gerenciamentoItemConfiguracaoDTO.getControllerTab() + "-tabela\" class=\"table table-bordered table-striped\">");
					tab.append("	<thead>");
					tab.append("		<tr>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.ui.tabela.coluna.Numero") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "liberacao.titulo") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "requisicaoMudanca.proprietario") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "requisicaoMudanca.solicitante") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "requisicaoMudanca.impacto") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "solicitacaoServico.urgencia") + "</th>");
					tab.append("		</tr>");
					tab.append("	</thead>");
					tab.append("	<tbody>");

					for (RequisicaoLiberacaoDTO requisicaoLiberacaoDTO : requisicaoLiberacaoListDTO) {
						tab.append("	<tr>");
						tab.append("		<td>" + requisicaoLiberacaoDTO.getIdLiberacao() + "</td>");
						tab.append("		<td>" + (requisicaoLiberacaoDTO.getTitulo() != null && !requisicaoLiberacaoDTO.getTitulo().isEmpty() ? requisicaoLiberacaoDTO.getTitulo() : "") + "</td>");
						tab.append("		<td>" + (requisicaoLiberacaoDTO.getNomeProprietario() != null && !requisicaoLiberacaoDTO.getNomeProprietario().isEmpty() ? requisicaoLiberacaoDTO.getNomeProprietario() : "") + "</td>");
						tab.append("		<td>" + (requisicaoLiberacaoDTO.getNomeSolicitante() != null && !requisicaoLiberacaoDTO.getNomeSolicitante().isEmpty() ? requisicaoLiberacaoDTO.getNomeSolicitante() : "") + "</td>");
						tab.append("		<td>" + (requisicaoLiberacaoDTO.getNivelImpacto() == null ? ""
								: requisicaoLiberacaoDTO.getNivelImpacto().equalsIgnoreCase("B") || requisicaoLiberacaoDTO.getNivelImpacto().equalsIgnoreCase("Baixa")
										? UtilI18N.internacionaliza(request, "citcorpore.comum.baixa")
										: requisicaoLiberacaoDTO.getNivelImpacto().equalsIgnoreCase("A") || requisicaoLiberacaoDTO.getNivelImpacto().equalsIgnoreCase("Alta")
												? UtilI18N.internacionaliza(request, "citcorpore.comum.alta")
												: requisicaoLiberacaoDTO.getNivelImpacto().equalsIgnoreCase("M") || requisicaoLiberacaoDTO.getNivelImpacto().equalsIgnoreCase("Mdia")
														? UtilI18N.internacionaliza(request, "citcorpore.comum.baixa") : requisicaoLiberacaoDTO.getNivelImpacto())
								+ "</td>");
						tab.append("		<td>" + (requisicaoLiberacaoDTO.getNivelUrgencia() == null ? ""
								: requisicaoLiberacaoDTO.getNivelUrgencia().equalsIgnoreCase("B") || requisicaoLiberacaoDTO.getNivelUrgencia().equalsIgnoreCase("Baixa")
										? UtilI18N.internacionaliza(request, "citcorpore.comum.baixa")
										: requisicaoLiberacaoDTO.getNivelUrgencia().equalsIgnoreCase("A") || requisicaoLiberacaoDTO.getNivelUrgencia().equalsIgnoreCase("Alta")
												? UtilI18N.internacionaliza(request, "citcorpore.comum.alta")
 : requisicaoLiberacaoDTO.getNivelUrgencia().equalsIgnoreCase("M")
														|| requisicaoLiberacaoDTO.getNivelUrgencia().equalsIgnoreCase("Mdia")
														? UtilI18N.internacionaliza(request, "citcorpore.comum.baixa") : requisicaoLiberacaoDTO.getNivelUrgencia())
								+ "</td>");
						tab.append("	</tr>");
						// TODO Adicionar itens de configurao relacionados -
						// ItemConfiguracaoTree.java (833)
					}

					tab.append("	</tbody>");
					tab.append("</table>");
				}
			} else if (gerenciamentoItemConfiguracaoDTO.getControllerTab().equalsIgnoreCase("tab-base-conhecimento")) {
				tab.setLength(0);

				tab.append("<div class=\"row-fluid\">");
				tab.append("	<div class=\"span6\">");

				if(request.getParameter("isIframe").toString().equals("true")){
					tab.append("		<button type=\"button\" id=\"btnAddConhecimento\" disabled=\"disabled\" class=\"botaoNovo lFloat btn btn-icon btn-primary glyphicons circle_plus btnGravar\" onclick=\"clickListarConhecimentos();\">");
				} else {
					tab.append("		<button type=\"button\" id=\"btnAddConhecimento\" class=\"botaoNovo lFloat btn btn-icon btn-primary glyphicons circle_plus btnGravar\" onclick=\"clickListarConhecimentos();\">");
				}

				tab.append("			<i></i>").append(UtilI18N.internacionaliza(request, "gerenciaportfolio.VincularConhecimento"));
				tab.append("		</button>");
				tab.append("	</div>");
				tab.append("</div>");

				Collection<ConhecimentoICDTO> ConhecimentoICCollectionDTO = getConhecimentoICService().findByidItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());

				if (ConhecimentoICCollectionDTO != null && !ConhecimentoICCollectionDTO.isEmpty()) {
					tab.append("<table id=\"" + gerenciamentoItemConfiguracaoDTO.getControllerTab() + "-tabela\" class=\"table table-bordered table-striped\">");
					tab.append("	<thead>");
					tab.append("		<tr>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "baseConhecimento.idBaseConhecimento") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "baseConhecimento.titulo") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.acao") + "</th>");
					tab.append("		</tr>");
					tab.append("	</thead>");
					tab.append("	<tbody>");
					tab.append("<div class=\"separator\"></div>");
					for (ConhecimentoICDTO conhecimentoICDTO : ConhecimentoICCollectionDTO) {
						HistoricoBaseConhecimentoDTO historicoBaseConhecimentoDTO = new HistoricoBaseConhecimentoDTO();
						historicoBaseConhecimentoDTO.setIdBaseConhecimento(conhecimentoICDTO.getIdBaseConhecimento());
						historicoBaseConhecimentoDTO = getHistoricoBaseConhecimentoService().restoreHistoricoFromIdBaseConhecimento(historicoBaseConhecimentoDTO);

						tab.append("	<tr>");
						tab.append("		<td>" + historicoBaseConhecimentoDTO.getIdBaseConhecimento() + "</td>");
						tab.append("		<td>" + (historicoBaseConhecimentoDTO.getTitulo() != null && !historicoBaseConhecimentoDTO.getTitulo().isEmpty() ? historicoBaseConhecimentoDTO.getTitulo() : "") + "</td>");
						tab.append("		<td><button type='button' id='btnExcluirBaseConhecimento' class='btn-action glyphicons remove_2 btn-danger btnGravar' onclick='desvincularConhecimentoIc(").append(conhecimentoICDTO.getIdBaseConhecimento()).append(")'><i></i></button>");
						tab.append("	</tr>");
					}

					tab.append("	</tbody>");
					tab.append("</table>");
				} else {
					tab.append("<div class=\"row-fluid\">");
					tab.append("	<div class=\"span12\">");
					tab.append("		<p class=\"align-center\">".concat(UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.nenhumitemencontrado")).concat("</p>"));
					tab.append("	</div>");
					tab.append("</div>");
				}
			} else if (gerenciamentoItemConfiguracaoDTO.getControllerTab().equalsIgnoreCase("tab-itens-relacionados")) {
				tab.setLength(0);

				Collection<TipoItemConfiguracaoDTO> tipoItemConfiguracaoCollectionDTO = getTipoItemConfiguracaoService().findTipoItemConfiguracaoItensRelacionados(itemConfiguracaoDTO.getIdItemConfiguracao());

				if (tipoItemConfiguracaoCollectionDTO != null && !tipoItemConfiguracaoCollectionDTO.isEmpty()) {
					tab.append("<div class=\"accordion accordion-2\" id=\"accordion\">");
					Integer collapse = 0;
					for (TipoItemConfiguracaoDTO tipoItemConfiguracaoDTO : tipoItemConfiguracaoCollectionDTO) {
						collapse++;

						tab.append("	<div class=\"accordion-group\">");
						tab.append("		<div class=\"accordion-heading\">");
						tab.append("			<a class=\"accordion-toggle\" data-toggle=\"collapse\" data-parent=\"#accordion\" href=\"#collapse-" + collapse + "\">" + tipoItemConfiguracaoDTO.getNome() + "</a>");
						tab.append("		</div>");
						tab.append("		<div id=\"collapse-" + collapse + "\" class=\"accordion-body collapse\" style=\"height: 0px;\">");

						Collection<ItemConfiguracaoDTO> itemConfiguracaoCollectionDTO = getItemConfiguracaoService().listByIdItemPaiAndTagTipoItemCfg(itemConfiguracaoDTO.getIdItemConfiguracao(), tipoItemConfiguracaoDTO.getTag());

						if (itemConfiguracaoCollectionDTO != null && !itemConfiguracaoCollectionDTO.isEmpty()) {
							tab.append("			<div class=\"accordion-inner\">");

							tab.append("				<div class=\"widget-timeline\">");
							tab.append("					<ul class=\"list-timeline\">");

							for (ItemConfiguracaoDTO itemConfiguracaoRelacionadoDTO : itemConfiguracaoCollectionDTO) {
								Collection<CaracteristicaDTO> caracteristicaCollectionDTO = getCaracteristicaService().consultarCaracteristicasComValoresItemConfiguracao(itemConfiguracaoRelacionadoDTO.getIdItemConfiguracao());

								tab.append("						<li>");
								tab.append("							<span>" + itemConfiguracaoRelacionadoDTO.getIdItemConfiguracao() + "</span>");
								tab.append("							<span class=\"glyphicons activity-icon more_items\"><i></i></span>");

								if (caracteristicaCollectionDTO != null && !caracteristicaCollectionDTO.isEmpty()) {
									tab.append("							<span class=\"ellipsis\"><a href=\"javascript:return false;\" onclick=\"ItemConfiguracao.View.Tab.ItensRelacionados.toggleCaracteristicas(this);\" data-id=\"" + itemConfiguracaoRelacionadoDTO.getIdItemConfiguracao() + "\">" + itemConfiguracaoRelacionadoDTO.getIdentificacao() + "</a></span>");
								} else {
									tab.append("							<span class=\"ellipsis\">" + itemConfiguracaoRelacionadoDTO.getIdentificacao() + "</span>");
								}

								tab.append("							<a class=\"pull-right iframe-view-hidden\" href=\"#\" onclick=\"ItemConfiguracao.View.open($(this)); return false;\" data-relation=\"" + itemConfiguracaoRelacionadoDTO.getIdItemConfiguracao() + "\" style=\"cursor: pointer;\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.visualizar") + "</a>");
								tab.append("							<div class=\"clearfix\"></div>");
								tab.append("						</li>");

								if (caracteristicaCollectionDTO != null && !caracteristicaCollectionDTO.isEmpty()) {
									tab.append("					<div class=\"widget-timeline ic-relacionado-caracteristicas hide\" data-reference=\"" + itemConfiguracaoRelacionadoDTO.getIdItemConfiguracao() + "\">");
									tab.append("						<ul class=\"list-timeline\">");

									for (CaracteristicaDTO caracteristicaDTO : caracteristicaCollectionDTO) {
										tab.append("						<li>");
										tab.append("							<span class=\"title\">" + caracteristicaDTO.getNome() + "</span>");
										tab.append("							<span class=\"glyphicons activity-icon chevron-right\"><i></i></span>");
										tab.append("							<span class=\"ellipsis\">" + (caracteristicaDTO.getValorString() != null && !caracteristicaDTO.getValorString().isEmpty() ? caracteristicaDTO.getValorString() : "") + "</span>");
										tab.append("							<div class=\"clearfix\"></div>");
										tab.append("						</li>");
									}

									tab.append("						</ul>");
									tab.append("					</div>");
								}
							}

							tab.append("					</ul>");
							tab.append("				</div>");
							tab.append("			</div>");
						} else {
							tab.append("			<div class=\"accordion-inner\">".concat(UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.nenhumitemencontrado")).concat("</div>"));
						}

						tab.append("		</div>");
						tab.append("	</div>");
					}
					tab.append("</div>");
				}
			} else if (gerenciamentoItemConfiguracaoDTO.getControllerTab().equalsIgnoreCase("tab-impactos")) {
				tab.setLength(0);

				Collection<ServicoDTO> servicoCollectionDTO = getServicoService().getServicosImpactadosByIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());

				if (servicoCollectionDTO != null && !servicoCollectionDTO.isEmpty()) {
					tab.append("<table id=\"" + gerenciamentoItemConfiguracaoDTO.getControllerTab() + "-tabela\" class=\"table table-bordered table-striped\">");
					tab.append("	<thead>");
					tab.append("		<tr>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "lookup.idServico") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "lookup.nomeServico") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.tipoServico") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.acoes") + "</th>");
					tab.append("		</tr>");
					tab.append("	</thead>");
					tab.append("	<tbody>");

					for (ServicoDTO servicoDTO : servicoCollectionDTO) {
						tab.append("	<tr>");
						tab.append("		<td>" + servicoDTO.getIdServico() + "</td>");
						tab.append("		<td>" + (servicoDTO.getNomeServico() != null && !servicoDTO.getNomeServico().isEmpty() ? servicoDTO.getNomeServico() : "") + "</td>");
						tab.append("		<td>" + geraLabelTipoServico(request, servicoDTO) + "</td>");
						if (TipoServico.SERVICO_APOIO.getIdentificador().equalsIgnoreCase(servicoDTO.getTipoServico())) {
							tab.append("		<td><button type=\"button\" class=\"btn-mini btn-block btn-default\" onclick=\"ItemConfiguracao.View.Tab.Impactos.openServiceDesign(" + servicoDTO.getIdServico() + ")\">"
									+ UtilI18N.internacionaliza(request, "citcorpore.comum.mapa") + "</button></td>");
						} else {
							tab.append("		<td><button type=\"button\" class=\"btn-mini btn-block btn-default\" onclick=\"ItemConfiguracao.View.Tab.Impactos.openServiceDesignForBusinessService("
									+ servicoDTO.getIdServico() + ")\">" + UtilI18N.internacionaliza(request, "citcorpore.comum.mapa") + "</button></td>");
						}

						tab.append("	</tr>");
					}

					tab.append("	</tbody>");
					tab.append("</table>");
				}
			} else if (gerenciamentoItemConfiguracaoDTO.getControllerTab().equalsIgnoreCase("tab-historico")) {
				tab.setLength(0);

				List<HistoricoItemConfiguracaoDTO> HistoricoItemConfiguracaoListDTO = getHistoricoItemConfiguracaoService().listHistoricoItemByIditemconfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());

				if (HistoricoItemConfiguracaoListDTO != null && !HistoricoItemConfiguracaoListDTO.isEmpty()) {
					tab.append("<table id=\"" + gerenciamentoItemConfiguracaoDTO.getControllerTab() + "-tabela\" class=\"table table-bordered table-striped\">");
					tab.append("	<thead>");
					tab.append("		<tr>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "itemConfiguracaoTree.versaoHistorico") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.identificacao") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "itemConfiguracaoTree.familia") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "itemConfiguracaoTree.localidade") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "itemConfiguracaoTree.dataExpiracao") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "colaborador.colaborador") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "itemConfiguracaoTree.versao") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "itemConfiguracaoTree.tipoItem") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "problema.impacto") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "itemConfiguracaoTree.urgencia") + "</th>");
					tab.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.acoes") + "</th>");
					tab.append("		</tr>");
					tab.append("	</thead>");
					tab.append("	<tbody>");

					for (HistoricoItemConfiguracaoDTO historicoItemConfiguracaoDTO : HistoricoItemConfiguracaoListDTO) {
						tab.append("	<tr>");
						tab.append("		<td>" + (historicoItemConfiguracaoDTO.getHistoricoVersao() != null ? historicoItemConfiguracaoDTO.getHistoricoVersao().floatValue() + " - " : "") + UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, historicoItemConfiguracaoDTO.getDataHoraAlteracao(), WebUtil.getLanguage(request)) + "</td>");
						tab.append("		<td>" + (historicoItemConfiguracaoDTO.getIdentificacao() != null && !historicoItemConfiguracaoDTO.getIdentificacao().isEmpty() ? historicoItemConfiguracaoDTO.getIdentificacao() : "") + "</td>");
						tab.append("		<td>" + (historicoItemConfiguracaoDTO.getFamilia() != null && !historicoItemConfiguracaoDTO.getFamilia().isEmpty() ? historicoItemConfiguracaoDTO.getFamilia() : "") + "</td>");
						tab.append("		<td>" + (historicoItemConfiguracaoDTO.getLocalidade() != null && !historicoItemConfiguracaoDTO.getLocalidade().isEmpty() ? historicoItemConfiguracaoDTO.getLocalidade() : "") + "</td>");
						tab.append("		<td>" + (historicoItemConfiguracaoDTO.getDataExpiracao() != null ? UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, historicoItemConfiguracaoDTO.getDataExpiracao(), WebUtil.getLanguage(request)) : "") + "</td>");
						tab.append("		<td>" + (historicoItemConfiguracaoDTO.getNomeProprietario() != null && !historicoItemConfiguracaoDTO.getNomeProprietario().isEmpty() ? historicoItemConfiguracaoDTO.getNomeProprietario() : "") + "</td>");
						tab.append("		<td>" + (historicoItemConfiguracaoDTO.getVersao() != null && !historicoItemConfiguracaoDTO.getVersao().isEmpty() ? historicoItemConfiguracaoDTO.getVersao() : "") + "</td>");
						tab.append("		<td>" + (historicoItemConfiguracaoDTO.getNomeTipoItemConfiguracao() != null && !historicoItemConfiguracaoDTO.getNomeTipoItemConfiguracao().isEmpty() ? historicoItemConfiguracaoDTO.getNomeTipoItemConfiguracao() : "") + "</td>");

						if (historicoItemConfiguracaoDTO.getImpacto() != null && !historicoItemConfiguracaoDTO.getImpacto().isEmpty()) {
							switch (historicoItemConfiguracaoDTO.getImpacto()) {
							case "B":
								tab.append("<td>" + UtilI18N.internacionaliza(request, "citcorpore.comum.baixa") + "</td>");
								break;
							case "M":
								tab.append("<td>" + UtilI18N.internacionaliza(request, "citcorpore.comum.media") + "</td>");
								break;
							case "A":
								tab.append("<td>" + UtilI18N.internacionaliza(request, "citcorpore.comum.alta") + "</td>");
								break;
							default:
								tab.append("<td></td>");
								break;
							}
						} else {
							tab.append("<td></td>");
						}

						if (historicoItemConfiguracaoDTO.getUrgencia() != null && !historicoItemConfiguracaoDTO.getUrgencia().isEmpty()) {
							switch (historicoItemConfiguracaoDTO.getUrgencia()) {
							case "B":
								tab.append("<td>" + UtilI18N.internacionaliza(request, "citcorpore.comum.baixa") + "</td>");
								break;
							case "M":
								tab.append("<td>" + UtilI18N.internacionaliza(request, "citcorpore.comum.media") + "</td>");
								break;
							case "A":
								tab.append("<td>" + UtilI18N.internacionaliza(request, "citcorpore.comum.alta") + "</td>");
								break;
							default:
								tab.append("<td></td>");
								break;
							}
						} else {
							tab.append("<td></td>");
						}
						if(request.getParameter("isIframe").toString().equals("true")){
							tab.append("		<td><button type=\"button\" disabled=\"disabled\" class=\"btn-mini btn-block btn-default\" onclick=\"ItemConfiguracao.View.Tab.Historico.Baseline.restore(" + historicoItemConfiguracaoDTO.getIdHistoricoIC() + ")\">".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.restaurar")).concat("</button></td>"));
						}else{
							tab.append("		<td><button type=\"button\" class=\"btn-mini btn-block btn-default\" onclick=\"ItemConfiguracao.View.Tab.Historico.Baseline.restore(" + historicoItemConfiguracaoDTO.getIdHistoricoIC() + ")\">".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.restaurar")).concat("</button></td>"));
						}
						tab.append("	</tr>");
					}

					tab.append("	</tbody>");
					tab.append("</table>");

				} else {
					tab.append("<div class=\"row-fluid\">");
					tab.append("	<div class=\"span12\">");
					tab.append("		<p class=\"align-center\">".concat(UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.nenhumitemencontrado")).concat("</p>"));
					tab.append("	</div>");
					tab.append("</div>");
				}

				tab.append("<div class=\"separator top\"></div>");

				tab.append("<div class=\"row-fluid iframe-view-hidden\">");
				tab.append("	<div class=\"span4\">");
				tab.append("		<button type=\"button\" class=\"btn btn-block btn-default\" onclick=\"ItemConfiguracao.View.Tab.Historico.Baseline.generate();\">" + UtilI18N.internacionaliza(request, "itemConfiguracaoTree.gerarPontoRestauracao") + "</button>");
				tab.append("	</div>");
				tab.append("</div>");
			} else if (gerenciamentoItemConfiguracaoDTO.getControllerTab().equalsIgnoreCase("tab-item-configuracao-pai")) {
				if (itemConfiguracaoDTO.getIdItemConfiguracaoPai() != null) {
					tab.setLength(0);

					EmpregadoDTO empregadoDTO = new EmpregadoDTO();
					GrupoDTO grupoDTO = new GrupoDTO();

					ItemConfiguracaoDTO itemConfiguracaoPaiDTO = new ItemConfiguracaoDTO();
					itemConfiguracaoPaiDTO = getItemConfiguracaoService().restoreByIdItemConfiguracao(itemConfiguracaoDTO.getIdItemConfiguracaoPai());

					tab.append("<div class=\"row-fluid\">");
					tab.append("<div class=\"span4\">");
					tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "limiteAprovacao.identificacao")).concat("</h5>"));
					tab.append("<p>" + (itemConfiguracaoPaiDTO.getIdentificacao() != null && !itemConfiguracaoPaiDTO.getIdentificacao().isEmpty() ? itemConfiguracaoPaiDTO.getIdentificacao() : "-") + "</p>");
					tab.append("</div>");
					tab.append("<div class=\"span4\">");
					tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "lingua.nome")).concat("</h5>"));
					tab.append("<p>" + (itemConfiguracaoPaiDTO.getNome() != null && !itemConfiguracaoPaiDTO.getNome().isEmpty() ? itemConfiguracaoPaiDTO.getNome() : "-") + "</p>");
					tab.append("</div>");
					tab.append("<div class=\"span4\">");
					tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "lookup.contrato")).concat("</h5>"));

					if (itemConfiguracaoPaiDTO.getIdContrato() != null) {
						ContratoDTO contratoDTO = new ContratoDTO();
						contratoDTO.setIdContrato(itemConfiguracaoPaiDTO.getIdContrato());
						contratoDTO = (ContratoDTO) getContratoService().restore(contratoDTO);

						tab.append("<p>" + contratoDTO.getNumero() + "</p>");
					} else {
						tab.append("<p>-</p>");
					}

					tab.append("</div>");
					tab.append("</div>");
					tab.append("<div class=\"row-fluid\">");
					tab.append("<div class=\"span4\">");
					tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.familia")).concat("</h5>"));
					tab.append("<p>" + (itemConfiguracaoPaiDTO.getFamilia() != null && !itemConfiguracaoPaiDTO.getFamilia().isEmpty() ? itemConfiguracaoPaiDTO.getFamilia() : "-") + "</p>");
					tab.append("</div>");
					tab.append("<div class=\"span4\">");
					tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.classe")).concat("</h5>"));
					tab.append("<p>" + (itemConfiguracaoPaiDTO.getClasse() != null && !itemConfiguracaoPaiDTO.getClasse().isEmpty() ? itemConfiguracaoPaiDTO.getClasse() : "-") + "</p>");
					tab.append("</div>");
					tab.append("<div class=\"span4\">");
					tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.versao")).concat("</h5>"));
					tab.append("<p>" + (itemConfiguracaoPaiDTO.getVersao() != null && !itemConfiguracaoPaiDTO.getVersao().isEmpty() ? itemConfiguracaoPaiDTO.getVersao() : "-") + "</p>");
					tab.append("</div>");
					tab.append("</div>");
					tab.append("<div class=\"row-fluid\">");
					tab.append("<div class=\"span4\">");
					tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.nSerie")).concat("</h5>"));
					tab.append("<p>" + (itemConfiguracaoPaiDTO.getNumeroSerie() != null && !itemConfiguracaoPaiDTO.getNumeroSerie().isEmpty() ? itemConfiguracaoPaiDTO.getNumeroSerie() : "-") + "</p>");
					tab.append("</div>");
					tab.append("<div class=\"span4\">");
					tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.localidade")).concat("</h5>"));
					tab.append("<p>" + (itemConfiguracaoPaiDTO.getLocalidade() != null && !itemConfiguracaoPaiDTO.getLocalidade().isEmpty() ? itemConfiguracaoPaiDTO.getLocalidade() : "-") + "</p>");
					tab.append("</div>");
					tab.append("<div class=\"span4\">");
					tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.dataExpiracao")).concat("</h5>"));
					tab.append("<p>" + (itemConfiguracaoPaiDTO.getDataExpiracao() != null ? UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, itemConfiguracaoPaiDTO.getDataExpiracao()) : "-") + "</p>");
					tab.append("</div>");
					tab.append("</div>");
					tab.append("<div class=\"row-fluid\">");

					tab.append("<div class=\"span4\">");
					tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.midia")).concat("</h5>"));

					if (itemConfiguracaoPaiDTO.getIdMidiaSoftware() != null) {
						MidiaSoftwareDTO midiaSoftwareDTO = new MidiaSoftwareDTO();
						midiaSoftwareDTO.setIdMidiaSoftware(itemConfiguracaoPaiDTO.getIdMidiaSoftware());
						midiaSoftwareDTO = (MidiaSoftwareDTO) getMidiaSoftwareService().restore(midiaSoftwareDTO);

						if (midiaSoftwareDTO != null) {
							tab.append("<p>" + midiaSoftwareDTO.getNome() + "</p>");
						} else {
							tab.append("<p>-</p>");
						}
					} else {
						tab.append("<p>-</p>");
					}

					tab.append("</div>");

					tab.append("<div class=\"span4\">");
					tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.tipoItemConfiguracao")).concat("</h5>"));

					if (itemConfiguracaoPaiDTO.getIdTipoItemConfiguracao() != null) {
						TipoItemConfiguracaoDTO tipoItemConfiguracaoDTO = new TipoItemConfiguracaoDTO();
						tipoItemConfiguracaoDTO.setId(itemConfiguracaoDTO.getIdTipoItemConfiguracao());
						tipoItemConfiguracaoDTO = (TipoItemConfiguracaoDTO) getTipoItemConfiguracaoService().restore(tipoItemConfiguracaoDTO);
						if (tipoItemConfiguracaoDTO != null) {
							tab.append("<p>" + tipoItemConfiguracaoDTO.getNome() + "</p>");
						} else {
							tab.append("<p>-</p>");
						}
					} else {
						tab.append("<p>-</p>");
					}

					tab.append("</div>");
					tab.append("<div class=\"span4\">");
					tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.status")).concat("</h5>"));

					if (itemConfiguracaoDTO.getStatus() != null) {
						Enumerados.StatusIC statusIc = Enumerados.StatusIC.getStatus(itemConfiguracaoDTO.getStatus());
						tab.append("<p>" + UtilI18N.internacionaliza(request, statusIc.getChaveInternacionalizacao()) + "</p>");
					} else {
						tab.append("<p>-</p>");
					}

					tab.append("</div>");
					tab.append("</div>");
					tab.append("<div class=\"row-fluid\">");
					tab.append("<div class=\"span4\">");
					tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.ativofixo")).concat("</h5>"));
					tab.append("<p>" + (itemConfiguracaoPaiDTO.getAtivoFixo() != null && !itemConfiguracaoPaiDTO.getAtivoFixo().isEmpty() ? itemConfiguracaoPaiDTO.getAtivoFixo() : "-") + "</p>");
					tab.append("</div>");
					tab.append("<div class=\"span4\">");
					tab.append("<h5>Criticidade do Servio</h5>");

					if (itemConfiguracaoPaiDTO.getCriticidade() != null) {
						for (Enumerados.CriticidadeIC criticidade : Enumerados.CriticidadeIC.values()) {
							if (itemConfiguracaoPaiDTO.getCriticidade().equals(criticidade.getItem())) {
								tab.append("<p>" + UtilI18N.internacionaliza(request, criticidade.getDescricao()) + "</p>");
							}
						}
					} else {
						tab.append("<p>-</p>");
					}

					tab.append("</div>");
					tab.append("<div class=\"span4\">");
					tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "problema.impacto")).concat("</h5>"));

					if (itemConfiguracaoDTO.getImpacto() != null) {
						switch (itemConfiguracaoDTO.getImpacto()) {
						case "B":
							tab.append("<p>" + UtilI18N.internacionaliza(request, "citcorpore.comum.baixa") + "</p>");
							break;
						case "M":
							tab.append("<p>" + UtilI18N.internacionaliza(request, "citcorpore.comum.media") + "</p>");
							break;
						case "A":
							tab.append("<p>" + UtilI18N.internacionaliza(request, "citcorpore.comum.alta") + "</p>");
							break;
						default:
							tab.append("<p>-</p>");
							break;
						}
					} else {
						tab.append("<p>-</p>");
					}

					tab.append("</div>");
					tab.append("</div>");
					tab.append("<div class=\"row-fluid\">");
					tab.append("<div class=\"span4\">");
					tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.urgencia")).concat("</h5>"));

					if (itemConfiguracaoDTO.getUrgencia() != null) {
						switch (itemConfiguracaoDTO.getUrgencia()) {
						case "B":
							tab.append("<p>" + UtilI18N.internacionaliza(request, "citcorpore.comum.baixa") + "</p>");
							break;
						case "M":
							tab.append("<p>" + UtilI18N.internacionaliza(request, "citcorpore.comum.media") + "</p>");
							break;
						case "A":
							tab.append("<p>" + UtilI18N.internacionaliza(request, "citcorpore.comum.alta") + "</p>");
							break;
						default:
							tab.append("<p>-</p>");
							break;
						}
					} else {
						tab.append("<p>-</p>");
					}

					tab.append("</div>");
					tab.append("<div class=\"span4\">");
					tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "mapaDesenhoCatalogoNegocio.funcionario")).concat("</h5>"));

					if (itemConfiguracaoPaiDTO.getIdProprietario() != null) {
						empregadoDTO = new EmpregadoDTO();
						empregadoDTO.setIdEmpregado(itemConfiguracaoPaiDTO.getIdProprietario());
						empregadoDTO = (EmpregadoDTO) getEmpregadoService().restore(empregadoDTO);
						if (empregadoDTO != null) {
							tab.append("<p>" + empregadoDTO.getNome() + "</p>");
						} else {
							tab.append("<p>-</p>");
						}
					} else {
						tab.append("<p>-</p>");
					}

					tab.append("</div>");
					tab.append("<div class=\"span4\">");
					tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.grupo")).concat("</h5>"));

					if (itemConfiguracaoPaiDTO.getIdGrupoItemConfiguracao() != null && itemConfiguracaoPaiDTO.getIdGrupoItemConfiguracao() > 0) {
						GrupoItemConfiguracaoDTO grupoItemConfiguracaoDTO = new GrupoItemConfiguracaoDTO();

						grupoItemConfiguracaoDTO.setIdGrupoItemConfiguracao(itemConfiguracaoPaiDTO.getIdGrupoItemConfiguracao());
						grupoItemConfiguracaoDTO = (GrupoItemConfiguracaoDTO) getGrupoItemConfiguracaoService().restore(grupoItemConfiguracaoDTO);
						if (grupoItemConfiguracaoDTO != null) {
							tab.append("<p>" + grupoItemConfiguracaoDTO.getNomeGrupoItemConfiguracao() + "</p>");
						} else {
							tab.append("<p>-</p>");
						}
					} else {
						tab.append("<p>-</p>");
					}

					tab.append("</div>");
					tab.append("</div>");
					tab.append("<div class=\"row-fluid\">");

					tab.append("<div class=\"span4\">");
					tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.mudanca")).concat("</h5>"));

					if (itemConfiguracaoPaiDTO.getIdMudanca() != null) {
						RequisicaoMudancaDTO requisicaoMudancaDTO = new RequisicaoMudancaDTO();
						requisicaoMudancaDTO.setIdRequisicaoMudanca(itemConfiguracaoPaiDTO.getIdMudanca());
						requisicaoMudancaDTO = (RequisicaoMudancaDTO) getRequisicaoMudancaService().restore(requisicaoMudancaDTO);
						if (requisicaoMudancaDTO != null) {
							tab.append("<p>" + requisicaoMudancaDTO.getIdRequisicaoMudanca() + " - " + requisicaoMudancaDTO.getTitulo() + " - " + UtilI18N.internacionaliza(request, requisicaoMudancaDTO.getDescrStatus()) + "</p>");
						} else {
							tab.append("<p>-</p>");
						}
					} else {
						tab.append("<p>-</p>");
					}

					tab.append("</div>");

					tab.append("<div class=\"span4\">");
					tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.tipoResponsavel")).concat("</h5>"));

					if (itemConfiguracaoPaiDTO.getIdResponsavel() != null) {
						itemConfiguracaoPaiDTO.setTipoResponsavel("U");
					} else if (itemConfiguracaoPaiDTO.getIdGrupoResponsavel() != null) {
						itemConfiguracaoPaiDTO.setTipoResponsavel("G");
					}

					if (itemConfiguracaoPaiDTO.getTipoResponsavel() != null) {
						switch (itemConfiguracaoPaiDTO.getTipoResponsavel()) {
						case "U":
							tab.append("<p>" + UtilI18N.internacionaliza(request, "citcorpore.comum.usuario") + "</p>");
							break;
						case "G":
							tab.append("<p>" + UtilI18N.internacionaliza(request, "controle.grupo") + "</p>");
							break;
						default:
							tab.append("<p>-</p>");
							break;
						}
					} else {
						tab.append("<p>-</p>");
					}

					tab.append("</div>");
					tab.append("<div class=\"span4\">");
					tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "gerenciamentoservico.responsavel")).concat("</h5>"));

					if (itemConfiguracaoPaiDTO.getIdResponsavel() != null) {
						empregadoDTO = new EmpregadoDTO();
						empregadoDTO.setIdEmpregado(itemConfiguracaoPaiDTO.getIdResponsavel());
						empregadoDTO = (EmpregadoDTO) getEmpregadoService().restore(empregadoDTO);
						if (empregadoDTO != null) {
							tab.append("<p>" + empregadoDTO.getNome() + "</p>");
						} else {
							tab.append("<p>-</p>");
						}
					} else if (itemConfiguracaoPaiDTO.getIdGrupoResponsavel() != null) {
						grupoDTO.setIdGrupo(itemConfiguracaoPaiDTO.getIdGrupoResponsavel());
						grupoDTO = (GrupoDTO) getGrupoService().restore(grupoDTO);
						if (grupoDTO != null) {
							tab.append("<p>" + grupoDTO.getNome() + "</p>");
						} else {
							tab.append("<p>-</p>");
						}
					} else {
						tab.append("<p>-</p>");
					}

					tab.append("</div>");
					tab.append("</div>");
					tab.append("<div class=\"row-fluid\">");
					tab.append("<div class=\"span12\">");
					tab.append("<h5>".concat(UtilI18N.internacionaliza(request, "entrevistaCandidato.informacoesAdicionais")).concat("</h5>"));
					tab.append("<p>" + (itemConfiguracaoPaiDTO.getInformacoesAdicionais() != null && !itemConfiguracaoPaiDTO.getInformacoesAdicionais().isEmpty() ? itemConfiguracaoPaiDTO.getInformacoesAdicionais() : "-") + "</p>");
					tab.append("</div>");
					tab.append("</div>");

				}

			} // fim da aba de item de configurao pai

			if (tab.toString().isEmpty()) {
				tab.append("<div class=\"row-fluid\">");
				tab.append("	<div class=\"span12\">");
				tab.append("		<p class=\"align-center\">".concat(UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.nenhumitemencontrado")).concat("</p>"));
				tab.append("	</div>");
				tab.append("</div>");
			}

			HTMLElement tabElement = document.getElementById(gerenciamentoItemConfiguracaoDTO.getControllerTab());
			tabElement.setInnerHTML(tab.toString());

			document.executeScript("ItemConfiguracao.View.Tab.Loading.close($(\"#" + gerenciamentoItemConfiguracaoDTO.getControllerTab() + "\"));");
		}
	}

	/**
	 * Carrega os dados de auditoria.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.acorse
	 */
	public void loadAuditoria(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();

		StringBuilder tab = new StringBuilder();

		if (gerenciamentoItemConfiguracaoDTO.getDataInicioAuditoria() != null && gerenciamentoItemConfiguracaoDTO.getDataFimAuditoria() != null) {
			ItemConfiguracaoDTO itemConfiguracaoDTO = new ItemConfiguracaoDTO();

			if (StringUtils.isNotBlank(request.getParameter("idInfoItem"))) {
				itemConfiguracaoDTO = getItemConfiguracaoService().restoreByIdItemConfiguracao(Integer.parseInt(request.getParameter("idInfoItem")));
			} else {
				itemConfiguracaoDTO = getItemConfiguracaoService().restoreByIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());
			}

			itemConfiguracaoDTO.setDataInicioHistorico(gerenciamentoItemConfiguracaoDTO.getDataInicioAuditoria());
			itemConfiguracaoDTO.setDataFimHistorico(gerenciamentoItemConfiguracaoDTO.getDataFimAuditoria());

			List<AuditoriaItemConfigDTO> AuditoriaItemConfigListDTO = getItemConfiguracaoService().historicoAlteracaoItemConfiguracaoByIdItemConfiguracao(itemConfiguracaoDTO);

			if (AuditoriaItemConfigListDTO != null && !AuditoriaItemConfigListDTO.isEmpty()) {
				tab.append("<table class=\"table table-bordered table-striped\">");
				tab.append("	<thead>");
				tab.append("		<tr>");
				tab.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.identificacao") + "</th>");
				tab.append("			<th>" + UtilI18N.internacionaliza(request, "itemConfiguracaoTree.tipoItemConfiguracao") + "</th>");
				tab.append("			<th>" + UtilI18N.internacionaliza(request, "eventoItemConfiguracao.usuario") + "</th>");
				tab.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.dataAlteracao") + "</th>");
				tab.append("			<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.tipoModificacao") + "</th>");
				tab.append("		</tr>");
				tab.append("	</thead>");
				tab.append("	<tbody>");

				for (AuditoriaItemConfigDTO auditoriaItemConfigDTO : AuditoriaItemConfigListDTO) {
					tab.append("	<tr>");
					tab.append("		<td>" + auditoriaItemConfigDTO.getIdentificacao() + "</td>");
					tab.append("		<td>" + auditoriaItemConfigDTO.getTipoItemConfiguracao());
					if(auditoriaItemConfigDTO.getNomeCaracteristica() != null){
						tab.append(" - ").append(auditoriaItemConfigDTO.getNomeCaracteristica());
					}
					tab.append("		</td>");
					tab.append("		<td>" + (auditoriaItemConfigDTO.getLogin() != null && !auditoriaItemConfigDTO.getLogin().isEmpty() ? auditoriaItemConfigDTO.getLogin() : "") + "</td>");
					tab.append("		<td>" + UtilDatas.convertDateToString(TipoDate.TIMESTAMP_WITH_SECONDS, auditoriaItemConfigDTO.getDataHoraAlteracao(), WebUtil.getLanguage(request)) + "</td>");

					String tipoAlteracaoInter = null;
					if (auditoriaItemConfigDTO.getTipoAlteracao() != null) {
						Enumerados.TipoAlteracao aux = Enumerados.TipoAlteracao.fromIdentificador(auditoriaItemConfigDTO.getTipoAlteracao());
						if (aux != null) {
							tipoAlteracaoInter = UtilI18N.internacionaliza(request, aux.getChave());
						} else {
							tipoAlteracaoInter = auditoriaItemConfigDTO.getTipoAlteracao();
					}
					}

					tab.append("		<td>" + tipoAlteracaoInter + "</td>");
					tab.append("	</tr>");
				}

				tab.append("	</tbody>");
				tab.append("</table>");
			}
		}

		if (tab.toString().isEmpty()) {
			tab.append("<div class=\"row-fluid\">");
			tab.append("	<div class=\"span12\">");
			tab.append("		<p class=\"align-center\">".concat(UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.nenhumitemencontrado")).concat("</p>"));
			tab.append("	</div>");
			tab.append("</div>");
		}

		HTMLElement tabElement = document.getElementById("auditoria-content");
		tabElement.setInnerHTML(tab.toString());
	}

	/**
	 * Aplica filtros os filtros da pesquisa e recupera a listagem de itens de configurao
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author thyen.chang
	 */
	public void filtraListagem(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();

		if (gerenciamentoItemConfiguracaoDTO.getFiltroStatus() == null && gerenciamentoItemConfiguracaoDTO.getFiltroCriticidade() == null && (gerenciamentoItemConfiguracaoDTO.getFiltroIdentificacao() == null || gerenciamentoItemConfiguracaoDTO.getFiltroIdentificacao().isEmpty()) && (gerenciamentoItemConfiguracaoDTO.getFiltroDashboard() == null || gerenciamentoItemConfiguracaoDTO.getFiltroDashboard().isEmpty())) {
			if (gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo() != null && gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo() > 0) {
				inventoryNavigate(document, request, response);
				return;
			} else {
				inventoryStart(document, request, response);
				return;
			}
		}

		ItemConfiguracaoService itemConfiguracaoService = getItemConfiguracaoService();
		List<ItemConfiguracaoDTO> listaItensFiltro = itemConfiguracaoService.listItensByGerenciamentoItemConfiguracaoDTO(gerenciamentoItemConfiguracaoDTO);

		List<InventarioElementoDTO> inventarioElementos = new ArrayList<InventarioElementoDTO>();

		if (listaItensFiltro != null) {
			for (ItemConfiguracaoDTO itemConfiguracaoDTO : listaItensFiltro) {
				InventarioElementoDTO inventarioElementoDTO = new InventarioElementoDTO();
				inventarioElementoDTO.setId(itemConfiguracaoDTO.getIdItemConfiguracao());

				if (exibeNome && itemConfiguracaoDTO.getNome() != null && !itemConfiguracaoDTO.getNome().isEmpty()) {
					inventarioElementoDTO.setNome(itemConfiguracaoDTO.getNome());
				} else {
					inventarioElementoDTO.setNome(itemConfiguracaoDTO.getIdentificacao());
				}

				if (itemConfiguracaoDTO.getImagem() != null && !itemConfiguracaoDTO.getImagem().isEmpty()) {
					inventarioElementoDTO.setIcone(itemConfiguracaoDTO.getImagem());
				} else if (itemConfiguracaoDTO.getIdTipoItemConfiguracao() != null) {
					TipoItemConfiguracaoDTO tipoItemConfiguracaoDTO = new TipoItemConfiguracaoDTO();
					tipoItemConfiguracaoDTO.setId(itemConfiguracaoDTO.getIdTipoItemConfiguracao());
					tipoItemConfiguracaoDTO = getTipoItemConfiguracaoService().restore(tipoItemConfiguracaoDTO);

					if (tipoItemConfiguracaoDTO.getImagem() != null && !tipoItemConfiguracaoDTO.getImagem().isEmpty()) {
						inventarioElementoDTO.setIcone(tipoItemConfiguracaoDTO.getImagem());
					} else {
						inventarioElementoDTO.setIcone("devices");
					}
				} else {
					inventarioElementoDTO.setIcone("devices");
				}

				inventarioElementoDTO.setTipo(TipoElementoInventario.ITEMCONFIGURACAO.getCodigo());

				Enumerados.StatusIC statusIc = Enumerados.StatusIC.getStatus(itemConfiguracaoDTO.getStatus() != null ? itemConfiguracaoDTO.getStatus() : 1);
				inventarioElementoDTO.setExtra("<span class=\"status status-one label " + statusIc.getLabel() + "\" title=\"" + UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.itemconfiguracaostatus") + "\">" + UtilI18N.internacionaliza(request, statusIc.getChaveInternacionalizacao()) + "</span>");

				inventarioElementos.add(inventarioElementoDTO);
			}
		}

		document.executeScript("Inventory.Widget.add({ widgets : " + new Gson().toJson(inventarioElementos) + "}, true);");
	}

	/**
	 * Carrega itens da modal de grupo
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author thyen.chang
	 */
	public void loadModalGrupo(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		HTMLSelect grupoPai = document.getSelectById("grupopai");
		grupoPai.removeAllOptions();

		GrupoItemConfiguracaoService grupoItemConfiguracaoService = getGrupoItemConfiguracaoService();
		List<GrupoItemConfiguracaoDTO> listGrupos = new ArrayList<>();

		GrupoItemConfiguracaoDTO grupoItemConfiguracaoDTO = new GrupoItemConfiguracaoDTO();
		grupoItemConfiguracaoDTO.setIdGrupoItemConfiguracao(ID_CICLO_DESENVOLVIMENTO);
		grupoItemConfiguracaoDTO.setNomeGrupoItemConfiguracao(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.CICLO_DE_VIDA_IC_DESENVOLVIMENTO, UtilI18N.internacionaliza(request, "itemConfiguracao.ciclo.desenvolvimento")).trim());
		listGrupos.add(grupoItemConfiguracaoDTO);

		grupoItemConfiguracaoDTO = new GrupoItemConfiguracaoDTO();
		grupoItemConfiguracaoDTO.setIdGrupoItemConfiguracao(ID_CICLO_HOMOLOGACA0);
		grupoItemConfiguracaoDTO.setNomeGrupoItemConfiguracao(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.CICLO_DE_VIDA_IC_HOMOLOGACAO, UtilI18N.internacionaliza(request, "itemConfiguracao.ciclo.homologacao")).trim());
		listGrupos.add(grupoItemConfiguracaoDTO);

		grupoItemConfiguracaoDTO = new GrupoItemConfiguracaoDTO();
		grupoItemConfiguracaoDTO.setIdGrupoItemConfiguracao(ID_CICLO_PRODUCAO);
		grupoItemConfiguracaoDTO.setNomeGrupoItemConfiguracao(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.CICLO_DE_VIDA_IC_PRODUCAO, UtilI18N.internacionaliza(request, "itemConfiguracao.ciclo.producao")).trim());
		listGrupos.add(grupoItemConfiguracaoDTO);

		listGrupos.addAll(grupoItemConfiguracaoService.listGruposAtivos());

		Collections.sort(listGrupos, new Comparator<GrupoItemConfiguracaoDTO>() {

			@Override
			public int compare(GrupoItemConfiguracaoDTO o1, GrupoItemConfiguracaoDTO o2) {
				return o1.getNomeGrupoItemConfiguracao().compareTo(o2.getNomeGrupoItemConfiguracao());
			}
		});


		for (GrupoItemConfiguracaoDTO grupoItemConfiguracao : listGrupos) {
			grupoPai.addOption(JavascriptUtil.escapeJavaScript(grupoItemConfiguracao.getIdGrupoItemConfiguracao().toString()), JavascriptUtil.escapeJavaScript(grupoItemConfiguracao.getNomeGrupoItemConfiguracao()));
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		if (gerenciamentoItemConfiguracaoDTO != null && gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo() != null) {
			document.executeScript("$('#modal-controller-grupo #grupopai').val('".concat(gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo().toString()).concat("');"));
		}

	}

	public void carregaNomeGrupoModal(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		loadModalGrupo(document, request, response);
		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		if (gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo() != null) {
			GrupoItemConfiguracaoService grupoItemConfiguracaoService = getGrupoItemConfiguracaoService();
			List<GrupoItemConfiguracaoDTO> listGrupo = grupoItemConfiguracaoService.findGrupoById(gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo());

			if (listGrupo != null && listGrupo.size() > 0) {
				if (listGrupo.get(0).getNomeGrupoItemConfiguracao() != null) {
					document.executeScript("$('#modal-controller-grupo #modalNome').val('".concat(listGrupo.get(0).getNomeGrupoItemConfiguracao()).concat("');"));
				}
				if (listGrupo.get(0).getIdGrupoItemConfiguracaoPai() != null) {
					document.executeScript("$('#modal-controller-grupo #grupopai').val('".concat(listGrupo.get(0).getIdGrupoItemConfiguracaoPai().toString()).concat("');"));
				}
				if (listGrupo.get(0).getImagem() != null && !listGrupo.get(0).getImagem().isEmpty()) {
					document.executeScript("$(\"#modal-controller-grupo input[name='grupoImagem'][value='" + listGrupo.get(0).getImagem() + "']\").prop(\"checked\", true);");
				}
				if (listGrupo.get(0).getCorFundo() != null && !listGrupo.get(0).getCorFundo().isEmpty()) {
					document.executeScript("$(\"#modal-controller-grupo #grupoCorFundo\").val(\"" + listGrupo.get(0).getCorFundo() + "\");");
				} else {
					document.executeScript("$(\"#modal-controller-grupo #grupoCorFundo\").val(\"#f4f4f4\");");
				}
				if (listGrupo.get(0).getCorTexto() != null && !listGrupo.get(0).getCorTexto().isEmpty()) {
					document.executeScript("$(\"#modal-controller-grupo #grupoCorTexto\").val(\"" + listGrupo.get(0).getCorTexto() + "\");");
				} else {
					document.executeScript("$(\"#modal-controller-grupo #grupoCorTexto\").val(\"#999999\");");
				}

				document.executeScript("$(\"#modal-controller-grupo #grupoCorFundo\").keyup();");
				document.executeScript("$(\"#modal-controller-grupo #grupoCorTexto\").keyup();");
			}
		}
	}

	public void adicionaGrupo(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		GrupoItemConfiguracaoDTO grupoItemConfiguracaoDTO = new GrupoItemConfiguracaoDTO();
		grupoItemConfiguracaoDTO.setNomeGrupoItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getControllerNomeGrupoItemConfiguracao());
		grupoItemConfiguracaoDTO.setIdGrupoItemConfiguracaoPai(gerenciamentoItemConfiguracaoDTO.getControllerGrupoPaiItemConfiguracao());
		grupoItemConfiguracaoDTO.setImagem(gerenciamentoItemConfiguracaoDTO.getControllerGrupoImagem());
		if (gerenciamentoItemConfiguracaoDTO.getControllerGrupoCorFundo() != null && !gerenciamentoItemConfiguracaoDTO.getControllerGrupoCorFundo().isEmpty() && !gerenciamentoItemConfiguracaoDTO.getControllerGrupoCorFundo().equalsIgnoreCase("#f4f4f4")) {
			grupoItemConfiguracaoDTO.setCorFundo(gerenciamentoItemConfiguracaoDTO.getControllerGrupoCorFundo());
		}
		if (gerenciamentoItemConfiguracaoDTO.getControllerGrupoCorTexto() != null && !gerenciamentoItemConfiguracaoDTO.getControllerGrupoCorTexto().isEmpty() && !gerenciamentoItemConfiguracaoDTO.getControllerGrupoCorTexto().equalsIgnoreCase("#999999")) {
			grupoItemConfiguracaoDTO.setCorTexto(gerenciamentoItemConfiguracaoDTO.getControllerGrupoCorTexto());
		}

		salvarGrupoItemConfiguracao(document, request, grupoItemConfiguracaoDTO);
	}

	public void editaGrupo(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		GrupoItemConfiguracaoDTO grupoItemConfiguracaoDTO = new GrupoItemConfiguracaoDTO();
		grupoItemConfiguracaoDTO.setIdGrupoItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo());
		grupoItemConfiguracaoDTO.setIdGrupoItemConfiguracaoPai(gerenciamentoItemConfiguracaoDTO.getControllerGrupoPaiItemConfiguracao());
		grupoItemConfiguracaoDTO.setNomeGrupoItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getControllerNomeGrupoItemConfiguracao());
		grupoItemConfiguracaoDTO.setImagem(gerenciamentoItemConfiguracaoDTO.getControllerGrupoImagem());
		if (gerenciamentoItemConfiguracaoDTO.getControllerGrupoCorFundo() != null && !gerenciamentoItemConfiguracaoDTO.getControllerGrupoCorFundo().isEmpty() && !gerenciamentoItemConfiguracaoDTO.getControllerGrupoCorFundo().equalsIgnoreCase("#f4f4f4")) {
			grupoItemConfiguracaoDTO.setCorFundo(gerenciamentoItemConfiguracaoDTO.getControllerGrupoCorFundo());
		}
		if (gerenciamentoItemConfiguracaoDTO.getControllerGrupoCorTexto() != null && !gerenciamentoItemConfiguracaoDTO.getControllerGrupoCorTexto().isEmpty() && !gerenciamentoItemConfiguracaoDTO.getControllerGrupoCorTexto().equalsIgnoreCase("#999999")) {
			grupoItemConfiguracaoDTO.setCorTexto(gerenciamentoItemConfiguracaoDTO.getControllerGrupoCorTexto());
		}

		salvarGrupoItemConfiguracao(document, request, grupoItemConfiguracaoDTO);

		document.executeScript("Modal.close($('#modal-controller-grupo'));");
	}

	public void salvarGrupoItemConfiguracao(DocumentHTML document, HttpServletRequest request, GrupoItemConfiguracaoDTO grupoItemConfiguracaoDTO) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		grupoItemConfiguracaoDTO.setDataInicio(UtilDatas.getDataAtual());
		GrupoItemConfiguracaoService grupoItemConfiguracaoService = getGrupoItemConfiguracaoService();
		if (grupoItemConfiguracaoDTO.getIdGrupoItemConfiguracao() != null) {
			grupoItemConfiguracaoService.update(grupoItemConfiguracaoDTO);
			document.alert(UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.grupoeditado"));
		} else {
			grupoItemConfiguracaoService.create(grupoItemConfiguracaoDTO);
			document.alert(UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.grupoeditado"));
		}
		document.executeScript("Modal.close($('#modal-controller-grupo'));");
		document.executeScript("Inventory.Widget.refresh();");
	}

	public void excluirGrupoItemConfiguracao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		GrupoItemConfiguracaoService grupoItemConfiguracaoService = getGrupoItemConfiguracaoService();
		GrupoItemConfiguracaoDTO grupoItemConfiguracaoDTO = new GrupoItemConfiguracaoDTO();
		grupoItemConfiguracaoDTO.setIdGrupoItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo());
		grupoItemConfiguracaoDTO = grupoItemConfiguracaoService.restore(grupoItemConfiguracaoDTO);
		if (!grupoItemConfiguracaoService.validaExclusaoGrupo(grupoItemConfiguracaoDTO.getIdGrupoItemConfiguracao())) {
			document.alert(UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.grupoexcluirfalha"));
		} else {
			grupoItemConfiguracaoDTO.setDataFim(UtilDatas.getDataAtual());
			grupoItemConfiguracaoService.update(grupoItemConfiguracaoDTO);
			document.alert(UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.grupoexcluido"));

			document.executeScript("Inventory.Widget.previous(\"\");");
		}
		document.executeScript("Modal.close($('#modal-controller-grupo-excluir'));");
	}

	/**
	 * Concatena ao Nome do Contrato o Nmero do Contrato + Data do Contrato + Nome do Cliente + Nome do Fornecedor.
	 *
	 * @param contratoDto
	 * @return String - Nome do Contrato tratado.
	 * @throws Exception
	 * @author valdoilo.damasceno
	 * @since 03.11.2013
	 */
	private String tratarNomeContrato(ContratoDTO contratoDto) throws Exception {
		ClienteService clienteService = (ClienteService) ServiceLocator.getInstance().getService(ClienteService.class, null);
		FornecedorService fornecedorService = (FornecedorService) ServiceLocator.getInstance().getService(FornecedorService.class, null);

		String nomeCliente = "";
		String nomeFornecedor = "";

		ClienteDTO clienteDto = new ClienteDTO();

		clienteDto.setIdCliente(contratoDto.getIdCliente());

		clienteDto = (ClienteDTO) clienteService.restore(clienteDto);

		if (clienteDto != null) {
			nomeCliente = clienteDto.getNomeRazaoSocial();
		}

		FornecedorDTO fornecedorDto = new FornecedorDTO();

		fornecedorDto.setIdFornecedor(contratoDto.getIdFornecedor());

		fornecedorDto = (FornecedorDTO) fornecedorService.restore(fornecedorDto);

		if (fornecedorDto != null) {
			nomeFornecedor = fornecedorDto.getRazaoSocial();
		}

		String nomeContrato = "" + contratoDto.getNumero() + " de " + UtilDatas.dateToSTR(contratoDto.getDataContrato()) + " (" + nomeCliente + " - " + nomeFornecedor + ")";

		return nomeContrato;
	}

	private void carregaValoresDashboard(DocumentHTML document) throws Exception {
		ItemConfiguracaoService itemConfiguracaoService = getItemConfiguracaoService();

		Integer qtdIncidentes = itemConfiguracaoService.getQuantidadeIncidentesTotalItem();
		Integer qtdMudancas = itemConfiguracaoService.getQuantidadeMudancasTotalItem();
		Integer qtdProblemas = itemConfiguracaoService.getQuantidadeProblemasTotalItem();
		Integer qtdLiberacoes = itemConfiguracaoService.getQuantidadeLiberacoesTotalItem();

		StringBuilder comando = new StringBuilder();

		comando.append("setValoresDashboard(").append(qtdIncidentes).append(",").append(qtdMudancas).append(",").append(qtdProblemas).append(",").append(qtdLiberacoes).append(");");

		document.executeScript(comando.toString());
	}

	public void executeScript(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();

		if (gerenciamentoItemConfiguracaoDTO.getControllerScript() != null && !gerenciamentoItemConfiguracaoDTO.getControllerScript().isEmpty()) {
			final ScriptRhinoJSExecute scriptExecute = new ScriptRhinoJSExecute();
			final Context cx = Context.enter();
			final Scriptable scope = cx.initStandardObjects();
			scope.put("request", scope, request);
			scope.put("response", scope, response);
			scope.put("language", scope, WebUtil.getLanguage(request));

			try {
				scriptExecute.processScript(cx, scope, gerenciamentoItemConfiguracaoDTO.getControllerScript(), "Gerenciamento de Item de Configurao - Execuo de Script");

				document.alert(UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.scriptsucesso"));
				document.executeScript("Modal.close($('#modal-controller-grupo-excluir'));");
			} catch (Exception e) {
				document.alert(UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.scriptfalha"));
			}
		} else {
			document.alert(UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.scriptfalha"));
		}
	}

	/**
	 * Cria e restaura uma baseline com base no histrico escolhido.
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigopecci
	 */
	public void restoreBaseline(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();

		UsuarioDTO usuarioDTO = br.com.centralit.citcorpore.util.WebUtil.getUsuario(request);

		if (gerenciamentoItemConfiguracaoDTO.getControllerIdHistoricoItemConfiguracao() != null) {
			HistoricoItemConfiguracaoDTO historicoItemConfiguracaoDTO = new HistoricoItemConfiguracaoDTO();
			historicoItemConfiguracaoDTO.setIdHistoricoIC(gerenciamentoItemConfiguracaoDTO.getControllerIdHistoricoItemConfiguracao());
			historicoItemConfiguracaoDTO = getHistoricoItemConfiguracaoService().restore(historicoItemConfiguracaoDTO);

			historicoItemConfiguracaoDTO.setBaseLine("SIM");

			getHistoricoItemConfiguracaoService().update(historicoItemConfiguracaoDTO);

			if (historicoItemConfiguracaoDTO.getIdItemConfiguracao() != null) {
				ItemConfiguracaoDTO itemConfiguracaoDTO = new ItemConfiguracaoDTO();
				itemConfiguracaoDTO = getItemConfiguracaoService().restoreByIdItemConfiguracao(historicoItemConfiguracaoDTO.getIdItemConfiguracao());
				Integer idItemConfigutacao = itemConfiguracaoDTO.getIdItemConfiguracao();
				itemConfiguracaoDTO = new ItemConfiguracaoDTO();
				itemConfiguracaoDTO.setIdItemConfiguracao(idItemConfigutacao);

				Reflexao.copyPropertyValues(historicoItemConfiguracaoDTO, itemConfiguracaoDTO);

				List<HistoricoValorDTO> listValoresDtos = getHistoricoValorService().listHistoricoValorByIdHistoricoIc(historicoItemConfiguracaoDTO.getIdHistoricoIC());

				List<ValorDTO> listValorDto = new ArrayList<ValorDTO>();

				for (HistoricoValorDTO historicoValorDTO : listValoresDtos) {
					ValorDTO valorDTO = new ValorDTO();
					Reflexao.copyPropertyValues(historicoValorDTO, valorDTO);
					valorDTO.getIdValor();
					listValorDto.add(valorDTO);
				}

				itemConfiguracaoDTO.setValores(listValorDto);

				getItemConfiguracaoService().restaurarBaseline(itemConfiguracaoDTO, usuarioDTO);

				document.alert(UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.restauracaosucesso"));
				document.executeScript("ItemConfiguracao.View.refresh();");
			} else {
				document.alert(UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.restauracaofalha"));
			}
		} else {
			document.alert(UtilI18N.internacionaliza(request, "gerenciamentoitemconfiguracao.restauracaofalha"));
		}

		document.executeScript("$(\"#tab-historico\").attr(\"data-loaded\", \"false\");");
		document.executeScript("ItemConfiguracao.View.Tab.open($(\"#ic-container .ic-view .ic-tabs a[data-reference='tab-historico']\"));");
	}

	public void generateRestorePoint(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		ItemConfiguracaoDTO itemConfiguracaoDTO = new ItemConfiguracaoDTO();
		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = new GerenciamentoItemConfiguracaoDTO();
		if (StringUtils.isNotBlank(request.getParameter("idInfoItem"))) {
			gerenciamentoItemConfiguracaoDTO.setIdItemConfiguracao(Integer.parseInt(request.getParameter("idInfoItem")));

			HTMLForm form = document.getForm("formGerenciamentoItemConfiguracao");
			form.setValue("idInfoItem", request.getParameter("idInfoItem"));
			request.setAttribute("iFramInformacaoItemConfiguracao", true);

		} else {
			gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		}
		itemConfiguracaoDTO = getItemConfiguracaoService().restoreByIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());

		HistoricoItemConfiguracaoDTO historicoItemConfiguracaoDTO = getItemConfiguracaoService().createHistoricoItem(itemConfiguracaoDTO, null);
		historicoItemConfiguracaoDTO = getHistoricoItemConfiguracaoService().create(historicoItemConfiguracaoDTO);

		if (historicoItemConfiguracaoDTO.getIdHistoricoIC() != null) {
			document.alert(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.pontoRestauracaoGravadoSucesso"));
		} else {
			document.alert(UtilI18N.internacionaliza(request, "itemConfiguracaoTree.criarpontofalha"));
		}

		document.executeScript("$(\"#tab-historico\").attr(\"data-loaded\", \"false\");");
		document.executeScript("ItemConfiguracao.View.Tab.open($(\"#ic-container .ic-view .ic-tabs a[data-reference='tab-historico']\"));");
	}

	private void loadRelatorios(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		StringBuilder sb = new StringBuilder();
		UsuarioDTO usuario = WebUtil.getUsuario(request);

		Collection<BIConsultaDTO> biConsultaListDTO = getBIConsultaService().findByTipoModuloExibicao(TipoExibicaoRelatorio.GERAL.getIdentificador(), ModuloExibicaoRelatorio.GERENCIAMENTO_CONFIGURACAO.getIdentificador());

		if (biConsultaListDTO != null && !biConsultaListDTO.isEmpty()) {
			for (BIConsultaDTO biConsultaDTO : biConsultaListDTO) {
				sb.append("<a href='#' onclick='openReport(&#39;" + biConsultaDTO.getTipoConsulta() + "&#39;, " + biConsultaDTO.getIdConsulta() + ",&#39;G&#39;); return false;'>" + StringEscapeUtils.escapeJavaScript(biConsultaDTO.getNomeConsulta()) + "</a><br/>");
			}
		}

		Collection<SmartReportDTO> listSmartReport = getSmartReportService().findByIdsGrupoUsuarioAndTipoModuloExibicao(usuario.getColGrupos(), TipoExibicaoRelatorio.GERAL.getIdentificador(),
				ModuloExibicaoRelatorio.GERENCIAMENTO_CONFIGURACAO.getIdentificador());

		if (listSmartReport != null && !listSmartReport.isEmpty()) {
			for (SmartReportDTO smartReportDTO : listSmartReport) {
				sb.append("<a href='#' onclick='UtilSmartReport.open(" + smartReportDTO.getIdSmartReport() + ", null); return false;'>" + smartReportDTO.getIdentificacao() + "</a><br/>");
			}
		}

		if (sb.length() == 0) {
			sb.append(UtilI18N.internacionaliza(request, "citcorpore.comum.resultado"));
		}

		document.executeScript("initReports(\"" + sb.toString() + "\", 'G');");
	}

	private void loadRelatoriosEspecificos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		StringBuilder sb = new StringBuilder();
		UsuarioDTO usuario = WebUtil.getUsuario(request);

		Collection<BIConsultaDTO> biConsultaListDTO = getBIConsultaService().findByTipoModuloExibicao(TipoExibicaoRelatorio.ESPECIFICO.getIdentificador(), ModuloExibicaoRelatorio.GERENCIAMENTO_CONFIGURACAO.getIdentificador());

		if (biConsultaListDTO != null && !biConsultaListDTO.isEmpty()) {
			for (BIConsultaDTO biConsultaDTO : biConsultaListDTO) {
				sb.append("<a href='#' onclick='openReport(&#39;" + biConsultaDTO.getTipoConsulta() + "&#39;, " + biConsultaDTO.getIdConsulta() + "," + "&#39;E&#39;, ${idespecifico}); return false;'>" + StringEscapeUtils.escapeJavaScript(biConsultaDTO.getNomeConsulta()) + "</a><br/>");
			}
		}

		Collection<SmartReportDTO> listSmartReport = getSmartReportService().findByIdsGrupoUsuarioAndTipoModuloExibicao(usuario.getColGrupos(), TipoExibicaoRelatorio.ESPECIFICO.getIdentificador(),
				ModuloExibicaoRelatorio.GERENCIAMENTO_CONFIGURACAO.getIdentificador());

		if (listSmartReport != null && !listSmartReport.isEmpty()) {
			for (SmartReportDTO smartReportDTO : listSmartReport) {
				sb.append("<a href='#' onclick='UtilSmartReport.open(" + smartReportDTO.getIdSmartReport() + ", ${idespecifico}); return false;'>" + smartReportDTO.getIdentificacao() + "</a><br/>");
			}
		}

		if (sb.length() == 0) {
			sb.append(UtilI18N.internacionaliza(request, "citcorpore.comum.resultado"));
		}

		document.executeScript("initReports(\"" + sb.toString() + "\", 'E');");
	}

	public void gravarValorItemConfiguracao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		ItemConfiguracaoValorDTO itemConfiguracaoValorDTO = refleteGerenciamentoItemConfiguracaoDTO(gerenciamentoItemConfiguracaoDTO);
		String mensagem = "";
		try {
			if (itemConfiguracaoValorDTO != null && itemConfiguracaoValorDTO.getIdItemConfiguracaoValor() != null) {
				getItemConfiguracaoValorService().update(itemConfiguracaoValorDTO);
				mensagem = UtilI18N.internacionaliza(request, "MSG06");
			} else {
				itemConfiguracaoValorDTO = getItemConfiguracaoValorService().create(itemConfiguracaoValorDTO);
				mensagem = UtilI18N.internacionaliza(request, "MSG05");
			}
			document.executeScript("limparValorItemConfiguracao()");
			document.executeScript("preencheTabelaFinanceiro(1)");
		} catch (Exception e) {
			e.printStackTrace();
			mensagem = UtilI18N.internacionaliza(request, "MSE02");
		}
		document.alert(mensagem);
	}

	public void deletaValorItemConfiguracao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		ItemConfiguracaoValorDTO itemConfiguracaoValorDTO = refleteGerenciamentoItemConfiguracaoDTO(gerenciamentoItemConfiguracaoDTO);
		itemConfiguracaoValorDTO = getItemConfiguracaoValorService().restore(itemConfiguracaoValorDTO);
		String mensagem = "";
		try {
			getItemConfiguracaoValorService().delete(itemConfiguracaoValorDTO);
			mensagem = UtilI18N.internacionaliza(request, "MSG07");
		} catch (Exception e) {
			e.printStackTrace();
			mensagem = UtilI18N.internacionaliza(request, "MSE02");
		}
		document.executeScript("preencheTabelaFinanceiro(1)");
		document.alert(mensagem);
	}

	public void montaHTMLValorItemConfiguracao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		ItemConfiguracaoValorDTO itemConfiguracaoValorDTO = refleteGerenciamentoItemConfiguracaoDTO(gerenciamentoItemConfiguracaoDTO);
		Integer totalPaginas = getItemConfiguracaoValorService().getNumeroPaginasByIdItemConfiguracao(itemConfiguracaoValorDTO, pageSize);
		Integer pageNo = gerenciamentoItemConfiguracaoDTO.getPaginacaoFinanceiro();
		pageNo = pageNo == null ? 0 : pageNo - 1;
		itemConfiguracaoValorDTO.setPageNo(pageNo);
		itemConfiguracaoValorDTO.setPageSize(pageSize);
		List<ItemConfiguracaoValorDTO> listItemConfiguracaoValor = getItemConfiguracaoValorService().listByIdItemConfiguracaoPaginado(itemConfiguracaoValorDTO);
		StringBuilder sb = new StringBuilder();
		sb.append("<table class='dynamicTable table table-striped table-bordered'>");
		sb.append("	<thead>");
		sb.append("			<tr>");
		sb.append("			<th>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.datainicio")).append("</th>");
		sb.append("			<th>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.datafim")).append("</th>");
		sb.append("			<th>").append(UtilI18N.internacionaliza(request, "citcorpore.comum.valor")).append("</th>");
		sb.append("			<th>").append(UtilI18N.internacionaliza(request, "rh.acao")).append("</th>");
		sb.append("		</tr>");
		sb.append("	<thead>");
		sb.append("	<tbody>");
		DecimalFormat decimalFormat = new DecimalFormat("#################.00");
		if (listItemConfiguracaoValor != null && !listItemConfiguracaoValor.isEmpty()) {

			for (ItemConfiguracaoValorDTO icValor : listItemConfiguracaoValor) {
				final HttpSession session = request.getSession(true);

				String dataInicio = UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, icValor.getDataInicioValor(), session.getAttribute("locale").toString());
				String dataFim = UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, icValor.getDataFimValor(), session.getAttribute("locale").toString());

				sb.append("<tr>");
				sb.append("		<td>").append(dataInicio).append("</td>");
				sb.append("		<td>").append(icValor.getDataFimValor() != null ? dataFim : "").append("</td>");
				sb.append("		<td>").append(decimalFormat.format(icValor.getValor())).append("</td>");
				sb.append("		<td>");
				sb.append("		<button type='button' id='btnEditValorIC' class='btn-action glyphicons pencil btn-warning btnGravar' onclick='editarValorIC(").append(icValor.getIdItemConfiguracaoValor()).append(")'><i></i></button>");
				sb.append("		<button type='button' id='btnEditValorIC' class='btn-action glyphicons remove_2 btn-danger btnGravar' onclick='deletarValorIC(").append(icValor.getIdItemConfiguracaoValor()).append(")'><i></i></button>");
				sb.append("		</td>");
				sb.append("</tr>");
			}

			sb.append("	<tbody>");
			sb.append("</table>");

			sb.append(UtilHTML.paginacaoHtml(request, "preencheTabelaFinanceiro", totalPaginas, gerenciamentoItemConfiguracaoDTO.getPaginacaoFinanceiro()));
			HTMLElement divFinanceiro = document.getElementById("financeiro-content");
			divFinanceiro.appendHTML(sb.toString());
			pageNo++;
			document.executeScript("$('#paginacaoFinanceiro').val(".concat(pageNo.toString()).concat(")"));
			document.executeScript("$('#totalPaginasFinanceiro').val(".concat(totalPaginas.toString()).concat(")"));
		}
	}

	public void restoreItemConfiguracaoValor(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		ItemConfiguracaoValorDTO itemConfiguracaoValorDTO = refleteGerenciamentoItemConfiguracaoDTO(gerenciamentoItemConfiguracaoDTO);
		itemConfiguracaoValorDTO = getItemConfiguracaoValorService().restore(itemConfiguracaoValorDTO);
		document.getElementById("dataInicioValorIC").setValue(UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, itemConfiguracaoValorDTO.getDataInicioValor(), WebUtil.getLanguage(request)));
		if (itemConfiguracaoValorDTO.getDataFimValor() != null) {
			document.getElementById("dataFimValorIC").setValue(UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, itemConfiguracaoValorDTO.getDataFimValor(), WebUtil.getLanguage(request)));
		}
		document.getElementById("valorItemConfiguracao").setValue(itemConfiguracaoValorDTO.getValor().toString().replaceAll("\\.", ","));
	}

	private ItemConfiguracaoValorDTO refleteGerenciamentoItemConfiguracaoDTO(GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO) {
		ItemConfiguracaoValorDTO itemConfiguracaoValorDTO = new ItemConfiguracaoValorDTO();
		itemConfiguracaoValorDTO.setIdItemConfiguracaoValor(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracaoValor());
		itemConfiguracaoValorDTO.setIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());
		itemConfiguracaoValorDTO.setDataInicioValor(gerenciamentoItemConfiguracaoDTO.getDataInicioValorIC());
		itemConfiguracaoValorDTO.setDataFimValor(gerenciamentoItemConfiguracaoDTO.getDataFimValorIC());
		itemConfiguracaoValorDTO.setValor(gerenciamentoItemConfiguracaoDTO.getValorItemConfiguracao());
		return itemConfiguracaoValorDTO;
	}

	private String geraLabelTipoServico(HttpServletRequest request, ServicoDTO servicoDTO) {
		if (servicoDTO != null && servicoDTO.getTipoServico() != null) {
			if (servicoDTO.getTipoServico().trim().equalsIgnoreCase(TipoServico.SERVICO_APOIO.getIdentificador())) {
				String onEvents = " onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "citcorpore.comum.visualizarHierarquia")
						+ "')\" onmouseout=\"fechaTooltip();\"".concat("onclick=\"ItemConfiguracao.View.Tab.Impactos.openModalHierarquiaServicoApoio(" + servicoDTO.getIdServico() + ")\"");
				return "<a style='cursor: pointer' " + onEvents + ">"
						+ UtilI18N.internacionaliza(request, "citcorpore.comum.tipoServicoApoio") + "</a>";
			}
			if (servicoDTO.getTipoServico().trim().equalsIgnoreCase(TipoServico.SERVICO_NEGOCIO.getIdentificador())) {
				return UtilI18N.internacionaliza(request, "citcorpore.comum.tipoServicoNegocio");
			}
		}
		return "--";
	}

	public void exportarCMDB(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		try {
			UsuarioDTO usuarioDto = WebUtil.getUsuario(request);
			if (usuarioDto == null) {
				document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
				document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
				return;
			}
			GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
			ObjetoNegocioService objetoNegocioService = (ObjetoNegocioService) ServiceLocator.getInstance().getService(ObjetoNegocioService.class, null);
			CamposObjetoNegocioService camposObjetoNegocioService = (CamposObjetoNegocioService) ServiceLocator.getInstance().getService(CamposObjetoNegocioService.class, null);
			ObjetoNegocioDTO objetoNegocioDTO = objetoNegocioService.getByNomeTabelaDB("ITEMCONFIGURACAO");
			if (objetoNegocioDTO == null) {
				return;
			}
			DataManager dataManager = new DataManager();
			String ORIGEM_SISTEMA = ParametroUtil.getValorParametroCitSmartHashMap(Enumerados.ParametroSistema.ORIGEM_SISTEMA, " ");
			if (ORIGEM_SISTEMA == null || ORIGEM_SISTEMA.trim().equalsIgnoreCase("")) {
				document.alert(UtilI18N.internacionaliza(request, "dataManager.infoorigemdados"));
				document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
				return;
			}

			Integer ID_CICLO_DESENVOLVIMENTO = 0;
			try {
				ID_CICLO_DESENVOLVIMENTO = Integer.parseInt(ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_GRUPO_PADRAO_IC_DESENVOLVIMENTO, "997").isEmpty() ? "997" : ParametroUtil.getValorParametroCitSmartHashMap(ParametroSistema.ID_GRUPO_PADRAO_IC_DESENVOLVIMENTO, "997"));
			} catch (Exception e) {
			}

			// ---
			HashMap hashValoresItem = new HashMap();
			hashValoresItem.put("NOMETABELADB", "ITEMCONFIGURACAO");

			String nomeTabelaItem = "ITEMCONFIGURACAO";

			Collection col = camposObjetoNegocioService.findByIdObjetoNegocioAndNomeDB(objetoNegocioDTO.getIdObjetoNegocio(), "IDGRUPOITEMCONFIGURACAO");
			CamposObjetoNegocioDTO camposObjetoNegocioDTO = null;
			if (col != null) {
				for (Iterator it = col.iterator(); it.hasNext();) {
					camposObjetoNegocioDTO = (CamposObjetoNegocioDTO) it.next();
				}
			}
			if (camposObjetoNegocioDTO == null) {
				return;
			}

			hashValoresItem.put("COND_" + camposObjetoNegocioDTO.getIdCamposObjetoNegocio(), "IN");
			hashValoresItem.put("VALOR_" + camposObjetoNegocioDTO.getIdCamposObjetoNegocio(), "(SELECT idgrupoitemconfiguracao FROM grupoitemconfiguracao WHERE idGrupoItemConfiguracaoPai = " + gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo() + ")");

			// ---
			ObjetoNegocioDTO objetoNegocioGrpDTO = objetoNegocioService.getByNomeTabelaDB("GRUPOITEMCONFIGURACAO");
			if (objetoNegocioGrpDTO == null) {
				return;
			}
			HashMap hashValoresGrp = new HashMap();
			hashValoresGrp.put("NOMETABELADB", "GRUPOITEMCONFIGURACAO");

			col = camposObjetoNegocioService.findByIdObjetoNegocioAndNomeDB(objetoNegocioGrpDTO.getIdObjetoNegocio(), "IDGRUPOITEMCONFIGURACAOPAI");
			camposObjetoNegocioDTO = null;
			if (col != null) {
				for (Iterator it = col.iterator(); it.hasNext();) {
					camposObjetoNegocioDTO = (CamposObjetoNegocioDTO) it.next();
				}
			}
			if (camposObjetoNegocioDTO == null) {
				return;
			}

			if (ID_CICLO_DESENVOLVIMENTO.intValue() == gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo().intValue()) {
				hashValoresGrp.put("COND_" + camposObjetoNegocioDTO.getIdCamposObjetoNegocio(), "=");
				hashValoresGrp.put("VALOR_" + camposObjetoNegocioDTO.getIdCamposObjetoNegocio(), "" + gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo() + " OR IDGRUPOITEMCONFIGURACAOPAI IS NULL");
			} else {
				hashValoresGrp.put("COND_" + camposObjetoNegocioDTO.getIdCamposObjetoNegocio(), "=");
				hashValoresGrp.put("VALOR_" + camposObjetoNegocioDTO.getIdCamposObjetoNegocio(), "" + gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo());
			}
			String sqlDelete = "";
			String filterAditional = "";
			// StringBuilder strAux = dataManager.geraRecursiveExportObjetoNegocio(hashValoresItem, objetoNegocioDTO.getIdObjetoNegocio(), sqlDelete, "ITEMCONFIGURACAO", filterAditional);
			StringBuilder strAuxGrp = dataManager.geraRecursiveExportObjetoNegocio(hashValoresGrp, objetoNegocioGrpDTO.getIdObjetoNegocio(), sqlDelete, "GRUPOITEMCONFIGURACAO", filterAditional, "");

			// String str = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<tables origem='" + ORIGEM_SISTEMA + "'>\n" + strAuxGrp.toString() + "\n" + strAux.toString();
			String str = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<tables origem='" + ORIGEM_SISTEMA + "'>\n" + strAuxGrp.toString();
			str = "" + str + "\n</tables>";

			String strDateTime = new java.util.Date().toString();
			strDateTime = strDateTime.replaceAll(" ", "_");
			strDateTime = strDateTime.replaceAll(":", "_");
			UtilTratamentoArquivos.geraFileTxtFromString(CITCorporeUtil.CAMINHO_REAL_APP + "/exportXML/export_data_" + strDateTime + ".smart", str);

			// JdbcEngine jdbcEngine = new JdbcEngine(Constantes.getValue("DATABASE_ALIAS"), null);
			LogDados logDados = new LogDados();
			logDados.setDtAtualizacao(UtilDatas.getDataHoraAtual());
			logDados.setIdUsuario(usuarioDto.getIdUsuario());
			logDados.setDataInicio(UtilDatas.getDataAtual());
			logDados.setDataLog(UtilDatas.getDataHoraAtual());
			logDados.setNomeTabela(nomeTabelaItem);
			logDados.setOperacao("Export");
			logDados.setLocalOrigem(usuarioDto.getNomeUsuario());
			logDados.setDados("Execute export... " + nomeTabelaItem);

			LogDadosService lds = new LogDadosServiceBean();

			try {
				logDados = lds.create(logDados);
			} catch (Exception e) {
			}

			document.alert(UtilI18N.internacionaliza(request, "dataManager.arquivoExportado"));
			document.executeScript("getFile('" + "exportXML/export_data_" + strDateTime + ".smart', 'export_data_" + strDateTime + ".smart')");
		} finally {
			document.getJanelaPopupById("JANELA_AGUARDE_MENU").hide();
		}
	}

	public void habilitaBotaoExportar(DocumentHTML document, GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO) {
		if (gerenciamentoItemConfiguracaoDTO != null && gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo() != null) {
			Integer idGrupo = gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo();

			if (idGrupo.equals(ID_CICLO_DESENVOLVIMENTO) || idGrupo.equals(ID_CICLO_HOMOLOGACA0) || idGrupo.equals(ID_CICLO_PRODUCAO)) {
				document.executeScript("enableExportButton()");
				return;
			}
		}
		document.executeScript("disableExportButton()");
	}

	private void habilitaBotaoCalendarioEANS(DocumentHTML document, GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO) {
		if (gerenciamentoItemConfiguracaoDTO != null && gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo() != null) {
			document.executeScript("$(\"#btnCalendarioGrupo\").prop(\"disabled\", \"\");");
			document.executeScript("$(\"#btnANSGrupo\").prop(\"disabled\", \"\");");
			document.executeScript("$(\"#btnValorIndispGrupo\").prop(\"disabled\", \"\");");
			return;
		}
		document.executeScript("$(\"#btnCalendarioGrupo\").prop(\"disabled\", \"disabled\");");
		document.executeScript("$(\"#btnANSGrupo\").prop(\"disabled\", \"disabled\");");
		document.executeScript("$(\"#btnValorIndispGrupo\").prop(\"disabled\", \"disabled\");");
	}

	public void carregarIndicadoresCapacidade(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLElement divTabela = document.getElementById("tabelaIndicadoresCapacidade");
		GerenciamentoItemConfiguracaoDTO beanDto = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		document.executeScript("limpaTabelaIndicadoresCapacidade()");
		List<Integer> listIdIndicadorCapacidade = convertListIndicadorCapacidadeIcToListIdIndicadorCapacidade(getIndicadorCapacidadeItemConfiguracaoService().listAllByIdItemConfiguracao(beanDto.getIdItemConfiguracao()));
		Collection<IndicadorCapacidadeDTO> listIndicadores = getIndicadorCapacidadeService().list();
		StringBuilder sb = new StringBuilder();
		if (listIndicadores != null && !listIndicadores.isEmpty()) {
			sb.append("		<table class='dynamicTable table table-striped table-bordered' id='tableIndicadorCapacidade'> ");
			sb.append("			<thead> ");
			sb.append("				<tr> ");
			sb.append("					<th></th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.nome") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.valor") + "</th> ");
			sb.append("				</tr> ");
			sb.append("			</thead> ");
			sb.append("			<tbody> ");

			for (IndicadorCapacidadeDTO indicadorCapacidadeDTO : listIndicadores) {
				String isChecked = listIdIndicadorCapacidade.contains(indicadorCapacidadeDTO.getIdIndicadorCapacidade()) ? "checked" : "";
				Integer id = indicadorCapacidadeDTO.getIdIndicadorCapacidade();
				sb.append("		<tr>");
				sb.append("			<td>").append("			<input type='checkbox' name='indicadorCapacidadeCheck' id='indicador").append(id).append("' value='").append(id).append("'").append(isChecked).append(" />").append("		</td>");
				sb.append("			<td>" + indicadorCapacidadeDTO.getNome() + "</td>");
				sb.append("			<td>" + indicadorCapacidadeDTO.getValor().toString() + "</td>");
				sb.append("		</tr>");
			}
			sb.append("			</tbody> ");
			sb.append("		</table> ");
			sb.append("");

			sb.append("<div class='separator'></div>");
			divTabela.appendHTML(sb.toString());
		} else {
			sb.append("<h4>" + UtilI18N.internacionaliza(request, "gerenciamentoportfolio.indicadoresCapacidade.nenhumIndicadorCapacidadeCadastrado"));
			divTabela.appendHTML(sb.toString());
		}
	}

	private List<Integer> convertListIndicadorCapacidadeIcToListIdIndicadorCapacidade(List<IndicadorCapacidadeItemConfiguracaoDTO> listIndicadorCapacidadeServico) {
		List<Integer> listId = new ArrayList<>();
		for (IndicadorCapacidadeItemConfiguracaoDTO indicador : listIndicadorCapacidadeServico) {
			listId.add(indicador.getIdIndicadorCapacidade());
		}
		return listId;
	}

	public void adicionarIndicadoresCapacidade(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO beanDto = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		getIndicadorCapacidadeItemConfiguracaoService().deleteByIdItemConfiguracao(beanDto.getIdItemConfiguracao());
		try {
			if (beanDto.getIndicadorCapacidadeCheck() != null) {
				for (Integer idIndicadorCapacidade : beanDto.getIndicadorCapacidadeCheck()) {
					IndicadorCapacidadeItemConfiguracaoDTO indicadorCapacidadeItemConfiguracaoDTO = new IndicadorCapacidadeItemConfiguracaoDTO();
					indicadorCapacidadeItemConfiguracaoDTO.setIdItemConfiguracao(beanDto.getIdItemConfiguracao());
					indicadorCapacidadeItemConfiguracaoDTO.setIdIndicadorCapacidade(idIndicadorCapacidade);
					getIndicadorCapacidadeItemConfiguracaoService().create(indicadorCapacidadeItemConfiguracaoDTO);
				}
				document.executeScript("notificacaoI18N('MSG18')");
			}
		} catch (Exception e) {
			e.printStackTrace();
			document.executeScript("notificacaoI18N('MSE02')");
		}
		preencheTabelaIndicadoresCapacidadeIC(beanDto, document, request);
		document.executeScript("$('#POPUP_ADICIONAR_INDICADORES_CAPACIDADE').dialog('close');");
	}

	public void preencheTabelaIndicadoresCapacidadeIC(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO beanDto = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		preencheTabelaIndicadoresCapacidadeIC(beanDto, document, request);
	}

	private void preencheTabelaIndicadoresCapacidadeIC(GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO, final DocumentHTML document, final HttpServletRequest request)
			throws ServiceException, Exception {
		Integer paginaSelecionada = gerenciamentoItemConfiguracaoDTO.getPaginaSelecionadaIndicadorCapacidadeIc();
		Integer totalPaginas = getIndicadorCapacidadeItemConfiguracaoService().getTotalPaginasIndicadoresCapacidade(pageSize, gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());
		if (paginaSelecionada != null && totalPaginas != null && paginaSelecionada > totalPaginas) {
			paginaSelecionada = totalPaginas;
		}
		if (paginaSelecionada == null || paginaSelecionada <= 0) {
			paginaSelecionada = 1;
		}
		List<IndicadorCapacidadeItemConfiguracaoDTO> listIndicadores = this.getIndicadorCapacidadeItemConfiguracaoService().listByIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO, paginaSelecionada - 1, pageSize);
		HTMLElement divTabela = document.getElementById("tabelaIndicadoresCapacidadeIc");
		document.executeScript("limpaTabelaIndicadoresCapacidadeIc()");
		StringBuilder sb = new StringBuilder();
		if (listIndicadores != null && !listIndicadores.isEmpty()) {
			sb.append("		<table class='dynamicTable table table-striped table-bordered'> ");
			sb.append("			<thead> ");
			sb.append("				<tr> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.nome") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.valor") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "planoMelhoria.acoes.titulo") + "</th> ");
			sb.append("				</tr> ");
			sb.append("			</thead> ");
			sb.append("			<tbody> ");

			for (IndicadorCapacidadeItemConfiguracaoDTO indicadorCapacidadeItemConfiguracaoDTO : listIndicadores) {
				sb.append("		<tr>");
				sb.append("			<td>" + indicadorCapacidadeItemConfiguracaoDTO.getNome() + "</td>");
				sb.append("			<td>" + indicadorCapacidadeItemConfiguracaoDTO.getValor() + "</td>");
				sb.append("			<td><button type='button' id='btnExcluirVinculo' class='btn-action glyphicons remove_2 btn-danger btnGravar' onclick='desvincularIndicadorCapacidade(").append(indicadorCapacidadeItemConfiguracaoDTO.getIdIndicadorCapacidadeIc()).append(")'><i></i></button>");
				sb.append("		</tr>");
			}
			sb.append("			</tbody> ");
			sb.append("		</table> ");
			sb.append("");
			sb.append("<div class='separator'></div>");
			sb.append(UtilHTML.paginacaoHtml(request, "atualizaTelaPaginadaIndicadorCapacidadeIc", totalPaginas, paginaSelecionada));
			divTabela.appendHTML(sb.toString());
		} else {
			sb.append("<h4>" + UtilI18N.internacionaliza(request, "gerenciamentoportfolio.indicadorescapacidade.nenhumvinculado"));
			divTabela.appendHTML(sb.toString());
		}
	}

	public void desvincularIndicadorCapacidade(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		IndicadorCapacidadeItemConfiguracaoDTO indicadorCapacidadeItemConfiguracaoDTO = new IndicadorCapacidadeItemConfiguracaoDTO();
		indicadorCapacidadeItemConfiguracaoDTO.setIdIndicadorCapacidadeIc(gerenciamentoItemConfiguracaoDTO.getIdIndicadorCapacidadeIc());
		try {
			getIndicadorCapacidadeItemConfiguracaoService().delete(indicadorCapacidadeItemConfiguracaoDTO);
			document.executeScript("notificacaoI18N('MSG18')");
		} catch (Exception e) {
			e.printStackTrace();
			document.executeScript("notificacaoErro('MSE02')");
		}
		preencheTabelaIndicadoresCapacidadeIC(gerenciamentoItemConfiguracaoDTO, document, request);
	}

	public void carregarAtributoDemanda(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		HTMLElement divTabela = document.getElementById("tabelaAtributoDemanda");
		GerenciamentoItemConfiguracaoDTO beanDto = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		document.executeScript("limpaTabelaAtributoDemanda()");
		List<Integer> listIdAtributoDemanda = convertListAtributoDemandaIcToListIdAtributoDemanda(getAtributoDemandaItemConfiguracaoService().listAllByIdItemConfiguracao(beanDto.getIdItemConfiguracao()));
		Collection<AtributoDemandaDTO> listAtributos = getAtributoDemandaService().list();
		StringBuilder sb = new StringBuilder();
		if (listAtributos != null && !listAtributos.isEmpty()) {
			sb.append("		<table class='dynamicTable table table-striped table-bordered' id='tableAtributoDemanda'> ");
			sb.append("			<thead> ");
			sb.append("				<tr> ");
			sb.append("					<th></th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.nome") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.valor") + "</th> ");
			sb.append("				</tr> ");
			sb.append("			</thead> ");
			sb.append("			<tbody> ");

			for (AtributoDemandaDTO atributoDemandaDTO : listAtributos) {
				String isChecked = listIdAtributoDemanda.contains(atributoDemandaDTO.getIdAtributoDemanda()) ? "checked" : "";
				Integer id = atributoDemandaDTO.getIdAtributoDemanda();
				sb.append("		<tr>");
				sb.append("			<td>").append("			<input type='checkbox' name='atributoDemandaCheck' id='indicador").append(id).append("' value='").append(id).append("'").append(isChecked).append(" />").append("		</td>");
				sb.append("			<td>" + atributoDemandaDTO.getNome() + "</td>");
				sb.append("			<td>" + atributoDemandaDTO.getValor() + "</td>");
				sb.append("		</tr>");
			}
			sb.append("			</tbody> ");
			sb.append("		</table> ");
			sb.append("");

			sb.append("<div class='separator'></div>");
			divTabela.appendHTML(sb.toString());
		} else {
			sb.append("<h4>" + UtilI18N.internacionaliza(request, "gerenciamentoportfolio.atributoDemanda.nenhumAtributoDemandaCadastrado"));
			divTabela.appendHTML(sb.toString());
		}
	}

	private List<Integer> convertListAtributoDemandaIcToListIdAtributoDemanda(List<AtributoDemandaItemConfiguracaoDTO> listAtributoDemandaIc) {
		List<Integer> listId = new ArrayList<>();
		for (AtributoDemandaItemConfiguracaoDTO atributo : listAtributoDemandaIc) {
			listId.add(atributo.getIdAtributoDemanda());
		}
		return listId;
	}

	public void adicionarAtributoDemanda(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO beanDto = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		getAtributoDemandaItemConfiguracaoService().deleteByIdItemConfiguracao(beanDto.getIdItemConfiguracao());
		try {
			if (beanDto.getAtributoDemandaCheck() != null) {
				for (Integer idAtributoDemanda : beanDto.getAtributoDemandaCheck()) {
					AtributoDemandaItemConfiguracaoDTO atributoDemandaItemConfiguracaoDTO = new AtributoDemandaItemConfiguracaoDTO();
					atributoDemandaItemConfiguracaoDTO.setIdItemConfiguracao(beanDto.getIdItemConfiguracao());
					atributoDemandaItemConfiguracaoDTO.setIdAtributoDemanda(idAtributoDemanda);
					getAtributoDemandaItemConfiguracaoService().create(atributoDemandaItemConfiguracaoDTO);
				}
				document.executeScript("notificacaoI18N('MSG18')");
			}
		} catch (Exception e) {
			e.printStackTrace();
			document.executeScript("notificacaoI18N('MSE02')");

		}
		preencheTabelaAtributoDemandaIC(beanDto, document, request);
		document.executeScript("$('#POPUP_ADICIONAR_ATRIBUTO_DEMANDA').dialog('close');");
	}

	public void preencheTabelaAtributoDemandaIC(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO beanDto = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		preencheTabelaAtributoDemandaIC(beanDto, document, request);
	}

	private void preencheTabelaAtributoDemandaIC(GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO, final DocumentHTML document, final HttpServletRequest request)
			throws ServiceException, Exception {
		Integer paginaSelecionada = gerenciamentoItemConfiguracaoDTO.getPaginaSelecionadaAtributoDemandaIc();
		Integer totalPaginas = getAtributoDemandaItemConfiguracaoService().getTotalPaginasAtributoDemanda(pageSize, gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());
		if (paginaSelecionada != null && totalPaginas != null && paginaSelecionada > totalPaginas) {
			paginaSelecionada = totalPaginas;
		}
		if (paginaSelecionada == null || paginaSelecionada <= 0) {
			paginaSelecionada = 1;
		}
		List<AtributoDemandaItemConfiguracaoDTO> listAtributos = this.getAtributoDemandaItemConfiguracaoService().listByIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO, paginaSelecionada - 1, pageSize);
		HTMLElement divTabela = document.getElementById("tabelaAtributoDemandaIc");
		document.executeScript("limpaTabelaAtributoDemandaIc()");
		StringBuilder sb = new StringBuilder();
		if (listAtributos != null && !listAtributos.isEmpty()) {
			sb.append("		<table class='dynamicTable table table-striped table-bordered'> ");
			sb.append("			<thead> ");
			sb.append("				<tr> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.nome") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "citcorpore.comum.valor") + "</th> ");
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "planoMelhoria.acoes.titulo") + "</th> ");
			sb.append("				</tr> ");
			sb.append("			</thead> ");
			sb.append("			<tbody> ");

			for (AtributoDemandaItemConfiguracaoDTO atributoDemandaItemConfiguracaoDTO : listAtributos) {
				sb.append("		<tr>");
				sb.append("			<td>" + atributoDemandaItemConfiguracaoDTO.getNome() + "</td>");
				sb.append("			<td>" + atributoDemandaItemConfiguracaoDTO.getValor() + "</td>");
				sb.append("			<td><button type='button' id='btnExcluirVinculo' class='btn-action glyphicons remove_2 btn-danger btnGravar' onclick='desvincularAtributoDemanda(").append(atributoDemandaItemConfiguracaoDTO.getIdAtributoDemandaIc()).append(")'><i></i></button>");
				sb.append("		</tr>");
			}
			sb.append("			</tbody> ");
			sb.append("		</table> ");
			sb.append("");
			sb.append("<div class='separator'></div>");
			sb.append(UtilHTML.paginacaoHtml(request, "atualizaTelaPaginadaAtributoDemandaIc", totalPaginas, paginaSelecionada));
			divTabela.appendHTML(sb.toString());
		} else {
			sb.append("<h4>" + UtilI18N.internacionaliza(request, "gerenciamentoportfolio.atributodemanda.nenhumvinculado"));
			divTabela.appendHTML(sb.toString());
		}
	}

	public void desvincularAtributoDemanda(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		AtributoDemandaItemConfiguracaoDTO indicadorCapacidadeItemConfiguracaoDTO = new AtributoDemandaItemConfiguracaoDTO();
		indicadorCapacidadeItemConfiguracaoDTO.setIdAtributoDemandaIc(gerenciamentoItemConfiguracaoDTO.getIdAtributoDemandaIc());
		try {
			getAtributoDemandaItemConfiguracaoService().delete(indicadorCapacidadeItemConfiguracaoDTO);
			document.executeScript("notificacaoI18N('MSG18')");
		} catch (Exception e) {
			e.printStackTrace();
			document.executeScript("notificacaoI18N('MSE02')");
		}
		preencheTabelaAtributoDemandaIC(gerenciamentoItemConfiguracaoDTO, document, request);
	}

	public void vincularConhecimento(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		try {
			if (gerenciamentoItemConfiguracaoDTO != null && gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao() != null && gerenciamentoItemConfiguracaoDTO.getIdBaseConhecimento() != null) {
				Collection<ConhecimentoICDTO> colConhecimentoICDTO = getConhecimentoICService().findByidItemConfiguracaoAndIdBaseConhecimento(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao(), gerenciamentoItemConfiguracaoDTO.getIdBaseConhecimento());
				ConhecimentoICDTO conhecimentoICDTO = new ConhecimentoICDTO();
				if (colConhecimentoICDTO == null || colConhecimentoICDTO.size() == 0) {
					conhecimentoICDTO.setIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());
					conhecimentoICDTO.setIdBaseConhecimento(gerenciamentoItemConfiguracaoDTO.getIdBaseConhecimento());
					getConhecimentoICService().create(conhecimentoICDTO);
					document.executeScript("notificacaoI18N('MSG18')");
				} else {
					document.executeScript("notificacaoErro('gerenciamentoItemConfiguracao.conhecimentoJaVinculadoEsteItemConfiguracao')");
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			document.executeScript("notificacaoErro(".concat("'MSE02'").concat(")"));
		}

		if (gerenciamentoItemConfiguracaoDTO != null) {
		refreshDadosConhecimento(document, request, gerenciamentoItemConfiguracaoDTO);
	}
	}

	public void deletarConhecimentoIc(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		try {
			if (gerenciamentoItemConfiguracaoDTO != null && gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao() != null && gerenciamentoItemConfiguracaoDTO.getIdBaseConhecimento() != null) {
				getConhecimentoICService().deleteByIdBaseConhecimentoAndIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdBaseConhecimento(), gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());
				document.executeScript("notificacaoI18N(".concat("'MSG18'").concat(")"));
			}
		} catch (Exception e) {
			e.printStackTrace();
			document.executeScript("notificacaoErro(".concat("'MSE02'").concat(")"));
		}

		if (gerenciamentoItemConfiguracaoDTO != null) {
		refreshDadosConhecimento(document, request, gerenciamentoItemConfiguracaoDTO);
	}
	}

	private void refreshDadosConhecimento(final DocumentHTML document, final HttpServletRequest request, final GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO) throws Exception {
		preencherQuantidadeBaseConhecimento(document, gerenciamentoItemConfiguracaoDTO);
		preencherListBaseConhecimento(document, request, gerenciamentoItemConfiguracaoDTO);
	}

	private void preencherQuantidadeBaseConhecimento(final DocumentHTML document, final GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO) throws Exception {
		HTMLElement tabBaseConhecimentoQuantidades = document.getElementById("tab-base-conhecimento-quantidades");
		Collection<ConhecimentoICDTO> ConhecimentoICCollectionDTO = getConhecimentoICService().findByidItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());
		if (ConhecimentoICCollectionDTO != null && !ConhecimentoICCollectionDTO.isEmpty()) {
			tabBaseConhecimentoQuantidades.setInnerHTML(String.valueOf(ConhecimentoICCollectionDTO.size()));
		} else {
			tabBaseConhecimentoQuantidades.setInnerHTML("0");
		}
	}

	private void preencherListBaseConhecimento(final DocumentHTML document, final HttpServletRequest request, final GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO) throws Exception {
		gerenciamentoItemConfiguracaoDTO.setControllerTab("tab-base-conhecimento");
		loadTab(gerenciamentoItemConfiguracaoDTO, document, request);
	}

	private void carregaComboLocalidade(final DocumentHTML document) throws Exception {
		Collection<LocalidadeDTO> colLocalidadeDTO = getLocalidadeService().listLocalidade();
		HTMLSelect selectLocalidade = document.getSelectById("localidade");
		selectLocalidade.removeAllOptions();
		if (colLocalidadeDTO != null) {
			for (LocalidadeDTO localidadeDTO : colLocalidadeDTO) {
				selectLocalidade.addOption(localidadeDTO.getNomeLocalidade(), localidadeDTO.getNomeLocalidade());
			}
		}
	}

	public void gravarCalendarioGrupo(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		if (gerenciamentoItemConfiguracaoDTO != null && gerenciamentoItemConfiguracaoDTO.getIdCalendarioGrupo() != null && gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo() != null) {
			GrupoItemConfiguracaoCalendarioDTO grupoItemConfiguracaoCalendarioDTO = new GrupoItemConfiguracaoCalendarioDTO();
			grupoItemConfiguracaoCalendarioDTO.setIdCalendario(gerenciamentoItemConfiguracaoDTO.getIdCalendarioGrupo());
			grupoItemConfiguracaoCalendarioDTO.setIdGrupoItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo());
			getGrupoItemConfiguracaoCalendarioService().deleteByIdGrupoItemConfiguracao(grupoItemConfiguracaoCalendarioDTO.getIdGrupoItemConfiguracao());
			getGrupoItemConfiguracaoCalendarioService().create(grupoItemConfiguracaoCalendarioDTO);
		}
		document.executeScript("Modal.close($('#modal-grupo-calendario'));");
		document.executeScript("notificacaoI18N('MSG18')");
	}

	public void restauraCalendarioGrupo(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		if (gerenciamentoItemConfiguracaoDTO != null && gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo() != null) {
			Collection<GrupoItemConfiguracaoCalendarioDTO> colCalendarioGrupo = getGrupoItemConfiguracaoCalendarioService().findByIdGrupoItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo());
			String idCalendarioTexto = "";
			String nomeCalendario = "";
			if (colCalendarioGrupo != null && colCalendarioGrupo.size() > 0) {
				for (GrupoItemConfiguracaoCalendarioDTO grupoItemConfiguracaoCalendarioDTO : colCalendarioGrupo) {
					CalendarioDTO calendarioDTO = new CalendarioDTO();
					calendarioDTO.setIdCalendario(grupoItemConfiguracaoCalendarioDTO.getIdCalendario());
					calendarioDTO = (CalendarioDTO) getCalendarioService().restore(calendarioDTO);
					idCalendarioTexto = calendarioDTO.getIdCalendario().toString();
					nomeCalendario = calendarioDTO.getDescricao();
				}
			}
			document.executeScript("preencheDadosCalendarioGrupo('".concat(idCalendarioTexto).concat("','").concat(nomeCalendario).concat("')"));
		}
	}

	public void gravarAcordoNivelServicoGrupo(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		if (gerenciamentoItemConfiguracaoDTO != null && gerenciamentoItemConfiguracaoDTO.getIdAcordoNivelServicoGrupo() != null && gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo() != null) {
			GrupoItemConfiguracaoAcordoNivelServicoDTO grupoItemConfiguracaoAcordoNivelServicoDTO = new GrupoItemConfiguracaoAcordoNivelServicoDTO();
			grupoItemConfiguracaoAcordoNivelServicoDTO.setIdAcordoNivelServico(gerenciamentoItemConfiguracaoDTO.getIdAcordoNivelServicoGrupo());
			grupoItemConfiguracaoAcordoNivelServicoDTO.setIdGrupoItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo());
			getGrupoItemConfiguracaoAcordoNivelServicoService().deleteByIdGrupoItemConfiguracao(grupoItemConfiguracaoAcordoNivelServicoDTO.getIdGrupoItemConfiguracao());
			getGrupoItemConfiguracaoAcordoNivelServicoService().create(grupoItemConfiguracaoAcordoNivelServicoDTO);
		}
		document.executeScript("Modal.close($('#modal-grupo-ans'));");
		document.executeScript("notificacaoI18N('MSG18')");
	}

	public void restauraAcordoNivelServicoGrupo(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		if (gerenciamentoItemConfiguracaoDTO != null && gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo() != null) {
			Collection<GrupoItemConfiguracaoAcordoNivelServicoDTO> colAcordoNivelServvicoGrupo = getGrupoItemConfiguracaoAcordoNivelServicoService().findByIdGrupoItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo());
			String idAcordoNivelServicoTexto = "";
			String nomeAcordoNivelServico = "";
			if (colAcordoNivelServvicoGrupo != null && colAcordoNivelServvicoGrupo.size() > 0) {
				for (GrupoItemConfiguracaoAcordoNivelServicoDTO grupoItemConfiguracaoAcordoNivelServicoDTO : colAcordoNivelServvicoGrupo) {
					AcordoNivelServicoDTO acordoNivelServicoDTO = new AcordoNivelServicoDTO();
					acordoNivelServicoDTO.setIdAcordoNivelServico(grupoItemConfiguracaoAcordoNivelServicoDTO.getIdAcordoNivelServico());
					acordoNivelServicoDTO = (AcordoNivelServicoDTO) getAcordoNivelServicoService().restore(acordoNivelServicoDTO);
					idAcordoNivelServicoTexto = acordoNivelServicoDTO.getIdAcordoNivelServico().toString();
					nomeAcordoNivelServico = nomeAcordoNivelServico.concat(acordoNivelServicoDTO.getTituloSLA()).concat(" - ").concat(acordoNivelServicoDTO.getDescricaoSLA()).concat(" - ").concat(acordoNivelServicoDTO.getSituacao());
				}
			}
			document.executeScript("preencheDadosAcordoNivelServicoGrupo('".concat(idAcordoNivelServicoTexto).concat("','").concat(nomeAcordoNivelServico).concat("')"));
		}
	}

	public void gravarCalendarioIC(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		if (gerenciamentoItemConfiguracaoDTO != null && gerenciamentoItemConfiguracaoDTO.getIdCalendarioIC() != null && gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao() != null) {
			ItemConfiguracaoCalendarioDTO itemConfiguracaoCalendarioDTO = new ItemConfiguracaoCalendarioDTO();
			itemConfiguracaoCalendarioDTO.setIdCalendario(gerenciamentoItemConfiguracaoDTO.getIdCalendarioIC());
			itemConfiguracaoCalendarioDTO.setIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());
			getItemConfiguracaoCalendarioService().deleteByIdItemConfiguracao(itemConfiguracaoCalendarioDTO.getIdItemConfiguracao());
			getItemConfiguracaoCalendarioService().create(itemConfiguracaoCalendarioDTO);
		}
		document.executeScript("notificacaoI18N('MSG18')");
	}

	public void restauraCalendarioIC(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		if (gerenciamentoItemConfiguracaoDTO != null && gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao() != null) {
			Collection<ItemConfiguracaoCalendarioDTO> colCalendarioIC = getItemConfiguracaoCalendarioService().findByIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());
			String idCalendarioTexto = "";
			String nomeCalendario = "";
			if (colCalendarioIC != null && colCalendarioIC.size() > 0) {
				for (ItemConfiguracaoCalendarioDTO itemConfiguracaoCalendarioDTO : colCalendarioIC) {
					CalendarioDTO calendarioDTO = new CalendarioDTO();
					calendarioDTO.setIdCalendario(itemConfiguracaoCalendarioDTO.getIdCalendario());
					calendarioDTO = (CalendarioDTO) getCalendarioService().restore(calendarioDTO);
					idCalendarioTexto = calendarioDTO.getIdCalendario().toString();
					nomeCalendario = calendarioDTO.getDescricao();
				}
			}
			document.executeScript("preencheDadosCalendarioIC('".concat(idCalendarioTexto).concat("','").concat(nomeCalendario).concat("')"));
		}
	}

	public void gravarAcordoNivelServicoIC(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		if (gerenciamentoItemConfiguracaoDTO != null && gerenciamentoItemConfiguracaoDTO.getIdAcordoNivelServicoIC() != null && gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao() != null) {
			ItemConfiguracaoAcordoNivelServicoDTO itemConfiguracaoAcordoNivelServicoDTO = new ItemConfiguracaoAcordoNivelServicoDTO();
			itemConfiguracaoAcordoNivelServicoDTO.setIdAcordoNivelServico(gerenciamentoItemConfiguracaoDTO.getIdAcordoNivelServicoIC());
			itemConfiguracaoAcordoNivelServicoDTO.setIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());
			getItemConfiguracaoAcordoNivelServicoService().deleteByIdItemConfiguracao(itemConfiguracaoAcordoNivelServicoDTO.getIdItemConfiguracao());
			getItemConfiguracaoAcordoNivelServicoService().create(itemConfiguracaoAcordoNivelServicoDTO);
		}
		document.executeScript("notificacaoI18N('MSG18')");
	}

	public void restauraAcordoNivelServicoIC(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}
		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		if (gerenciamentoItemConfiguracaoDTO != null && gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao() != null) {
			Collection<ItemConfiguracaoAcordoNivelServicoDTO> colAcordoNivelServvicoIC = getItemConfiguracaoAcordoNivelServicoService().findByIdItemConfiguracao(gerenciamentoItemConfiguracaoDTO.getIdItemConfiguracao());
			String idAcordoNivelServicoTexto = "";
			String nomeAcordoNivelServico = "";
			if (colAcordoNivelServvicoIC != null && colAcordoNivelServvicoIC.size() > 0) {
				for (ItemConfiguracaoAcordoNivelServicoDTO itemConfiguracaoAcordoNivelServicoDTO : colAcordoNivelServvicoIC) {
					AcordoNivelServicoDTO acordoNivelServicoDTO = new AcordoNivelServicoDTO();
					acordoNivelServicoDTO.setIdAcordoNivelServico(itemConfiguracaoAcordoNivelServicoDTO.getIdAcordoNivelServico());
					acordoNivelServicoDTO = (AcordoNivelServicoDTO) getAcordoNivelServicoService().restore(acordoNivelServicoDTO);
					idAcordoNivelServicoTexto = acordoNivelServicoDTO.getIdAcordoNivelServico().toString();
					nomeAcordoNivelServico = nomeAcordoNivelServico.concat(acordoNivelServicoDTO.getTituloSLA()).concat(" - ").concat(acordoNivelServicoDTO.getDescricaoSLA()).concat(" - ").concat(acordoNivelServicoDTO.getSituacao());
				}
			}
			document.executeScript("preencheDadosAcordoNivelServicoIC('".concat(idAcordoNivelServicoTexto).concat("','").concat(nomeAcordoNivelServico).concat("')"));
		}
	}

	public void adicionaValorIndisiponibilidadeGrupo(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception{
		if(!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		if(gerenciamentoItemConfiguracaoDTO != null){
			Integer idGrupoItemConfiguracao = gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo();
			getGrupoICValorIndisponibilidadeService().deleteByIdGrupoItemConfiguracao(idGrupoItemConfiguracao);
			Double valorIndisponibilidade = gerenciamentoItemConfiguracaoDTO.getValorHoraIndisponibilidadeGrupo();
			if(valorIndisponibilidade != null){
				GrupoICValorIndisponibilidadeDTO grupoICValorIndisponibilidadeDTO = new GrupoICValorIndisponibilidadeDTO();
				grupoICValorIndisponibilidadeDTO.setIdGrupoItemConfiguracao(idGrupoItemConfiguracao);
				grupoICValorIndisponibilidadeDTO.setValor(valorIndisponibilidade);
				getGrupoICValorIndisponibilidadeService().create(grupoICValorIndisponibilidadeDTO);
			}
			document.executeScript("notificacaoI18N('MSG05');");
			document.executeScript("fecharModalValorIndisponibilidadeGrupo();");
		}
	}

	public void restauraValorIndisponibilidadeGrupo(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception{
		if(!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();
		if(gerenciamentoItemConfiguracaoDTO != null){
			Integer idGrupoItemConfiguracao = gerenciamentoItemConfiguracaoDTO.getControllerIdGrupo();
			GrupoICValorIndisponibilidadeDTO grupoICValorIndisponibilidadeDTO = getGrupoICValorIndisponibilidadeService().getByIdGrupoItemConfiguracao(idGrupoItemConfiguracao);
			if (grupoICValorIndisponibilidadeDTO != null && grupoICValorIndisponibilidadeDTO.getValor() != null) {
				Locale locale = new Locale("pt", "BR");
				if (WebUtil.getLanguage(request).equalsIgnoreCase("en")) {
					locale = new Locale("en", "US");
				} else if (WebUtil.getLanguage(request).equalsIgnoreCase("es")) {
					locale = new Locale("es", "ES");
				}

				document.executeScript("serValorIndiponibilidadeGrupo('".concat(NumberFormat.getInstance(locale).format(grupoICValorIndisponibilidadeDTO.getValor()).concat("')")));
			}
		}
	}

	public void exibirHierarquiaServicoApoio(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception{
		GerenciamentoItemConfiguracaoDTO gerenciamentoItemConfiguracaoDTO = (GerenciamentoItemConfiguracaoDTO) document.getBean();

		ArvoreServico arvServicos = getServicoService().getHieraquiaServicoApoioImpactado(gerenciamentoItemConfiguracaoDTO.getIdServicoImpactado());

		JSONObject json = arvServicos.getJsonNodeStructureTreeChart(WebUtil.getLanguage(request));

		document.executeScript("ItemConfiguracao.View.Tab.Impactos.exibirHierarquiaServicoApoio(" + json.toString() + ")");
	}

	@Override
	public Class<GerenciamentoItemConfiguracaoDTO> getBeanClass() {
		return GerenciamentoItemConfiguracaoDTO.class;
	}

	private GrupoItemConfiguracaoService getGrupoItemConfiguracaoService() throws ServiceException {
		if (grupoItemConfiguracaoService == null) {
			grupoItemConfiguracaoService = (GrupoItemConfiguracaoService) ServiceLocator.getInstance().getService(GrupoItemConfiguracaoService.class, null);
		}

		return grupoItemConfiguracaoService;
	}

	private EvmConexaoService getEvmConexaoService() throws ServiceException {
		if (evmConexaoService == null) {
			evmConexaoService = (EvmConexaoService) ServiceLocator.getInstance().getService(EvmConexaoService.class, null);
		}
		return evmConexaoService;
	}

	private ItemConfiguracaoService getItemConfiguracaoService() throws ServiceException {
		if (itemConfiguracaoService == null) {
			itemConfiguracaoService = (ItemConfiguracaoService) ServiceLocator.getInstance().getService(ItemConfiguracaoService.class, null);
		}

		return itemConfiguracaoService;
	}

	private TipoItemConfiguracaoService getTipoItemConfiguracaoService() throws ServiceException {
		if (tipoItemConfiguracaoService == null) {
			tipoItemConfiguracaoService = (TipoItemConfiguracaoService) ServiceLocator.getInstance().getService(TipoItemConfiguracaoService.class, null);
		}

		return tipoItemConfiguracaoService;
	}

	private ContratoService getContratoService() throws ServiceException {
		if (contratoService == null) {
			contratoService = (ContratoService) ServiceLocator.getInstance().getService(ContratoService.class, null);
		}

		return contratoService;
	}

	private EmpregadoService getEmpregadoService() throws ServiceException {
		if (empregadoService == null) {
			empregadoService = (EmpregadoService) ServiceLocator.getInstance().getService(EmpregadoService.class, null);
		}

		return empregadoService;
	}

	private GrupoService getGrupoService() throws ServiceException {
		if (grupoService == null) {
			grupoService = (GrupoService) ServiceLocator.getInstance().getService(GrupoService.class, null);
		}

		return grupoService;
	}

	private CaracteristicaService getCaracteristicaService() throws ServiceException {
		if (caracteristicaService == null) {
			caracteristicaService = (CaracteristicaService) ServiceLocator.getInstance().getService(CaracteristicaService.class, null);
		}

		return caracteristicaService;
	}

	private SolicitacaoServicoService getSolicitacaoServicoService() throws ServiceException {
		if (solicitacaoServicoService == null) {
			solicitacaoServicoService = (SolicitacaoServicoService) ServiceLocator.getInstance().getService(SolicitacaoServicoService.class, null);
		}

		return solicitacaoServicoService;
	}

	private ProblemaService getProblemaService() throws ServiceException {
		if (problemaService == null) {
			problemaService = (ProblemaService) ServiceLocator.getInstance().getService(ProblemaService.class, null);
		}

		return problemaService;
	}

	private RequisicaoMudancaService getRequisicaoMudancaService() throws ServiceException {
		if (requisicaoMudancaService == null) {
			requisicaoMudancaService = (RequisicaoMudancaService) ServiceLocator.getInstance().getService(RequisicaoMudancaService.class, null);
		}

		return requisicaoMudancaService;
	}

	private RequisicaoLiberacaoService getRequisicaoLiberacaoService() throws ServiceException {
		if (requisicaoLiberacaoService == null) {
			requisicaoLiberacaoService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, null);
		}

		return requisicaoLiberacaoService;
	}

	private ConhecimentoICService getConhecimentoICService() throws ServiceException {
		if (conhecimentoICService == null) {
			conhecimentoICService = (ConhecimentoICService) ServiceLocator.getInstance().getService(ConhecimentoICService.class, null);
		}

		return conhecimentoICService;
	}

	private HistoricoItemConfiguracaoService getHistoricoItemConfiguracaoService() throws ServiceException {
		if (historicoItemConfiguracaoService == null) {
			historicoItemConfiguracaoService = (HistoricoItemConfiguracaoService) ServiceLocator.getInstance().getService(HistoricoItemConfiguracaoService.class, null);
		}

		return historicoItemConfiguracaoService;
	}

	private HistoricoValorService getHistoricoValorService() throws ServiceException {
		if (historicoValorService == null) {
			historicoValorService = (HistoricoValorService) ServiceLocator.getInstance().getService(HistoricoValorService.class, null);
		}

		return historicoValorService;
	}

	private MidiaSoftwareService getMidiaSoftwareService() throws ServiceException {
		if (midiaSoftwareService == null) {
			midiaSoftwareService = (MidiaSoftwareService) ServiceLocator.getInstance().getService(MidiaSoftwareService.class, null);
		}

		return midiaSoftwareService;
	}

	private BIConsultaService getBIConsultaService() throws ServiceException {
		if (biConsultaService == null) {
			biConsultaService = (BIConsultaService) ServiceLocator.getInstance().getService(BIConsultaService.class, null);
		}
		return biConsultaService;
	}

	private MenuService getMenuService() throws ServiceException {
		if (menuService == null) {
			menuService = (MenuService) ServiceLocator.getInstance().getService(MenuService.class, null);
		}
		return menuService;
	}

	private PerfilAcessoMenuService getPerfilAcessoMenuService() throws ServiceException {
		if (perfilAcessoMenuService == null) {
			perfilAcessoMenuService = (PerfilAcessoMenuService) ServiceLocator.getInstance().getService(PerfilAcessoMenuService.class, null);
		}
		return perfilAcessoMenuService;
	}

	private UsuarioService getUsuarioService() throws ServiceException {
		if (usuarioService == null) {
			usuarioService = (UsuarioService) ServiceLocator.getInstance().getService(UsuarioService.class, null);
		}
		return usuarioService;
	}

	private GrupoEmpregadoService getGrupoEmpregadoService() throws ServiceException {
		if (grupoEmpregadoService == null) {
			grupoEmpregadoService = (GrupoEmpregadoService) ServiceLocator.getInstance().getService(GrupoEmpregadoService.class, null);
		}
		return grupoEmpregadoService;
	}

	private PerfilAcessoGrupoService getPerfilAcessoGrupoServicee() throws ServiceException {
		if (perfilAcessoGrupoService == null) {
			perfilAcessoGrupoService = (PerfilAcessoGrupoService) ServiceLocator.getInstance().getService(PerfilAcessoGrupoService.class, null);
		}
		return perfilAcessoGrupoService;
	}

	private ItemConfiguracaoValorService getItemConfiguracaoValorService() throws ServiceException {
		if (itemConfiguracaoValorService == null) {
			itemConfiguracaoValorService = (ItemConfiguracaoValorService) ServiceLocator.getInstance().getService(ItemConfiguracaoValorService.class, null);
		}
		return itemConfiguracaoValorService;
	}

	private IndicadorCapacidadeService getIndicadorCapacidadeService() throws ServiceException {
		if (indicadorCapacidadeService == null) {
			indicadorCapacidadeService = (IndicadorCapacidadeService) ServiceLocator.getInstance().getService(IndicadorCapacidadeService.class, null);
		}
		return indicadorCapacidadeService;
	}

	private IndicadorCapacidadeItemConfiguracaoService getIndicadorCapacidadeItemConfiguracaoService() throws ServiceException {
		if (indicadorCapacidadeItemConfiguracaoService == null) {
			indicadorCapacidadeItemConfiguracaoService = (IndicadorCapacidadeItemConfiguracaoService) ServiceLocator.getInstance().getService(IndicadorCapacidadeItemConfiguracaoService.class, null);
		}
		return indicadorCapacidadeItemConfiguracaoService;
	}

	private AtributoDemandaService getAtributoDemandaService() throws ServiceException {
		if (atributoDemandaService == null) {
			atributoDemandaService = (AtributoDemandaService) ServiceLocator.getInstance().getService(AtributoDemandaService.class, null);
		}
		return atributoDemandaService;
	}

	private AtributoDemandaItemConfiguracaoService getAtributoDemandaItemConfiguracaoService() throws ServiceException {
		if (atributoDemandaItemConfiguracaoService == null) {
			atributoDemandaItemConfiguracaoService = (AtributoDemandaItemConfiguracaoService) ServiceLocator.getInstance().getService(AtributoDemandaItemConfiguracaoService.class, null);
		}
		return atributoDemandaItemConfiguracaoService;
	}

	private LocalidadeService getLocalidadeService() throws ServiceException {
		if (localidadeService == null) {
			localidadeService = (LocalidadeService) ServiceLocator.getInstance().getService(LocalidadeService.class, null);
		}
		return localidadeService;
	}

	private HistoricoBaseConhecimentoService getHistoricoBaseConhecimentoService() throws ServiceException {
		if (historicoBaseConhecimentoService == null) {
			historicoBaseConhecimentoService = (HistoricoBaseConhecimentoService) ServiceLocator.getInstance().getService(HistoricoBaseConhecimentoService.class, null);
		}
		return historicoBaseConhecimentoService;
	}

	private GrupoItemConfiguracaoAcordoNivelServicoService getGrupoItemConfiguracaoAcordoNivelServicoService() throws ServiceException {
		if (grupoItemConfiguracaoAcordoNivelServicoService == null) {
			grupoItemConfiguracaoAcordoNivelServicoService = (GrupoItemConfiguracaoAcordoNivelServicoService) ServiceLocator.getInstance().getService(GrupoItemConfiguracaoAcordoNivelServicoService.class, null);
		}
		return grupoItemConfiguracaoAcordoNivelServicoService;
	}

	private GrupoItemConfiguracaoCalendarioService getGrupoItemConfiguracaoCalendarioService() throws ServiceException {
		if (grupoItemConfiguracaoCalendarioService == null) {
			grupoItemConfiguracaoCalendarioService = (GrupoItemConfiguracaoCalendarioService) ServiceLocator.getInstance().getService(GrupoItemConfiguracaoCalendarioService.class, null);
		}
		return grupoItemConfiguracaoCalendarioService;
	}

	private ItemConfiguracaoAcordoNivelServicoService getItemConfiguracaoAcordoNivelServicoService() throws ServiceException {
		if (itemConfiguracaoAcordoNivelServicoService == null) {
			itemConfiguracaoAcordoNivelServicoService = (ItemConfiguracaoAcordoNivelServicoService) ServiceLocator.getInstance().getService(ItemConfiguracaoAcordoNivelServicoService.class, null);
		}
		return itemConfiguracaoAcordoNivelServicoService;
	}

	private ItemConfiguracaoCalendarioService getItemConfiguracaoCalendarioService() throws ServiceException {
		if (itemConfiguracaoCalendarioService == null) {
			itemConfiguracaoCalendarioService = (ItemConfiguracaoCalendarioService) ServiceLocator.getInstance().getService(ItemConfiguracaoCalendarioService.class, null);
		}
		return itemConfiguracaoCalendarioService;
	}

	private CalendarioService getCalendarioService() throws ServiceException {
		if (calendarioService == null) {
			calendarioService = (CalendarioService) ServiceLocator.getInstance().getService(CalendarioService.class, null);
		}
		return calendarioService;
	}

	private AcordoNivelServicoService getAcordoNivelServicoService() throws ServiceException {
		if (acordoNivelServicoService == null) {
			acordoNivelServicoService = (AcordoNivelServicoService) ServiceLocator.getInstance().getService(AcordoNivelServicoService.class, null);
		}
		return acordoNivelServicoService;
	}

	private GrupoICValorIndisponibilidadeService getGrupoICValorIndisponibilidadeService() throws ServiceException {
		if(grupoICValorIndisponibilidadeService == null) {
			grupoICValorIndisponibilidadeService = (GrupoICValorIndisponibilidadeService) ServiceLocator.getInstance().getService(GrupoICValorIndisponibilidadeService.class, null);
		}
		return grupoICValorIndisponibilidadeService;
	}

	private ServicoService getServicoService() throws ServiceException {
		if (servicoService == null) {
			servicoService = (ServicoService) ServiceLocator.getInstance().getService(ServicoService.class, null);
		}
		return servicoService;
	}

	private StatusInventarioService getStatusInventarioService() throws ServiceException {
		if (statusInventarioService == null) {
			statusInventarioService = (StatusInventarioService) ServiceLocator.getInstance().getService(StatusInventarioService.class, null);
		}
		return statusInventarioService;
	}

	private EvmInventoryConfiguracaoService getEvmInventoryConfiguracaoService() throws ServiceException {
		if (evmInventoryConfiguracaoService == null) {
			evmInventoryConfiguracaoService = (EvmInventoryConfiguracaoService) ServiceLocator.getInstance().getService(EvmInventoryConfiguracaoService.class, null);
		}
		return evmInventoryConfiguracaoService;
	}

	private SmartReportService getSmartReportService() throws ServiceException {
		if (smartReportService == null) {
			smartReportService = (SmartReportService) ServiceLocator.getInstance().getService(SmartReportService.class, null);
		}
		return smartReportService;
	}
}