package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;

import br.com.centralit.bpm.dto.ElementoFluxoDTO;
import br.com.centralit.bpm.dto.TarefaFluxoDTO;
import br.com.centralit.bpm.util.Enumerated;
import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citcorpore.bean.BIConsultaDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoLiberacaoDTO;
import br.com.centralit.citcorpore.bean.RequisicaoLiberacaoDTO;
import br.com.centralit.citcorpore.bean.SmartReportDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.AtribuicaoFluxoService;
import br.com.centralit.citcorpore.negocio.BIConsultaService;
import br.com.centralit.citcorpore.negocio.ExecucaoLiberacaoService;
import br.com.centralit.citcorpore.negocio.RequisicaoLiberacaoService;
import br.com.centralit.citcorpore.negocio.SmartReportService;
import br.com.centralit.citcorpore.util.Enumerados.ModuloExibicaoRelatorio;
import br.com.centralit.citcorpore.util.Enumerados.ReleaseRequestStatus;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.Enumerados.TipoExibicaoRelatorio;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;
import br.com.citframework.util.UtilStrings;

public class GerenciamentoLiberacao extends AjaxFormAction {

	private BIConsultaService biConsultaService;
	private SmartReportService smartReportService;
	private AtribuicaoFluxoService atribuicaoFluxoService;

	@Override
	public Class<GerenciamentoLiberacaoDTO> getBeanClass() {
		return GerenciamentoLiberacaoDTO.class;
	}

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		exibeTarefas(document, request, response);
		loadRelatorios(document, request, response);

		UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario != null && usuario.getNomeUsuario() != null) {
			request.setAttribute("login", WebUtil.getUsuario(request).getNomeUsuario());
		}
	}

	public void exibeTarefas(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		UsuarioDTO usuario = WebUtil.getUsuario(request);

		WebUtil.validarSeUsuarioEstaNaSessao(request, document);

		GerenciamentoLiberacaoDTO gerenciamentoBean = (GerenciamentoLiberacaoDTO) document.getBean();

		ExecucaoLiberacaoService execucaoLiberacaoService = (ExecucaoLiberacaoService) ServiceLocator.getInstance().getService(ExecucaoLiberacaoService.class, null);
		List<TarefaFluxoDTO> colTarefas = execucaoLiberacaoService.recuperaTarefas(usuario.getLogin());
		if (colTarefas == null) {
			return;
		}

		boolean bFiltroPorSolicitacao = gerenciamentoBean.getIdRequisicaoSel() != null && gerenciamentoBean.getIdRequisicaoSel().length() > 0;
		List<TarefaFluxoDTO> colTarefasFiltradas = new ArrayList<TarefaFluxoDTO>();
		if (!bFiltroPorSolicitacao) {
			colTarefasFiltradas.addAll(colTarefas);
		} else {
			for (TarefaFluxoDTO tarefaDto : colTarefas) {
				boolean bAdicionar = false;
				String idRequisicao = "" + ((RequisicaoLiberacaoDTO) tarefaDto.getRequisicaoLiberacaoDto()).getIdRequisicaoLiberacao();
				bAdicionar = idRequisicao.indexOf(gerenciamentoBean.getIdRequisicaoSel()) >= 0;
				if (bAdicionar) {
					colTarefasFiltradas.add(tarefaDto);
				}
			}
		}
		List<TarefaFluxoDTO> colTarefasFiltradasFinal = new ArrayList<TarefaFluxoDTO>();
		HashMap<String, String> mapAtr = new HashMap<String, String>();
		UtilI18N.internacionaliza(request, "citcorpore.comum.sematribuicao");
		mapAtr.put(UtilI18N.internacionaliza(request, "citcorpore.comum.sematribuicao"), UtilI18N.internacionaliza(request, "citcorpore.comum.sematribuicao"));
		for (TarefaFluxoDTO tarefaDto : colTarefasFiltradas) {
			RequisicaoLiberacaoDTO requisicaoLiberacaoDto = (RequisicaoLiberacaoDTO) tarefaDto.getRequisicaoLiberacaoDto();
			requisicaoLiberacaoDto.setDescricao("");

			if (tarefaDto.getResponsavelAtual() != null) {
				if (!mapAtr.containsKey(requisicaoLiberacaoDto.getResponsavelAtual())) {
					mapAtr.put(requisicaoLiberacaoDto.getResponsavelAtual(), requisicaoLiberacaoDto.getResponsavelAtual());
				}
			}

			requisicaoLiberacaoDto.setDataHoraInicioStr(UtilDatas.convertDateToString(TipoDate.TIMESTAMP_DEFAULT, requisicaoLiberacaoDto.getDataHoraInicio(), WebUtil.getLanguage(request)));
			requisicaoLiberacaoDto.setDataHoraSolicitacaoStr(UtilDatas.convertDateToString(TipoDate.TIMESTAMP_DEFAULT, requisicaoLiberacaoDto.getDataHoraInicio(), WebUtil.getLanguage(request)));
			requisicaoLiberacaoDto.setDataHoraTerminoStr(UtilDatas.convertDateToString(TipoDate.TIMESTAMP_DEFAULT, requisicaoLiberacaoDto.getDataHoraTermino(), WebUtil.getLanguage(request)));
			requisicaoLiberacaoDto.setDataInicioStr(UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, requisicaoLiberacaoDto.getDataHoraInicioAgendada(), WebUtil.getLanguage(request)));
			requisicaoLiberacaoDto.setDataTerminoStr(UtilDatas.convertDateToString(TipoDate.DATE_DEFAULT, requisicaoLiberacaoDto.getDataHoraTerminoAgendada(), WebUtil.getLanguage(request)));
			requisicaoLiberacaoDto.setDatahoraAprovacaoStr(UtilDatas.convertDateToString(TipoDate.TIMESTAMP_DEFAULT, requisicaoLiberacaoDto.getDatahoraAprovacao(), WebUtil.getLanguage(request)));
			// Verifica se usuario  o responsavel pela liberao da requisio
			//(usuario.getIdEmpregado() == dtoSol.getIdSolicitante() ){
			//	dtoSol.setAutorizadoLiberar("S");
			//}

			if (gerenciamentoBean.getAtribuidaCompartilhada() == null || gerenciamentoBean.getAtribuidaCompartilhada().trim().equalsIgnoreCase("")) {
				colTarefasFiltradasFinal.add(tarefaDto);
			} else {
				if (gerenciamentoBean.getAtribuidaCompartilhada().trim().equalsIgnoreCase(UtilI18N.internacionaliza(request, "citcorpore.comum.sematribuicao"))) {
					if (requisicaoLiberacaoDto.getResponsavelAtual() == null || requisicaoLiberacaoDto.getResponsavelAtual().trim().equalsIgnoreCase("")) {
						colTarefasFiltradasFinal.add(tarefaDto);
					}
				} else {
					if (gerenciamentoBean.getAtribuidaCompartilhada().trim().equalsIgnoreCase(requisicaoLiberacaoDto.getResponsavelAtual())) {
						colTarefasFiltradasFinal.add(tarefaDto);
					}
				}
			}
		}
		String tarefasStr = serializaTarefas(colTarefasFiltradasFinal, request);

		document.executeScript("exibirGraficos('" + tarefasStr + "');");

		montarTabelaLiberacoes(document, request, colTarefasFiltradasFinal);

		loadRelatoriosEspecificos(document, request, response);

		carregaComboAtribuidaCompartilhada(document, request, gerenciamentoBean, mapAtr);
	}

	private void carregaComboAtribuidaCompartilhada(DocumentHTML document, HttpServletRequest request, GerenciamentoLiberacaoDTO gerenciamentoBean, HashMap<String, String> mapAtr) throws Exception {
		document.getSelectById("atribuidaCompartilhada").removeAllOptions();
		document.getSelectById("atribuidaCompartilhada").addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.todos") + " --");

		for (Iterator<String> it = mapAtr.values().iterator(); it.hasNext();) {
			String str = it.next();
			document.getSelectById("atribuidaCompartilhada").addOption(str, str);
		}

		document.getSelectById("atribuidaCompartilhada").setValue(gerenciamentoBean.getAtribuidaCompartilhada());
		document.getJanelaPopupById("parent.JANELA_AGUARDE_MENU").hide();
	}

	private void montarTabelaLiberacoes(DocumentHTML document, HttpServletRequest request, List<TarefaFluxoDTO> colTarefasFiltradasFinal) throws Exception {
		HTMLElement divTabelaLiberacoes = document.getElementById("divConteudoLista");
		StringBuilder conteudoHtml = new StringBuilder();

		if (colTarefasFiltradasFinal == null || colTarefasFiltradasFinal.isEmpty()) {
			conteudoHtml.append("<div class='separator'></div>");
			conteudoHtml.append("<h4 class=\"align-center\">").append(UtilI18N.internacionaliza(request, "MSG04")).append("</h4>");
		} else {
			ArrayList<String> colunas = new ArrayList<String>();
			colunas.add("citcorpore.comum.numero");
			colunas.add("solicitacaoServico.solicitante");
			colunas.add("solicitacaoServico.dataHoraCriacao");
			colunas.add("gerenciaservico.pri");
			colunas.add("solicitacaoServico.prazoLimite");
			colunas.add("tarefa.atraso");
			colunas.add("solicitacaoServico.situacao");
			colunas.add("tarefa.tarefa_atual");
			colunas.add("citcorpore.comum.grupoExecutorAtual");
			colunas.add("tarefa.responsavelatual");
			colunas.add("tarefa.compartilhadacom");
			colunas.add("citcorpore.comum.acoes");

			conteudoHtml.append(UtilHTML.geraHTMLCabecalhoTabela(request, colunas));
			for (TarefaFluxoDTO tarefa : colTarefasFiltradasFinal) {
				conteudoHtml.append(geraHtmlDadosTabela(request, tarefa));
			}
			conteudoHtml.append(UtilHTML.geraHTMLRodapeTabela());
		}

		divTabelaLiberacoes.setInnerHTML(conteudoHtml.toString());
	}

	private String geraHtmlDadosTabela(final HttpServletRequest request, TarefaFluxoDTO tarefa) throws Exception {
		StringBuilder sb = new StringBuilder();
		sb.append("		<tr>");

		RequisicaoLiberacaoDTO requisicaoLiberacao = (RequisicaoLiberacaoDTO) tarefa.getRequisicaoLiberacaoDto();
		ElementoFluxoDTO elementoFluxo = tarefa.getElementoFluxoDto();

		if (requisicaoLiberacao != null) {
			sb.append("			<td>".concat(UtilNumbersAndDecimals.nullToVazio(requisicaoLiberacao.getIdRequisicaoLiberacao())).concat("</td>"));
			sb.append("			<td>".concat(UtilStrings.nullToVazio(requisicaoLiberacao.getNomeSolicitante())).concat("</td>"));
			sb.append("			<td>".concat(UtilStrings.nullToVazio(requisicaoLiberacao.getDataHoraInicioStr())).concat("</td>"));

			if (requisicaoLiberacao.getPrioridade() != null && requisicaoLiberacao.getPrioridade().equals(new Integer(1))) {
				sb.append("			<td>".concat(UtilNumbersAndDecimals.nullToVazio(requisicaoLiberacao.getPrioridade())).concat("&nbsp;<img src='").concat(Constantes.getValue("CONTEXTO_APLICACAO")).concat("/imagens/b.gif' style='cursor: pointer;' title='").concat(UtilI18N.internacionaliza(request, "gerenciaservico.prioridadealta")).concat("'/></td>"));
			} else {
				sb.append("			<td>".concat(UtilNumbersAndDecimals.nullToVazio(requisicaoLiberacao.getPrioridade())).concat("</td>"));
			}

			sb.append("			<td>".concat(UtilStrings.nullToVazio(requisicaoLiberacao.getDataHoraTerminoStr())).concat("</td>"));

			if (requisicaoLiberacao.getAtraso() > new Double(0) && !ReleaseRequestStatus.SUSPENDED.getId().equals(requisicaoLiberacao.getIdStatus())) {
				sb.append("			<td class='lblRed'>".concat(UtilStrings.nullToVazio(requisicaoLiberacao.getAtrasoStr())).concat("</td>"));
			} else {
				sb.append("			<td></td>");
			}
			sb.append("			<td>".concat(UtilStrings.nullToVazio(UtilI18N.internacionaliza(request, requisicaoLiberacao.getDescrStatus()))).concat("</td>"));
			sb.append("			<td>".concat(UtilStrings.nullToVazio(elementoFluxo.getDocumentacao())).concat("</td>"));

			String nomeGrupoTarefaAtual = this.getNomeGrupoTarefaAtual(request, tarefa);

			if (nomeGrupoTarefaAtual != null && !nomeGrupoTarefaAtual.isEmpty()) {
				sb.append(" <td>".concat(nomeGrupoTarefaAtual).concat("</td>"));
			} else {
				sb.append("			<td>".concat(UtilStrings.nullToVazio(requisicaoLiberacao.getNomeGrupoAtual())).concat("</td>"));
			}

			sb.append("			<td>".concat(UtilStrings.nullToVazio(tarefa.getResponsavelAtual())).concat("</td>"));
			sb.append("			<td>".concat(UtilStrings.nullToVazio(tarefa.getCompartilhamento())).concat("</td>"));

			geraAcoesTabela(request, sb, tarefa, requisicaoLiberacao, elementoFluxo);
		}

		sb.append("		</tr> ");

		return sb.toString();
	}

	private String getNomeGrupoTarefaAtual(final HttpServletRequest request, TarefaFluxoDTO tarefa) throws Exception {
		String nomeGrupoAtual = "";
		Integer idType = 1;

		boolean suspender = SimNao.SIM.getValorStr().equalsIgnoreCase(tarefa.getSuspender());
		boolean reativar = SimNao.SIM.getValorStr().equalsIgnoreCase(tarefa.getReativar());
		boolean executar = SimNao.SIM.getValorStr().equalsIgnoreCase(tarefa.getExecutar());
		boolean delegar = SimNao.SIM.getValorStr().equalsIgnoreCase(tarefa.getDelegar());

		if (!suspender && !reativar && !executar && !delegar && tarefa.getIdItemTrabalho() != null) {
			idType = Enumerated.AssignmentType.MONITORING.getId();
		}

		nomeGrupoAtual = this.getAtribuicaoFluxoService().getNomeGrupoTarefaAtual(tarefa.getIdItemTrabalho(), idType);

		return (nomeGrupoAtual != null && !nomeGrupoAtual.isEmpty() ? nomeGrupoAtual : "");
	}

	private void geraAcoesTabela(final HttpServletRequest request, StringBuilder sb, TarefaFluxoDTO tarefa, RequisicaoLiberacaoDTO requisicaoLiberacao, ElementoFluxoDTO elementoFluxo)
			throws Exception {

		sb.append("			<td class=\"center\" style=\"width: 200px;\"> ");
		sb.append("				<div class='span12'>");
		sb.append("					<div class='span4'>");

		// Visualizar Solicitao
		String onclickVisualizarSolicitacao = "visualizarSolicitacao(".concat(UtilNumbersAndDecimals.nullToVazio(requisicaoLiberacao.getIdRequisicaoLiberacao())).concat(")");
		geraSpanButton(request, sb, "btn-action glyphicons search btn-primary mt2", "requisicaoLiberacao.visualizarCadastroLiberacao", onclickVisualizarSolicitacao);

		// Relatrios Especficos
		sb.append("					<span class='btn-action glyphicons charts btn-primary gl-relatorios-especificos mt2' style='cursor:pointer;' data-idespecifico='".concat(UtilNumbersAndDecimals.nullToVazio(requisicaoLiberacao.getIdRequisicaoLiberacao())).concat("' data-title='").concat(UtilI18N.internacionaliza(request, "menu.nome.relatorio")).concat("' tabindex='0' data-toggle='popover' data-trigger='focus'  data-container='body' ").concat("data-placement='top' data-html='true' data-content='' ").concat("onclick='javascript: return false;'>").concat("<i></i></span>"));

		sb.append("					</div>");
		sb.append("					<div class='span8'>");

		geraDropdownInicio(request, sb);

		// Agendar Liberao
		String onclickAgendarLiberacao = "agendaAtividade(".concat(UtilNumbersAndDecimals.nullToVazio(requisicaoLiberacao.getIdRequisicaoLiberacao())).concat(")");
		geraAcoesDropdown(request, sb, onclickAgendarLiberacao, "gerenciamentoMudanca.agendarLiberacao");
		if (!ReleaseRequestStatus.SUSPENDED.getId().equals(requisicaoLiberacao.getIdStatus()) && SimNao.SIM.getValorStr().equalsIgnoreCase(tarefa.getSuspender())) {

			String onclickPrepararSuspensao = "prepararSuspensao(".concat(UtilNumbersAndDecimals.nullToVazio(requisicaoLiberacao.getIdRequisicaoLiberacao())).concat(")");
			geraAcoesDropdown(request, sb, onclickPrepararSuspensao, "requisicaoLiberacao.suspenderLiberacao");
		} else if (ReleaseRequestStatus.SUSPENDED.getId().equals(requisicaoLiberacao.getIdStatus()) && SimNao.SIM.getValorStr().equalsIgnoreCase(tarefa.getReativar())) {

			String onclickReativarLiberacao = "reativarSolicitacao(".concat(UtilNumbersAndDecimals.nullToVazio(requisicaoLiberacao.getIdRequisicaoLiberacao())).concat(")");
			geraAcoesDropdown(request, sb, onclickReativarLiberacao, "requisicaoLiberacao.reativarLiberacao");
		}

		UsuarioDTO usuario = WebUtil.getUsuario(request);
		String loginUsuario = UtilStrings.nullToVazio(usuario.getLogin());

		if (!ReleaseRequestStatus.SUSPENDED.getId().equals(requisicaoLiberacao.getIdStatus()) && SimNao.SIM.getValorStr().equalsIgnoreCase(tarefa.getExecutar())) {
			if (requisicaoLiberacao.getResponsavelAtual() == null || !requisicaoLiberacao.getResponsavelAtual().equalsIgnoreCase(loginUsuario)) {
				String onclickCapturar = "capturarTarefa(\"".concat(tarefa.getResponsavelAtual()).concat("\",").concat(UtilNumbersAndDecimals.nullToVazio(tarefa.getIdItemTrabalho())).concat(",").concat(UtilNumbersAndDecimals.nullToVazio(requisicaoLiberacao.getIdRequisicaoLiberacao())).concat(")");

				geraAcoesDropdown(request, sb, onclickCapturar, "gerenciaservico.capturartarefa");
			}

			String onclickExecutarTarefa = "prepararExecucaoTarefa(".concat(UtilNumbersAndDecimals.nullToVazio(tarefa.getIdItemTrabalho())).concat(",").concat(UtilNumbersAndDecimals.nullToVazio(requisicaoLiberacao.getIdRequisicaoLiberacao())).concat(",\"E\");");

			geraAcoesDropdown(request, sb, onclickExecutarTarefa, "gerenciaservico.iniciarexecutartarefa");
		}

		if (SimNao.SIM.getValorStr().equalsIgnoreCase(tarefa.getDelegar())) {
			String onclickDelegarCompartilhar = "exibirDelegacaoTarefa(".concat(UtilNumbersAndDecimals.nullToVazio(tarefa.getIdItemTrabalho())).concat(",").concat(UtilNumbersAndDecimals.nullToVazio(requisicaoLiberacao.getIdRequisicaoLiberacao())).concat(",\"").concat(UtilStrings.nullToVazio(elementoFluxo.getDocumentacao())).concat("\")");
			geraAcoesDropdown(request, sb, onclickDelegarCompartilhar, "gerenciaservico.delegarcompartilhartarefa");
		}

		geraDropdownFim(sb);

		sb.append("					</div>");
		sb.append("				</div>");
		sb.append("			</td>");
	}

	private void geraSpanButton(HttpServletRequest request, StringBuilder sb, String clazz, String chaveTitulo, String onclick) {
		sb.append("<span class='".concat(clazz).concat("' title='"));
		sb.append(UtilI18N.internacionaliza(request, chaveTitulo));
		sb.append("' onclick='");
		sb.append(onclick);
		sb.append("' style='cursor:pointer;'><i></i></span>");
	}

	private void geraDropdownInicio(HttpServletRequest request, StringBuilder sb) throws Exception {
		sb.append("						<div id='acoes' class='btn-group btn-block w15 aLeft dropup span11'>");
		sb.append("							<div class='leadcontainer' data-toggle='dropdown'>");
		sb.append("								<button type='button' class='btn dropdown-lead btn-default'>" + UtilI18N.internacionaliza(request, "solicitacaoServico.acao") + "</button>");
		sb.append("							</div>");
		sb.append("							<a class='btn btn-default dropdown-toggle solicitacoes-toggle' data-toggle='dropdown'><span class='caret'></span> </a>");
		sb.append("							<ul class='dropdown-menu pull-right'>");
	}

	private void geraAcoesDropdown(HttpServletRequest request, StringBuilder sb, String onclick, String chaveTexto) throws Exception {
		sb.append("								<li onclick='".concat(onclick).concat("'><a >").concat(UtilI18N.internacionaliza(request, chaveTexto)).concat("</a></li>"));
	}

	private void geraDropdownFim(StringBuilder sb) {
		sb.append("							</ul>");
		sb.append("						</div>");
	}

	public void preparaExecucaoTarefa(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		UsuarioDTO usuario = WebUtil.getUsuario(request);
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);

		GerenciamentoLiberacaoDTO gerenciamentoBean = (GerenciamentoLiberacaoDTO) document.getBean();
		if (gerenciamentoBean.getIdTarefa() == null) {
			return;
		}

		ExecucaoLiberacaoService execucaoLiberacaoService = (ExecucaoLiberacaoService) ServiceLocator.getInstance().getService(ExecucaoLiberacaoService.class, null);
		TarefaFluxoDTO tarefaDto = execucaoLiberacaoService.recuperaTarefa(usuario.getLogin(), gerenciamentoBean.getIdTarefa());
		if (tarefaDto == null || tarefaDto.getElementoFluxoDto() == null || !tarefaDto.getExecutar().equals("S") || tarefaDto.getElementoFluxoDto().getTipoInteracao() == null) {
			return;
		}

		if (tarefaDto.getElementoFluxoDto().getTipoInteracao().equals(Enumerated.INTERACTION_VIEW)) {
			if (tarefaDto.getIdVisao() != null) {
				document.executeScript("exibirVisao('" + UtilI18N.internacionaliza(request, "gerenciaservico.iniciarexecutartarefa") + "','" + tarefaDto.getIdVisao() + "','" + tarefaDto.getElementoFluxoDto().getIdFluxo() + "','" + tarefaDto.getIdItemTrabalho() + "','" + gerenciamentoBean.getAcaoFluxo() + "');");
			} else {
				document.alert(UtilI18N.internacionaliza(request, "requisicaoliberacao.validacao.requisicaoliberacao"));
			}
		} else {
			String caracterParmURL = "?";
			if (tarefaDto.getElementoFluxoDto().getUrl().indexOf("?") > -1) { // Se na URL ja conter ?, entao colocar &
				caracterParmURL = "&";
			}
			document.executeScript("exibirUrl('" + UtilI18N.internacionaliza(request, "gerenciaservico.iniciarexecutartarefa") + " " + tarefaDto.getElementoFluxoDto().getDocumentacao() + "','" + tarefaDto.getElementoFluxoDto().getUrl() + caracterParmURL + "idRequisicaoLiberacao=" + ((RequisicaoLiberacaoDTO) tarefaDto.getRequisicaoLiberacaoDto()).getIdRequisicaoLiberacao() + "&idTarefa=" + tarefaDto.getIdItemTrabalho() + "&acaoFluxo=" + gerenciamentoBean.getAcaoFluxo() + "');");
		}
	}

	public void reativaRequisicao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		UsuarioDTO usuario = WebUtil.getUsuario(request);
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);

		GerenciamentoLiberacaoDTO gerenciamentoBean = (GerenciamentoLiberacaoDTO) document.getBean();
		if (gerenciamentoBean.getIdRequisicao() == null) {
			return;
		}

		RequisicaoLiberacaoService requisicaoLiberacaoService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, null);
		RequisicaoLiberacaoDTO requisicaoLiberacaoDto = requisicaoLiberacaoService.restoreAll(gerenciamentoBean.getIdRequisicao());
		requisicaoLiberacaoService.reativa(usuario, requisicaoLiberacaoDto);
		exibeTarefas(document, request, response);
	}

	public void aprovarLiberacao(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		UsuarioDTO usuario = WebUtil.getUsuario(request);
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);

		GerenciamentoLiberacaoDTO gerenciamentoBean = (GerenciamentoLiberacaoDTO) document.getBean();
		if (gerenciamentoBean.getIdRequisicao() == null) {
			return;
		}

		RequisicaoLiberacaoService requisicaoLiberacaoService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, WebUtil.getUsuarioSistema(request));
		RequisicaoLiberacaoDTO requisicaoLiberacaoDto = requisicaoLiberacaoService.restoreAll(gerenciamentoBean.getIdRequisicao());

		if (requisicaoLiberacaoDto != null && requisicaoLiberacaoDto.getIdAprovador() == null) {
			if (requisicaoLiberacaoDto != null) {
				if (usuario.getIdUsuario() != null) {
					requisicaoLiberacaoDto.setIdAprovador(usuario.getIdUsuario());
					requisicaoLiberacaoDto.setDatahoraAprovacao(UtilDatas.getDataHoraAtual());
					requisicaoLiberacaoDto.setUsuarioDto(usuario);
				}
			}
			requisicaoLiberacaoService.updateLiberacaoAprovada(requisicaoLiberacaoDto);
			document.alert(UtilI18N.internacionaliza(request, "requisicaoLiberacao.LiberacaoSucesso"));

		} else {
			document.alert(UtilI18N.internacionaliza(request, "requisicaoLiberacao.requisicaoLiderada"));
			return;
		}

		exibeTarefas(document, request, response);
	}

	private String serializaTarefas(List<TarefaFluxoDTO> colTarefas, HttpServletRequest request) throws Exception {

		if (colTarefas == null) {
			return null;
		}
		for (TarefaFluxoDTO tarefaDto : colTarefas) {
			String elementoFluxo_serialize = StringEscapeUtils.escapeJavaScript(br.com.citframework.util.WebUtil.serializeObject(tarefaDto.getElementoFluxoDto(), WebUtil.getLanguage(request)));
			String requisicaoLiberacao_serialize = StringEscapeUtils.escapeJavaScript(br.com.citframework.util.WebUtil.serializeObject(tarefaDto.getRequisicaoLiberacaoDto(), WebUtil.getLanguage(request)));

			tarefaDto.setElementoFluxo_serialize(elementoFluxo_serialize);
			tarefaDto.setSolicitacao_serialize(requisicaoLiberacao_serialize);
		}
		return br.com.citframework.util.WebUtil.serializeObjects(colTarefas, WebUtil.getLanguage(request));
	}

	public void capturaTarefa(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		UsuarioDTO usuario = WebUtil.getUsuario(request);
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);

		GerenciamentoLiberacaoDTO requisicaoBean = (GerenciamentoLiberacaoDTO) document.getBean();

		if (requisicaoBean.getIdTarefa() == null) {
			return;
		}

		RequisicaoLiberacaoService reqService = (RequisicaoLiberacaoService) ServiceLocator.getInstance().getService(RequisicaoLiberacaoService.class, WebUtil.getUsuarioSistema(request));
		RequisicaoLiberacaoDTO reqDto = new RequisicaoLiberacaoDTO();
		reqDto.setIdRequisicaoLiberacao(requisicaoBean.getIdRequisicao());
		reqDto = (RequisicaoLiberacaoDTO) reqService.restore(reqDto);

		reqDto.setIdProprietario(usuario.getIdUsuario());
		reqService.updateSimples(reqDto);

		ExecucaoLiberacaoService execucaoLiberacaoService = (ExecucaoLiberacaoService) ServiceLocator.getInstance().getService(ExecucaoLiberacaoService.class, WebUtil.getUsuarioSistema(request));
		execucaoLiberacaoService.executa(usuario, requisicaoBean.getIdTarefa(), Enumerated.ACTION_START);
		exibeTarefas(document, request, response);

		requisicaoBean = null;
	}

	public void onClosePopUp(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		exibeTarefas(document, request, response);
	}

	private BIConsultaService getBIConsultaService() throws ServiceException {
		if (biConsultaService == null) {
			biConsultaService = (BIConsultaService) ServiceLocator.getInstance().getService(BIConsultaService.class, null);
		}
		return biConsultaService;
	}

	private void loadRelatorios(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		StringBuilder sb = new StringBuilder();
		UsuarioDTO usuario = WebUtil.getUsuario(request);

		Collection<BIConsultaDTO> biConsultaListDTO = getBIConsultaService().findByTipoModuloExibicao(TipoExibicaoRelatorio.GERAL.getIdentificador(), ModuloExibicaoRelatorio.GERENCIAMENTO_LIBERACAO.getIdentificador());

		if (biConsultaListDTO != null && !biConsultaListDTO.isEmpty()) {
			for (BIConsultaDTO biConsultaDTO : biConsultaListDTO) {
				sb.append("<a href='#' onclick='openReport(&#39;" + biConsultaDTO.getTipoConsulta() + "&#39;, " + biConsultaDTO.getIdConsulta() + ",&#39;" + biConsultaDTO.getNomeConsulta() + "&#39;); return false;'>" + biConsultaDTO.getNomeConsulta() + "</a><br/>");
			}
		}

		Collection<SmartReportDTO> listSmartReport = getSmartReportService().findByIdsGrupoUsuarioAndTipoModuloExibicao(usuario.getColGrupos(), TipoExibicaoRelatorio.GERAL.getIdentificador(),
				ModuloExibicaoRelatorio.GERENCIAMENTO_LIBERACAO.getIdentificador());

		if (listSmartReport != null && !listSmartReport.isEmpty()) {
			for (SmartReportDTO smartReportDTO : listSmartReport) {
				sb.append("<a href='#' onclick='UtilSmartReport.open(" + smartReportDTO.getIdSmartReport() + ", null); return false;'>" + smartReportDTO.getIdentificacao() + "</a><br/>");
			}
		}

		if (sb.length() == 0) {
			sb.append(UtilI18N.internacionaliza(request, "citcorpore.comum.resultado"));
		}

		document.executeScript("initReports(\"" + sb.toString() + "\", 'G');");
	}

	private void loadRelatoriosEspecificos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		StringBuilder sb = new StringBuilder();
		UsuarioDTO usuario = WebUtil.getUsuario(request);

		Collection<BIConsultaDTO> biConsultaListDTO = getBIConsultaService().findByTipoModuloExibicao(TipoExibicaoRelatorio.ESPECIFICO.getIdentificador(), ModuloExibicaoRelatorio.GERENCIAMENTO_LIBERACAO.getIdentificador());

		if (biConsultaListDTO != null && !biConsultaListDTO.isEmpty()) {
			for (BIConsultaDTO biConsultaDTO : biConsultaListDTO) {
				sb.append("<a href='#' onclick='openReport(&#39;" + biConsultaDTO.getTipoConsulta() + "&#39;, " + biConsultaDTO.getIdConsulta() + ",&#39;" + biConsultaDTO.getNomeConsulta() + "&#39;, &#39;E&#39;, ${idespecifico}); return false;'>" + biConsultaDTO.getNomeConsulta() + "</a><br/>");
			}
		}

		Collection<SmartReportDTO> listSmartReport = getSmartReportService().findByIdsGrupoUsuarioAndTipoModuloExibicao(usuario.getColGrupos(), TipoExibicaoRelatorio.ESPECIFICO.getIdentificador(),
				ModuloExibicaoRelatorio.GERENCIAMENTO_LIBERACAO.getIdentificador());

		if (listSmartReport != null && !listSmartReport.isEmpty()) {
			for (SmartReportDTO smartReportDTO : listSmartReport) {
				sb.append("<a href='#' onclick='UtilSmartReport.open(" + smartReportDTO.getIdSmartReport() + ", ${idespecifico}); return false;'>" + smartReportDTO.getIdentificacao() + "</a><br/>");
			}
		}

		if (sb.length() == 0) {
			sb.append(UtilI18N.internacionaliza(request, "citcorpore.comum.resultado"));
		}

		document.executeScript("initReports(\"" + sb.toString() + "\", 'E');");
	}

	private SmartReportService getSmartReportService() throws ServiceException {
		if (smartReportService == null) {
			smartReportService = (SmartReportService) ServiceLocator.getInstance().getService(SmartReportService.class, null);
		}
		return smartReportService;
	}

	private AtribuicaoFluxoService getAtribuicaoFluxoService() throws ServiceException {
		if (atribuicaoFluxoService == null) {
			atribuicaoFluxoService = (AtribuicaoFluxoService) ServiceLocator.getInstance().getService(AtribuicaoFluxoService.class, null);
		}

		return atribuicaoFluxoService;
	}
}
