package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringEscapeUtils;

import br.com.centralit.bpm.dto.ElementoFluxoDTO;
import br.com.centralit.bpm.dto.TarefaFluxoDTO;
import br.com.centralit.bpm.util.Enumerated;
import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citcorpore.bean.BIConsultaDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoMudancasDTO;
import br.com.centralit.citcorpore.bean.RequisicaoMudancaDTO;
import br.com.centralit.citcorpore.bean.SmartReportDTO;
import br.com.centralit.citcorpore.bean.UsuarioDTO;
import br.com.centralit.citcorpore.negocio.BIConsultaService;
import br.com.centralit.citcorpore.negocio.ExecucaoMudancaService;
import br.com.centralit.citcorpore.negocio.RequisicaoMudancaService;
import br.com.centralit.citcorpore.negocio.SmartReportService;
import br.com.centralit.citcorpore.util.Enumerados.ChangeRequestStatus;
import br.com.centralit.citcorpore.util.Enumerados.ModuloExibicaoRelatorio;
import br.com.centralit.citcorpore.util.Enumerados.SimNao;
import br.com.centralit.citcorpore.util.Enumerados.TipoDate;
import br.com.centralit.citcorpore.util.Enumerados.TipoExibicaoRelatorio;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.Constantes;
import br.com.citframework.util.UtilDatas;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilNumbersAndDecimals;
import br.com.citframework.util.UtilStrings;

public class GerenciamentoMudancas extends AjaxFormAction {

	private BIConsultaService biConsultaService;
	private SmartReportService smartReportService;

	@Override
	public Class<GerenciamentoMudancasDTO> getBeanClass() {
		return GerenciamentoMudancasDTO.class;
	}

	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		this.exibeTarefas(document, request, response);
		loadRelatorios(document, request, response);

		UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario != null && usuario.getNomeUsuario() != null) {
			request.setAttribute("login", WebUtil.getUsuario(request).getNomeUsuario());
		}
	}

	/**
	 * Exibe as tarefas para o gerenciamento de mudanas
	 *
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 */
	public void exibeTarefas(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert("Sessao expirada! Favor efetuar logon novamente!");
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		final GerenciamentoMudancasDTO gerenciamentoBean = (GerenciamentoMudancasDTO) document.getBean();

		final ExecucaoMudancaService execucaoMudancaService = (ExecucaoMudancaService) ServiceLocator.getInstance().getService(ExecucaoMudancaService.class, null);
		final List<TarefaFluxoDTO> colTarefas = execucaoMudancaService.recuperaTarefas(usuario.getLogin());
		if (colTarefas == null) {
			return;
		}

		final boolean bFiltroPorSolicitacao = gerenciamentoBean.getIdRequisicaoSel() != null && gerenciamentoBean.getIdRequisicaoSel().length() > 0;
		final List<TarefaFluxoDTO> colTarefasFiltradas = new ArrayList<TarefaFluxoDTO>();
		if (!bFiltroPorSolicitacao) {
			colTarefasFiltradas.addAll(colTarefas);
		} else {
			for (final TarefaFluxoDTO tarefaDto : colTarefas) {
				boolean bAdicionar = false;
				final String idRequisicao = "" + ((RequisicaoMudancaDTO) tarefaDto.getRequisicaoMudancaDto()).getIdRequisicaoMudanca();
				bAdicionar = idRequisicao.indexOf(gerenciamentoBean.getIdRequisicaoSel()) >= 0;
				if (bAdicionar) {
					colTarefasFiltradas.add(tarefaDto);
				}
			}
		}
		final List<TarefaFluxoDTO> colTarefasFiltradasFinal = new ArrayList<TarefaFluxoDTO>();
		final HashMap<String, String> mapAtr = new HashMap<String, String>();
		mapAtr.put(UtilI18N.internacionaliza(request, "citcorpore.comum.sematribuicao"), UtilI18N.internacionaliza(request, "citcorpore.comum.sematribuicao"));
		for (final TarefaFluxoDTO tarefaDto : colTarefasFiltradas) {
			final RequisicaoMudancaDTO requisicaoMudancaDto = (RequisicaoMudancaDTO) tarefaDto.getRequisicaoMudancaDto();
			requisicaoMudancaDto.setDescricao("");
			requisicaoMudancaDto.setDataHoraInicioStr(UtilDatas.convertDateToString(TipoDate.TIMESTAMP_DEFAULT, requisicaoMudancaDto.getDataHoraInicio(), WebUtil.getLanguage(request)));
			requisicaoMudancaDto.setDataHoraTerminoStr(UtilDatas.convertDateToString(TipoDate.TIMESTAMP_DEFAULT, requisicaoMudancaDto.getDataHoraTermino(), WebUtil.getLanguage(request)));
			requisicaoMudancaDto.setDescrStatus(ChangeRequestStatus.chaveFromId(requisicaoMudancaDto.getIdStatus()));

			if (requisicaoMudancaDto.getResponsavelAtual() != null) {
				if (!mapAtr.containsKey(requisicaoMudancaDto.getResponsavelAtual())) {
					mapAtr.put(requisicaoMudancaDto.getResponsavelAtual(), requisicaoMudancaDto.getResponsavelAtual());
				}
			}

			if (gerenciamentoBean.getAtribuidaCompartilhada() == null || gerenciamentoBean.getAtribuidaCompartilhada().trim().equalsIgnoreCase("")) {
				colTarefasFiltradasFinal.add(tarefaDto);
			} else {
				if (gerenciamentoBean.getAtribuidaCompartilhada().trim().equalsIgnoreCase(UtilI18N.internacionaliza(request, "citcorpore.comum.sematribuicao"))) {
					if (requisicaoMudancaDto.getResponsavelAtual() == null || requisicaoMudancaDto.getResponsavelAtual().trim().equalsIgnoreCase("")) {
						colTarefasFiltradasFinal.add(tarefaDto);
					}
				} else {
					if (gerenciamentoBean.getAtribuidaCompartilhada().trim().equalsIgnoreCase(requisicaoMudancaDto.getResponsavelAtual())) {
						colTarefasFiltradasFinal.add(tarefaDto);
					}
				}
			}
		}
		final String tarefasStr = this.serializaTarefas(colTarefasFiltradasFinal, request);
		document.executeScript("exibirGraficos('" + tarefasStr + "');");

		montarTabelaMudancas(document, request, colTarefasFiltradasFinal);

		loadRelatoriosEspecificos(document, request, response);

		carregaComboAtribuidaCompartilhada(document, request, gerenciamentoBean, mapAtr);
	}

	private void carregaComboAtribuidaCompartilhada(final DocumentHTML document, final HttpServletRequest request, final GerenciamentoMudancasDTO gerenciamentoBean, final HashMap<String, String> mapAtr)
			throws Exception {
		document.getSelectById("atribuidaCompartilhada").removeAllOptions();
		document.getSelectById("atribuidaCompartilhada").addOption("", "-- " + UtilI18N.internacionaliza(request, "citcorpore.comum.todos") + " --");
		for (final Iterator<String> it = mapAtr.values().iterator(); it.hasNext();) {
			final String str = it.next();
			document.getSelectById("atribuidaCompartilhada").addOption(str, str);
		}
		document.getSelectById("atribuidaCompartilhada").setValue(gerenciamentoBean.getAtribuidaCompartilhada());
	}

	private String serializaTarefas(final List<TarefaFluxoDTO> colTarefas, final HttpServletRequest request) throws Exception {
		if (colTarefas == null) {
			return null;
		}
		for (final TarefaFluxoDTO tarefaDto : colTarefas) {
			final String elementoFluxo_serialize = StringEscapeUtils.escapeJavaScript(br.com.citframework.util.WebUtil.serializeObject(tarefaDto.getElementoFluxoDto(), WebUtil.getLanguage(request)));
			final String requisicaoMudanca_serialize = StringEscapeUtils
					.escapeJavaScript(br.com.citframework.util.WebUtil.serializeObject(tarefaDto.getRequisicaoMudancaDto(), WebUtil.getLanguage(request)));

			tarefaDto.setElementoFluxo_serialize(elementoFluxo_serialize);
			tarefaDto.setSolicitacao_serialize(requisicaoMudanca_serialize);
		}
		return br.com.citframework.util.WebUtil.serializeObjects(colTarefas, WebUtil.getLanguage(request));
	}

	private void montarTabelaMudancas(DocumentHTML document, HttpServletRequest request, List<TarefaFluxoDTO> colTarefasFiltradasFinal) throws Exception {
		HTMLElement divTabelaMudancas = document.getElementById("divConteudoLista");
		StringBuilder conteudoHtml = new StringBuilder();

		if (colTarefasFiltradasFinal == null || colTarefasFiltradasFinal.isEmpty()) {
			conteudoHtml.append("<div class='separator'></div>");
			conteudoHtml.append("<h4 class=\"align-center\">").append(UtilI18N.internacionaliza(request, "MSG04")).append("</h4>");
		} else {
			ArrayList<String> colunas = new ArrayList<String>();
			colunas.add("citcorpore.comum.numero");
			colunas.add("solicitacaoServico.solicitante");
			colunas.add("solicitacaoServico.dataHoraCriacao");
			colunas.add("gerenciamentoservico.prioridade");
			colunas.add("requisicaMudanca.prazo");
			colunas.add("solicitacaoServico.prazoLimite");
			colunas.add("tarefa.atraso");
			colunas.add("solicitacaoServico.situacao");
			colunas.add("tarefa.tarefa_atual");
			colunas.add("citcorpore.comum.grupoExecutor");
			colunas.add("tarefa.responsavelatual");
			colunas.add("citcorpore.comum.acoes");


			conteudoHtml.append(UtilHTML.geraHTMLCabecalhoTabela(request, colunas));
			for (TarefaFluxoDTO tarefa : colTarefasFiltradasFinal) {
				conteudoHtml.append(geraHtmlDadosTabela(request, tarefa));
			}
			conteudoHtml.append(UtilHTML.geraHTMLRodapeTabela());
		}

		divTabelaMudancas.setInnerHTML(conteudoHtml.toString());

		document.executeScript("configuraCamposResponsivosTabela()");
	}

	private String geraHtmlDadosTabela(final HttpServletRequest request, TarefaFluxoDTO tarefa) throws Exception {
		StringBuilder sb = new StringBuilder();
		sb.append("		<tr>");

		RequisicaoMudancaDTO requisicaoMudanca = (RequisicaoMudancaDTO) tarefa.getRequisicaoMudancaDto();
		ElementoFluxoDTO elementoFluxo = tarefa.getElementoFluxoDto();

		if (requisicaoMudanca != null) {
			sb.append("			<td>".concat(UtilNumbersAndDecimals.nullToVazio(requisicaoMudanca.getIdRequisicaoMudanca())).concat("</td>"));
			sb.append("			<td>".concat(UtilStrings.nullToVazio(requisicaoMudanca.getNomeSolicitante())).concat("</td>"));
			sb.append("			<td>".concat(UtilStrings.nullToVazio(requisicaoMudanca.getDataHoraInicioStr())).concat("</td>"));

			if (requisicaoMudanca.getPrioridade() != null && requisicaoMudanca.getPrioridade().equals(new Integer(1))) {
				sb.append("			<td>".concat(UtilNumbersAndDecimals.nullToVazio(requisicaoMudanca.getPrioridade()))
						.concat("&nbsp;<img src='").concat(Constantes.getValue("CONTEXTO_APLICACAO")).concat("/imagens/b.gif' style='cursor: pointer;' title='")
						.concat(UtilI18N.internacionaliza(request, "gerenciaservico.prioridadealta"))
						.concat("'/></td>"));
			} else {
				sb.append("			<td>".concat(UtilNumbersAndDecimals.nullToVazio(requisicaoMudanca.getPrioridade())).concat("</td>"));
			}

			sb.append("			<td>".concat(UtilNumbersAndDecimals.nullToVazio(requisicaoMudanca.getPrazoHH())).concat(":").concat(UtilNumbersAndDecimals.nullToVazio(requisicaoMudanca.getPrazoMM()))
					.concat("</td>"));
			sb.append("			<td>".concat(UtilStrings.nullToVazio(requisicaoMudanca.getDataHoraLimiteStr())).concat("</td>"));

			if (requisicaoMudanca.getAtraso() > new Double(0) && !ChangeRequestStatus.SUSPENDED.getId().equals(requisicaoMudanca.getIdStatus())) {
				sb.append("			<td class='lblRed'>".concat(UtilStrings.nullToVazio(requisicaoMudanca.getAtrasoStr())).concat("</td>"));
			} else {
				sb.append("			<td></td>");
			}

			sb.append("			<td>"
					.concat(UtilI18N.internacionaliza(request, UtilStrings.nullOuVazioToNaoDisponivel(requisicaoMudanca.getDescrStatus())))
					.concat("</td>"));
			sb.append("			<td>".concat(UtilStrings.nullToVazio(elementoFluxo.getDocumentacao())).concat("</td>"));
			sb.append("			<td>".concat(UtilStrings.nullToVazio(requisicaoMudanca.getNomeGrupoAtual())).concat("</td>"));
			sb.append("			<td>".concat(UtilStrings.nullToVazio(requisicaoMudanca.getResponsavelAtual())).concat("</td>"));

			geraAcoesTabela(request, sb, tarefa, requisicaoMudanca);
		}

		sb.append("		</tr> ");

		return sb.toString();
	}

	private void geraAcoesTabela(final HttpServletRequest request, StringBuilder sb, TarefaFluxoDTO tarefa, RequisicaoMudancaDTO requisicaoMudanca) throws Exception {
		sb.append("			<td class=\"center\" style=\"width: 200px;\"> ");
		sb.append("				<div class='span12'>");
		sb.append("					<div class='span4'>");

		// Visualizar Solicitao
		String onclickVisualizarSolicitacao = "visualizarSolicitacao(".concat(UtilNumbersAndDecimals.nullToVazio(requisicaoMudanca.getIdRequisicaoMudanca())).concat(",")
				.concat(UtilNumbersAndDecimals.nullToVazio(tarefa.getIdItemTrabalho())).concat(")");
		geraSpanButton(request, sb, "btn-action glyphicons search btn-primary mt2", "requisicaoMudanca.visualizarCadastroMudanca", onclickVisualizarSolicitacao);

		// Relatrios Especficos
		sb.append("					<span class='btn-action glyphicons charts btn-primary gm-relatorios-especificos mt2' style='cursor:pointer;' data-idespecifico='"
				.concat(UtilNumbersAndDecimals.nullToVazio(requisicaoMudanca.getIdRequisicaoMudanca())).concat("' data-title='")
				.concat(UtilI18N.internacionaliza(request, "menu.nome.relatorio"))
				.concat("' tabindex='0' data-toggle='popover' data-trigger='focus'  data-container='body' ")
				.concat("data-placement='top' data-html='true' data-content='' ")
				.concat("onclick='javascript: return false;'>").concat("<i></i></span>"));

		sb.append("					</div>");
		sb.append("					<div class='span8'>");

		geraDropdownInicio(request, sb);

		// Agendar Mudana
		String onclickAgendarMudanca = "agendaAtividade(".concat(UtilNumbersAndDecimals.nullToVazio(requisicaoMudanca.getIdRequisicaoMudanca())).concat(")");
		geraAcoesDropdown(request, sb, onclickAgendarMudanca, "gerenciamentoMudanca.agendarMudanca");
		if (!ChangeRequestStatus.SUSPENDED.getId().equals(requisicaoMudanca.getIdStatus())
				&& SimNao.SIM.getValorStr().equalsIgnoreCase(tarefa.getSuspender())) {

			String onclickPrepararSuspensao = "prepararSuspensao(".concat(UtilNumbersAndDecimals.nullToVazio(requisicaoMudanca.getIdRequisicaoMudanca())).concat(")");
			geraAcoesDropdown(request, sb, onclickPrepararSuspensao, "requisicaoMudanca.suspenderMudanca");
		} else if (ChangeRequestStatus.SUSPENDED.getId().equals(requisicaoMudanca.getIdStatus())
				&& SimNao.SIM.getValorStr().equalsIgnoreCase(tarefa.getReativar())) {

			String onclickReativarMudanca = "reativarSolicitacao(".concat(UtilNumbersAndDecimals.nullToVazio(requisicaoMudanca.getIdRequisicaoMudanca())).concat(")");
			geraAcoesDropdown(request, sb, onclickReativarMudanca, "requisicaoMudanca.reativarMudanca");
		}

		String onclickAgendaReuniao = "agendaReuniao(".concat(UtilNumbersAndDecimals.nullToVazio(requisicaoMudanca.getIdRequisicaoMudanca())).concat(")");
		geraAcoesDropdown(request, sb, onclickAgendaReuniao, "reuniao.agendaReuniao");

		UsuarioDTO usuario = WebUtil.getUsuario(request);
		String loginUsuario = UtilStrings.nullToVazio(usuario.getLogin());

		if (!ChangeRequestStatus.SUSPENDED.getId().equals(requisicaoMudanca.getIdStatus())
				&& SimNao.SIM.getValorStr().equalsIgnoreCase(tarefa.getExecutar())) {

			if (requisicaoMudanca.getResponsavelAtual() == null || !requisicaoMudanca.getResponsavelAtual().equalsIgnoreCase(loginUsuario)) {
				String onclickCapturar = "capturarTarefa(\"".concat(requisicaoMudanca.getResponsavelAtual()).concat("\",")
						.concat(UtilNumbersAndDecimals.nullToVazio(tarefa.getIdItemTrabalho())).concat(",")
						.concat(UtilNumbersAndDecimals.nullToVazio(requisicaoMudanca.getIdRequisicaoMudanca())).concat(")");

				geraAcoesDropdown(request, sb, onclickCapturar, "gerenciaservico.capturartarefa");
			}

			String onclickExecutarTarefa = "prepararExecucaoTarefa(".concat(UtilNumbersAndDecimals.nullToVazio(tarefa.getIdItemTrabalho())).concat(",")
					.concat(UtilNumbersAndDecimals.nullToVazio(requisicaoMudanca.getIdRequisicaoMudanca())).concat(",\"E\");");

			geraAcoesDropdown(request, sb, onclickExecutarTarefa, "gerenciaservico.iniciarexecutartarefa");
		}

		geraDropdownFim(sb);

		sb.append("					</div>");
		sb.append("				</div>");
		sb.append("			</td>");
	}

	private void geraSpanButton(HttpServletRequest request, StringBuilder sb, String clazz, String chaveTitulo, String onclick) {
		sb.append("<span class='".concat(clazz).concat("' title='"));
		sb.append(UtilI18N.internacionaliza(request, chaveTitulo));
		sb.append("' onclick='");
		sb.append(onclick);
		sb.append("' style='cursor:pointer;'><i></i></span>");
	}

	private void geraDropdownInicio(HttpServletRequest request, StringBuilder sb) throws Exception {
		sb.append("						<div id='acoes' class='btn-group btn-block w15 aLeft dropup span11'>");
		sb.append("							<div class='leadcontainer' data-toggle='dropdown'>");
		sb.append("								<button type='button' class='btn dropdown-lead btn-default'>" + UtilI18N.internacionaliza(request, "solicitacaoServico.acao") + "</button>");
		sb.append("							</div>");
		sb.append("							<a class='btn btn-default dropdown-toggle solicitacoes-toggle' data-toggle='dropdown'><span class='caret'></span> </a>");
		sb.append("							<ul class='dropdown-menu pull-right'>");
	}

	private void geraAcoesDropdown(HttpServletRequest request, StringBuilder sb, String onclick, String chaveTexto) throws Exception {
		sb.append("								<li onclick='".concat(onclick).concat("'><a >").concat(UtilI18N.internacionaliza(request, chaveTexto)).concat("</a></li>"));
	}

	private void geraDropdownFim(StringBuilder sb) {
		sb.append("							</ul>");
		sb.append("						</div>");
	}

	public void preparaExecucaoTarefa(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {

		if(!WebUtil.validarSeUsuarioEstaNaSessao(request, document)){
			return;
		}

		final GerenciamentoMudancasDTO gerenciamentoBean = (GerenciamentoMudancasDTO) document.getBean();
		if (gerenciamentoBean.getIdTarefa() == null) {
			document.executeScript("JANELA_AGUARDE_MENU.hide()");
			return;
		}

		final UsuarioDTO usuario = WebUtil.getUsuario(request);
		final ExecucaoMudancaService execucaoMudancaService = (ExecucaoMudancaService) ServiceLocator.getInstance().getService(ExecucaoMudancaService.class, null);
		final TarefaFluxoDTO tarefaDto = execucaoMudancaService.recuperaTarefa(usuario.getLogin(), gerenciamentoBean.getIdTarefa());
		if (tarefaDto == null || tarefaDto.getElementoFluxoDto() == null || !tarefaDto.getExecutar().equals("S") || tarefaDto.getElementoFluxoDto().getTipoInteracao() == null) {
			document.executeScript("JANELA_AGUARDE_MENU.hide()");
			return;
		}

		if (tarefaDto.getElementoFluxoDto().getTipoInteracao().equals(Enumerated.INTERACTION_VIEW)) {
			if (tarefaDto.getIdVisao() != null) {
				document.executeScript("exibirVisao('" + UtilI18N.internacionaliza(request, "gerenciaservico.iniciarexecutartarefa") + " " + tarefaDto.getElementoFluxoDto().getDocumentacao() + "','"
						+ tarefaDto.getIdVisao() + "','"
						+ tarefaDto.getElementoFluxoDto().getIdFluxo() + "','" + tarefaDto.getIdItemTrabalho() + "','" + gerenciamentoBean.getAcaoFluxo() + "');");
			} else {
				document.alert("Viso para tarefa \"" + tarefaDto.getElementoFluxoDto().getDocumentacao() + "\" no encontrada");
			}
		} else {
			String caracterParmURL = "?";
			if (tarefaDto.getElementoFluxoDto().getUrl().indexOf('?') > -1) { // Se
																				// na
																				// URL
																				// já
																				// conter
																				// ?,
																				// entao
																				// colocar
																				// &
				caracterParmURL = "&";
			}

			document.executeScript("exibirUrl('" + UtilI18N.internacionaliza(request, "gerenciaservico.iniciarexecutartarefa") + " " + tarefaDto.getElementoFluxoDto().getDocumentacao() + "','"
					+ tarefaDto.getElementoFluxoDto().getUrl()
					+ caracterParmURL
					+ "idRequisicaoMudanca=" + ((RequisicaoMudancaDTO) tarefaDto.getRequisicaoMudancaDto()).getIdRequisicaoMudanca() + "&idTarefa=" + tarefaDto.getIdItemTrabalho() + "&acaoFluxo="
					+ gerenciamentoBean.getAcaoFluxo() + "');");
		}

		document.executeScript("JANELA_AGUARDE_MENU.hide()");
	}

	public void reativaRequisicao(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert("Sesso expirada! Favor efetuar logon novamente!");
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		final GerenciamentoMudancasDTO gerenciamentoBean = (GerenciamentoMudancasDTO) document.getBean();
		if (gerenciamentoBean.getIdRequisicao() == null) {
			return;
		}

		final RequisicaoMudancaService requisicaoMudancaService = (RequisicaoMudancaService) ServiceLocator.getInstance().getService(RequisicaoMudancaService.class, null);
		final RequisicaoMudancaDTO requisicaoMudancaDto = requisicaoMudancaService.restoreAll(gerenciamentoBean.getIdRequisicao());
		requisicaoMudancaService.reativa(usuario, requisicaoMudancaDto);
		this.exibeTarefas(document, request, response);
	}

	public void capturaTarefa(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		final UsuarioDTO usuario = WebUtil.getUsuario(request);
		if (usuario == null) {
			document.alert(UtilI18N.internacionaliza(request, "citcorpore.comum.sessaoExpirada"));
			document.executeScript("window.location = '" + Constantes.getValue("SERVER_ADDRESS") + request.getContextPath() + "'");
			return;
		}

		GerenciamentoMudancasDTO requisicaoBean = (GerenciamentoMudancasDTO) document.getBean();

		if (requisicaoBean.getIdTarefa() == null) {
			return;
		}

		final RequisicaoMudancaService requisicaoMudancaService = (RequisicaoMudancaService) ServiceLocator.getInstance().getService(RequisicaoMudancaService.class, null);

		RequisicaoMudancaDTO requisicaoDto = new RequisicaoMudancaDTO();
		requisicaoDto.setIdRequisicaoMudanca(requisicaoBean.getIdRequisicao());
		requisicaoDto = (RequisicaoMudancaDTO) requisicaoMudancaService.restore(requisicaoDto);

		requisicaoDto.setIdProprietario(usuario.getIdEmpregado());
		requisicaoMudancaService.updateNotNull(requisicaoDto);

		final ExecucaoMudancaService execucaoMudancaService = (ExecucaoMudancaService) ServiceLocator.getInstance().getService(ExecucaoMudancaService.class, null);
		execucaoMudancaService.executa(usuario, requisicaoBean.getIdTarefa(), Enumerated.ACTION_START);
		this.exibeTarefas(document, request, response);
		document.executeScript("atualizarListaTarefas()");
		document.executeScript("JANELA_AGUARDE_MENU.hide()");
	}

	private BIConsultaService getBIConsultaService() throws ServiceException {
		if (biConsultaService == null) {
			biConsultaService = (BIConsultaService) ServiceLocator.getInstance().getService(BIConsultaService.class, null);
		}
		return biConsultaService;
	}

	private void loadRelatorios(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		StringBuilder sb = new StringBuilder();
		UsuarioDTO usuario = WebUtil.getUsuario(request);

		Collection<BIConsultaDTO> biConsultaListDTO = getBIConsultaService().findByTipoModuloExibicao(TipoExibicaoRelatorio.GERAL.getIdentificador(),
				ModuloExibicaoRelatorio.GERENCIAMENTO_MUDANCA.getIdentificador());

		if (biConsultaListDTO != null && !biConsultaListDTO.isEmpty()) {
			for (BIConsultaDTO biConsultaDTO : biConsultaListDTO) {
				sb.append("<a href='#' onclick='openReport(&#39;" + biConsultaDTO.getTipoConsulta() + "&#39;, " + biConsultaDTO.getIdConsulta() + ",&#39;" + biConsultaDTO.getNomeConsulta()
						+ "&#39;); return false;'>" + biConsultaDTO.getNomeConsulta() + "</a><br/>");
			}
		}

		Collection<SmartReportDTO> listSmartReport = getSmartReportService().findByIdsGrupoUsuarioAndTipoModuloExibicao(usuario.getColGrupos(), TipoExibicaoRelatorio.GERAL.getIdentificador(),
				ModuloExibicaoRelatorio.GERENCIAMENTO_MUDANCA.getIdentificador());

		if (listSmartReport != null && !listSmartReport.isEmpty()) {
			for (SmartReportDTO smartReportDTO : listSmartReport) {
				sb.append("<a href='#' onclick='UtilSmartReport.open(" + smartReportDTO.getIdSmartReport() + ", null); return false;'>" + smartReportDTO.getIdentificacao() + "</a><br/>");
			}
		}

		if (sb.length() == 0) {
			sb.append(UtilI18N.internacionaliza(request, "citcorpore.comum.resultado"));
		}

		document.executeScript("initReports(\"" + sb.toString() + "\", 'G');");
	}

	private void loadRelatoriosEspecificos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if (!WebUtil.validarSeUsuarioEstaNaSessao(request, document)) {
			return;
		}

		StringBuilder sb = new StringBuilder();
		UsuarioDTO usuario = WebUtil.getUsuario(request);

		Collection<BIConsultaDTO> biConsultaListDTO = getBIConsultaService().findByTipoModuloExibicao(TipoExibicaoRelatorio.ESPECIFICO.getIdentificador(),
				ModuloExibicaoRelatorio.GERENCIAMENTO_MUDANCA.getIdentificador());

		if (biConsultaListDTO != null && !biConsultaListDTO.isEmpty()) {
			for (BIConsultaDTO biConsultaDTO : biConsultaListDTO) {
				sb.append("<a href='#' onclick='openReport(&#39;" + biConsultaDTO.getTipoConsulta() + "&#39;, " + biConsultaDTO.getIdConsulta() + ",&#39;" + biConsultaDTO.getNomeConsulta()
						+ "&#39;, &#39;E&#39;, ${idespecifico}); return false;'>" + biConsultaDTO.getNomeConsulta() + "</a><br/>");
			}
		}

		Collection<SmartReportDTO> listSmartReport = getSmartReportService().findByIdsGrupoUsuarioAndTipoModuloExibicao(usuario.getColGrupos(), TipoExibicaoRelatorio.ESPECIFICO.getIdentificador(),
				ModuloExibicaoRelatorio.GERENCIAMENTO_MUDANCA.getIdentificador());

		if (listSmartReport != null && !listSmartReport.isEmpty()) {
			for (SmartReportDTO smartReportDTO : listSmartReport) {
				sb.append("<a href='#' onclick='UtilSmartReport.open(" + smartReportDTO.getIdSmartReport() + ", ${idespecifico}); return false;'>" + smartReportDTO.getIdentificacao() + "</a><br/>");
			}
		}

		if (sb.length() == 0) {
			sb.append(UtilI18N.internacionaliza(request, "citcorpore.comum.resultado"));
		}

		document.executeScript("initReports(\"" + sb.toString() + "\", 'E');");
	}

	private SmartReportService getSmartReportService() throws ServiceException {
		if (smartReportService == null) {
			smartReportService = (SmartReportService) ServiceLocator.getInstance().getService(SmartReportService.class, null);
		}
		return smartReportService;
	}

}