package br.com.centralit.citcorpore.ajaxForms;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.FileUtils;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citcorpore.bean.AcordoNivelServicoDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoNivelServicoDTO;
import br.com.centralit.citcorpore.bean.TempoAcordoNivelServicoDTO;
import br.com.centralit.citcorpore.negocio.AcordoNivelServicoService;
import br.com.centralit.citcorpore.negocio.TempoAcordoNivelServicoService;
import br.com.centralit.citcorpore.util.CITCorporeUtil;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;

public class GerenciamentoNivelServico extends AjaxFormAction {

	private AcordoNivelServicoService acordoNivelServicoService;
	private TempoAcordoNivelServicoService tempoAcordoNivelServicoService;

	private static HashMap<String, String> templates = new HashMap<String, String>();

	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		
		templates.put("ans", FileUtils.readFileToString(new File(CITCorporeUtil.CAMINHO_REAL_APP + "/pages/gerenciamentoNivelServico/templates/ans.html"), StandardCharsets.UTF_8.name()));
		templates.put("classe-servico", FileUtils.readFileToString(new File(CITCorporeUtil.CAMINHO_REAL_APP + "/pages/gerenciamentoNivelServico/templates/classe-servico.html"), StandardCharsets.UTF_8.name()).replaceAll("<key>ans</key>", templates.get("ans")));
		templates.put("nivel-acordo-cliente", FileUtils.readFileToString(new File(CITCorporeUtil.CAMINHO_REAL_APP + "/pages/gerenciamentoNivelServico/templates/nivel-acordo-cliente.html"), StandardCharsets.UTF_8.name()).replaceAll("<key>ans</key>", templates.get("ans")));
		templates.put("nivel-acordo-servico", FileUtils.readFileToString(new File(CITCorporeUtil.CAMINHO_REAL_APP + "/pages/gerenciamentoNivelServico/templates/nivel-acordo-servico.html"), StandardCharsets.UTF_8.name()).replaceAll("<key>ans</key>", templates.get("ans")));
		templates.put("nivel-acordo-corporativo", FileUtils.readFileToString(new File(CITCorporeUtil.CAMINHO_REAL_APP + "/pages/gerenciamentoNivelServico/templates/nivel-acordo-corporativo.html"), StandardCharsets.UTF_8.name()).replaceAll("<key>ans</key>", templates.get("ans")));

		//Quando  feito o load da pgina, tambm ser feito o load do tempo de atendimento
		GerenciamentoNivelServicoTempoAtendimento gerenciamentoNivelServicoTempoAtendimento = new GerenciamentoNivelServicoTempoAtendimento();
		gerenciamentoNivelServicoTempoAtendimento.load(document, request, response);
	}

	/**
	 * Renderiza a tela conforme o tipo de acordo escolhido.
	 * 
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.acorse && rodrigo.guilherme
	 */
	public void render(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		GerenciamentoNivelServicoDTO gerenciamentoAcordoNivelServicoDTO = (GerenciamentoNivelServicoDTO) document.getBean();

		if (gerenciamentoAcordoNivelServicoDTO.getOwner().equalsIgnoreCase("Cliente")) {
			HTMLElement tabConfiguracoes = document.getElementById("tab-cliente-ans");
			
			String template = compileTemplate(null, "cliente-", templates.get("ans"), request);
			
			tabConfiguracoes.setInnerHTML(template);
		} else if (gerenciamentoAcordoNivelServicoDTO.getOwner().equalsIgnoreCase("Multinivel")) {
			HTMLElement tabConfiguracoes = document.getElementById("ans-niveis-multi-nivel-content");

			HashMap<String, String> data = new HashMap<String, String>();
			data.put("titulo", "Corporativo");

			String template = compileTemplate(data, "multinivel-", templates.get("nivel-acordo-corporativo"), request);

			tabConfiguracoes.setInnerHTML(template);
		}

		document.executeScript(gerenciamentoAcordoNivelServicoDTO.getCallback());
	}

	/**
	 * Realiza o restore da tela conforme o acordo escolhido.
	 * 
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.acorse && rodrigo.guilherme
	 */
	public void restore(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		GerenciamentoNivelServicoDTO gerenciamentoAcordoNivelServicoDTO = (GerenciamentoNivelServicoDTO) document.getBean();

		//TODO Realizar o restore de todos os campos do acordo escolhido.

		if (gerenciamentoAcordoNivelServicoDTO.getOwner().equalsIgnoreCase("Cliente")) {
			HTMLElement tabConfiguracoes = document.getElementById("tab-cliente-ans");

			AcordoNivelServicoDTO acordoNivelServicoDTO = new AcordoNivelServicoDTO();
			
			//Exemplo 'SLA - A Combinar'
			acordoNivelServicoDTO.setIdAcordoNivelServico(38);
			acordoNivelServicoDTO = this.getAcordoNivelServicoService().restore(acordoNivelServicoDTO);

			String template = compileTemplate(null, "cliente-", templates.get("ans"), request);
			tabConfiguracoes.setInnerHTML(template);

			for (int i = 1; i <= 5; i++) {
				Collection colAux1 = this.getTempoAcordoNivelServicoService().findByIdAcordoAndFaseAndIdPrioridade(acordoNivelServicoDTO.getIdAcordoNivelServico().intValue(), 1, i);
				if (colAux1 != null && colAux1.size() > 0) {
					TempoAcordoNivelServicoDTO tempoAcordoNivelServicoDTO = (TempoAcordoNivelServicoDTO) ((List) colAux1).get(0);
					document.getElementById("cliente-HH-1-" + i).setValue(tempoAcordoNivelServicoDTO.getTempoHH().toString());
					document.getElementById("cliente-MM-1-" + i).setValue(tempoAcordoNivelServicoDTO.getTempoMM().toString());
				}
				colAux1 = this.getTempoAcordoNivelServicoService().findByIdAcordoAndFaseAndIdPrioridade(acordoNivelServicoDTO.getIdAcordoNivelServico().intValue(), 2, i);
				if (colAux1 != null && colAux1.size() > 0) {
					TempoAcordoNivelServicoDTO tempoAcordoNivelServicoDTO = (TempoAcordoNivelServicoDTO) ((List) colAux1).get(0);
					document.getElementById("cliente-HH-2-" + i).setValue(tempoAcordoNivelServicoDTO.getTempoHH().toString());
					document.getElementById("cliente-MM-2-" + i).setValue(tempoAcordoNivelServicoDTO.getTempoMM().toString());
				}
			}

			HTMLForm form = document.getForm("formClienteANS");
			form.setValues(acordoNivelServicoDTO);
		} else if (gerenciamentoAcordoNivelServicoDTO.getOwner().equalsIgnoreCase("Servico")) {
			HTMLElement tabConfiguracoes = document.getElementById("ans-classe-servico-content");

			//TODO Loop nas classes de servios existentes para adicionar na tela.

			HashMap<String, String> data = new HashMap<String, String>();
			data.put("titulo", "Teste");

			String template = compileTemplate(data, "servico-", templates.get("classe-servico"), request);

			tabConfiguracoes.appendHTML(template);
			
			//TODO Realizar set dos values.
		} else if (gerenciamentoAcordoNivelServicoDTO.getOwner().equalsIgnoreCase("Multinivel")) {
			HTMLElement tabConfiguracoes = document.getElementById("ans-niveis-multi-nivel-content");

			//TODO Loop nos niveis de acordo existentes para adicionar na tela.

			HashMap<String, String> data = new HashMap<String, String>();
			data.put("titulo", "Corporativo");

			String template = compileTemplate(data, "multinivel-", templates.get("nivel-acordo-corporativo"), request);

			tabConfiguracoes.appendHTML(template);
			
			//TODO Realizar set dos values.
		}

		document.executeScript(gerenciamentoAcordoNivelServicoDTO.getCallback());
	}

	/**
	 * Adicionar uma nova classe de servio para os acordos do tipo servio.
	 * 
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.acorse && rodrigo.guilherme
	 */
	public void adicionarClasseServico(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		GerenciamentoNivelServicoDTO gerenciamentoAcordoNivelServicoDTO = (GerenciamentoNivelServicoDTO) document.getBean();

		HTMLElement tabConfiguracoes = document.getElementById("ans-classe-servico-content");

		HashMap<String, String> data = new HashMap<String, String>();
		data.put("titulo", gerenciamentoAcordoNivelServicoDTO.getServicoNomeClasse());

		String template = compileTemplate(data, "servico-", templates.get("classe-servico"), request);

		tabConfiguracoes.appendHTML(template);

		document.executeScript(gerenciamentoAcordoNivelServicoDTO.getCallback());
	}

	/**
	 * Adiciona um novo nivel de acordo para os acordos do tipo multinivel.
	 * 
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.acorse && rodrigo.guilherme
	 */
	public void adicionarNivelAcordo(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		GerenciamentoNivelServicoDTO gerenciamentoAcordoNivelServicoDTO = (GerenciamentoNivelServicoDTO) document.getBean();

		HTMLElement tabConfiguracoes = document.getElementById("ans-niveis-multi-nivel-content");

		HashMap<String, String> data = new HashMap<String, String>();
		data.put("titulo", gerenciamentoAcordoNivelServicoDTO.getMultinivelNomeNivelAcordo());

		String template = new String();

		if (gerenciamentoAcordoNivelServicoDTO.getMultinivelTipoNivelAcordo().equalsIgnoreCase("Cliente")) {
			template = compileTemplate(data, "multinivel-cliente-", templates.get("nivel-acordo-cliente"), request);
		} else if (gerenciamentoAcordoNivelServicoDTO.getMultinivelTipoNivelAcordo().equalsIgnoreCase("Servico")) {
			template = compileTemplate(data, "multinivel-servico-", templates.get("nivel-acordo-servico"), request);
		}

		tabConfiguracoes.appendHTML(template);

		document.executeScript(gerenciamentoAcordoNivelServicoDTO.getCallback());
	}

	/**
	 * Realiza a compilao do template e o retorna pronto para a insero na
	 * tela.
	 * 
	 * @param data
	 *            HashMap com os dados que sero utilizados para substituir as
	 *            palavras chaves do template. Ex: Uma chave chamada "titulo" no
	 *            hashmap ir substituir a palavra chave #titulo#
	 * @param prefixo
	 *            Prefixo que ser utilizado nos ids, hrefs para identificao
	 *            dos templates.
	 * @param template
	 *            Template utilizado para a compilao
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 * @throws Exception
	 * @author rodrigo.acorse && rodrigo.guilherme
	 */
	public String compileTemplate(HashMap<String, String> data, String prefixo, String template, final HttpServletRequest request) throws Exception {
		if (data != null && !data.isEmpty()) {
			for (Object key : data.keySet()) {
				if (data.get(key) != null) {
					template = template.replaceAll("<key>" + key.toString() + "</key>", data.get(key));
				}
			}
		}

		//Expresso regular para buscar a chave entre '<msg>' e '</msg>'
		String regex = "<msg>(.+?)</msg>";

		Pattern pattern = Pattern.compile(regex);
		Matcher matcher = pattern.matcher(template);

		while (matcher.find()) {
			template = template.replace(matcher.group(0), UtilI18N.internacionaliza(request, "" + matcher.group(1) + ""));
		}

		template = template.replaceAll("id=\"", "id=\"" + prefixo);
		template = template.replaceAll("href=\"#", "href=\"#" + prefixo);
		template = template.replaceAll("data-reference=\"", "data-reference=\"" + prefixo);
		template = template.replaceAll("data-target=\"#", "data-target=\"#" + prefixo);

		return template;
	}

	/**
	 * Recupera a instncia do acordoNivelServicoService
	 * 
	 * @author rodrigo.guilherme
	 * @since 26.10.2015
	 */
	private AcordoNivelServicoService getAcordoNivelServicoService() throws Exception {
		if (acordoNivelServicoService == null) {
			acordoNivelServicoService = (AcordoNivelServicoService) ServiceLocator.getInstance().getService(AcordoNivelServicoService.class, null);
		}
		return acordoNivelServicoService;
	}

	/**
	 * Recupera a instncia do tempoAcordoNivelServicoService
	 * 
	 * @author rodrigo.guilherme
	 * @since 26.10.2015
	 */
	public TempoAcordoNivelServicoService getTempoAcordoNivelServicoService() throws ServiceException, Exception {
		if (tempoAcordoNivelServicoService == null) {
			tempoAcordoNivelServicoService = (TempoAcordoNivelServicoService) ServiceLocator.getInstance().getService(TempoAcordoNivelServicoService.class, null);
		}
		return tempoAcordoNivelServicoService;
	}

	@Override
	public Class<?> getBeanClass() {
		return GerenciamentoNivelServicoDTO.class;
	}

}