package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLElement;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.GerenciamentoNivelServicoTempoAtendimentoDTO;
import br.com.centralit.citcorpore.bean.ModeloEmailDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.metainfo.complementos.ComplementoSLA_Grupos;
import br.com.centralit.citcorpore.metainfo.complementos.ComplementoSLA_Prioridade;
import br.com.centralit.citcorpore.negocio.ModeloEmailService;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.service.ServiceLocator;
import br.com.citframework.util.UtilI18N;

public class GerenciamentoNivelServicoTempoAtendimento extends AjaxFormAction {

	private ComplementoSLA_Prioridade complementoSLA_Prioridade;
	private ComplementoSLA_Grupos complementoSLA_Grupos;
	private ModeloEmailService modeloEmailService;

	@Override
	public void load(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		carregaComboPrioridadeAuto(document, request, response);
		carregaComboGrupos(document, request, response);
		carregaComboEmails(document, request, response);
	}

	/**
	 * Inicia a combo passado por parmetro com a opo 'selecione'
	 * 
	 * @author rodrigo.dorighello
	 * @since 29.10.2015
	 */
	private void iniciaCombo(DocumentHTML document, HttpServletRequest request, HTMLSelect combo) throws Exception {
		combo.removeAllOptions();
		combo.addOption("", UtilI18N.internacionaliza(request, "citcorpore.comum.selecione"));
	}

	/**
	 * Preenche a combo de prioridade de ao
	 * 
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 29.10.2015
	 */
	private void carregaComboPrioridadeAuto(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		String resp = this.getComplementoSLA_Prioridade().execute(null, request, response);

		HTMLSelect combo = document.getSelectById("idPrioridadeAuto1");
		iniciaCombo(document, request, combo);

		if (resp != null) {
			combo.setInnerHTML(resp);
		}
	}

	/**
	 * Preenche a combo de grupos
	 * 
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 29.10.2015
	 */
	private void carregaComboGrupos(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		String resp = this.getComplementoSLA_Grupos().execute(null, request, response);

		HTMLSelect combo = document.getSelectById("idGrupo1");
		iniciaCombo(document, request, combo);

		if (resp != null) {
			combo.setInnerHTML(resp);
		}
	}

	/**
	 * Preenche a combo de e-mails
	 * 
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 29.10.2015
	 */
	private void carregaComboEmails(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {

		HTMLSelect combo = document.getSelectById("idEmail");
		iniciaCombo(document, request, combo);

		Collection<ModeloEmailDTO> listModeloEmailDto = this.getModeloEmailService().getAtivos();

		if (listModeloEmailDto != null) {
			for (ModeloEmailDTO modeloEmailDTO : listModeloEmailDto) {
				combo.addOption(String.valueOf(modeloEmailDTO.getIdModeloEmail()), modeloEmailDTO.getTitulo());
			}
		}
	}

	/**
	 * Realiza a resturao dos dados do tempo de atendimento
	 * 
	 * @author rodrigo.guilherme
	 * @since 29.10.2015
	 */
	public void restore(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws Exception {
		GerenciamentoNivelServicoTempoAtendimentoDTO tempoAtendimentoDTO = (GerenciamentoNivelServicoTempoAtendimentoDTO) document.getBean();

		tempoAtendimentoDTO = restoreFake(tempoAtendimentoDTO);

		String htmlListaServicos = geraHtmlTabelaServicos(tempoAtendimentoDTO.getListaServicos(), request);

		HTMLElement divListaServicos = document.getElementById("modal-tempo-atendimento-lista-servicos");
		divListaServicos.setInnerHTML(htmlListaServicos);

		HTMLForm form = document.getForm("formModalTempoAtendimento");
		form.setValues(tempoAtendimentoDTO);
	}

	/**
	 * Temporrio para testes
	 * 
	 * @author rodrigo.guilherme
	 * @since 29.10.2015
	 */
	private GerenciamentoNivelServicoTempoAtendimentoDTO restoreFake(GerenciamentoNivelServicoTempoAtendimentoDTO entity) throws Exception {
		ArrayList<ServicoDTO> listaServicos = new ArrayList<ServicoDTO>();

		for (int i = 0; i < 20; i++) {
			ServicoDTO servicoDto = new ServicoDTO();
			
			servicoDto.setIdServico(i);
			
			if (i < 10)
				servicoDto.setNomeServico("Servio de Requisio " + i);
			else
				servicoDto.setNomeServico("Incidente "+i);

			listaServicos.add(servicoDto);

		}

		String listaServicosSerializados = "";

		if (listaServicos != null && listaServicos.size() > 0) {
			listaServicosSerializados = br.com.citframework.util.WebUtil.serializeObjects(listaServicos);
		}
		
		entity = new GerenciamentoNivelServicoTempoAtendimentoDTO();

		entity.setListaServicos(listaServicosSerializados);
		
		entity.setTaHoraP1F1(1);
		entity.setTaMinutoP1F1(2);
		entity.setTaHoraP1F2(3);
		entity.setTaMinutoP1F2(4);

		entity.setTaHoraP2F1(5);
		entity.setTaMinutoP2F1(6);
		entity.setTaHoraP2F2(7);
		entity.setTaMinutoP2F2(8);

		entity.setTaHoraP3F1(9);
		entity.setTaMinutoP3F1(10);
		entity.setTaHoraP3F2(11);
		entity.setTaMinutoP3F2(12);

		entity.setTaHoraP4F1(13);
		entity.setTaMinutoP4F1(14);
		entity.setTaHoraP4F2(15);
		entity.setTaMinutoP4F2(16);

		entity.setTaHoraP5F1(17);
		entity.setTaMinutoP5F1(18);
		entity.setTaHoraP5F2(19);
		entity.setTaMinutoP5F2(20);

		return entity;
	}

	/**
	 * Persiste no banco, os dados do tempo de atendimento
	 * 
	 * @param document
	 * @param request
	 * @param response
	 * @throws Exception
	 * @author rodrigo.guilherme
	 * @since 29.10.2015
	 */
	public void save(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		//GerenciamentoNivelServicoTempoAtendimentoDTO tempoAtendimentoDTO = (GerenciamentoNivelServicoTempoAtendimentoDTO) document.getBean();
	}

	/**
	 * Gera o html de toda a tabela de servios de requisio e incidente
	 * 
	 * @author rodrigo.guilherme
	 * @since 29.10.2015
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	private String geraHtmlTabelaServicos(String listaServicosSerializada, HttpServletRequest request) throws Exception {
		StringBuilder sb = new StringBuilder();

		try {
			ArrayList<ServicoDTO> listaServicos = (ArrayList) br.com.citframework.util.WebUtil.deserializeCollectionFromString(ServicoDTO.class, listaServicosSerializada);

			if (listaServicos != null) {

				sb.append(geraHtmlTabelaCabecalho(request));

				for (int i = 0; i < listaServicos.size(); i++) {
					sb.append(geraHtmlTabelaDados(listaServicos.get(i).getIdServico(), listaServicos.get(i).getNomeServico()));
				}

				sb.append(geraHTMLTabelaFinal());

			}
		} catch (Exception e) {
			e.printStackTrace();
		}

		return sb.toString();
	}

	/**
	 * Gera o html do cabealho da tabela de servios de requisio e incidente
	 * 
	 * @author rodrigo.guilherme
	 * @since 29.10.2015
	 */
	private String geraHtmlTabelaCabecalho(HttpServletRequest request) {
		StringBuilder sb = new StringBuilder();

		sb.append("		<table class=\"table table-bordered table-condensed table-striped table-primary table-vertical-center\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");

		//Internacionalizar

		sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "ID") + "</th> ");
		sb.append("					<th>" + UtilI18N.internacionaliza(request, "Nome do Servio") + "</th> ");
		sb.append("					<th class=\"center\"  style=\"width: 30px;\" >" + UtilI18N.internacionaliza(request, "Aes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody> ");

		return sb.toString();
	}

	/**
	 * Gera o html do contedo da tabela de servios de requisio e incidente
	 * 
	 * @author rodrigo.guilherme
	 * @since 29.10.2015
	 */
	private String geraHtmlTabelaDados(Integer idServico, String nomeServico) {
		StringBuilder sb = new StringBuilder();

		sb.append("		<tr>");
		sb.append("			<td class=\"center\">" + idServico + "</td> ");
		sb.append("			<td class=\"important\">" + nomeServico + "</td> ");
		sb.append("			<td class=\"center\"> ");
		sb.append("				<a onclick=\"TempoAtendimento.ListaServicos.remover(this);\" class=\"btn btn-action glyphicons remove_2 btn-danger\"><i></i></a>");
		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}

	/**
	 * Gera o html para o fim da tabela de servios de requisio e incidente
	 * 
	 * @author rodrigo.guilherme
	 * @since 29.10.2015
	 */
	private String geraHTMLTabelaFinal() {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");

		return sb.toString();
	}

	public ComplementoSLA_Prioridade getComplementoSLA_Prioridade() {
		if (complementoSLA_Prioridade == null) {
			complementoSLA_Prioridade = new ComplementoSLA_Prioridade();
		}

		return complementoSLA_Prioridade;
	}

	public ComplementoSLA_Grupos getComplementoSLA_Grupos() {
		if (complementoSLA_Grupos == null) {
			complementoSLA_Grupos = new ComplementoSLA_Grupos();
		}

		return complementoSLA_Grupos;
	}

	private ModeloEmailService getModeloEmailService() throws ServiceException {
		if (modeloEmailService == null) {
			modeloEmailService = (ModeloEmailService) ServiceLocator.getInstance().getService(ModeloEmailService.class, null);
		}
		return modeloEmailService;
	}

	@Override
	public Class<?> getBeanClass() {
		return GerenciamentoNivelServicoTempoAtendimentoDTO.class;
	}

}