package br.com.centralit.citcorpore.ajaxForms;

import java.util.ArrayList;
import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.google.gson.Gson;

import br.com.centralit.citajax.html.AjaxFormAction;
import br.com.centralit.citajax.html.DocumentHTML;
import br.com.centralit.citajax.html.HTMLForm;
import br.com.centralit.citajax.html.HTMLSelect;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioCadastroServicoNegocioDTO;
import br.com.centralit.citcorpore.bean.GerenciamentoPortfolioDTO;
import br.com.centralit.citcorpore.bean.ServicoDTO;
import br.com.centralit.citcorpore.bean.UploadDTO;
import br.com.centralit.citcorpore.util.Enumerados.BusinessUserTipo;
import br.com.centralit.citcorpore.util.Enumerados.CategoriaPortfolio;
import br.com.centralit.citcorpore.util.Enumerados.CriticidadeServico;
import br.com.centralit.citcorpore.util.Enumerados.DonoNegocioTipo;
import br.com.centralit.citcorpore.util.Enumerados.FaseServico;
import br.com.centralit.citcorpore.util.Enumerados.StatusServico;
import br.com.centralit.citcorpore.util.Enumerados.TipoServico;
import br.com.centralit.citcorpore.util.Util;
import br.com.centralit.citcorpore.util.UtilImagem;
import br.com.centralit.citcorpore.util.WebUtil;
import br.com.citframework.excecao.ServiceException;
import br.com.citframework.util.UtilHTML;
import br.com.citframework.util.UtilI18N;
import br.com.citframework.util.UtilStrings;

public class GerenciamentoPortfolio extends AjaxFormAction {

	@Override
	public void load(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		carregarComboOrdenarPor(document, request);
		carregarComboTipoOrdenacao(document, request);
	}

	private void carregarComboOrdenarPor(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect comboOrdenarPor = document.getSelectById("comboOrdenarPor");
		comboOrdenarPor.removeAllOptions();

		comboOrdenarPor.addOption("nomeServico", UtilI18N.internacionaliza(request, "gerenciaportfolio.nomeServicoNegocio"));
		comboOrdenarPor.addOption("criticidadeServico", UtilI18N.internacionaliza(request, "gerenciaportfolio.servicoNegocio.criticidadeServico"));
	}

	private void carregarComboTipoOrdenacao(DocumentHTML document, HttpServletRequest request) throws Exception {
		HTMLSelect comboAscDesc = document.getSelectById("comboAscDesc");
		comboAscDesc.removeAllOptions();

		comboAscDesc.addOption("asc", UtilI18N.internacionaliza(request, "citcorpore.comum.asc"));
		comboAscDesc.addOption("desc", UtilI18N.internacionaliza(request, "citcorpore.comum.desc"));
	}

	public void avancarPortfolio(final DocumentHTML document, final HttpServletRequest request, final HttpServletResponse response) throws ServiceException, Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		GerenciamentoPortfolioDTO gerenciamentoPortfolioDTO = (GerenciamentoPortfolioDTO) document.getBean();

		GerenciamentoPortfolioCadastroServicoNegocio gerenciamentoPortfolioCadastroServicoNegocio = new GerenciamentoPortfolioCadastroServicoNegocio();
		GerenciamentoPortfolioCadastroServicoNegocioDTO servicoNegocioDto = new GerenciamentoPortfolioCadastroServicoNegocioDTO();

		servicoNegocioDto.setIdPortfolioServico(gerenciamentoPortfolioDTO.getIdPortfolioServicoAtual());
		servicoNegocioDto.setCategoriaPortfolio(CategoriaPortfolio.FUNIL_SERVICOS.getIdentificador());

		HTMLForm form = document.getForm("formCadastroServicoNegocio");
		form.setValues(servicoNegocioDto);

		gerenciamentoPortfolioCadastroServicoNegocio.load(document, request, response);
		gerenciamentoPortfolioCadastroServicoNegocio.definirContadorProcessoDeIniciacao(document, new ArrayList<UploadDTO>());
		gerenciamentoPortfolioCadastroServicoNegocio.montaHTMLServicosNegocio(servicoNegocioDto, document, request);
	}

	/**
	 * Mtodo geral que constri a tabela de servios, de acordo com o tipo do
	 * servio
	 *
	 * @author rodrigo.dorighello
	 * @since 16.09.2015
	 */
	public static String geraHTMLServicosNegocioApoio(final DocumentHTML document, final HttpServletRequest request, Collection<ServicoDTO> listServicos, String tipoServico) {
		StringBuilder sb = new StringBuilder();

		sb.append(geraHtmlCabecalhoTabelaNegocioApoio(request, tipoServico));
		for (ServicoDTO servico : listServicos) {
			sb.append(geraHtmlDadosTabelaNegocioApoio(document, request, tipoServico, servico));
		}
		sb.append(geraHTMLFinalTabela(tipoServico));

		return sb.toString();
	}

	/**
	 * Mtodo geral que constri a tabela de servios, de acordo com o tipo do
	 * servio
	 *
	 * @author douglas.japiassu
	 * @since 06.10.2015
	 */
	public static String geraHTMLServicosRequisicaoIncidente(final DocumentHTML document, final HttpServletRequest request, Collection<ServicoDTO> listServicos, String tipoServico) {
		StringBuilder sb = new StringBuilder();

		sb.append(geraCabecalhoTabelaServicoRequisicaoIncidente(request, tipoServico));
		for (ServicoDTO servico : listServicos) {
			sb.append(geraDadosTabelaServicoRequisicaoIncidente(document, request, tipoServico, servico));
		}
		sb.append(geraFinalTabelaServicoRequisicaoIncidente(tipoServico));

		return sb.toString();
	}

	/**
	 * Gera o html do cabealho da tabela de servios, conforme seu tipo
	 * (negcio ou apoio)
	 *
	 * @author rodrigo.dorighello
	 * @since 16.09.2015
	 */
	private static String geraHtmlCabecalhoTabelaNegocioApoio(final HttpServletRequest request, String tipoServico) {
		StringBuilder sb = new StringBuilder();

		sb.append("<div class='row-fluid'> ");
		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed table-vertical-center checkboxs js-table-sortable ui-sortable\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");

		if (isServicoNegocio(tipoServico)) {
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nomeServicoNegocio") + "</th> ");
			sb.append("					<th class=\"center criticidadeServico\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.servicoNegocio.criticidadeServico") + "</th> ");
		} else if (isServicoApoio(tipoServico)) {
			sb.append("					<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nomeServicoApoio") + "</th> ");
		}

		sb.append("					<th class=\"center faseServico\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.fase") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.statusServico") + "</th> ");
		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.acoes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody> ");

		return sb.toString();
	}

	/**
	 * Gera o html do cabealho da tabela de servios, conforme seu tipo
	 * (negcio ou apoio)
	 *
	 * @author douglas.japiassu
	 * @since 08.10.2015
	 */
	private static String geraCabecalhoTabelaServicoRequisicaoIncidente(final HttpServletRequest request, String tipoServico) {
		StringBuilder sb = new StringBuilder();

		sb.append("<div class='row-fluid'> ");
		sb.append("	<div class=\"table-responsive tabela\">");
		sb.append("		<table class=\"table table-bordered table-striped table-condensed table-vertical-center checkboxs js-table-sortable ui-sortable\"> ");
		sb.append("			<thead> ");
		sb.append("				<tr> ");
		sb.append("					<th style=\"width: 1%;\" class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.id") + "</th> ");

		if (isServicoRequisicao(tipoServico)) {
			sb.append("				<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nomeServicoRequisicao") + "</th> ");
		} else if (isServicoIncidente(tipoServico)) {
			sb.append("				<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nomeServicoIncidente") + "</th> ");
		} else if (isServicoProcedimento(tipoServico)) {
			sb.append("				<th>" + UtilI18N.internacionaliza(request, "gerenciaportfolio.nomeServicoProcedimento") + "</th> ");
		}

		sb.append("					<th class=\"center\">" + UtilI18N.internacionaliza(request, "gerenciaportfolio.acoes") + "</th> ");
		sb.append("				</tr> ");
		sb.append("			</thead> ");
		sb.append("			<tbody> ");

		return sb.toString();
	}

	/**
	 * Gera os dados da tabela de servios, conforme seu tipo (negcio, apoio ou
	 * requisio)
	 *
	 * @author rodrigo.dorighello
	 * @since 16.09.2015
	 */
	private static String geraHtmlDadosTabelaNegocioApoio(final DocumentHTML document, final HttpServletRequest request, String tipoServico, ServicoDTO servico) {
		StringBuilder sb = new StringBuilder();
		String onClickServico = "";
		String onClickEditarServico = "";
		String onClickDesvincularServico = "";
		String onMouseOverAvancarServico = "";
		String onMouseOverEditarServico = "";
		String onMouseOverDesvincularServico = "";

		if (isServicoNegocio(tipoServico)) {
			onClickServico = "avancarServicoNegocio";
			onClickEditarServico = "editarServicoNegocio";

			onMouseOverAvancarServico = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "gerenciaportfolio.avancarServicoNegocio") + "')\" onmouseout=\"fechaTooltip()\"";
			onMouseOverEditarServico = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "gerenciaportfolio.editarServicoNegocio") + "')\" onmouseout=\"fechaTooltip()\"";
		} else if (isServicoApoio(tipoServico)) {
			onClickServico = "avancarServicoApoio";
			onClickEditarServico = "editarServicoApoio";
			onClickDesvincularServico = "desvincularServicoApoio";

			onMouseOverAvancarServico = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "gerenciaportfolio.avancarServicoApoio") + "')\" onmouseout=\"fechaTooltip()\"";
			onMouseOverEditarServico = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "gerenciaportfolio.editarServicoApoio") + "')\" onmouseout=\"fechaTooltip()\"";
			onMouseOverDesvincularServico = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "gerenciaportfolio.desvincularServicoApoio")
					+ "')\" onmouseout=\"fechaTooltip()\"";
		}

		sb.append("		<tr>");
		sb.append("			<td class=\"center\">" + servico.getIdServico() + "</td> ");
		sb.append("			<td>" + UtilHTML.encodeHTML(servico.getNomeServico()) + "</td> ");

		if (isServicoNegocio(tipoServico)) {
			if (!Util.isNullOrEmpty(servico.getCriticidadeServico())) {
				CriticidadeServico criticidadeServico = CriticidadeServico.fromItem(servico.getCriticidadeServico());
				sb.append("			<td class=\"center criticidadeServico\" style=\"width: 80px;\">");
				sb.append("				<span class=\"label label-block\" style=\"background-color: " + criticidadeServico.getCor() + "\">");
				sb.append(UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, criticidadeServico.getChave())));
				sb.append("				</span>");
				sb.append("			</td>");
			} else {
				sb.append("			<td class=\"center\" style=\"width: 80px;\">");
				sb.append("				<span class=\"label label-block label-warning\">");
				sb.append(UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "citcorpore.comum.naoDefinida")));
				sb.append("				</span>");
				sb.append("			</td>");
			}
		}

		if (UtilStrings.isNotVazio(servico.getFaseServico())) {
			FaseServico faseServico = FaseServico.fromTipo(servico.getFaseServico());
			sb.append("			<td class=\"center faseServico\" style=\"width: 80px;\">");
			sb.append("				<span class=\"label label-block\" style=\"background-color: " + faseServico.getCor() + "\">");
			sb.append(UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, faseServico.getChave())));
			sb.append("				</span>");
			sb.append("			</td>");
		} else {
			sb.append("			<td class=\"center\" style=\"width: 80px;\">");
			sb.append("				<span class=\"label label-block label-warning\">");
			sb.append(UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, "gerenciaportfolio.semFase")));
			sb.append("				</span>");
			sb.append("			</td>");
		}

		if (UtilStrings.isNotVazio(servico.getStatusServico())) {
			StatusServico statusServico = StatusServico.fromTipo(servico.getStatusServico());
			sb.append("			<td class=\"center\" style=\"width: 120px;\">");
			sb.append("				<span class=\"label label-block\" style=\"background-color: " + statusServico.getCor() + "\">");
			sb.append(UtilHTML.encodeHTML(UtilI18N.internacionaliza(request, statusServico.getChave())));
			sb.append("				</span>");
			sb.append("			</td> ");
		}

		sb.append("			<td class=\"center\" style=\"width: 90px;\"> ");

		sb.append("				<a onclick=\"" + onClickServico + "(this, " + servico.getIdServico() + ", '" + servico.getNomeServico() + "');\" " + onMouseOverAvancarServico
				+ "  class=\"btn-action glyphicons right_arrow btn-default\"><i></i></a> ");
			sb.append("				<a onclick=\"" + onClickEditarServico + "(this, " + servico.getIdServico() + ");\" " + onMouseOverEditarServico
				+ " class=\"btn-action glyphicons pencil btn-success\"><i></i></a> ");
		if (isServicoApoio(tipoServico)) {
			sb.append("				<a onclick=\"" + onClickDesvincularServico + "(this, " + servico.getIdServico() + ");\" " + onMouseOverDesvincularServico
					+ " class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a> ");
		}

		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}

	private static String geraDadosTabelaServicoRequisicaoIncidente(final DocumentHTML document, final HttpServletRequest request, String tipoServico, ServicoDTO servico) {
		StringBuilder sb = new StringBuilder();
		String onClickEditarServico = "";
		String onClickDesvincularServico = "";
		String onMouseOverEditar = "";
		String onMouseOverDesvincular = "";

		if (isServicoRequisicao(tipoServico)) {
			onClickEditarServico = "editarServicoNegocioRequisicao";
			onClickDesvincularServico = "desvincularServicoRequisicao";

			onMouseOverEditar = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "gerenciaportfolio.editarRequisicaoServico") + "')\" onmouseout=\"fechaTooltip()\"";
			onMouseOverDesvincular = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "gerenciaportfolio.desvincularRequisicaoServico") + "')\" onmouseout=\"fechaTooltip()\"";
		} else if (isServicoIncidente(tipoServico)) {
			onClickEditarServico = "editarServicoNegocioIncidente";
			onClickDesvincularServico = "desvincularServicoIncidente";

			onMouseOverEditar = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "gerenciaportfolio.editarIncidente") + "')\" onmouseout=\"fechaTooltip()\"";
			onMouseOverDesvincular = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "gerenciaportfolio.desvincularIncidente") + "')\" onmouseout=\"fechaTooltip()\"";
		} else if (isServicoProcedimento(tipoServico)) {
			onClickEditarServico = "editarServicoProcedimento";
			onClickDesvincularServico = "desvincularServicoProcedimento";

			onMouseOverEditar = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "gerenciaportfolio.editarProcedimento") + "')\" onmouseout=\"fechaTooltip()\"";
			onMouseOverDesvincular = "onmouseover=\"abreTooltip(this, '" + UtilI18N.internacionaliza(request, "gerenciaportfolio.desvincularIncidente") + "')\" onmouseout=\"fechaTooltip()\"";
		}

		sb.append("		<tr>");
		sb.append("			<td class=\"center\">" + servico.getIdServico() + "</td> ");
		sb.append("			<td>" + UtilHTML.encodeHTML(servico.getNomeServico()) + "</td> ");
		sb.append("			<td class=\"center\" style=\"width: 60px;\"> ");
			sb.append("				<a onclick=\"" + onClickEditarServico + "(this, " + servico.getIdServico() + ");\" " + onMouseOverEditar + " class=\"btn-action glyphicons pencil btn-success\"><i></i></a> ");
			sb.append("				<a onclick=\"" + onClickDesvincularServico + "(this, " + servico.getIdServico() + ");\" " + onMouseOverDesvincular
				+ " class=\"btn-action glyphicons remove_2 btn-default\"><i></i></a> ");
		sb.append("			</td> ");
		sb.append("		</tr> ");

		return sb.toString();
	}

	/**
	 * Gera o html do fim da tabela de servios, conforme seu tipo (negcio,
	 * apoio ou requisio)
	 *
	 * @author rodrigo.dorighello
	 * @since 16.09.2015
	 */
	private static String geraHTMLFinalTabela(String tipoServico) {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");
		sb.append("</div>");
		sb.append("<div class='row-fluid'> ");

		if (isServicoNegocio(tipoServico)) {
			sb.append("	<div id=\"paginacaoServicosNegocio\" class=\"divPaginacao\"></div>");
		} else if (isServicoApoio(tipoServico)) {
			sb.append("	<div id=\"paginacaoServicosApoio\" class=\"divPaginacao\"></div>");
		}

		sb.append("</div>");

		return sb.toString();
	}

	/**
	 * Gera o html do fim da tabela de servios, conforme seu tipo (negcio,
	 * apoio ou requisio)
	 *
	 * @author douglas.japiassu
	 * @since 08.10.2015
	 */
	private static String geraFinalTabelaServicoRequisicaoIncidente(String tipoServico) {
		StringBuilder sb = new StringBuilder();
		sb.append("			</tbody> ");
		sb.append("		</table>");
		sb.append("	</div>");
		sb.append("</div>");
		sb.append("<div class='row-fluid'> ");

		if (isServicoRequisicao(tipoServico)) {
			sb.append("	<div id=\"paginacaoServicosRequisicao\" class=\"divPaginacao\"></div>");
		} else if (isServicoIncidente(tipoServico)) {
			sb.append("	<div id=\"paginacaoServicosIncidente\" class=\"divPaginacao\"></div>");
		} else if (isServicoProcedimento(tipoServico)) {
			sb.append("	<div id=\"paginacaoServicosProcedimento\" class=\"divPaginacao\"></div>");
		}

		sb.append("</div>");

		return sb.toString();
	}

	/**
	 * @param tipoServico
	 * @return true se o servio for do tipo Negcio
	 * @author douglas.japiassu
	 */
	private static boolean isServicoNegocio(String tipoServico) {
		return TipoServico.SERVICO_NEGOCIO.getIdentificador().equalsIgnoreCase(tipoServico);
	}

	/**
	 * @param tipoServico
	 * @return true se o servio for do tipo Apoio
	 * @author douglas.japiassu
	 */
	private static boolean isServicoApoio(String tipoServico) {
		return TipoServico.SERVICO_APOIO.getIdentificador().equalsIgnoreCase(tipoServico);
	}

	/**
	 * @param tipoServico
	 * @return true se o servio for do tipo Requisio
	 * @author douglas.japiassu
	 */
	private static boolean isServicoRequisicao(String tipoServico) {
		return TipoServico.SERVICO_REQUISICAO.getIdentificador().equalsIgnoreCase(tipoServico);
	}

	/**
	 * @param tipoServico
	 * @return true se o servio for do tipo Incidente
	 * @author douglas.japiassu
	 */
	private static boolean isServicoIncidente(String tipoServico) {
		return TipoServico.SERVICO_INCIDENTE.getIdentificador().equalsIgnoreCase(tipoServico);
	}

	/**
	 * @param tipoServico
	 * @return true se o servio for do tipo Incidente
	 * @author douglas.japiassu
	 */
	private static boolean isServicoProcedimento(String tipoServico) {
		return TipoServico.SERVICO_PROCEDIMENTO.getIdentificador().equalsIgnoreCase(tipoServico);
	}

	/**
	 * Mtodo para vincular vrios servios de apoio ao servio de negcio a partir
	 * da lookup com checkbox
	 *
	 * @author douglas.japiassu
	 * @since 07.10.2015
	 */
	public void adicionaTabelaLOOKUP_SERVICO_VINCULAR_APOIO(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		GerenciamentoPortfolioDTO gerenciamentoPortfolioDto = (GerenciamentoPortfolioDTO) document.getBean();

		if (gerenciamentoPortfolioDto != null && gerenciamentoPortfolioDto.getIdServicoNegocioAtual() != null && gerenciamentoPortfolioDto.getColAllLOOKUP_SERVICO_VINCULAR_APOIO() != null) {
			GerenciamentoPortfolioCadastroServicoApoio servicoApoio = new GerenciamentoPortfolioCadastroServicoApoio();

			Integer idServicoNegocio = gerenciamentoPortfolioDto.getIdServicoNegocioAtual();
			Integer idPortfolioServico = gerenciamentoPortfolioDto.getIdPortfolioServicoAtual();

			String listaServicosStr = gerenciamentoPortfolioDto.getColAllLOOKUP_SERVICO_VINCULAR_APOIO();

				servicoApoio.vincularServicos(idPortfolioServico, idServicoNegocio, listaServicosStr, document, request, response);
				document.executeScript("depoisVincularServicos();");
			}
		}

	/**
	 * Mtodo para vincular vrios servios de requisio ao servio de negcio a partir
	 * da lookup com checkbox
	 *
	 * @author douglas.japiassu
	 * @since 07.10.2015
	 */
	public void adicionaTabelaLOOKUP_SERVICO_VINCULAR_REQUISICAO_NEGOCIO(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		GerenciamentoPortfolioDTO gerenciamentoPortfolioDto = (GerenciamentoPortfolioDTO) document.getBean();

		if (gerenciamentoPortfolioDto != null && gerenciamentoPortfolioDto.getIdServicoNegocioAtual() != null
				&& gerenciamentoPortfolioDto.getColAllLOOKUP_SERVICO_VINCULAR_REQUISICAO_NEGOCIO() != null) {
			GerenciamentoPortfolioCadastroServico servicoRequisicao = new GerenciamentoPortfolioCadastroServico();

			Integer idServicoNegocio = gerenciamentoPortfolioDto.getIdServicoNegocioAtual();
			Integer idPortfolioServico = gerenciamentoPortfolioDto.getIdPortfolioServicoAtual();

			String listaServicosStr = gerenciamentoPortfolioDto.getColAllLOOKUP_SERVICO_VINCULAR_REQUISICAO_NEGOCIO();

				servicoRequisicao.vincularServicos(TipoServico.SERVICO_REQUISICAO.getIdentificador(), idPortfolioServico, idServicoNegocio, listaServicosStr, document, request, response);
				document.executeScript("depoisVincularServicoNegocioRequisicao();");
			}
		}

	/**
	 * Mtodo para vincular vrios servios de incidente ao servio de negcio a partir
	 * da lookup com checkbox
	 *
	 * @author douglas.japiassu
	 * @since 07.10.2015
	 */
	public void adicionaTabelaLOOKUP_SERVICO_VINCULAR_INCIDENTE_NEGOCIO(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		GerenciamentoPortfolioDTO gerenciamentoPortfolioDto = (GerenciamentoPortfolioDTO) document.getBean();

		if (gerenciamentoPortfolioDto != null && gerenciamentoPortfolioDto.getIdServicoNegocioAtual() != null && gerenciamentoPortfolioDto.getColAllLOOKUP_SERVICO_VINCULAR_INCIDENTE_NEGOCIO() != null) {
			GerenciamentoPortfolioCadastroServico servicoIncidente = new GerenciamentoPortfolioCadastroServico();

			Integer idServicoNegocio = gerenciamentoPortfolioDto.getIdServicoNegocioAtual();
			Integer idPortfolioServico = gerenciamentoPortfolioDto.getIdPortfolioServicoAtual();

			String listaServicosStr = gerenciamentoPortfolioDto.getColAllLOOKUP_SERVICO_VINCULAR_INCIDENTE_NEGOCIO();

				servicoIncidente.vincularServicos(TipoServico.SERVICO_INCIDENTE.getIdentificador(), idPortfolioServico, idServicoNegocio, listaServicosStr, document, request, response);
				document.executeScript("depoisVincularServicoNegocioIncidente();");
			}
		}

	/**
	 * Mtodo para vincular vrios servios de requisio ao servio de negcio a partir
	 * da lookup com checkbox
	 *
	 * @author douglas.japiassu
	 * @since 30.10.2015
	 */
	public void adicionaTabelaLOOKUP_SERVICO_VINCULAR_REQUISICAO_APOIO(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		GerenciamentoPortfolioDTO gerenciamentoPortfolioDto = (GerenciamentoPortfolioDTO) document.getBean();

		if (gerenciamentoPortfolioDto != null && gerenciamentoPortfolioDto.getIdServicoNegocioAtual() != null && gerenciamentoPortfolioDto.getColAllLOOKUP_SERVICO_VINCULAR_REQUISICAO_APOIO() != null) {
			GerenciamentoPortfolioCadastroServico servicoRequisicao = new GerenciamentoPortfolioCadastroServico();

			Integer idServicoApoio = gerenciamentoPortfolioDto.getIdServicoNegocioAtual();
			Integer idPortfolioServico = gerenciamentoPortfolioDto.getIdPortfolioServicoAtual();

			String listaServicosStr = gerenciamentoPortfolioDto.getColAllLOOKUP_SERVICO_VINCULAR_REQUISICAO_APOIO();

				servicoRequisicao.vincularServicos(TipoServico.SERVICO_REQUISICAO.getIdentificador(), idPortfolioServico, idServicoApoio, listaServicosStr, document, request, response);
				document.executeScript("depoisVincularServicoRequisicaoApoio();");
			}
		}

	/**
	 * Mtodo para vincular vrios servios de incidente ao servio de negcio a partir
	 * da lookup com checkbox
	 *
	 * @author douglas.japiassu
	 * @since 30.10.2015
	 */
	public void adicionaTabelaLOOKUP_SERVICO_VINCULAR_INCIDENTE_APOIO(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		GerenciamentoPortfolioDTO gerenciamentoPortfolioDto = (GerenciamentoPortfolioDTO) document.getBean();

		if (gerenciamentoPortfolioDto != null && gerenciamentoPortfolioDto.getIdServicoNegocioAtual() != null && gerenciamentoPortfolioDto.getColAllLOOKUP_SERVICO_VINCULAR_INCIDENTE_APOIO() != null) {
			GerenciamentoPortfolioCadastroServico servicoIncidente = new GerenciamentoPortfolioCadastroServico();

			Integer idServicoApoio = gerenciamentoPortfolioDto.getIdServicoNegocioAtual();
			Integer idPortfolioServico = gerenciamentoPortfolioDto.getIdPortfolioServicoAtual();

			String listaServicosStr = gerenciamentoPortfolioDto.getColAllLOOKUP_SERVICO_VINCULAR_INCIDENTE_APOIO();

				servicoIncidente.vincularServicos(TipoServico.SERVICO_INCIDENTE.getIdentificador(), idPortfolioServico, idServicoApoio, listaServicosStr, document, request, response);
				document.executeScript("depoisVincularServicoIncidenteApoio();");
			}
		}

	/**
	 * Mtodo para obter todos os grupos de usurios checados
	 *
	 * @author pedro.francisco
	 * @since 14.01.2016
	 */
	public void adicionaTabelaLOOKUP_SERVICO_BUSINESS_USER_VINCULAR_GRUPO(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		GerenciamentoPortfolioDTO gerenciamentoPortfolioDto = (GerenciamentoPortfolioDTO) document.getBean();

		if (gerenciamentoPortfolioDto != null && gerenciamentoPortfolioDto.getIdServicoNegocioAtual() != null) {
			GerenciamentoPortfolioBusinessUser gerenciamentoPortfolioBusinessUser = new GerenciamentoPortfolioBusinessUser();

			String checkboxChecadosComoTrue = gerenciamentoPortfolioDto.getColAllLOOKUP_SERVICO_BUSINESS_USER_VINCULAR_GRUPO();

			if (!checkboxChecadosComoTrue.isEmpty()) {
				gerenciamentoPortfolioBusinessUser.salvarItensChecados(document, request, checkboxChecadosComoTrue, gerenciamentoPortfolioDto.getIdServicoNegocioAtual(),
						BusinessUserTipo.GRUPO_USUARIO.getIdentificador());
			}
		}
	}

	/**
	 * Mtodo para obter todos os usurios checados
	 *
	 * @author pedro.francisco
	 * @since 14.01.2016
	 */
	public void adicionaTabelaLOOKUP_SERVICO_BUSINESS_USER_VINCULAR_USUARIO(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		GerenciamentoPortfolioDTO gerenciamentoPortfolioDto = (GerenciamentoPortfolioDTO) document.getBean();

		if (gerenciamentoPortfolioDto != null && gerenciamentoPortfolioDto.getIdServicoNegocioAtual() != null) {
			GerenciamentoPortfolioBusinessUser gerenciamentoPortfolioBusinessUser = new GerenciamentoPortfolioBusinessUser();

			String checkboxChecadosComoTrue = gerenciamentoPortfolioDto.getColAllLOOKUP_SERVICO_BUSINESS_USER_VINCULAR_USUARIO();

			if (!checkboxChecadosComoTrue.isEmpty()) {
				gerenciamentoPortfolioBusinessUser.salvarItensChecados(document, request, checkboxChecadosComoTrue, gerenciamentoPortfolioDto.getIdServicoNegocioAtual(), BusinessUserTipo.USUARIO.getIdentificador());
			}
		}
	}

	/**
	 * Mtodo para vincular vrios donos de negcio (GRUPO) ao servio de negcio a partir
	 * da lookup com checkbox
	 *
	 * @author gilmar.junior
	 * @since 15.01.2015
	 */
	public void adicionaTabelaLOOKUP_GRUPO_VINCULAR_DONONEGOCIO(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		GerenciamentoPortfolioDTO gerenciamentoPortfolioDto = (GerenciamentoPortfolioDTO) document.getBean();

		if (gerenciamentoPortfolioDto != null && gerenciamentoPortfolioDto.getIdServicoNegocioAtual() != null
				&& gerenciamentoPortfolioDto.getColAllLOOKUP_GRUPO_VINCULAR_DONONEGOCIO() != null) {
			GerenciamentoPortfolioDonoNegocio donoNegocio = new GerenciamentoPortfolioDonoNegocio();

			String listaDonoNegocioGrupoStr = gerenciamentoPortfolioDto.getColAllLOOKUP_GRUPO_VINCULAR_DONONEGOCIO();
			Integer idServicoNegocioAtual = gerenciamentoPortfolioDto.getIdServicoNegocioAtual();

				donoNegocio.vincularDonoNegocioGrupo(document, request, response, listaDonoNegocioGrupoStr, idServicoNegocioAtual, DonoNegocioTipo.GRUPO.getIdentificador());
				document.executeScript("depoisVincularServicoDonoNegocioGrupo();");
			}
		}

	/**
	 * Mtodo para vincular vrios donos de negcio (EMPREGADO) ao servio de negcio a partir
	 * da lookup com checkbox
	 *
	 * @author gilmar.junior
	 * @since 19.01.2015
	 */
	public void adicionaTabelaLOOKUP_EMPREGADO_VINCULAR_DONONEGOCIO(DocumentHTML document, HttpServletRequest request, HttpServletResponse response) throws Exception {
		WebUtil.validarSeUsuarioEstaNaSessao(request, document);
		GerenciamentoPortfolioDTO gerenciamentoPortfolioDto = (GerenciamentoPortfolioDTO) document.getBean();

		if (gerenciamentoPortfolioDto != null && gerenciamentoPortfolioDto.getIdServicoNegocioAtual() != null
				&& gerenciamentoPortfolioDto.getColAllLOOKUP_EMPREGADO_VINCULAR_DONONEGOCIO() != null) {
			GerenciamentoPortfolioDonoNegocio donoNegocio = new GerenciamentoPortfolioDonoNegocio();

			String listaDonoNegocioEmpregadoStr = gerenciamentoPortfolioDto.getColAllLOOKUP_EMPREGADO_VINCULAR_DONONEGOCIO();
			Integer idServicoNegocioAtual = gerenciamentoPortfolioDto.getIdServicoNegocioAtual();

				donoNegocio.vincularDonoNegocioGrupo(document, request, response, listaDonoNegocioEmpregadoStr, idServicoNegocioAtual, DonoNegocioTipo.EMPREGADO.getIdentificador());
				document.executeScript("depoisVincularServicoDonoNegocioEmpregado();");
			}
		}

	public static void setPortalImages(DocumentHTML document) {
		Gson json = new Gson();
		document.executeScript("setImagePortalInWidget(" + json.toJson(UtilImagem.getPortalUrlImages()) + ");");
	}

	@Override
	public Class<GerenciamentoPortfolioDTO> getBeanClass() {
		return GerenciamentoPortfolioDTO.class;
	}
}
